# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (22,4,4,8,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        103 148
        88 169
        19 197
        206 103
        82 149
        65 24
        125 0
        96 166
        176 210
        211 173
        107 25
        184 75
        54 114
        136 191
        78 205
        89 189
        53 92
        39 51
        205 213
        99 6
        75 97
        125 12
        26 115
        144 14
        201 156
        32 2
        77 142
        133 104
        167 20
        39 2
        52 85
        183 213
        142 122
        195 90
        37 147
        123 10
        143 152
        100 199
        128 181
        18 74
        162 147
        3 151
        74 69
        145 29
        165 0
        18 193
        188 20
        203 31
        1 153
        23 76
        91 73
        88 109
        116 71
        100 183
        141 165
        23 35
        211 171
        206 75
        200 2
        52 72
        168 164
        63 67
        147 190
        55 11
        42 83
        176 198
        172 198
        196 177
        128 79
        56 150
        119 192
        66 209
        28 69
        5 183
        146 182
        26 60
        87 165
        1 95
        123 17
        4 156
        208 51
        137 148
        129 131
        72 21
        8 159
        87 12
        175 195
        57 39
        214 134
        82 46
        61 193
        59 87
        194 133
        64 180
        203 146
        1 22
        105 184
        37 210
        187 158
        62 150
        162 212
        163 210
        111 110
        22 21
        36 38
        158 157
        85 90
        99 181
        53 15
        77 65
        119 186
        197 28
        75 135
        64 35
        70 24
        67 69
        143 120
        47 57
        72 193
        105 189
        154 10
        180 36
        106 16
        195 51
        119 139
        210 43
        155 166
        162 43
        37 29
        89 199
        4 36
        130 196
        177 80
        42 182
        113 1
        138 3
        40 105
        116 82
        81 44
        13 16
        172 161
        41 26
        161 131
        12 191
        202 38
        23 139
        144 93
        201 92
        169 60
        160 103
        81 214
        3 96
        137 120
        86 121
        92 170
        178 208
        206 179
        175 52
        145 95
        126 90
        108 125
        72 187
        192 136
        154 61
        169 0
        68 215
        48 7
        215 43
        136 109
        24 167
        62 188
        9 20
        176 61
        80 107
        88 141
        181 205
        164 121
        150 171
        31 73
        50 148
        17 190
        174 81
        23 88
        14 60
        163 193
        15 46
        16 33
        32 95
        112 127
        101 144
        187 57
        207 93
        106 146
        175 28
        40 137
        45 140
        71 178
        13 86
        68 212
        58 79
        173 135
        195 157
        102 110
        128 56
        157 200
        214 97
        214 96
        41 124
        94 212
        155 120
        59 170
        129 106
        74 2
        105 173
        179 134
        76 87
        74 187
        48 158
        91 27
        14 9
        117 42
        40 118
        85 163
        19 53
        130 114
        208 69
        204 78
        22 90
        77 111
        123 176
        177 167
        129 86
        186 191
        62 205
        202 156
        66 78
        139 185
        152 73
        45 7
        158 208
        19 149
        49 126
        92 76
        206 159
        132 50
        93 124
        143 27
        8 97
        53 45
        185 169
        56 6
        113 68
        99 11
        52 67
        113 29
        186 25
        18 95
        60 191
        11 9
        79 213
        102 142
        49 51
        58 174
        98 29
        48 84
        82 47
        4 141
        13 147
        204 188
        133 34
        50 44
        202 15
        7 36
        190 121
        112 192
        162 182
        154 63
        49 67
        91 86
        61 22
        77 6
        159 83
        112 165
        192 35
        0 115
        154 126
        125 80
        104 164
        127 76
        107 54
        194 31
        41 54
        132 73
        64 141
        172 98
        135 155
        5 211
        197 178
        84 71
        10 215
        180 140
        151 79
        194 134
        127 15
        168 16
        168 17
        30 170
        68 33
        173 174
        55 54
        66 65
        48 47
        143 103
        5 102
        152 166
        30 109
        101 11
        6 188
        203 159
        100 78
        70 55
        201 140
        180 149
        108 196
        190 98
        118 183
        91 83
        3 174
        101 209
        179 44
        138 155
        102 151
        203 160
        108 186
        108 185
        204 111
        151 189
        153 215
        94 198
        119 115
        145 126
        113 198
        211 122
        5 138
        167 124
        201 35
        97 120
        199 65
        207 12
        32 49
        55 177
        152 134
        112 156
        104 160
        179 34
        117 131
        28 200
        178 45
        19 38
        56 122
        129 31
        118 89
        117 133
        85 153
        8 27
        209 124
        26 207
        93 80
        70 181
        84 200
        137 81
        197 47
        161 121
        153 63
        14 25
        130 25
        116 202
        132 160
        123 33
        171 213
        166 50
        58 122
        89 142
        32 21
        170 149
        161 182
        101 196
        139 207
        94 17
        144 185
        136 59
        199 150
        164 146
        46 7
        106 212
        10 98
        132 34
        184 148
        99 66
        204 114
        62 24
        21 157
        18 63
        175 57
        64 59
        70 111
        117 168
        94 131
        44 135
        41 9
        130 20
        138 40
        116 140
        172 43
        13 42
        171 189
        184 96
        209 114
        100 110
        71 39
        104 27
        4 30
        37 33
        83 34
        30 46
        127 109
        107 115
        8 194
        118 58
        84 38
        128 110
        145 163
        """

        self.waters = """
        0.71079 0.67158 0.3084
        0.62618 0.62383 0.65241
        0.58568 0.79284 0.55719
        0.75 0.75 0.0
        0.87618 0.75235 0.40479
        0.62383 0.99765 0.03372
        0.20951 0.79049 0.13265
        0.00235 0.62618 0.46628
        0.66667 0.33333 0.88222
        0.12254 0.87746 0.21103
        0.03921 0.32842 0.6916
        0.96079 0.67158 0.1916
        0.32842 0.28921 0.3084
        0.46079 0.92159 0.78408
        0.20587 0.79413 0.25
        0.33333 0.66667 0.43023
        0.33333 0.66667 0.76943
        0.91175 0.45588 0.75
        0.33333 0.66667 0.613
        0.37383 0.37617 0.46628
        0.32842 0.03921 0.1916
        0.87383 0.74765 0.59521
        0.79049 0.58099 0.63265
        0.00235 0.37618 0.34759
        0.37383 0.37617 0.15241
        0.45588 0.91175 0.25
        0.0 0.0 0.27433
        0.79049 0.20951 0.86735
        0.37618 0.37383 0.53372
        0.67158 0.96079 0.6916
        0.12618 0.87383 0.40479
        0.62618 0.62383 0.84759
        0.75235 0.87618 0.59521
        0.33333 0.66667 0.73057
        0.20716 0.79284 0.87213
        0.79284 0.20716 0.37213
        0.79284 0.58568 0.44281
        0.46079 0.92158 0.71593
        0.62383 0.62618 0.46628
        0.62618 0.00235 0.53372
        0.0 0.25 0.0
        0.0 0.0 0.22568
        0.28921 0.96079 0.8084
        0.24508 0.12254 0.71103
        0.20716 0.79284 0.94281
        0.00235 0.37618 0.46628
        0.20951 0.79049 0.44313
        0.25 0.0 0.5
        0.0 0.75 0.5
        0.87383 0.12618 0.59521
        0.33333 0.66667 0.92991
        0.79049 0.20951 0.55687
        0.25235 0.12618 0.59521
        0.20951 0.41902 0.44313
        0.75492 0.87746 0.21103
        0.71079 0.67158 0.1916
        0.12618 0.87383 0.09521
        0.37618 0.00235 0.53372
        0.00235 0.62617 0.03372
        0.41432 0.20716 0.37213
        0.12254 0.87746 0.28897
        0.99765 0.62382 0.65241
        0.41432 0.20716 0.12787
        0.20716 0.41432 0.62787
        0.66667 0.33333 0.387
        0.20951 0.41902 0.13265
        0.00235 0.37618 0.15241
        0.12383 0.24765 0.59521
        0.4608 0.53921 0.71593
        0.20716 0.41432 0.55719
        0.62383 0.62618 0.15241
        0.75 0.0 0.5
        0.12383 0.87618 0.59521
        0.58568 0.79284 0.87213
        0.33333 0.66667 0.57009
        0.41902 0.20951 0.94313
        0.20951 0.41902 0.36735
        0.33333 0.66667 0.11778
        0.79284 0.20716 0.12787
        0.79284 0.58568 0.05719
        0.45587 0.54412 0.25
        0.99765 0.62383 0.96628
        0.37383 0.99765 0.46628
        0.37618 0.00235 0.84759
        0.75 0.75 0.5
        0.41902 0.20951 0.63265
        0.67158 0.96079 0.8084
        0.37383 0.37617 0.34759
        0.00235 0.62618 0.34759
        0.20951 0.41902 0.05687
        0.66667 0.33334 0.61778
        0.62618 0.00235 0.84759
        0.12618 0.25235 0.40479
        0.20588 0.41175 0.25
        0.79413 0.58825 0.75
        0.58568 0.79284 0.62787
        0.62618 0.62383 0.96628
        0.66667 0.33333 0.93023
        0.87746 0.12254 0.71103
        0.00235 0.62618 0.15241
        0.87618 0.12383 0.09521
        0.92159 0.4608 0.21593
        0.58098 0.79049 0.05687
        0.12383 0.24765 0.90479
        0.99765 0.37383 0.84759
        0.25 0.25 0.0
        0.46079 0.53921 0.78408
        0.58826 0.79413 0.25
        0.66667 0.33334 0.26943
        0.20951 0.79049 0.36735
        0.74765 0.87383 0.09521
        0.58099 0.79049 0.13265
        0.58098 0.79049 0.36735
        0.67159 0.71079 0.6916
        0.7108 0.03921 0.1916
        0.75492 0.87746 0.28897
        0.62383 0.99765 0.46628
        0.03921 0.71079 0.8084
        0.00235 0.37617 0.03372
        0.71079 0.03921 0.3084
        0.79049 0.20951 0.94313
        0.87746 0.12254 0.78897
        0.20951 0.79049 0.05687
        0.07842 0.53921 0.71593
        0.12254 0.24508 0.21103
        0.53921 0.46079 0.28408
        0.79049 0.20951 0.63265
        0.33333 0.66667 0.38222
        0.87618 0.75235 0.09521
        0.67158 0.7108 0.8084
        0.53921 0.07842 0.21593
        0.87746 0.75492 0.78897
        0.33333 0.66667 0.887
        0.99765 0.62383 0.84759
        0.87383 0.74765 0.90479
        0.37618 0.00235 0.96628
        0.37383 0.99765 0.34759
        0.99765 0.37383 0.96628
        0.75 0.0 0.0
        0.96079 0.28921 0.3084
        0.79284 0.20716 0.44281
        0.79284 0.58568 0.37213
        0.33333 0.66667 0.06977
        0.87383 0.12618 0.90479
        0.08825 0.54413 0.25
        0.62618 0.00235 0.65241
        0.28921 0.32842 0.8084
        0.54412 0.08825 0.75
        0.20716 0.41432 0.94281
        0.41432 0.20716 0.44281
        0.24765 0.12383 0.09521
        0.62383 0.62618 0.03372
        0.75235 0.87618 0.90479
        0.37618 0.37383 0.65241
        0.99765 0.37382 0.65241
        0.62618 0.00235 0.96628
        0.74765 0.87383 0.40479
        0.79049 0.58099 0.55687
        0.99765 0.62382 0.53372
        0.41902 0.20951 0.86735
        0.20716 0.41432 0.87213
        0.0 0.0 0.77433
        0.41175 0.20587 0.75
        0.37618 0.00235 0.65241
        0.03921 0.32842 0.8084
        0.62383 0.62617 0.34759
        0.58568 0.79284 0.94281
        0.32842 0.28921 0.1916
        0.07842 0.53921 0.78408
        0.96079 0.67158 0.3084
        0.24765 0.12383 0.40479
        0.41432 0.20716 0.05719
        0.0 0.0 0.72568
        0.25 0.0 0.0
        0.0 0.75 0.0
        0.41902 0.20951 0.55687
        0.03921 0.71079 0.6916
        0.53921 0.46079 0.21593
        0.0 0.25 0.5
        0.12383 0.87618 0.90479
        0.66667 0.33333 0.42991
        0.79284 0.58568 0.12787
        0.24508 0.12254 0.78897
        0.79284 0.20716 0.05719
        0.37617 0.37383 0.96628
        0.92158 0.46079 0.28408
        0.53921 0.07842 0.28408
        0.20716 0.79284 0.55719
        0.37383 0.99765 0.15241
        0.37383 0.37618 0.03372
        0.79413 0.20588 0.75
        0.32842 0.03921 0.3084
        0.62383 0.99765 0.34759
        0.20716 0.79284 0.62787
        0.79049 0.58098 0.86735
        0.66667 0.33334 0.56977
        0.66667 0.33334 0.23057
        0.25 0.25 0.5
        0.87746 0.75492 0.71103
        0.12618 0.25235 0.09521
        0.62618 0.62383 0.53372
        0.87618 0.12383 0.40479
        0.58098 0.79049 0.44313
        0.37618 0.37383 0.84759
        0.62383 0.99765 0.15241
        0.66667 0.33334 0.113
        0.25235 0.12618 0.90479
        0.12254 0.24508 0.28897
        0.99765 0.37382 0.53372
        0.96079 0.28921 0.1916
        0.28921 0.96079 0.6916
        0.37383 0.99765 0.03372
        0.54413 0.45587 0.75
        0.66667 0.33333 0.07009
        0.79049 0.58098 0.94313
        0.28921 0.32842 0.6916
        """

        self.coord = "relative"

        self.cages = """
        12 -0.0094 -0.5047 -0.09324
        14 0.0 0.0 -0.04165
        12 -0.5047 -0.0094 -0.59324
        16 0.0 0.0 0.1527
        12 0.33333 0.66667 -0.17229
        12 0.5047 0.4953 0.59324
        12 0.0094 0.5047 -0.59324
        12 0.15683 -0.15684 0.75
        15 0.66667 0.33333 0.00064
        12 -0.15683 0.15684 0.25
        16 0.66667 0.33333 -0.19141
        16 -0.33333 -0.66667 0.69141
        12 0.31367 0.15683 0.25
        14 0.0 0.0 -0.54165
        12 -0.33333 -0.66667 -0.67229
        15 0.33333 0.66667 -0.00064
        12 -0.66667 -0.33333 0.67229
        15 -0.33333 -0.66667 -0.50064
        14 0.0 0.0 0.54165
        12 -0.4953 0.0094 0.59324
        16 -0.66667 -0.33333 -0.69141
        16 0.33333 0.66667 0.19141
        12 -0.31367 -0.15683 0.75
        12 -0.15684 -0.31367 0.25
        12 -0.5047 -0.4953 0.09324
        12 -0.0094 -0.5047 0.59324
        12 0.4953 -0.0094 0.09324
        12 0.66667 0.33333 0.17229
        16 0.0 0.0 -0.1527
        12 0.15683 0.31367 -0.25
        14 0.0 0.0 0.04165
        12 0.0094 0.5047 0.09324
        12 0.5047 0.0094 -0.09324
        16 0.0 0.0 0.6527
        12 -0.4953 -0.5047 -0.09324
        12 0.4953 0.5047 -0.59324
        16 0.0 0.0 -0.6527
        15 -0.66667 -0.33333 0.50064
        """

        self.bondlen = 3

        self.cell = """
        13.298468184769058 0.0 0.0
        -6.649234092384526 11.516811279429136 0.0
        4.3489773104049196e-15 7.532649662585564e-15 71.02418939783858
        """

        self.density = 0.5935336558921938

        self.cell = cellvectors(a=13.298468184769058,
                                b=13.298468184769058,
                                c=71.02418939783858,
                                C=119.99999999999999)
