# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (20,8,8,4,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        20 178
        221 107
        84 13
        32 190
        20 84
        94 211
        4 101
        46 164
        38 131
        80 171
        124 218
        129 196
        37 68
        121 93
        155 151
        223 160
        122 190
        118 200
        196 101
        167 50
        103 13
        70 119
        220 212
        33 83
        22 206
        50 41
        171 33
        48 130
        88 210
        90 214
        182 70
        25 31
        113 34
        98 158
        112 75
        32 24
        4 197
        60 41
        31 106
        74 150
        43 128
        200 127
        137 33
        0 71
        138 182
        37 203
        187 212
        194 44
        43 79
        207 9
        136 202
        184 172
        191 34
        10 97
        46 88
        208 19
        17 132
        3 88
        134 98
        92 127
        45 115
        181 82
        224 176
        193 156
        123 174
        135 21
        26 53
        69 189
        175 94
        76 110
        48 59
        20 27
        155 82
        223 169
        210 85
        73 201
        90 218
        57 93
        195 18
        145 73
        145 75
        4 126
        146 79
        8 177
        144 92
        128 122
        217 63
        197 151
        18 113
        222 82
        129 139
        224 104
        112 219
        45 143
        114 103
        116 217
        165 164
        70 211
        192 24
        8 28
        146 97
        163 53
        183 104
        131 64
        112 188
        170 113
        213 158
        48 149
        227 117
        78 101
        190 159
        1 6
        25 166
        154 67
        35 158
        22 198
        102 44
        47 71
        195 133
        225 40
        165 69
        227 209
        42 59
        58 81
        121 152
        21 80
        17 125
        60 79
        153 27
        126 132
        115 95
        91 109
        215 178
        166 189
        186 142
        78 103
        29 91
        44 12
        147 104
        170 106
        17 74
        37 146
        166 160
        115 9
        7 132
        202 212
        53 63
        66 57
        7 56
        65 36
        122 34
        215 73
        141 147
        123 178
        160 193
        143 108
        192 96
        173 114
        36 74
        60 118
        195 28
        147 162
        23 190
        180 15
        136 87
        159 110
        194 152
        227 10
        137 105
        164 12
        5 119
        150 108
        101 109
        169 86
        89 167
        61 185
        179 209
        191 148
        69 213
        99 75
        169 156
        122 111
        26 149
        69 225
        222 109
        100 13
        58 11
        131 59
        26 200
        112 108
        157 95
        32 63
        40 194
        167 3
        220 151
        21 201
        138 105
        71 96
        31 18
        105 133
        161 35
        221 182
        124 56
        111 148
        36 126
        121 216
        201 162
        65 108
        206 83
        144 111
        180 54
        6 225
        3 118
        22 175
        198 185
        172 83
        77 99
        0 197
        182 184
        223 159
        95 55
        28 67
        186 152
        206 97
        65 61
        140 6
        205 219
        226 175
        18 193
        163 116
        65 90
        54 161
        107 10
        206 203
        213 77
        47 175
        204 161
        207 77
        19 87
        144 26
        37 24
        107 50
        214 126
        111 63
        38 130
        200 194
        207 165
        14 218
        173 99
        141 119
        38 168
        227 88
        39 11
        176 156
        137 117
        7 13
        29 5
        141 188
        123 114
        187 174
        30 14
        1 134
        32 67
        39 116
        125 174
        48 204
        72 183
        20 205
        119 181
        25 133
        191 189
        110 86
        168 150
        162 139
        224 105
        226 172
        205 55
        123 153
        91 103
        140 49
        57 120
        137 184
        210 142
        42 39
        62 86
        153 11
        47 4
        218 143
        47 87
        171 224
        107 179
        129 222
        1 213
        104 181
        2 215
        154 113
        170 98
        135 14
        208 110
        79 127
        179 193
        120 75
        145 114
        128 154
        161 148
        52 186
        66 102
        51 136
        138 181
        180 27
        211 61
        177 19
        68 67
        52 216
        117 167
        29 188
        203 51
        128 92
        53 85
        60 192
        2 188
        106 189
        21 70
        90 198
        28 159
        160 34
        96 203
        91 199
        3 40
        49 134
        66 168
        43 68
        221 156
        129 62
        78 174
        140 46
        220 139
        80 147
        204 11
        163 16
        42 81
        141 61
        149 44
        131 7
        191 158
        64 81
        30 120
        124 125
        93 95
        214 56
        84 54
        72 62
        209 31
        17 38
        120 150
        197 202
        187 56
        199 100
        25 117
        52 12
        102 130
        222 5
        116 92
        30 157
        58 130
        201 5
        22 136
        226 41
        2 162
        64 45
        202 214
        72 176
        153 35
        118 85
        207 55
        42 16
        223 133
        179 89
        41 97
        142 127
        196 87
        0 51
        66 9
        46 186
        24 85
        83 185
        23 208
        14 74
        163 142
        0 76
        27 98
        64 124
        135 94
        151 109
        8 72
        166 89
        208 71
        121 102
        51 177
        155 76
        80 185
        155 183
        149 16
        15 148
        168 45
        157 143
        226 96
        173 84
        82 86
        196 212
        134 55
        170 15
        146 210
        144 204
        195 176
        187 100
        135 198
        183 139
        165 49
        30 73
        220 199
        33 10
        211 172
        78 132
        8 76
        221 171
        106 49
        36 94
        23 192
        217 15
        1 93
        184 50
        99 205
        9 12
        39 180
        215 219
        2 199
        57 77
        81 216
        23 43
        40 164
        152 6
        59 54
        140 209
        138 169
        68 177
        145 29
        115 216
        154 217
        52 16
        173 35
        89 225
        19 62
        157 219
        58 125
        178 100
        """

        self.waters = """
        0.5 0.72011 0.96045
        0.0 0.24056 0.47564
        0.30445 0.92137 0.6061
        0.625 0.44542 0.28587
        0.69393 0.83389 0.00212
        0.82055 0.85174 0.59086
        0.0 0.32611 0.40138
        0.5 0.02111 0.96573
        0.30608 0.63501 0.82127
        0.5 0.18555 0.32376
        0.18235 0.56886 0.32696
        0.0 0.18625 0.92282
        0.5 0.25461 0.26878
        0.5 0.02944 0.84073
        0.0 0.94516 0.27757
        0.375 0.30681 0.77616
        0.375 0.26492 0.08631
        0.82055 0.01031 0.08942
        0.18235 0.47263 0.64819
        0.0 0.67389 0.90138
        0.30445 0.11062 0.69533
        0.0 0.81376 0.42282
        0.125 0.75255 0.15195
        0.81765 0.55904 0.95203
        0.5 0.51549 0.04444
        0.5 0.48452 0.54444
        0.69265 0.33571 0.05068
        0.17945 0.18102 0.7321
        0.375 0.55458 0.78587
        0.69555 0.92137 0.6061
        0.0 0.99989 0.40257
        0.30735 0.4358 0.56472
        0.5 0.48098 0.91944
        0.30735 0.63743 0.36333
        0.875 0.40894 0.72225
        0.82055 0.18102 0.7321
        0.69555 0.88939 0.19533
        0.30735 0.56421 0.06472
        0.69555 0.07863 0.1061
        0.17945 0.23165 0.92844
        0.69393 0.36499 0.32127
        0.875 0.59106 0.22225
        0.30445 0.19804 0.01501
        0.0 0.52103 0.96581
        0.69393 0.25824 0.19804
        0.375 0.07646 0.23239
        0.30608 0.36499 0.32127
        0.81893 0.76529 0.04568
        0.69555 0.19804 0.01501
        0.30608 0.3076 0.51295
        0.81765 0.56886 0.32696
        0.30608 0.6924 0.01295
        0.30608 0.25824 0.19804
        0.5 0.38199 0.02864
        0.5 0.1707 0.84559
        0.30608 0.16611 0.50212
        0.30445 0.97064 0.00924
        0.81893 0.12886 0.39621
        0.0 0.13041 0.03067
        0.5 0.15568 0.9684
        0.81765 0.52738 0.14819
        0.5 0.8293 0.34559
        0.0 0.69797 0.77814
        0.5 0.39974 0.91427
        0.30445 0.07863 0.1061
        0.5 0.89364 0.27682
        0.69393 0.14246 0.28789
        0.30735 0.50632 0.86412
        0.18235 0.55904 0.95203
        0.69393 0.3076 0.51295
        0.82055 0.76835 0.42844
        0.69393 0.6924 0.01295
        0.18108 0.6698 0.7321
        0.0 0.96242 0.52757
        0.82055 0.9641 0.21442
        0.69555 0.02936 0.50924
        0.5 0.6861 0.84437
        0.69393 0.16611 0.50212
        0.82055 0.95607 0.90386
        0.0 0.49686 0.09081
        0.17945 0.76835 0.42844
        0.17945 0.14826 0.09086
        0.69393 0.74176 0.69804
        0.375 0.69319 0.27616
        0.5 0.10636 0.77682
        0.5 0.45573 0.10496
        0.81893 0.6698 0.7321
        0.0 0.75945 0.97564
        0.375 0.44542 0.28587
        0.81765 0.44097 0.45203
        0.30445 0.88939 0.19533
        0.625 0.92354 0.73239
        0.0 0.36352 0.97194
        0.0 0.16975 0.38727
        0.82055 0.81898 0.2321
        0.18108 0.12886 0.39621
        0.625 0.64648 0.10255
        0.125 0.59106 0.22225
        0.125 0.24746 0.65195
        0.625 0.10845 0.57162
        0.30445 0.9876 0.7972
        0.81893 0.87114 0.89621
        0.81893 0.18698 0.20821
        0.69555 0.9876 0.7972
        0.375 0.73508 0.58631
        0.5 0.61801 0.52864
        0.375 0.35352 0.60255
        0.0 0.56486 0.39458
        0.5 0.97056 0.34073
        0.69393 0.85755 0.78789
        0.69393 0.63501 0.82127
        0.69265 0.36257 0.86333
        0.5 0.97889 0.46573
        0.125 0.40894 0.72225
        0.82055 0.0359 0.71442
        0.30608 0.14246 0.28789
        0.18235 0.32029 0.953
        0.5 0.51903 0.41944
        0.69265 0.45691 0.17465
        0.69555 0.80197 0.51501
        0.82055 0.04393 0.40386
        0.0 0.20785 0.26537
        0.81765 0.43115 0.82696
        0.0 0.05484 0.77757
        0.17945 0.01031 0.08942
        0.0 0.03758 0.02757
        0.625 0.89155 0.07162
        0.0 0.40186 0.09257
        0.0 0.43514 0.89458
        0.0 0.79215 0.76537
        0.82055 0.14826 0.09086
        0.5 0.083 0.02462
        0.69555 0.97064 0.00924
        0.5 0.54427 0.60496
        0.18108 0.23471 0.54568
        0.0 0.85186 0.29472
        0.18108 0.76529 0.04568
        0.5 0.60026 0.41427
        0.69265 0.66429 0.55068
        0.18108 0.81302 0.70821
        0.18108 0.36454 0.41982
        0.5 0.84432 0.4684
        0.18235 0.38011 0.13931
        0.30445 0.0124 0.2972
        0.81765 0.32029 0.953
        0.82055 0.98969 0.58942
        0.18235 0.52738 0.14819
        0.30445 0.80197 0.51501
        0.625 0.30681 0.77616
        0.625 0.26492 0.08631
        0.69555 0.0124 0.2972
        0.5 0.81445 0.82376
        0.0 0.30203 0.27814
        0.0 0.14815 0.79472
        0.18235 0.43115 0.82696
        0.5 0.7454 0.76878
        0.0 0.59814 0.59257
        0.17945 0.04393 0.40386
        0.875 0.24746 0.65195
        0.625 0.55458 0.78587
        0.81765 0.47263 0.64819
        0.69555 0.22217 0.81921
        0.17945 0.85174 0.59086
        0.30735 0.33571 0.05068
        0.5 0.3139 0.34437
        0.5 0.27989 0.46045
        0.69265 0.4358 0.56472
        0.69265 0.49368 0.36412
        0.625 0.07646 0.23239
        0.81765 0.61989 0.63931
        0.25 0.32784 0.69038
        0.18235 0.67971 0.453
        0.625 0.69319 0.27616
        0.69555 0.11062 0.69533
        0.0 0.00012 0.90257
        0.875 0.75255 0.15195
        0.18235 0.61989 0.63931
        0.18108 0.63547 0.91982
        0.17945 0.0359 0.71442
        0.0 0.47897 0.46581
        0.30445 0.22217 0.81921
        0.625 0.73508 0.58631
        0.81765 0.67971 0.453
        0.30608 0.74176 0.69804
        0.69265 0.63743 0.36333
        0.30445 0.77783 0.31921
        0.18108 0.3302 0.2321
        0.17945 0.95607 0.90386
        0.5 0.917 0.52462
        0.625 0.35352 0.60255
        0.69265 0.50632 0.86412
        0.75 0.32784 0.69038
        0.69265 0.56421 0.06472
        0.0 0.50314 0.59081
        0.81893 0.3302 0.2321
        0.30735 0.5431 0.67465
        0.0 0.83025 0.88727
        0.5 0.79943 0.95096
        0.17945 0.81898 0.2321
        0.375 0.92354 0.73239
        0.81765 0.38011 0.13931
        0.0 0.8696 0.53067
        0.30608 0.83389 0.00212
        0.375 0.64648 0.10255
        0.82055 0.23165 0.92844
        0.375 0.10845 0.57162
        0.25 0.67216 0.19038
        0.5 0.20058 0.45096
        0.81893 0.63547 0.91982
        0.18235 0.44097 0.45203
        0.30735 0.45691 0.17465
        0.69555 0.77783 0.31921
        0.18108 0.87114 0.89621
        0.81893 0.23471 0.54568
        0.375 0.89155 0.07162
        0.17945 0.98969 0.58942
        0.18108 0.18698 0.20821
        0.30735 0.36257 0.86333
        0.17945 0.9641 0.21442
        0.30445 0.02936 0.50924
        0.30608 0.85755 0.78789
        0.0 0.63648 0.47194
        0.81893 0.81302 0.70821
        0.69265 0.5431 0.67465
        0.30735 0.66429 0.55068
        0.81893 0.36454 0.41982
        0.75 0.67216 0.19038
        0.30735 0.49368 0.36412
        """

        self.coord = "relative"

        self.cages = """
        12 0.2294 -0.44697 0.50083
        14 0.0 -0.70171 0.79707
        12 0.5 0.35997 0.18781
        15 0.5 0.22393 0.65212
        12 0.5 0.40102 0.44572
        14 0.21781 0.09242 0.90259
        14 -0.21781 -0.09242 1.40259
        12 -0.2243 -0.24731 0.87198
        16 0.0 -0.10945 1.07663
        16 0.0 0.10945 0.57663
        12 -0.5 -0.72596 0.92507
        12 0.2294 0.44697 0.00083
        15 0.0 0.07493 0.22848
        12 -0.2294 -0.44697 0.50083
        14 -0.21781 0.09242 1.90259
        12 0.2243 -0.24731 0.87198
        12 -0.2294 0.44697 1.00083
        15 0.0 -0.26185 0.58902
        12 -0.5 -0.35997 0.68781
        15 -0.5 -0.56902 0.73036
        15 -0.5 -0.22393 1.15212
        12 0.5 0.08375 0.40775
        12 0.5 0.72596 0.42507
        12 0.5 0.01666 0.64997
        15 0.0 0.26185 0.08902
        16 0.0 0.45166 0.27958
        14 0.0 0.64185 0.08198
        12 0.5 0.16383 0.14334
        12 0.2243 0.24731 0.37198
        12 -0.5 -0.40102 0.94572
        15 0.0 -0.07493 0.72848
        14 0.0 0.70171 0.29707
        12 -0.5 -0.01666 1.14997
        12 -0.5 -0.08375 0.90775
        15 0.5 0.56902 0.23036
        14 0.21781 -0.09242 1.40259
        12 -0.2243 0.24731 1.37198
        16 0.0 -0.45166 0.77958
        12 -0.5 -0.16383 0.64334
        14 0.0 -0.64185 0.58198
        """

        self.bondlen = 3

        self.cell = """
        14.534225051590713 37.63202891189917 26.446761948044973
        """

        self.density = 0.4711341450362165

        self.cell = cellvectors(a=14.534225051590713,
                                b=37.63202891189917,
                                c=26.446761948044973)
