from genice2.cell import cellvectors
import genice2.lattices
import numpy as np
desc = {
    "ref": {
        "115_2_114": "Engel 2018"
    },
    "usage": "No options available.",
    "brief": "Hypothetical zeolitic ice"
}


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.cell = cellvectors(
            a=29.57133,
            b=29.57133,
            c=16.68224,
            A=90.0,
            B=90.0,
            C=90.0
        )
        self.waters = np.array([
            [0.085323, 0.085326, -0.004377],
            [0.414158, 0.414702, -0.004459],
            [0.164677, 0.335322, 0.254374],
            [0.335321, 0.164636, 0.254454],
            [0.159043, 0.159036, 0.245801],
            [0.340952, 0.340935, 0.245775],
            [0.408991, 0.090993, 0.004191],
            [0.090965, 0.409041, 0.004215],
            [0.585283, 0.085792, -0.004494],
            [-0.085281, 0.414679, -0.004396],
            [0.664329, 0.335667, 0.246407],
            [-0.164692, 0.164690, 0.254395],
            [0.659057, 0.159082, 0.245564],
            [-0.159075, 0.340955, 0.245589],
            [-0.090961, 0.090966, 0.004221],
            [0.588901, 0.411101, -0.000063],
            [0.085317, 0.585317, -0.004342],
            [0.413837, -0.085569, -0.003361],
            [0.164680, -0.164708, 0.254498],
            [0.335293, 0.664674, 0.254549],
            [0.159053, 0.659051, 0.245770],
            [0.341209, -0.158798, 0.253618],
            [0.409011, 0.591001, 0.004238],
            [0.090973, -0.090952, 0.004229],
            [0.585297, 0.585797, -0.004501],
            [-0.085272, -0.085318, -0.004373],
            [0.664292, -0.164329, 0.246427],
            [-0.164685, 0.664688, 0.254390],
            [0.659061, 0.659074, 0.245558],
            [-0.159073, -0.159048, 0.245613],
            [-0.090958, 0.590958, 0.004232],
            [0.588871, -0.088890, -0.000097],
            [0.085326, 0.085328, 0.495617],
            [0.414682, 0.414696, 0.495650],
            [0.164669, 0.335325, -0.245623],
            [0.335307, 0.164736, 0.754317],
            [0.159040, 0.159038, -0.254226],
            [0.340925, 0.340945, -0.254205],
            [0.409038, 0.090921, 0.504438],
            [0.090954, 0.409045, 0.504182],
            [0.585303, 0.085371, 0.495631],
            [-0.085376, 0.414669, 0.495639],
            [0.664610, 0.335398, -0.245983],
            [-0.164677, 0.164677, 0.754377],
            [0.659057, 0.159109, -0.254149],
            [-0.159074, 0.340962, -0.254163],
            [-0.090959, 0.090965, 0.504194],
            [0.591221, 0.408788, 0.503104],
            [0.085318, 0.585327, 0.495578],
            [0.414591, -0.085381, 0.504289],
            [0.164165, -0.164715, -0.245557],
            [0.335284, 0.664167, 0.754419],
            [0.158986, 0.658986, -0.254226],
            [0.338859, -0.161092, -0.249724],
            [0.409065, 0.590917, 0.504257],
            [0.090916, -0.090931, 0.504204],
            [0.585303, 0.585368, 0.495647],
            [-0.085385, -0.085328, 0.495652],
            [0.664657, -0.164610, -0.246004],
            [-0.164674, 0.664674, 0.754383],
            [0.659057, 0.659111, -0.254162],
            [-0.159065, -0.159031, -0.254151],
            [-0.090959, 0.590954, 0.504190],
            [0.591181, -0.091217, 0.503396],
        ])
        self.coord = 'relative'
