# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['easyphysics']

package_data = \
{'': ['*']}

install_requires = \
['altair>=4.2.0,<5.0.0', 'matplotlib>=3.6.3,<4.0.0']

setup_kwargs = {
    'name': 'easyphysics',
    'version': '0.1.0',
    'description': 'A package with useful physics formulas to make physics easy and fun for users!',
    'long_description': '# easyphysics\n\nA package with useful physics formulas to make physics easy and fun for users! It uses four functions to easily calculate four classic physics theories. By making the functions concise and supporting graphs to demonstrate the theories, physics beginners might find learning physics fun and not daunting! All functions in this package require only arguments in numeric format; no dataset files are needed. `easyphysics` can also generate easy-to-understand visualizations to further reveal the physics effects.  \n\n## Installation\n\n```bash\n$ pip install easyphysics\n```\n\n## Usage\n\nThe package has four functions which can provide solutions for Physics Equations. Input will be taken from the User and the solutions will be provided by the functions. The four functions are as follows: \n\n\n- `freefall()` calculates the time it takes for a falling object using the equation of motion height = 1/2*gt^2, given the height and gravity of the free fall. It returns the time it takes for the free fall, and a plot compares the time of the free fall on different planets with a list. The distance traveled by the falling object (height) and the acceleration of gravity (g, default = 9.8) are the function’s arguments. \n- `gravitational_energy()` calculates the energy possessed or acquired by an object due to a change in its position when it is present in a gravitational field  = m*g*h\n- `kinetic_energy()` calculates the Kinetic Energy of an object. When work is done on an object, energy is transferred, and the object moves with a new constant speed. We call the energy that is transferred kinetic energy, and it depends on the mass and speed achieved. The kinetic energy equation is given as: KE = 1/2*m*v^2, Where KE is the kinetic energy, m is the body’s mass, and v is the body’s velocity.\n- `static_friction_ground()` calculates the friction force for static object. The formula is fr = mu * N, where \n    the mu is the coefficient of friction which incorporating the characteristics of the surface.\n\n```python\nfrom easyphysics.freefall import freefall\ntime, plot = freefall(height, g = 9.8)\ntime, plot = freefall(10, g = 15)\n\n```\n\n```python\nfrom easyphysics.kinetic_energy import kinetic_energy\nKE = kinetic_energy(mass, velocity)\nKE = kinetic_energy(0.6, 3)\n\n```\n\n```python\nfrom easyphysics.gravitational_energy import gravitational_energy\ngravitational_energy(m,h, g = 9.80665)\nge = gravitational_energy(10, 1000, g = 9.8)\n\n```\n\n```python\nfrom easyphysics.static_friction import static_friction_ground\nfrom easyphysics.static_friction import plot_frict\nstatic_friction_ground(mu, m, g = 9.8)\nforce = static_friction_ground(0.2, 2)\nplot_frict(0.2,2,9.8)\n\n```\n## Fitting into the Python ecosystem\n\nA similar well-known package [sympy](https://github.com/sympy/sympy) is available, which has a [module in physics](https://docs.sympy.org/latest/reference/public/physics/index.html).`sympy` is a library for symbolic computation. The physics module focuses on solving advanced physics problems such as Hydrogen Wavefunction and Quantum physics.\n\n`easyphysics` targets physics beginners rather than professionals, such as middle schoolers and people new to physics. It uses four functions to easily calculate four classic physics theories. By making the functions concise and supporting graphs to demonstrate the theories, physics beginners might find learning physics fun and not daunting! All functions in this package require only arguments in numeric format; no dataset files are needed.  `easyphysics` can also generate easy-to-understand visualizations to further reveal the physics effects.  The specific functions and visual components make  `easyphysics` different from other packages.\n\n## Contributing\n\n`easyphysics` was created by Revathy Ponnambalam, Nikita Susan Easow, Yaou Hu and Mengjun Chen.\nInterested in contributing? Check out the [contributing guidelines](CONTRIBUTING.md). Please note that this project is released with a [Code of Conduct](CONDUCT.md). By contributing to this project, you agree to abide by its terms.\n\n## License\n\n`easyphysics` was created by Revathy Ponnambalam, Nikita Susan Easow, Yaou Hu and Mengjun Chen. It is licensed under the terms of the MIT license.\n\n## Credits\n\n`easyphysics` was created with [`cookiecutter`](https://cookiecutter.readthedocs.io/en/latest/) and the `py-pkgs-cookiecutter` [template](https://github.com/py-pkgs/py-pkgs-cookiecutter).\n',
    'author': 'Group 16',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
