# 产品介绍

本仓库中包含两个产品：腾讯云物联网通信（IoT Hub） 和 腾讯云物联网开发平台（IoT Explorer） ，本仓库提供 Python 接入方式 。

## 腾讯云物联网通信（IoT Hub）Python SDK

腾讯云物联网通信（Internet of Things Hub， IoT Hub）旨在提供一个安全、稳定、高效的连接平台，帮助开发者低成本、快速地实现“设备-设备”、“设备-用户应用”、“设备-云服务”之间可靠、高并发的数据通信。不仅可以实现设备之间的互动、设备的数据上报和配置下发，还可以基于规则引擎打通设备与腾讯云产品间的通路，方便快捷地实现海量设备数据的存储、计算以及智能分析。详细介绍请参考官网 [物联网通信](https://cloud.tencent.com/document/product/634) 。

该仓库提供了 IoT Hub 设备端SDK，设备厂商可以通过 SDK 集成到 Python 环境设备上，将设备安全的接入到腾讯云物联网通信平台。

* [腾讯云物联网通信（IoT Hub）设备端 Python-SDK](hub/)


## 腾讯云物联网开发平台（IoT Explorer）Python SDK

腾讯云物联网开发平台（Internet of Things Explorer， IoT Explorer）为各行业的设备制造商、方案商及应用开发商提供一站式设备智能化服务。平台提供海量设备连接与管理能力及小程序应用开发能力，并打通腾讯云基础产品及 AI 能力，提升传统行业设备智能化的效率，降低用户的开发运维成本，助力用户业务发展。详细介绍请参考官网 [物联网开发平台](https://cloud.tencent.com/document/product/1081) 。

该仓库提供了 IoT Explorer 设备端SDK，用户可以通过SDK，由 python 语言开发设备接入驱动，或者集成到 python 环境设备上，将设备安全的接入到腾讯云物联网开发平台。

* [腾讯云物联网开发平台（IoT Explorer）设备端 Python-SDK](explorer/)


## SDK涉及到的域名

两个产品对应SDK涉及到的域名请参考 [Device SDK涉及的域名](https://github.com/tencentyun/iot-device-java/wiki/Device-SDK涉及的域名)
