import { Template } from 'cloudform-types';
import { Diff as DeepDiff } from 'deep-diff';
declare type Diff = DeepDiff<DiffableProject, DiffableProject>;
export declare type DiffRule = (diff: Diff, currentBuild: DiffableProject, nextBuild: DiffableProject) => void;
export declare type ProjectRule = (diffs: Diff[], currentBuild: DiffableProject, nextBuild: DiffableProject) => void;
interface DiffableProject {
    stacks: {
        [stackName: string]: Template;
    };
    root: Template;
}
export declare const sanityCheckProject: (currentCloudBackendDir: string, buildDirectory: string, rootStackName: string, diffRules: DiffRule[], projectRule: ProjectRule[]) => Promise<void>;
export declare const sanityCheckDiffs: (diffs: Diff[], current: DiffableProject, next: DiffableProject, diffRules: DiffRule[], projectRules?: ProjectRule[]) => void;
export declare const cantEditKeySchemaRule: (diff: Diff) => void;
export declare const cantAddLSILaterRule: (diff: Diff) => void;
export declare const cantEditGSIKeySchemaRule: (diff: Diff, currentBuild: DiffableProject, nextBuild: DiffableProject) => void;
export declare const cantAddAndRemoveGSIAtSameTimeRule: (diff: Diff, currentBuild: DiffableProject, nextBuild: DiffableProject) => void;
export declare const cantBatchMutateGSIAtUpdateTimeRule: (diff: Diff, currentBuild: DiffableProject, nextBuild: DiffableProject) => void;
export declare const cantMutateMultipleGSIAtUpdateTimeRule: (diffs: Diff[], currentBuild: DiffableProject, nextBuild: DiffableProject) => void;
export declare const cantEditLSIKeySchemaRule: (diff: Diff, currentBuild: DiffableProject, nextBuild: DiffableProject) => void;
export declare const cantHaveMoreThan500ResourcesRule: (diffs: Diff[], currentBuild: DiffableProject, nextBuild: DiffableProject) => void;
export {};
//# sourceMappingURL=sanity-check.d.ts.map