"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.pathManager = exports.PathManager = exports.PathConstants = void 0;
const path = __importStar(require("path"));
const fs = __importStar(require("fs-extra"));
const os_1 = require("os");
exports.PathConstants = {
    DotAWSDirName: '.aws',
    AWSCredentials: 'credentials',
    AWSConfig: 'config',
    DeploymentSecretsFileName: 'deployment-secrets.json',
    AmplifyAdminDirName: 'admin',
    AmplifyDirName: 'amplify',
    DotAmplifyDirName: '.amplify',
    DotConfigDirName: '.config',
    BackendDirName: 'backend',
    CurrentCloudBackendDirName: '#current-cloud-backend',
    AmplifyAdminConfigFileName: 'config.json',
    AmplifyRcFileName: '.amplifyrc',
    GitIgnoreFileName: '.gitignore',
    ProjectConfigFileName: 'project-config.json',
    AmplifyMetaFileName: 'amplify-meta.json',
    TagsFileName: 'tags.json',
    ParametersJsonFileName: 'parameters.json',
    LocalEnvFileName: 'local-env-info.json',
    LocalAWSInfoFileName: 'local-aws-info.json',
    TeamProviderInfoFileName: 'team-provider-info.json',
    BackendConfigFileName: 'backend-config.json',
    CLIJSONFileName: 'cli.json',
    CLIJSONFileNameGlob: 'cli*.json',
    CLIJsonWithEnvironmentFileName: (env) => `cli.${env}.json`,
};
class PathManager {
    constructor() {
        this.getAmplifyPackageLibDirPath = (packageName) => {
            const result = path.join(this.getAmplifyLibRoot(), packageName);
            if (!process.env.AMPLIFY_SUPPRESS_NO_PKG_LIB && !fs.pathExistsSync(result)) {
                throw new Error(`Package lib at ${result} does not exist.`);
            }
            return result;
        };
        this.getAmplifyLibRoot = () => path.join(this.getHomeDotAmplifyDirPath(), 'lib');
        this.getHomeDotAmplifyDirPath = () => this.homeDotAmplifyDirPath;
        this.getAmplifyAdminDirPath = () => this.constructPath(this.getHomeDotAmplifyDirPath(), [exports.PathConstants.AmplifyAdminDirName]);
        this.getAmplifyAdminConfigFilePath = () => this.constructPath(this.getAmplifyAdminDirPath(), [exports.PathConstants.AmplifyAdminConfigFileName]);
        this.getAmplifyDirPath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName]);
        this.getDotConfigDirPath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, exports.PathConstants.DotConfigDirName]);
        this.getBackendDirPath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, exports.PathConstants.BackendDirName]);
        this.getCurrentCloudBackendDirPath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, exports.PathConstants.CurrentCloudBackendDirName]);
        this.getAmplifyRcFilePath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyRcFileName]);
        this.getGitIgnoreFilePath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.GitIgnoreFileName]);
        this.getTeamProviderInfoFilePath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, exports.PathConstants.TeamProviderInfoFileName]);
        this.getProjectConfigFilePath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, exports.PathConstants.DotConfigDirName, exports.PathConstants.ProjectConfigFileName]);
        this.getLocalEnvFilePath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, exports.PathConstants.DotConfigDirName, exports.PathConstants.LocalEnvFileName]);
        this.getLocalAWSInfoFilePath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, exports.PathConstants.DotConfigDirName, exports.PathConstants.LocalAWSInfoFileName]);
        this.getAmplifyMetaFilePath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, exports.PathConstants.BackendDirName, exports.PathConstants.AmplifyMetaFileName]);
        this.getBackendConfigFilePath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, exports.PathConstants.BackendDirName, exports.PathConstants.BackendConfigFileName]);
        this.getTagFilePath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, exports.PathConstants.BackendDirName, exports.PathConstants.TagsFileName]);
        this.getCurrentTagFilePath = (projectPath) => this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, exports.PathConstants.CurrentCloudBackendDirName, exports.PathConstants.TagsFileName]);
        this.getResourceParamatersFilePath = (projectPath, category, resourceName) => this.constructPath(projectPath, [
            exports.PathConstants.AmplifyDirName,
            exports.PathConstants.BackendDirName,
            category,
            resourceName,
            exports.PathConstants.ParametersJsonFileName,
        ]);
        this.getCurrentAmplifyMetaFilePath = (projectPath) => this.constructPath(projectPath, [
            exports.PathConstants.AmplifyDirName,
            exports.PathConstants.CurrentCloudBackendDirName,
            exports.PathConstants.AmplifyMetaFileName,
        ]);
        this.getCurrentBackendConfigFilePath = (projectPath) => this.constructPath(projectPath, [
            exports.PathConstants.AmplifyDirName,
            exports.PathConstants.CurrentCloudBackendDirName,
            exports.PathConstants.BackendConfigFileName,
        ]);
        this.getDotAWSDirPath = () => path.normalize(path.join(os_1.homedir(), exports.PathConstants.DotAWSDirName));
        this.getAWSCredentialsFilePath = () => path.normalize(path.join(this.getDotAWSDirPath(), exports.PathConstants.AWSCredentials));
        this.getAWSConfigFilePath = () => path.normalize(path.join(this.getDotAWSDirPath(), exports.PathConstants.AWSConfig));
        this.getCLIJSONFilePath = (projectPath, env) => {
            const fileName = env === undefined ? exports.PathConstants.CLIJSONFileName : exports.PathConstants.CLIJsonWithEnvironmentFileName(env);
            return this.constructPath(projectPath, [exports.PathConstants.AmplifyDirName, fileName]);
        };
        this.getDotAWSAmplifyDirPath = () => path.normalize(path.join(os_1.homedir(), exports.PathConstants.DotAWSDirName, exports.PathConstants.AmplifyDirName));
        this.getDeploymentSecrets = () => path.normalize(path.join(this.getDotAWSAmplifyDirPath(), exports.PathConstants.DeploymentSecretsFileName));
        this.constructPath = (projectPath, segments = []) => {
            if (!projectPath) {
                projectPath = this.findProjectRoot();
            }
            if (projectPath) {
                return path.normalize(path.join(projectPath, ...segments));
            }
            throw this.createNotInitializedError();
        };
        this.validateProjectPath = (projectPath) => {
            if (fs.existsSync(projectPath)) {
                const amplifyDirPath = this.getAmplifyDirPath(projectPath);
                const dotConfigDirPath = this.getDotConfigDirPath(projectPath);
                return fs.existsSync(amplifyDirPath) && fs.existsSync(dotConfigDirPath);
            }
            return false;
        };
        this.findProjectRoot = () => {
            let currentPath = process.cwd();
            while (true) {
                if (this.validateProjectPath(currentPath)) {
                    return currentPath;
                }
                const parentPath = path.dirname(currentPath);
                if (currentPath === parentPath) {
                    break;
                }
                currentPath = parentPath;
            }
            return undefined;
        };
        this.createNotInitializedError = () => {
            const error = new Error("You are not working inside a valid Amplify project.\nUse 'amplify init' in the root of your app directory to initialize your project, or 'amplify pull' to pull down an existing project.");
            error.name = 'NotInitialized';
            error.stack = undefined;
            return error;
        };
        this.homeDotAmplifyDirPath = path.join(os_1.homedir(), exports.PathConstants.DotAmplifyDirName);
    }
}
exports.PathManager = PathManager;
exports.pathManager = new PathManager();
//# sourceMappingURL=pathManager.js.map