import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export interface CfnScalingPlanProps {
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource
     */
    readonly applicationSource: CfnScalingPlan.ApplicationSourceProperty | cdk.IResolvable;
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ScalingInstructions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions
     */
    readonly scalingInstructions: Array<CfnScalingPlan.ScalingInstructionProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export declare class CfnScalingPlan extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScalingPlans::ScalingPlan";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnScalingPlan;
    /**
     * @external
     * @cloudformationAttribute ScalingPlanName
     */
    readonly attrScalingPlanName: string;
    /**
     * @external
     * @cloudformationAttribute ScalingPlanVersion
     */
    readonly attrScalingPlanVersion: string;
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource
     */
    applicationSource: CfnScalingPlan.ApplicationSourceProperty | cdk.IResolvable;
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ScalingInstructions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions
     */
    scalingInstructions: Array<CfnScalingPlan.ScalingInstructionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::AutoScalingPlans::ScalingPlan`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScalingPlanProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export declare namespace CfnScalingPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html
     */
    interface ApplicationSourceProperty {
        /**
         * `CfnScalingPlan.ApplicationSourceProperty.CloudFormationStackARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-cloudformationstackarn
         */
        readonly cloudFormationStackArn?: string;
        /**
         * `CfnScalingPlan.ApplicationSourceProperty.TagFilters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-tagfilters
         */
        readonly tagFilters?: Array<CfnScalingPlan.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export declare namespace CfnScalingPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html
     */
    interface CustomizedLoadMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Dimensions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-dimensions
         */
        readonly dimensions?: Array<CfnScalingPlan.MetricDimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.MetricName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-metricname
         */
        readonly metricName: string;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Namespace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-namespace
         */
        readonly namespace: string;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Statistic`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-statistic
         */
        readonly statistic: string;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Unit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-unit
         */
        readonly unit?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export declare namespace CfnScalingPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html
     */
    interface CustomizedScalingMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Dimensions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-dimensions
         */
        readonly dimensions?: Array<CfnScalingPlan.MetricDimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.MetricName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-metricname
         */
        readonly metricName: string;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Namespace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-namespace
         */
        readonly namespace: string;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Statistic`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-statistic
         */
        readonly statistic: string;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Unit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-unit
         */
        readonly unit?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export declare namespace CfnScalingPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html
     */
    interface MetricDimensionProperty {
        /**
         * `CfnScalingPlan.MetricDimensionProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-name
         */
        readonly name: string;
        /**
         * `CfnScalingPlan.MetricDimensionProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export declare namespace CfnScalingPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html
     */
    interface PredefinedLoadMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.PredefinedLoadMetricSpecificationProperty.PredefinedLoadMetricType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-predefinedloadmetrictype
         */
        readonly predefinedLoadMetricType: string;
        /**
         * `CfnScalingPlan.PredefinedLoadMetricSpecificationProperty.ResourceLabel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-resourcelabel
         */
        readonly resourceLabel?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export declare namespace CfnScalingPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html
     */
    interface PredefinedScalingMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.PredefinedScalingMetricSpecificationProperty.PredefinedScalingMetricType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-predefinedscalingmetrictype
         */
        readonly predefinedScalingMetricType: string;
        /**
         * `CfnScalingPlan.PredefinedScalingMetricSpecificationProperty.ResourceLabel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-resourcelabel
         */
        readonly resourceLabel?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export declare namespace CfnScalingPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html
     */
    interface ScalingInstructionProperty {
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.CustomizedLoadMetricSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-customizedloadmetricspecification
         */
        readonly customizedLoadMetricSpecification?: CfnScalingPlan.CustomizedLoadMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.DisableDynamicScaling`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-disabledynamicscaling
         */
        readonly disableDynamicScaling?: boolean | cdk.IResolvable;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.MaxCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-maxcapacity
         */
        readonly maxCapacity: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.MinCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-mincapacity
         */
        readonly minCapacity: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredefinedLoadMetricSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predefinedloadmetricspecification
         */
        readonly predefinedLoadMetricSpecification?: CfnScalingPlan.PredefinedLoadMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMaxCapacityBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybehavior
         */
        readonly predictiveScalingMaxCapacityBehavior?: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMaxCapacityBuffer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybuffer
         */
        readonly predictiveScalingMaxCapacityBuffer?: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmode
         */
        readonly predictiveScalingMode?: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ResourceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-resourceid
         */
        readonly resourceId: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScalableDimension`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalabledimension
         */
        readonly scalableDimension: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScalingPolicyUpdateBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalingpolicyupdatebehavior
         */
        readonly scalingPolicyUpdateBehavior?: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScheduledActionBufferTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scheduledactionbuffertime
         */
        readonly scheduledActionBufferTime?: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ServiceNamespace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-servicenamespace
         */
        readonly serviceNamespace: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.TargetTrackingConfigurations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-targettrackingconfigurations
         */
        readonly targetTrackingConfigurations: Array<CfnScalingPlan.TargetTrackingConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export declare namespace CfnScalingPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html
     */
    interface TagFilterProperty {
        /**
         * `CfnScalingPlan.TagFilterProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-key
         */
        readonly key: string;
        /**
         * `CfnScalingPlan.TagFilterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export declare namespace CfnScalingPlan {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html
     */
    interface TargetTrackingConfigurationProperty {
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.CustomizedScalingMetricSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-customizedscalingmetricspecification
         */
        readonly customizedScalingMetricSpecification?: CfnScalingPlan.CustomizedScalingMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.DisableScaleIn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-disablescalein
         */
        readonly disableScaleIn?: boolean | cdk.IResolvable;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.EstimatedInstanceWarmup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-estimatedinstancewarmup
         */
        readonly estimatedInstanceWarmup?: number;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.PredefinedScalingMetricSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-predefinedscalingmetricspecification
         */
        readonly predefinedScalingMetricSpecification?: CfnScalingPlan.PredefinedScalingMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.ScaleInCooldown`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleincooldown
         */
        readonly scaleInCooldown?: number;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.ScaleOutCooldown`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleoutcooldown
         */
        readonly scaleOutCooldown?: number;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.TargetValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-targetvalue
         */
        readonly targetValue: number;
    }
}
