"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const assignment_1 = require("./assignment");
const permissionset_common_1 = require("./private/permissionset-common");
/**
 * The base permission set class
 */
class PermissionSetBase extends aws_cdk_lib_1.Resource {
    grant(principal, targetId, targetType = assignment_1.TargetTypes.AWS_ACCOUNT) {
        return new assignment_1.Assignment(this, 'Assignment', {
            permissionSet: this,
            principal: principal,
            targetId,
            targetType,
        });
    }
}
;
class PermissionSet extends PermissionSetBase {
    constructor(scope, id, props) {
        super(scope, id);
        let managedPolicies = [];
        if (props.awsManagedPolicies) {
            managedPolicies = props.awsManagedPolicies.map(policy => policy.managedPolicyArn);
        }
        if (!props.ssoInstanceArn.match(/arn:(aws|aws-us-gov|aws-cn|aws-iso|aws-iso-b):sso:::instance\/(sso)?ins-[a-zA-Z0-9-.]{16}/)) {
            throw new Error(`Invalid SSO instance ARN: ${props.ssoInstanceArn}`);
        }
        if (!props.name.match(/[\w+=,.@-]+/)) {
            throw new Error(`Invalid permission set name. Name may only contain alphanumeric characters and any of: +=,.@-: ${props.name}`);
        }
        if (props.relayStateType && !props.relayStateType.match(/[a-zA-Z0-9&$@#\\\/%?=~\-_'"|!:,.;*+\[\]\ \(\)\{\}]+/)) {
            throw new Error(`Invalid relay state type: ${props.relayStateType}`);
        }
        this.cfnPermissionSet = new aws_cdk_lib_1.aws_sso.CfnPermissionSet(this, 'permissionSet', {
            instanceArn: props.ssoInstanceArn,
            name: props.name,
            customerManagedPolicyReferences: props.customerManagedPolicyReferences,
            description: props.description,
            inlinePolicy: props.inlinePolicy,
            managedPolicies,
            permissionsBoundary: props.permissionsBoundary,
            relayStateType: props.relayStateType,
            sessionDuration: props.sessionDuration ? props.sessionDuration.toIsoString() : undefined,
        });
        this.ssoInstanceArn = props.ssoInstanceArn;
        this.permissionSetArn = this.cfnPermissionSet.attrPermissionSetArn;
    }
    /**
     * Reference an existing permission set by ARN
     */
    static fromPermissionSetArn(scope, id, permissionSetArn) {
        class Import extends PermissionSetBase {
            constructor() {
                super(...arguments);
                this.permissionSetArn = permissionSetArn;
                this.ssoInstanceArn = `arn:aws:sso:::instance/${permissionset_common_1.permissionSetParseArn(permissionSetArn).resourceName.split('/')[0]}`;
            }
        }
        ;
        const permissionSet = new Import(scope, id);
        return permissionSet;
    }
}
exports.PermissionSet = PermissionSet;
_a = JSII_RTTI_SYMBOL_1;
PermissionSet[_a] = { fqn: "@renovosolutions/cdk-library-aws-sso.PermissionSet", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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