"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Assignment = exports.TargetTypes = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const permissionset_common_1 = require("./private/permissionset-common");
const principal_common_1 = require("./private/principal-common");
var TargetTypes;
(function (TargetTypes) {
    TargetTypes["AWS_ACCOUNT"] = "AWS_ACCOUNT";
})(TargetTypes = exports.TargetTypes || (exports.TargetTypes = {}));
/**
 * The base assignment class
 *
 * Currently this is mostly empty. There isn't any
 * valuable methods to apply here or any resulting
 * attributes to define.
 */
class AssignmentBase extends aws_cdk_lib_1.Resource {
}
;
/**
 * The assignment construct.
 *
 * Has no import method because there is no attributes to import.
 */
class Assignment extends AssignmentBase {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.targetType === TargetTypes.AWS_ACCOUNT) {
            Assignment.validateAwsAccountTargetId(props.targetId);
        }
        principal_common_1.validatePrincipal(props.principal);
        permissionset_common_1.validatePermissionSetArn(props.permissionSet.permissionSetArn);
        const targetType = props.targetType ?? TargetTypes.AWS_ACCOUNT;
        new aws_cdk_lib_1.aws_sso.CfnAssignment(this, 'assignment', {
            instanceArn: props.permissionSet.ssoInstanceArn,
            permissionSetArn: props.permissionSet.permissionSetArn,
            principalId: props.principal.principalId,
            principalType: props.principal.principalType,
            targetId: props.targetId,
            targetType,
        });
    }
    static validateAwsAccountTargetId(targetId) {
        if (!targetId.match(/\d{12}/)) {
            throw new Error(`targetId should be a 12 digit AWS account id: ${targetId}`);
        }
    }
}
exports.Assignment = Assignment;
_a = JSII_RTTI_SYMBOL_1;
Assignment[_a] = { fqn: "@renovosolutions/cdk-library-aws-sso.Assignment", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXNzaWdubWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9hc3NpZ25tZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBSXFCO0FBSXJCLHlFQUEwRTtBQUMxRSxpRUFBK0Q7QUFFL0QsSUFBWSxXQUVYO0FBRkQsV0FBWSxXQUFXO0lBQ3JCLDBDQUEyQixDQUFBO0FBQzdCLENBQUMsRUFGVyxXQUFXLEdBQVgsbUJBQVcsS0FBWCxtQkFBVyxRQUV0QjtBQVNEOzs7Ozs7R0FNRztBQUNILE1BQWUsY0FBZSxTQUFRLHNCQUFRO0NBQTBCO0FBQUEsQ0FBQztBQWtDekU7Ozs7R0FJRztBQUNILE1BQWEsVUFBVyxTQUFRLGNBQWM7SUFPNUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFzQjtRQUM5RCxLQUFLLENBQUUsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWxCLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxXQUFXLENBQUMsV0FBVyxFQUFFO1lBQ2hELFVBQVUsQ0FBQywwQkFBMEIsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLENBQUM7U0FDdkQ7UUFDRCxvQ0FBaUIsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUM7UUFDbkMsK0NBQXdCLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBRS9ELE1BQU0sVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLElBQUksV0FBVyxDQUFDLFdBQVcsQ0FBQztRQUUvRCxJQUFJLHFCQUFHLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRSxZQUFZLEVBQUU7WUFDeEMsV0FBVyxFQUFFLEtBQUssQ0FBQyxhQUFhLENBQUMsY0FBYztZQUMvQyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsYUFBYSxDQUFDLGdCQUFnQjtZQUN0RCxXQUFXLEVBQUUsS0FBSyxDQUFDLFNBQVMsQ0FBQyxXQUFXO1lBQ3hDLGFBQWEsRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLGFBQWE7WUFDNUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLFVBQVU7U0FDWCxDQUFDLENBQUM7SUFDTCxDQUFDO0lBekJPLE1BQU0sQ0FBQywwQkFBMEIsQ0FBQyxRQUFnQjtRQUN4RCxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRTtZQUM3QixNQUFNLElBQUksS0FBSyxDQUFDLGlEQUFpRCxRQUFRLEVBQUUsQ0FBQyxDQUFDO1NBQzlFO0lBQ0gsQ0FBQzs7QUFMSCxnQ0EyQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBhd3Nfc3NvIGFzIHNzbyxcbiAgSVJlc291cmNlLFxuICBSZXNvdXJjZSxcbn0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBJUGVybWlzc2lvblNldCB9IGZyb20gJy4vcGVybWlzc2lvbnNldCc7XG5pbXBvcnQgeyBQcmluY2lwYWxQcm9wZXJ0eSB9IGZyb20gJy4vcHJpbmNpcGFsJztcbmltcG9ydCB7IHZhbGlkYXRlUGVybWlzc2lvblNldEFybiB9IGZyb20gJy4vcHJpdmF0ZS9wZXJtaXNzaW9uc2V0LWNvbW1vbic7XG5pbXBvcnQgeyB2YWxpZGF0ZVByaW5jaXBhbCB9IGZyb20gJy4vcHJpdmF0ZS9wcmluY2lwYWwtY29tbW9uJztcblxuZXhwb3J0IGVudW0gVGFyZ2V0VHlwZXMge1xuICBBV1NfQUNDT1VOVCA9ICdBV1NfQUNDT1VOVCcsXG59XG5cbi8qKlxuICogVGhlIHJlc291cmNlIGludGVyZmFjZSBmb3IgYW4gQVdTIFNTTyBhc3NpZ25tZW50LlxuICpcbiAqIFRoaXMgaW50ZXJmYWNlIGhhcyBubyBhdHRyaWJ1dGVzIGJlY2F1c2UgdGhlIHJlc3VsdGluZyByZXNvdXJjZSBoYXMgbm9uZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJQXNzaWdubWVudCBleHRlbmRzIElSZXNvdXJjZSB7fVxuXG4vKipcbiAqIFRoZSBiYXNlIGFzc2lnbm1lbnQgY2xhc3NcbiAqXG4gKiBDdXJyZW50bHkgdGhpcyBpcyBtb3N0bHkgZW1wdHkuIFRoZXJlIGlzbid0IGFueVxuICogdmFsdWFibGUgbWV0aG9kcyB0byBhcHBseSBoZXJlIG9yIGFueSByZXN1bHRpbmdcbiAqIGF0dHJpYnV0ZXMgdG8gZGVmaW5lLlxuICovXG5hYnN0cmFjdCBjbGFzcyBBc3NpZ25tZW50QmFzZSBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUFzc2lnbm1lbnQge307XG5cbi8qKlxuICogQXR0cmlidXRlcyBmb3IgYW4gYXNzaWdubWVudCBvZiB3aGljaCB0aGVyZSBhcmUgbm9uZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBc3NpZ25tZW50QXR0cmlidXRlcyB7fVxuXG4vKipcbiAqIFRoZSBwcm9wZXJ0aWVzIG9mIGEgbmV3IGFzc2lnbm1lbnQuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQXNzaWdubWVudFByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBwZXJtaXNzaW9uIHNldCB0byBhc3NpZ24gdG8gdGhlIHByaW5jaXBhbFxuICAgKi9cbiAgcmVhZG9ubHkgcGVybWlzc2lvblNldDogSVBlcm1pc3Npb25TZXQ7XG5cbiAgLyoqXG4gICAqIFRoZSBwcmluY2lwYWwgdG8gYXNzaWduIHRoZSBwZXJtaXNzaW9uIHNldCB0b1xuICAgKi9cbiAgcmVhZG9ubHkgcHJpbmNpcGFsOiBQcmluY2lwYWxQcm9wZXJ0eTtcblxuICAvKipcbiAgICogVGhlIHRhcmdldCBpZCB0aGUgcGVybWlzc2lvbiBzZXQgd2lsbCBiZSBhc3NpZ25lZCB0b1xuICAgKi9cbiAgcmVhZG9ubHkgdGFyZ2V0SWQ6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIGVudGl0eSB0eXBlIGZvciB3aGljaCB0aGUgYXNzaWdubWVudCB3aWxsIGJlIGNyZWF0ZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IFRhcmdldFR5cGVzLkFXU19BQ0NPVU5UXG4gICAqL1xuICByZWFkb25seSB0YXJnZXRUeXBlPzogVGFyZ2V0VHlwZXM7XG59XG5cbi8qKlxuICogVGhlIGFzc2lnbm1lbnQgY29uc3RydWN0LlxuICpcbiAqIEhhcyBubyBpbXBvcnQgbWV0aG9kIGJlY2F1c2UgdGhlcmUgaXMgbm8gYXR0cmlidXRlcyB0byBpbXBvcnQuXG4gKi9cbmV4cG9ydCBjbGFzcyBBc3NpZ25tZW50IGV4dGVuZHMgQXNzaWdubWVudEJhc2Uge1xuICBwcml2YXRlIHN0YXRpYyB2YWxpZGF0ZUF3c0FjY291bnRUYXJnZXRJZCh0YXJnZXRJZDogc3RyaW5nKSB7XG4gICAgaWYgKCF0YXJnZXRJZC5tYXRjaCgvXFxkezEyfS8pKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYHRhcmdldElkIHNob3VsZCBiZSBhIDEyIGRpZ2l0IEFXUyBhY2NvdW50IGlkOiAke3RhcmdldElkfWApO1xuICAgIH1cbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBBc3NpZ25tZW50UHJvcHMpIHtcbiAgICBzdXBlciAoc2NvcGUsIGlkKTtcblxuICAgIGlmIChwcm9wcy50YXJnZXRUeXBlID09PSBUYXJnZXRUeXBlcy5BV1NfQUNDT1VOVCkge1xuICAgICAgQXNzaWdubWVudC52YWxpZGF0ZUF3c0FjY291bnRUYXJnZXRJZChwcm9wcy50YXJnZXRJZCk7XG4gICAgfVxuICAgIHZhbGlkYXRlUHJpbmNpcGFsKHByb3BzLnByaW5jaXBhbCk7XG4gICAgdmFsaWRhdGVQZXJtaXNzaW9uU2V0QXJuKHByb3BzLnBlcm1pc3Npb25TZXQucGVybWlzc2lvblNldEFybik7XG5cbiAgICBjb25zdCB0YXJnZXRUeXBlID0gcHJvcHMudGFyZ2V0VHlwZSA/PyBUYXJnZXRUeXBlcy5BV1NfQUNDT1VOVDtcblxuICAgIG5ldyBzc28uQ2ZuQXNzaWdubWVudCh0aGlzLCAnYXNzaWdubWVudCcsIHtcbiAgICAgIGluc3RhbmNlQXJuOiBwcm9wcy5wZXJtaXNzaW9uU2V0LnNzb0luc3RhbmNlQXJuLFxuICAgICAgcGVybWlzc2lvblNldEFybjogcHJvcHMucGVybWlzc2lvblNldC5wZXJtaXNzaW9uU2V0QXJuLFxuICAgICAgcHJpbmNpcGFsSWQ6IHByb3BzLnByaW5jaXBhbC5wcmluY2lwYWxJZCxcbiAgICAgIHByaW5jaXBhbFR5cGU6IHByb3BzLnByaW5jaXBhbC5wcmluY2lwYWxUeXBlLFxuICAgICAgdGFyZ2V0SWQ6IHByb3BzLnRhcmdldElkLFxuICAgICAgdGFyZ2V0VHlwZSxcbiAgICB9KTtcbiAgfVxufVxuIl19