from setuptools import setup
import codecs


# Copied from (and hacked):
# https://github.com/pypa/virtualenv/blob/develop/setup.py#L42
def get_version(filename):
    import os
    import re

    here = os.path.dirname(os.path.abspath(__file__))
    f = codecs.open(os.path.join(here, filename), encoding='utf-8')
    version_file = f.read()
    f.close()
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]",
                              version_file, re.M)
    if version_match:
        return version_match.group(1)
    raise RuntimeError("Unable to find version string.")


with open("README.rst", "r") as fh:
    long_description = fh.read()


setup(
    name='pytest-neo',
    description=(
        'pytest-neo is a plugin for pytest that shows '
        'tests like screen of Matrix.'
    ),
    long_description=long_description,
    version=get_version('pytest_neo.py'),
    license='MIT',
    author='Ilya Chistyakov',
    author_email='ilchistyakov@gmail.com',
    py_modules=['pytest_neo'],
    entry_points={'pytest11': ['neo = pytest_neo']},
    zip_safe=False,
    include_package_data=True,
    platforms='any',
    install_requires=['pytest>=6.2.0'],
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: POSIX',
        'Operating System :: MacOS :: MacOS X',
        'Topic :: Software Development :: Testing',
        'Topic :: Software Development :: Libraries',
        'Topic :: Utilities',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: Implementation :: PyPy',
    ],
    project_urls={
        'Source': 'https://github.com/MyGodIsHe/pytest-neo',
    },
)
