# Generated by Django 3.1.13 on 2021-10-04 07:24

from django.db import migrations, models


def copy_date_to_stamp(apps, schema_editor):
    """Copy date to stamp."""
    RawNotificationModel = apps.get_model("nautobot_circuit_maintenance", "RawNotification")

    for raw_notification in RawNotificationModel.objects.all():
        raw_notification.stamp = raw_notification.date
        raw_notification.save(update_fields=["stamp"])


class Migration(migrations.Migration):

    dependencies = [
        ("circuits", "0002_initial_part_2"),
        ("nautobot_circuit_maintenance", "0009_auto_20210916_1519"),
    ]

    operations = [
        migrations.AddField(
            model_name="rawnotification",
            name="stamp",
            field=models.DateTimeField(null=True),
        ),
        migrations.RunPython(copy_date_to_stamp),
        migrations.AlterField(
            model_name="rawnotification",
            name="stamp",
            field=models.DateTimeField(),
        ),
        migrations.AlterModelOptions(
            name="rawnotification",
            options={"ordering": ["stamp"]},
        ),
        migrations.AlterUniqueTogether(
            name="rawnotification",
            unique_together={("stamp", "provider", "subject")},
        ),
        migrations.AlterModelOptions(
            name="note",
            options={"ordering": ["last_updated"]},
        ),
        migrations.AlterModelOptions(
            name="parsednotification",
            options={"ordering": ["last_updated"]},
        ),
        migrations.RemoveField(
            model_name="rawnotification",
            name="date",
        ),
        migrations.RemoveField(
            model_name="parsednotification",
            name="date",
        ),
        migrations.RemoveField(
            model_name="note",
            name="date",
        ),
    ]
