'''
Copyright (C) 2017-2022 Bryant Moscon - bmoscon@gmail.com

Please see the LICENSE file for the terms and conditions
associated with this software.
'''
from krypton_cryptofeed.exchanges.mixins.ftx_rest import FTXRestMixin
from krypton_cryptofeed.defines import CANCEL_ORDER, L2_BOOK, ORDER_INFO, ORDER_STATUS, PLACE_ORDER, TICKER, TRADES, TRADE_HISTORY


class FTXTRRestMixin(FTXRestMixin):
    api = "https://ftxtr.com/api"
    rest_channels = (
        TRADES, TICKER, L2_BOOK, ORDER_INFO, ORDER_STATUS, CANCEL_ORDER, PLACE_ORDER, TRADE_HISTORY
    )

    def funding_sync(self, symbol: str, **kwargs):
        raise NotImplementedError

    async def funding(self, symbol: str, **kwargs):
        raise NotImplementedError
