from math import pi
import cv2

def load_image(img_path, height, width):
    img = cv2.imread(img_path)
    if (height is not None and width is not None):
        shape = (height, weight)
        img = cv2.resize(img, shape)

    return img

def get_rad(theta, phi, gamma):
    return (deg_to_rad(theta),
            deg_to_rad(phi),
            deg_to_rad(gamma))

def get_deg(rtheta, rphi, rgamma):
    return (rad_to_deg(rtheta),
            rad_to_deg(rphi),
            rad_to_deg(rgamma))

def deg_to_rad(deg):
    return deg * pi / 180.0

def rad_to_deg(rad):
    return deg * 180.0 / pi
