"""
Django migration to initialize database models for the Customer Satisfaction Metrics app.

This module contains the initial database schema definitions for the Question, Survey,
and Response models. It is auto-generated by Django's manage.py makemigrations command.
"""

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    """
    Initial database migration for the Customer Satisfaction Metrics application.

    This migration creates the initial database tables for the Question, Survey,
    and Response models, along with their relationships and fields.
    """

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Question",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("text", models.TextField()),
                (
                    "response_type",
                    models.CharField(
                        choices=[
                            ("INT", "Integer"),
                            ("TEXT", "Text"),
                            ("BOOL", "Boolean"),
                        ],
                        max_length=5,
                    ),
                ),
                ("int_min", models.IntegerField(blank=True, null=True)),
                ("int_max", models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="Survey",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=200)),
                ("slug", models.SlugField(blank=True, max_length=200, unique=True)),
                (
                    "survey_type",
                    models.CharField(
                        choices=[
                            ("CSAT", "Customer Satisfaction"),
                            ("NPS", "Net Promoter Score"),
                            ("CES", "Customer Effort Score"),
                            ("GENERIC", "Generic Survey"),
                        ],
                        max_length=200,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="Response",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "response_type",
                    models.CharField(
                        choices=[
                            ("NPS", "Net Promoter Score"),
                            ("CSAT", "Customer Satisfaction Score"),
                            ("CES", "Customer Effort Score"),
                            ("TEXT", "Text"),
                            ("INT", "Integer"),
                            ("BOOL", "Boolean"),
                        ],
                        max_length=5,
                    ),
                ),
                ("text", models.TextField()),
                ("ip_address", models.GenericIPAddressField()),
                ("user_agent", models.TextField()),
                (
                    "question",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="responses",
                        to="customersatisfactionmetrics.question",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="question",
            name="survey",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="questions",
                to="customersatisfactionmetrics.survey",
            ),
        ),
    ]
