# Generated by Django PlanB 1.7 (Django 2.2.12) on 2020-05-05 14:21

from django.conf import settings
from django.db import migrations
from django.db.models.functions import Concat
from django.db.models import CharField, F, Value


def get_retention(fileset):
    for retention in (fileset.retention, fileset.hostgroup.retention):
        if retention:
            return retention
    return settings.PLANB_RETENTION


def migrate_retention_forward(apps, schema_editor):
    Fileset = apps.get_model('planb', 'Fileset')
    # Old retention values were increased by 1 in the code.
    Fileset.objects.all().update(
        retention=Concat(
            F('yearly_retention') + 1, Value('y,'),
            F('monthly_retention') + 1, Value('m,'),
            F('weekly_retention') + 1, Value('w,'),
            F('daily_retention') + 1, Value('d'), output_field=CharField()
        ))
    # Remove retention if it matches the default.
    Fileset.objects.filter(
        retention=settings.PLANB_RETENTION).update(retention='')

def migrate_retention_backward(apps, schema_editor):
    Fileset = apps.get_model('planb', 'Fileset')
    for fileset in Fileset.objects.prefetch_related('hostgroup'):
        retention = dict(
            (i[-1], int(i[:-1]))
            for i in get_retention(fileset).split(',')
        )
        # Remove 1 from retention, this is added in the old code.
        fileset.yearly_retention = max(retention.get('y', 2) - 1, 0)
        fileset.monthly_retention = max(retention.get('m', 12) - 1, 0)
        fileset.weekly_retention = max(retention.get('w', 4) - 1, 0)
        fileset.daily_retention = max(retention.get('d', 16) - 1, 0)
        fileset.save(update_fields=[
            'yearly_retention', 'monthly_retention', 'weekly_retention',
            'daily_retention',
        ])


class Migration(migrations.Migration):

    dependencies = [
        ('planb', '0016_auto_20200505_1619'),
    ]

    operations = [
        migrations.RunPython(
            migrate_retention_forward, migrate_retention_backward)
    ]
