# Generated by Django 2.1.10 on 2019-07-24 13:04

from django.core.exceptions import ImproperlyConfigured
from django.db import migrations, models


def validate_config(apps, schema_editor):
    '''
    Ensure the data migration can succeed before altering the table.
    '''
    from planb.storage import storage_pools
    Fileset = apps.get_model('planb', 'Fileset')

    required_storages = set(
        Fileset.objects.distinct().values_list('dest_pool', flat=True))
    available_storages = set(storage_pools.keys())
    if not required_storages.issubset(available_storages):
        raise ImproperlyConfigured(
            'PLANB_STORAGE_POOLS requires a storage definition for {}'.format(
                required_storages.difference(available_storages)))
    # At this point in time Zfs is the only supported storage.
    # Make sure the user doesn't map the fileset to a different storage.
    for alias in required_storages:
        storage = storage_pools[alias]
        if storage.config['ENGINE'] not in (
                'planb.storage.dummy.DummyStorage',
                'planb.storage.zfs.ZfsStorage'):
            raise ImproperlyConfigured(
                'Storage {} should be of type ZfsStorage (or DummyStorage) '
                '(current={})'.format(
                    alias, storage.config['ENGINE']))


def set_dataset_name(apps, schema_editor):
    from planb.storage import storage_pools
    Fileset = apps.get_model('planb', 'Fileset')

    for fileset in Fileset.objects.prefetch_related('hostgroup'):
        storage = storage_pools[fileset.storage_alias]
        fileset.dataset_name = storage.name_dataset(
            fileset.hostgroup.name, fileset.friendly_name)
        fileset.save(update_fields=['dataset_name'])


class Migration(migrations.Migration):

    dependencies = [
        ('planb', '0014_add_backuprun_attributes'),
    ]

    operations = [
        migrations.RunPython(validate_config),
        migrations.RenameField(
            model_name='fileset',
            old_name='dest_pool',
            new_name='storage_alias',
        ),
        migrations.AlterField(
            model_name='fileset',
            name='storage_alias',
            field=models.CharField(default='', max_length=31, verbose_name='Storage'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='fileset',
            name='dataset_name',
            field=models.CharField(default='', editable=False, help_text='The complete dataset name for the storage.', max_length=254, verbose_name='Dataset name'),
            preserve_default=False,
        ),
        migrations.RunPython(set_dataset_name),
        migrations.AlterUniqueTogether(
            name='fileset',
            unique_together={('storage_alias', 'dataset_name'), ('hostgroup', 'friendly_name')},
        ),
        migrations.AlterField(
            model_name='fileset',
            name='friendly_name',
            field=models.CharField(help_text='Short name, should be unique per host group.', max_length=63, verbose_name='Name'),
        ),
    ]
