# -*- coding: utf-8 -*-
# Generated by Django 1.11.9 on 2018-01-16 17:07
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('planb', '0004_refactor_transportfield'),
    ]

    operations = [
        migrations.CreateModel(
            name='BackupRun',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('started', models.DateTimeField(auto_now_add=True, db_index=True, help_text='When the backup run started.')),
                ('duration', models.PositiveIntegerField(blank=True, help_text='How long this backup run took in seconds.', null=True)),
                ('success', models.BooleanField(default=False, help_text='If the backup succeeded, the other values can be trusted.')),
                ('error_text', models.TextField(blank=True, help_text='Error messages; non-empty only if success is False.')),
                ('total_size_mb', models.PositiveIntegerField(default=0, help_text='Estimated total backup size in MiB.')),
                ('snapshot_size_mb', models.PositiveIntegerField(default=0, help_text='Estimated single backup size in MiB.')),
                ('snapshot_size_listing', models.TextField(blank=True, help_text='YAML-safe "PATH: SIZE<LF>"{n} dictionary of paths.')),
            ],
        ),
        migrations.AlterModelOptions(
            name='hostgroup',
            options={'ordering': ('name',)},
        ),
        migrations.AlterField(
            model_name='hostconfig',
            name='backup_size_mb',
            field=models.PositiveIntegerField(db_index=True, default=0, help_text='Estimated total backup size in MiB.'),
        ),
        migrations.AddField(
            model_name='backuprun',
            name='hostconfig',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='planb.HostConfig'),
        ),
    ]
