# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2017-05-30 14:43
from __future__ import unicode_literals

import datetime
from django.db import migrations, models
from django.utils import timezone
import django.db.models.deletion
import planb.common.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='HostConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('friendly_name', models.CharField(max_length=63, unique=True)),
                ('host', models.CharField(max_length=254)),
                ('transport', models.PositiveSmallIntegerField(choices=[(0, 'ssh (default)'), (1, 'rsync (port 873)')], default=0)),
                ('user', models.CharField(default='root', max_length=254)),
                ('src_dir', models.CharField(default='/', max_length=254)),
                ('dest_pool', models.CharField(max_length=254)),
                ('retention', models.IntegerField(default=15, help_text='How many days do we keep?', verbose_name='Daily retention')),
                ('rsync_path', models.CharField(default='/usr/bin/rsync', max_length=31)),
                ('ionice_path', models.CharField(blank=True, default='/usr/bin/ionice', max_length=31)),
                ('flags', models.CharField(default='-az --numeric-ids --stats --delete', help_text='Default "-az --delete", add "--no-perms --chmod=D0700,F600" for (windows) hosts without permission bits.', max_length=511)),
                ('includes', planb.common.fields.FilelistField(default='etc home root srv usr/local/bin var/backups var/lib/dpkg/status* var/lib/psdiff.db* var/spool/cron', max_length=1023)),
                ('excludes', planb.common.fields.FilelistField(blank=True, max_length=1023)),
                ('running', models.BooleanField(default=False)),
                ('priority', models.IntegerField(default=0)),
                ('date_complete', models.DateTimeField(default=datetime.datetime(1970, 1, 2, 0, 0, tzinfo=timezone.utc), verbose_name='Complete date')),
                ('complete_duration', models.PositiveIntegerField(default=0, help_text='Duration in seconds of last successful job.', verbose_name='Time')),
                ('enabled', models.BooleanField(default=True)),
                ('queued', models.BooleanField(default=False)),
                ('failure_datetime', models.DateTimeField(blank=True, null=True)),
                ('use_sudo', models.BooleanField(default=False)),
                ('use_ionice', models.BooleanField(default=False)),
                ('file_to_check', models.CharField(blank=True, default='var/log/kern.log', max_length=255, null=True)),
                ('keep_weekly', models.BooleanField(default=False)),
                ('keep_monthly', models.BooleanField(default=False)),
                ('keep_yearly', models.BooleanField(default=False)),
                ('weekly_retention', models.IntegerField(blank=True, default=3, help_text="How many weekly's do we need to keep?", null=True)),
                ('monthly_retention', models.IntegerField(blank=True, default=11, help_text="How many monthly's do we need to keep?", null=True)),
                ('yearly_retention', models.IntegerField(blank=True, default=1, help_text="How many yearly's do we need to keep?", null=True)),
                ('backup_size_mb', models.PositiveIntegerField(db_index=True, default=0)),
            ],
        ),
        migrations.CreateModel(
            name='HostGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=63, unique=True)),
                ('notify_email', planb.common.fields.MultiEmailField(blank=True, help_text='Use a newline per emailaddress', null=True)),
            ],
        ),
        migrations.AddField(
            model_name='hostconfig',
            name='hostgroup',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='hostconfigs', to='planb.HostGroup'),
        ),
    ]
