class cdp_listener(object):
    from typing import Dict

    def __init__(self, driver):
        self.listeners = {}
        self.driver = driver
        self.my_headers= None
    async def async_helper(self):
        async with self.driver.bidi_connection() as connection:
            session, devtools = connection.session, connection.devtools

            for listener in self.listeners.items():
                my_listener = await listener[1]["listener"](connection=connection)

                async for event in my_listener:
                    try:
                        await session.execute(await listener[1]["at_event"](event=event, connection=connection))
                    except Exception as e:
                        if -32602 in e.__dict__.values():
                            print(e) # 'Invalid InterceptionId.'
                        else:
                            raise e

    def trio_helper(self):
        import trio
        trio.run(self.async_helper)

    def start_threaded(self, listeners: Dict[str,Dict[callable, callable]] = {}):
        if listeners:
            self.listeners = listeners

        import threading
        thread = threading.Thread(target=self.trio_helper)
        thread.start()
        return thread

    def add_listeners(self, listeners: Dict[str,Dict[callable, callable]]):
        self.listeners = listeners

    def remove_listener(self, listener:str):
        del self.listeners[listener]

    def connection_refused(self,event, connection):
        self.print_event(event)

        session, devtools = connection.session, connection.devtools
        # show_image(event.request.url)
        return devtools.fetch.fail_request(request_id=event.request_id,
                                           error_reason=devtools.network.ErrorReason.CONNECTION_REFUSED)

    async def modify_headers(self, event, connection):
        self.print_event(event)

        session, devtools = connection.session, connection.devtools

        headers = event.request.headers.to_json()

        try:
            headers.update(self.my_headers)
        except TypeError as e:
            print(e)
            raise TypeError("Define headers using cdp_listener.specify_headers.\n")
        my_headers = []
        for item in headers.items():
            my_headers.append(devtools.fetch.HeaderEntry.from_json({"name": item[0], "value": item[1]}))

        return devtools.fetch.continue_request(request_id=event.request_id, headers=my_headers)

    def specify_headers(self, headers:Dict[str, str]):
        self.my_headers = headers

    async def all_images(self, connection):
        session, devtools = connection.session, connection.devtools
        pattern = map(devtools.fetch.RequestPattern.from_json, [{"resourceType": "Image"}])
        pattern = list(pattern)
        await session.execute(devtools.fetch.enable(patterns=pattern))

        return session.listen(devtools.fetch.RequestPaused)

    async def all_requests(self, connection):
        session, devtools = connection.session, connection.devtools
        pattern = map(devtools.fetch.RequestPattern.from_json, [{"urlPattern": "*"}])
        pattern = list(pattern)
        await session.execute(devtools.fetch.enable(patterns=pattern))

        return session.listen(devtools.fetch.RequestPaused)

    def show_image(self, url: str):  # show image from URL
        from PIL import Image
        from io import BytesIO
        import requests
        try:
            response = requests.get(url)
            img = Image.open(BytesIO(response.content))
            img.show()
        except Exception as e:
            print(e)

    def print_event(self, event):
        print({"type": event.resource_type.to_json(), "frame_id": event.frame_id, "url": event.request.url})