/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.io.Serializable;
import org.postgis.Point;

public abstract class Geometry
implements Serializable {
    private static final long serialVersionUID = 256L;
    public static final int LINEARRING = 0;
    public static final int POINT = 1;
    public static final int LINESTRING = 2;
    public static final int POLYGON = 3;
    public static final int MULTIPOINT = 4;
    public static final int MULTILINESTRING = 5;
    public static final int MULTIPOLYGON = 6;
    public static final int GEOMETRYCOLLECTION = 7;
    public static final String[] ALLTYPES = new String[]{"", "POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION"};
    public int dimension;
    public boolean haveMeasure = false;
    public final int type;
    public static final int UNKNOWN_SRID = 0;
    public int srid = 0;

    public static String getTypeString(int type) {
        if (type >= 0 && type <= 7) {
            return ALLTYPES[type];
        }
        throw new IllegalArgumentException("Unknown Geometry type" + type);
    }

    public static int parseSRID(int srid) {
        if (srid < 0) {
            srid = 0;
        }
        return srid;
    }

    protected Geometry(int type) {
        this.type = type;
    }

    public int hashCode() {
        return this.dimension | this.type * 4 | this.srid * 32;
    }

    public boolean equals(Object other) {
        return other != null && other instanceof Geometry && this.equals((Geometry)other);
    }

    public boolean equals(Geometry other) {
        return other != null && this.dimension == other.dimension && this.type == other.type && this.srid == other.srid && this.haveMeasure == other.haveMeasure && other.getClass().equals(this.getClass()) && this.equalsintern(other);
    }

    protected abstract boolean equalsintern(Geometry var1);

    public abstract int numPoints();

    public abstract Point getPoint(int var1);

    public abstract Point getFirstPoint();

    public abstract Point getLastPoint();

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        return Geometry.getTypeString(this.type);
    }

    public boolean isMeasured() {
        return this.haveMeasure;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int srid) {
        this.srid = srid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.srid != 0) {
            sb.append("SRID=");
            sb.append(this.srid);
            sb.append(';');
        }
        this.outerWKT(sb, true);
        return sb.toString();
    }

    public void outerWKT(StringBuffer sb, boolean putM) {
        sb.append(this.getTypeString());
        if (putM && this.haveMeasure && this.dimension == 2) {
            sb.append('M');
        }
        this.mediumWKT(sb);
    }

    public final void outerWKT(StringBuffer sb) {
        this.outerWKT(sb, true);
    }

    protected void mediumWKT(StringBuffer sb) {
        sb.append('(');
        this.innerWKT(sb);
        sb.append(')');
    }

    protected abstract void innerWKT(StringBuffer var1);

    public String getValue() {
        StringBuffer sb = new StringBuffer();
        this.mediumWKT(sb);
        return sb.toString();
    }

    public boolean checkConsistency() {
        return this.dimension >= 2 && this.dimension <= 3 && this.type >= 0 && this.type <= 7;
    }

    protected String initSRID(String value) {
        if ((value = value.trim()).startsWith("SRID=")) {
            int index = value.indexOf(59, 5);
            if (index == -1) {
                throw new IllegalArgumentException("Error parsing Geometry - SRID not delimited with ';' ");
            }
            this.srid = Integer.parseInt(value.substring(5, index));
            return value.substring(index + 1).trim();
        }
        return value;
    }
}

