/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.v0_6;

import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.store.Storeable;

public class OsmUser
implements Storeable {
    private String name;
    private int id;
    private static final int USER_ID_NONE = -1;
    public static final OsmUser NONE = new OsmUser(-1, "");

    public OsmUser(int id, String userName) {
        if (userName == null) {
            throw new NullPointerException("The user name cannot be null.");
        }
        if (NONE != null && id == -1) {
            throw new OsmosisRuntimeException("A user id of -1 is not permitted.");
        }
        this.name = userName;
        this.id = id;
    }

    public OsmUser(StoreReader sr, StoreClassRegister scr) {
        this.name = sr.readString();
        this.id = sr.readInteger();
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        sw.writeString(this.name);
        sw.writeInteger(this.id);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OsmUser)) {
            return false;
        }
        OsmUser ou = (OsmUser)o;
        return this.name.equals(ou.name) && this.id == ou.id;
    }

    public int hashCode() {
        int result = -17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

