/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.model;

public final class ZoomIntervalConfiguration {
    private final byte[] baseZoom;
    private final byte maxMaxZoom;
    private final byte[] maxZoom;
    private final byte minMinZoom;
    private final byte[] minZoom;

    public static ZoomIntervalConfiguration fromString(String confString) {
        String[] splitted = confString.split(",");
        if (splitted.length % 3 != 0) {
            throw new IllegalArgumentException("invalid zoom interval configuration, amount of comma-separated values must be a multiple of 3");
        }
        byte[][] intervals = new byte[splitted.length / 3][3];
        for (int i = 0; i < intervals.length; ++i) {
            intervals[i][0] = Byte.parseByte(splitted[i * 3]);
            intervals[i][1] = Byte.parseByte(splitted[i * 3 + 1]);
            intervals[i][2] = Byte.parseByte(splitted[i * 3 + 2]);
        }
        return ZoomIntervalConfiguration.newInstance(intervals);
    }

    public static ZoomIntervalConfiguration getStandardConfiguration() {
        return new ZoomIntervalConfiguration(new byte[][]{{5, 0, 7}, {10, 8, 11}, {14, 12, 21}});
    }

    public static ZoomIntervalConfiguration newInstance(byte[] ... intervals) {
        return new ZoomIntervalConfiguration(intervals);
    }

    private ZoomIntervalConfiguration(byte[][] intervals) {
        this.baseZoom = new byte[intervals.length];
        this.minZoom = new byte[intervals.length];
        this.maxZoom = new byte[intervals.length];
        int i = 0;
        for (byte[] interval : intervals) {
            ++i;
            if (interval.length != 3) {
                throw new IllegalArgumentException("invalid interval configuration, found only " + interval.length + "parameters for interval " + i);
            }
            if (interval[0] < interval[1] || interval[0] > interval[2]) {
                throw new IllegalArgumentException("invalid configuration for interval " + i + ", make sure that minZoom < baseZoom < maxZoom");
            }
            if (i > 1) {
                if (interval[0] < this.baseZoom[i - 2]) {
                    throw new IllegalArgumentException("interval configurations must follow an increasing order");
                }
                if (interval[1] != this.maxZoom[i - 2] + 1) {
                    throw new IllegalArgumentException("minZoom of interval " + i + " not adjacent to maxZoom of interval " + (i - 1));
                }
            }
            this.baseZoom[i - 1] = interval[0];
            this.minZoom[i - 1] = interval[1];
            this.maxZoom[i - 1] = interval[2];
        }
        this.minMinZoom = this.minZoom[0];
        this.maxMaxZoom = this.maxZoom[this.maxZoom.length - 1];
    }

    public byte getBaseZoom(int index) {
        this.checkValidIndex(index);
        return this.baseZoom[index];
    }

    public byte getMaxMaxZoom() {
        return this.maxMaxZoom;
    }

    public byte getMaxZoom(int index) {
        this.checkValidIndex(index);
        return this.maxZoom[index];
    }

    public byte getMinMinZoom() {
        return this.minMinZoom;
    }

    public byte getMinZoom(int index) {
        this.checkValidIndex(index);
        return this.minZoom[index];
    }

    public int getNumberOfZoomIntervals() {
        if (this.baseZoom == null) {
            return 0;
        }
        return this.baseZoom.length;
    }

    private void checkValidIndex(int index) {
        if (index < 0 || index >= this.baseZoom.length) {
            throw new IllegalArgumentException("illegal zoom interval index: " + index);
        }
    }

    public String toString(int index) {
        return this.getBaseZoom(index) + "," + this.getMinZoom(index) + "," + this.getMaxZoom(index);
    }
}

