/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.ElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.OsmElementProcessor;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmHandler
extends DefaultHandler {
    private static final Logger LOG = Logger.getLogger(OsmHandler.class.getName());
    private static final String ELEMENT_NAME_OSM = "osm";
    private ElementProcessor osmElementProcessor;
    private ElementProcessor elementProcessor;
    private Locator documentLocator;

    public OsmHandler(Sink osmSink, boolean enableDateParsing) {
        this.osmElementProcessor = new OsmElementProcessor(null, osmSink, enableDateParsing, true);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.elementProcessor != null) {
            this.elementProcessor = this.elementProcessor.getChild(uri, localName, qName);
        } else if (ELEMENT_NAME_OSM.equals(qName)) {
            this.elementProcessor = this.osmElementProcessor;
        } else {
            throw new OsmosisRuntimeException("This does not appear to be an OSM XML file.");
        }
        this.elementProcessor.begin(attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.elementProcessor.end();
        this.elementProcessor = this.elementProcessor.getParent();
    }

    @Override
    public void setDocumentLocator(Locator documentLocator) {
        this.documentLocator = documentLocator;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        LOG.severe("Unable to parse xml file.  publicId=(" + this.documentLocator.getPublicId() + "), systemId=(" + this.documentLocator.getSystemId() + "), lineNumber=" + this.documentLocator.getLineNumber() + ", columnNumber=" + this.documentLocator.getColumnNumber() + ".");
        super.error(e);
    }
}

