# Generated by Django 3.0.6 on 2020-05-05 22:13

from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Circunscripcion',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('nombre', models.CharField(max_length=10)),
                ('orden', models.CharField(max_length=7)),
            ],
            options={
                'verbose_name_plural': 'circunscripciones',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='Comprobante',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('nombre', models.CharField(max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='Dp',
            fields=[
                ('dp', models.IntegerField(primary_key=True, serialize=False)),
                ('nombre', models.CharField(max_length=50, verbose_name='nombre depto')),
                ('habitantes', models.IntegerField(blank=True)),
                ('superficie', models.IntegerField(blank=True)),
                ('cabecera', models.CharField(blank=True, max_length=50)),
                ('circunscripcion', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='gea.Circunscripcion')),
            ],
            options={
                'verbose_name_plural': 'Departamentos',
                'ordering': ['dp'],
            },
        ),
        migrations.CreateModel(
            name='Ds',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('ds', models.IntegerField()),
                ('nombre', models.CharField(max_length=50, verbose_name='nombre distrito')),
                ('dp', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='gea.Dp')),
            ],
            options={
                'verbose_name_plural': 'distritos',
                'ordering': ['dp', 'ds'],
            },
        ),
        migrations.CreateModel(
            name='Expediente',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.IntegerField(primary_key=True, serialize=False, verbose_name='Expediente Nº')),
                ('fecha_plano', models.DateField(blank=True, null=True)),
                ('fecha_medicion', models.DateField(blank=True, null=True)),
                ('inscripcion_numero', models.IntegerField(blank=True, null=True, unique=True, verbose_name='SCIT inscripción Nº')),
                ('inscripcion_fecha', models.DateField(blank=True, null=True, verbose_name='Fecha inscripción')),
                ('duplicado', models.BooleanField(default=False)),
                ('orden_numero', models.IntegerField(blank=True, null=True, verbose_name='CoPA Expendiente Nº')),
                ('orden_fecha', models.DateField(blank=True, null=True, verbose_name='Fecha contrato')),
                ('sin_inscripcion', models.BooleanField(default=False)),
                ('cancelado', models.BooleanField(default=False)),
                ('cancelado_por', models.CharField(blank=True, max_length=100)),
                ('plano_ruta', models.URLField(blank=True, max_length=100)),
            ],
            options={
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Lugar',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nombre', models.CharField(max_length=80)),
                ('observacion', models.CharField(blank=True, max_length=255)),
            ],
            options={
                'verbose_name_plural': 'lugares',
                'ordering': ['nombre'],
            },
        ),
        migrations.CreateModel(
            name='Objeto',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nombre', models.CharField(max_length=80)),
            ],
            options={
                'ordering': ['nombre'],
            },
        ),
        migrations.CreateModel(
            name='Partida',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pii', models.IntegerField()),
                ('subpii', models.IntegerField()),
                ('api', models.SmallIntegerField()),
            ],
            options={
                'ordering': ['pii', 'subpii'],
            },
        ),
        migrations.CreateModel(
            name='Titulo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nombre', models.CharField(max_length=30)),
            ],
            options={
                'ordering': ['nombre'],
            },
        ),
        migrations.CreateModel(
            name='Zona',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('descripcion', models.CharField(max_length=50)),
            ],
            options={
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='Sd',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('sd', models.IntegerField()),
                ('nombre', models.CharField(blank=True, max_length=50, verbose_name='nombre subdistrito')),
                ('ds', models.ForeignKey(db_column='ds', on_delete=django.db.models.deletion.PROTECT, to='gea.Ds')),
            ],
            options={
                'verbose_name_plural': 'subdistritos',
                'ordering': ['ds', 'sd'],
            },
        ),
        migrations.CreateModel(
            name='Profesional',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nombres', models.CharField(max_length=50)),
                ('apellidos', models.CharField(max_length=50)),
                ('icopa', models.CharField(blank=True, max_length=8, verbose_name='ICoPA')),
                ('domicilio', models.CharField(blank=True, max_length=50)),
                ('telefono', models.CharField(blank=True, max_length=20)),
                ('celular', models.CharField(blank=True, max_length=20)),
                ('web', models.URLField(blank=True, max_length=50)),
                ('email', models.EmailField(blank=True, max_length=50)),
                ('cuit_cuil', models.CharField(blank=True, max_length=14, verbose_name='CUIT/CUIL/CDI')),
                ('habilitado', models.BooleanField(default=True)),
                ('jubilado', models.BooleanField(default=False)),
                ('fallecido', models.BooleanField(default=False)),
                ('lugar', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='gea.Lugar')),
                ('titulo', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='gea.Titulo')),
            ],
            options={
                'verbose_name_plural': 'profesionales',
                'ordering': ['apellidos', 'nombres'],
            },
        ),
        migrations.CreateModel(
            name='Presupuesto',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('monto', models.DecimalField(decimal_places=2, max_digits=8)),
                ('fecha', models.DateField()),
                ('porcentaje_cancelado', models.DecimalField(decimal_places=2, max_digits=5, verbose_name='% cancelado')),
                ('observacion', models.CharField(blank=True, max_length=255)),
                ('expediente', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='gea.Expediente')),
            ],
            options={
                'ordering': ['expediente'],
            },
        ),
        migrations.CreateModel(
            name='Persona',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nombres', models.CharField(blank=True, max_length=100)),
                ('apellidos', models.CharField(max_length=100)),
                ('nombres_alternativos', models.CharField(blank=True, max_length=100)),
                ('apellidos_alternativos', models.CharField(blank=True, max_length=100)),
                ('domicilio', models.CharField(blank=True, max_length=50)),
                ('telefono', models.CharField(blank=True, max_length=20)),
                ('celular', models.CharField(blank=True, max_length=20)),
                ('email', models.EmailField(blank=True, max_length=50)),
                ('cuit_cuil', models.CharField(blank=True, default=None, max_length=14, null=True, unique=True, verbose_name='CUIT/CUIL/CDI')),
                ('tipo_doc', models.SmallIntegerField(blank=True, choices=[(0, 'DNI'), (1, 'LC'), (2, 'LE'), (3, 'Otro')])),
                ('documento', models.IntegerField(blank=True, default=None, unique=True)),
                ('lugar', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='gea.Lugar')),
            ],
            options={
                'ordering': ['apellidos', 'nombres'],
            },
        ),
        migrations.CreateModel(
            name='PartidaDominio',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tomo', models.IntegerField(blank=True)),
                ('par', models.BooleanField(default=False)),
                ('impar', models.BooleanField(default=False)),
                ('folio', models.IntegerField(blank=True)),
                ('numero', models.IntegerField(blank=True)),
                ('fecha', models.DateField(blank=True)),
                ('fecha_inscripcion_definitiva', models.DateField(blank=True)),
                ('partida', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gea.Partida')),
            ],
            options={
                'verbose_name_plural': 'partida_dominios',
            },
        ),
        migrations.AddField(
            model_name='partida',
            name='sd',
            field=models.ForeignKey(db_column='sd', default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='gea.Sd'),
        ),
        migrations.CreateModel(
            name='Pago',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('comprobante_nro', models.IntegerField()),
                ('fecha', models.DateField()),
                ('monto', models.DecimalField(decimal_places=2, max_digits=8)),
                ('porcentaje', models.DecimalField(decimal_places=2, max_digits=5)),
                ('observacion', models.CharField(blank=True, max_length=255)),
                ('comprobante', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='gea.Comprobante')),
                ('presupuesto', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='gea.Presupuesto')),
            ],
        ),
        migrations.CreateModel(
            name='ExpedientePersona',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('comitente', models.BooleanField(default=False)),
                ('propietario', models.BooleanField(default=True)),
                ('poseedor', models.BooleanField(default=False)),
                ('sucesor', models.BooleanField(default=False)),
                ('partes_indivisas_propias', models.IntegerField(blank=True)),
                ('partes_indivisas_total', models.IntegerField(blank=True)),
                ('sucesion', models.BooleanField(default=False)),
                ('nuda_propiedad', models.BooleanField(default=False)),
                ('usufructo', models.BooleanField(default=False)),
                ('expediente', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gea.Expediente')),
                ('persona', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gea.Persona')),
            ],
            options={
                'verbose_name': 'persona involucrada',
                'verbose_name_plural': 'personas involucradas',
                'ordering': ['persona__apellidos', 'persona__nombres'],
            },
        ),
        migrations.CreateModel(
            name='ExpedientePartida',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('set_ruta', models.URLField(blank=True, max_length=100)),
                ('expediente', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gea.Expediente')),
                ('partida', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gea.Partida')),
            ],
            options={
                'verbose_name': 'partida',
                'verbose_name_plural': 'partidas',
                'ordering': ['expediente', 'partida'],
            },
        ),
        migrations.CreateModel(
            name='ExpedienteLugar',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('expediente', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gea.Expediente')),
                ('lugar', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gea.Lugar')),
            ],
            options={
                'verbose_name': 'lugar',
                'verbose_name_plural': 'lugares',
                'ordering': ['expediente', 'lugar'],
            },
        ),
        migrations.AddField(
            model_name='expediente',
            name='objetos',
            field=models.ManyToManyField(to='gea.Objeto'),
        ),
        migrations.AddField(
            model_name='expediente',
            name='profesionales_firmantes',
            field=models.ManyToManyField(to='gea.Profesional'),
        ),
        migrations.CreateModel(
            name='CatastroLocal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('seccion', models.CharField(blank=True, max_length=20)),
                ('manzana', models.CharField(blank=True, max_length=20)),
                ('parcela', models.CharField(blank=True, max_length=20)),
                ('subparcela', models.CharField(blank=True, max_length=20)),
                ('suburbana', models.BooleanField(default=False)),
                ('poligono', models.CharField(blank=True, max_length=20)),
                ('expediente_lugar', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gea.ExpedienteLugar')),
            ],
            options={
                'verbose_name': 'catastro local',
                'verbose_name_plural': 'catastros locales',
            },
        ),
        migrations.CreateModel(
            name='Catastro',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('seccion', models.CharField(blank=True, max_length=10)),
                ('poligono', models.CharField(blank=True, max_length=10)),
                ('manzana', models.CharField(blank=True, max_length=10)),
                ('parcela', models.CharField(max_length=10)),
                ('subparcela', models.CharField(blank=True, max_length=10)),
                ('expediente_partida', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gea.ExpedientePartida')),
                ('zona', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gea.Zona')),
            ],
        ),
        migrations.CreateModel(
            name='Antecedente',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('inscripcion_numero', models.IntegerField()),
                ('duplicado', models.BooleanField(default=False)),
                ('observacion', models.CharField(blank=True, max_length=255)),
                ('plano_ruta', models.URLField(blank=True, max_length=100)),
                ('expediente', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gea.Expediente')),
                ('expediente_modificado', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='expediente_modificado', to='gea.Expediente')),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='partida',
            unique_together={('pii', 'subpii')},
        ),
    ]
