"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShardingInstance = exports.ShardingInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const mongodb_generated_1 = require("./mongodb.generated");
Object.defineProperty(exports, "ShardingInstanceProperty", { enumerable: true, get: function () { return mongodb_generated_1.RosShardingInstance; } });
/**
 * A ROS resource type:  `ALIYUN::MONGODB::ShardingInstance`
 */
class ShardingInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::MONGODB::ShardingInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosShardingInstance = new mongodb_generated_1.RosShardingInstance(this, id, {
            tdeStatus: props.tdeStatus,
            engineVersion: props.engineVersion === undefined || props.engineVersion === null ? '3.4' : props.engineVersion,
            zoneId: props.zoneId,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            securityIpArray: props.securityIpArray,
            mongos: props.mongos,
            storageEngine: props.storageEngine === undefined || props.storageEngine === null ? 'WiredTiger' : props.storageEngine,
            restoreTime: props.restoreTime,
            accountPassword: props.accountPassword,
            vpcId: props.vpcId,
            protocolType: props.protocolType,
            chargeType: props.chargeType === undefined || props.chargeType === null ? 'PostPaid' : props.chargeType,
            networkType: props.networkType,
            configServer: props.configServer,
            srcDbInstanceId: props.srcDbInstanceId,
            replicaSet: props.replicaSet,
            dbInstanceDescription: props.dbInstanceDescription,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosShardingInstance;
        this.attrDbInstanceId = rosShardingInstance.attrDbInstanceId;
        this.attrDbInstanceStatus = rosShardingInstance.attrDbInstanceStatus;
        this.attrOrderId = rosShardingInstance.attrOrderId;
    }
}
exports.ShardingInstance = ShardingInstance;
//# sourceMappingURL=data:application/json;base64,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