from canvas_workflow_kit.value_set.value_set import ValueSet


class PenicillinAntibiotics(ValueSet):
    VALUE_SET_NAME = 'Penicillin Antibiotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151185', '151511', '152729', '154602', '156201', '163138', '163138', '163785', '163785', '171050', '175995',
        '177124', '177124', '177124', '177514', '177514', '177514', '178491', '179116', '179881', '179881', '181397',
        '183940', '186245', '193402', '193402', '194882', '196275', '196670', '198439', '198769', '200884', '200884',
        '201510', '202187', '203900', '203900', '203900', '208138', '208138', '208138', '208741', '213521', '214718',
        '214718', '214718', '215259', '215897', '216098', '216098', '216157', '218463', '218463', '218463', '218991',
        '219168', '219385', '221024', '221024', '221024', '222079', '222846', '225679', '228707', '230792', '230938',
        '231552', '231552', '231552', '232938', '232938', '233571', '235122', '237917', '238581', '239684', '239684',
        '239684', '239759', '248044', '249125', '250340', '251090', '252253', '254252', '255395', '256845', '256942',
        '257616', '257616', '257616', '260954', '260954', '260954', '265081', '267161', '267173', '267331', '268409',
        '268491', '268912', '268912', '268912', '269658', '274716', '275332', '277766', '282194', '283416', '283936',
        '290663', '292856', '293276', '293704', '296359', '297410', '297410', '299693', '400606', '400607', '400621',
        '400622', '400667', '400668', '428854', '444914', '445646', '445647', '445649', '446344', '446349', '448072',
        '453628', '475428', '554141', '556891', '561559',
    }


class PenicillinAntibioticNatural(ValueSet):
    VALUE_SET_NAME = 'Penicillin Antibiotic - Natural'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151185', '179116', '179881', '179881', '193402', '193402', '196275', '213521', '222846', '225679', '252253',
        '256942', '267331', '268409', '269658', '277766', '299693', '400621', '400622', '445646', '445647', '453628',
    }


class AminopenicillinAntibiotic(ValueSet):
    VALUE_SET_NAME = 'Aminopenicillin Antibiotic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152729', '171050', '175995', '181397', '200884', '200884', '202187', '203900', '203900', '203900', '208741',
        '215259', '215897', '216098', '216098', '218991', '219385', '222079', '231552', '231552', '231552', '248044',
        '256845', '260954', '260954', '260954', '265081', '267161', '267173', '268491', '268912', '268912', '268912',
        '554141', '556891',
    }


class PenicillinAntibioticPenicillinaseResistant(ValueSet):
    VALUE_SET_NAME = 'Penicillin Antibiotic - Penicillinase-resistant'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151511', '154602', '163785', '163785', '198769', '201510', '228707', '232938', '232938', '235122', '250340',
        '255395', '282194', '283416', '292856', '293276', '400606', '400607',
    }


class PenicillinAntibioticExtendedSpectrum(ValueSet):
    VALUE_SET_NAME = 'Penicillin Antibiotic - Extended-spectrum'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class UrinaryAntibacterialAmidinopenicillin(ValueSet):
    VALUE_SET_NAME = 'Urinary Antibacterial - Amidinopenicillin'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class PenicillinAntibioticCombinations(ValueSet):
    VALUE_SET_NAME = 'Penicillin Antibiotic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156201', '163138', '163138', '177124', '177124', '177124', '177514', '177514', '177514', '178491', '183940',
        '186245', '194882', '196670', '198439', '208138', '208138', '208138', '214718', '214718', '214718', '216157',
        '218463', '218463', '218463', '219168', '221024', '221024', '221024', '230792', '230938', '233571', '237917',
        '238581', '239684', '239684', '239684', '239759', '249125', '251090', '254252', '257616', '257616', '257616',
        '274716', '275332', '283936', '290663', '293704', '296359', '297410', '297410', '400667', '400668', '428854',
        '444914', '445649', '446344', '446349', '448072', '475428', '561559',
    }


class PenicillinAntibioticAminoglycosideAntibioticCombinations(ValueSet):
    VALUE_SET_NAME = 'Penicillin Antibiotic - Aminoglycoside Antibiotic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class PenicillinAntibioticAnalgesicCombinations(ValueSet):
    VALUE_SET_NAME = 'Penicillin Antibiotic - Analgesic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class CephalosporinAntibiotics(ValueSet):
    VALUE_SET_NAME = 'Cephalosporin Antibiotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151398', '153158', '155031', '156634', '157270', '158349', '159656', '163107', '165708', '166260', '166260',
        '166702', '167466', '168270', '168270', '168575', '171540', '172417', '172648', '175020', '177101', '177843',
        '178552', '178928', '179693', '180222', '180704', '181309', '182796', '184235', '184590', '185182', '186935',
        '187681', '188516', '190065', '190242', '190711', '190711', '190711', '191166', '191166', '195329', '195800',
        '198317', '201731', '202876', '202876', '204820', '207959', '209523', '210861', '210861', '210861', '214298',
        '216223', '216895', '217085', '217085', '217304', '218065', '218129', '220956', '221530', '222255', '223977',
        '224542', '225523', '225817', '225817', '226058', '226058', '226214', '226606', '228907', '230300', '230652',
        '232042', '235857', '236472', '237590', '237854', '237930', '239952', '240273', '240273', '240697', '240780',
        '241621', '241727', '246047', '250823', '251407', '252739', '254305', '255939', '255939', '257395', '259480',
        '261454', '262533', '263068', '263575', '263870', '267182', '268017', '268017', '268758', '269959', '272404',
        '272522', '272786', '274680', '275833', '275833', '275966', '276972', '277037', '277182', '278278', '280146',
        '282576', '282576', '282809', '285453', '287007', '287953', '289909', '289909', '292949', '297319', '299864',
        '471278', '471279', '471617', '471617', '472923', '472943', '474613', '474613', '474614', '474614', '475403',
        '545320', '545322', '545379', '545380', '550726', '550726', '550745', '550745', '553465', '553468', '553928',
        '556215', '556216', '556566', '556566', '556577', '556577', '557426', '557427', '561459', '561460', '562545',
        '562546', '562698', '562699', '563932', '565242', '565243', '568330', '570672', '575547', '575548', '575560',
        '575561', '577852', '577852', '577853', '577853', '583451', '583460', '584264', '584841', '585734', '586833',
        '588175', '588234', '589160', '589161', '590996', '593000', '593009', '594053', '594159',
    }


class CephalosporinAntibiotics1stGeneration(ValueSet):
    VALUE_SET_NAME = 'Cephalosporin Antibiotics - 1st Generation'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153158', '168270', '168270', '177843', '178928', '180704', '181309', '184235', '191166', '191166', '195329',
        '207959', '216223', '217304', '225817', '225817', '232042', '237854', '240273', '240273', '246047', '252739',
        '263575', '275833', '275833', '472923', '472943', '545320', '545322', '553928', '557426', '557427', '570672',
        '585734', '586833', '588175', '588234', '590996', '593000', '593009', '594053', '594159',
    }


class CephalosporinAntibiotics2ndGeneration(ValueSet):
    VALUE_SET_NAME = 'Cephalosporin Antibiotics - 2nd Generation'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151398', '158349', '159656', '163107', '166260', '166260', '166702', '168575', '172417', '178552', '180222',
        '186935', '190242', '190711', '190711', '190711', '201731', '209523', '210861', '210861', '210861', '217085',
        '217085', '218129', '221530', '224542', '228907', '236472', '237590', '240780', '241621', '262533', '263068',
        '268017', '268017', '272786', '274680', '276972', '277182', '278278', '287007', '287953', '299864', '545379',
        '545380', '553465', '553468',
    }


class CephalosporinAntibiotics3rdGeneration(ValueSet):
    VALUE_SET_NAME = 'Cephalosporin Antibiotics - 3rd Generation'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155031', '156634', '157270', '167466', '171540', '172648', '175020', '177101', '179693', '184590', '185182',
        '187681', '188516', '190065', '195800', '198317', '202876', '202876', '204820', '214298', '216895', '218065',
        '220956', '222255', '225523', '226058', '226058', '226214', '226606', '237930', '239952', '240697', '241727',
        '250823', '251407', '254305', '255939', '255939', '257395', '263870', '267182', '268758', '269959', '272404',
        '272522', '275966', '277037', '280146', '282576', '282576', '282809', '285453', '289909', '289909', '292949',
        '297319', '471278', '471279', '471617', '471617', '474613', '474613', '474614', '474614', '475403', '550726',
        '550726', '550745', '550745', '556566', '556566', '556577', '556577', '563932', '565242', '565243', '568330',
        '575547', '575548', '575560', '575561', '577852', '577852', '577853', '577853', '589160', '589161',
    }


class CephalosporinAntibiotics4thGeneration(ValueSet):
    VALUE_SET_NAME = 'Cephalosporin Antibiotics - 4th Generation'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165708', '182796', '223977', '230300', '230652', '235857', '259480', '261454', '556215', '556216', '561459',
        '561460',
    }


class CephalosporinAntibioticsCombinations(ValueSet):
    VALUE_SET_NAME = 'Cephalosporin Antibiotics Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '583451', '583460', '584264', '584841',
    }


class MacrolideAntibioticsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Macrolide Antibiotics and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158260', '160811', '166250', '170344', '170344', '171032', '172089', '172089', '172282', '177323', '178161',
        '191814', '192504', '192882', '193361', '196828', '196915', '198967', '207911', '212311', '213682', '213682',
        '214158', '214158', '214386', '219107', '221200', '222195', '224912', '226253', '234514', '234514', '236682',
        '238877', '238877', '238877', '239861', '241393', '242135', '245677', '245677', '251092', '252048', '253769',
        '256969', '256969', '258377', '262619', '263787', '276290', '276964', '276964', '276964', '291103', '294797',
        '296846', '296846', '299595', '428910', '445655', '445655', '445823', '474378', '474386', '474976', '564429',
        '564432',
    }


class MacrolideCombinations(ValueSet):
    VALUE_SET_NAME = 'Macrolide Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class LincosamideAntibiotics(ValueSet):
    VALUE_SET_NAME = 'Lincosamide  Antibiotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152366', '153798', '153798', '153798', '153798', '153798', '156338', '167106', '173116', '189584', '189584',
        '189584', '189584', '193624', '196373', '196373', '202099', '204496', '205189', '209010', '216402', '222528',
        '234671', '234671', '242899', '242899', '267677', '267677', '298595', '298595', '475528', '475529', '475542',
        '475674', '475694', '576185', '587044', '587050', '591222', '593496', '593497', '593498',
    }


class TetracyclineAntibioticsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Tetracycline Antibiotics and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150546', '155953', '162562', '162562', '162562', '179296', '181611', '183851', '186076', '197107', '205916',
        '213996', '217508', '220826', '224956', '228445', '230922', '235975', '242595', '250247', '254416', '254503',
        '255441', '275615', '289461', '290164', '290164', '291732', '298835', '428982', '448641', '449553', '449565',
        '449566', '474860', '474861', '475401', '545247', '545248', '545249', '550382', '550399', '552640', '552642',
        '555364', '555384', '557078', '557103', '557110', '558920', '558921', '558931', '558932', '562171', '562172',
        '562173', '562177', '562178', '562179', '563829', '563829', '563891', '563983', '563984', '578077', '578853',
        '580565', '582201', '582202', '582237', '582238', '582397', '582411', '582412', '584689', '586015', '586026',
        '587408', '587410', '587411', '588361', '588363', '591029', '591063', '591066', '591089', '591097', '591564',
        '594623', '594624', '594625', '594718', '594727', '594729', '594807', '594808', '595144', '595145', '595146',
        '596028',
    }


class TetracyclineAntibioticsCombinations(ValueSet):
    VALUE_SET_NAME = 'Tetracycline Antibiotics Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '557103', '557110', '582397', '582411', '582412', '588361', '588363',
    }


class FluoroquinoloneCombinations(ValueSet):
    VALUE_SET_NAME = 'Fluoroquinolone Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class FluoroquinoloneMacrolideAntibioticCombinations(ValueSet):
    VALUE_SET_NAME = 'Fluoroquinolone-Macrolide Antibiotic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AminoglycosideAntibiotic(ValueSet):
    VALUE_SET_NAME = 'Aminoglycoside Antibiotic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '162865', '171012', '203631', '251206', '261523', '261523', '261523', '262452', '278441', '278441', '279188',
        '453193', '475538', '475541', '548829', '548829', '548831', '548832', '548833', '548834', '548946', '548947',
        '552403', '561552', '561565',
    }


class AntimycobacterialAgents(ValueSet):
    VALUE_SET_NAME = 'Antimycobacterial Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150351', '151172', '156944', '156944', '156944', '156944', '159752', '160201', '170764', '176601', '178208',
        '178208', '181216', '190069', '193403', '193415', '219999', '220366', '220702', '229165', '234703', '235901',
        '235901', '235901', '235901', '236528', '239053', '239053', '240114', '242617', '243863', '249068', '249895',
        '249946', '249946', '261122', '262780', '264399', '264399', '280732', '286198', '296151', '448888', '448888',
        '448890', '448890', '448892', '448892', '448893', '448893', '473521', '550238', '550238', '550256', '550256',
        '576490', '576565',
    }


class AntitubercularCombinations(ValueSet):
    VALUE_SET_NAME = 'Antitubercular Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '170764', '193415', '280732', '296151',
    }


class Antifungals(ValueSet):
    VALUE_SET_NAME = 'Antifungals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154877', '163082', '164267', '165553', '170534', '175283', '175283', '176419', '178876', '178876', '178876',
        '180391', '181700', '181752', '181816', '193650', '194377', '194561', '194566', '210224', '216228', '216228',
        '216228', '216228', '220130', '220966', '227421', '228802', '229318', '232751', '239909', '242676', '242935',
        '244009', '251372', '251840', '257739', '259089', '263844', '265676', '267110', '272429', '276354', '284001',
        '284100', '285202', '287927', '288690', '288690', '289225', '293107', '295262', '443959', '443960', '443961',
        '445265', '445266', '445267', '467376', '467383', '468007', '468008', '468009', '473630', '474096', '476514',
        '546548', '546558', '547497', '547536', '552365', '554624', '554625', '554633', '554634', '559545', '559547',
        '560281', '560281', '561206', '561207', '576151', '576154', '580376', '580377', '581109', '581121', '584470',
        '584473', '584712', '584714',
    }


class AntifungalOther(ValueSet):
    VALUE_SET_NAME = 'Antifungal other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164267', '165553', '180391', '181700', '181752', '210224', '242676', '242935', '251372', '265676', '295262',
    }


class AntifungalImidazoles(ValueSet):
    VALUE_SET_NAME = 'Antifungal - Imidazoles'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '170534', '561206', '561207',
    }


class AntifungalTriazoles(ValueSet):
    VALUE_SET_NAME = 'Antifungal - Triazoles'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154877', '163082', '175283', '175283', '176419', '178876', '178876', '178876', '181816', '193650', '194377',
        '194566', '216228', '216228', '216228', '216228', '228802', '232751', '239909', '244009', '259089', '263844',
        '284100', '285202', '288690', '288690', '289225', '293107', '443959', '443960', '443961', '445265', '445266',
        '445267', '467376', '467383', '546548', '546558', '560281', '560281', '576151', '576154', '580376', '580377',
        '581109', '581121', '584470', '584473', '584712', '584714',
    }


class Antivirals(ValueSet):
    VALUE_SET_NAME = 'Antivirals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150887', '151332', '151661', '151732', '153357', '153645', '153888', '155427', '156136', '157130', '157172',
        '157284', '157686', '158370', '164336', '164367', '164470', '164471', '165277', '165634', '166359', '166544',
        '169374', '170886', '171370', '173863', '175985', '176222', '176927', '176935', '180384', '180384', '182458',
        '182635', '182833', '183601', '184850', '190554', '190554', '197324', '198147', '199517', '199536', '199842',
        '200565', '201661', '202308', '203395', '204203', '204519', '207871', '208776', '209280', '209905', '211256',
        '212012', '212078', '212245', '213140', '213291', '217041', '220400', '220400', '222692', '223107', '227082',
        '227763', '229021', '232143', '235677', '235809', '237220', '237887', '237976', '239315', '239600', '239600',
        '241914', '243165', '244816', '247256', '247898', '249427', '252070', '254026', '254785', '256157', '257046',
        '257099', '262840', '265155', '266189', '266382', '266488', '267097', '268222', '268512', '269371', '270511',
        '270621', '271580', '275190', '278653', '279164', '279743', '282309', '282484', '283252', '284070', '288003',
        '288259', '288747', '290845', '291059', '291085', '291169', '291169', '291326', '293003', '294847', '295121',
        '296447', '299474', '400094', '400684', '400684', '401010', '446297', '446299', '446414', '446426', '446515',
        '446518', '448274', '448275', '449789', '450226', '450227', '450407', '450408', '450616', '450627', '452983',
        '452995', '453876', '453883', '454276', '454276', '454277', '454277', '454278', '454278', '454279', '454279',
        '467548', '467806', '471230', '471231', '471246', '471287', '472805', '473165', '473714', '473715', '473716',
        '473724', '473725', '473738', '473738', '473739', '473739', '473740', '473740', '473741', '473741', '474060',
        '474438', '474439', '475260', '475556', '475557', '475741', '475839', '475840', '475841', '475842', '475843',
        '475855', '475855', '475857', '475858', '475871', '475871', '475872', '475872', '475875', '475876', '475877',
        '475878', '545873', '545875', '547362', '547401', '547482', '547484', '552320', '552323', '552327', '552334',
        '552491', '552492', '553092', '553093', '553103', '553104', '553119', '553124', '553459', '553464', '554090',
        '554092', '554419', '554984', '556217', '556288', '556616', '556620', '557332', '557335', '558314', '558362',
        '559651', '560325', '560332', '560479', '560490', '563113', '563119', '563771', '563772', '564311', '564313',
        '564987', '564993', '565605', '565609', '565865', '565866', '567564', '567565', '567604', '567605', '569498',
        '569499', '569906', '570003', '570004', '570005', '570007', '570013', '570014', '570015', '570016', '570742',
        '570746', '572347', '572351', '572511', '572511', '572513', '574877', '574883', '575072', '575073', '575866',
        '575964', '575972', '577381', '577541', '577542', '579487', '579507', '580375', '580384', '580418', '580421',
        '580523', '580572', '581592', '581595', '581739', '581864', '582414', '582420', '582741', '582742', '582814',
        '582819', '583084', '583086', '583453', '583456', '583457', '583466', '583740', '583741', '583821', '583822',
        '586387', '586584', '586615', '586776', '586779', '586797', '588222', '588227', '589298', '589312', '589683',
        '589692', '590080', '590093', '590576', '590579', '590614', '590618', '590619', '590626', '590627', '590628',
        '590898', '590899', '590914', '590915', '591047', '591048', '591300', '591308', '592303', '592352', '592356',
        '592399', '592903', '592904', '592909', '592910', '593090', '593820', '593827', '593848', '594056', '594061',
        '594158', '594162', '594480', '594481', '594482', '594483', '594844', '594844', '594845', '594845', '594846',
        '594847', '594953', '594960', '594991', '594991', '594993', '594993', '594994', '594995', '595444', '595449',
        '595451', '595692', '595710', '595713', '595714', '595841', '595863', '595864', '596010',
    }


class Antiretrovirals(ValueSet):
    VALUE_SET_NAME = 'Antiretrovirals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150887', '151332', '151661', '153357', '155427', '156136', '157172', '158370', '164336', '164367', '164471',
        '166359', '173863', '176222', '176935', '182635', '182833', '183601', '190554', '190554', '197324', '198147',
        '199517', '199536', '199842', '200565', '201661', '202308', '209905', '211256', '212012', '212078', '213291',
        '217041', '227763', '229021', '235809', '237220', '237887', '237976', '241914', '243165', '244816', '247256',
        '247898', '249427', '254026', '262840', '266382', '266488', '267097', '268222', '268512', '270511', '271580',
        '279164', '279743', '282309', '282484', '283252', '288259', '291059', '291169', '291169', '291326', '294847',
        '295121', '296447', '299474', '400094', '400684', '400684', '401010', '446414', '446426', '449789', '450226',
        '450227', '450407', '450408', '450616', '450627', '452983', '452995', '467806', '471230', '471231', '471246',
        '471287', '472805', '473165', '474438', '474439', '475260', '475556', '475557', '475741', '545873', '545875',
        '547362', '547401', '552320', '552323', '552327', '552334', '552491', '552492', '553119', '553124', '553459',
        '553464', '554090', '554092', '554419', '554984', '556217', '556288', '556616', '556620', '557332', '557335',
        '558314', '558362', '560479', '560490', '563113', '563119', '563771', '563772', '564311', '564313', '565605',
        '565609', '569498', '569499', '569906', '570003', '570004', '570005', '570007', '570013', '570014', '570015',
        '570016', '570742', '570746', '572347', '572351', '574877', '574883', '575072', '575073', '575964', '575972',
        '577381', '577541', '577542', '579487', '579507', '580523', '581739', '581864', '582414', '582420', '582741',
        '582742', '583084', '583086', '583453', '583740', '583741', '583821', '583822', '588222', '588227', '589683',
        '589692', '590080', '590093', '590614', '590618', '590619', '590626', '590627', '590628', '590898', '590899',
        '590914', '590915', '592399', '592903', '592904', '592909', '592910', '593820', '593827', '593848', '594953',
        '594960', '595444', '595449', '595451', '595692', '595710', '595713', '595714', '595841', '595863', '595864',
    }


class AntiretroviralProteaseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Antiretroviral - Protease Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151661', '164336', '164471', '176935', '200565', '201661', '202308', '209905', '235809', '237887', '243165',
        '279164', '449789', '450226', '450227', '450407', '450408', '452983', '452995', '467806', '472805', '473165',
        '474438', '474439', '547362', '547401', '552320', '552323', '554419', '554984', '556217', '556288', '556616',
        '556620', '557332', '557335', '558314', '558362', '560479', '560490', '569906', '575964', '575972', '577381',
        '581739', '583084', '583086', '583453', '583821', '583822',
    }


class AntiretroviralNucleosideReverseTranscriptaseInhibitorsNrti(ValueSet):
    VALUE_SET_NAME = 'Antiretroviral - Nucleoside Reverse Transcriptase Inhibitors (NRTI)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150887', '151332', '155427', '157172', '176222', '182635', '182833', '183601', '197324', '199517', '199842',
        '213291', '227763', '237220', '241914', '244816', '247256', '249427', '254026', '262840', '266488', '267097',
        '268222', '270511', '271580', '279743', '282309', '282484', '288259', '291059', '291326', '294847', '295121',
        '296447', '299474', '400684', '400684', '446414', '446426', '450616', '450627', '475260', '475741',
    }


class AntiretroviralNonNucleosideReverseTranscriptaseInhibNnrti(ValueSet):
    VALUE_SET_NAME = 'Antiretroviral - Non-Nucleoside Reverse Transcriptase Inhib (NNRTI)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153357', '158370', '164367', '190554', '190554', '199536', '211256', '229021', '237976', '247898', '266382',
        '283252', '291169', '291169', '400094', '401010', '554090', '554092', '563113', '563119', '563771', '563772',
        '564311', '564313', '572347', '572351', '577541', '577542',
    }


class AntiretroviralCombinations(ValueSet):
    VALUE_SET_NAME = 'Antiretroviral Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156136', '166359', '173863', '198147', '212012', '217041', '471230', '471231', '471246', '471287', '475556',
        '475557', '545873', '545875', '553459', '553464', '565605', '565609', '574877', '574883', '582414', '582420',
        '588222', '588227', '589683', '589692', '590080', '590093', '590614', '590618', '590619', '590626', '590627',
        '590628', '594953', '594960', '595444', '595449', '595451', '595713', '595714', '595841', '595863', '595864',
    }


class CmvAntiviralAgents(ValueSet):
    VALUE_SET_NAME = 'CMV Antiviral Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153645', '153888', '157686', '164470', '165634', '239600', '239600', '252070', '265155', '560325', '560332',
        '593090', '594844', '594844', '594845', '594845', '594846', '594847', '594991', '594991', '594993', '594993',
        '594994', '594995', '596010',
    }


class HepatitisAgents(ValueSet):
    VALUE_SET_NAME = 'Hepatitis Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157130', '166544', '169374', '175985', '182458', '184850', '208776', '222692', '232143', '270621', '278653',
        '288003', '288747', '290845', '446297', '446299', '446515', '446518', '448274', '448275', '453876', '453883',
        '454276', '454276', '454277', '454277', '454278', '454278', '454279', '454279', '467548', '473714', '473715',
        '473716', '473724', '473725', '473738', '473738', '473739', '473739', '473740', '473740', '473741', '473741',
        '474060', '475839', '475840', '475841', '475842', '475843', '475855', '475855', '475857', '475858', '475871',
        '475871', '475872', '475872', '475875', '475876', '475877', '475878', '547482', '547484', '565865', '565866',
        '567564', '567565', '567604', '567605', '572511', '572511', '572513', '580375', '580384', '580418', '580421',
        '580572', '582814', '582819', '583457', '583466', '586387', '586584', '586615', '586776', '586779', '586797',
        '589298', '589312', '590576', '590579', '591047', '591048', '591300', '591308', '592352', '592356', '594056',
        '594061', '594158', '594162', '594480', '594481', '594482', '594483',
    }


class HepatitisCTherapyCombinations(ValueSet):
    VALUE_SET_NAME = 'Hepatitis C Therapy Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '582814', '582819', '583457', '583466', '586387', '586797', '589298', '589312', '591047', '591048', '591300',
        '591308', '594056', '594061', '594158', '594162',
    }


class HerpesAntiviralAgents(ValueSet):
    VALUE_SET_NAME = 'Herpes Antiviral Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157284', '165277', '171370', '176927', '180384', '180384', '203395', '204203', '207871', '209280', '212245',
        '213140', '223107', '227082', '235677', '254785', '256157', '257046', '257099', '266189', '269371', '293003',
        '575866', '581592', '581595', '592303',
    }


class HerpesAntiviralAgentPurineAnalogs(ValueSet):
    VALUE_SET_NAME = 'Herpes Antiviral Agent - Purine Analogs'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157284', '165277', '176927', '180384', '180384', '203395', '204203', '207871', '209280', '212245', '254785',
        '256157', '257046', '257099', '266189', '269371', '575866', '581592', '581595', '592303',
    }


class HerpesAntiviralAgentThymidineAnalogs(ValueSet):
    VALUE_SET_NAME = 'Herpes Antiviral Agent - Thymidine Analogs'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '171370', '213140', '223107', '227082', '235677', '293003',
    }


class InfluenzaAAndBAntiviralAgents(ValueSet):
    VALUE_SET_NAME = 'Influenza-A and B Antiviral Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151732', '170886', '204519', '239315', '553092', '553093', '553103', '553104', '559651', '564987', '564993',
        '583456',
    }


class AntiviralMiscellaneousAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Antiviral Miscellaneous and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class HepatitisCNucleosideAnalogAndInterferonCombinations(ValueSet):
    VALUE_SET_NAME = 'Hepatitis C - Nucleoside Analog and Interferon Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AmebicidesAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Amebicides and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '267096',
    }


class Anthelmintic(ValueSet):
    VALUE_SET_NAME = 'Anthelmintic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157338', '167913', '206878', '217749', '224627', '224627', '229388', '245234', '254708', '429151', '467377',
        '467377', '467378', '467378', '547796', '547824', '589775',
    }


class PolymyxinAntibioticsAndDerivatives(ValueSet):
    VALUE_SET_NAME = 'Polymyxin Antibiotics and Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156626', '161166', '179734', '278128', '429154',
    }


class StreptograminAntibiotics(ValueSet):
    VALUE_SET_NAME = 'Streptogramin Antibiotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '184470', '268726',
    }


class AntileproticAgents(ValueSet):
    VALUE_SET_NAME = 'Antileprotic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156944', '156944', '156944', '156944', '235901', '235901', '235901', '235901', '239053', '239053', '249946',
        '249946', '448888', '448888', '448890', '448890', '448892', '448892', '448893', '448893', '550238', '550238',
        '550256', '550256',
    }


class FolateAntagonistAntibiotics(ValueSet):
    VALUE_SET_NAME = 'Folate Antagonist Antibiotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '170540', '175758', '188329', '188329', '188329', '203221', '204475', '204885', '257459', '274224', '429198',
        '443690', '471264', '594545',
    }


class Vaccines(ValueSet):
    VALUE_SET_NAME = 'Vaccines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '170732', '170732', '174955', '179331', '203251', '212473', '215954', '227641', '238977', '262179', '275471',
        '288234', '292799', '292799', '299076', '444068', '444598', '445152', '445777', '448473', '453711', '470793',
        '473306', '474063', '474064', '474071', '474072', '474353', '474994', '474999', '476398', '476399', '545381',
        '545383', '545432', '545509', '545510', '545511', '545512', '549320', '549344', '549498', '550427', '550433',
        '550842', '550843', '550846', '550849', '550982', '550990', '551055', '551058', '551104', '551121', '551446',
        '551453', '551512', '551515', '551553', '551554', '551561', '551731', '552210', '552317', '552643', '552650',
        '553824', '553841', '554043', '554155', '554334', '554366', '554367', '554368', '554684', '554686', '554688',
        '554741', '554838', '554842', '554852', '554853', '554854', '554855', '554856', '554885', '554926', '555029',
        '555047', '555048', '555051', '555052', '555053', '555245', '555292', '555309', '555347', '555358', '555375',
        '555376', '555396', '555397', '556218', '558948', '558951', '559100', '559582', '559591', '560304', '560319',
        '560594', '560605', '560655', '560671', '561995', '563308', '569361', '569362', '573004', '573098', '573268',
        '573271', '573294', '573295', '573532', '574098', '575454', '577225', '579413', '579460', '579462', '579465',
        '580666', '581247', '581248', '581926', '581933', '581934', '581935', '581936', '581937', '581938', '581939',
        '581940', '581941', '581942', '581943', '581944', '581946', '581947', '581948', '581949', '581950', '581951',
        '581953', '581954', '581955', '581958', '581959', '581961', '581968', '581969', '581975', '581983', '581986',
        '581988', '581990', '581992', '582060', '582193', '582196', '582197', '582332', '582341', '583131', '583133',
        '583374', '583375', '583379', '583382', '585227', '585228', '585230', '585231', '585376', '585381', '585595',
        '585596', '585597', '585836', '585853', '585872', '586276', '586277', '586287', '586401', '586402', '586407',
        '586408', '586412', '586414', '586438', '586439', '586440', '586456', '586457', '586460', '586461', '586463',
        '586464', '586622', '586673', '587013', '587065', '587110', '588142', '588235', '589865', '589867', '589868',
        '589870', '589871', '589872', '589974', '589976', '590004', '590044', '590564', '590606', '590736', '590822',
        '590913', '590923', '590980', '591082', '591083', '591084', '591087', '591088', '591090', '591091', '591092',
        '591093', '591094', '591095', '591096', '591098', '591099', '591100', '591123', '591497', '591503', '591510',
        '591515', '591516', '591531', '591647', '591650', '591656', '591657', '592443', '593408', '593409', '593410',
        '593432', '593441', '593444', '593445', '593451', '593538', '593545', '593707', '593720', '593726', '593734',
        '593744', '593745', '593746', '593748', '593749', '593895', '593915', '593916', '593917', '593936', '593937',
        '593967', '593968', '593969', '593972', '593973', '593974', '593975', '593985', '593986', '593988', '594011',
        '594020', '594021', '594022', '594452', '594695', '594723', '594930', '595064',
    }


class VaccinesViral(ValueSet):
    VALUE_SET_NAME = 'Vaccines - Viral'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '174955', '212473', '275471', '444598', '470793', '474994', '474999', '476398', '476399', '545381', '545383',
        '545432', '545509', '545510', '545511', '545512', '549320', '549344', '550427', '550433', '550842', '550843',
        '550846', '550849', '550982', '550990', '551055', '551058', '551104', '551121', '551446', '551453', '551512',
        '551515', '551553', '551554', '551561', '551731', '552210', '552317', '552643', '552650', '554688', '554741',
        '554852', '554853', '554854', '554855', '554856', '554926', '555029', '555047', '555048', '555051', '555052',
        '555053', '555245', '555292', '555309', '558948', '558951', '559582', '559591', '573004', '573098', '573268',
        '573271', '573294', '573295', '573532', '579460', '579462', '579465', '581926', '581933', '581934', '581935',
        '581936', '581937', '581938', '581939', '581940', '581941', '581942', '581943', '581944', '581946', '581947',
        '581948', '581949', '581950', '581951', '581953', '581954', '581955', '581958', '581959', '581961', '581968',
        '581969', '581975', '581983', '581986', '581988', '581990', '581992', '582060', '582193', '582196', '582197',
        '582332', '582341', '583374', '583375', '583379', '583382', '585227', '585228', '585230', '585231', '585376',
        '585381', '585595', '585596', '585597', '585836', '585853', '585872', '586276', '586277', '586287', '586401',
        '586402', '586407', '586408', '586412', '586414', '586438', '586439', '586440', '586456', '586457', '586460',
        '586461', '586463', '586464', '586622', '586673', '587013', '587065', '587110', '588142', '588235', '589865',
        '589867', '589868', '589870', '589871', '589872', '589974', '589976', '590004', '590044', '590564', '590606',
        '590736', '590822', '590913', '591082', '591083', '591084', '591087', '591088', '591090', '591091', '591092',
        '591093', '591094', '591095', '591096', '591098', '591099', '591100', '591123', '591497', '591503', '591510',
        '591515', '591516', '591531', '591647', '591650', '591656', '591657', '592443', '593408', '593409', '593410',
        '593432', '593441', '593444', '593445', '593451', '593538', '593545', '593707', '593720', '593726', '593734',
        '593744', '593745', '593746', '593748', '593749', '593895', '593915', '593916', '593917', '593936', '593937',
        '593967', '593968', '593969', '593972', '593973', '593974', '593975', '593985', '593986', '593988', '594011',
        '594020', '594021', '594022', '594452', '594695', '594723', '594930', '595064',
    }


class VaccineViralCombinations(ValueSet):
    VALUE_SET_NAME = 'Vaccine Viral Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '474994', '474999', '554741', '554926',
    }


class VaccinesBacterial(ValueSet):
    VALUE_SET_NAME = 'Vaccines - Bacterial'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '170732', '170732', '179331', '203251', '238977', '262179', '288234', '292799', '292799', '299076', '444068',
        '445152', '445777', '448473', '473306', '554043', '554155', '554684', '554686', '554885', '559100', '560304',
        '560319', '560594', '560605', '560655', '560671', '561995', '563308', '575454', '577225', '579413', '581247',
        '581248', '583131', '583133', '590923', '590980',
    }


class VaccineMixedCombinationsBacterialAndViral(ValueSet):
    VALUE_SET_NAME = 'Vaccine Mixed Combinations (Bacterial and Viral)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '555347', '555358',
    }


class ToxoidVaccines(ValueSet):
    VALUE_SET_NAME = 'Toxoid Vaccines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '215954', '227641', '453711', '474063', '474064', '474071', '474072', '474353', '549498', '553824', '553841',
        '554334', '554366', '554367', '554368', '554838', '554842', '555375', '555376', '555396', '555397', '556218',
        '569361', '569362', '574098', '580666',
    }


class ToxoidVaccineCombinations(ValueSet):
    VALUE_SET_NAME = 'Toxoid Vaccine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '215954', '227641', '453711', '474063', '474064', '474071', '474072', '474353', '549498', '553824', '553841',
        '554334', '554366', '554367', '554368', '554838', '554842', '555375', '555376', '555396', '555397', '556218',
        '569361', '569362', '574098', '580666',
    }


class PassiveImmunizingAgents(ValueSet):
    VALUE_SET_NAME = 'Passive Immunizing Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152170', '171685', '174783', '177770', '196973', '199599', '215286', '215286', '220057', '227280', '227481',
        '234590', '241499', '262559', '283399', '445582', '448977', '448978', '464129', '467373', '468245', '468359',
        '468359', '468359', '468359', '468359', '474349', '474350', '474354', '474355', '474469', '474469', '474469',
        '474469', '474469', '474469', '475289', '475289', '475753', '475754', '475755', '475758', '475758', '476534',
        '476535', '476536', '476537', '476540', '476541', '476542', '476543', '507779', '507779', '545102', '545103',
        '545105', '545106', '549616', '549617', '549797', '549798', '549806', '549825', '550199', '550201', '550202',
        '550231', '550485', '550736', '550736', '550736', '550736', '550736', '550922', '550923', '552581', '552582',
        '554085', '554085', '554085', '554085', '554945', '560788', '560789', '560790', '560795', '560796', '560797',
        '560958', '560958', '560958', '562547', '562547', '562547', '562810', '562811', '562812', '562813', '562814',
        '562843', '562844', '562845', '562858', '562859', '564836', '565595', '565596', '565597', '565598', '565599',
        '566004', '566011', '576409', '576409', '579013', '579866', '579873', '582100', '582100', '582100', '582100',
        '582458', '582458', '582458', '582458', '582579', '582590', '582591', '582592', '582593', '582602', '582603',
        '582604', '582605', '582606', '582950', '582971', '584112', '584112', '584112', '584112', '584112', '584113',
        '584113', '584113', '584297', '584297', '584297', '584297', '584297', '584300', '584300', '584302', '584302',
        '584302', '584302', '584302', '584302', '584303', '584303', '584303', '584303', '584767', '584768', '584774',
        '584775', '585914', '585932', '589778', '589779', '591866', '591867', '591868', '591869', '591877', '591878',
        '591879', '591880', '591970', '591970', '591970', '592287', '592439', '593327', '593327', '593327', '593330',
        '593330', '593330', '595974', '595974', '596005', '596005',
    }


class ImmuneSerums(ValueSet):
    VALUE_SET_NAME = 'Immune Serums'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '196973', '227280', '234590', '283399', '579013',
    }


class AntitoxinsAntivenins(ValueSet):
    VALUE_SET_NAME = 'Antitoxins-Antivenins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152170', '171685', '241499', '262559', '566004', '566011',
    }


class MonoclonalAntibodies(ValueSet):
    VALUE_SET_NAME = 'Monoclonal Antibodies'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '474349', '474350', '474354', '474355', '592287', '592439',
    }


class AntiviralMonoclonalAntibodies(ValueSet):
    VALUE_SET_NAME = 'Antiviral Monoclonal Antibodies'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '474349', '474350', '474354', '474355',
    }


class PassiveImmunizingAgentCombinations(ValueSet):
    VALUE_SET_NAME = 'Passive Immunizing Agent Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AllergenicExtractOthers(ValueSet):
    VALUE_SET_NAME = 'Allergenic Extract Others'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '471353', '471393', '586903', '586903', '590123', '590134', '590261', '590281', '590297', '590344',
    }


class MixedAllergenicExtracts(ValueSet):
    VALUE_SET_NAME = 'Mixed Allergenic Extracts'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Antineoplastics(ValueSet):
    VALUE_SET_NAME = 'Antineoplastics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150345', '152057', '152606', '152606', '152606', '153568', '155359', '156213', '156213', '157412', '157548',
        '157548', '157712', '157978', '157986', '158026', '158200', '158222', '160337', '161566', '161863', '161975',
        '162365', '162470', '162669', '162669', '163416', '163565', '164280', '165678', '165827', '166679', '166878',
        '167224', '169622', '170058', '170693', '170693', '171250', '171640', '171779', '172462', '172836', '173371',
        '174031', '174858', '174904', '175078', '176115', '176219', '177896', '178584', '178799', '180595', '181214',
        '181528', '181642', '182243', '183826', '184492', '187121', '187121', '187121', '187245', '188741', '189136',
        '189495', '190327', '190690', '191147', '191235', '191415', '191415', '192104', '194271', '194271', '194271',
        '194403', '194698', '195534', '195534', '196296', '196385', '198659', '198876', '200223', '201866', '202971',
        '204163', '204337', '204337', '205813', '206377', '207720', '208202', '208422', '208809', '210225', '210604',
        '211589', '213114', '214082', '216414', '217683', '218088', '218314', '218328', '218992', '221353', '222247',
        '222487', '222555', '223871', '224334', '224631', '225691', '226954', '227567', '227625', '227770', '228489',
        '230894', '231771', '231771', '231771', '231912', '232098', '232098', '232098', '232539', '232584', '232681',
        '233229', '236285', '236383', '236649', '236649', '237131', '240247', '241255', '241436', '242663', '242663',
        '243119', '243178', '243315', '243315', '243315', '243943', '246262', '248083', '248083', '248083', '248091',
        '248262', '249041', '251124', '251571', '251965', '252210', '252545', '254486', '254486', '254486', '254490',
        '254695', '254695', '254695', '255029', '257262', '258049', '258110', '258513', '259340', '259505', '260561',
        '260722', '260726', '260741', '262343', '262473', '262980', '263281', '263821', '264552', '265375', '265418',
        '268141', '269137', '270229', '270624', '275337', '277415', '277415', '277415', '277415', '278100', '278509',
        '278912', '280267', '281370', '281370', '283260', '283331', '283331', '286032', '286032', '286032', '286064',
        '286361', '287154', '287806', '288267', '288267', '288989', '289232', '290333', '290697', '291067', '291116',
        '291340', '291402', '291855', '293034', '293278', '296968', '297623', '298252', '298373', '298373', '298590',
        '298653', '400481', '429324', '429325', '443495', '443500', '443588', '443593', '445397', '445401', '446039',
        '446040', '446125', '446131', '446731', '448699', '448699', '448699', '448699', '448699', '448839', '448841',
        '449624', '449627', '449719', '449727', '450049', '450049', '450050', '450055', '450056', '450056', '451487',
        '451487', '451487', '451487', '454311', '454312', '454505', '454505', '454506', '454506', '469479', '469502',
        '469797', '469800', '471753', '472449', '472450', '472521', '472522', '472523', '472526', '472527', '472528',
        '472892', '472949', '473063', '473096', '473180', '473213', '473323', '473325', '474189', '474190', '474205',
        '474206', '475150', '475567', '475586', '475595', '475596', '475988', '475989', '476057', '476058', '476070',
        '476071', '476303', '476305', '476306', '476307', '476308', '476309', '476310', '545328', '545331', '545745',
        '545746', '545747', '545753', '545754', '545755', '545769', '545770', '545771', '545772', '545814', '546542',
        '546549', '547060', '547099', '550108', '550115', '550486', '550486', '550486', '550487', '550487', '550487',
        '550492', '550492', '550492', '550493', '550493', '550493', '551447', '551474', '551571', '551577', '552212',
        '552213', '553161', '553162', '553167', '553168', '553343', '553351', '553997', '553999', '554205', '554206',
        '554232', '554425', '554575', '554629', '554630', '554645', '554662', '554887', '554889', '555174', '555175',
        '555250', '555251', '555513', '555524', '555545', '555546', '555547', '555547', '555548', '555548', '555551',
        '555552', '555553', '556012', '556025', '556110', '556111', '556113', '556235', '556236', '556252', '556253',
        '556301', '556303', '556310', '556311', '556312', '556441', '556553', '556554', '556555', '556832', '556833',
        '556938', '556939', '557475', '557475', '557484', '557484', '557619', '557620', '557767', '557768', '557774',
        '557775', '557864', '558833', '559410', '559411', '559430', '559431', '559670', '559675', '559688', '559693',
        '560113', '560119', '560806', '560816', '561039', '561045', '561232', '561234', '561572', '561573', '561615',
        '561616', '561669', '561674', '562387', '562388', '562393', '562394', '562644', '562650', '562669', '562706',
        '562725', '562728', '563105', '563106', '563110', '563111', '563255', '563592', '563593', '563594', '563671',
        '563672', '563673', '563674', '563843', '563844', '563845', '563851', '563853', '563855', '563861', '563862',
        '564110', '564112', '564135', '564139', '564146', '564299', '564300', '564303', '564305', '564564', '564566',
        '564850', '564865', '565161', '565162', '565744', '565766', '565975', '565996', '566092', '566093', '566098',
        '566099', '567845', '567846', '567847', '568547', '568548', '568549', '568550', '568551', '568554', '568555',
        '568556', '568557', '568559', '568633', '568667', '569834', '569848', '569883', '570177', '570178', '570218',
        '570240', '570242', '570243', '570478', '570481', '570750', '570760', '570842', '572059', '572074', '572298',
        '573156', '573162', '573733', '573927', '573941', '574499', '574501', '574527', '574529', '574871', '575010',
        '575032', '575066', '575067', '575164', '575165', '575410', '575414', '575825', '575825', '575826', '575826',
        '575990', '576001', '576344', '576345', '576424', '576426', '576430', '576446', '576447', '576666', '576667',
        '576668', '576985', '576986', '576987', '576989', '577004', '577005', '577006', '577007', '577187', '577188',
        '577190', '577191', '577902', '577906', '578093', '578094', '578095', '578100', '578101', '578102', '578543',
        '578547', '578621', '578622', '578628', '578629', '578702', '578742', '578764', '578765', '578852', '578854',
        '579190', '579191', '579192', '579227', '579569', '579570', '579571', '579588', '579868', '579869', '580183',
        '580186', '580309', '580313', '581445', '581446', '581472', '581472', '581479', '581479', '581482', '581517',
        '581574', '581625', '581625', '581625', '581625', '581662', '581663', '581719', '581882', '581889', '582030',
        '582076', '582143', '582144', '582154', '582155', '582463', '582466', '582925', '582926', '582927', '582928',
        '583349', '583350', '583452', '583465', '583477', '583478', '583479', '583481', '583706', '583717', '583723',
        '583724', '583725', '583860', '583861', '583862', '583871', '583872', '583874', '584041', '584042', '584043',
        '584044', '584084', '584085', '584086', '584087', '584210', '584284', '584285', '584286', '584294', '584295',
        '584296', '585259', '585259', '585821', '586000', '586001', '586124', '586263', '586840', '586896', '587585',
        '587586', '587591', '587592', '587814', '587882', '587883', '587904', '587922', '587923', '588023', '588033',
        '588111', '588112', '588121', '588122', '588236', '588241', '588268', '588286', '588300', '588301', '588304',
        '588305', '588343', '588343', '588362', '588362', '588413', '588414', '588415', '588418', '588420', '588421',
        '588458', '588490', '588495', '588496', '588501', '588502', '588584', '588644', '588644', '588647', '588652',
        '588659', '588699', '588699', '589926', '590218', '590219', '590219', '590220', '590220', '590221', '590222',
        '590223', '590223', '590224', '590224', '590225', '590329', '590330', '590331', '590335', '590336', '590337',
        '590622', '590624', '590662', '590663', '590747', '590748', '590932', '590954', '591165', '591907', '592031',
        '592203', '592203', '592226', '592226', '592316', '592591', '592592', '592602', '592603', '593231', '593237',
        '593238', '593245', '593246', '593247', '593309', '593310', '593315', '593322', '593333', '593479', '593510',
        '593512', '593523', '593524', '593525', '593525', '593528', '593529', '593529', '593534', '593534', '593541',
        '593541', '593590', '593591', '593592', '593602', '593603', '593604', '593708', '593717', '593742', '593883',
        '593890', '593891', '594012', '594045', '594131', '594137', '594138', '594139', '594143', '594144', '594213',
        '594215', '594249', '594250', '594251', '594252', '594253', '594254', '594344', '594349', '594355', '594357',
        '594420', '594424', '594535', '594536', '594537', '594538', '594546', '594547', '594548', '594549', '594667',
        '594669', '594789', '594792', '595027', '595032', '595033', '595057', '595073', '595169', '595175', '595196',
        '595205', '595206', '595215', '595216', '595370', '595375', '595509', '595516', '595568', '595569', '595570',
        '595571', '595587', '595588', '595589', '595590', '595597', '595600', '595770', '595835', '595838',
    }


class AntineoplasticAlkylatingAgents(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Alkylating Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157412', '161863', '167224', '172462', '172836', '174031', '174858', '176219', '177896', '178584', '183826',
        '187121', '187121', '187121', '189495', '191415', '191415', '194271', '194271', '194271', '194403', '195534',
        '195534', '198659', '205813', '206377', '208422', '211589', '213114', '216414', '217683', '221353', '222487',
        '227567', '236285', '243119', '251965', '252210', '254486', '254486', '254486', '260741', '262980', '269137',
        '278100', '283331', '283331', '286032', '286032', '286032', '290333', '291116', '293278', '298653', '550486',
        '550486', '550486', '550487', '550487', '550487', '550492', '550492', '550492', '550493', '550493', '550493',
        '552212', '552213', '554645', '554662', '557619', '557620', '560113', '560119', '569834', '569848', '579868',
        '579869', '582925', '582926', '582927', '582928', '583723', '583724', '583725', '584210', '586000', '586001',
        '588236', '588241', '588584', '588647', '589926', '591907',
    }


class AntineoplasticAlkylatingAgentNitrogenMustards(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Alkylating Agent - Nitrogen Mustards'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157412', '167224', '172836', '174031', '177896', '178584', '206377', '213114', '217683', '236285', '243119',
        '252210', '269137', '278100', '290333', '552212', '552213', '579868', '579869', '589926', '591907',
    }


class AntineoplasticAlkylatingAgentNitrosoureas(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Alkylating Agent - Nitrosoureas'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161863', '172462', '189495', '211589', '216414', '222487', '260741', '583723', '583724', '583725', '588236',
        '588241',
    }


class AntineoplasticAntibiotics(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic Antibiotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152057', '155359', '169622', '174904', '222247', '224631', '233229', '243178', '270229', '275337', '288989',
        '291340', '591165', '595770',
    }


class AntineoplasticAntimetabolites(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Antimetabolites'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150345', '157986', '165678', '165827', '166679', '171250', '171779', '173371', '181528', '190327', '190690',
        '200223', '202971', '204337', '204337', '214082', '227625', '227770', '228489', '232681', '237131', '240247',
        '241436', '243943', '248091', '249041', '251571', '254490', '258513', '260722', '260726', '263281', '278912',
        '448699', '448699', '448699', '448699', '448699', '454311', '454312', '469479', '469502', '471753', '472892',
        '472949', '475567', '476303', '545328', '545331', '553997', '553999', '555545', '555546', '555547', '555547',
        '555548', '555548', '555551', '555552', '555553', '557864', '558833', '559410', '559411', '559430', '559431',
        '562669', '562706', '567845', '567846', '567847', '581574', '581625', '581625', '581625', '581625', '581719',
        '587585', '587586', '587591', '587592', '593512', '593742',
    }


class AntineoplasticAntibodyAntibodyDrugComplexes(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Antibody/Antibody-Drug Complexes'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160337', '196385', '242663', '242663', '288267', '288267', '400481', '446731', '454505', '454505', '454506',
        '454506', '473096', '473180', '556111', '556113', '556301', '556303', '556832', '556833', '556938', '556939',
        '559670', '559675', '563671', '563672', '563673', '563674', '564850', '564865', '565975', '565996', '573156',
        '573162', '577187', '577188', '577190', '577191', '577902', '577906', '580183', '580186', '581445', '581446',
        '581472', '581472', '581479', '581479', '581662', '581663', '583349', '583350', '585821', '586263', '588343',
        '588343', '588362', '588362', '588458', '588490', '588495', '588496', '588501', '588502', '592203', '592203',
        '592226', '592226', '593510', '593883', '593890', '593891', '594249', '594252', '594355', '594357',
    }


class AntineoplasticMonoclonalAntibodies(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Monoclonal Antibodies'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160337', '196385', '242663', '242663', '288267', '288267', '400481', '446731', '454505', '454505', '454506',
        '454506', '473096', '473180', '556111', '556113', '556301', '556303', '556832', '556833', '556938', '556939',
        '559670', '559675', '563671', '563672', '563673', '563674', '564850', '564865', '573156', '573162', '577902',
        '577906', '580183', '580186', '581445', '581446', '581472', '581472', '581479', '581479', '581662', '581663',
        '583349', '583350', '585821', '586263', '588343', '588343', '588362', '588362', '588458', '588490', '588495',
        '588496', '588501', '588502', '592203', '592203', '592226', '592226', '593510', '593883', '593890', '593891',
    }


class AntineoplasticHormoneHormoneAntagonistAgents(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Hormone/Hormone Antagonist Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157712', '157978', '158200', '162365', '163565', '164280', '170058', '170693', '170693', '175078', '182243',
        '189136', '218328', '226954', '230894', '232539', '241255', '246262', '252545', '257262', '258049', '259505',
        '260561', '262473', '265375', '278509', '283260', '286064', '291067', '291402', '298373', '298373', '443495',
        '443500', '443588', '443593', '446125', '446131', '448839', '448841', '469797', '469800', '472449', '472450',
        '473323', '473325', '475150', '475586', '545814', '555174', '555175', '555250', '555251', '557475', '557475',
        '557484', '557484', '561039', '561045', '564110', '564112', '564135', '564139', '564564', '564566', '575010',
        '575032', '575825', '575825', '575826', '575826', '593309', '593310', '595509', '595516',
    }


class AntineoplasticAndrogens(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Androgens'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntineoplasticAntiadrenals(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Antiadrenals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '162365', '163565',
    }


class AntineoplasticAntiandrogens(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Antiandrogens'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158200', '170058', '218328', '230894', '286064', '564110', '564112', '575010', '575032', '593309', '593310',
        '595509', '595516',
    }


class AntineoplasticSelectiveEstrogenReceptorModulatorsSerms(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Selective Estrogen Receptor Modulators (SERMs)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '232539', '259505', '265375', '291067', '475586', '545814',
    }


class AntineoplasticAromataseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Aromatase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157712', '226954', '246262', '258049', '262473', '278509',
    }


class AntineoplasticEstrogens(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Estrogens'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157978', '175078',
    }


class AntineoplasticProgestins(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Progestins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '182243', '252545', '283260', '475150',
    }


class AntineoplasticLhrhGnrhAgonistAnalogPituitarySuppressants(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - LHRH (GnRH) Agonist Analog Pituitary Suppressants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164280', '170693', '170693', '189136', '241255', '257262', '260561', '291402', '298373', '298373', '443588',
        '443593', '446125', '446131', '448839', '448841', '469797', '469800', '472449', '472450', '473323', '473325',
        '555174', '555175', '555250', '555251', '561039', '561045', '564135', '564139', '564564', '564566',
    }


class AntineoplasticMitoticInhibitors(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Mitotic Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '171640', '184492', '208202', '258110', '277415', '277415', '277415', '277415', '286361', '473063', '473213',
        '553161', '553162', '553167', '553168', '556012', '556025', '556110', '561615', '561616', '562387', '562388',
        '562393', '562394', '562644', '562650', '563592', '563593', '563594', '564146', '564299', '564300', '564303',
        '564305', '570750', '573733', '574871', '579227', '579588', '586124',
    }


class AntineoplasticTopoisomeraseIInhibitors(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Topoisomerase I Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '162470', '198876', '225691', '554205', '554206', '554232', '554425', '556235', '556236', '556252', '556253',
        '562725', '562728', '563255', '588023', '588033',
    }


class AntineoplasticRadiopharmaceuticals(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Radiopharmaceuticals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '262343', '297623', '551447', '551474', '578543', '578547', '587814', '587882', '587883', '587904', '587922',
        '587923', '595370', '595375',
    }


class AntineoplasticOthers(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Others'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '575990', '576001',
    }


class AntineoplasticInterleukins(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Interleukins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '181642', '210604',
    }


class AntineoplasticPhotosensitizers(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Photosensitizers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158026', '280267', '298252', '298590',
    }


class AntineoplasticSelectiveRetinoidXReceptorAgonists(ValueSet):
    VALUE_SET_NAME = 'Antineoplastic - Selective Retinoid X Receptor Agonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '180595', '204163',
    }


class Endocrine(ValueSet):
    VALUE_SET_NAME = 'Endocrine'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150724', '151287', '151292', '152132', '152333', '152333', '152636', '152787', '153056', '153263', '153278',
        '153278', '153666', '154170', '154532', '154757', '154757', '155744', '156080', '156330', '156410', '157005',
        '157276', '157529', '157640', '157766', '158131', '158184', '158290', '159354', '159627', '160093', '160353',
        '160372', '160372', '160372', '160397', '160510', '161242', '161595', '161664', '161689', '162161', '162276',
        '162284', '162412', '162756', '163725', '163934', '163956', '163965', '164094', '164420', '164763', '165084',
        '165256', '165381', '165381', '165381', '165884', '166426', '166726', '167375', '167529', '167620', '168539',
        '168539', '168539', '169278', '169721', '169805', '170020', '170105', '170310', '170678', '170942', '171460',
        '172466', '172747', '172960', '173160', '173334', '173508', '173526', '173537', '174267', '174715', '175194',
        '175321', '175323', '175497', '175584', '175624', '175636', '175684', '175833', '175988', '176377', '176663',
        '176999', '177109', '177822', '178150', '178488', '178540', '179018', '179093', '179253', '180673', '181189',
        '181840', '181840', '182749', '182862', '183447', '183639', '183683', '183692', '183845', '184094', '184161',
        '184164', '184164', '184218', '184359', '184359', '184359', '184359', '184403', '184702', '184728', '184801',
        '185027', '185240', '185398', '185710', '186214', '187057', '187057', '187201', '187414', '187638', '187893',
        '187978', '187978', '187978', '188137', '188137', '188463', '188776', '188801', '189604', '190037', '190801',
        '190997', '191119', '191281', '191281', '191479', '191479', '191657', '191882', '191895', '193096', '193228',
        '193374', '193439', '193439', '193541', '193809', '193809', '194103', '194104', '194779', '195085', '195136',
        '195153', '195644', '195978', '195978', '196223', '196615', '196891', '197476', '197476', '197580', '197879',
        '198209', '198464', '199591', '200004', '200258', '201315', '201987', '202846', '203325', '203325', '203936',
        '204311', '204348', '204481', '204944', '205069', '205075', '205571', '206556', '206599', '206657', '206785',
        '206785', '206983', '207471', '208610', '208723', '208766', '209040', '209301', '209301', '209725', '210179',
        '210382', '210382', '210792', '211063', '211192', '211192', '211395', '212579', '212789', '213323', '213415',
        '213671', '213671', '214116', '214163', '214163', '214163', '214453', '214453', '214727', '215254', '215452',
        '215614', '215684', '215684', '215848', '216262', '216309', '216311', '216445', '216597', '216829', '217047',
        '217056', '217212', '217840', '217840', '217975', '217975', '217975', '218008', '218070', '218450', '218760',
        '218786', '219151', '219340', '219874', '220146', '221849', '223222', '223375', '223375', '223410', '223652',
        '224196', '225034', '225190', '225431', '225440', '226964', '227100', '228241', '228289', '228553', '228553',
        '229157', '229322', '229559', '229941', '229941', '230036', '230050', '230248', '230694', '230701', '231468',
        '231516', '231630', '231812', '231812', '231942', '232437', '232454', '232454', '233226', '233406', '234216',
        '235056', '235158', '235788', '236411', '236491', '236506', '236794', '236794', '236794', '236801', '236937',
        '237259', '237342', '237342', '237361', '237692', '237700', '237800', '237947', '238196', '238196', '238243',
        '238405', '238405', '238405', '238405', '238462', '238759', '238759', '238759', '238865', '239243', '240935',
        '241223', '241713', '241772', '241877', '242128', '242168', '242590', '243102', '243660', '244258', '244319',
        '244441', '245026', '245026', '245044', '245044', '245728', '245851', '246280', '246607', '246671', '246830',
        '246879', '247230', '247652', '248321', '248438', '248438', '248664', '249326', '249446', '249466', '249707',
        '249753', '249753', '250029', '250118', '250245', '250930', '251106', '251390', '251432', '251432', '251464',
        '251871', '252197', '252504', '253167', '253327', '253433', '253589', '253625', '254789', '255488', '255827',
        '256244', '256285', '256373', '256510', '256830', '257084', '257317', '257448', '257528', '257648', '257847',
        '258205', '258730', '259008', '259116', '259589', '260150', '260230', '260567', '261074', '261845', '261882',
        '261937', '261972', '262100', '262924', '262983', '263195', '263224', '263261', '263453', '263667', '263784',
        '264119', '264516', '264576', '264633', '265088', '265365', '265660', '265693', '265693', '265697', '265811',
        '266937', '266970', '267327', '267327', '267993', '268105', '269536', '270520', '270632', '270806', '270962',
        '271006', '271060', '271396', '271418', '272039', '272120', '272192', '272241', '272446', '272997', '273579',
        '273633', '273633', '273633', '274050', '274584', '274811', '274811', '274985', '275126', '275361', '275705',
        '275720', '275734', '275753', '275753', '275849', '275849', '276103', '276633', '276716', '276940', '277023',
        '277383', '277600', '277649', '278108', '278320', '278786', '278921', '278921', '279419', '279619', '279619',
        '279731', '280261', '280359', '281055', '281273', '281538', '281538', '281627', '281746', '282223', '282623',
        '282985', '282990', '283147', '283529', '284337', '284822', '284939', '285641', '285966', '285966', '286168',
        '286763', '286763', '287634', '287988', '288051', '288519', '288639', '288776', '288783', '288985', '289002',
        '289062', '289306', '289485', '290064', '290321', '290331', '290441', '290441', '290503', '290638', '291183',
        '291848', '292010', '292392', '292684', '293032', '293238', '293303', '293442', '293730', '293732', '293937',
        '294017', '294117', '294117', '294764', '295931', '296048', '296237', '296331', '296891', '297239', '297665',
        '297705', '297714', '297944', '297944', '298141', '298160', '299175', '299354', '299729', '299765', '299788',
        '299898', '400802', '400803', '401065', '401095', '401096', '429347', '429348', '429938', '429988', '429988',
        '429988', '429988', '429988', '430036', '430040', '443552', '443594', '443594', '443594', '443594', '443600',
        '443600', '443822', '443925', '444330', '444335', '444336', '444337', '444585', '444606', '445290', '445435',
        '445549', '446054', '446103', '446105', '446304', '446305', '446380', '446476', '446477', '446492', '446493',
        '446596', '446597', '446598', '446891', '448495', '448581', '448582', '448593', '448625', '448935', '449029',
        '449030', '449031', '449033', '449034', '449035', '449441', '449443', '449569', '449605', '449606', '449853',
        '449865', '450233', '450242', '450388', '450398', '450447', '450449', '450451', '450452', '450453', '450717',
        '450718', '450792', '450793', '451579', '451898', '452666', '452812', '453557', '453559', '453574', '453598',
        '453598', '453605', '453605', '453632', '453743', '453751', '454287', '467356', '467357', '467358', '467360',
        '467361', '467362', '467442', '467443', '467447', '467448', '467571', '467970', '467971', '467983', '467985',
        '468272', '468273', '468343', '468383', '468384', '469643', '469774', '469796', '470631', '470632', '470633',
        '470780', '471032', '471162', '471188', '471277', '472243', '472245', '472927', '472928', '472929', '472930',
        '472931', '472932', '472933', '472934', '472935', '472936', '472937', '472938', '472939', '472940', '472941',
        '472942', '472982', '472983', '472984', '472985', '472986', '472987', '472988', '472989', '473147', '473148',
        '473149', '473659', '473667', '473676', '473678', '473748', '473752', '473765', '474050', '474051', '474074',
        '474075', '474208', '474746', '474872', '474875', '474881', '474883', '474986', '474986', '474987', '475043',
        '475044', '475051', '475247', '475248', '475460', '475461', '475467', '475468', '475508', '475536', '475682',
        '475682', '475689', '475863', '475864', '475894', '475895', '475896', '475897', '475898', '475899', '475900',
        '475901', '476076', '476077', '476118', '476214', '476257', '476275', '476474', '476478', '476490', '512120',
        '512122', '512123', '512124', '512125', '512126', '512127', '545001', '545002', '545003', '545004', '545005',
        '545006', '545007', '545008', '545046', '545198', '545213', '545213', '545460', '545461', '545462', '545497',
        '545999', '546006', '546036', '546038', '546101', '546268', '546280', '546283', '546289', '546290', '546293',
        '546319', '546386', '547317', '547319', '547320', '547320', '547328', '547329', '547330', '547330', '547558',
        '547645', '547659', '549002', '549012', '549190', '550474', '550475', '550494', '550530', '550627', '550627',
        '550632', '550632', '550683', '550683', '550683', '550693', '550694', '550750', '550758', '550769', '550839',
        '550848', '550961', '550991', '550992', '551000', '551013', '551017', '551118', '551279', '551279', '551280',
        '551281', '551285', '551287', '551288', '551288', '551529', '551538', '551574', '551704', '551714', '552265',
        '552808', '552825', '553032', '553033', '553034', '553041', '553042', '553043', '553776', '553777', '553838',
        '553839', '553840', '553853', '553871', '553885', '553892', '553893', '553894', '553906', '553907', '553908',
        '553909', '553910', '553911', '553912', '554098', '554106', '554222', '554451', '554470', '554646', '554836',
        '554841', '554886', '554886', '554897', '554897', '555263', '555512', '556341', '556435', '556442', '556535',
        '556560', '556610', '556648', '556899', '556922', '556977', '556978', '556981', '556982', '557533', '557540',
        '557709', '557718', '558037', '558171', '558523', '558576', '558881', '558882', '558883', '558884', '558885',
        '558886', '558887', '558888', '558907', '558909', '558913', '558914', '559769', '559773', '559807', '559832',
        '560076', '560102', '560265', '560271', '560272', '560273', '560274', '560291', '560293', '560294', '560295',
        '560349', '560710', '560711', '560712', '560714', '560715', '560716', '560717', '560718', '560719', '560720',
        '560723', '560724', '560725', '560726', '560727', '560728', '560729', '560730', '560731', '560732', '560854',
        '560856', '560857', '561061', '561062', '561063', '561064', '561070', '561071', '561072', '561088', '561103',
        '561104', '561301', '561331', '561332', '561335', '561336', '561412', '561413', '561840', '561841', '561842',
        '562296', '562321', '562348', '562351', '562352', '562417', '562418', '562419', '562559', '562570', '562572',
        '562575', '562584', '562585', '562586', '562587', '562588', '562592', '562598', '562621', '562648', '562694',
        '562700', '562720', '562721', '563156', '563158', '563314', '563329', '563329', '563545', '563559', '563718',
        '563728', '563729', '563730', '563738', '564127', '564132', '564162', '564170', '564866', '564871', '565095',
        '565109', '565816', '565820', '565826', '565828', '566371', '566379', '567986', '567988', '567989', '568680',
        '569912', '569951', '569987', '570151', '570157', '570207', '570210', '570213', '570251', '570252', '570253',
        '570286', '570287', '570288', '570311', '570312', '570313', '570314', '570316', '570317', '570735', '571126',
        '571127', '571585', '572198', '572200', '572335', '572336', '572337', '572445', '572446', '572447', '573346',
        '573351', '574502', '574506', '574507', '574609', '574649', '574811', '574812', '574813', '574822', '574823',
        '574824', '575116', '575260', '575275', '575378', '575573', '575575', '575584', '575585', '575957', '576267',
        '576268', '576269', '576284', '576360', '576361', '576362', '576772', '576773', '576869', '576870', '576871',
        '576872', '576873', '576874', '576875', '576876', '576877', '576878', '576880', '576881', '576882', '576885',
        '576886', '576887', '576888', '576889', '576890', '576891', '576892', '576893', '577172', '577391', '577413',
        '577414', '577427', '577665', '577665', '577666', '577704', '577705', '577707', '577708', '577709', '577709',
        '577710', '577711', '577739', '577739', '577826', '577826', '577894', '578046', '578230', '578861', '579045',
        '579045', '579345', '579459', '579463', '579464', '579466', '579467', '579468', '580000', '580005', '580015',
        '580027', '580380', '580381', '580382', '580603', '580604', '580662', '580679', '580680', '580681', '580682',
        '580683', '580690', '580695', '580701', '580702', '581038', '581044', '581068', '581124', '581125', '581202',
        '581281', '581378', '581385', '581576', '581645', '581699', '581703', '581704', '581722', '581723', '581724',
        '581725', '581726', '582096', '582250', '582251', '582254', '582255', '582281', '582282', '582283', '582284',
        '582290', '582291', '582292', '582293', '582531', '582532', '582557', '582558', '582681', '582682', '582683',
        '582684', '583003', '583004', '583005', '583006', '583007', '583008', '583009', '583010', '583100', '583100',
        '583105', '583105', '583195', '583196', '583348', '583368', '583436', '583437', '583438', '583468', '583469',
        '583470', '583471', '583472', '583480', '583482', '583483', '583876', '583877', '583888', '583889', '584037',
        '584038', '584039', '584222', '584232', '584417', '584428', '584437', '584440', '584444', '584447', '584690',
        '584836', '584837', '584838', '584839', '584847', '584848', '584849', '584850', '585037', '585038', '585039',
        '585517', '585539', '585540', '585738', '585784', '586164', '586212', '586254', '586256', '586267', '587166',
        '587167', '587168', '587169', '587178', '587182', '587183', '587184', '587256', '587288', '587289', '587355',
        '587379', '587704', '587707', '587732', '587733', '587810', '587901', '588070', '588382', '588717', '589107',
        '589199', '589569', '589569', '589570', '589570', '589701', '589748', '589777', '589793', '590128', '590948',
        '590949', '590957', '590958', '591113', '591128', '591187', '591206', '591211', '591216', '591255', '591289',
        '591290', '591291', '591292', '591357', '591371', '591749', '591750', '591787', '591823', '591835', '591841',
        '591842', '591843', '591844', '591855', '591859', '591860', '591861', '591862', '591954', '592104', '592410',
        '592414', '592417', '592418', '592425', '592438', '592450', '592453', '592469', '592518', '592518', '592520',
        '592534', '592535', '592539', '592581', '592582', '592583', '592584', '592642', '592651', '592978', '592981',
        '592982', '592984', '592993', '592994', '592995', '592996', '592997', '593006', '593006', '593006', '593022',
        '593023', '593027', '593028', '593032', '593033', '593099', '593125', '593126', '593157', '593178', '593180',
        '593181', '593273', '593274', '593318', '593319', '593320', '593321', '593416', '593526', '593527', '593537',
        '593540', '593547', '593566', '593567', '593574', '593664', '593711', '593721', '593727', '593774', '593804',
        '593899', '593900', '593926', '593927', '593987', '594023', '594054', '594058', '594059', '594060', '594161',
        '594170', '594224', '594226', '594345', '594369', '594466', '594479', '594530', '594599', '594600', '594635',
        '594635', '594635', '594806', '594826', '594836', '595028', '595029', '595030', '595031', '595051', '595058',
        '595112', '595149', '595150', '595162', '595163', '595167', '595168', '595180', '595181', '595182', '595183',
        '595191', '595192', '595197', '595202', '595214', '595221', '595222', '595311', '595312', '595368', '595368',
        '595377', '595403', '595404', '595409', '595410', '595426', '595427', '595428', '595430', '595556', '595596',
        '595880', '595892', '595893', '595894', '595896', '595897', '595903', '595908', '595913', '595914', '595963',
        '595964', '595967', '595968', '596030', '596030', '596031', '596034', '596035', '596046', '596047', '596048',
        '596054', '596055', '596056',
    }


class GlucocorticoidsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Glucocorticoids and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151292', '159354', '160510', '165084', '165381', '165381', '165381', '172466', '176663', '179018', '182749',
        '183639', '183845', '184161', '185027', '187978', '187978', '187978', '190997', '191119', '193541', '194104',
        '197580', '197879', '201315', '203325', '203325', '204944', '206599', '208766', '210382', '210382', '212789',
        '213671', '213671', '214116', '214163', '214163', '214163', '214453', '214453', '215254', '215684', '215684',
        '216311', '218450', '225431', '228553', '228553', '231516', '233226', '233406', '236491', '236794', '236794',
        '236794', '237800', '237947', '238243', '238759', '238759', '238759', '242590', '243102', '244319', '245851',
        '246280', '251390', '256510', '259008', '260230', '261074', '262924', '263667', '263784', '267327', '267327',
        '267993', '270520', '272039', '272446', '273633', '273633', '273633', '275849', '275849', '276633', '278921',
        '278921', '280261', '280359', '282223', '282623', '282985', '284939', '285966', '285966', '288639', '290321',
        '293937', '294117', '294117', '299354', '429347', '429348', '445290', '445435', '545460', '545461', '545462',
        '546038', '546268', '546293', '546386', '547558', '549012', '551529', '554836', '554841', '556341', '556610',
        '556648', '557533', '557540', '558037', '560271', '560272', '560273', '560274', '560291', '560293', '560294',
        '560295', '561061', '561062', '561063', '561064', '561070', '561071', '561072', '561088', '561840', '561841',
        '561842', '564866', '564871', '571126', '571127', '574811', '574812', '574813', '574822', '574823', '574824',
        '575116', '575378', '580000', '580005', '580015', '580027', '584417', '587256', '587288', '587289', '587355',
        '587379', '589701', '589748', '590128', '591113', '591128', '591187', '591206', '591211', '591216', '591357',
        '591787', '591835', '591855', '591954', '592410', '592438', '592450', '592453', '592469', '592520', '592978',
        '592981', '592982', '592984', '592993', '592994', '592995', '592996', '592997', '593022', '593023', '593099',
        '593125', '593126', '593178', '593273', '593274', '593526', '593527', '593547', '593566', '593567', '593727',
        '593774', '593926', '593927', '594054', '594058', '594059', '594060', '594161', '594170', '594466', '594479',
        '594530', '594599', '594600', '595112', '595368', '595368', '595403', '595404', '595409', '595410', '595892',
        '595893', '595896', '595897', '595903', '595908', '595913', '595914', '595963', '595964', '595967', '595968',
        '596030', '596030', '596031', '596034', '596035',
    }


class GlucocorticoidCombinations(ValueSet):
    VALUE_SET_NAME = 'Glucocorticoid Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '179018', '218450', '580000', '580005', '580015', '580027', '587355', '587379', '591113', '591128', '591187',
        '591216', '592450', '593727', '593774', '594161', '594170', '595409', '595410', '595892', '595893', '595908',
        '595913',
    }


class Mineralocorticoids(ValueSet):
    VALUE_SET_NAME = 'Mineralocorticoids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '288051',
    }


class AndrogenAnabolic(ValueSet):
    VALUE_SET_NAME = 'Androgen-Anabolic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161689', '162276', '175584', '184801', '185710', '186214', '197476', '197476', '200258', '206556', '206657',
        '223375', '223375', '229941', '229941', '236801', '271060', '275753', '275753', '279619', '279619', '281746',
        '284337', '289062', '290441', '290441', '297714', '297944', '297944', '446304', '446305', '448495', '450233',
        '450242', '471032', '471162', '471188', '546036', '563156', '563158', '563545', '563559', '564162', '564170',
        '567986', '567988', '567989', '575573', '575575', '575584', '575585', '581038', '581044', '581722', '581723',
        '581724', '584437', '584444', '585738', '585784',
    }


class Androgens(ValueSet):
    VALUE_SET_NAME = 'Androgens'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161689', '175584', '184801', '185710', '186214', '197476', '197476', '200258', '206556', '206657', '223375',
        '223375', '229941', '229941', '271060', '275753', '275753', '279619', '279619', '284337', '290441', '290441',
        '297714', '297944', '297944', '448495', '450233', '450242', '471032', '471162', '471188', '546036', '563156',
        '563158', '563545', '563559', '564162', '564170', '567986', '567988', '567989', '575573', '575575', '575584',
        '575585', '581038', '581044', '581722', '581723', '581724', '584437', '584444', '585738', '585784',
    }


class AndrogenCombinations(ValueSet):
    VALUE_SET_NAME = 'Androgen - Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AnabolicSteroids(ValueSet):
    VALUE_SET_NAME = 'Anabolic Steroids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '162276', '236801', '281746', '289062', '446304', '446305',
    }


class AnabolicSteroidCombinations(ValueSet):
    VALUE_SET_NAME = 'Anabolic Steroid - Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class EstrogensAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Estrogens and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152636', '162284', '165256', '166426', '169721', '170020', '170942', '173160', '173526', '174267', '184702',
        '187893', '188776', '203936', '204481', '206785', '206785', '207471', '209725', '211395', '212579', '216309',
        '219874', '223410', '223652', '225034', '229157', '231942', '234216', '237259', '249326', '250930', '253433',
        '254789', '255488', '257317', '259116', '259589', '261937', '262983', '271418', '272997', '274584', '274985',
        '275361', '276103', '276940', '277600', '278320', '278786', '281273', '281627', '287988', '288776', '288783',
        '289306', '290064', '290503', '291183', '291848', '292010', '293303', '294017', '295931', '296891', '297239',
        '299788', '401095', '401096', '445549', '448935', '449853', '449865', '450388', '450398', '450447', '450449',
        '450451', '450452', '450453', '450717', '450718', '450792', '450793', '453557', '453559', '453574', '453632',
        '453743', '453751', '468383', '468384', '469774', '470780', '475247', '475248', '475536', '475682', '475682',
        '475689', '545001', '545002', '545003', '545004', '545005', '545006', '545007', '545008', '546319', '550627',
        '550627', '550632', '550632', '550961', '550991', '550992', '551013', '551279', '551279', '551280', '551281',
        '551285', '551287', '551288', '551288', '552265', '552808', '552825', '554222', '561301', '563329', '563329',
        '573346', '573351', '575957', '576267', '576268', '576269', '580662', '580679', '581699', '583195', '583196',
        '583368', '588382', '589569', '589569', '589570', '589570', '591749', '591750',
    }


class EstrogenCombinations(ValueSet):
    VALUE_SET_NAME = 'Estrogen Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165256', '166426', '173160', '204481', '206785', '206785', '209725', '223410', '259589', '262983', '274584',
        '276940', '288783', '290064', '292010', '295931', '449853', '449865', '453557', '453559', '453574', '453632',
        '453743', '453751', '475247', '475248', '475536', '475682', '475682', '475689', '546319', '550627', '550627',
        '550632', '550632', '550991', '550992', '561301', '563329', '563329', '573346', '573351', '580662', '580679',
        '581699', '583195', '583196', '588382', '589569', '589569', '589570', '589570', '591749', '591750',
    }


class EstrogenAndrogen(ValueSet):
    VALUE_SET_NAME = 'Estrogen-Androgen'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '166426', '262983', '475247', '475248', '550991', '550992',
    }


class EstrogenAntiandrogen(ValueSet):
    VALUE_SET_NAME = 'Estrogen-Antiandrogen'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class EstrogenAntianxietyAgent(ValueSet):
    VALUE_SET_NAME = 'Estrogen-Antianxiety Agent'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class EstrogenProgestin(ValueSet):
    VALUE_SET_NAME = 'Estrogen-Progestin'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165256', '173160', '204481', '206785', '206785', '209725', '223410', '259589', '274584', '276940', '288783',
        '290064', '292010', '295931', '449853', '449865', '453557', '453559', '453574', '453632', '453743', '453751',
        '475536', '475682', '475682', '475689', '546319', '550627', '550627', '550632', '550632', '561301', '563329',
        '563329', '573346', '573351', '581699', '583195', '583196', '588382', '589569', '589569', '589570', '589570',
        '591749', '591750',
    }


class EstrogenAndrogenProgestin(ValueSet):
    VALUE_SET_NAME = 'Estrogen-Androgen-Progestin'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Contraceptives(ValueSet):
    VALUE_SET_NAME = 'Contraceptives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153580', '156232', '157415', '158856', '159437', '160059', '162053', '163371', '164684', '168204', '172211',
        '172308', '172826', '174432', '175860', '176156', '177652', '178087', '182489', '182654', '186904', '189255',
        '189255', '196089', '196772', '198338', '200650', '202176', '205627', '209745', '213795', '216704', '218508',
        '221887', '225602', '226806', '231527', '232090', '233409', '235622', '235635', '238055', '239157', '243233',
        '244984', '245741', '246817', '247522', '249137', '249483', '250895', '257036', '258029', '263343', '265164',
        '266307', '266307', '266307', '269757', '270107', '275109', '277656', '281606', '283021', '285293', '286882',
        '286903', '288791', '289176', '289176', '289642', '289718', '289718', '290511', '292762', '294861', '294861',
        '294899', '296387', '400550', '400550', '400719', '401017', '401107', '429872', '429909', '444031', '444031',
        '444042', '444042', '445100', '445210', '445210', '445289', '445682', '445779', '446088', '446089', '446338',
        '446571', '446635', '448128', '448216', '448997', '448998', '449551', '449552', '449920', '450042', '450043',
        '451886', '452056', '452059', '453781', '453789', '454479', '467465', '467619', '467620', '468263', '468264',
        '468267', '471845', '472535', '473049', '473727', '473728', '474221', '474724', '476605', '476823', '476825',
        '545418', '545454', '545786', '545956', '546254', '546292', '546307', '547161', '547462', '547565', '547593',
        '549231', '551267', '553236', '553279', '555362', '557062', '557128', '557626', '557633', '557987', '557988',
        '558654', '558846', '558846', '558846', '558852', '560828', '561387', '561545', '561553', '561864', '562132',
        '562288', '562289', '562512', '562684', '562704', '562709', '562950', '562951', '562953', '563014', '563015',
        '563664', '563682', '563688', '563755', '563774', '563940', '564037', '564376', '564491', '564518', '565360',
        '565376', '565407', '566830', '569134', '569135', '569924', '571689', '571690', '572123', '572124', '572840',
        '573290', '573546', '573808', '574589', '574593', '574596', '574599', '575455', '575703', '575831', '575874',
        '576088', '576089', '576483', '576518', '576629', '576686', '576717', '577255', '577255', '577537', '577538',
        '577845', '577926', '578043', '578377', '578491', '578627', '578635', '579025', '579064', '579133', '579133',
        '579221', '579922', '579923', '580154', '580211', '580445', '580529', '580839', '581060', '581399', '581842',
        '581980', '582038', '582090', '582177', '582333', '582456', '582509', '582801', '583533', '583752', '584034',
        '584049', '584328', '584813', '584816', '584900', '585087', '586008', '586153', '587098', '587452', '587708',
        '588395', '588550', '588582', '588609', '588830', '588832', '588892', '588896', '589091', '589095', '589920',
        '590349', '591419', '591791', '591829', '591830', '592006', '592054', '592059', '593243', '593361', '593366',
        '593565', '593718', '593959', '594209', '594432', '595249', '595296', '595297', '595392', '595634', '595691',
        '595703', '596024',
    }


class ContraceptiveOralProgestin(ValueSet):
    VALUE_SET_NAME = 'Contraceptive Oral - Progestin'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '275109', '281606', '400719', '446571', '446635', '448128', '449920', '561864', '578491', '579221', '582038',
        '582333', '582456', '593718',
    }


class ContraceptivesInjectable(ValueSet):
    VALUE_SET_NAME = 'Contraceptives Injectable'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '226806', '289642', '445289', '445682', '473727', '473728',
    }


class ContraceptivesIntravaginal(ValueSet):
    VALUE_SET_NAME = 'Contraceptives Intravaginal'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '200650', '218508', '232090', '233409', '249483', '250895', '266307', '266307', '266307', '289176', '289176',
        '444031', '444031', '444042', '444042', '547462', '547565', '560828', '589920',
    }


class ContraceptivesImplant(ValueSet):
    VALUE_SET_NAME = 'Contraceptives Implant'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '545956', '565407',
    }


class EmergencyContraceptivesAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Emergency Contraceptives and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '558846', '558846', '558846', '558852', '562512', '562684', '573808', '577255', '577255', '581842', '582509',
        '583533', '584034', '584049', '590349', '591791', '595392', '595691',
    }


class EmergencyContraceptiveCombinations(ValueSet):
    VALUE_SET_NAME = 'Emergency Contraceptive Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class ContraceptiveInjectableCombinations(ValueSet):
    VALUE_SET_NAME = 'Contraceptive Injectable Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class ContraceptiveOralCombinations(ValueSet):
    VALUE_SET_NAME = 'Contraceptive Oral Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156232', '157415', '159437', '160059', '162053', '163371', '164684', '168204', '172211', '172308', '172826',
        '174432', '175860', '176156', '177652', '178087', '182489', '182654', '186904', '189255', '189255', '196089',
        '196772', '198338', '202176', '205627', '209745', '213795', '216704', '221887', '225602', '231527', '235622',
        '235635', '238055', '239157', '243233', '244984', '245741', '246817', '247522', '249137', '257036', '258029',
        '263343', '265164', '269757', '270107', '277656', '283021', '285293', '286882', '286903', '288791', '290511',
        '292762', '294861', '294861', '294899', '296387', '401017', '401107', '429872', '429909', '445100', '445779',
        '446088', '446089', '446338', '448216', '448997', '448998', '449551', '449552', '450042', '450043', '451886',
        '452056', '452059', '453781', '453789', '454479', '467465', '467619', '467620', '468263', '468264', '468267',
        '471845', '472535', '473049', '474221', '474724', '476605', '476823', '476825', '545418', '545454', '545786',
        '546254', '546292', '546307', '547161', '547593', '549231', '551267', '553236', '553279', '555362', '557062',
        '557128', '557626', '557633', '557987', '557988', '558654', '561387', '561545', '561553', '562132', '562288',
        '562289', '562704', '562709', '562950', '562951', '562953', '563014', '563015', '563664', '563682', '563688',
        '563755', '563774', '563940', '564037', '564376', '564491', '564518', '565360', '565376', '566830', '569134',
        '569135', '569924', '571689', '571690', '572123', '572124', '572840', '573290', '573546', '574589', '574593',
        '574596', '574599', '575455', '575703', '575831', '575874', '576088', '576089', '576483', '576518', '576629',
        '577537', '577538', '577845', '577926', '578043', '578377', '578627', '578635', '579025', '579064', '579922',
        '579923', '580154', '580211', '580445', '580529', '580839', '581060', '581980', '582090', '582177', '582801',
        '583752', '584328', '584900', '585087', '586008', '586153', '587098', '587452', '587708', '588395', '588550',
        '588582', '588609', '588830', '588832', '588892', '588896', '589091', '589095', '591419', '591829', '592054',
        '592059', '593243', '593361', '593366', '593565', '593959', '594209', '594432', '595249', '595296', '595297',
        '595634', '595703', '596024',
    }


class ContraceptiveOralMonophasic(ValueSet):
    VALUE_SET_NAME = 'Contraceptive Oral - Monophasic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159437', '160059', '162053', '163371', '164684', '168204', '172211', '172308', '172826', '174432', '175860',
        '176156', '177652', '178087', '182489', '182654', '196089', '198338', '202176', '209745', '221887', '225602',
        '231527', '235622', '235635', '238055', '239157', '244984', '245741', '246817', '247522', '249137', '258029',
        '263343', '269757', '270107', '285293', '286882', '286903', '288791', '290511', '294861', '294861', '294899',
        '296387', '401107', '429872', '429909', '445100', '445779', '446338', '448216', '448997', '448998', '450042',
        '450043', '451886', '452056', '452059', '467465', '467620', '472535', '474221', '474724', '476605', '476823',
        '476825', '545454', '546254', '546292', '546307', '547161', '547593', '549231', '551267', '555362', '557987',
        '557988', '561387', '562132', '562288', '562289', '562950', '562951', '563014', '563015', '563664', '563682',
        '563688', '563755', '563774', '563940', '564037', '564376', '564491', '564518', '566830', '569924', '571689',
        '572123', '573290', '573546', '574593', '574596', '575703', '575831', '575874', '576088', '576089', '576483',
        '576518', '576629', '577537', '578043', '578377', '578627', '578635', '579025', '579922', '579923', '580154',
        '580529', '580839', '581060', '581980', '582090', '582177', '582801', '583752', '584900', '585087', '586008',
        '587098', '587452', '587708', '588395', '588582', '588609', '588892', '588896', '589095', '591419', '591829',
        '592054', '592059', '593243', '593959', '594209', '594432', '595249', '595296', '595634', '595703', '596024',
    }


class ContraceptiveOralTriphasic(ValueSet):
    VALUE_SET_NAME = 'Contraceptive Oral - Triphasic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156232', '157415', '189255', '189255', '196772', '216704', '243233', '265164', '277656', '283021', '292762',
        '446088', '446089', '449551', '449552', '453781', '453789', '454479', '467619', '468263', '468264', '468267',
        '471845', '473049', '553236', '553279', '557128', '558654', '562953', '571690', '572840', '574589', '574599',
        '575455', '577538', '580211', '588830', '588832', '589091', '593565', '595297',
    }


class Progestins(ValueSet):
    VALUE_SET_NAME = 'Progestins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151287', '153263', '177822', '179253', '184728', '185240', '195136', '196615', '201987', '221849', '252197',
        '264633', '270962', '296048', '429938',
    }


class DiabeticTherapy(ValueSet):
    VALUE_SET_NAME = 'Diabetic Therapy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152132', '153666', '154170', '154532', '154757', '154757', '155744', '156080', '157766', '158131', '159627',
        '160397', '161595', '162161', '163934', '164763', '166726', '167375', '167529', '170310', '170678', '171460',
        '172960', '173537', '174715', '175323', '175636', '175684', '176377', '176999', '178540', '181840', '181840',
        '183692', '187057', '187057', '187638', '191281', '191281', '191479', '191479', '191657', '193228', '193809',
        '193809', '195978', '195978', '196223', '204311', '206983', '208723', '209040', '209301', '209301', '210179',
        '211192', '211192', '214727', '215614', '216262', '216597', '218008', '218760', '218786', '223222', '225440',
        '228241', '229322', '230694', '230701', '231630', '231812', '231812', '235056', '235158', '235788', '236411',
        '236506', '236937', '238196', '238196', '241223', '245026', '245026', '245044', '245044', '248438', '248438',
        '248664', '249753', '249753', '250245', '251432', '251432', '252504', '253589', '255827', '257528', '257648',
        '260150', '261972', '265365', '265660', '269536', '272120', '272192', '272241', '274811', '274811', '275126',
        '281055', '281538', '281538', '284822', '286168', '287634', '288985', '292684', '293032', '293442', '296331',
        '297665', '297705', '299765', '429988', '429988', '429988', '429988', '429988', '444330', '444335', '444336',
        '444337', '444585', '444606', '446103', '446105', '446476', '446477', '446492', '446493', '446596', '446597',
        '446598', '446891', '448581', '448582', '448593', '448625', '449605', '449606', '451579', '451898', '453598',
        '453598', '453605', '453605', '467970', '467971', '467983', '467985', '468343', '473765', '474050', '474051',
        '474074', '474075', '474208', '474875', '474986', '474986', '474987', '475043', '475044', '475863', '475864',
        '476076', '476077', '476118', '476214', '476275', '476474', '476478', '545046', '545198', '545213', '545213',
        '545999', '546006', '546101', '546280', '546283', '546289', '546290', '547317', '547319', '547320', '547320',
        '547328', '547329', '547330', '547330', '547645', '547659', '550474', '550475', '550494', '550530', '550693',
        '550694', '551000', '551017', '551704', '551714', '553776', '553777', '553838', '553839', '553840', '554470',
        '554646', '555263', '556899', '556922', '556977', '556978', '556981', '556982', '557709', '557718', '558171',
        '558907', '558909', '558913', '558914', '560076', '560102', '560265', '560349', '561331', '561332', '561335',
        '561336', '562570', '562572', '562575', '562584', '562585', '562586', '562587', '562588', '564127', '564132',
        '570207', '570210', '570251', '570252', '570253', '570286', '570287', '570288', '570311', '570312', '570313',
        '570314', '570316', '570317', '570735', '571585', '576284', '576869', '576870', '576871', '576872', '576873',
        '576874', '576875', '576876', '576877', '576878', '576880', '576881', '576882', '576885', '576886', '576887',
        '576888', '576889', '576890', '576891', '576892', '576893', '577665', '577665', '577666', '577704', '577705',
        '577707', '577708', '577709', '577709', '577710', '577711', '577739', '577739', '577826', '577826', '578046',
        '578230', '578861', '580603', '580604', '580680', '580681', '580682', '580683', '580701', '580702', '581202',
        '581281', '581645', '581703', '581704', '581725', '581726', '582096', '582250', '582251', '582254', '582255',
        '582281', '582282', '582283', '582284', '582290', '582291', '582292', '582293', '582681', '582682', '582683',
        '582684', '583003', '583004', '583005', '583006', '583007', '583008', '583009', '583010', '583348', '583468',
        '583469', '583470', '583471', '583472', '583480', '583482', '583483', '583876', '583877', '583888', '583889',
        '584222', '584232', '584428', '584440', '584447', '585517', '586164', '586212', '586254', '586256', '586267',
        '587166', '587167', '587168', '587169', '587178', '587182', '587183', '587184', '587732', '587733', '587810',
        '587901', '588717', '589107', '589199', '590948', '590949', '590957', '590958', '591255', '591371', '591841',
        '591842', '591843', '591844', '591859', '591860', '591861', '591862', '592417', '592418', '592425', '592518',
        '592518', '592534', '592535', '592539', '592581', '592582', '592583', '592584', '592642', '592651', '593027',
        '593028', '593032', '593033', '593157', '593318', '593319', '593320', '593321', '593416', '593664', '593711',
        '593899', '593900', '594224', '594226', '594806', '594826', '594836', '595028', '595029', '595030', '595031',
        '595051', '595058', '595149', '595150', '595162', '595163', '595167', '595168', '595180', '595181', '595182',
        '595183', '595202', '595214', '595221', '595222', '595311', '595312', '595426', '595427', '595428', '595430',
        '595880', '595894',
    }


class Insulins(ValueSet):
    VALUE_SET_NAME = 'Insulins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153666', '158131', '164763', '170310', '174715', '193228', '193809', '193809', '208723', '228241', '231812',
        '231812', '236937', '238196', '238196', '245026', '245026', '248438', '248438', '249753', '249753', '251432',
        '251432', '272192', '274811', '274811', '288985', '444330', '444335', '444336', '444337', '444585', '444606',
        '446103', '446105', '446891', '448581', '448582', '448593', '448625', '473765', '474875', '476118', '476214',
        '476275', '476474', '476478', '547645', '547659', '551704', '551714', '553838', '553839', '553840', '557709',
        '557718', '580603', '580604', '580701', '580702', '581645', '583468', '583469', '583470', '583471', '583472',
        '583480', '583482', '583483', '584222', '584232', '586164', '586212', '586254', '586256', '586267', '587732',
        '587733', '588717', '589107', '589199', '591255', '592642', '592651', '593027', '593028', '593032', '593033',
        '593899', '593900', '594224', '594226', '595167', '595168', '595880', '595894',
    }


class InsulinMixed(ValueSet):
    VALUE_SET_NAME = 'Insulin - Mixed'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class InsulinBeef(ValueSet):
    VALUE_SET_NAME = 'Insulin - Beef'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class InsulinPorkCombinations(ValueSet):
    VALUE_SET_NAME = 'Insulin Pork Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class InsulinHumanAndAnalogsFixedCombinations(ValueSet):
    VALUE_SET_NAME = 'Insulin - Human and Analogs, Fixed Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153666', '158131', '193809', '193809', '249753', '249753', '288985', '444606', '446103', '446105', '448581',
        '448593', '473765', '476275', '547645', '547659', '553839', '553840', '580701',
    }


class OralAntidiabeticAgents(ValueSet):
    VALUE_SET_NAME = 'Oral Antidiabetic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152132', '154170', '154532', '154757', '154757', '155744', '157766', '159627', '160397', '161595', '162161',
        '163934', '166726', '167375', '167529', '170678', '171460', '172960', '175323', '175636', '175684', '176377',
        '176999', '178540', '181840', '181840', '183692', '187638', '191281', '191281', '191479', '191479', '191657',
        '195978', '195978', '196223', '204311', '206983', '209301', '209301', '210179', '211192', '211192', '214727',
        '215614', '216262', '216597', '218008', '218760', '218786', '223222', '225440', '229322', '230694', '230701',
        '235056', '235158', '235788', '236411', '236506', '241223', '245044', '245044', '248664', '252504', '253589',
        '255827', '257528', '260150', '261972', '265365', '265660', '269536', '272120', '272241', '275126', '281055',
        '281538', '281538', '284822', '286168', '287634', '292684', '293032', '293442', '296331', '297665', '297705',
        '299765', '446476', '446477', '446492', '446493', '446596', '446597', '446598', '449605', '449606', '451579',
        '451898', '453598', '453598', '453605', '453605', '467970', '467971', '467983', '467985', '474986', '474986',
        '474987', '475043', '475044', '475863', '475864', '476076', '476077', '545999', '546006', '546101', '546280',
        '546283', '546289', '546290', '547317', '547319', '547320', '547320', '547328', '547329', '547330', '547330',
        '550474', '550475', '550494', '550530', '551000', '551017', '555263', '556977', '556978', '556981', '556982',
        '558907', '558909', '558913', '558914', '561331', '561332', '561335', '561336', '562570', '562572', '562575',
        '562584', '562585', '562586', '562587', '562588', '564127', '564132', '570251', '570252', '570253', '570286',
        '570287', '570288', '570311', '570312', '570313', '570314', '570316', '570317', '570735', '571585', '576869',
        '576870', '576871', '576872', '576873', '576874', '576875', '576876', '576877', '576878', '576880', '576881',
        '576882', '576885', '576886', '576887', '576888', '576889', '576890', '576891', '576892', '576893', '577707',
        '577708', '577710', '577711', '580680', '580681', '580682', '580683', '582250', '582251', '582254', '582255',
        '582281', '582282', '582283', '582284', '582290', '582291', '582292', '582293', '583003', '583004', '583005',
        '583006', '583007', '583008', '583009', '583010', '583876', '583877', '583888', '583889', '587166', '587167',
        '587168', '587169', '587178', '587182', '587183', '587184', '590948', '590949', '590957', '590958', '591841',
        '591842', '591843', '591844', '591859', '591860', '591861', '591862', '592581', '592582', '592583', '592584',
        '593157', '593318', '593319', '593320', '593321', '593664', '593711', '594806', '595149', '595150', '595162',
        '595163', '595180', '595181', '595182', '595183', '595202', '595214', '595221', '595222', '595311', '595312',
        '595426', '595427', '595428', '595430',
    }


class AntihyperglycemicAntidiabeticCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihyperglycemic (Antidiabetic) Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '176999', '178540', '196223', '206983', '230694', '446476', '446477', '446492', '446493', '446596', '446597',
        '446598', '451579', '451898', '474986', '474986', '474987', '475043', '475044', '475863', '475864', '476076',
        '476077', '546280', '546283', '546289', '546290', '550474', '550475', '550494', '550530', '551000', '551017',
        '556977', '556978', '556981', '556982', '561331', '561332', '561335', '561336', '562570', '562572', '562575',
        '562584', '562585', '562586', '570251', '570252', '570253', '570286', '570287', '570288', '570311', '570312',
        '570313', '570314', '570316', '570317', '576870', '576871', '576872', '576873', '576874', '576876', '576877',
        '576880', '576881', '576882', '576887', '576889', '576890', '576891', '576892', '576893', '582281', '582282',
        '582283', '582284', '582290', '582291', '582292', '582293', '583003', '583004', '583005', '583006', '583007',
        '583008', '583009', '583010', '583876', '583877', '583888', '583889', '587166', '587167', '587168', '587169',
        '587178', '587182', '587183', '587184', '590948', '590949', '590957', '590958', '591841', '591842', '591843',
        '591844', '591859', '591860', '591861', '591862', '592581', '592582', '592583', '592584', '593157', '593318',
        '593319', '593320', '593321', '594806', '595149', '595150', '595180', '595181', '595182', '595183', '595202',
        '595214', '595311', '595312', '595426', '595427', '595428', '595430',
    }


class InsulinResponseEnhancersBiguanides(ValueSet):
    VALUE_SET_NAME = 'Insulin Response Enhancers - Biguanides'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155744', '163934', '167529', '191479', '191479', '204311', '241223', '252504', '287634', '449605', '449606',
        '453598', '453598', '453605', '453605', '467970', '467971', '467983', '467985', '545999', '546006', '546101',
        '555263', '593664', '593711',
    }


class AntihyperglycemicMeglitinideAnalogs(ValueSet):
    VALUE_SET_NAME = 'Antihyperglycemic - Meglitinide Analogs'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154532', '161595', '171460', '216262', '225440', '229322', '255827', '292684', '293442', '296331',
    }


class AgentsToTreatHypoglycemiaHyperglycemicsCombinations(ValueSet):
    VALUE_SET_NAME = 'Agents to treat Hypoglycemia (Hyperglycemics) Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AgentsToTreatHypoglycemiaHyperglycemicsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Agents to treat Hypoglycemia (Hyperglycemics) and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156080', '173537', '187057', '187057', '209040', '231630', '250245', '257648', '429988', '429988', '429988',
        '429988', '429988', '468343', '474208', '545046', '545198', '545213', '545213', '550693', '550694', '556899',
        '556922', '558171', '560076', '560102', '560265', '577665', '577665', '577666', '577704', '577705', '577709',
        '577709', '577739', '577739', '577826', '577826', '578046', '578230', '583348', '584428', '584440', '584447',
        '585517', '587810', '587901', '592518', '592518', '593416', '595051', '595058',
    }


class AntihyperglycemicAldoseReductaseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Antihyperglycemic - Aldose Reductase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntihyperglycemicAlphaGlucosidaseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Antihyperglycemic - Alpha-Glucosidase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152132', '157766', '160397', '167375', '187638', '191657', '210179', '218760', '230701', '235158', '265365',
        '297665',
    }


class AntihyperglycemicInsulinResponseEnhancers(ValueSet):
    VALUE_SET_NAME = 'Antihyperglycemic - Insulin Response Enhancers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154757', '154757', '155744', '159627', '163934', '167529', '191479', '191479', '195978', '195978', '204311',
        '215614', '241223', '248664', '252504', '261972', '272120', '281055', '281538', '281538', '284822', '287634',
        '297705', '299765', '449605', '449606', '453598', '453598', '453605', '453605', '467970', '467971', '467983',
        '467985', '545999', '546006', '546101', '555263', '593664', '593711',
    }


class InsulinResponseEnhancersThiazolidinedionesPparGammaAgonists(ValueSet):
    VALUE_SET_NAME = 'Insulin Response Enhancers - Thiazolidinediones (PPAR-gamma agonists)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154757', '154757', '159627', '195978', '195978', '215614', '248664', '261972', '272120', '281055', '281538',
        '281538', '284822', '297705', '299765',
    }


class ThyroidTherapy(ValueSet):
    VALUE_SET_NAME = 'Thyroid Therapy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153056', '156410', '157529', '158184', '160353', '161664', '162412', '162756', '163725', '169805', '172747',
        '175194', '175497', '175624', '175988', '177109', '178488', '183683', '184094', '184403', '189604', '190801',
        '191895', '193374', '194779', '200004', '205075', '205571', '208610', '210792', '213323', '213415', '215452',
        '216445', '216829', '217047', '217056', '218070', '220146', '227100', '228289', '230036', '232437', '237361',
        '238462', '241772', '244258', '246607', '248321', '249707', '250029', '251106', '253625', '256244', '256285',
        '256830', '257084', '257448', '261882', '263224', '263453', '264576', '265088', '265697', '266937', '266970',
        '270632', '270806', '271006', '273579', '275720', '275734', '277023', '279419', '279731', '288519', '293730',
        '296237', '298141', '446054', '512120', '512122', '512123', '512124', '512125', '512126', '512127', '553853',
        '553871', '553885', '553892', '553893', '553894', '553906', '553907', '553908', '553909', '553910', '553911',
        '553912', '555512', '558881', '558882', '558883', '558884', '558885', '558886', '558887', '558888', '560710',
        '560711', '560712', '560714', '560715', '560716', '560717', '560718', '560719', '560720', '560723', '560724',
        '560725', '560726', '560727', '560728', '560729', '560730', '560731', '560732', '562296', '562321', '562348',
        '562351', '562352', '562417', '562418', '562419', '562598', '562621', '562648', '563718', '563738', '565095',
        '565109', '568680', '569912', '569951', '569987', '570151', '570157', '570213', '579459', '579463', '579464',
        '579466', '579467', '579468', '581124', '581125', '591289', '591290', '591291', '591292', '592104', '593721',
    }


class ThyroidHormonesAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Thyroid Hormones and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153056', '156410', '157529', '158184', '160353', '161664', '162412', '162756', '163725', '172747', '175194',
        '175497', '175624', '175988', '177109', '178488', '183683', '184094', '184403', '189604', '190801', '191895',
        '193374', '194779', '200004', '205075', '205571', '208610', '210792', '213323', '213415', '215452', '216445',
        '216829', '217047', '217056', '218070', '220146', '227100', '228289', '230036', '232437', '237361', '238462',
        '241772', '244258', '246607', '248321', '250029', '251106', '253625', '256244', '256285', '257084', '257448',
        '261882', '263224', '263453', '264576', '265088', '265697', '266937', '266970', '270632', '270806', '271006',
        '273579', '275720', '275734', '279419', '288519', '293730', '296237', '298141', '446054', '512120', '512122',
        '512123', '512124', '512125', '512126', '512127', '553853', '553871', '553885', '553892', '553893', '553894',
        '553906', '553907', '553908', '553909', '553910', '553911', '553912', '555512', '558881', '558882', '558883',
        '558884', '558885', '558886', '558887', '558888', '560710', '560711', '560712', '560714', '560715', '560716',
        '560717', '560718', '560719', '560720', '560723', '560724', '560725', '560726', '560727', '560728', '560729',
        '560730', '560731', '560732', '562296', '562321', '562348', '562351', '562352', '562417', '562418', '562419',
        '562598', '562621', '562648', '563718', '563738', '565095', '565109', '568680', '569912', '569951', '569987',
        '570151', '570157', '570213', '579459', '579463', '579464', '579466', '579467', '579468', '581124', '581125',
        '591289', '591290', '591291', '591292', '592104', '593721',
    }


class ThyroidHormoneCombinationsSyntheticT3AndT4(ValueSet):
    VALUE_SET_NAME = 'Thyroid Hormone Combinations - Synthetic T3 and T4'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '163725', '194779', '215452', '228289', '256285', '263224', '263453', '265088', '275734', '293730',
    }


class AntithyroidAgents(ValueSet):
    VALUE_SET_NAME = 'Antithyroid Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '169805', '249707', '256830', '277023', '279731',
    }


class Oxytocics(ValueSet):
    VALUE_SET_NAME = 'Oxytocics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '168539', '168539', '168539', '184218', '194103', '195644', '217840', '217840', '219151', '231468', '237342',
        '237342', '238405', '238405', '238405', '238405', '253167', '256373', '258205', '286763', '286763', '293732',
        '298160', '472927', '472928', '472929', '472930', '472931', '472932', '472933', '472934', '472935', '472936',
        '472937', '472938', '472939', '472940', '472941', '472942', '472982', '472983', '472984', '472985', '472986',
        '472987', '472988', '472989', '474746', '475894', '475895', '475896', '475897', '475898', '475899', '475900',
        '475901', '549190', '559769', '559773', '591823',
    }


class AbortifacientsOrAgentsForCervicalRipening(ValueSet):
    VALUE_SET_NAME = 'Abortifacients or Agents for Cervical Ripening'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '184218', '194103', '219151', '237342', '237342', '253167', '256373', '258205', '286763', '286763', '293732',
        '298160',
    }


class AbortifacientsOrCervicalRipeningAgentsProstaglandinAnalogs(ValueSet):
    VALUE_SET_NAME = 'Abortifacients or Cervical Ripening Agents - Prostaglandin Analogs'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '184218', '194103', '219151', '253167', '256373', '258205', '293732', '298160',
    }


class OxytocicCombinations(ValueSet):
    VALUE_SET_NAME = 'Oxytocic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class OxytocicMixtures(ValueSet):
    VALUE_SET_NAME = 'Oxytocic Mixtures'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AdrenalSteroidInhibitors(ValueSet):
    VALUE_SET_NAME = 'Adrenal Steroid Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class CalciumAndBoneMetabolismRegulators(ValueSet):
    VALUE_SET_NAME = 'Calcium and Bone Metabolism Regulators'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157276', '164420', '165884', '169278', '170105', '182862', '184359', '184359', '184359', '184359', '205069',
        '217975', '217975', '217975', '225190', '226964', '229559', '232454', '232454', '242128', '261845', '264119',
        '268105', '271396', '276716', '293238', '299898', '400802', '400803', '443594', '443594', '443594', '443594',
        '443600', '443600', '446380', '449441', '449443', '454287', '467356', '467357', '467358', '467360', '467361',
        '467362', '473676', '473678', '473748', '473752', '474872', '476257', '476490', '550683', '550683', '550683',
        '550750', '550839', '550848', '554886', '554886', '554897', '554897', '556435', '556442', '561412', '561413',
        '562559', '562592', '562694', '562700', '566371', '566379', '574609', '574649', '577172', '581068', '584836',
        '584837', '584838', '584839', '584847', '584848', '584849', '584850', '593006', '593006', '593006', '593537',
        '593540', '594635', '594635', '594635', '596046', '596047', '596048', '596054', '596055', '596056',
    }


class BoneResorptionInhibitorsBisphosphonates(ValueSet):
    VALUE_SET_NAME = 'Bone Resorption Inhibitors - Bisphosphonates'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157276', '164420', '169278', '170105', '182862', '184359', '184359', '184359', '184359', '205069', '217975',
        '217975', '217975', '225190', '226964', '229559', '242128', '264119', '268105', '271396', '400802', '400803',
        '443594', '443594', '443594', '443594', '443600', '443600', '446380', '449441', '449443', '454287', '473676',
        '473678', '476257', '476490', '550683', '550683', '550683', '550750', '554886', '554886', '554897', '554897',
        '562559', '562592', '566371', '566379', '574609', '574649', '577172', '581068',
    }


class Calcitonins(ValueSet):
    VALUE_SET_NAME = 'Calcitonins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '232454', '232454', '276716', '293238', '299898', '474872',
    }


class CalciumAndBoneMetabolismRegulatorsOther(ValueSet):
    VALUE_SET_NAME = 'Calcium and Bone Metabolism Regulators - Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class SelectiveEstrogenReceptorModulatorsSerms(ValueSet):
    VALUE_SET_NAME = 'Selective Estrogen Receptor Modulators (SERMs)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165884', '261845',
    }


class FertilityRegulators(ValueSet):
    VALUE_SET_NAME = 'Fertility Regulators'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '175833', '181189', '188463', '188801', '195153', '230248', '237700', '247230', '277383', '289485', '443552',
        '452666', '452812', '467442', '467443', '467447', '467448', '468272', '468273', '469643', '470631', '470632',
        '470633', '473659', '473667', '474881', '474883', '475460', '475461', '475467', '475468', '550758', '550769',
        '551538', '551574', '563314', '580380', '580381', '580382', '588070', '589777', '589793', '594369', '595556',
        '595596',
    }


class FertilityEnhancerOvulationStimulantGonadotropins(ValueSet):
    VALUE_SET_NAME = 'Fertility Enhancer - Ovulation Stimulant - Gonadotropins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '188463', '195153', '230248', '237700', '247230', '289485', '443552', '452666', '452812', '467442', '467443',
        '467447', '467448', '468272', '468273', '469643', '470631', '470632', '470633', '473659', '473667', '474881',
        '474883', '475460', '475461', '475467', '475468', '550758', '550769', '580380', '580381', '580382', '594369',
    }


class FertilityEnhancerOvulationStimulantSyntheticNonFsh(ValueSet):
    VALUE_SET_NAME = 'Fertility Enhancer - Ovulation Stimulant - Synthetic (Non-FSH)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '175833', '188801',
    }


class LhrhGnrhAgonistAnalogPituitarySuppressants(ValueSet):
    VALUE_SET_NAME = 'LHRH (GnRH) Agonist Analog Pituitary Suppressants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157005', '164094', '217212', '260567', '469796',
    }


class GrowthHormones(ValueSet):
    VALUE_SET_NAME = 'Growth Hormones'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150724', '152787', '156330', '157640', '158290', '160093', '163956', '163965', '167620', '173334', '180673',
        '183447', '187201', '193096', '198464', '202846', '204348', '211063', '219340', '224196', '238865', '239243',
        '240935', '241877', '242168', '244441', '246671', '246830', '250118', '251464', '251871', '253327', '257847',
        '264516', '265811', '277649', '278108', '283529', '290331', '290638', '292392', '294764', '401065', '443822',
        '443925', '467571', '471277', '472243', '472245', '473147', '473148', '473149', '545497', '549002', '554098',
        '554106', '554451', '556535', '556560', '558523', '558576', '559807', '559832', '560854', '560856', '560857',
        '561103', '561104', '584690', '585539', '585540', '587704', '587707', '593574',
    }


class GrowthHormoneReleasingHormonesGhrh(ValueSet):
    VALUE_SET_NAME = 'Growth Hormone Releasing Hormones (GHRH)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '562720', '562721', '575260', '575275',
    }


class SomatostaticAgents(ValueSet):
    VALUE_SET_NAME = 'Somatostatic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152333', '152333', '153278', '153278', '161242', '188137', '188137', '190037', '195085', '198209', '199591',
        '243660', '246879', '249446', '249466', '262100', '263195', '275705', '299175', '553032', '553033', '553034',
        '553041', '553042', '553043', '563728', '563729', '563730', '574502', '574506', '574507', '576360', '576361',
        '576362', '577413', '577414', '577427', '583436', '583437', '583438', '584037', '584038', '584039', '585037',
        '585038', '585039',
    }


class PosteriorPituitaryHormones(ValueSet):
    VALUE_SET_NAME = 'Posterior Pituitary Hormones'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160372', '160372', '160372', '173508', '184164', '184164', '187414', '191882', '193439', '193439', '230050',
        '237692', '241713', '245728', '263261', '265693', '265693', '299729', '430036', '572198', '572200', '572335',
        '572336', '572337', '572445', '572446', '572447', '583100', '583100', '583105', '583105', '593180', '593181',
        '594023', '595191', '595192',
    }


class AntidiureticAndVasopressorHormones(ValueSet):
    VALUE_SET_NAME = 'Antidiuretic and Vasopressor Hormones'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160372', '160372', '160372', '173508', '184164', '184164', '187414', '191882', '193439', '193439', '230050',
        '237692', '241713', '245728', '263261', '265693', '265693', '299729', '430036', '572198', '572200', '572335',
        '572336', '572337', '572445', '572446', '572447', '583100', '583100', '583105', '583105', '593180', '593181',
        '594023', '595191', '595192',
    }


class AdrenocorticotrophicHormones(ValueSet):
    VALUE_SET_NAME = 'Adrenocorticotrophic Hormones'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '289002', '430040',
    }


class ProlactinInhibitors(ValueSet):
    VALUE_SET_NAME = 'Prolactin Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '247652',
    }


class ProlactinInhibitorDopamineReceptorAgonists(ValueSet):
    VALUE_SET_NAME = 'Prolactin Inhibitor - Dopamine Receptor Agonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '247652',
    }


class MenopausalSymptomsSuppressant(ValueSet):
    VALUE_SET_NAME = 'Menopausal Symptoms Suppressant'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '577391', '577894', '579045', '579045', '579345', '592414', '593804',
    }


class MenopausalSymptomsSupressantHormonalAgents(ValueSet):
    VALUE_SET_NAME = 'Menopausal Symptoms Supressant - Hormonal Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '592414', '593804',
    }


class UterineRelaxants(ValueSet):
    VALUE_SET_NAME = 'Uterine Relaxants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MetabolicModifiers(ValueSet):
    VALUE_SET_NAME = 'Metabolic Modifiers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152001', '152001', '154300', '159641', '161845', '166102', '181187', '195859', '195965', '195965', '203468',
        '205371', '205371', '212065', '217207', '245912', '260747', '275147', '280672', '280672', '286094', '290017',
        '290110', '298296', '298296', '400003', '400004', '400005', '400058', '400059', '400060', '445956', '445956',
        '453820', '453823', '471128', '471131', '473365', '473369', '474240', '474241', '474242', '474244', '474245',
        '551049', '551068', '553836', '553837', '558794', '558800', '562595', '562597', '563095', '576951', '576953',
        '580524', '580990', '582375', '582395', '582702', '582706', '583104', '583104', '583138', '586155', '586160',
        '586937', '586972', '587080', '587389', '589320', '589553', '589582', '590478', '590496', '591025', '591177',
        '591197', '591317', '591376', '591582', '591642', '591658', '592172', '592330', '592506', '592560', '592965',
        '592966', '592967', '594116', '594117', '594118',
    }


class MetabolicModifierCarnitineReplenisherAgents(ValueSet):
    VALUE_SET_NAME = 'Metabolic Modifier - Carnitine Replenisher Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159641', '195859', '203468', '217207', '275147', '298296', '298296', '551049', '551068',
    }


class MetabolicModifierHomocystinuriaTreatmentAgents(ValueSet):
    VALUE_SET_NAME = 'Metabolic Modifier - Homocystinuria Treatment Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154300', '161845',
    }


class MetabolicModifierUreaCycleDisorderAgents(ValueSet):
    VALUE_SET_NAME = 'Metabolic Modifier - Urea Cycle Disorder Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152001', '152001', '260747', '280672', '280672', '290110', '473365', '473369', '562595', '562597', '576951',
        '576953',
    }


class CardiacInotropes(ValueSet):
    VALUE_SET_NAME = 'Cardiac Inotropes'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151385', '169022', '199821', '204037', '206408', '220310', '244843', '247540', '257402', '257402', '257402',
        '269681', '285978', '287430', '443815', '555496', '555497', '565263', '565621', '572423', '579980', '579981',
        '580751', '580768',
    }


class CardiacInotropesPhosphodiesteraseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Cardiac Inotropes - Phosphodiesterase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '257402', '257402', '257402', '555496', '555497',
    }


class DigitalisGlycosides(ValueSet):
    VALUE_SET_NAME = 'Digitalis Glycosides'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151385', '169022', '199821', '204037', '206408', '220310', '244843', '247540', '269681', '285978', '287430',
        '443815', '565263', '565621', '572423', '579980', '579981', '580751', '580768',
    }


class AnginaTherapy(ValueSet):
    VALUE_SET_NAME = 'Angina Therapy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154356', '159220', '165379', '167234', '167234', '167234', '167234', '167234', '167234', '169513', '172302',
        '174665', '175682', '178346', '178547', '184354', '185290', '185891', '203560', '210468', '211131', '212103',
        '213710', '216758', '216758', '216758', '216780', '218233', '219629', '220123', '220460', '224874', '226502',
        '226574', '227603', '229569', '234805', '239642', '243996', '247166', '248160', '250854', '250991', '254168',
        '254168', '256598', '264273', '264273', '264273', '265879', '267617', '274331', '276651', '289103', '298773',
        '430068', '430103', '430120', '430128', '446110', '448936', '448936', '476331', '476571', '552325', '552332',
        '556758', '556760', '556762', '556763', '557118', '560817', '560817', '560817', '560817', '560817', '560817',
        '569201', '569204', '581454', '581508', '590969', '590979',
    }


class AntianginalCoronaryVasodilatorsNitrates(ValueSet):
    VALUE_SET_NAME = 'Antianginal - Coronary Vasodilators (Nitrates)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154356', '159220', '165379', '167234', '167234', '167234', '167234', '167234', '167234', '169513', '172302',
        '174665', '175682', '178346', '178547', '184354', '185290', '185891', '203560', '210468', '211131', '212103',
        '213710', '216758', '216758', '216758', '216780', '218233', '219629', '220123', '220460', '224874', '226502',
        '226574', '227603', '229569', '234805', '239642', '243996', '247166', '248160', '250854', '250991', '254168',
        '254168', '256598', '264273', '264273', '264273', '265879', '267617', '274331', '276651', '289103', '298773',
        '430068', '430103', '430120', '430128', '446110', '448936', '448936', '556758', '556760', '556762', '556763',
        '557118', '560817', '560817', '560817', '560817', '560817', '560817', '569201', '569204', '581454', '581508',
        '590969', '590979',
    }


class AntianginalPotassiumChannelAgonists(ValueSet):
    VALUE_SET_NAME = 'Antianginal - Potassium-Channel Agonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntianginalAgentsOther(ValueSet):
    VALUE_SET_NAME = 'Antianginal Agents Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AnginalTherapyCombinations(ValueSet):
    VALUE_SET_NAME = 'Anginal Therapy Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class CoronaryVasodilatorNitrateCombinations(ValueSet):
    VALUE_SET_NAME = 'Coronary Vasodilator (Nitrate) Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class BetaAdrenergicBlockers(ValueSet):
    VALUE_SET_NAME = 'Beta Adrenergic Blockers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151656', '153463', '155760', '156010', '156525', '158839', '160414', '162707', '162843', '162962', '163403',
        '164212', '164241', '164797', '166376', '168488', '172697', '174363', '175686', '175686', '175936', '176166',
        '176685', '181771', '182435', '185501', '187002', '190976', '192407', '192407', '193427', '199452', '201729',
        '202574', '206859', '209377', '210976', '213587', '214062', '218287', '220690', '221898', '224622', '227013',
        '227167', '229626', '230964', '235667', '235922', '246724', '251929', '261804', '264405', '266159', '270923',
        '271618', '271618', '272740', '273634', '275110', '276084', '277047', '277907', '279341', '281748', '282810',
        '282810', '286820', '290337', '290337', '295683', '297193', '297225', '297887', '298093', '298093', '299349',
        '444374', '448999', '449000', '449003', '449004', '453953', '547997', '547999', '548000', '548001', '548082',
        '548083', '548084', '548085', '553915', '553916', '553917', '553946', '553947', '553948', '557639', '557659',
        '559107', '568438', '573704', '580943', '580945', '581609', '581611', '589689', '589690', '593608',
    }


class AlphaBetaBlockers(ValueSet):
    VALUE_SET_NAME = 'Alpha-Beta Blockers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158839', '160414', '163403', '164241', '168488', '176685', '209377', '224622', '277047', '279341', '282810',
        '282810', '299349', '547997', '547999', '548000', '548001', '548082', '548083', '548084', '548085', '559107',
        '568438', '573704', '593608',
    }


class CalciumChannelBlockers(ValueSet):
    VALUE_SET_NAME = 'Calcium Channel Blockers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150388', '150971', '150971', '157397', '157397', '157397', '163131', '163469', '165159', '166892', '166937',
        '167154', '167446', '167533', '169016', '169333', '169575', '169724', '172336', '172574', '173510', '174042',
        '174216', '174329', '179043', '181751', '181760', '183030', '184293', '188074', '189800', '189800', '189800',
        '190102', '190699', '195723', '197599', '197868', '199176', '199183', '199183', '200428', '200536', '202300',
        '202624', '202624', '203222', '204075', '204075', '204954', '206632', '210233', '215924', '216567', '216994',
        '217891', '217957', '218493', '221627', '222232', '222653', '223252', '223454', '223832', '224261', '227404',
        '227404', '231949', '231994', '232070', '232755', '233458', '233862', '234418', '235013', '237106', '242216',
        '242574', '243374', '245877', '250514', '250555', '251572', '252860', '256364', '258765', '263208', '263208',
        '263208', '263497', '263832', '263969', '264530', '266829', '270258', '270809', '272840', '274382', '275518',
        '278272', '279901', '280202', '280578', '283789', '287217', '288346', '289725', '289807', '295814', '297780',
        '298200', '299351', '299547', '445556', '448708', '448709', '448710', '448711', '448712', '448713', '448714',
        '448715', '448716', '448717', '448718', '448719', '449404', '449405', '449406', '449407', '449408', '449641',
        '449642', '471091', '471092', '471093', '472924', '472925', '472926', '554465', '554466', '554467', '554468',
        '554485', '554486', '554488', '555943', '555944', '555949', '556229', '556234', '556246', '556247', '556824',
        '556825', '556852', '557530', '557531', '562934', '564006', '564010', '564014', '564015', '564017', '573746',
        '578844', '579027', '588178', '589942', '593472', '594433', '594436', '594569', '595607',
    }


class Antiarrhythmics(ValueSet):
    VALUE_SET_NAME = 'Antiarrhythmics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150358', '151807', '152779', '155773', '157601', '160121', '165621', '166591', '169107', '169508', '170461',
        '174429', '175363', '175494', '178251', '183239', '184929', '185830', '189377', '189730', '190878', '193821',
        '194412', '195187', '196380', '198310', '199400', '203114', '205183', '206598', '208686', '210260', '210732',
        '212898', '221901', '222092', '223459', '224332', '228864', '230155', '237183', '243776', '243776', '248491',
        '248829', '250272', '251530', '251766', '260972', '261266', '261929', '262594', '265464', '265785', '274471',
        '278255', '278255', '278255', '278255', '280333', '281153', '283306', '288964', '291187', '296991', '444249',
        '444249', '444944', '444944', '449494', '449496', '451558', '451559', '451560', '453457', '453462', '454178',
        '454180', '454181', '454205', '454206', '454207', '454371', '545231', '545231', '545232', '545233', '545238',
        '545239', '545239', '558741', '558745', '559416', '560050', '563304', '563305', '563306', '563310', '564459',
        '564460', '565068', '565069', '573523', '583982', '583982', '583985', '583985', '590326', '590375', '590376',
        '591479', '592349', '592421', '594710', '594714',
    }


class AntiarrhythmicClassINonspecific(ValueSet):
    VALUE_SET_NAME = 'Antiarrhythmic - Class I Nonspecific'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntiarrhythmicClassIa(ValueSet):
    VALUE_SET_NAME = 'Antiarrhythmic - Class Ia'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152779', '175494', '184929', '189730', '196380', '198310', '199400', '205183', '208686', '210260', '210732',
        '221901', '261266', '262594', '265464', '592349',
    }


class AntiarrhythmicClassIb(ValueSet):
    VALUE_SET_NAME = 'Antiarrhythmic - Class Ib'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '237183', '265785', '274471', '545231', '545231', '545232', '545233', '545238', '545239', '545239', '573523',
        '592421',
    }


class AntiarrhythmicClassIc(ValueSet):
    VALUE_SET_NAME = 'Antiarrhythmic - Class Ic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155773', '165621', '169107', '224332', '230155', '248491', '251766', '280333', '454178', '454180', '454181',
        '454205', '454206', '454207',
    }


class AntiarrhythmicClassIi(ValueSet):
    VALUE_SET_NAME = 'Antiarrhythmic - Class II'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151807', '157601', '169508', '174429', '178251', '185830', '193821', '203114', '206598', '212898', '222092',
        '223459', '248829', '250272', '251530', '260972', '261929', '283306', '291187', '449494', '449496', '451558',
        '451559', '451560', '559416', '560050', '583982', '583982', '583985', '583985', '590375', '590376',
    }


class AntiarrhythmicOthers(ValueSet):
    VALUE_SET_NAME = 'Antiarrhythmic Others'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '243776', '243776', '444249', '444249', '444944', '444944', '591479', '594710', '594714',
    }


class AntihypertensiveTherapyAgents(ValueSet):
    VALUE_SET_NAME = 'Antihypertensive Therapy Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150020', '150221', '150297', '150297', '150320', '150773', '151400', '151988', '152422', '152614', '153773',
        '154635', '154750', '154866', '156288', '157469', '158667', '159940', '159940', '160255', '161211', '161298',
        '162288', '162421', '162494', '162874', '163710', '163803', '164694', '165773', '165852', '166281', '166886',
        '166924', '166924', '167314', '168196', '169032', '169224', '169234', '169840', '169840', '169856', '170588',
        '170591', '170613', '171394', '171884', '171884', '172097', '172563', '173241', '173833', '174191', '174384',
        '176000', '176891', '177415', '179012', '179012', '179602', '181227', '182213', '182716', '182850', '183474',
        '183474', '186112', '186112', '186234', '186858', '186858', '187439', '187439', '187815', '188424', '189764',
        '190365', '191433', '191934', '192199', '192315', '193057', '194263', '195418', '195832', '196675', '197215',
        '197641', '197954', '198689', '200345', '200623', '201995', '202492', '202892', '203110', '203158', '203275',
        '203578', '204185', '204201', '204201', '205558', '205664', '205744', '206091', '206181', '206201', '206319',
        '206464', '206587', '206985', '208605', '208631', '208761', '208877', '208934', '212737', '213457', '213723',
        '214605', '215708', '217875', '218498', '218840', '218937', '219729', '220510', '221158', '221158', '221638',
        '221656', '221842', '221895', '221895', '223083', '223191', '224288', '227444', '228042', '228701', '228846',
        '228880', '229173', '230231', '230370', '230456', '230741', '230905', '230905', '233066', '233466', '234355',
        '238209', '239278', '239555', '239555', '239908', '239916', '240070', '241128', '241285', '241448', '241732',
        '241751', '243183', '243990', '244100', '244655', '244736', '244899', '244899', '244899', '245792', '245870',
        '246658', '246934', '247057', '247110', '247495', '247613', '247613', '247725', '247994', '248758', '248758',
        '249335', '250623', '250811', '250819', '251749', '252934', '253349', '253941', '254675', '254675', '255618',
        '256633', '256736', '257120', '257247', '257247', '257956', '257956', '258059', '258203', '258630', '260822',
        '261128', '261128', '261287', '261396', '262157', '262886', '263025', '263564', '264202', '264202', '265458',
        '265804', '266033', '266229', '266373', '267633', '267825', '268023', '268029', '268029', '268312', '268801',
        '268801', '269488', '269739', '270066', '270066', '272059', '273426', '273480', '273550', '274165', '275384',
        '275733', '275733', '278349', '278605', '278853', '278853', '279496', '280075', '280204', '280394', '280890',
        '282212', '282548', '283356', '284012', '285229', '285229', '286047', '286502', '286924', '287115', '288522',
        '288522', '288657', '289479', '289576', '290144', '290144', '290376', '291283', '291544', '291760', '291935',
        '292473', '292473', '292534', '293385', '295201', '295494', '295862', '295951', '296073', '296945', '296945',
        '296945', '297195', '298890', '299225', '299893', '400055', '401081', '401081', '401082', '401082', '443458',
        '443459', '443459', '443460', '443460', '443461', '443462', '443462', '443463', '443463', '443654', '443655',
        '443656', '443657', '443667', '443668', '443669', '443670', '444559', '444735', '446003', '446006', '446239',
        '446431', '450728', '450729', '450730', '450731', '450732', '450733', '470673', '470673', '470680', '470680',
        '473403', '473404', '474324', '474488', '474503', '474546', '475457', '475458', '476278', '476280', '476805',
        '476806', '545217', '545218', '545219', '545220', '545309', '545309', '545310', '545310', '545313', '545313',
        '545314', '545314', '549879', '549881', '549893', '549894', '551394', '551394', '551394', '551395', '551395',
        '551395', '551402', '551402', '551402', '551403', '551403', '551403', '551468', '551469', '551470', '551471',
        '551494', '551495', '551496', '551497', '552971', '552973', '552974', '552977', '552982', '552983', '552984',
        '552985', '554080', '554081', '554082', '554083', '554107', '554108', '554109', '554110', '555887', '555893',
        '558217', '558217', '558218', '558218', '558219', '558219', '558220', '558220', '558221', '558221', '558227',
        '558227', '558228', '558228', '558229', '558229', '558230', '558230', '558231', '558231', '558708', '559048',
        '559074', '559074', '559075', '559076', '559079', '559080', '559082', '559098', '559631', '559631', '559640',
        '559640', '559641', '559641', '559642', '559642', '559656', '559657', '559658', '559659', '560596', '560598',
        '561779', '561780', '561781', '561782', '561783', '561790', '561791', '561792', '561793', '561795', '562074',
        '562075', '562076', '562077', '562079', '562080', '562081', '562082', '562498', '563423', '563426', '563434',
        '563435', '565125', '569670', '569671', '569672', '569686', '569687', '569688', '569727', '569728', '569729',
        '569730', '575020', '575211', '575278', '578104', '579516', '579530', '579963', '579963', '579964', '579964',
        '579965', '579965', '579966', '579966', '579967', '579967', '579969', '579969', '579970', '579970', '579971',
        '579971', '579972', '579972', '579973', '579973', '580089', '580089', '580094', '580094', '580525', '580526',
        '580527', '580528', '581178', '581179', '581180', '581181', '582494', '583030', '583735', '583736', '583739',
        '586515', '586515', '586516', '586516', '586517', '586517', '586523', '586523', '586524', '586524', '586525',
        '586525', '586659', '586660', '586661', '588751', '588752', '588753', '588754', '588755', '588756', '588757',
        '588758', '588761', '588763', '588765', '588766', '588767', '588768', '588769', '588770', '588771', '588772',
        '589898', '590941', '591365', '591418', '591421', '591871', '591977', '593211', '593220', '593825', '593833',
        '594376', '594842', '595393', '595423',
    }


class AceInhibitors(ValueSet):
    VALUE_SET_NAME = 'ACE Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150320', '151988', '152422', '157469', '158667', '163803', '166924', '166924', '169234', '169840', '169840',
        '170591', '171394', '176891', '179012', '179012', '183474', '183474', '186112', '186112', '186234', '189764',
        '191433', '197641', '202492', '203110', '204201', '204201', '206201', '206464', '208631', '208761', '208877',
        '218498', '219729', '221638', '227444', '228042', '228880', '230231', '233466', '239278', '240070', '241751',
        '243183', '244736', '244899', '244899', '244899', '247057', '247110', '250819', '253349', '256633', '257247',
        '257247', '264202', '264202', '267825', '268801', '268801', '269739', '272059', '273480', '278853', '278853',
        '279496', '282212', '285229', '285229', '286924', '288522', '288522', '290376', '291544', '291760', '295201',
        '295494', '295862', '298890', '579516', '579530', '591418', '591421', '591871', '591977',
    }


class AngiotensinIiReceptorBlockersArbs(ValueSet):
    VALUE_SET_NAME = 'Angiotensin II Receptor Blockers (ARBs)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150773', '169856', '173833', '176000', '195832', '200345', '203578', '206587', '230741', '230905', '230905',
        '239555', '239555', '239916', '241128', '247613', '247613', '247725', '247994', '249335', '250811', '257120',
        '257956', '257956', '261287', '261396', '262157', '268023', '270066', '270066', '273426', '273550', '286047',
        '288657', '289576', '291935', '297195', '299225', '443458', '443459', '443459', '443460', '443460', '443461',
        '443462', '443462', '443463', '443463', '446003', '446006', '563423', '563426', '563434', '563435',
    }


class PostganglionicBlockersAntihypertensive(ValueSet):
    VALUE_SET_NAME = 'Postganglionic Blockers, Antihypertensive'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class PeripheralAlpha1ReceptorBlockers(ValueSet):
    VALUE_SET_NAME = 'Peripheral Alpha-1 Receptor Blockers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154750', '154866', '165773', '167314', '169032', '170613', '179602', '201995', '206319', '213457', '217875',
        '223191', '228701', '229173', '258059', '260822', '262886', '278605', '289479', '293385', '295951', '473403',
        '473404', '476805', '476806',
    }


class Vasodilators(ValueSet):
    VALUE_SET_NAME = 'Vasodilators'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156288', '197954', '205664', '208605', '221158', '221158', '238209', '243990', '255618', '267633', '269488',
        '292473', '292473', '474488', '474503', '593211', '593220', '595393', '595423',
    }


class AntihypertensiveFluoroquinoloneVasodilators(ValueSet):
    VALUE_SET_NAME = 'Antihypertensive - Fluoroquinolone Vasodilators'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DopamineD1ReceptorAgonistsAntihypertensive(ValueSet):
    VALUE_SET_NAME = 'Dopamine D1 Receptor Agonists, Antihypertensive'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '221158', '221158', '292473', '292473',
    }


class MaoisAntihypertensive(ValueSet):
    VALUE_SET_NAME = 'MAOIs, Antihypertensive'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntihypertensiveTherapyCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihypertensive Therapy Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150221', '154635', '161211', '162494', '162874', '166886', '173241', '174191', '177415', '187815', '192199',
        '195418', '197215', '200623', '202892', '205558', '206091', '206181', '214605', '220510', '221842', '223083',
        '258203', '266229', '266373', '283356', '291283', '299893', '569670', '569671', '569672', '569686', '569687',
        '569688',
    }


class AceInhibitorAndCalciumChannelBlockerCombinations(ValueSet):
    VALUE_SET_NAME = 'ACE Inhibitor and Calcium Channel Blocker Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151400', '162421', '163710', '170588', '190365', '212737', '230370', '234355', '247495', '252934', '266033',
        '282548', '444559', '444735', '446239', '446431', '545217', '545218', '545219', '545220', '583735', '583736',
        '583739', '586659', '586660', '586661',
    }


class AceInhibitorAndDiureticCombinations(ValueSet):
    VALUE_SET_NAME = 'ACE Inhibitor and Diuretic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152614', '153773', '164694', '166281', '171884', '171884', '172563', '182213', '182716', '191934', '192315',
        '193057', '194263', '198689', '204185', '208934', '215708', '221656', '228846', '230456', '239908', '245870',
        '246934', '261128', '261128', '263564', '265458', '275733', '275733', '280394', '280890', '287115', '296073',
        '400055',
    }


class BetaBlockerDiureticCombinations(ValueSet):
    VALUE_SET_NAME = 'Beta Blocker-Diuretic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161211', '162494', '162874', '166886', '173241', '174191', '187815', '192199', '195418', '197215', '202892',
        '205558', '206091', '206181', '214605', '220510', '221842', '223083', '258203', '283356', '569670', '569671',
        '569672', '569686', '569687', '569688',
    }


class BetaAdrenergicBlockerCalciumChannelBlockerCombinations(ValueSet):
    VALUE_SET_NAME = 'Beta-Adrenergic Blocker-Calcium Channel Blocker Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AngiotensinIiReceptorBlockerArbDiureticCombinations(ValueSet):
    VALUE_SET_NAME = 'Angiotensin II Receptor Blocker (ARB)-Diuretic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150297', '150297', '161298', '162288', '169224', '187439', '187439', '213723', '218840', '233066', '241285',
        '244655', '246658', '248758', '248758', '250623', '253941', '254675', '254675', '265804', '268029', '268029',
        '280075', '280204', '296945', '296945', '296945', '401081', '401081', '401082', '401082', '450728', '450729',
        '450730', '450731', '450732', '450733', '470673', '470673', '470680', '470680', '475457', '475458', '545309',
        '545309', '545310', '545310', '545313', '545313', '545314', '545314', '555887', '555893', '569727', '569728',
        '569729', '569730',
    }


class CentralAlpha2AgonistsDiureticCombinations(ValueSet):
    VALUE_SET_NAME = 'Central Alpha-2 Agonists-Diuretic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150221', '154635', '177415', '200623', '266229', '266373', '291283', '299893',
    }


class PeripheralAlpha1ReceptorBlockerDiureticCombination(ValueSet):
    VALUE_SET_NAME = 'Peripheral Alpha-1 Receptor Blocker-Diuretic Combination'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntihypertensiveOtherDiureticCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihypertensive Other-Diuretic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class PostganglionicBlockerDiureticCombinations(ValueSet):
    VALUE_SET_NAME = 'Postganglionic Blocker-Diuretic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Diuretics(ValueSet):
    VALUE_SET_NAME = 'Diuretics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152246', '152894', '153306', '153685', '154382', '154760', '154760', '154760', '156119', '161530', '162073',
        '162073', '165453', '165921', '166096', '166963', '167761', '170248', '170248', '172209', '174192', '175248',
        '176024', '176024', '177657', '180924', '182414', '182414', '185186', '187319', '192121', '192363', '193388',
        '194408', '200876', '200893', '201306', '203322', '205678', '206108', '206831', '208244', '208244', '208944',
        '214223', '218896', '218979', '219112', '220295', '225788', '226152', '228951', '230529', '234555', '235084',
        '235858', '237799', '238614', '240445', '241149', '242086', '251043', '251412', '253304', '254794', '254964',
        '255379', '255926', '256468', '258026', '258592', '258592', '259132', '259776', '263690', '264012', '265507',
        '269382', '269382', '270143', '270502', '270502', '270502', '271542', '271854', '275763', '275763', '275763',
        '275763', '277246', '278109', '279161', '281973', '283326', '290295', '294909', '297017', '299395', '299750',
        '299797', '444329', '444329', '446392', '446393', '453398', '453399', '549792', '557670', '557699', '558061',
        '558313', '558317', '558383', '558384', '558387', '558388', '561123', '561124', '565266', '565266', '568584',
        '569455', '592310', '593762', '593796', '594305', '594305',
    }


class DiureticCarbonicAnhydraseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Diuretic - Carbonic Anhydrase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '166096', '174192', '175248', '193388', '201306', '205678', '238614', '241149', '251412', '299797',
    }


class DiureticLoop(ValueSet):
    VALUE_SET_NAME = 'Diuretic - Loop'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152894', '153306', '154760', '154760', '154760', '156119', '165453', '165921', '166963', '170248', '170248',
        '177657', '180924', '187319', '194408', '218979', '219112', '225788', '230529', '235858', '237799', '242086',
        '251043', '255926', '256468', '264012', '270143', '270502', '270502', '270502', '444329', '444329', '558061',
        '561123', '561124', '568584', '592310',
    }


class DiureticMercurial(ValueSet):
    VALUE_SET_NAME = 'Diuretic - Mercurial'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DiureticOsmotic(ValueSet):
    VALUE_SET_NAME = 'Diuretic - Osmotic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154382', '162073', '162073', '200893', '218896', '258026', '258592', '258592', '275763', '275763', '275763',
        '275763', '281973', '299750', '593762', '593796',
    }


class DiureticPotassiumSparing(ValueSet):
    VALUE_SET_NAME = 'Diuretic - Potassium Sparing'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '220295', '240445', '254794', '255379', '283326',
    }


class DiureticThiazidesAndRelated(ValueSet):
    VALUE_SET_NAME = 'Diuretic - Thiazides and Related'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153685', '172209', '176024', '176024', '192121', '192363', '200876', '203322', '208944', '228951', '234555',
        '235084', '253304', '254964', '259132', '265507', '269382', '269382', '271854', '278109', '549792',
    }


class DiureticMiscellaneous(ValueSet):
    VALUE_SET_NAME = 'Diuretic - Miscellaneous'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '263690', '558313', '558317', '569455',
    }


class DiureticMiscellaneousAndMiscellaneousCombinations(ValueSet):
    VALUE_SET_NAME = 'Diuretic - Miscellaneous and Miscellaneous Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '263690', '558313', '558317', '569455',
    }


class DiureticMiscellaneousAndPotassiumCombinations(ValueSet):
    VALUE_SET_NAME = 'Diuretic - Miscellaneous and Potassium Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DiureticMiscellaneousCombinationsOther(ValueSet):
    VALUE_SET_NAME = 'Diuretic - Miscellaneous Combinations - Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class CardiovascularSympathomimeticsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Cardiovascular Sympathomimetics and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153818', '153818', '156234', '156234', '156234', '156234', '180229', '186526', '191303', '223317', '269775',
        '270702', '270702', '270702', '275334', '275334', '289043', '289043', '291938', '292098', '292098', '295515',
        '430494', '430494', '444034', '451405', '474318', '548811', '554756', '556635', '556636', '556638', '556724',
        '556725', '556726', '556727', '556731', '556732', '556733', '556737', '556738', '557145', '557255', '557256',
        '558369', '558370', '558620', '558650', '558650', '560073', '560073', '560888', '561087', '561101', '561480',
        '561491', '561495', '561567', '561581', '561582', '561583', '561586', '561587', '561588', '561764', '561873',
        '563122', '563262', '563294', '563309', '563312', '564242', '564242', '564270', '567026', '567027', '568009',
        '569260', '570542', '571124', '571484', '571529', '572132', '573123', '573580', '573881', '573882', '574107',
        '574108', '574141', '574142', '574144', '574145', '574148', '574149', '574535', '574538', '574540', '574666',
        '574700', '574701', '574702', '574703', '574776', '575119', '575617', '575618', '576527', '576529', '580925',
        '580926', '580927', '581952', '581952', '581952', '582287', '582288', '582289', '587702', '587801', '587880',
        '588179', '589845', '590383', '590390', '590607', '590607', '590661', '590760', '590995', '591729', '591957',
        '592396', '592598', '592601', '592641', '592645', '593302', '593402', '593933', '594005', '594075', '594076',
        '594086', '594092', '594192', '594857', '594915', '594966', '594984', '594987', '594988', '595044', '595045',
        '595643', '596013',
    }


class CardiovascularSympathomimeticAnaphylaxisTherapyAgents(ValueSet):
    VALUE_SET_NAME = 'Cardiovascular Sympathomimetic - Anaphylaxis Therapy Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '180229', '186526', '275334', '275334', '451405', '474318', '560073', '560073', '575617', '575618', '576527',
        '576529', '587702', '587801', '591957', '592598', '592601', '592641', '592645', '593933', '595643', '596013',
    }


class CardiovascularSympathomimeticAnaphylaxisTherapyAgentCombinations(ValueSet):
    VALUE_SET_NAME = 'Cardiovascular Sympathomimetic-Anaphylaxis Therapy Agent Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class CardiovascularSympathomimeticCombinations(ValueSet):
    VALUE_SET_NAME = 'Cardiovascular Sympathomimetic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Antihyperlipidemics(ValueSet):
    VALUE_SET_NAME = 'Antihyperlipidemics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150475', '151266', '154892', '154892', '158585', '161081', '163181', '163181', '165097', '168953', '169018',
        '170255', '170427', '170427', '171377', '173289', '173289', '180691', '181235', '184650', '184650', '184906',
        '185650', '187634', '187634', '187647', '190025', '197702', '199160', '201075', '202334', '203422', '205621',
        '205621', '205767', '209275', '209275', '209407', '209964', '210074', '215025', '216881', '217974', '219761',
        '223663', '225051', '225051', '227996', '229128', '231211', '231982', '234602', '235395', '235982', '237672',
        '238251', '238251', '239979', '241540', '245894', '250293', '250661', '251829', '253952', '257180', '257180',
        '268217', '268217', '270465', '270691', '275447', '276332', '277834', '277834', '281676', '282815', '284793',
        '285060', '285060', '286606', '286939', '288658', '288864', '288864', '293008', '294944', '295035', '296278',
        '299576', '299603', '439440', '439452', '439455', '445200', '445201', '445202', '445783', '445784', '446097',
        '446639', '446641', '449815', '449950', '450258', '451272', '451272', '451274', '451274', '451275', '451293',
        '451294', '451295', '451296', '451299', '451300', '451301', '451302', '453061', '454235', '454236', '454236',
        '454236', '454253', '454253', '454254', '454459', '454460', '454461', '454462', '454463', '454464', '454465',
        '454466', '466583', '467344', '467345', '467346', '467347', '467348', '467349', '467350', '467351', '469750',
        '469751', '469752', '470914', '470934', '471104', '471105', '471135', '471137', '471138', '471139', '471145',
        '471146', '471147', '471148', '471271', '472462', '472463', '472671', '472672', '472673', '472677', '472678',
        '472679', '472737', '472738', '472769', '474054', '474114', '474183', '475241', '475242', '475684', '476780',
        '545137', '545180', '545759', '545763', '545911', '545912', '546661', '546679', '546683', '546793', '546813',
        '546868', '546874', '546890', '550543', '550560', '551389', '551770', '551770', '551891', '552230', '552230',
        '552232', '552510', '552511', '552547', '552548', '552800', '552805', '552828', '552901', '552931', '552938',
        '553071', '554320', '554321', '554322', '554331', '554332', '554333', '554361', '554362', '554380', '554381',
        '554706', '554726', '555694', '555706', '555956', '557006', '557007', '557009', '557010', '557147', '557161',
        '557578', '557607', '557807', '557814', '557836', '558286', '558299', '558768', '558790', '558803', '559040',
        '559067', '559069', '559070', '559163', '559446', '559452', '559952', '560121', '560123', '560127', '560268',
        '560626', '560700', '561122', '561290', '561291', '561292', '561308', '561309', '561310', '561398', '561761',
        '561770', '561775', '561776', '561787', '561788', '562027', '562047', '562236', '562487', '562503', '562964',
        '563043', '563189', '563229', '563230', '563272', '563336', '563365', '563416', '563419', '563427', '563495',
        '563529', '564038', '564052', '564071', '564104', '564540', '564581', '564730', '564819', '564828', '564918',
        '565043', '565113', '565189', '565255', '565574', '565701', '565718', '567099', '568542', '568627', '568983',
        '569131', '570097', '570212', '570727', '570883', '572218', '572258', '572650', '572682', '572999', '573013',
        '573252', '573296', '573323', '573391', '573564', '573744', '573809', '573815', '573866', '573876', '573879',
        '573911', '574000', '574050', '574101', '575188', '575206', '575207', '575988', '576233', '576459', '576460',
        '576461', '576669', '576671', '576672', '577177', '577217', '577359', '577394', '577406', '577410', '577576',
        '577609', '577653', '577730', '578096', '578167', '578244', '578244', '578245', '578245', '578246', '578246',
        '578247', '578247', '578260', '578260', '578261', '578261', '578262', '578262', '578263', '578263', '578908',
        '579006', '579121', '579176', '579395', '579660', '579661', '579662', '579671', '579672', '579673', '579752',
        '580009', '580214', '580227', '580228', '580239', '580243', '580244', '580250', '580341', '580889', '581538',
        '581573', '581620', '581631', '581655', '581901', '583146', '583147', '583153', '583154', '583212', '583221',
        '583278', '583282', '583836', '584001', '584253', '584539', '585082', '585083', '585132', '585133', '585305',
        '585434', '585469', '585546', '585547', '585725', '585727', '585729', '585737', '585741', '585742', '585743',
        '585799', '586685', '586748', '586768', '586770', '586771', '586772', '586774', '586780', '586781', '586783',
        '586784', '586854', '586935', '586988', '587005', '587137', '587139', '587143', '587155', '587259', '587347',
        '587520', '587567', '587575', '587593', '587948', '588147', '588619', '590388', '590389', '591159', '591164',
        '591731', '591928', '591950', '592100', '592199', '592337', '592380', '592803', '593012', '593260', '593442',
        '593550', '593714', '593790', '593880', '593922', '594014', '594015', '594016', '594046', '594211', '594212',
        '594220', '594494', '594513', '594638', '594737', '594769', '594959', '595766', '595767', '595768',
    }


class AntihyperlipidemicBileAcidSequestrants(ValueSet):
    VALUE_SET_NAME = 'Antihyperlipidemic - Bile Acid Sequestrants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '209407', '231211', '234602', '237672', '239979', '257180', '257180', '281676', '285060', '285060', '288658',
        '288864', '288864', '451272', '451272', '451274', '451274', '451275', '454235', '454236', '454236', '454236',
        '454253', '454253', '454254', '471104', '471271', '551770', '551770', '552230', '552230', '552232', '560121',
        '560127',
    }


class AntihyperlipidemicFibricAcidDerivatives(ValueSet):
    VALUE_SET_NAME = 'Antihyperlipidemic - Fibric Acid Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '201075', '205767', '210074', '235982', '276332', '445783', '445784', '446097', '472462', '472463', '472737',
        '472738', '474114', '474183', '475241', '475242', '545911', '545912', '552510', '552511', '552547', '552548',
        '554361', '554362', '554380', '554381', '555956', '557006', '557007', '557009', '557010', '559040', '559067',
        '559069', '559070', '561122', '580227', '580228', '580243', '580244',
    }


class AlternativeTherapyNaturalHmgCoaReductaseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Alternative Therapy - Natural HMG CoA Reductase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntihyperlipidemicNicotinicAcidDerivatives(ValueSet):
    VALUE_SET_NAME = 'Antihyperlipidemic - Nicotinic Acid Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161081', '165097', '184906', '185650', '190025', '199160', '216881', '253952',
    }


class AntihyperlipidemicAgentsOther(ValueSet):
    VALUE_SET_NAME = 'Antihyperlipidemic Agents Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '168953', '169018', '170255', '180691', '187647', '202334', '231982', '250293', '284793', '295035', '299576',
        '299603', '439440', '439452', '439455', '449815', '449950', '450258', '453061', '466583', '470914', '470934',
        '471105', '472769', '474054', '475684', '476780', '545137', '545180', '546661', '546679', '546683', '546793',
        '546813', '546868', '546874', '546890', '550543', '550560', '551389', '551891', '552800', '552805', '552828',
        '552901', '552931', '552938', '553071', '554706', '554726', '555694', '555706', '557147', '557161', '557578',
        '557607', '557807', '557814', '557836', '558286', '558299', '558768', '558790', '558803', '559163', '559446',
        '559452', '559952', '560123', '560268', '560626', '560700', '561398', '561761', '561770', '562027', '562047',
        '562236', '562487', '562503', '562964', '563043', '563189', '563229', '563230', '563272', '563336', '563365',
        '563416', '563419', '563427', '563495', '563529', '564038', '564052', '564071', '564104', '564540', '564581',
        '564730', '564819', '564828', '564918', '565043', '565113', '565189', '565255', '565574', '565701', '565718',
        '567099', '568542', '568627', '568983', '569131', '570097', '570212', '570727', '570883', '572218', '572258',
        '572650', '572682', '572999', '573013', '573252', '573296', '573323', '573391', '573564', '573744', '573809',
        '573815', '573866', '573876', '573879', '573911', '574000', '574050', '574101', '575188', '575206', '575207',
        '575988', '576233', '577359', '577394', '577406', '577410', '577576', '577609', '577653', '577730', '578096',
        '578167', '578908', '579006', '579121', '579176', '579395', '579660', '579661', '579662', '579671', '579672',
        '579673', '579752', '580009', '580214', '580239', '580250', '580341', '580889', '581538', '581573', '581620',
        '581631', '581655', '581901', '583146', '583147', '583153', '583154', '583212', '583221', '583278', '583282',
        '583836', '584001', '584253', '584539', '585082', '585083', '585132', '585133', '585305', '585434', '585469',
        '585546', '585547', '585737', '585799', '586685', '586748', '586774', '586854', '586935', '586988', '587005',
        '587259', '587347', '587520', '587567', '587575', '587593', '587948', '588147', '588619', '591731', '591928',
        '591950', '592100', '592199', '592337', '592380', '592803', '593012', '593260', '593442', '593550', '593714',
        '593790', '593880', '593922', '594046', '594220', '594494', '594513', '594638', '594737', '594769', '594959',
    }


class AntihyperlipidemicCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihyperlipidemic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '171377', '215025', '219761', '250661', '270465', '275447', '454459', '454460', '454461', '454462', '454463',
        '454464', '454465', '454466', '467344', '467345', '467346', '467347', '467348', '467349', '467350', '467351',
        '471135', '471137', '471138', '471139', '471145', '471146', '471147', '471148', '472671', '472672', '472673',
        '472677', '472678', '472679', '545759', '545763', '554320', '554321', '554322', '554331', '554332', '554333',
        '561775', '561776', '561787', '561788', '578244', '578244', '578245', '578245', '578246', '578246', '578247',
        '578247', '578260', '578260', '578261', '578261', '578262', '578262', '578263', '578263',
    }


class AntihyperlipidemicFibricAcidDerivativeCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihyperlipidemic - Fibric Acid Derivative Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class PeripheralVasodilators(ValueSet):
    VALUE_SET_NAME = 'Peripheral Vasodilators'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '182850', '205744', '290144', '290144',
    }


class PeripheralVasodilatorCombinations(ValueSet):
    VALUE_SET_NAME = 'Peripheral Vasodilator Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class PulmonaryAntihypertensiveAgents(ValueSet):
    VALUE_SET_NAME = 'Pulmonary Antihypertensive Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '168196', '174384', '203158', '203275', '206985', '244100', '245792', '275384', '443654', '443655', '443656',
        '443657', '443667', '443668', '443669', '443670', '474324', '474546', '476278', '476280', '551394', '551394',
        '551394', '551395', '551395', '551395', '551402', '551402', '551402', '551403', '551403', '551403', '558708',
        '559048', '559074', '559074', '559075', '559076', '559079', '559080', '559082', '559098', '560596', '560598',
        '562498', '565125', '575020', '575211', '575278', '579963', '579963', '579964', '579964', '579965', '579965',
        '579966', '579966', '579967', '579967', '579969', '579969', '579970', '579970', '579971', '579971', '579972',
        '579972', '579973', '579973', '580089', '580089', '580094', '580094', '580525', '580526', '580527', '580528',
        '581178', '581179', '581180', '581181', '582494', '583030', '588751', '588752', '588753', '588754', '588755',
        '588756', '588757', '588758', '588761', '588763', '588765', '588766', '588767', '588768', '588769', '588770',
        '588771', '588772', '589898', '593825', '593833', '594376', '594842',
    }


class CardioplegicSolutions(ValueSet):
    VALUE_SET_NAME = 'Cardioplegic Solutions'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159668', '194709', '585223', '585285', '587361', '587362', '587391', '587401', '589504', '589509', '590299',
        '590373', '590418', '592251', '594573', '594586', '594619', '594633', '594653', '594728', '594773', '595190',
        '595209',
    }


class DrugsToTreatErectileDysfunction(ValueSet):
    VALUE_SET_NAME = 'Drugs to treat Erectile Dysfunction'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '163033', '170033', '172567', '180029', '185745', '186458', '205275', '207454', '221033', '227663', '244529',
        '248739', '250182', '250589', '255099', '257032', '257273', '258863', '269228', '274650', '275008', '278205',
        '278205', '283845', '292959', '292959', '451410', '451412', '451413', '451414', '451418', '451419', '451420',
        '451421', '453501', '453501', '453502', '453503', '453510', '453510', '453511', '453512', '547343', '547344',
        '554344', '554346', '563857', '563864', '580425', '580426', '580427', '580599', '580600', '580601', '590831',
        '590832', '590836', '590933', '590950', '590952',
    }


class ErectileDysfunctionEdDrugsProstaglandins(ValueSet):
    VALUE_SET_NAME = 'Erectile Dysfunction (ED) Drugs - Prostaglandins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '163033', '172567', '180029', '185745', '221033', '227663', '248739', '250182', '250589', '255099', '257032',
        '257273', '258863', '269228', '275008', '278205', '278205', '283845', '292959', '292959', '547343', '547344',
    }


class ErectileDysfunctionEdDrugsSelCgmpPhosphodiesteraseType5Inhib(ValueSet):
    VALUE_SET_NAME = 'Erectile Dysfunction (ED) Drugs-Sel.cGMP Phosphodiesterase Type5 Inhib'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '170033', '186458', '205275', '207454', '244529', '274650', '451410', '451412', '451413', '451414', '451418',
        '451419', '451420', '451421', '453501', '453501', '453502', '453503', '453510', '453510', '453511', '453512',
        '554344', '554346', '563857', '563864', '580425', '580426', '580427', '580599', '580600', '580601',
    }


class Vasoprotectants(ValueSet):
    VALUE_SET_NAME = 'Vasoprotectants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class VasoprotectantCombinations(ValueSet):
    VALUE_SET_NAME = 'Vasoprotectant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Antihistamines(ValueSet):
    VALUE_SET_NAME = 'Antihistamines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150460', '150460', '150460', '152076', '155667', '155667', '155667', '155667', '156562', '159904', '159904',
        '161399', '161399', '161399', '161588', '161588', '161588', '161820', '163775', '164319', '164937', '164937',
        '164937', '167440', '170122', '170122', '170122', '170282', '170282', '170282', '170282', '170282', '170282',
        '170880', '172912', '178967', '179155', '179155', '180342', '180342', '180342', '180342', '180342', '180342',
        '180342', '180946', '182284', '184794', '193259', '194752', '196830', '199378', '199378', '199378', '199378',
        '201097', '201097', '201097', '201097', '201097', '208054', '208712', '209376', '209376', '209376', '214190',
        '215020', '215020', '215020', '216259', '216542', '216542', '216573', '216573', '223200', '224098', '224098',
        '225697', '226679', '227537', '227537', '227537', '227761', '229839', '230708', '230708', '232013', '234616',
        '235806', '237438', '238770', '238770', '238770', '238770', '238770', '238966', '239826', '239826', '243574',
        '243574', '243574', '243574', '243574', '244334', '245783', '245783', '245783', '246852', '248172', '251020',
        '251020', '260011', '260407', '260407', '262895', '262895', '264152', '276620', '276620', '276620', '276620',
        '284785', '286486', '288586', '290453', '290453', '290453', '290453', '292857', '292857', '292857', '292857',
        '292857', '292857', '292857', '292857', '292857', '292857', '295102', '296765', '299478', '400657', '400657',
        '400657', '400657', '430714', '430762', '430762', '430763', '430766', '430766', '430770', '430770', '430770',
        '430770', '430770', '430789', '430789', '430791', '430792', '430792', '430792', '430792', '430798', '430806',
        '430808', '430809', '430809', '430824', '430838', '443632', '445602', '445602', '445602', '448081', '448081',
        '448243', '448243', '448827', '448922', '448922', '448994', '448994', '448994', '448994', '449660', '449788',
        '450714', '451409', '452587', '452587', '453761', '453900', '467496', '467722', '467722', '467723', '467723',
        '467723', '468338', '468338', '470730', '470730', '471894', '471894', '471894', '471894', '471894', '472227',
        '472473', '472473', '472653', '472653', '472653', '472653', '472696', '472787', '473146', '473146', '473314',
        '473314', '473399', '473399', '473399', '473399', '473586', '474276', '474489', '474489', '474974', '476691',
        '509228', '546747', '546749', '548729', '548729', '549992', '549992', '549992', '549992', '550006', '550006',
        '550006', '550006', '550116', '550210', '552264', '552264', '552426', '552576', '552576', '552584', '552584',
        '553428', '554011', '554341', '554341', '554341', '554341', '554341', '554341', '554341', '554341', '554632',
        '554632', '554632', '554632', '554632', '554632', '554704', '554742', '554828', '554828', '554845', '554949',
        '554949', '554952', '555126', '555126', '555126', '556540', '557164', '558386', '559019', '559409', '559455',
        '559455', '559488', '560597', '560604', '560791', '560949', '560990', '561000', '561003', '561013', '561154',
        '561154', '561421', '561421', '561430', '561430', '561915', '562026', '562026', '562026', '562086', '562086',
        '562255', '562306', '562864', '562864', '562864', '563097', '563097', '563100', '563100', '563100', '563140',
        '563140', '563388', '563395', '563396', '563460', '563460', '563461', '563461', '563468', '563468', '563468',
        '563469', '563469', '563554', '563554', '563721', '563721', '563721', '563939', '564531', '564531', '564531',
        '564698', '565789', '566447', '566447', '567382', '567602', '567619', '569447', '570392', '571029', '571030',
        '571131', '575331', '575456', '575456', '575692', '575692', '576256', '576256', '576433', '576433', '576433',
        '576701', '576745', '577789', '577855', '577920', '577960', '578153', '578153', '578529', '578825', '578832',
        '578983', '580881', '581163', '581238', '581238', '581259', '581612', '581691', '581691', '582159', '582167',
        '582234', '582297', '582297', '582297', '582297', '582301', '582301', '582303', '582304', '582327', '582328',
        '582377', '582460', '583867', '586668', '586754', '586754', '586777', '586909', '586914', '587484', '591062',
        '591726', '592163', '592206', '592224', '592238', '592351', '593075', '593078', '593093', '593947', '593953',
        '594073', '594120', '594640', '595615',
    }


class Antihistamine1stGenerationAlkylamines(ValueSet):
    VALUE_SET_NAME = 'Antihistamine - 1st Generation - Alkylamines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Antihistamine1stGenerationEthanolamines(ValueSet):
    VALUE_SET_NAME = 'Antihistamine - 1st Generation - Ethanolamines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Antihistamine1stGenerationEthylenediamines(ValueSet):
    VALUE_SET_NAME = 'Antihistamine - 1st Generation - Ethylenediamines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Antihistamine1stGenerationPhenothiazines(ValueSet):
    VALUE_SET_NAME = 'Antihistamine - 1st Generation - Phenothiazines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Antihistamine1stGenerationPiperidines(ValueSet):
    VALUE_SET_NAME = 'Antihistamine - 1st Generation - Piperidines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Antihistamines2ndGeneration(ValueSet):
    VALUE_SET_NAME = 'Antihistamines - 2nd Generation'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161399', '161399', '161399', '164937', '164937', '164937', '170122', '170122', '170122', '170282', '170282',
        '170282', '170282', '170282', '170282', '172912', '180342', '180342', '180342', '180342', '180342', '180342',
        '180342', '199378', '199378', '199378', '199378', '201097', '201097', '201097', '201097', '201097', '209376',
        '209376', '209376', '235806', '238966', '292857', '292857', '292857', '292857', '292857', '292857', '292857',
        '292857', '292857', '292857', '296765', '448243', '448243', '448922', '448922', '448994', '448994', '448994',
        '448994', '449788', '452587', '452587', '453900', '467496', '467722', '467722', '467723', '467723', '467723',
        '470730', '470730', '472696', '472787', '474489', '474489', '474974', '476691', '548729', '548729', '549992',
        '549992', '549992', '549992', '550006', '550006', '550006', '550006', '552264', '552264', '552576', '552576',
        '552584', '552584', '554011', '554341', '554341', '554341', '554341', '554341', '554341', '554341', '554341',
        '554632', '554632', '554632', '554632', '554632', '554632', '554704', '554742', '554828', '554828', '554845',
        '554949', '554949', '554952', '555126', '555126', '555126', '556540', '557164', '558386', '559019', '559409',
        '559488', '560597', '560604', '561000', '561154', '561154', '561421', '561421', '561430', '561430', '561915',
        '562026', '562026', '562026', '562086', '562086', '562864', '562864', '562864', '563097', '563097', '563100',
        '563100', '563100', '563140', '563140', '563388', '563460', '563460', '563461', '563461', '563468', '563468',
        '563468', '563469', '563469', '563721', '563721', '563721', '563939', '564531', '564531', '564531', '564698',
        '567382', '567619', '569447', '571131', '575456', '575456', '575692', '575692', '576256', '576256', '576433',
        '576433', '576433', '577960', '578983', '581238', '581238', '581691', '581691', '582234', '582297', '582297',
        '582297', '582297', '583867', '586777', '587484', '591062', '593093',
    }


class AntihistamineCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntihistamineAntihistamineCombinations1stGeneration(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Antihistamine Combinations - 1st Generation'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class C1stGenerationAntihistamineAnticholinergicCombinations(ValueSet):
    VALUE_SET_NAME = '1st Generation Antihistamine - Anticholinergic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntihistamineAntianxietyCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine - Antianxiety Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class NasalPreparations(ValueSet):
    VALUE_SET_NAME = 'Nasal Preparations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153491', '153491', '153491', '156164', '157002', '159794', '160566', '162239', '162239', '162691', '166335',
        '166335', '166335', '166335', '166727', '166727', '174979', '180203', '180339', '183019', '183019', '183019',
        '189392', '197688', '199011', '199651', '202392', '202392', '204339', '204458', '207269', '207269', '212455',
        '215054', '215858', '216467', '221042', '222828', '222988', '223279', '230287', '231622', '234688', '234688',
        '237054', '237054', '237319', '240371', '240371', '245887', '245887', '245887', '245887', '247129', '250675',
        '250675', '252563', '258941', '259866', '274292', '274292', '275672', '280077', '280077', '280439', '287370',
        '287370', '287370', '287370', '287492', '291052', '291137', '291137', '293752', '293752', '294649', '297104',
        '298386', '431089', '431089', '431092', '431092', '431097', '431101', '431104', '431130', '431131', '431151',
        '431151', '431155', '431155', '446327', '446327', '446327', '446327', '446327', '446601', '448548', '448548',
        '448548', '448549', '448549', '448549', '448559', '448577', '448910', '448913', '448915', '450088', '450091',
        '450091', '450091', '450093', '450093', '450093', '450094', '450098', '450110', '450110', '450111', '450196',
        '450196', '450196', '450196', '450196', '450196', '450196', '450196', '450196', '450238', '450245', '450715',
        '452976', '453846', '453853', '470682', '470689', '470696', '470697', '471748', '473228', '473590', '473605',
        '473884', '474376', '474376', '474395', '474399', '474433', '474433', '474433', '474433', '474433', '474434',
        '474441', '474441', '474442', '474442', '476720', '545720', '545750', '545981', '547461', '549058', '550809',
        '550809', '550809', '550810', '551975', '551977', '552481', '552488', '552495', '552858', '552859', '553259',
        '553259', '553260', '553362', '553367', '553367', '553377', '553377', '553383', '553383', '554075', '554614',
        '554830', '554832', '554948', '555489', '555683', '557425', '557782', '557970', '558039', '558039', '558039',
        '558039', '558045', '558223', '558643', '558643', '558643', '558666', '558675', '558675', '559263', '559300',
        '560216', '561756', '561760', '561760', '561762', '561834', '561834', '561928', '561929', '564102', '564587',
        '568176', '568220', '570133', '571730', '571739', '572483', '572991', '573068', '573350', '573350', '573393',
        '573399', '573810', '574528', '574530', '574531', '574533', '574553', '575297', '575311', '575367', '575622',
        '575622', '576905', '577196', '577244', '580991', '580991', '581461', '581881', '582137', '582371', '582398',
        '582398', '582399', '582399', '582399', '582399', '582399', '582400', '582401', '582419', '582421', '582421',
        '582937', '582991', '583490', '583522', '583523', '583583', '583583', '583583', '587563', '588240', '588240',
        '589152', '589152', '589311', '589315', '589326', '589528', '589528', '590164', '590249', '590552', '590552',
        '590552', '590552', '590842', '590963', '591162', '591163', '591163', '592449', '592471', '592681', '592708',
        '592885', '592885', '593934', '593965', '594136', '594491', '594598', '594865', '595091', '595394', '595857',
        '595986',
    }


class SystemicSympathomimeticDecongestants(ValueSet):
    VALUE_SET_NAME = 'Systemic Sympathomimetic Decongestants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158973', '182273', '182273', '197837', '197837', '199714', '199714', '199714', '200129', '207818', '214645',
        '214645', '214729', '251127', '265334', '265334', '265334', '265334', '265334', '266678', '279935', '287628',
        '287628', '291199', '291199', '291199', '291728', '291728', '296252', '401105', '401112', '430998', '430998',
        '430998', '431008', '431035', '431065', '431073', '431073', '445281', '446098', '446098', '449050', '449050',
        '468355', '472770', '472770', '472770', '472778', '472778', '473469', '473469', '473485', '473485', '474080',
        '474080', '474080', '474080', '474080', '475254', '476401', '476448', '476448', '476485', '550325', '550576',
        '550656', '550676', '552489', '553506', '553506', '553506', '554178', '554178', '554178', '554178', '558985',
        '559331', '572976', '572976', '572978', '576169', '576169', '576216', '577057', '579725', '587912', '591125',
        '591160', '591160', '591179', '591179', '595564',
    }


class NasalSympathomimeticDecongestantsIntranasal(ValueSet):
    VALUE_SET_NAME = 'Nasal Sympathomimetic Decongestants (Intranasal)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157002', '159794', '160566', '180339', '197688', '199651', '202392', '202392', '204339', '204458', '212455',
        '215054', '216467', '223279', '234688', '234688', '237054', '237054', '240371', '240371', '247129', '250675',
        '250675', '259866', '280439', '287492', '291052', '293752', '293752', '431089', '431089', '431092', '431092',
        '431097', '431101', '431104', '431130', '431131', '446601', '448577', '448910', '448913', '448915', '450088',
        '450093', '450093', '450093', '450094', '450098', '450110', '450110', '450111', '450238', '450245', '450715',
        '452976', '473590', '473605', '473884', '545981', '549058', '552481', '552488', '552495', '552858', '552859',
        '553362', '553367', '553367', '557425', '560216', '576905', '581461', '582371', '582991', '595857',
    }


class NasalCorticosteroids(ValueSet):
    VALUE_SET_NAME = 'Nasal Corticosteroids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153491', '153491', '153491', '162691', '230287', '231622', '237319', '245887', '245887', '245887', '245887',
        '258941', '275672', '287370', '287370', '287370', '287370', '547461', '550809', '550809', '550809', '550810',
        '554614', '570133', '571730', '571739', '573068', '580991', '580991', '583522', '583523', '583583', '583583',
        '583583', '587563', '588240', '588240', '589152', '589152', '589311', '589315', '589326', '589528', '589528',
        '590552', '590552', '590552', '590552', '590963', '591162', '591163', '591163', '592885', '592885', '594136',
        '594491', '594598', '594865', '595986',
    }


class NasalAntiInfectives(ValueSet):
    VALUE_SET_NAME = 'Nasal Anti-infectives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '294649', '298386',
    }


class NasalAntibiotics(ValueSet):
    VALUE_SET_NAME = 'Nasal Antibiotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '294649', '298386',
    }


class NasalAnticholinergics(ValueSet):
    VALUE_SET_NAME = 'Nasal Anticholinergics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '189392', '199011', '280077', '280077', '291137', '291137',
    }


class NasalAntiallergy(ValueSet):
    VALUE_SET_NAME = 'Nasal Antiallergy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '162239', '162239', '166335', '166335', '166335', '166335', '274292', '274292', '431151', '431151', '554830',
        '554832', '559263', '559300',
    }


class NasalAntihistamines(ValueSet):
    VALUE_SET_NAME = 'Nasal Antihistamines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '274292', '274292', '554830', '554832', '559263', '559300',
    }


class NasalMastCellStabilizers(ValueSet):
    VALUE_SET_NAME = 'Nasal Mast Cell Stabilizers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '162239', '162239', '166335', '166335', '166335', '166335', '431151', '431151',
    }


class NasalMucolytics(ValueSet):
    VALUE_SET_NAME = 'Nasal Mucolytics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class NasalPreparationsOther(ValueSet):
    VALUE_SET_NAME = 'Nasal Preparations Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '593934', '593965',
    }


class NasalCombinations(ValueSet):
    VALUE_SET_NAME = 'Nasal Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '174979', '221042', '252563', '448548', '448548', '448548', '448549', '448549', '448549', '448559', '453846',
        '453853', '474376', '474376', '474395', '474399', '474433', '474433', '474433', '474433', '474433', '474434',
        '474441', '474441', '474442', '474442', '551975', '551977', '553259', '553259', '553260', '553383', '553383',
        '554075', '554948', '555489', '555683', '557970', '558039', '558039', '558039', '558039', '558045', '558223',
        '558643', '558643', '558643', '558666', '558675', '558675', '561760', '561760', '561834', '561834', '564587',
        '568176', '568220', '572483', '572991', '573350', '573350', '573393', '573399', '574528', '574530', '574531',
        '574533', '574553', '575367', '577196', '577244', '582398', '582398', '582399', '582399', '582399', '582399',
        '582399', '582400', '582401', '582419', '582421', '582421', '582937', '590164', '590249', '590842', '592449',
        '592471', '592681', '592708',
    }


class NasalDecongestantAntihistamineCombinations(ValueSet):
    VALUE_SET_NAME = 'Nasal Decongestant-Antihistamine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class NasalDecongestantCombinationsOther(ValueSet):
    VALUE_SET_NAME = 'Nasal Decongestant Combinations Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class NasalDecongestantCorticosteroidCombinations(ValueSet):
    VALUE_SET_NAME = 'Nasal Decongestant-Corticosteroid Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class NasalMastCellStabilizerAntihistamineCombinations(ValueSet):
    VALUE_SET_NAME = 'Nasal Mast Cell Stabilizer-Antihistamine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class NasalMastCellStabilizerDecongestantAnalgesicCombinations(ValueSet):
    VALUE_SET_NAME = 'Nasal Mast Cell Stabilizer-Decongestant-Analgesic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Antitussives(ValueSet):
    VALUE_SET_NAME = 'Antitussives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152596', '159946', '159946', '162870', '162870', '173864', '175383', '182472', '197758', '199915', '219365',
        '220038', '221749', '223754', '235305', '278656', '299191', '445739', '445739', '453498', '453534', '468414',
        '472844', '472872', '475473', '550918', '552723', '552744', '552803', '556521', '560485', '560492', '562401',
        '567330', '569759', '573636', '573693', '574671', '575368', '579579', '579706', '579726', '582094', '589075',
        '589075', '589276', '589276', '589972', '591413', '591766',
    }


class AntitussivesNarcotic(ValueSet):
    VALUE_SET_NAME = 'Antitussives - Narcotic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntitussivesNonnarcotic(ValueSet):
    VALUE_SET_NAME = 'Antitussives - Nonnarcotic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152596', '159946', '159946', '162870', '162870', '173864', '175383', '182472', '197758', '199915', '219365',
        '220038', '221749', '223754', '235305', '278656', '299191', '445739', '445739', '453498', '453534', '468414',
        '472844', '472872', '475473', '550918', '552723', '552744', '552803', '556521', '560485', '560492', '562401',
        '567330', '569759', '573636', '573693', '574671', '575368', '579579', '579706', '579726', '582094', '589075',
        '589075', '589276', '589276', '589972', '591413', '591766',
    }


class ExpectorantsSingleAgentsGeneral(ValueSet):
    VALUE_SET_NAME = 'Expectorants - Single Agents, General'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '177397', '187417', '206912', '206912', '206912', '206912', '210644', '210644', '221492', '221492', '221492',
        '221492', '230136', '230136', '230136', '232845', '270471', '273000', '273000', '273336', '273336', '277941',
        '277941', '278458', '278458', '278458', '431244', '431244', '431266', '431267', '431268', '431270', '431270',
        '431273', '431273', '431277', '445423', '445423', '445423', '445423', '445423', '445423', '445423', '448163',
        '450886', '450886', '473166', '473591', '473591', '474006', '474383', '474760', '546103', '546110', '551189',
        '552775', '552775', '552809', '552809', '552809', '552809', '552824', '552824', '552824', '552824', '553037',
        '555050', '555778', '556565', '556570', '556749', '556976', '556976', '556976', '559255', '560445', '560738',
        '561080', '562979', '562979', '565406', '566711', '570789', '574327', '574327', '575950', '575950', '576710',
        '580657', '580657', '580657', '580657', '580657', '580657', '580657', '582063', '582708', '589803', '589803',
        '590675', '592837', '592837',
    }


class ExpectorantsIodineContainingAgents(ValueSet):
    VALUE_SET_NAME = 'Expectorants - Iodine Containing Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '237329', '473947',
    }


class ExpectorantMixtures(ValueSet):
    VALUE_SET_NAME = 'Expectorant Mixtures'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Mucolytics(ValueSet):
    VALUE_SET_NAME = 'Mucolytics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157476', '157476', '157476', '235115', '237169', '255965', '255965', '255965',
    }


class AromaticAntitussivesForVaporization(ValueSet):
    VALUE_SET_NAME = 'Aromatic Antitussives for Vaporization'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '163983', '163983', '163983', '172266', '190576', '215386', '286724', '286724', '286724', '431319', '444282',
        '444282', '448877', '448877', '473461', '592381', '592522',
    }


class CoughAndColdOrAllergyCombinations(ValueSet):
    VALUE_SET_NAME = 'Cough and Cold or Allergy Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150813', '151114', '151114', '151939', '152121', '152476', '152476', '152476', '152476', '153203', '154025',
        '154025', '155293', '156741', '156741', '157530', '157844', '157844', '157915', '157915', '160637', '162433',
        '162967', '164880', '165033', '165033', '165435', '165435', '165535', '166293', '166860', '168473', '169509',
        '170906', '171687', '171687', '172053', '172131', '172283', '173301', '173373', '173373', '173373', '175316',
        '176053', '176539', '177001', '178169', '178463', '178463', '179819', '179863', '179863', '180806', '182486',
        '182486', '182486', '182486', '184646', '185097', '185137', '185435', '185601', '186306', '189386', '190681',
        '190939', '192844', '193595', '193618', '193618', '193946', '195041', '195053', '195053', '195297', '195297',
        '198424', '199757', '199757', '201662', '201662', '201662', '201662', '201831', '202433', '205302', '207801',
        '209171', '209171', '211616', '211616', '216418', '216513', '216513', '216857', '216857', '216857', '217037',
        '217037', '217037', '217037', '217037', '217037', '217847', '219964', '220327', '220327', '220562', '220562',
        '220942', '220942', '220953', '220953', '220953', '223532', '223630', '223986', '223986', '224665', '224665',
        '224665', '225305', '225305', '226289', '226534', '226664', '227220', '227699', '229479', '229575', '231079',
        '231293', '232441', '234720', '234720', '234720', '235218', '235218', '235442', '235442', '238024', '238592',
        '240794', '241398', '241398', '241820', '242227', '242410', '244365', '244365', '244365', '245298', '245298',
        '245298', '245524', '245687', '246080', '247355', '248130', '248130', '248130', '249613', '250032', '251457',
        '251457', '251457', '251457', '251457', '251457', '252311', '252311', '253385', '253385', '253491', '256245',
        '256651', '259052', '259052', '259052', '259790', '260718', '260965', '260965', '260965', '260965', '260965',
        '262319', '265591', '266124', '266139', '266139', '266139', '266346', '266803', '266972', '266972', '266972',
        '267493', '267727', '267898', '268630', '268630', '268630', '269115', '269961', '270369', '270500', '271018',
        '271018', '271573', '271807', '272759', '272759', '274297', '274297', '275083', '275083', '275083', '275613',
        '276176', '276600', '276600', '277147', '277345', '277345', '277345', '277890', '278113', '278693', '278693',
        '278693', '278693', '278901', '279357', '279357', '279701', '279974', '282750', '284181', '284183', '284183',
        '284440', '284440', '285630', '286662', '286662', '286662', '288299', '288299', '290699', '290699', '292967',
        '293613', '293613', '293613', '296058', '296157', '298977', '299674', '299674', '299674', '400065', '400233',
        '400259', '400266', '400266', '400266', '400400', '400785', '400785', '400837', '401113', '431348', '431370',
        '431391', '431403', '431743', '431801', '431873', '432285', '432313', '432314', '432573', '432663', '432666',
        '432667', '432842', '432842', '432845', '433029', '433170', '433215', '433226', '433233', '433235', '433250',
        '433250', '433250', '433291', '433541', '433547', '435554', '435555', '435558', '435562', '435563', '435574',
        '435578', '443549', '443549', '443647', '443688', '443918', '443986', '445444', '445444', '445444', '445518',
        '445519', '445519', '445844', '446366', '446366', '446668', '446668', '446813', '446830', '446905', '448160',
        '448612', '449425', '449425', '449425', '449584', '449597', '449685', '449685', '449732', '449756', '449756',
        '449756', '449922', '449922', '449922', '449922', '450005', '450713', '450713', '450713', '451132', '451132',
        '451132', '451132', '451396', '451540', '451616', '452107', '452336', '452609', '452609', '452609', '452991',
        '453045', '453045', '453045', '453884', '453884', '453884', '465073', '468328', '468328', '468329', '468329',
        '470729', '470729', '470729', '471220', '471289', '471289', '471289', '471289', '471587', '471587', '471692',
        '471777', '472010', '472476', '472476', '472476', '472562', '472609', '472706', '472756', '472756', '472828',
        '472828', '473072', '473185', '473185', '473189', '473190', '473210', '473210', '473466', '473530', '473577',
        '473577', '473577', '473582', '473582', '473583', '473583', '473583', '473593', '473593', '473638', '473837',
        '473856', '473856', '474021', '474021', '474037', '474137', '474138', '474430', '474430', '474453', '474453',
        '474520', '474728', '474728', '474728', '474728', '474728', '474728', '474728', '474729', '474729', '474729',
        '474729', '474729', '474738', '474738', '474739', '474739', '474739', '475042', '475047', '475047', '475061',
        '475115', '475115', '475149', '475151', '475163', '475306', '475306', '475319', '475319', '475369', '475370',
        '475474', '475474', '475510', '475510', '475624', '475654', '475683', '475688', '475759', '475801', '475910',
        '476074', '476126', '476178', '476279', '476434', '476434', '476461', '476475', '476487', '476498', '476499',
        '476505', '476589', '476681', '476681', '476681', '476692', '476727', '476727', '476727', '476737', '476755',
        '476755', '476755', '476756', '476756', '476756', '476756', '476841', '476842', '476842', '476842', '476847',
        '476848', '476849', '476849', '476849', '476849', '476850', '476850', '476850', '476850', '476850', '476850',
        '476862', '545096', '545096', '545096', '545100', '545109', '545109', '545174', '545174', '545174', '545174',
        '545174', '545293', '545293', '545490', '545490', '545491', '545491', '545522', '545522', '545522', '545537',
        '545537', '545537', '545537', '545645', '545645', '545677', '545677', '545677', '545703', '545703', '545804',
        '545916', '545916', '546104', '546116', '546116', '546116', '546117', '546118', '546118', '546118', '546131',
        '546132', '546132', '546132', '546132', '546136', '546136', '546144', '546147', '546147', '546147', '546147',
        '546147', '546147', '546148', '546148', '546164', '546189', '546227', '546276', '546294', '546294', '546294',
        '546337', '546338', '546340', '546401', '546403', '546403', '546403', '546403', '546412', '546412', '546412',
        '546412', '546412', '546438', '546468', '546478', '546551', '546588', '546588', '546592', '546659', '546659',
        '546660', '546870', '546870', '547135', '547158', '547180', '547181', '547181', '547218', '547348', '547348',
        '547370', '547432', '547459', '547472', '547472', '547480', '547608', '547608', '547647', '547745', '548197',
        '548197', '548631', '548631', '548650', '548730', '549050', '549057', '549186', '549187', '549187', '549214',
        '549676', '549800', '549801', '549802', '549802', '549866', '549937', '549968', '549968', '550403', '550434',
        '550468', '550479', '550490', '550500', '550501', '550503', '550545', '550545', '550561', '550577', '550583',
        '550646', '550679', '550728', '550747', '550749', '550756', '550760', '550765', '550767', '551042', '551042',
        '551190', '551191', '551191', '551192', '551252', '551252', '551275', '551282', '551316', '551635', '551635',
        '551664', '551664', '552193', '552193', '552278', '552300', '552301', '552311', '552331', '552335', '552347',
        '552375', '552375', '552375', '552425', '552425', '552457', '552542', '552542', '552613', '552613', '552623',
        '552667', '552708', '552776', '552776', '552777', '552802', '552832', '552832', '552925', '552942', '552943',
        '552954', '552955', '553074', '553134', '553134', '553204', '553204', '553278', '553339', '553341', '553348',
        '553348', '553348', '553348', '553395', '553514', '553570', '553577', '553577', '553580', '553585', '553586',
        '553595', '553606', '553606', '553747', '553748', '554118', '554145', '554162', '554258', '554288', '554342',
        '554390', '554390', '554494', '554516', '554562', '554598', '554619', '554627', '554627', '554635', '554640',
        '554641', '554717', '554717', '554718', '554725', '554768', '554787', '554808', '554873', '554893', '554896',
        '554929', '554932', '554964', '554965', '555077', '555077', '555077', '555098', '555098', '555124', '555127',
        '555127', '555144', '555173', '555186', '555242', '555243', '555247', '555249', '555282', '555288', '555288',
        '555457', '555459', '555558', '555558', '555642', '555642', '555677', '555750', '555752', '555780', '555895',
        '555907', '555910', '555932', '555933', '555946', '555948', '555970', '555976', '555986', '556061', '556062',
        '556099', '556220', '556220', '556362', '556362', '556362', '556363', '556372', '556523', '556534', '556605',
        '556628', '556757', '556940', '556953', '556959', '556985', '557015', '557102', '557108', '557156', '557157',
        '557219', '557226', '557371', '557728', '557729', '557730', '557731', '557732', '558025', '558167', '558173',
        '558186', '558222', '558265', '558293', '558294', '558363', '558364', '558471', '558478', '558478', '558478',
        '558721', '558722', '558723', '558724', '558725', '558726', '558727', '558733', '558734', '558735', '558736',
        '558737', '558738', '558739', '558809', '558942', '558984', '559026', '559026', '559026', '559026', '559027',
        '559027', '559039', '559128', '559222', '559223', '559224', '559224', '559231', '559254', '559285', '559285',
        '559305', '559306', '559307', '559308', '559309', '559310', '559312', '559324', '559333', '559334', '559335',
        '559336', '559338', '559339', '559340', '559356', '559384', '559387', '559387', '559387', '559425', '559436',
        '559569', '559569', '559570', '559570', '559596', '559597', '559618', '559623', '559626', '559626', '559626',
        '559626', '559635', '559635', '559635', '559635', '559652', '559653', '559710', '559711', '559719', '559720',
        '559721', '559722', '559723', '559724', '559725', '559753', '559754', '559755', '559756', '559757', '559758',
        '559759', '559763', '560128', '560139', '560209', '560230', '560240', '560405', '560446', '560467', '560467',
        '560506', '560511', '560512', '560512', '560512', '560518', '560533', '560533', '560548', '560637', '560673',
        '560674', '560787', '560807', '560872', '560872', '560981', '560989', '560991', '561209', '561209', '561213',
        '561260', '561275', '561282', '561283', '561295', '561304', '561312', '561318', '561329', '561345', '561351',
        '561360', '561381', '561386', '561748', '561758', '561801', '561801', '561813', '561837', '561837', '561837',
        '561837', '561850', '561850', '561912', '561913', '562023', '562065', '562065', '562078', '562195', '562216',
        '562217', '562253', '562253', '562253', '562256', '562262', '562302', '562323', '562323', '562325', '562397',
        '562415', '562488', '562495', '562495', '562515', '562522', '562522', '562703', '562711', '562831', '563060',
        '563060', '563176', '563214', '563335', '563343', '563348', '563358', '563366', '563366', '563370', '563393',
        '563401', '563458', '563496', '563518', '563523', '563533', '563540', '563549', '563585', '563595', '563687',
        '563691', '563694', '563740', '563744', '563870', '563919', '563976', '564050', '564140', '564211', '564274',
        '564297', '564298', '564359', '564373', '564426', '564428', '564462', '564476', '564480', '564482', '564485',
        '564493', '564532', '564930', '565190', '565294', '565294', '565384', '565384', '565384', '565384', '565422',
        '565422', '565533', '565533', '565685', '565712', '565771', '565771', '565771', '565831', '565832', '565832',
        '566021', '566036', '566448', '566448', '566449', '566712', '566726', '566726', '566726', '566727', '566728',
        '566728', '566783', '566787', '566787', '566820', '566834', '566834', '566838', '566880', '566882', '566883',
        '566920', '566920', '566924', '566957', '567016', '567018', '567018', '567306', '567325', '567331', '567332',
        '567332', '567355', '567377', '567377', '567377', '567381', '567381', '567600', '567672', '567672', '567719',
        '567720', '567762', '567769', '567783', '567825', '567909', '567992', '567993', '568059', '568358', '568473',
        '568473', '568677', '568853', '568855', '569007', '569079', '569218', '569235', '569236', '569267', '569305',
        '569324', '569401', '569439', '569448', '569456', '569462', '569471', '569501', '569501', '569501', '569572',
        '569573', '569632', '569632', '569725', '569772', '569782', '569819', '569917', '569990', '569997', '570220',
        '570294', '570340', '570340', '570343', '570553', '570809', '570810', '570864', '570867', '570991', '570992',
        '571001', '571001', '571032', '571032', '571035', '571038', '571038', '571049', '571068', '571130', '571729',
        '571831', '571883', '571935', '571959', '572024', '572075', '572128', '572343', '572343', '572393', '572507',
        '572576', '572794', '572794', '572794', '572813', '572879', '572879', '572879', '572880', '572935', '572948',
        '572948', '572977', '573007', '573155', '573195', '573322', '573394', '573394', '573394', '573769', '573769',
        '573769', '573859', '573991', '574176', '574470', '574547', '574547', '574555', '574755', '574825', '574825',
        '574825', '574829', '574833', '574835', '574891', '575056', '575057', '575059', '575068', '575141', '575169',
        '575424', '575424', '575444', '575474', '575558', '575558', '575665', '575684', '575700', '575701', '575704',
        '575939', '575939', '575940', '575943', '575980', '575982', '575982', '576029', '576031', '576032', '576058',
        '576107', '576147', '576172', '576187', '576188', '576192', '576201', '576226', '576234', '576241', '576332',
        '576431', '576740', '576744', '576744', '576806', '576806', '576809', '576809', '576819', '576819', '576851',
        '576852', '576901', '576902', '576938', '576970', '576984', '576984', '576984', '576990', '577021', '577022',
        '577023', '577024', '577185', '577211', '577367', '577367', '577397', '577399', '577403', '577403', '577404',
        '577404', '577405', '577487', '577656', '577657', '577781', '577830', '577847', '577961', '577996', '578006',
        '578041', '578076', '578086', '578202', '578299', '578337', '578352', '578379', '578416', '578469', '578544',
        '578545', '578546', '578577', '578750', '578776', '578800', '578828', '578829', '578833', '578835', '578855',
        '578898', '578900', '578963', '578965', '578967', '578968', '578968', '578968', '578988', '579004', '579010',
        '579014', '579018', '579041', '579206', '579206', '579226', '579226', '579226', '579241', '579266', '579266',
        '579275', '579275', '579275', '579297', '579297', '579472', '579472', '579483', '579483', '579524', '579525',
        '579566', '579595', '579596', '579613', '579620', '579630', '579640', '579736', '579765', '579852', '579865',
        '579865', '579865', '579886', '579886', '579887', '579919', '579978', '579985', '579999', '579999', '580019',
        '580022', '580028', '580038', '580046', '580115', '580191', '580192', '580204', '580251', '580295', '580298',
        '580311', '580429', '580446', '580446', '580446', '580503', '580503', '580515', '580784', '580789', '580796',
        '580804', '580809', '580810', '580833', '580900', '581045', '581116', '581137', '581140', '581140', '581143',
        '581144', '581148', '581148', '581153', '581192', '581217', '581255', '581255', '581256', '581257', '581262',
        '581266', '581266', '581278', '581287', '581288', '581289', '581410', '581411', '581491', '581519', '581560',
        '581575', '581591', '581594', '581602', '581603', '581617', '581618', '581622', '581713', '581714', '581737',
        '581811', '581836', '581837', '581837', '581846', '581868', '581879', '581899', '581899', '582004', '582005',
        '582034', '582045', '582048', '582049', '582049', '582049', '582072', '582084', '582085', '582085', '582085',
        '582086', '582086', '582104', '582138', '582140', '582145', '582150', '582163', '582368', '582369', '582372',
        '582373', '582373', '582373', '582373', '582373', '582373', '582378', '582379', '582416', '582429', '582433',
        '582434', '582462', '582529', '582554', '582565', '582609', '582644', '582644', '582661', '582661', '582691',
        '582799', '582799', '582804', '582817', '582821', '582821', '582844', '582845', '582935', '582960', '582960',
        '583046', '583066', '583075', '583099', '583120', '583182', '583183', '583185', '583186', '583237', '583261',
        '583319', '583333', '583345', '583384', '583405', '583419', '583560', '583560', '583567', '583567', '583639',
        '583837', '583855', '583886', '583931', '583961', '584005', '584026', '584142', '584560', '584632', '584668',
        '584669', '584673', '584673', '585035', '585225', '585380', '585454', '585548', '585592', '585612', '585781',
        '585818', '585845', '585879', '585942', '585944', '585972', '586099', '586123', '586150', '586194', '586208',
        '586213', '586215', '586217', '586223', '586225', '586229', '586230', '586240', '586258', '586288', '586290',
        '586384', '586393', '586651', '586657', '586658', '586710', '586738', '586778', '586782', '586891', '586911',
        '586916', '586945', '586947', '586963', '586996', '586998', '587019', '587049', '587052', '587112', '587118',
        '587127', '587132', '587136', '587192', '587192', '587267', '587287', '587384', '587422', '587426', '587509',
        '587564', '587690', '587950', '588124', '588145', '588204', '588217', '588280', '588283', '588284', '588288',
        '588290', '588299', '588467', '588467', '588583', '588736', '589147', '589351', '589382', '589408', '589490',
        '589650', '589656', '589851', '589876', '589892', '589892', '589930', '589944', '589944', '589955', '589957',
        '590028', '590204', '590232', '590251', '590274', '590294', '590294', '590469', '590489', '590497', '590654',
        '590672', '590776', '590780', '590904', '590987', '591040', '591142', '591260', '591367', '591414', '591562',
        '591563', '591579', '591585', '591747', '591748', '591772', '591773', '591777', '591778', '591874', '591910',
        '591949', '591958', '591975', '592043', '592107', '592131', '592154', '592221', '592275', '592382', '592567',
        '592567', '592739', '592846', '592847', '592862', '592862', '593241', '593460', '593488', '593589', '593638',
        '593800', '593977', '594002', '594003', '594018', '594019', '594106', '594493', '594540', '594732', '594732',
        '594783', '594801', '594815', '595024', '595025', '595038', '595071', '595078', '595101', '595108', '595113',
        '595174', '595193', '595241', '595302', '595316', '595419', '595676', '595813', '595827', '595837',
    }


class DecongestantAnalgesicCombinations(ValueSet):
    VALUE_SET_NAME = 'Decongestant-Analgesic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151939', '173301', '185137', '185435', '253385', '253385', '400837', '431348', '431370', '431391', '445444',
        '445444', '445444', '445518', '445519', '445519', '449425', '449425', '449425', '471220', '471777', '475061',
        '475115', '475115', '476434', '476434', '476841', '545645', '545645', '546116', '546116', '546116', '546276',
        '546294', '546294', '546294', '547180', '547608', '547608', '547647', '548631', '548631', '549057', '550577',
        '552311', '552832', '552832', '552925', '560506', '560533', '560533', '560872', '560872', '561381', '562323',
        '562323', '575665', '579613', '579999', '579999', '581255', '581255', '581266', '581266', '582368', '582529',
        '582960', '582960', '583319', '583345', '585942', '586738', '586963', '588284', '588467', '588467', '592131',
        '594783',
    }


class DecongestantAnalgesicAnticholinergicCombinations(ValueSet):
    VALUE_SET_NAME = 'Decongestant-Analgesic-Anticholinergic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntihistamineAnalgesicCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Analgesic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '172131', '195053', '195053', '201831', '223532', '226289', '232441', '260718', '266803', '271573', '277147',
        '278113', '279701', '292967', '293613', '293613', '293613', '431403', '435554', '435555', '435558', '435562',
        '435563', '435574', '435578', '443647', '449732', '453045', '453045', '453045', '471692', '475306', '475306',
        '475319', '475319', '475474', '475474', '475759', '475910', '552193', '552193', '555077', '555077', '555077',
        '559324', '561329', '561345', '563458', '563744', '564140', '564211', '564493', '568855', '569079', '572880',
        '573195', '574176', '579640', '582372', '582378', '582416', '583384', '583419', '583837', '583855', '585972',
        '587384', '590469', '590489', '591040', '592739',
    }


class AntihistamineAnalgesicAnticholinergicCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Analgesic-Anticholinergic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntihistamineDecongestantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Decongestant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151114', '151114', '154025', '154025', '162967', '165435', '165435', '184646', '185097', '189386', '198424',
        '216857', '216857', '216857', '217037', '217037', '217037', '217037', '217037', '217037', '217847', '224665',
        '224665', '224665', '225305', '225305', '231079', '234720', '234720', '234720', '241820', '244365', '244365',
        '244365', '251457', '251457', '251457', '251457', '251457', '251457', '256651', '259052', '259052', '259052',
        '262319', '266346', '270369', '272759', '272759', '276600', '276600', '286662', '286662', '286662', '400266',
        '400266', '400266', '431743', '431801', '431873', '445844', '446366', '446366', '448612', '449685', '449685',
        '449756', '449756', '449756', '449922', '449922', '449922', '449922', '450713', '450713', '450713', '451132',
        '451132', '451132', '451132', '451616', '452609', '452609', '452609', '453884', '453884', '453884', '470729',
        '470729', '470729', '472609', '472756', '472756', '473189', '473210', '473210', '473577', '473577', '473577',
        '473583', '473583', '473583', '475042', '475047', '475047', '475163', '475369', '475801', '476475', '476487',
        '476692', '545293', '545293', '545677', '545677', '545677', '545703', '545703', '545916', '545916', '546659',
        '546659', '546870', '546870', '547181', '547181', '547348', '547348', '547480', '548650', '548730', '549187',
        '549187', '550500', '550583', '550747', '550749', '550765', '550767', '553586', '553606', '553606', '554145',
        '554342', '554516', '554562', '554627', '554627', '554635', '554717', '554717', '554718', '554768', '555098',
        '555098', '555127', '555127', '555173', '555186', '555288', '555288', '555457', '556061', '556099', '557157',
        '557728', '557731', '558265', '558942', '560230', '560405', '560637', '560787', '560807', '560981', '560991',
        '561312', '561386', '561913', '562078', '562216', '563335', '563348', '563358', '563393', '563523', '563533',
        '563540', '563595', '564359', '564426', '564428', '566726', '566726', '566726', '566727', '567600', '567769',
        '567909', '569235', '569267', '569324', '569448', '569456', '569501', '569501', '569501', '569572', '571130',
        '571729', '571831', '571959', '572024', '572794', '572794', '572794', '572879', '572879', '572879', '572935',
        '572977', '573769', '573769', '573769', '573859', '573991', '575474', '576332', '576740', '576744', '576744',
        '577656', '577847', '577996', '578337', '579004', '580192', '580251', '580295', '580298', '580311', '580796',
        '580804', '580833', '581278', '581713', '581737', '581879', '582429', '583186', '586998', '589955', '590251',
        '590497', '590987', '591748', '591773', '591874', '591910',
    }


class AntihistamineDecongestantAnticholinergicCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Decongestant-Anticholinergic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160637', '267493',
    }


class AntihistamineDecongestantAnalgesicCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Decongestant-Analgesic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '166293', '179819', '219964', '246080', '247355', '270500', '271807', '299674', '299674', '299674', '401113',
        '432285', '432313', '432314', '449584', '449597', '465073', '474137', '474138', '476461', '476498', '545491',
        '545491', '546118', '546118', '546118', '546131', '546337', '546338', '546551', '546592', '547370', '547432',
        '547472', '547472', '549800', '549802', '549802', '550468', '550479', '550501', '550545', '550545', '550679',
        '551042', '551042', '551252', '551252', '552278', '552623', '552802', '553074', '553580', '553595', '554787',
        '555558', '555558', '556363', '556372', '557156', '558186', '558222', '558363', '558809', '559356', '559626',
        '559626', '559626', '559626', '559635', '559635', '559635', '559635', '560989', '561260', '561748', '562217',
        '562256', '563060', '563060', '563740', '565190', '566449', '566728', '566728', '567332', '567332', '567381',
        '567381', '567720', '569236', '571883', '571935', '575700', '575701', '575704', '576234', '576241', '577657',
        '577830', '579014', '580429', '580446', '580446', '580446', '580515', '581288', '581289', '581560', '581846',
        '582072', '582104', '582138', '582163', '582369', '585944', '586215', '586916', '589351', '589930', '592154',
        '592847', '595025',
    }


class AntihistamineDecongestantAnalgesicAnticholinergicCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Decongestant-Analgesic-Anticholinergic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntitussiveNarcoticCombinationsOther(ValueSet):
    VALUE_SET_NAME = 'Antitussive-Narcotic Combinations Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class NarcoticAntitussiveDecongestantCombinations(ValueSet):
    VALUE_SET_NAME = 'Narcotic Antitussive-Decongestant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '240794', '564476',
    }


class NarcoticAntitussiveAntihistamineCombinations(ValueSet):
    VALUE_SET_NAME = 'Narcotic Antitussive-Antihistamine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '195297', '195297', '279357', '279357', '282750', '552942', '552943', '552954', '552955', '555124', '555948',
        '555976', '557219', '557226', '558364', '558721', '558722', '558723', '558724', '558725', '558726', '558727',
        '558733', '558734', '558735', '558736', '558737', '558738', '558739', '577211', '577781', '585612', '586099',
    }


class NarcoticAntitussiveAntihistamineDecongestantCombinations(ValueSet):
    VALUE_SET_NAME = 'Narcotic Antitussive-Antihistamine-Decongestant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157915', '157915', '209171', '209171', '216513', '216513', '235442', '235442', '554725', '556940', '556953',
        '559618', '559623', '559719', '559720', '559721', '559722', '559723', '559724', '559725', '559753', '559754',
        '559755', '559756', '559757', '559758', '559759', '561318', '562488', '562515', '564480', '564485', '567762',
        '567825', '579919', '579985', '582034', '582045', '587049', '587112',
    }


class NarcoticAntitussiveAntihistamineDecongestantAnalgesicCombinations(ValueSet):
    VALUE_SET_NAME = 'Narcotic Antitussive-Antihistamine-Decongestant-Analgesic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class NonNarcAntitussive1stGenerationAntihistamineAnalgesicComb(ValueSet):
    VALUE_SET_NAME = 'Non-Narc Antitussive-1st Generation Antihistamine-Analgesic Comb.'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '400233', '400259', '452991', '474729', '474729', '474729', '474729', '474729', '474739', '474739', '474739',
        '475654', '476847', '545174', '545174', '545174', '545174', '545174', '546147', '546147', '546147', '546147',
        '546147', '546147', '546227', '546403', '546403', '546403', '546403', '550403', '550561', '552425', '552425',
        '552613', '552613', '553204', '553204', '556523', '560209', '561209', '561209', '561213', '564297', '565384',
        '565384', '565384', '565384', '565422', '565422', '567377', '567377', '567377', '569782', '569917', '569990',
        '569997', '570343', '573394', '573394', '573394', '575424', '575424', '576188', '576201', '576431', '582150',
        '582817', '582844', '586891',
    }


class NonNarcoticAntitussiveDecongestantCombinations(ValueSet):
    VALUE_SET_NAME = 'Non-Narcotic Antitussive-Decongestant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152121', '265591', '269115', '432573', '550646', '550760', '555282', '558984', '559039', '559128', '589656',
        '595174',
    }


class NonNarcoticAntitussiveAntihistamineCombinations(ValueSet):
    VALUE_SET_NAME = 'Non-Narcotic Antitussive-Antihistamine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157844', '157844', '164880', '175316', '176053', '226534', '476074', '476727', '476727', '476727', '476737',
        '476756', '476756', '476756', '476756', '546438', '546478', '549214', '554873', '554896', '555752', '557730',
        '558293', '558294', '564482', '564930', '568473', '568473', '577405', '577487', '578006', '578041', '578835',
        '578900', '578963', '578965', '581140', '581140', '581148', '581148', '582048', '582799', '582799', '582804',
        '582821', '582821', '582845', '584668', '590904', '593460', '593488', '593800', '594002', '594003', '594018',
        '594019',
    }


class NonNarcAntitussiveAntihistamineDecongestantCombinations(ValueSet):
    VALUE_SET_NAME = 'Non-Narc Antitussive-Antihistamine-Decongestant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156741', '156741', '157530', '166860', '202433', '220562', '220562', '223986', '223986', '226664', '229479',
        '249613', '259790', '271018', '271018', '275613', '279974', '284183', '284183', '284440', '284440', '400400',
        '432663', '432666', '432667', '451540', '452336', '473072', '475370', '545096', '545096', '545096', '545109',
        '545109', '546660', '547135', '547745', '549186', '550434', '550490', '550728', '550756', '551635', '551635',
        '551664', '551664', '552457', '552667', '554162', '554598', '555144', '555243', '555247', '555642', '555642',
        '555677', '555750', '555780', '556062', '556534', '557729', '557732', '560467', '560467', '561282', '561283',
        '561912', '562495', '562495', '563343', '563370', '563401', '563496', '563518', '563687', '563976', '564373',
        '564532', '567306', '567355', '567992', '568059', '569573', '570809', '570810', '570991', '570992', '571001',
        '571001', '571032', '571032', '572075', '572507', '572948', '572948', '573007', '573322', '575141', '575169',
        '576806', '576806', '576819', '576819', '576851', '576852', '577021', '577024', '577961', '578086', '578352',
        '578379', '578545', '578988', '579041', '579595', '579978', '580046', '581217', '581257', '581519', '581714',
        '581811', '581868', '583075', '583120', '583185', '583237', '586194', '587118', '587136', '587950', '589851',
        '591772', '591777', '591778', '592043', '592107', '592275', '592382', '594493', '594540', '595101', '595193',
        '595241',
    }


class NonNarcAntitussiveAntihistamineDecongestantAnalgesicCombinations(ValueSet):
    VALUE_SET_NAME = 'Non-Narc Antitussive-Antihistamine-Decongestant-Analgesic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '179863', '179863', '190939', '216418', '276176', '298977', '432842', '432842', '432845', '451396', '473466',
        '473837', '473856', '473856', '474453', '474453', '474520', '475149', '475151', '476178', '545490', '545490',
        '545537', '545537', '545537', '545537', '546148', '546148', '546340', '552301', '552331', '552776', '552776',
        '553278', '557371', '558471', '558478', '558478', '558478', '559026', '559026', '559026', '559026', '559027',
        '559027', '560240', '561275', '562023', '562195', '562415', '563176', '564050', '564298', '566920', '566920',
        '567018', '567018', '567719', '569462', '569471', '569819', '570294', '570340', '570340', '572128', '574825',
        '574825', '574825', '574829', '574835', '574891', '575056', '575057', '575059', '575068', '575939', '575939',
        '578750', '579472', '579472', '579852', '581622', '581836', '582049', '582049', '582049', '582644', '582644',
        '582661', '582661', '583931', '583961', '584560', '584632', '584673', '584673', '586288', '587019', '587052',
        '588299', '591747', '595108', '595113',
    }


class ExpectorantCombinationsOther(ValueSet):
    VALUE_SET_NAME = 'Expectorant Combinations - Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DecongestantExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Decongestant-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165033', '165033', '186306', '190681', '193618', '193618', '193946', '195041', '229575', '238592', '242410',
        '250032', '274297', '274297', '277890', '278901', '284181', '433029', '446905', '448160', '475510', '475510',
        '475683', '475688', '547158', '547218', '549801', '550503', '551192', '551275', '552335', '552708', '553341',
        '553514', '553748', '554258', '554288', '554640', '554929', '554965', '555895', '555907', '555910', '555932',
        '555946', '555970', '555986', '556220', '556220', '556605', '556628', '558025', '558173', '559222', '559223',
        '562703', '562711', '562831', '565685', '565712', '569401', '571035', '578577', '578828', '578829', '580204',
        '581137', '581153', '583183', '585225', '585454', '587564', '589892', '589892', '589944', '589944', '589957',
        '590028', '591562', '591579',
    }


class AntihistamineExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntihistamineExpectorantAnalgesicCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Expectorant-Analgesic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntihistamineDecongestantExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Decongestant-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DecongestantAnalgesicExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Decongestant-Analgesic-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '443918', '443986', '476849', '476849', '476849', '476849', '476862', '553585', '557015', '566820', '566883',
        '576970', '577404', '577404', '578776', '578967', '578968', '578968', '578968', '579206', '579206', '580809',
        '581410', '581899', '581899', '582084', '582140', '583046', '583066', '585548', '585845', '586657', '586658',
        '586710', '586778', '587127', '589650', '590776', '592221',
    }


class AntihistamineDecongestantAnalgesicExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Decongestant-Analgesic-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '579010', '579018', '587132', '587267', '591367', '595302', '595316',
    }


class AntitussiveDecongestantAnalgesicCombinations(ValueSet):
    VALUE_SET_NAME = 'Antitussive-Decongestant-Analgesic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '205302', '227699', '266124', '296058', '433170', '468328', '468328', '468329', '468329', '473190', '474728',
        '474728', '474728', '474728', '474728', '474728', '474728', '474738', '474738', '476126', '545522', '545522',
        '545522', '546132', '546132', '546132', '546132', '546144', '546164', '546189', '546401', '546412', '546412',
        '546412', '546412', '546412', '548197', '548197', '549050', '549676', '549937', '552300', '552375', '552375',
        '552375', '553395', '556362', '556362', '556362', '558167', '562065', '562065', '562397', '569632', '569632',
        '574755', '575940', '576226', '579620', '580789', '582373', '582373', '582373', '582373', '582373', '582373',
        '586213', '588583', '589490', '590274', '592846', '594801', '594815', '595038', '595071',
    }


class AntitussiveExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antitussive-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152476', '152476', '152476', '152476', '162433', '168473', '169509', '170906', '177001', '178463', '178463',
        '180806', '182486', '182486', '182486', '182486', '185601', '192844', '193595', '199757', '199757', '201662',
        '201662', '201662', '201662', '207801', '220327', '220327', '220942', '220942', '220953', '220953', '220953',
        '223630', '231293', '242227', '245298', '245298', '245298', '245524', '260965', '260965', '260965', '260965',
        '260965', '266139', '266139', '266139', '266972', '266972', '266972', '267898', '268630', '268630', '268630',
        '269961', '275083', '275083', '275083', '277345', '277345', '277345', '278693', '278693', '278693', '278693',
        '288299', '288299', '290699', '290699', '296157', '433215', '433226', '433233', '433235', '433250', '433250',
        '433250', '433291', '471289', '471289', '471289', '471289', '471587', '471587', '472010', '472476', '472476',
        '472476', '472562', '472828', '472828', '473185', '473185', '473530', '474430', '474430', '475624', '476279',
        '546104', '549866', '551190', '551191', '551191', '551282', '551316', '552347', '552777', '553339', '553348',
        '553348', '553348', '553348', '553570', '554118', '554494', '554808', '554893', '556757', '556959', '556985',
        '559224', '559224', '559231', '559254', '559285', '559285', '559384', '559425', '559436', '559711', '560446',
        '560674', '561351', '561360', '561801', '561801', '562302', '562325', '563214', '563549', '563585', '563870',
        '565294', '565294', '565533', '565533', '565771', '565771', '565771', '565831', '566712', '566783', '566880',
        '567325', '568358', '568853', '569725', '569772', '570864', '570867', '571038', '571038', '571068', '572576',
        '574470', '574555', '574833', '575558', '575558', '575980', '575982', '575982', '576032', '576058', '576107',
        '577022', '577023', '577403', '577403', '578076', '579865', '579865', '579865', '579886', '579886', '580028',
        '580115', '580503', '580503', '580900', '581287', '582004', '582434', '582462', '582935', '583099', '583333',
        '583560', '583560', '583567', '583567', '585380', '585592', '585781', '586150', '586911', '586947', '587422',
        '588280', '588288', '588736', '591975', '592567', '592567', '592862', '592862', '594732', '594732', '595676',
    }


class AntitussiveDecongestantExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antitussive-Decongestant-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153203', '155293', '165535', '171687', '171687', '172053', '173373', '173373', '173373', '176539', '178169',
        '211616', '211616', '235218', '235218', '241398', '241398', '245687', '248130', '248130', '248130', '253491',
        '267727', '285630', '400785', '400785', '443549', '443549', '443688', '446668', '446668', '452107', '473582',
        '473582', '473593', '473593', '476499', '476505', '476681', '476681', '476681', '476755', '476755', '476755',
        '476842', '476842', '476842', '545100', '546468', '549968', '549968', '552542', '552542', '553577', '553577',
        '553747', '554619', '554641', '554932', '554964', '555242', '555249', '555933', '557102', '557108', '559305',
        '559306', '559307', '559308', '559309', '559310', '559312', '559333', '559334', '559335', '559336', '559338',
        '559339', '559340', '559387', '559387', '559387', '559569', '559569', '559570', '559570', '559596', '559597',
        '559652', '559653', '559710', '559763', '560128', '560139', '560518', '560548', '560673', '561295', '561304',
        '561758', '561813', '561837', '561837', '561837', '561837', '561850', '561850', '562522', '562522', '563366',
        '563366', '563691', '563694', '564274', '564462', '565832', '565832', '566021', '566036', '566787', '566787',
        '567331', '567672', '567672', '567783', '568677', '569007', '569305', '569439', '570553', '571049', '572343',
        '572343', '572393', '574547', '574547', '575684', '576031', '576147', '576172', '576192', '576809', '576809',
        '576901', '576902', '576938', '577185', '577367', '577367', '577397', '577399', '578202', '578299', '578416',
        '578469', '578544', '578546', '578800', '578833', '578855', '578898', '579226', '579226', '579226', '579266',
        '579266', '579524', '579525', '579566', '579596', '579630', '579887', '580019', '580022', '580038', '581045',
        '581116', '581143', '581144', '581192', '581256', '581262', '581603', '581618', '582005', '582145', '582379',
        '582554', '582565', '582609', '582691', '583182', '583261', '583405', '583639', '583886', '585035', '585879',
        '586945', '587509', '588204', '588217', '588283', '588290', '589147', '589382', '589408', '589876', '590204',
        '591563', '591585', '591949', '591958', '593977', '594106',
    }


class AntitussiveAntihistamineExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antitussive-Antihistamine-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntitussiveAnalgesicExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antitussive-Analgesic-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntitussiveAntihistamineDecongestantExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antitussive-Antihistamine-Decongestant-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntitussiveDecongestantAnalgesicExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antitussive-Decongestant-Analgesic-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '238024', '252311', '252311', '400065', '433541', '433547', '446813', '446830', '473638', '474021', '474021',
        '474037', '476850', '476850', '476850', '476850', '476850', '476850', '545804', '546136', '546136', '546588',
        '546588', '547459', '553134', '553134', '554390', '554390', '555459', '560511', '560512', '560512', '560512',
        '566448', '566448', '566834', '566834', '566838', '566882', '567016', '567993', '569218', '570220', '573155',
        '575943', '576029', '576187', '576984', '576984', '576984', '576990', '579241', '579275', '579275', '579275',
        '579297', '579297', '579483', '579483', '580191', '580784', '580810', '581411', '581591', '582085', '582085',
        '582085', '582086', '582086', '585818', '586123', '586223', '586225', '586229', '586230', '586240', '586996',
        '587192', '587192', '587287', '587426', '588124', '588145', '590780', '591142', '591260', '593241', '595024',
    }


class AntitussiveAntihistamineAnalgesicExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antitussive-Antihistamine-Analgesic-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '566924', '566957',
    }


class AntitussiveAntihistamineDecongestantAnalgesicExpectorantComb(ValueSet):
    VALUE_SET_NAME = 'Antitussive-Antihistamine-Decongestant-Analgesic-Expectorant Comb'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '562253', '562253', '562253', '562262', '579736', '579765', '581575', '581594', '581602', '581617', '581837',
        '581837', '584005', '584026', '584142', '584669', '586208', '586217', '586258', '586290', '586384', '586393',
        '586651', '586782', '587690', '590232', '590294', '590294', '590654', '590672', '591414', '593589', '593638',
        '595078', '595419', '595813', '595827', '595837',
    }


class CoughAndColdOrAllergyCombinationsOther(ValueSet):
    VALUE_SET_NAME = 'Cough and Cold or Allergy Combinations Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaCopdTherapyAgents(ValueSet):
    VALUE_SET_NAME = 'Asthma/COPD Therapy Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150390', '154171', '154680', '156672', '157320', '157536', '158361', '158361', '161508', '162287', '164193',
        '165956', '167135', '169246', '169268', '172435', '172723', '174469', '175282', '176596', '177662', '187792',
        '191405', '192695', '193215', '193215', '193884', '194984', '196643', '196643', '197529', '198066', '207738',
        '208297', '209750', '214422', '214422', '214758', '216067', '217179', '227810', '229289', '230107', '230506',
        '232635', '236390', '241459', '241459', '242056', '243877', '246337', '248781', '248857', '248857', '248952',
        '249303', '249493', '250025', '250041', '250196', '250196', '251006', '251006', '251025', '252617', '252617',
        '254062', '255421', '255421', '255803', '255854', '259175', '259175', '259175', '260554', '260554', '260554',
        '261865', '262446', '262937', '264381', '264567', '265564', '265564', '267456', '267456', '267782', '271995',
        '273471', '273471', '274474', '274490', '275579', '275579', '279394', '279394', '279394', '280818', '283926',
        '286546', '286546', '286546', '286605', '286605', '286804', '288967', '290954', '293173', '293173', '293197',
        '293640', '294151', '297987', '297987', '400006', '400244', '443570', '443817', '443818', '446373', '446374',
        '446599', '446600', '448103', '449966', '450360', '450366', '451357', '451358', '451358', '467524', '467524',
        '467524', '467526', '467526', '467526', '467866', '469776', '469777', '471208', '473400', '473401', '473402',
        '473627', '474039', '474062', '474069', '474491', '474492', '474493', '474497', '474498', '474499', '474500',
        '475695', '545839', '546150', '546150', '546151', '546151', '546152', '546152', '546154', '546154', '546155',
        '546155', '546156', '546156', '547198', '549702', '549703', '549795', '549796', '550315', '551028', '551028',
        '551029', '551029', '551032', '551032', '551033', '551033', '551102', '552473', '552553', '552575', '552575',
        '552583', '552657', '552912', '555086', '555090', '555092', '556006', '556007', '556015', '556016', '556935',
        '556935', '556936', '556936', '557652', '557652', '557661', '557661', '561626', '561626', '561627', '561627',
        '561631', '561631', '561632', '561632', '562717', '563183', '564108', '564108', '564113', '564113', '565186',
        '565187', '573311', '574237', '574771', '574771', '574771', '574771', '574777', '574777', '574777', '574777',
        '575039', '575784', '575864', '578437', '578437', '579049', '579049', '579341', '580423', '580423', '580428',
        '580428', '580653', '580653', '580958', '580958', '581705', '581705', '582317', '582317', '582322', '582322',
        '582383', '582383', '582425', '582425', '582426', '582426', '582484', '583372', '583373', '583380', '583381',
        '583398', '583398', '583400', '583400', '583402', '583402', '584934', '584941', '585924', '585924', '585930',
        '585930', '586159', '586159', '587559', '587566', '588138', '588138', '588213', '588224', '588224', '588224',
        '588228', '588228', '588228', '588229', '588229', '588242', '589959', '590050', '590396', '590396', '590459',
        '590459', '592865', '592867', '592868', '592868', '592911', '592912', '592913', '593469', '593470', '593471',
        '594172', '594173', '594174', '594176', '594177', '594539', '594539', '594550', '594550', '594631', '594632',
        '594878', '594879', '595080', '595084', '595399', '595400', '595666', '595694',
    }


class AsthmaCopdTherapyAnticholinergicAgents(ValueSet):
    VALUE_SET_NAME = 'Asthma/COPD Therapy - Anticholinergic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '293173', '293173', '467524', '467524', '467524', '467526', '467526', '467526', '474062', '474069', '574771',
        '574771', '574771', '574771', '574777', '574777', '574777', '574777', '575039', '579341', '581705', '581705',
        '583402', '583402', '587559', '587566', '588138', '588138', '588229', '588229', '595080', '595084', '595399',
        '595400',
    }


class AsthmaTherapyMastCellStabilizers(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Mast Cell Stabilizers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '193215', '193215',
    }


class AsthmaTherapySympathomimetics(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Sympathomimetics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaCopdTherapyBetaAdrenergicAgents(ValueSet):
    VALUE_SET_NAME = 'Asthma/COPD Therapy - Beta Adrenergic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154171', '157536', '162287', '167135', '172435', '177662', '187792', '197529', '208297', '214422', '214422',
        '216067', '232635', '249303', '250196', '250196', '252617', '252617', '255854', '262937', '267456', '267456',
        '273471', '273471', '279394', '279394', '279394', '280818', '286546', '286546', '286546', '297987', '297987',
        '400006', '400244', '446373', '446374', '446599', '446600', '467866', '469777', '471208', '473627', '475695',
        '545839', '547198', '550315', '552473', '552553', '563183', '565186', '565187', '582317', '582317', '582322',
        '582322', '584934', '584941',
    }


class AsthmaTherapyAlphaBetaAdrenergicAgentCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Alpha/Beta Adrenergic Agent Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyXanthines(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '169246', '169268', '172723', '174469', '175282', '176596', '191405', '192695', '194984', '209750', '217179',
        '229289', '230107', '242056', '243877', '246337', '249493', '250041', '262446', '264381', '264567', '271995',
        '274490', '283926', '294151', '443817', '443818', '451357', '451358', '451358', '575784', '575864',
    }


class AsthmaTherapyInhaledCorticosteroidsGlucocorticoids(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Inhaled Corticosteroids (Glucocorticoids)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156672', '157320', '207738', '227810', '241459', '241459', '248781', '248952', '259175', '259175', '259175',
        '260554', '260554', '260554', '267782', '274474', '286605', '286605', '288967', '293640', '473400', '473401',
        '473402', '474039', '474491', '474492', '474493', '474497', '474498', '474499', '474500', '549702', '549703',
        '549795', '549796', '551102', '552575', '552575', '552583', '555086', '555090', '555092', '556006', '556007',
        '556015', '556016', '556935', '556935', '556936', '556936', '562717', '580423', '580423', '580428', '580428',
        '582425', '582425', '582426', '582426', '583372', '583373', '583380', '583381', '583398', '583398', '583400',
        '583400', '592911', '592912', '592913', '594172', '594173', '594174', '594176', '594177', '594631', '594632',
    }


class AsthmaTherapyLeukotrieneModulators(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Leukotriene Modulators'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150390', '154680', '161508', '165956', '193884', '198066', '214758', '236390', '251025', '255803', '265564',
        '265564', '293197', '448103', '449966', '552657', '552912',
    }


class AsthmaTherapy5LipoxygenaseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - 5-Lipoxygenase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165956', '214758', '552657', '552912',
    }


class AsthmaTherapyLeukotrieneReceptorAntagonists(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Leukotriene Receptor Antagonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150390', '154680', '161508', '193884', '198066', '236390', '251025', '255803', '265564', '265564', '293197',
        '448103', '449966',
    }


class AsthmaCopdTherapyCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma/COPD Therapy Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158361', '158361', '164193', '196643', '196643', '248857', '248857', '251006', '251006', '255421', '255421',
        '275579', '275579', '546150', '546150', '546151', '546151', '546152', '546152', '546154', '546154', '546155',
        '546155', '546156', '546156', '551028', '551028', '551029', '551029', '551032', '551032', '551033', '551033',
        '557652', '557652', '557661', '557661', '561626', '561626', '561627', '561627', '561631', '561631', '561632',
        '561632', '573311', '578437', '578437', '579049', '579049', '580653', '580653', '580958', '580958', '582383',
        '582383', '582484', '585924', '585924', '585930', '585930', '586159', '586159', '588224', '588224', '588224',
        '588228', '588228', '588228', '590396', '590396', '590459', '590459', '592865', '592867', '592868', '592868',
        '593469', '593470', '593471', '594539', '594539', '594550', '594550',
    }


class AsthmaTherapyXanthineMixtures(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine Mixtures'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyXanthineExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyXanthineAlphaBetaAdrenergicCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine-Alpha/Beta Adrenergic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyXanthineAlphaBetaAdrenergicExpectorantComb(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine-Alpha/Beta Adrenergic-Expectorant Comb'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyAlphaBetaAdrenergicBarbiturateCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Alpha/Beta Adrenergic-Barbiturate Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyXanthineAntihistamineExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine-Antihistamine-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyXanthineAlphaBetaAdrenergicBarbiturateComb(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine-Alpha/Beta Adrenergic-Barbiturate Comb'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyXanthineAlphaBetaAdrenergicBarbiturAntihistComb(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine-Alpha/Beta Adrenergic-Barbitur-Antihist Comb'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyXanthineAlphaBetaAdrenergicBarbiturExpectComb(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine-Alpha/Beta Adrenergic-Barbitur-Expect Comb'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyAlphaBetaAdrenergicAnticholinergicCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Alpha/Beta Adrenergic-Anticholinergic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyBetaAdrenergicAntitussiveCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Beta Adrenergic-Antitussive Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyAlphaBetaAdrenergicExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Alpha/Beta Adrenergic-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '557652', '557652', '557661', '557661',
    }


class AsthmaTherapyXanthineAntitussiveAntihistamineCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine-Antitussive-Antihistamine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyXanthineAntitussiveExpectorantCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine-Antitussive-Expectorant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntihistamineAntiInflammatoryGlucocorticoidCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihistamine-Anti-Inflammatory, Glucocorticoid Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyXanthineMastCellStabilizerCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine-Mast Cell Stabilizer Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AsthmaTherapyXanthineGlucocorticoidCombinations(ValueSet):
    VALUE_SET_NAME = 'Asthma Therapy - Xanthine-Glucocorticoid Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class LungSurfactants(ValueSet):
    VALUE_SET_NAME = 'Lung Surfactants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150440', '150440', '186157', '186157', '213399', '213399', '295191', '295191', '475678', '475679', '475680',
        '475681', '575250', '575257',
    }


class ElastaseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Elastase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159857', '282987', '451216', '554415', '554416', '559933', '562221', '562260', '595184', '595195',
    }


class PleuralSclerosingAgents(ValueSet):
    VALUE_SET_NAME = 'Pleural Sclerosing Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '259578', '282525', '454224', '595735', '595736', '595737', '595756', '595757', '595758',
    }


class Laxatives(ValueSet):
    VALUE_SET_NAME = 'Laxatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150501', '150501', '153424', '153574', '153574', '153574', '153574', '153574', '153574', '153574', '154028',
        '154168', '154168', '154168', '154168', '154855', '158730', '159256', '159256', '159256', '159422', '159422',
        '161711', '161711', '163435', '167990', '168766', '169549', '169549', '169549', '169549', '169549', '170200',
        '170456', '170456', '170725', '171942', '171942', '171942', '171942', '173103', '173103', '173103', '174524',
        '176027', '176027', '176252', '177296', '180036', '180036', '181192', '181192', '182702', '183498', '186644',
        '186644', '187304', '187304', '187883', '188752', '190145', '191227', '191227', '191227', '191388', '194094',
        '194094', '194749', '194814', '195773', '196353', '196626', '196626', '198132', '199515', '199922', '200846',
        '200846', '201117', '201117', '202299', '203913', '203913', '204725', '205015', '205015', '205015', '205015',
        '205015', '205015', '205076', '206206', '206206', '206533', '207895', '207895', '207895', '207895', '207895',
        '207895', '207895', '208862', '209244', '209244', '209244', '209244', '209244', '209580', '209580', '209580',
        '209580', '209580', '209580', '209580', '209580', '209580', '209580', '209580', '209580', '212256', '214676',
        '215155', '215155', '215155', '215155', '215155', '216754', '217731', '222363', '223023', '223023', '223515',
        '223515', '225277', '226001', '226001', '226001', '226001', '226001', '226410', '226410', '226410', '226410',
        '226410', '227075', '228476', '230939', '231716', '231733', '234834', '237628', '237628', '237628', '237628',
        '237628', '237628', '237628', '237628', '237628', '237628', '237628', '237708', '237776', '238530', '239126',
        '242231', '242231', '243704', '243704', '243704', '243991', '243991', '243991', '243991', '243991', '243991',
        '244585', '247296', '247420', '250495', '252612', '254881', '254881', '255052', '255065', '258255', '258255',
        '258516', '258516', '259042', '259194', '259406', '260619', '261917', '261995', '263751', '266142', '267352',
        '267352', '267352', '267452', '267452', '269487', '273825', '276604', '276604', '277441', '277441', '277441',
        '277441', '277441', '277441', '277441', '277441', '277441', '277441', '277441', '278167', '278167', '280207',
        '283473', '284027', '284972', '284972', '285427', '286672', '288086', '289734', '289734', '289734', '289806',
        '290399', '290912', '297753', '297753', '299518', '299518', '299518', '400889', '400969', '433848', '433849',
        '433849', '433849', '433849', '433849', '433849', '433849', '433849', '433849', '433849', '433849', '433849',
        '433856', '433867', '433870', '433870', '433878', '433878', '433878', '433879', '433879', '433917', '433918',
        '433921', '433921', '433925', '433925', '433936', '433947', '433949', '433949', '433980', '433981', '433981',
        '434011', '434026', '434032', '434054', '434113', '434113', '443823', '444234', '445413', '445983', '446091',
        '446594', '446594', '446594', '446606', '446606', '446606', '446606', '446606', '447157', '447536', '447536',
        '447536', '448850', '448865', '448865', '448962', '448963', '449919', '449988', '450059', '450364', '450455',
        '450638', '452377', '453676', '453676', '453676', '453706', '453706', '453706', '453706', '453706', '453706',
        '453706', '453706', '453706', '453713', '453715', '453715', '453715', '453715', '453791', '453791', '453792',
        '453873', '453873', '454109', '454324', '454513', '467435', '467445', '467453', '467453', '467453', '467471',
        '467568', '467572', '467572', '467572', '467736', '467736', '467736', '467736', '467736', '467849', '467860',
        '467887', '467887', '468275', '468426', '470904', '470904', '470904', '471557', '472106', '472543', '472543',
        '472543', '472543', '472543', '472566', '472566', '472990', '473155', '473184', '473465', '473465', '473989',
        '474219', '474366', '474689', '474838', '474859', '474869', '475136', '475144', '475145', '475176', '475181',
        '475193', '475193', '475203', '475931', '476329', '476330', '476450', '476454', '545280', '545554', '545562',
        '545948', '545990', '546000', '546470', '546560', '546560', '546566', '546596', '546662', '547766', '547983',
        '547983', '548095', '548095', '548675', '549705', '549969', '549969', '549998', '550283', '550283', '550283',
        '550287', '550400', '550734', '550816', '550818', '551045', '551046', '551152', '552256', '552256', '552261',
        '552493', '552493', '552493', '552541', '552705', '552705', '552795', '552843', '552853', '552881', '552911',
        '553319', '553627', '553627', '554126', '555181', '555797', '556010', '556010', '556157', '556175', '556182',
        '556182', '556182', '556182', '556197', '556219', '556219', '556282', '556282', '556361', '556361', '556361',
        '556409', '556409', '556409', '556409', '556409', '556409', '556511', '556511', '556574', '556612', '556612',
        '556612', '556612', '556612', '556612', '556613', '556621', '556621', '556621', '556621', '556678', '558070',
        '558081', '558082', '558398', '558433', '558440', '558475', '558475', '558601', '559166', '559166', '559166',
        '559200', '559277', '559512', '559512', '559665', '559666', '559666', '559666', '559718', '559718', '559941',
        '560175', '560189', '560340', '560348', '560849', '561090', '561090', '561090', '561090', '561094', '561094',
        '561094', '561556', '561569', '561575', '561640', '561640', '561640', '561765', '561765', '561765', '561817',
        '561821', '561821', '561824', '561827', '561854', '561916', '561918', '562031', '562142', '562145', '562165',
        '562165', '562176', '562176', '562261', '562261', '562261', '562461', '562466', '563298', '563298', '563670',
        '563670', '563670', '563670', '563670', '563670', '563709', '564059', '564175', '564366', '564519', '564519',
        '565254', '565304', '565382', '565507', '565507', '565507', '565507', '565507', '565507', '565529', '565529',
        '565529', '565529', '567236', '567352', '567374', '567399', '567533', '567607', '567613', '567681', '567682',
        '568306', '568310', '568372', '568640', '568640', '568642', '568862', '569090', '570780', '570791', '570794',
        '570794', '570963', '570963', '571660', '572358', '572358', '572358', '572359', '572359', '572359', '572361',
        '572361', '572362', '572675', '572676', '572676', '573506', '573507', '573518', '573913', '573971', '575255',
        '575393', '575528', '575534', '575594', '576453', '576718', '576774', '576818', '577011', '577478', '578614',
        '578806', '578856', '578856', '579009', '579175', '579175', '579239', '579239', '579397', '579629', '580029',
        '580029', '580029', '580045', '580045', '580045', '580286', '580622', '580717', '580727', '580842', '580845',
        '580845', '580847', '580867', '580867', '580878', '580880', '580901', '581415', '581415', '581474', '581843',
        '581854', '581862', '581873', '581876', '581909', '581977', '581978', '582017', '582017', '582095', '582095',
        '582097', '582097', '582097', '582294', '582294', '583209', '583240', '583897', '583897', '583897', '584184',
        '584993', '585090', '585128', '586432', '586795', '586892', '586928', '586948', '587238', '587263', '587382',
        '587390', '587398', '587487', '587487', '587487', '587530', '587530', '587689', '587813', '587813', '587852',
        '587852', '588133', '588146', '589469', '589839', '590368', '590416', '590434', '590475', '591147', '591181',
        '591305', '591646', '591662', '591669', '591676', '592607', '592687', '592715', '592835', '593254', '593307',
        '593308', '593308', '593398', '593398', '593399', '593411', '593431', '593799', '593850', '594325', '594396',
        '594396', '594405', '594413', '594421', '594902', '595063', '595109', '595224', '595234', '595347', '595348',
        '595349', '595704', '596044', '596073',
    }


class LaxativeSalineAndOsmotic(ValueSet):
    VALUE_SET_NAME = 'Laxative - Saline and Osmotic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150501', '150501', '154168', '154168', '154168', '154168', '158730', '169549', '169549', '169549', '169549',
        '169549', '191227', '191227', '191227', '194094', '194094', '209244', '209244', '209244', '209244', '209244',
        '209580', '209580', '209580', '209580', '209580', '209580', '209580', '209580', '209580', '209580', '209580',
        '209580', '222363', '226001', '226001', '226001', '226001', '226001', '237776', '260619', '263751', '277441',
        '277441', '277441', '277441', '277441', '277441', '277441', '277441', '277441', '277441', '277441', '283473',
        '433848', '433849', '433849', '433849', '433849', '433849', '433849', '433849', '433849', '433849', '433849',
        '433849', '433849', '434113', '434113', '467453', '467453', '467453', '467572', '467572', '467572', '467736',
        '467736', '467736', '467736', '467736', '470904', '470904', '470904', '472543', '472543', '472543', '472543',
        '472543', '472566', '472566', '547983', '547983', '548095', '548095', '552256', '552256', '552261', '559512',
        '559512', '559665', '559666', '559666', '559666', '560175', '560189', '560340', '560348', '561090', '561090',
        '561090', '561090', '561640', '561640', '561640', '561765', '561765', '561765', '561821', '561821', '561916',
        '562031', '563670', '563670', '563670', '563670', '563670', '563670', '564519', '564519', '568862', '570780',
        '570791', '575255', '575528', '575534', '575594', '582097', '582097', '582097', '583897', '583897', '583897',
        '591147', '591181', '593254',
    }


class LaxativeStimulant(ValueSet):
    VALUE_SET_NAME = 'Laxative - Stimulant'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159256', '159256', '159256', '167990', '170456', '170456', '171942', '171942', '171942', '171942', '173103',
        '173103', '173103', '177296', '180036', '180036', '191388', '195773', '196353', '196626', '196626', '200846',
        '200846', '202299', '205015', '205015', '205015', '205015', '205015', '205015', '206533', '215155', '215155',
        '215155', '215155', '215155', '217731', '225277', '228476', '231716', '231733', '237628', '237628', '237628',
        '237628', '237628', '237628', '237628', '237628', '237628', '237628', '237628', '237708', '243991', '243991',
        '243991', '243991', '243991', '243991', '252612', '258516', '258516', '259406', '261917', '267352', '267352',
        '267352', '267452', '267452', '276604', '276604', '284027', '289734', '289734', '289734', '297753', '297753',
        '400889', '433867', '433870', '433870', '433878', '433878', '433878', '433879', '433879', '433917', '433918',
        '433921', '433921', '433925', '433925', '443823', '445983', '446594', '446594', '446594', '446606', '446606',
        '446606', '446606', '446606', '447157', '447536', '447536', '447536', '452377', '453715', '453715', '453715',
        '453715', '454109', '467445', '467849', '467860', '472106', '472990', '473155', '473184', '473465', '473465',
        '475181', '476329', '476330', '546470', '551152', '552493', '552493', '552493', '552853', '553627', '553627',
        '561569', '571660', '580286', '582095', '582095', '585128', '586948', '592835', '594405', '594421',
    }


class LaxativeBulkForming(ValueSet):
    VALUE_SET_NAME = 'Laxative - Bulk Forming'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '163435', '168766', '174524', '182702', '187304', '187304', '204725', '206206', '206206', '208862', '216754',
        '226410', '226410', '226410', '226410', '226410', '242231', '242231', '243704', '243704', '243704', '244585',
        '247296', '247420', '250495', '266142', '269487', '273825', '284972', '284972', '288086', '299518', '299518',
        '299518', '433936', '433947', '433949', '433949', '433980', '433981', '433981', '445413', '448850', '448962',
        '448963', '453676', '453676', '453676', '453706', '453706', '453706', '453706', '453706', '453706', '453706',
        '453706', '453706', '453791', '453791', '453792', '453873', '453873', '454324', '467435', '467471', '468426',
        '471557', '474219', '474366', '474689', '474838', '475136', '475144', '475145', '475176', '475193', '475193',
        '475203', '475931', '545554', '545562', '545948', '545990', '546000', '549969', '549969', '549998', '550283',
        '550283', '550283', '550287', '552843', '552911', '553319', '554126', '555181', '556010', '556010', '556157',
        '556175', '556182', '556182', '556182', '556182', '556197', '556219', '556219', '556282', '556282', '556361',
        '556361', '556361', '556409', '556409', '556409', '556409', '556409', '556409', '556511', '556511', '556574',
        '556612', '556612', '556612', '556612', '556612', '556612', '556613', '556621', '556621', '556621', '556621',
        '556678', '558070', '558081', '558475', '558475', '558601', '559166', '559166', '559166', '559200', '561094',
        '561094', '561094', '561854', '561918', '562165', '562165', '562176', '562176', '562261', '562261', '562261',
        '562461', '562466', '563298', '563298', '564059', '564175', '564366', '565254', '565304', '565382', '565507',
        '565507', '565507', '565507', '565507', '565507', '565529', '565529', '565529', '565529', '567352', '567533',
        '567607', '567613', '567682', '568306', '568310', '568372', '570794', '570794', '570963', '570963', '572358',
        '572358', '572358', '572359', '572359', '572359', '572361', '572361', '572362', '572675', '572676', '572676',
        '573518', '575393', '576718', '576774', '576818', '578806', '578856', '578856', '579009', '579175', '579175',
        '579239', '579239', '579397', '580029', '580029', '580029', '580045', '580045', '580045', '580622', '580842',
        '580845', '580845', '580847', '580867', '580867', '580878', '580880', '580901', '581415', '581415', '581474',
        '581843', '581854', '581862', '581873', '581876', '581977', '581978', '582017', '582017', '582294', '582294',
        '583240', '584184', '586432', '586892', '586928', '587238', '587263', '587390', '587398', '587487', '587487',
        '587487', '587530', '587530', '587689', '587813', '587813', '587852', '587852', '588133', '588146', '589839',
        '590368', '590416', '590434', '590475', '591305', '591646', '591662', '591669', '591676', '592607', '592687',
        '592715', '593307', '593308', '593308', '593398', '593398', '593399', '593411', '593431', '593799', '593850',
        '594325', '594413', '594902', '595224', '595347', '595348', '595349', '595704', '596044', '596073',
    }


class LaxativeLubricant(ValueSet):
    VALUE_SET_NAME = 'Laxative - Lubricant'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153574', '153574', '153574', '153574', '153574', '153574', '153574', '176027', '176027', '207895', '207895',
        '207895', '207895', '207895', '207895', '207895', '223023', '223023', '259042', '259194', '433856', '434011',
        '444234', '560849',
    }


class LaxativeSurfactant(ValueSet):
    VALUE_SET_NAME = 'Laxative - Surfactant'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153424', '154028', '159422', '159422', '161711', '161711', '170200', '170725', '181192', '181192', '183498',
        '187883', '188752', '190145', '194749', '198132', '199922', '212256', '214676', '227075', '230939', '234834',
        '239126', '255052', '255065', '258255', '258255', '261995', '280207', '286672', '289806', '290399', '290912',
        '434026', '434032', '434054', '467568', '473989', '476454', '547766', '549705', '555797', '558082', '561556',
        '561575', '563709', '567236', '567681', '568640', '568640', '568642', '573506', '573507', '579629', '580717',
        '580727', '583209', '587382', '589469', '595234',
    }


class LaxativeCombinations(ValueSet):
    VALUE_SET_NAME = 'Laxative Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154855', '176252', '186644', '186644', '194814', '199515', '201117', '201117', '203913', '203913', '205076',
        '223515', '223515', '238530', '254881', '254881', '278167', '278167', '285427', '400969', '446091', '448865',
        '448865', '449919', '449988', '450059', '450364', '450455', '450638', '453713', '454513', '467887', '467887',
        '468275', '474859', '474869', '476450', '545280', '546560', '546560', '546566', '546596', '546662', '548675',
        '550400', '550734', '550816', '550818', '551045', '551046', '552541', '552705', '552705', '552795', '552881',
        '558398', '558433', '558440', '559277', '559718', '559718', '559941', '561817', '561824', '561827', '562142',
        '562145', '567374', '567399', '569090', '573913', '573971', '576453', '577011', '577478', '578614', '581909',
        '584993', '585090', '586795', '594396', '594396', '595063', '595109',
    }


class LaxativeBowelPrepKits(ValueSet):
    VALUE_SET_NAME = 'Laxative - Bowel Prep Kits'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154855', '176252', '194814', '199515', '203913', '203913', '205076', '223515', '223515', '238530', '254881',
        '254881', '278167', '278167', '285427', '446091', '450638', '454513', '468275', '476450', '545280', '546560',
        '546560', '546566', '546596', '546662', '550400', '550734', '550816', '550818', '551045', '551046', '552705',
        '552705', '558398', '558433', '558440', '561817', '561824', '562142', '562145', '567374', '567399', '577011',
        '577478', '581909',
    }


class Antidiarrheals(ValueSet):
    VALUE_SET_NAME = 'Antidiarrheals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152747', '152747', '152747', '153068', '163770', '163770', '166695', '169179', '169179', '179292', '190047',
        '190047', '190047', '190047', '190047', '190047', '190047', '190452', '193687', '195685', '198960', '198960',
        '198960', '201582', '202152', '215570', '216725', '228236', '228236', '228236', '236990', '241731', '241731',
        '241731', '241731', '241731', '241731', '245049', '253660', '259637', '259637', '259637', '259637', '266709',
        '266854', '267463', '268532', '268532', '270285', '270285', '270285', '274463', '279391', '279605', '281822',
        '281822', '284293', '287164', '288617', '289580', '294410', '295224', '295839', '297457', '299464', '299464',
        '299464', '400158', '400158', '434308', '434338', '434339', '434340', '434341', '434341', '434341', '434341',
        '434341', '434345', '434346', '434346', '434346', '434346', '434346', '434347', '434351', '434351', '434351',
        '434351', '434351', '434352', '434352', '434359', '434363', '434365', '434365', '434369', '434369', '434369',
        '446507', '446507', '451259', '451260', '451261', '453456', '453456', '453463', '453463', '453588', '454259',
        '454378', '454496', '454496', '454496', '454549', '467787', '467788', '467789', '472246', '472246', '472581',
        '472617', '472617', '473107', '473108', '473117', '473118', '473281', '473288', '474175', '474179', '474531',
        '474635', '474635', '474645', '474645', '474798', '474798', '545316', '545318', '545318', '545736', '546089',
        '546089', '546099', '546099', '546100', '546115', '546115', '550021', '550021', '550805', '550881', '550893',
        '553956', '554846', '554846', '554846', '554846', '554846', '554846', '554879', '554879', '554879', '554879',
        '554879', '554879', '554937', '555793', '555988', '556031', '556666', '556666', '556666', '556930', '556930',
        '558940', '559256', '559287', '559295', '559392', '559561', '559866', '559904', '560481', '560481', '560721',
        '560750', '560750', '561027', '561352', '561435', '561469', '561469', '561479', '561570', '561682', '561907',
        '561907', '561919', '561924', '561924', '561932', '562264', '562285', '562724', '562733', '562939', '562939',
        '562941', '562942', '562945', '562945', '562946', '562947', '562949', '562998', '563471', '563705', '564149',
        '564173', '564268', '564271', '564272', '564453', '564475', '565824', '567611', '567679', '569190', '571002',
        '571072', '571351', '571410', '571567', '571598', '572987', '573008', '573739', '573799', '574062', '574079',
        '574079', '574100', '574369', '574667', '574696', '574696', '574765', '574810', '575013', '575069', '576010',
        '576054', '576370', '576507', '576563', '576858', '577055', '577208', '577481', '577507', '577574', '577698',
        '577699', '577712', '577716', '577717', '577718', '577720', '577734', '577734', '577735', '577736', '577797',
        '577851', '577993', '578028', '578089', '578355', '578355', '578400', '578403', '578467', '578468', '578557',
        '578557', '579336', '579336', '579496', '579532', '579552', '580215', '580703', '580764', '580813', '580994',
        '581016', '581101', '581274', '581465', '581518', '581531', '581537', '581582', '581588', '581597', '581709',
        '581729', '582035', '582074', '582176', '582185', '582506', '582643', '582826', '582843', '582843', '582843',
        '582843', '582846', '582848', '582848', '582848', '582848', '583435', '583661', '583677', '583700', '583703',
        '583863', '583880', '583885', '583885', '583930', '583930', '584146', '584359', '584620', '584620', '584645',
        '584645', '584913', '584955', '585177', '585375', '585405', '585713', '585713', '585885', '585964', '585965',
        '586243', '586261', '586733', '586769', '586908', '586936', '586981', '587131', '587367', '587443', '587453',
        '587471', '587486', '587517', '587746', '587968', '587982', '588668', '588674', '588682', '588686', '588702',
        '588714', '589282', '589304', '589308', '589309', '589476', '590058', '590076', '590283', '590300', '590302',
        '590322', '590394', '590435', '590499', '590535', '590577', '590596', '590609', '590635', '590641', '590656',
        '590808', '591683', '591705', '591706', '591934', '592252', '592263', '592588', '592734', '592741', '592749',
        '592887', '592930', '592934', '592935', '592936', '592947', '592948', '592950', '593046', '593102', '593121',
        '593124', '593132', '593149', '593412', '593430', '593454', '593506', '593556', '593575', '593587', '593654',
        '593686', '594824', '595046', '595061', '595067', '595068', '595083', '595585', '595745', '595759', '595851',
        '595920', '595980',
    }


class AntidiarrhealAntiperistalticAgents(ValueSet):
    VALUE_SET_NAME = 'Antidiarrheal - Antiperistaltic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152747', '152747', '152747', '169179', '169179', '179292', '190047', '190047', '190047', '190047', '190047',
        '190047', '190047', '215570', '228236', '228236', '228236', '274463', '288617', '434308', '446507', '446507',
        '474635', '474635', '474645', '474645', '474798', '474798', '559392', '590596', '592588',
    }


class AntidiarrhealGiAdsorbents(ValueSet):
    VALUE_SET_NAME = 'Antidiarrheal - GI Adsorbents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntidiarrhealBismuthAgents(ValueSet):
    VALUE_SET_NAME = 'Antidiarrheal - Bismuth Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '163770', '163770', '166695', '193687', '198960', '198960', '198960', '216725', '236990', '241731', '241731',
        '241731', '241731', '241731', '241731', '245049', '259637', '259637', '259637', '259637', '266854', '267463',
        '268532', '268532', '281822', '281822', '287164', '299464', '299464', '299464', '434338', '434339', '434340',
        '434341', '434341', '434341', '434341', '434341', '434345', '434346', '434346', '434346', '434346', '434346',
        '434347', '434351', '434351', '434351', '434351', '434351', '434352', '434352', '434359', '434363', '434365',
        '434365', '434369', '434369', '434369', '453588', '467787', '467788', '467789', '472246', '472246', '472581',
        '473281', '545316', '545318', '545318', '545736', '560481', '560481', '562724', '562733', '576858', '580813',
        '582506', '584359', '586908', '590300', '590302', '590499',
    }


class AntidiarrhealCombinations(ValueSet):
    VALUE_SET_NAME = 'Antidiarrheal Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153068', '190452', '195685', '201582', '270285', '270285', '270285', '279605', '294410', '451259', '454259',
        '454378', '454496', '454496', '454496', '454549', '550021', '550021', '550805', '553956', '556666', '556666',
        '556666', '559256', '574765', '574810', '586243', '586261',
    }


class AntidiarrhealAntiperistalticAnticholinergicCombinations(ValueSet):
    VALUE_SET_NAME = 'Antidiarrheal Antiperistaltic-Anticholinergic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153068', '195685', '201582', '279605', '294410',
    }


class AntidiarrhealGiAdsorbentMixtures(ValueSet):
    VALUE_SET_NAME = 'Antidiarrheal GI Adsorbent Mixtures'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '454496', '454496', '454496',
    }


class AntacidsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Antacids and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151940', '154745', '160959', '160959', '162734', '163049', '166628', '169851', '171618', '174729', '176019',
        '177732', '179667', '180117', '180689', '183000', '189225', '191964', '197133', '198889', '199777', '199777',
        '199777', '202107', '217485', '220092', '220291', '220291', '220291', '224950', '228322', '228322', '228322',
        '229306', '233675', '234854', '235955', '238094', '240833', '243554', '243554', '243554', '245371', '245371',
        '245468', '245468', '248515', '248515', '248515', '248650', '248650', '248970', '248970', '250275', '250275',
        '251656', '252767', '252767', '252767', '254986', '255849', '256146', '262213', '264417', '265342', '268191',
        '272363', '272363', '272363', '272734', '274417', '274417', '277523', '277968', '279215', '281464', '283732',
        '284953', '286058', '287321', '290969', '292345', '292345', '292345', '293964', '293964', '294809', '295950',
        '297762', '299483', '434414', '434414', '434544', '434576', '434590', '434624', '434661', '434670', '434683',
        '434683', '434684', '434690', '434692', '448590', '448660', '451230', '451230', '451615', '451994', '452480',
        '452701', '454130', '454229', '454229', '454245', '454245', '454248', '454248', '454252', '454252', '454252',
        '454264', '454500', '467319', '467407', '467408', '468109', '468450', '468554', '471129', '471130', '471254',
        '471616', '471651', '472605', '473344', '473346', '473599', '473621', '474362', '474813', '475642', '476239',
        '545738', '545798', '549528', '549554', '549554', '549554', '552794', '553248', '555740', '557858', '557873',
        '558875', '559282', '559750', '560275', '560703', '561926', '561926', '565836', '565837', '565838', '567356',
        '567356', '567356', '567357', '572370', '572370', '572949', '572984', '574505', '574505', '574505', '574839',
        '575058', '575342', '575563', '575563', '576231', '576759', '580387', '580648', '581621', '582422', '583394',
        '583418', '583762', '583817', '583824', '584015', '584036', '584081', '584081', '584372', '584372', '585462',
        '587442', '587456', '589859', '591682', '591687', '595613', '595626', '595626', '595638', '595638',
    }


class AntacidAluminum(ValueSet):
    VALUE_SET_NAME = 'Antacid - Aluminum'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '235955', '274417', '274417',
    }


class AntacidBicarbonate(ValueSet):
    VALUE_SET_NAME = 'Antacid - Bicarbonate'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '180689', '233675', '549554', '549554', '549554',
    }


class AntacidCalcium(ValueSet):
    VALUE_SET_NAME = 'Antacid - Calcium'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '171618', '177732', '180117', '183000', '189225', '191964', '197133', '199777', '199777', '199777', '220291',
        '220291', '220291', '234854', '240833', '243554', '243554', '243554', '248515', '248515', '248515', '248970',
        '248970', '250275', '250275', '256146', '268191', '281464', '292345', '292345', '292345', '294809', '434414',
        '434414', '451230', '451230', '452480', '452701', '467319', '471616', '472605', '474813', '475642', '552794',
        '557858', '557873', '561926', '561926', '572949', '572984', '574505', '574505', '574505', '576759', '580648',
        '582422', '583394', '585462', '587442', '587456', '589859', '591682', '591687', '595613',
    }


class AntacidMagnesium(ValueSet):
    VALUE_SET_NAME = 'Antacid - Magnesium'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '163049', '265342', '284953', '290969', '583762',
    }


class AntacidCombinations(ValueSet):
    VALUE_SET_NAME = 'Antacid Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151940', '154745', '160959', '160959', '162734', '166628', '169851', '174729', '176019', '179667', '198889',
        '202107', '217485', '220092', '224950', '228322', '228322', '228322', '229306', '238094', '245371', '245371',
        '245468', '245468', '248650', '248650', '251656', '252767', '252767', '252767', '254986', '255849', '262213',
        '264417', '272363', '272363', '272363', '272734', '277523', '277968', '279215', '283732', '286058', '287321',
        '293964', '293964', '295950', '297762', '299483', '434544', '434576', '434590', '434624', '434661', '434670',
        '434683', '434683', '434684', '434690', '434692', '448590', '448660', '451615', '451994', '454130', '454229',
        '454229', '454245', '454245', '454248', '454248', '454252', '454252', '454252', '454264', '454500', '467407',
        '467408', '468109', '468450', '468554', '471129', '471130', '471254', '471651', '473344', '473346', '473599',
        '473621', '474362', '476239', '545738', '545798', '549528', '553248', '555740', '558875', '559282', '559750',
        '560275', '560703', '565836', '565837', '565838', '567356', '567356', '567356', '567357', '572370', '572370',
        '574839', '575058', '575342', '575563', '575563', '576231', '580387', '581621', '583418', '583817', '583824',
        '584015', '584036', '584081', '584081', '584372', '584372',
    }


class AntacidDimethiconeCombinations(ValueSet):
    VALUE_SET_NAME = 'Antacid - Dimethicone Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntacidSimethiconeCombinations(ValueSet):
    VALUE_SET_NAME = 'Antacid - Simethicone Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160959', '160959', '166628', '198889', '224950', '228322', '228322', '228322', '245371', '245371', '245468',
        '245468', '248650', '248650', '251656', '252767', '252767', '252767', '254986', '262213', '264417', '272363',
        '272363', '272363', '277968', '283732', '286058', '293964', '293964', '295950', '297762', '299483', '434544',
        '434576', '434590', '434624', '434661', '434670', '434683', '434683', '434684', '434690', '434692', '448660',
        '454229', '454229', '454245', '454245', '454248', '454248', '454252', '454252', '454252', '454264', '467407',
        '467408', '471129', '471254', '473344', '473346', '473599', '473621', '476239', '549528', '553248', '555740',
        '558875', '559750', '565837', '565838', '567356', '567356', '567356', '567357', '572370', '572370', '575342',
        '575563', '575563', '576231', '580387', '581621', '583418', '584015', '584036',
    }


class AntacidAntacidCombinations(ValueSet):
    VALUE_SET_NAME = 'Antacid - Antacid Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151940', '154745', '162734', '169851', '174729', '179667', '202107', '217485', '220092', '238094', '272734',
        '279215', '287321', '448590', '451615', '451994', '454130', '454500', '468109', '468450', '468554', '471130',
        '471651', '474362', '545738', '545798', '560275', '565836', '574839', '575058', '583817', '583824', '584081',
        '584081', '584372', '584372',
    }


class GastrointestinalAntispasmodics(ValueSet):
    VALUE_SET_NAME = 'Gastrointestinal Antispasmodics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151294', '151671', '154914', '156294', '156427', '160055', '160055', '165174', '167678', '167678', '167678',
        '167678', '169959', '169959', '169959', '169959', '174919', '183265', '187951', '187951', '208456', '213123',
        '222897', '228400', '230644', '230974', '234652', '236139', '236182', '238502', '241345', '246097', '247468',
        '251732', '255467', '261487', '265406', '266474', '268089', '268089', '268585', '268585', '271571', '280587',
        '283897', '290254', '290625', '292117', '292439', '292566', '434728', '434834', '434842', '450735', '468195',
        '468195', '471935', '473430', '473445', '559114', '561280', '561594', '565300', '565301', '565302', '565303',
        '575298', '575777', '575816', '578613', '579888', '586956', '588168', '588745', '589630', '590385', '591169',
        '591169', '592451', '592519',
    }


class GiAntispasmodicBelladonnaAlkaloids(ValueSet):
    VALUE_SET_NAME = 'GI Antispasmodic - Belladonna Alkaloids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154914', '156294', '156427', '174919', '222897', '228400', '230644', '234652', '236182', '238502', '246097',
        '247468', '255467', '266474', '268089', '268089', '268585', '268585', '271571', '280587', '292439', '450735',
        '471935', '473430', '473445', '561280', '561594', '565300', '565301', '565302', '565303', '575298',
    }


class GiAntispasmodicQuaternaryAmmoniumCompounds(ValueSet):
    VALUE_SET_NAME = 'GI Antispasmodic - Quaternary Ammonium Compounds'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151294', '151671', '165174', '167678', '167678', '167678', '167678', '169959', '169959', '169959', '169959',
        '241345', '292117', '292566', '434728', '559114', '579888', '586956', '588168', '590385', '591169', '591169',
        '592451', '592519',
    }


class GiAntispasmodicSelectiveMuscarinicReceptorAntagonists(ValueSet):
    VALUE_SET_NAME = 'GI Antispasmodic - Selective Muscarinic Receptor Antagonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class GiAntispasmodicCombinations(ValueSet):
    VALUE_SET_NAME = 'GI Antispasmodic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '183265', '187951', '187951', '208456', '236139', '261487', '283897', '290625', '434834', '434842', '468195',
        '468195', '575777', '575816', '588745', '589630',
    }


class GastricAcidSecretionReducersHistamineH2ReceptorAntagonists(ValueSet):
    VALUE_SET_NAME = 'Gastric Acid Secretion Reducers - Histamine H2-Receptor Antagonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '167911', '167911', '167911', '167911', '176030', '177131', '183740', '188368', '199736', '202182', '202274',
        '202478', '203441', '205842', '205842', '205842', '205842', '208390', '208390', '211505', '212049', '212049',
        '223516', '223516', '223516', '231096', '231096', '231096', '231096', '231096', '233075', '233075', '242904',
        '242904', '242904', '242904', '242904', '243581', '245594', '245594', '245594', '262574', '268745', '269077',
        '273098', '276048', '279509', '280324', '288640', '291433', '291433', '291433', '294445', '400642', '400851',
        '434894', '445836', '445836', '452436', '452436', '452436', '471155', '473003', '473004', '473139', '473139',
        '473139', '473139', '473139', '473197', '473197', '473266', '473266', '473360', '473360', '474033', '474033',
        '547641', '547641', '547641', '547641', '547695', '547695', '548683', '549716', '549716', '549716', '552061',
        '552061', '553169', '553538', '553538', '555453', '555453', '557160', '557160', '558749', '558771', '558898',
        '558898', '594837',
    }


class GastricMucosaCytoprotectiveProstaglandinAnalogs(ValueSet):
    VALUE_SET_NAME = 'Gastric Mucosa - Cytoprotective Prostaglandin Analogs'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '175085', '245621', '254994', '270995',
    }


class GastricAcidSecretionReducingAgentsProtonPumpInhibitorsPpis(ValueSet):
    VALUE_SET_NAME = 'Gastric Acid Secretion Reducing Agents - Proton Pump Inhibitors (PPIs)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161355', '161359', '186106', '186739', '193225', '193720', '197010', '205113', '209379', '209460', '213238',
        '214019', '224550', '226012', '228493', '238235', '238235', '241473', '245569', '255331', '259872', '297062',
        '298924', '450468', '450469', '450469', '450504', '450504', '450505', '451486', '451486', '451486', '451488',
        '451488', '451488', '473757', '473758', '473790', '549722', '549723', '549752', '549753', '554070', '554070',
        '554070', '554070', '554070', '554377', '554382', '555135', '555152', '557235', '557236', '557244', '557245',
        '557294', '557295', '559806', '560863', '560864', '561431', '561431', '561431', '561431', '564959', '574876',
        '574878', '574884', '574885', '577784', '577785', '579485', '579486', '580187', '580188', '581284', '588548',
        '591990', '594787', '595882', '595900',
    }


class PepticUlcerTherapyCombinations(ValueSet):
    VALUE_SET_NAME = 'Peptic Ulcer Therapy Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '172741', '471626', '472735', '473152', '476601', '476601', '476602', '476603', '476604', '476606', '476607',
        '556049', '557249', '559468', '561117', '561117', '561998', '562085', '589726', '593989', '593990',
    }


class PepticUlcerTreatmentOfHPyloriAntibioticBismuthCombinations(ValueSet):
    VALUE_SET_NAME = 'Peptic Ulcer - Treatment of H. Pylori: Antibiotic-Bismuth Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '550278', '550298',
    }


class PepticUlcerTreatmentHPyloriProtonPumpInhibitorAndAntibiotics(ValueSet):
    VALUE_SET_NAME = 'Peptic Ulcer-Treatment H. Pylori-Proton Pump Inhibitor and Antibiotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '470964', '470964', '470965', '572567', '572567', '572575', '572575',
    }


class GastricAcidSecretionReducingH2AntagonistAndAntacidCombinations(ValueSet):
    VALUE_SET_NAME = 'Gastric Acid Secretion Reducing-H2 Antagonist and Antacid Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '172741', '472735', '556049', '557249', '559468', '561998', '562085', '589726',
    }


class GastricAcidSecretionReducingH2AntagonistAndAntiemeticComb(ValueSet):
    VALUE_SET_NAME = 'Gastric Acid Secretion Reducing-H2 Antagonist and Antiemetic Comb.'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class GastricAcidSecretionReducingH2AntagonistAndAntispasmodicComb(ValueSet):
    VALUE_SET_NAME = 'Gastric Acid Secretion Reducing- H2 Antagonist and Antispasmodic Comb.'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Antiemetics(ValueSet):
    VALUE_SET_NAME = 'Antiemetics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150100', '152181', '152181', '163232', '164794', '164801', '164801', '164881', '169949', '169949', '171276',
        '172179', '176765', '177818', '177818', '180547', '180547', '180758', '181002', '181002', '181028', '181089',
        '183591', '183591', '184689', '184789', '184992', '198080', '199300', '201476', '202830', '205556', '205556',
        '206610', '207397', '207434', '207654', '208715', '208715', '209726', '209726', '212849', '213732', '213732',
        '213732', '214864', '215635', '215941', '218334', '220973', '221962', '224772', '226815', '233422', '233422',
        '233726', '233967', '233967', '234197', '234197', '234644', '234644', '234644', '236941', '237304', '241584',
        '242041', '246179', '246179', '258028', '258028', '260062', '260079', '261751', '263408', '263408', '268900',
        '271263', '272376', '272376', '273293', '273705', '273718', '273718', '273718', '273718', '275565', '278720',
        '278720', '278720', '278720', '279018', '285288', '285613', '294658', '294658', '295167', '295167', '299955',
        '299955', '299955', '400024', '400027', '401097', '434985', '434993', '434994', '446406', '446406', '449017',
        '449018', '449020', '449022', '449023', '449024', '449044', '450460', '451125', '451292', '451298', '451477',
        '453993', '468407', '472432', '545779', '545779', '545795', '545795', '545811', '545843', '545848', '545968',
        '547607', '547607', '549592', '552920', '552920', '553315', '553543', '553980', '553995', '555464', '556335',
        '556351', '556927', '557046', '561684', '561684', '561685', '561685', '561687', '561687', '561688', '561688',
        '561874', '562640', '564054', '564197', '564342', '564342', '565669', '573160', '576203', '576248', '577820',
        '578206', '578250', '581657', '582827', '582830', '587221', '587337', '588728', '590377', '591105', '591122',
        '591207', '591493', '591600', '591979', '592385', '594779', '594781', '594860', '594963', '595469', '595657',
    }


class AntiemeticDopamineD2Antagonists(ValueSet):
    VALUE_SET_NAME = 'Antiemetic - Dopamine (D2) Antagonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntiemeticAnticholinergics(ValueSet):
    VALUE_SET_NAME = 'Antiemetic - Anticholinergics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '273718', '273718', '273718', '273718', '278720', '278720', '278720', '278720',
    }


class AntiemeticSelectiveSerotonin5Ht3Antagonists(ValueSet):
    VALUE_SET_NAME = 'Antiemetic - Selective Serotonin 5-HT3 Antagonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164881', '171276', '172179', '181002', '181002', '181028', '183591', '183591', '205556', '205556', '209726',
        '209726', '215941', '218334', '221962', '224772', '234197', '234197', '237304', '260062', '260079', '271263',
        '273293', '275565', '285288', '285613', '401097', '451292', '451298', '451477', '472432', '547607', '547607',
        '549592', '553980', '553995', '556335', '556351', '556927', '557046', '561684', '561684', '561685', '561685',
        '561687', '561687', '561688', '561688', '561874', '564054', '590377', '591493', '591600', '591979',
    }


class AntiemeticOtherAndMiscCombinations(ValueSet):
    VALUE_SET_NAME = 'Antiemetic - Other and Misc Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '201476', '576203', '576248',
    }


class DigestiveAids(ValueSet):
    VALUE_SET_NAME = 'Digestive Aids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150852', '152122', '154944', '158551', '166827', '217434', '230447', '230447', '230447', '230447', '235459',
        '235459', '235459', '235459', '235459', '235459', '241270', '243251', '256823', '285841', '285841', '400896',
        '400988', '401106', '435008', '435018', '446294', '448189', '448604', '448929', '448929', '448929', '449725',
        '451758', '464950', '474538', '474538', '474538', '474641', '474641', '550471', '550471', '550471', '553370',
        '553371', '558610', '558611', '558612', '558622', '558623', '558624', '559533', '559534', '559535', '559536',
        '559592', '559593', '559594', '559595', '559929', '565323', '565325', '566916', '566917', '567019', '567020',
        '571081', '571082', '571493', '571494', '571496', '573026', '573027', '573070', '573072', '574353', '574354',
        '575817', '575818', '575819', '576929', '576956', '577999', '578000', '583420', '583422', '584156', '584648',
        '584649', '584869', '584870', '587587', '587620', '587642', '587684', '591848', '591849', '591850', '591851',
        '591922', '591923', '591924', '591925', '592302', '592306', '592364', '592378', '593478', '593532', '594255',
        '594262', '594970', '594978', '594980', '595015', '595520', '595521', '595523', '595524', '595950', '596009',
    }


class Choleretics(ValueSet):
    VALUE_SET_NAME = 'Choleretics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DigestiveEnzymes(ValueSet):
    VALUE_SET_NAME = 'Digestive Enzymes'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150852', '152122', '154944', '158551', '166827', '217434', '230447', '230447', '230447', '230447', '235459',
        '235459', '235459', '235459', '235459', '235459', '241270', '243251', '256823', '285841', '285841', '400896',
        '400988', '401106', '435008', '435018', '446294', '448189', '448604', '448929', '448929', '448929', '449725',
        '451758', '464950', '474538', '474538', '474538', '474641', '474641', '550471', '550471', '550471', '553370',
        '553371', '584156', '587620', '587642',
    }


class DigestiveEnzymesWithAnticholinergics(ValueSet):
    VALUE_SET_NAME = 'Digestive Enzymes with Anticholinergics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DigestiveEnzymeMixtures(ValueSet):
    VALUE_SET_NAME = 'Digestive Enzyme Mixtures'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '558610', '558611', '558612', '558622', '558623', '558624', '559533', '559534', '559535', '559536', '559592',
        '559593', '559594', '559595', '559929', '565323', '565325', '566916', '566917', '567019', '567020', '571081',
        '571082', '571493', '571494', '571496', '573026', '573027', '573070', '573072', '574353', '574354', '575817',
        '575818', '575819', '576929', '576956', '577999', '578000', '583420', '583422', '587587', '587684', '591848',
        '591849', '591850', '591851', '591922', '591923', '591924', '591925', '592302', '592306', '592364', '592378',
        '593478', '593532', '594255', '594262', '594970', '594978', '594980', '595015', '595520', '595521', '595523',
        '595524', '595950', '596009',
    }


class GastricAcidifiers(ValueSet):
    VALUE_SET_NAME = 'Gastric Acidifiers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Hydrocholeretics(ValueSet):
    VALUE_SET_NAME = 'Hydrocholeretics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DigestiveAidCombinations(ValueSet):
    VALUE_SET_NAME = 'Digestive Aid Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '558610', '558611', '558612', '558622', '558623', '558624', '559533', '559534', '559535', '559536', '559592',
        '559593', '559594', '559595', '559929', '565323', '565325', '566916', '566917', '567019', '567020', '571081',
        '571082', '571493', '571494', '571496', '573026', '573027', '573070', '573072', '574353', '574354', '575817',
        '575818', '575819', '576929', '576956', '577999', '578000', '583420', '583422', '587587', '587684', '591848',
        '591849', '591850', '591851', '591922', '591923', '591924', '591925', '592302', '592306', '592364', '592378',
        '593478', '593532', '594255', '594262', '594970', '594978', '594980', '595015', '595520', '595521', '595523',
        '595524', '595950', '596009',
    }


class DigestiveAidMixturesWithAntiflatulents(ValueSet):
    VALUE_SET_NAME = 'Digestive Aid Mixtures with Antiflatulents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DigestiveAidMixturesWithAnticholinergics(ValueSet):
    VALUE_SET_NAME = 'Digestive Aid Mixtures with Anticholinergics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class GallstoneSolubilizingLitholysisAgentsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Gallstone Solubilizing (Litholysis) Agents and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '178797', '247089', '249255', '252632', '472012', '472013', '559761', '559765',
    }


class GallstoneSolubilizingLitholysisAgentCombinations(ValueSet):
    VALUE_SET_NAME = 'Gallstone Solubilizing (Litholysis) Agent Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class GastrointestinalAntiflatulentsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Gastrointestinal Antiflatulents and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159008', '159008', '164745', '169405', '172904', '172904', '175202', '175202', '175202', '175698', '190914',
        '190914', '190914', '190914', '190914', '190914', '190914', '197816', '197816', '197816', '197816', '197816',
        '202277', '215418', '224141', '234137', '238728', '242206', '244236', '253853', '257657', '260652', '260652',
        '264467', '264467', '266190', '275520', '277715', '278159', '298821', '435074', '443679', '446603', '471610',
        '474332', '476063', '545341', '545341', '545377', '545377', '556963', '556973', '557373', '557373', '560798',
        '561296', '561307', '561322', '563612', '572934', '572994', '581917', '581919', '583359', '583359', '583371',
        '583371', '596086',
    }


class GastrointestinalAntiflatulentCombinations(ValueSet):
    VALUE_SET_NAME = 'Gastrointestinal Antiflatulent Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class GastrointestinalProkineticCombinations(ValueSet):
    VALUE_SET_NAME = 'Gastrointestinal Prokinetic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class ColonicAcidifierAmmoniaInhibitor(ValueSet):
    VALUE_SET_NAME = 'Colonic Acidifier (Ammonia Inhibitor)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '188184', '188184', '291670', '569114',
    }


class InflammatoryBowelAgents(ValueSet):
    VALUE_SET_NAME = 'Inflammatory Bowel Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152214', '155199', '157734', '158018', '165759', '168879', '189081', '197780', '215612', '222513', '244310',
        '245387', '249289', '259607', '266986', '267499', '274798', '293882', '296506', '443447', '453663', '471731',
        '471749', '473045', '473045', '473045', '473106', '473106', '473106', '549049', '549060', '555411', '556053',
        '557072', '557075', '557104', '558170', '558399', '570456', '576354', '576821', '576824', '576932', '576945',
        '581636', '581637', '583043', '583129', '583132', '590116', '590734', '590735', '591897', '591900', '594068',
        '594069',
    }


class InflammatoryBowelAgentTumorNecrosisFactorAlphaBlockers(ValueSet):
    VALUE_SET_NAME = 'Inflammatory Bowel Agent - Tumor Necrosis Factor Alpha Blockers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '197780', '245387', '583043', '590116', '594068', '594069',
    }


class PhosphateBinders(ValueSet):
    VALUE_SET_NAME = 'Phosphate Binders'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '176076', '178153', '197192', '204899', '242829', '281736', '287975', '297162', '470906', '470923', '471063',
        '472578', '472604', '475826', '475827', '475830', '475831', '553812', '553835', '557058', '559065', '559065',
        '559066', '559066', '559072', '559073', '564260', '564483', '580774', '580807', '582562', '583421', '585437',
        '585438', '585440', '585441', '586587',
    }


class UrinaryAntiInfectiveCombinations(ValueSet):
    VALUE_SET_NAME = 'Urinary Anti-infective Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '204797', '435167', '444460', '444569', '445819', '445821', '454458', '474653', '476163', '550847', '552358',
        '560221', '560221', '561392', '561428', '561945', '562463', '562465', '562467', '562701', '564232', '564502',
        '581382', '581382', '582589', '582607', '583417', '583439', '583495', '586616', '586617', '586757', '587679',
        '587680', '587683', '589468', '590036', '590971', '595099', '595100',
    }


class UrinaryAntiInfectiveMethenamineCombinations(ValueSet):
    VALUE_SET_NAME = 'Urinary Anti-infective Methenamine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '204797', '435167', '444460', '444569', '445819', '445821', '454458', '474653', '476163', '550847', '552358',
        '560221', '560221', '561392', '561428', '561945', '562463', '562465', '562467', '562701', '564232', '564502',
        '581382', '581382', '582589', '582607', '583417', '583439', '583495', '586616', '586617', '586757', '587679',
        '587680', '587683', '589468', '590036', '590971', '595099', '595100',
    }


class UrinaryAntiInfectiveAnalgesicCombinations(ValueSet):
    VALUE_SET_NAME = 'Urinary Anti-infective-Analgesic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class UrinaryAntispasmodics(ValueSet):
    VALUE_SET_NAME = 'Urinary Antispasmodics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151167', '161941', '166377', '172070', '176493', '177820', '180155', '202494', '223607', '223837', '236249',
        '258320', '269610', '273895', '279326', '282572', '296218', '449001', '449002', '471236', '472665', '472666',
        '472681', '472682', '472953', '472958', '473019', '473020', '553789', '557437', '557438', '557444', '557445',
        '557974', '557980', '572216', '572227', '579663', '579663', '579665', '579665', '593384', '593390',
    }


class UrinaryAntispasmodicCombinations(ValueSet):
    VALUE_SET_NAME = 'Urinary Antispasmodic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class VaginalProducts(ValueSet):
    VALUE_SET_NAME = 'Vaginal Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157000', '157000', '158888', '159481', '161089', '162174', '163555', '168912', '183106', '183150', '183473',
        '183695', '184718', '188813', '188813', '189238', '189699', '193975', '196892', '197333', '198401', '199910',
        '200732', '202794', '204530', '206119', '207118', '212063', '215365', '215739', '215739', '216543', '219879',
        '219879', '222741', '229924', '229924', '230767', '230767', '230767', '240674', '242313', '260815', '260815',
        '260815', '263283', '264944', '265718', '266088', '266383', '266383', '267073', '271181', '271181', '271181',
        '271536', '271880', '277891', '280397', '282560', '288255', '299753', '401018', '401018', '401024', '435218',
        '435218', '435231', '435241', '435241', '444251', '444251', '446365', '448154', '448193', '448920', '449649',
        '449650', '449656', '449657', '450448', '451478', '453080', '453080', '453080', '453080', '467711', '467711',
        '467711', '472691', '472691', '472901', '472901', '475209', '476075', '545054', '545055', '545058', '545094',
        '545805', '546229', '553346', '553354', '553379', '553540', '558670', '558776', '558869', '558900', '558999',
        '559330', '559330', '559418', '559419', '559440', '559441', '559674', '559676', '560233', '560233', '560246',
        '560246', '561488', '561502', '562656', '562657', '562657', '563394', '564781', '565001', '565028', '567405',
        '568417', '569874', '569994', '570241', '575569', '575772', '576215', '576215', '577389', '577428', '577953',
        '578025', '578781', '579088', '580206', '580406', '581186', '584290', '584628', '592083', '592083', '593011',
        '593114', '594383',
    }


class VaginalAntiInfectives(ValueSet):
    VALUE_SET_NAME = 'Vaginal Anti-infectives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157000', '157000', '158888', '162174', '163555', '168912', '183106', '183150', '183695', '184718', '188813',
        '188813', '189238', '189699', '193975', '196892', '198401', '199910', '200732', '204530', '206119', '212063',
        '215365', '215739', '215739', '216543', '222741', '229924', '229924', '230767', '230767', '230767', '242313',
        '260815', '260815', '260815', '263283', '264944', '265718', '266088', '267073', '271181', '271181', '271181',
        '271880', '282560', '288255', '299753', '401018', '401018', '401024', '444251', '444251', '446365', '448154',
        '448193', '448920', '451478', '472691', '472691', '472901', '472901', '475209', '476075', '545805', '558670',
        '558776', '558999', '559418', '559440', '559441', '564781', '565001', '565028', '567405', '570241', '575569',
        '575772', '576215', '576215', '577953', '578025', '579088', '580206', '580406', '581186', '584290', '594383',
    }


class VaginalAntifungalAzoleAgents(ValueSet):
    VALUE_SET_NAME = 'Vaginal Antifungal - Azole Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157000', '157000', '162174', '163555', '168912', '183695', '184718', '188813', '188813', '189699', '193975',
        '196892', '198401', '204530', '206119', '212063', '215365', '216543', '229924', '229924', '264944', '267073',
        '282560', '288255', '299753', '401018', '401018', '401024', '444251', '444251', '446365', '448154', '448193',
        '448920', '451478', '545805', '558670', '558776', '558999', '565001', '565028', '567405', '575569', '575772',
        '576215', '576215', '577953', '578025', '579088', '580206', '580406', '594383',
    }


class VaginalAntiInfectiveCombinations(ValueSet):
    VALUE_SET_NAME = 'Vaginal Anti-infective Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158888', '199910', '242313', '271880', '559440', '559441',
    }


class VaginalAntiInflammatoryAgents(ValueSet):
    VALUE_SET_NAME = 'Vaginal Anti-inflammatory Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class VaginalCorticosteroids(ValueSet):
    VALUE_SET_NAME = 'Vaginal Corticosteroids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class VaginalNsaidS(ValueSet):
    VALUE_SET_NAME = 'Vaginal NSAID\'s'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class VaginalDoucheProducts(ValueSet):
    VALUE_SET_NAME = 'Vaginal Douche Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '435218', '435218', '453080', '453080', '453080', '453080', '467711', '467711', '467711', '559330', '559330',
        '559419', '559674', '559676',
    }


class Spermicides(ValueSet):
    VALUE_SET_NAME = 'Spermicides'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '200650', '218508', '232090', '233409', '249483', '250895', '266307', '266307', '266307', '289176', '289176',
        '547462', '547565', '560828', '589920',
    }


class VaginalEstrogens(ValueSet):
    VALUE_SET_NAME = 'Vaginal Estrogens'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161089', '240674', '277891', '280397', '435231', '449649', '449650', '449656', '449657', '450448', '560233',
        '560233', '560246', '560246', '592083', '592083',
    }


class VaginalProgestins(ValueSet):
    VALUE_SET_NAME = 'Vaginal Progestins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '207118', '271536',
    }


class VaginalProductsMiscellaneous(ValueSet):
    VALUE_SET_NAME = 'Vaginal Products Miscellaneous'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '219879', '219879', '435241', '435241', '545054', '545055', '545058', '545094', '553540', '569874', '569994',
        '578781',
    }


class FertilityEnhancers(ValueSet):
    VALUE_SET_NAME = 'Fertility Enhancers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '175833', '181189', '188463', '188801', '195153', '230248', '237700', '247230', '277383', '289485', '443552',
        '452666', '452812', '467442', '467443', '467447', '467448', '468272', '468273', '469643', '470631', '470632',
        '470633', '473659', '473667', '474881', '474883', '475460', '475461', '475467', '475468', '550758', '550769',
        '551538', '551574', '563314', '580380', '580381', '580382', '588070', '589777', '589793', '594369', '595556',
        '595596',
    }


class UrinaryPhModifierAcidifiers(ValueSet):
    VALUE_SET_NAME = 'Urinary pH Modifier - Acidifiers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '197856', '247132', '250547', '251329', '264316', '266853', '290710', '443793', '465676', '582057', '588726',
        '592987',
    }


class UrinaryAcidifierPhosphates(ValueSet):
    VALUE_SET_NAME = 'Urinary Acidifier - Phosphates'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '197856', '251329', '264316', '266853', '290710', '443793', '465676', '582057', '588726', '592987',
    }


class UrinaryPhModifierAlkalinizers(ValueSet):
    VALUE_SET_NAME = 'Urinary pH Modifier - Alkalinizers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160540', '160540', '171346', '176942', '198495', '206920', '212199', '213632', '213632', '216635', '231985',
        '235068', '261460', '262130', '290010', '293050', '297212', '435247', '454565', '560196', '560229', '583556',
        '585649', '585650',
    }


class UrinaryAlkalinizerCitrates(ValueSet):
    VALUE_SET_NAME = 'Urinary Alkalinizer - Citrates'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160540', '160540', '171346', '176942', '198495', '206920', '212199', '213632', '213632', '216635', '231985',
        '235068', '261460', '262130', '290010', '293050', '297212', '435247', '454565', '560196', '560229', '583556',
        '585649', '585650',
    }


class UrinaryAnalgesics(ValueSet):
    VALUE_SET_NAME = 'Urinary Analgesics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '182793', '182793', '188127', '190783', '231365', '231365', '234569', '435249', '453412', '552490', '555406',
        '555406', '555412', '561214', '561994', '578583', '578641', '585300', '585457', '585483', '586844',
    }


class CystinosisTherapyCystineDepletingAgents(ValueSet):
    VALUE_SET_NAME = 'Cystinosis Therapy (Cystine Depleting Agents)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150476', '185836', '231596', '235399', '578493', '578494', '578505', '578518',
    }


class InterstitialCystitisAgents(ValueSet):
    VALUE_SET_NAME = 'Interstitial Cystitis Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155663', '192580', '556045', '556314',
    }


class KidneyStoneAgents(ValueSet):
    VALUE_SET_NAME = 'Kidney Stone Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151309', '195979',
    }


class GUIrrigants(ValueSet):
    VALUE_SET_NAME = 'G.U. Irrigants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '171706', '178142', '193636', '193636', '195969', '195969', '195969', '195969', '201794', '207039', '207039',
        '244011', '257664', '257664', '257664', '261291', '265019', '289977', '557877', '557877', '590113', '590205',
    }


class GUIrrigantsAntiInfective(ValueSet):
    VALUE_SET_NAME = 'G.U. Irrigants - Anti-infective'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161231', '161231', '292160', '292160',
    }


class ProstaticHypertrophyAgents(ValueSet):
    VALUE_SET_NAME = 'Prostatic Hypertrophy Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152828', '229409', '252636', '291359', '446685', '446701', '452332', '452334', '557423', '557424', '557446',
        '557447', '561515', '561520',
    }


class ProstaticHypertrophyAgent5AlphaReductaseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Prostatic Hypertrophy Agent - 5-alpha Reductase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '252636', '291359', '446685', '446701',
    }


class ProstaticHypertrophyAgentAlpha1AdrenoceptorAntagonists(ValueSet):
    VALUE_SET_NAME = 'Prostatic Hypertrophy Agent - alpha-1-Adrenoceptor Antagonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152828', '229409', '452332', '452334', '557423', '557424', '557446', '557447',
    }


class AntianxietyAgents(ValueSet):
    VALUE_SET_NAME = 'Antianxiety Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151877', '152352', '155610', '159138', '161469', '168484', '169427', '173662', '174400', '176369', '180590',
        '194007', '194767', '199495', '208857', '217763', '217763', '220202', '221440', '221721', '222389', '222771',
        '224877', '226373', '227459', '232422', '233827', '234102', '235411', '239455', '242110', '243115', '258357',
        '258498', '259723', '262260', '265723', '266427', '269828', '270672', '271130', '271779', '273886', '275031',
        '275187', '278149', '278236', '281202', '283968', '289412', '289874', '289874', '289874', '291828', '292628',
        '294273', '295708', '297806', '298900', '299075', '445424', '449757', '449758', '449759', '449760', '449765',
        '449766', '449767', '449768', '473474', '473475', '473476', '473477', '570918', '575868',
    }


class AntianxietyAgentBenzodiazepines(ValueSet):
    VALUE_SET_NAME = 'Antianxiety Agent - Benzodiazepines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159138', '161469', '169427', '173662', '174400', '176369', '180590', '194007', '208857', '220202', '221440',
        '221721', '222389', '222771', '224877', '226373', '227459', '232422', '233827', '234102', '235411', '242110',
        '258357', '258498', '262260', '266427', '270672', '271130', '271779', '273886', '275031', '278149', '278236',
        '281202', '289412', '291828', '292628', '295708', '297806', '445424', '449757', '449758', '449759', '449760',
        '449765', '449766', '449767', '449768', '473474', '473475', '473476', '473477', '570918',
    }


class BenzodiazepineReversalAgentsBenzodiazepineAntagonists(ValueSet):
    VALUE_SET_NAME = 'Benzodiazepine Reversal Agents - Benzodiazepine Antagonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '299363', '299363',
    }


class Antidepressants(ValueSet):
    VALUE_SET_NAME = 'Antidepressants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150775', '151828', '153762', '155998', '156099', '156363', '157802', '158389', '159478', '159557', '160594',
        '162415', '162880', '162880', '163322', '163996', '164032', '164679', '164903', '165180', '165312', '165337',
        '165384', '167366', '168238', '168238', '168568', '169434', '170878', '172769', '173045', '174113', '174219',
        '176033', '176094', '176094', '177741', '178305', '180823', '180938', '181686', '181922', '182526', '182739',
        '182797', '183163', '183497', '184142', '185295', '186475', '186475', '187010', '187550', '189751', '190700',
        '190877', '191502', '193691', '193732', '195219', '196308', '197500', '199755', '204035', '204126', '205919',
        '206717', '206717', '207002', '208628', '212506', '215802', '216192', '217745', '218554', '219796', '221764',
        '222565', '222717', '222717', '223886', '223886', '224211', '227253', '227595', '227618', '228125', '228422',
        '229065', '230585', '231423', '232828', '233457', '233457', '234356', '234657', '235887', '236370', '236502',
        '237861', '237861', '237883', '237883', '237924', '238327', '238743', '238855', '239308', '239397', '240580',
        '240580', '244490', '247369', '247943', '248823', '251468', '251594', '252937', '255018', '255189', '255593',
        '256223', '256813', '257073', '258316', '259152', '259710', '261497', '261631', '263022', '265026', '266471',
        '269013', '270138', '270175', '270977', '271090', '271358', '273190', '274766', '274842', '276464', '278017',
        '278030', '278302', '279552', '279850', '279922', '280835', '281254', '281856', '283710', '283834', '284102',
        '284707', '287285', '287344', '287768', '288365', '289004', '289046', '289402', '290602', '291693', '292393',
        '293966', '294385', '294811', '296462', '297644', '297815', '299306', '400878', '400879', '400880', '400937',
        '400938', '400940', '444247', '444578', '445972', '445972', '445973', '445973', '445975', '445976', '448540',
        '448541', '451597', '451598', '451599', '451600', '453746', '453747', '453748', '453749', '453752', '453753',
        '453754', '453755', '453815', '453816', '453816', '453817', '453818', '453824', '453825', '453826', '453827',
        '453864', '453865', '467914', '471238', '471239', '471240', '471241', '471242', '471243', '476609', '476610',
        '476611', '476814', '476815', '476816', '551727', '551781', '554474', '554475', '554521', '554522', '554573',
        '554622', '554623', '554671', '556344', '556345', '556347', '556349', '557536', '557553', '557562', '557563',
        '558649', '558662', '561514', '561527', '561543', '561546', '564220', '564221', '564222', '564227', '564228',
        '564229', '568097', '572152', '572171', '574762', '574774', '577801', '577802', '579406', '579407', '579896',
        '579897', '579898', '579899', '579900', '579913', '579914', '579916', '579950', '579951', '579952', '580279',
        '580283', '580331', '580332', '580333', '580334', '580335', '581134', '581135', '583254', '583256', '583258',
        '584820', '584843', '584963', '584971', '585984', '585990',
    }


class AntidepressantAlpha2ReceptorAntagonistsNassa(ValueSet):
    VALUE_SET_NAME = 'Antidepressant - Alpha-2 Receptor Antagonists (NaSSA)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164903', '167366', '182526', '190877', '199755', '238855', '247369', '261631', '271090', '278017', '287285',
        '292393', '467914',
    }


class AntidepressantMonamineOxidaseMaoInhibitors(ValueSet):
    VALUE_SET_NAME = 'Antidepressant - Monamine Oxidase (MAO) Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '180938', '183497', '191502', '195219', '256813', '266471', '476609', '476610', '476611', '476814', '476815',
        '476816',
    }


class AntidepressantSelectiveSerotoninReuptakeInhibitorsSsris(ValueSet):
    VALUE_SET_NAME = 'Antidepressant - Selective Serotonin Reuptake Inhibitors (SSRIs)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151828', '153762', '156099', '162880', '162880', '165337', '168238', '168238', '172769', '174113', '176094',
        '176094', '183163', '184142', '186475', '186475', '187550', '190700', '204035', '216192', '222717', '222717',
        '227618', '231423', '232828', '235887', '236370', '237861', '237861', '237883', '237883', '239397', '240580',
        '240580', '255189', '259152', '270175', '279552', '279850', '280835', '283710', '283834', '284102', '287344',
        '287768', '289046', '291693', '400878', '400879', '400880', '400937', '400938', '400940', '445972', '445972',
        '445973', '445973', '445975', '445976', '448540', '448541', '453746', '453747', '453748', '453749', '453752',
        '453753', '453754', '453755', '453864', '453865', '554521', '554522', '554573', '554671', '568097',
    }


class AntidepressantSelectiveNorepinephrineReuptakeInhibitorSelNari(ValueSet):
    VALUE_SET_NAME = 'Antidepressant - Selective Norepinephrine Reuptake Inhibitor(SEL-NARI)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntipsychoticsNeuroleptics(ValueSet):
    VALUE_SET_NAME = 'Antipsychotics (Neuroleptics)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150937', '150994', '151461', '151461', '151677', '152293', '153091', '155882', '156874', '163705', '165351',
        '166170', '166170', '166370', '171830', '172422', '172631', '174156', '174272', '174836', '176281', '177407',
        '178184', '179384', '180115', '181424', '182986', '183135', '183135', '183135', '188391', '189075', '189148',
        '190512', '192267', '196623', '197357', '198370', '198781', '204963', '205256', '206428', '206428', '206888',
        '208137', '211371', '213638', '213759', '216465', '216583', '217071', '217099', '220673', '221839', '222887',
        '226680', '228213', '229384', '231269', '231819', '234539', '236015', '237377', '240542', '244419', '245686',
        '246386', '248531', '248873', '251884', '251904', '252140', '252140', '253110', '255538', '256482', '258197',
        '258954', '259854', '261014', '262012', '262447', '262447', '262447', '262563', '262620', '263934', '264194',
        '266352', '266352', '266352', '266789', '268991', '270650', '270716', '273230', '273597', '273686', '276552',
        '277577', '278143', '279297', '281841', '282857', '283402', '284576', '284616', '288311', '288804', '290779',
        '292133', '293161', '293689', '295531', '295980', '298293', '298541', '298541', '298987', '445187', '445964',
        '446832', '446833', '446834', '446835', '446836', '446837', '446838', '446839', '449530', '449530', '449530',
        '449531', '449531', '449531', '449532', '449532', '449537', '449537', '449538', '449539', '449539', '451007',
        '451010', '453115', '453116', '453117', '453138', '453139', '453140', '467498', '467506', '467838', '467839',
        '468368', '468369', '473030', '473134', '473182', '474360', '476032', '476034', '476173', '476267', '476267',
        '476268', '476268', '476269', '476270', '476699', '476699', '476700', '476700', '476712', '476713', '545538',
        '545539', '545817', '545818', '548357', '548377', '548640', '548640', '548641', '548641', '548642', '548642',
        '548671', '548672', '548673', '550757', '550763', '551086', '551087', '551088', '551592', '551593', '551594',
        '552532', '552628', '557133', '557134', '557135', '557136', '558410', '558968', '558969', '558970', '558971',
        '558972', '559003', '559004', '559005', '559007', '559008', '559151', '559152', '559152', '559444', '559445',
        '560052', '560053', '560054', '560055', '560056', '560057', '560058', '560059', '560062', '560063', '560064',
        '560065', '560066', '560067', '560068', '560069', '560427', '560428', '560430', '560437', '560438', '560439',
        '561833', '561835', '561972', '561973', '562943', '562944', '562954', '562955', '569999', '570010', '574908',
        '574987', '575764', '575764', '575766', '576476', '577010', '577274', '577275', '577284', '577285', '579421',
        '579421', '579421', '579708', '579767', '580325', '580694', '583568', '583570', '583573', '583574', '585516',
        '585516', '585518', '585518', '585935', '585936', '585937', '585938', '586041', '586042', '586043', '586044',
        '586588', '586590', '586591', '586592', '586593', '586594', '586596', '586597', '586598', '586599', '586600',
        '586601', '587546', '587547', '587548', '587549', '587727', '587728', '587729', '587730', '587741', '587742',
        '587743', '587750', '587751', '587752', '589486', '589491', '590471', '590474', '593777', '593780',
    }


class AntipsychoticBenzamideDerivatives(ValueSet):
    VALUE_SET_NAME = 'Antipsychotic - Benzamide Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntipsychoticButyrophenoneDerivatives(ValueSet):
    VALUE_SET_NAME = 'Antipsychotic - Butyrophenone Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153091', '156874', '165351', '183135', '183135', '183135', '197357', '244419', '248873', '259854', '261014',
        '262447', '262447', '262447', '266352', '266352', '266352', '282857', '298541', '298541', '473134',
    }


class AntipsychoticAtypicalDopamineSerotoninAntagDibenzodiazepineDer(ValueSet):
    VALUE_SET_NAME = 'Antipsychotic - Atypical Dopamine-Serotonin Antag-Dibenzodiazepine Der'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '172422', '174272', '256482', '273597', '467838', '467839', '468368', '468369', '474360', '476173', '552532',
        '552628', '561833', '561835', '561972', '561973', '577010', '580325',
    }


class AntipsychoticPhenothiazines(ValueSet):
    VALUE_SET_NAME = 'Antipsychotic - Phenothiazines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151461', '151461', '151677', '155882', '163705', '166370', '176281', '178184', '180115', '189148', '208137',
        '211371', '213759', '220673', '221839', '231269', '240542', '251884', '252140', '252140', '263934', '268991',
        '277577', '281841', '284576', '292133', '293689', '295980',
    }


class BipolarTherapyAgents(ValueSet):
    VALUE_SET_NAME = 'Bipolar Therapy Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '196753', '198629', '198841', '209182', '233694', '235118', '284261', '286428', '473729', '473730', '473731',
        '575830', '589905', '589906', '589907',
    }


class SedativeHypnotics(ValueSet):
    VALUE_SET_NAME = 'Sedative-Hypnotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150882', '150882', '154258', '157164', '157244', '158358', '158503', '163306', '169027', '170449', '170449',
        '179675', '179903', '179903', '179992', '181571', '181571', '182137', '186546', '187809', '197942', '200162',
        '200702', '201671', '208938', '220055', '220055', '222595', '225558', '229037', '229037', '231124', '248054',
        '248162', '248162', '248162', '250267', '251455', '252494', '260923', '269693', '270070', '272077', '272622',
        '273968', '273968', '273968', '273968', '274265', '275883', '276233', '278649', '282441', '283969', '288019',
        '289261', '289537', '289537', '289537', '290568', '293839', '295032', '295032', '298705', '400758', '435512',
        '435527', '435529', '435529', '435529', '435532', '435534', '435547', '445300', '445300', '445300', '445300',
        '445300', '445426', '445619', '445620', '451840', '452313', '452355', '452356', '453197', '454102', '454103',
        '467317', '467473', '472774', '472775', '472776', '472797', '472798', '472799', '472891', '472897', '474814',
        '474905', '475011', '475012', '475014', '475015', '476392', '547774', '550157', '550235', '552111', '554941',
        '554941', '554960', '554980', '556041', '556991', '557028', '558617', '558619', '558646', '558647', '559028',
        '559357', '561218', '561853', '561935', '561936', '561942', '561944', '562343', '562392', '562986', '562986',
        '562990', '562990', '563102', '563152', '563317', '563364', '563555', '563574', '563719', '563802', '563827',
        '569083', '569085', '569191', '569641', '569647', '569971', '570022', '570993', '570994', '571334', '571335',
        '571423', '571791', '572205', '572254', '572673', '572995', '572995', '572995', '572995', '573000', '573000',
        '573000', '573057', '573057', '573057', '573975', '575883', '575905', '575937', '576330', '576425', '576444',
        '576551', '576849', '577099', '577917', '577919', '577921', '577924', '577925', '577975', '578649', '578748',
        '578748', '579567', '579584', '579619', '579636', '579786', '579813', '579814', '579998', '580143', '580591',
        '580591', '580650', '580650', '580665', '580689', '580890', '581053', '581108', '581263', '581267', '581268',
        '581320', '582266', '582313', '582314', '582315', '582316', '582361', '582362', '582363', '582364', '583000',
        '583000', '583000', '583279', '583576', '583835', '583839', '584077', '584107', '585992', '586022', '586075',
        '586128', '586242', '586706', '586852', '587163', '587243', '587400', '587574', '587719', '587826', '589549',
        '589825', '592395', '592759', '594843',
    }


class SedativeHypnoticBarbiturates(ValueSet):
    VALUE_SET_NAME = 'Sedative-Hypnotic - Barbiturates'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158503', '170449', '170449', '200702', '220055', '220055', '222595', '260923', '272622', '435512', '563152',
    }


class SedativeHypnoticNonBarbiturates(ValueSet):
    VALUE_SET_NAME = 'Sedative-Hypnotic - Non-Barbiturates'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150882', '150882', '154258', '157164', '157244', '158358', '163306', '169027', '179675', '179903', '179903',
        '179992', '181571', '181571', '182137', '186546', '187809', '197942', '200162', '201671', '208938', '225558',
        '229037', '229037', '231124', '248054', '248162', '248162', '248162', '250267', '251455', '252494', '269693',
        '270070', '272077', '273968', '273968', '273968', '273968', '274265', '275883', '276233', '278649', '282441',
        '283969', '288019', '289261', '289537', '289537', '289537', '290568', '293839', '295032', '295032', '298705',
        '400758', '435527', '435529', '435529', '435529', '435532', '435534', '435547', '445300', '445300', '445300',
        '445300', '445300', '445426', '445619', '445620', '451840', '452313', '452355', '452356', '453197', '454102',
        '454103', '467317', '467473', '472774', '472775', '472776', '472797', '472798', '472799', '472891', '472897',
        '474814', '474905', '475011', '475012', '475014', '475015', '476392', '547774', '550157', '550235', '552111',
        '554941', '554941', '554960', '554980', '556041', '556991', '557028', '558617', '558619', '558646', '558647',
        '559028', '559357', '561218', '561853', '561935', '561936', '561942', '561944', '562343', '562392', '562986',
        '562986', '562990', '562990', '563102', '563317', '563364', '563555', '563574', '563719', '563802', '563827',
        '569083', '569085', '569191', '569641', '569647', '569971', '570022', '570993', '570994', '571334', '571335',
        '571423', '571791', '572205', '572254', '572673', '572995', '572995', '572995', '572995', '573000', '573000',
        '573000', '573057', '573057', '573057', '573975', '575883', '575905', '575937', '576330', '576425', '576444',
        '576551', '576849', '577099', '577917', '577919', '577921', '577924', '577925', '577975', '578649', '578748',
        '578748', '579567', '579584', '579619', '579636', '579786', '579813', '579814', '579998', '580143', '580591',
        '580591', '580650', '580650', '580665', '580689', '580890', '581053', '581108', '581263', '581267', '581268',
        '581320', '582266', '582313', '582314', '582315', '582316', '582361', '582362', '582363', '582364', '583000',
        '583000', '583000', '583279', '583576', '583835', '583839', '584077', '584107', '585992', '586022', '586075',
        '586128', '586242', '586706', '586852', '587163', '587243', '587400', '587574', '587719', '587826', '589549',
        '589825', '592395', '592759', '594843',
    }


class SedativeHypnoticBenzodiazepines(ValueSet):
    VALUE_SET_NAME = 'Sedative-Hypnotic - Benzodiazepines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150882', '150882', '154258', '157164', '158358', '163306', '169027', '179903', '179903', '181571', '181571',
        '182137', '186546', '187809', '197942', '208938', '225558', '231124', '250267', '272077', '282441', '293839',
        '295032', '295032', '445619', '445620', '472891', '472897', '556041', '556991', '557028', '561853', '562392',
        '569971', '570022',
    }


class SedativeHypnoticGabaReceptorModulators(ValueSet):
    VALUE_SET_NAME = 'Sedative-Hypnotic - GABA-Receptor Modulators'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '179675', '269693', '270070', '274265', '278649', '289261', '290568', '298705', '472774', '472775', '472776',
        '472797', '472798', '472799', '475011', '475012', '475014', '475015', '558617', '558619', '558646', '558647',
        '562986', '562986', '562990', '562990', '570993', '570994', '571334', '571335',
    }


class SedativeHypnoticAntihistamines(ValueSet):
    VALUE_SET_NAME = 'Sedative-Hypnotic - Antihistamines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157244', '201671', '229037', '229037', '248054', '251455', '273968', '273968', '273968', '273968', '275883',
        '276233', '283969', '288019', '289537', '289537', '289537', '435527', '435529', '435529', '435529', '435532',
        '435534', '435547', '445300', '445300', '445300', '445300', '445300', '445426', '467317', '467473', '547774',
        '552111', '554941', '554941', '554960', '559357', '572995', '572995', '572995', '572995', '573000', '573000',
        '573000', '573057', '573057', '573057', '575883', '577099', '577921', '578748', '578748', '579567', '579619',
        '579636', '579813', '579998', '581108', '582266', '583000', '583000', '583000', '583279', '583576', '586242',
        '586852', '587163', '587243', '587826',
    }


class SedativeHypnoticAntihistamineCombinations(ValueSet):
    VALUE_SET_NAME = 'Sedative-Hypnotic - Antihistamine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class SedativeHypnoticCombinations(ValueSet):
    VALUE_SET_NAME = 'Sedative-Hypnotic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class CnsStimulants(ValueSet):
    VALUE_SET_NAME = 'CNS Stimulants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154160', '154160', '166598', '169229', '174882', '177953', '183403', '196148', '204879', '206921', '207704',
        '209390', '217565', '219330', '225388', '254083', '255314', '259312', '260349', '265361', '276791', '276916',
        '276916', '276916', '283048', '283048', '287703', '287703', '287703', '292130', '435771', '553409', '555265',
        '557461', '578651', '578653', '578655', '578656', '578669', '578670', '581525', '581526', '581527', '581540',
        '581541', '581542', '582389', '583765', '583766', '583768', '583792',
    }


class CnsStimulantAmphetamines(ValueSet):
    VALUE_SET_NAME = 'CNS Stimulant - Amphetamines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '166598', '169229', '196148', '204879', '207704', '209390', '219330', '254083', '255314', '265361', '292130',
        '555265', '557461', '578651', '578653', '578655', '578656', '578669', '578670', '581525', '581526', '581527',
        '581540', '581541', '581542', '582389', '583765', '583766', '583768', '583792',
    }


class CnsStimulantAmphetamineCombinations(ValueSet):
    VALUE_SET_NAME = 'CNS Stimulant - Amphetamine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class Anorexiants(ValueSet):
    VALUE_SET_NAME = 'Anorexiants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156383', '179380', '181295', '193292', '196819', '200013', '204397', '208252', '212958', '213054', '229139',
        '259223', '292152', '299345', '570139', '570140', '570144', '570145', '575450', '575451', '576408', '576434',
        '591780',
    }


class AnorexiantCombinations(ValueSet):
    VALUE_SET_NAME = 'Anorexiant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '573963', '573964', '573965', '573966', '574991', '574992', '574993', '574994',
    }


class AntiObesityAgents(ValueSet):
    VALUE_SET_NAME = 'Anti-Obesity Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '171834', '256851', '551444', '551444', '551451', '551451', '578704', '578714', '582580', '582584', '583503',
        '584911', '591205', '591324',
    }


class AntiObesityHormonalAgents(ValueSet):
    VALUE_SET_NAME = 'Anti-Obesity - Hormonal Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntiObesityFatAbsorptionDecreasingAgents(ValueSet):
    VALUE_SET_NAME = 'Anti-Obesity - Fat Absorption Decreasing Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '171834', '256851', '551444', '551444', '551451', '551451',
    }


class AntiObesityMonoamineReuptakeInhibitors(ValueSet):
    VALUE_SET_NAME = 'Anti-Obesity - Monoamine Reuptake Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntiObesitySerotoninReuptakeInhibitors(ValueSet):
    VALUE_SET_NAME = 'Anti-Obesity - Serotonin Reuptake Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class CnsStimulantAnaleptics(ValueSet):
    VALUE_SET_NAME = 'CNS Stimulant - Analeptics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154160', '154160', '177953', '183403', '206921', '217565', '259312', '260349', '276791', '276916', '276916',
        '276916', '283048', '283048', '287703', '287703', '287703', '435771', '553409',
    }


class CnsStimulantAnalepticCombinations(ValueSet):
    VALUE_SET_NAME = 'CNS Stimulant - Analeptic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AttentionDeficitHyperactivityAdhdTherapyStimulantType(ValueSet):
    VALUE_SET_NAME = 'Attention Deficit-Hyperactivity (ADHD) Therapy, Stimulant-Type'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151208', '154196', '157658', '158986', '167997', '169764', '174864', '176052', '176132', '178538', '181659',
        '183921', '184255', '187885', '194444', '198314', '207855', '209785', '214704', '215346', '218736', '220449',
        '230013', '237286', '237302', '242780', '244161', '246298', '247696', '255022', '258391', '260058', '265054',
        '266696', '277390', '277622', '279828', '281575', '285987', '292678', '294452', '297274', '400963', '400964',
        '443804', '443805', '443806', '443812', '443813', '443814', '445259', '445260', '445261', '450870', '451159',
        '452570', '452571', '452572', '452573', '452574', '452575', '467713', '467717', '469734', '469735', '469736',
        '469737', '469738', '469763', '469764', '469765', '469766', '469767', '474272', '474273', '474274', '474278',
        '474279', '474281', '476820', '476821', '476822', '476826', '476827', '476828', '545086', '545087', '545088',
        '545089', '545169', '545170', '545171', '545172', '546091', '546096', '546707', '546709', '546711', '546713',
        '546715', '546717', '546719', '549869', '549870', '549871', '550900', '550901', '550902', '554190', '554191',
        '554192', '554197', '554198', '554199', '560061', '560089', '562001', '562005', '565649', '565652', '565660',
        '565661', '576379', '576379', '576379', '576379', '576484', '576484', '576484', '576484', '583549', '583565',
        '585519', '585520', '585521', '585522', '585523', '585524', '585525', '586399', '586409', '588027', '588623',
        '588624', '588625', '588641', '588642', '588643', '589074', '589401', '589402', '589403', '589404', '589405',
        '589406', '589537', '589538', '589539', '589540', '589541', '589542', '592889', '593037', '593038', '593039',
        '593044', '593045', '593163', '593164', '593165', '593166', '593167', '593168', '593851', '593852', '593853',
        '593859', '593860', '593861', '593862', '593869', '593870', '593871', '593872', '594127', '594128', '594129',
        '594462', '595152', '595267',
    }


class CognitiveDisorderTherapy(ValueSet):
    VALUE_SET_NAME = 'Cognitive Disorder Therapy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153512', '160755', '164231', '182063', '183004', '191398', '203950', '210354', '235446', '237989', '242601',
        '252804', '254940', '258218', '270337', '292682', '292978', '453564', '453568', '453569', '453570', '453571',
        '453573', '473023', '473024', '473025', '473793', '473794', '473818', '473832', '473832', '473923', '473924',
        '473924', '474102', '474103', '474163', '474755', '551711', '551712', '552270', '552271', '561763', '561774',
        '575113', '575256', '577884', '577885', '577886', '577887', '577946', '578121', '578122', '578123', '578124',
        '578125', '585003', '585005', '585013', '585014', '591621', '591622', '591628', '591629', '592253', '592261',
    }


class CognitiveDisorderTherapyAntidementia(ValueSet):
    VALUE_SET_NAME = 'Cognitive Disorder Therapy - Antidementia'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153512', '160755', '164231', '182063', '183004', '191398', '203950', '210354', '237989', '242601', '252804',
        '254940', '258218', '270337', '292682', '292978', '453564', '453568', '453569', '453570', '453571', '453573',
        '473023', '473024', '473025', '473793', '473794', '473818', '473832', '473832', '473923', '473924', '473924',
        '474102', '474103', '474163', '474755', '551711', '551712', '552270', '552271', '561763', '561774', '575113',
        '575256', '577884', '577885', '577886', '577887', '577946', '578121', '578122', '578123', '578124', '578125',
        '585003', '585005', '585013', '585014', '591621', '591622', '591628', '591629', '592253', '592261',
    }


class AlzheimerSDiseaseTherapyCholinesteraseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Alzheimer\'s Disease Therapy - Cholinesterase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153512', '160755', '164231', '182063', '183004', '191398', '203950', '210354', '237989', '242601', '252804',
        '254940', '258218', '270337', '292682', '292978', '473023', '473024', '473025', '473793', '473794', '473818',
        '473923', '473924', '473924', '474102', '474103', '474163', '551711', '551712', '552270', '552271', '561763',
        '561774', '575113', '575256',
    }


class AntidementiaNootropics(ValueSet):
    VALUE_SET_NAME = 'Antidementia - Nootropics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class SmokingDeterrentsSystemic(ValueSet):
    VALUE_SET_NAME = 'Smoking Deterrents, Systemic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155551', '164034', '164034', '164034', '174208', '174208', '174208', '174208', '174208', '174208', '174208',
        '174208', '174208', '174208', '174208', '174208', '174208', '174208', '174208', '182119', '182119', '182119',
        '182119', '182119', '182119', '182119', '182119', '182119', '183364', '183364', '183364', '197774', '204691',
        '206127', '207581', '207581', '218691', '230787', '230787', '230787', '230787', '230787', '230787', '230787',
        '230787', '230787', '230787', '230787', '230787', '230787', '230787', '234905', '234905', '237934', '237934',
        '242610', '242610', '242610', '242610', '242610', '242610', '242610', '242610', '242610', '252274', '252274',
        '252274', '252274', '268297', '297622', '297622', '446910', '446910', '448316', '448316', '448316', '448316',
        '448316', '448316', '448316', '448316', '448317', '448317', '448317', '448317', '448317', '448317', '448317',
        '448317', '448317', '448317', '468409', '473697', '473697', '473698', '473698', '545344', '545344', '545344',
        '545345', '545346', '545545', '545546', '545547', '550895', '560398', '560399', '561655', '561655', '561655',
        '561655', '561655', '561655', '561655', '561655', '561656', '561656', '561656', '561656', '561656', '561656',
        '569442', '569444', '569444', '572931', '572933', '582271', '582312', '589901', '593030', '593030', '593030',
        '593034', '593034', '593034', '593035', '593035', '593035', '593036', '593036', '593036',
    }


class SmokingDeterrentCombinations(ValueSet):
    VALUE_SET_NAME = 'Smoking Deterrent Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MultipleSclerosisAgents(ValueSet):
    VALUE_SET_NAME = 'Multiple Sclerosis Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '198530', '237061', '400517', '400519', '400523', '400524', '450963', '450963', '450976', '450976', '472548',
        '472554', '473315', '473321', '556627', '556741', '559141', '560498', '560503', '562231', '562231', '562231',
        '562232', '562232', '562232', '571857', '571857', '571874', '571874', '575247', '575248', '575333', '575334',
        '575380', '575381', '577026', '577031', '577033', '577036', '577037', '577038', '577693', '577694', '577695',
        '577701', '577702', '577703', '580761', '580770', '582356', '582358', '582359', '582360', '582731', '582736',
        '582737', '582738', '583190', '583194', '586234', '591072', '591076', '593342', '593345', '595605',
    }


class ChemicalDependencyAgentsToTreat(ValueSet):
    VALUE_SET_NAME = 'Chemical Dependency, Agents to Treat'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155551', '164034', '164034', '164034', '174208', '174208', '174208', '174208', '174208', '174208', '174208',
        '174208', '174208', '174208', '174208', '174208', '174208', '174208', '174208', '182119', '182119', '182119',
        '182119', '182119', '182119', '182119', '182119', '182119', '183364', '183364', '183364', '197774', '202917',
        '204691', '206127', '207581', '207581', '211704', '218691', '230787', '230787', '230787', '230787', '230787',
        '230787', '230787', '230787', '230787', '230787', '230787', '230787', '230787', '230787', '234905', '234905',
        '237934', '237934', '242610', '242610', '242610', '242610', '242610', '242610', '242610', '242610', '242610',
        '252274', '252274', '252274', '252274', '268297', '274365', '289669', '297622', '297622', '446910', '446910',
        '448276', '448276', '448277', '448277', '448291', '448292', '448316', '448316', '448316', '448316', '448316',
        '448316', '448316', '448316', '448317', '448317', '448317', '448317', '448317', '448317', '448317', '448317',
        '448317', '448317', '468409', '471237', '473697', '473697', '473698', '473698', '545344', '545344', '545344',
        '545345', '545346', '545412', '545415', '545545', '545546', '545547', '550895', '560398', '560399', '561655',
        '561655', '561655', '561655', '561655', '561655', '561655', '561655', '561656', '561656', '561656', '561656',
        '561656', '561656', '562052', '562053', '562058', '562059', '569442', '569444', '569444', '572931', '572933',
        '576019', '576036', '576061', '576062', '579099', '579103', '579230', '579231', '581808', '581809', '581810',
        '582173', '582174', '582175', '582271', '582312', '583856', '583857', '583868', '587211', '587214', '587216',
        '589901', '590745', '590758', '592660', '592661', '593030', '593030', '593030', '593034', '593034', '593034',
        '593035', '593035', '593035', '593036', '593036', '593036', '595055', '595056', '595131', '595133',
    }


class AlcoholDeterrents(ValueSet):
    VALUE_SET_NAME = 'Alcohol Deterrents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '202917', '211704', '274365', '289669',
    }


class AgentsForNarcoticWithdrawal(ValueSet):
    VALUE_SET_NAME = 'Agents for Narcotic Withdrawal'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '448276', '448276', '448277', '448277', '448291', '448292', '562052', '562053', '562058', '562059', '576019',
        '576036', '576061', '576062', '579099', '579103', '579230', '579231', '581808', '581809', '581810', '582173',
        '582174', '582175', '583856', '583857', '583868', '587211', '587214', '587216', '590745', '590758', '592660',
        '592661', '595055', '595056', '595131', '595133',
    }


class AnalgesicAntiInflammatoryOrAntipyreticNonNarcotic(ValueSet):
    VALUE_SET_NAME = 'Analgesic, Anti-inflammatory or Antipyretic - Non-Narcotic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150636', '151023', '151116', '151116', '151348', '152758', '152763', '154374', '154691', '154729', '154729',
        '154729', '154729', '155093', '155241', '155771', '156072', '156467', '156756', '157574', '157804', '158362',
        '158362', '158362', '158535', '159388', '159499', '160401', '160401', '160929', '160929', '160929', '161789',
        '163355', '163355', '163709', '163973', '164122', '164122', '164141', '165458', '166467', '166662', '167161',
        '167222', '167261', '167815', '168008', '168008', '168008', '168008', '169047', '169647', '170807', '171848',
        '172276', '172276', '172331', '172480', '172480', '173420', '174189', '174940', '175570', '175645', '176198',
        '177014', '178017', '178413', '179458', '181418', '181418', '181418', '182198', '182198', '182478', '187592',
        '189154', '189993', '191006', '191515', '192500', '192560', '192560', '192859', '193042', '193190', '195116',
        '195116', '195116', '195227', '196127', '196211', '196631', '196684', '198054', '198251', '198251', '198770',
        '198954', '199835', '201982', '201982', '201982', '202198', '202464', '202602', '202602', '203847', '204491',
        '205316', '205957', '206060', '206813', '206813', '206813', '206813', '208371', '208653', '208972', '211068',
        '211731', '212784', '213119', '214238', '215697', '216092', '216915', '216915', '217919', '217919', '217919',
        '217972', '218199', '218538', '218713', '222191', '222791', '222791', '224295', '225171', '225171', '225171',
        '225171', '227376', '227376', '227988', '227988', '228043', '228278', '228882', '229265', '230120', '231235',
        '231636', '232150', '234997', '237273', '237650', '237650', '237650', '237650', '237782', '237786', '237786',
        '237786', '237786', '237786', '237919', '239170', '239963', '240035', '240146', '240846', '240856', '242088',
        '242316', '243513', '244392', '244817', '245921', '246191', '246191', '246321', '249180', '249381', '249524',
        '249746', '250548', '250621', '252217', '252407', '252891', '254478', '254960', '255740', '255796', '256171',
        '256217', '256217', '256217', '256217', '256461', '256812', '257396', '258332', '259181', '259181', '259623',
        '260353', '260635', '261620', '261893', '262483', '262908', '263280', '263280', '263818', '264674', '264771',
        '265096', '265498', '265665', '266721', '267074', '269923', '271667', '271667', '272656', '272656', '272668',
        '272668', '273242', '273372', '273839', '273839', '273839', '274248', '275304', '275533', '275777', '275877',
        '277462', '278995', '278995', '278995', '278995', '280170', '280256', '280631', '281309', '281639', '281792',
        '282942', '284316', '284790', '284977', '286068', '286119', '286283', '286640', '286843', '286862', '286879',
        '287089', '288156', '288226', '289448', '289538', '289798', '290029', '290824', '290887', '291838', '292038',
        '292038', '292038', '292627', '292728', '293894', '293894', '297151', '297946', '297946', '298026', '298404',
        '298739', '299282', '400720', '400862', '435870', '435904', '435905', '435910', '435910', '435912', '436040',
        '436095', '436096', '436181', '436182', '436188', '436195', '436201', '436218', '436281', '436284', '436288',
        '436288', '436288', '436288', '436288', '436347', '436375', '436376', '436480', '436480', '436487', '436725',
        '436725', '436726', '436726', '436727', '436727', '443591', '443788', '443789', '443790', '443791', '444351',
        '444351', '444358', '444366', '445980', '446086', '446608', '446619', '446625', '446625', '446625', '446625',
        '446625', '446812', '448106', '448214', '448214', '448214', '448215', '448393', '448504', '449505', '449505',
        '449511', '449511', '449511', '450881', '451231', '453593', '468425', '469651', '469651', '470916', '470917',
        '471357', '471359', '471498', '472027', '472035', '472085', '472123', '472398', '472399', '472401', '472634',
        '472635', '472656', '472662', '473007', '473007', '473008', '473056', '473104', '473104', '473105', '473233',
        '473386', '473386', '473458', '473959', '474018', '474040', '475165', '475165', '475165', '475168', '475168',
        '475168', '475168', '475472', '475475', '475951', '475956', '476033', '476036', '476156', '476156', '476156',
        '476250', '476250', '476251', '476251', '476251', '476252', '476252', '476449', '501022', '545052', '545053',
        '545240', '545499', '545593', '545648', '545909', '545922', '545922', '545922', '546236', '546236', '547549',
        '548533', '548589', '548778', '548882', '549094', '549137', '550079', '550269', '550378', '550378', '550412',
        '550412', '550512', '550522', '550666', '550666', '550666', '550677', '550720', '550723', '550729', '551004',
        '551992', '551993', '551994', '552035', '552238', '552910', '554016', '554044', '554116', '554440', '554452',
        '554515', '554533', '554843', '554844', '555663', '555679', '556116', '556117', '556226', '556254', '556352',
        '556951', '556951', '557049', '557055', '557063', '557111', '557123', '557264', '557280', '557680', '558052',
        '558052', '558089', '558091', '558097', '558098', '558206', '558312', '558312', '558316', '558772', '558772',
        '558866', '558876', '558901', '558908', '558981', '558987', '559203', '559643', '559645', '559647', '559648',
        '559648', '559649', '559649', '559691', '559700', '559714', '559715', '559823', '560001', '560007', '560251',
        '560252', '560253', '560256', '560257', '560258', '560311', '560320', '560614', '560698', '560739', '560998',
        '560998', '561019', '561116', '561208', '561220', '561221', '561225', '561226', '561343', '561370', '561370',
        '561370', '561395', '561395', '561395', '561406', '561406', '561420', '561693', '562118', '562143', '562144',
        '562197', '562311', '562479', '562613', '562666', '562788', '562832', '563023', '563502', '563503', '563504',
        '563505', '563992', '563992', '563992', '563992', '564055', '564079', '564079', '564164', '564244', '564244',
        '564246', '564246', '565196', '565196', '565611', '565613', '566746', '566749', '567329', '567329', '567329',
        '567464', '567732', '567780', '568485', '568523', '569211', '569475', '569475', '570239', '570438', '570438',
        '570438', '571297', '571588', '571588', '571914', '572882', '573186', '573638', '575557', '575807', '575931',
        '575933', '575942', '575951', '576274', '576274', '577035', '577114', '577144', '577416', '577416', '577783',
        '577825', '577825', '577825', '577834', '577834', '577834', '578586', '578589', '578846', '578847', '578848',
        '579118', '579118', '579118', '579118', '579118', '579118', '579118', '579118', '579118', '579118', '579118',
        '579128', '579128', '579128', '579128', '579128', '579128', '579128', '579128', '579128', '579128', '579128',
        '579153', '579240', '579261', '579314', '579322', '579329', '579747', '579747', '580062', '580063', '580064',
        '580065', '580137', '580144', '580147', '580148', '580150', '580151', '580504', '580505', '580506', '580507',
        '580707', '580710', '581005', '581005', '581006', '581174', '581174', '581175', '581329', '581894', '581906',
        '582106', '582107', '582108', '582109', '582110', '582111', '582112', '582113', '582114', '582343', '582344',
        '582346', '582348', '582349', '582350', '582351', '582365', '582366', '582367', '582855', '582857', '582875',
        '582875', '583509', '583542', '583566', '583737', '583983', '584183', '584213', '585484', '585485', '585491',
        '585492', '585699', '585844', '586755', '586832', '587203', '587219', '587224', '587273', '587332', '587381',
        '587722', '587722', '588218', '588231', '588264', '588323', '588456', '588457', '588469', '588470', '588563',
        '589009', '589340', '589502', '589705', '589706', '590102', '590141', '590142', '590144', '590146', '590149',
        '590319', '590319', '590340', '590340', '590461', '590461', '590482', '590482', '590583', '590583', '590911',
        '590912', '590918', '590934', '590973', '590977', '591120', '591129', '591161', '591743', '591759', '591894',
        '591895', '591994', '592174', '592246', '592446', '592494', '592851', '593201', '593203', '593346', '593347',
        '593349', '593350', '593650', '593651', '593658', '593659', '593676', '594088', '594090', '594099', '594100',
        '594321', '594503', '594552', '594596', '594780', '594797', '594812', '595013', '595072', '595072', '595599',
        '595807', '595808', '595910',
    }


class SalicylateAnalgesics(ValueSet):
    VALUE_SET_NAME = 'Salicylate Analgesics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155093', '156072', '164122', '164122', '172480', '172480', '174940', '176198', '179458', '187592', '198054',
        '202464', '216092', '218199', '222791', '222791', '228882', '230120', '237782', '242316', '262908', '263818',
        '265096', '275777', '286068', '286879', '289448', '298026', '435870', '435904', '435905', '435910', '435910',
        '435912', '469651', '469651', '475165', '475165', '475165', '475168', '475168', '475168', '475168', '545499',
        '546236', '546236', '554044', '558052', '558052', '563992', '563992', '563992', '563992', '568523', '584183',
        '584213',
    }


class AnalgesicOrAntipyreticNonNarcotic(ValueSet):
    VALUE_SET_NAME = 'Analgesic or Antipyretic Non-Narcotic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152758', '154691', '154729', '154729', '154729', '154729', '155771', '158362', '158362', '158362', '159388',
        '160401', '160401', '160929', '160929', '160929', '165458', '166662', '167261', '168008', '168008', '168008',
        '168008', '169647', '172276', '172276', '175570', '177014', '181418', '181418', '181418', '191006', '192500',
        '192560', '192560', '193190', '195116', '195116', '195116', '195227', '198954', '201982', '201982', '201982',
        '206813', '206813', '206813', '206813', '211731', '217919', '217919', '217919', '218538', '218713', '225171',
        '225171', '225171', '225171', '227376', '227376', '227988', '227988', '232150', '244392', '249381', '250548',
        '256171', '260353', '261893', '271667', '271667', '272656', '272656', '272668', '272668', '273839', '273839',
        '273839', '274248', '275533', '282942', '286119', '287089', '289538', '297946', '297946', '400720', '400862',
        '436040', '436095', '436096', '436181', '436182', '436188', '436195', '436201', '436218', '436281', '436284',
        '436288', '436288', '436288', '436288', '436288', '443788', '443789', '446608', '448106', '448393', '448504',
        '450881', '451231', '453593', '472634', '472635', '472656', '472662', '473056', '473233', '473386', '473386',
        '473959', '474018', '475472', '475475', '476156', '476156', '476156', '476250', '476250', '476251', '476251',
        '476251', '476252', '476252', '476449', '501022', '545052', '545053', '545240', '545593', '548589', '550269',
        '550666', '550666', '550666', '550677', '551004', '551992', '551993', '551994', '552910', '554116', '556951',
        '556951', '557280', '559203', '559643', '559645', '559647', '559648', '559648', '559649', '559649', '559823',
        '560739', '561019', '561116', '561693', '562143', '562197', '562479', '562613', '562788', '562832', '563023',
        '564079', '564079', '565196', '565196', '567329', '567329', '567329', '567464', '569211', '569475', '569475',
        '570239', '570438', '570438', '570438', '571588', '571588', '573638', '575557', '575807', '575951', '576274',
        '576274', '577035', '577416', '577416', '578846', '578847', '578848', '579118', '579118', '579118', '579118',
        '579118', '579118', '579118', '579118', '579118', '579118', '579118', '579128', '579128', '579128', '579128',
        '579128', '579128', '579128', '579128', '579128', '579128', '579128', '579747', '579747', '581329', '586755',
        '587224', '587381', '587722', '587722', '590583', '590583', '590918', '591994', '592851', '593676', '594797',
        '595013', '595072', '595072', '595599', '595807', '595808',
    }


class AnalgesicOrAntipyreticNonNarcoticAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Analgesic or Antipyretic Non-Narcotic and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152758', '154691', '154729', '154729', '154729', '154729', '155771', '157804', '158362', '158362', '158362',
        '159388', '160401', '160401', '160929', '160929', '160929', '165458', '166662', '167161', '167261', '168008',
        '168008', '168008', '168008', '169647', '171848', '172276', '172276', '175570', '177014', '181418', '181418',
        '181418', '189154', '191006', '192500', '192560', '192560', '193190', '195116', '195116', '195116', '195227',
        '196684', '198770', '198954', '199835', '201982', '201982', '201982', '206813', '206813', '206813', '206813',
        '208653', '211731', '217919', '217919', '217919', '218538', '218713', '225171', '225171', '225171', '225171',
        '227376', '227376', '227988', '227988', '229265', '232150', '240846', '244392', '249381', '250548', '256171',
        '260353', '261893', '271667', '271667', '272656', '272656', '272668', '272668', '273839', '273839', '273839',
        '274248', '275533', '282942', '284790', '284977', '286119', '287089', '288226', '289538', '292627', '297946',
        '297946', '400720', '400862', '436040', '436095', '436096', '436181', '436182', '436188', '436195', '436201',
        '436218', '436281', '436284', '436288', '436288', '436288', '436288', '436288', '436347', '436480', '436480',
        '436487', '443788', '443789', '446608', '448106', '448393', '448504', '449505', '449505', '450881', '451231',
        '453593', '472634', '472635', '472656', '472662', '473056', '473233', '473386', '473386', '473959', '474018',
        '475472', '475475', '476156', '476156', '476156', '476250', '476250', '476251', '476251', '476251', '476252',
        '476252', '476449', '501022', '545052', '545053', '545240', '545593', '545648', '548589', '550269', '550666',
        '550666', '550666', '550677', '551004', '551992', '551993', '551994', '552035', '552238', '552910', '554116',
        '556951', '556951', '557280', '559203', '559643', '559645', '559647', '559648', '559648', '559649', '559649',
        '559823', '560739', '561019', '561116', '561343', '561693', '562143', '562197', '562311', '562479', '562613',
        '562788', '562832', '563023', '564079', '564079', '564164', '565196', '565196', '567329', '567329', '567329',
        '567464', '569211', '569475', '569475', '570239', '570438', '570438', '570438', '571297', '571588', '571588',
        '572882', '573186', '573638', '575557', '575807', '575951', '576274', '576274', '577035', '577416', '577416',
        '578846', '578847', '578848', '579118', '579118', '579118', '579118', '579118', '579118', '579118', '579118',
        '579118', '579118', '579118', '579128', '579128', '579128', '579128', '579128', '579128', '579128', '579128',
        '579128', '579128', '579128', '579153', '579261', '579747', '579747', '580707', '580710', '581329', '581906',
        '585699', '585844', '586755', '587224', '587381', '587722', '587722', '589340', '589502', '590583', '590583',
        '590918', '591994', '592851', '593676', '594321', '594503', '594780', '594797', '595013', '595072', '595072',
        '595599', '595807', '595808',
    }


class AnalgesicOrAntipyreticNonNarcoticSedativeCombinations(ValueSet):
    VALUE_SET_NAME = 'Analgesic or Antipyretic Non-Narcotic/Sedative Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157804', '189154', '196684', '198770', '199835', '208653', '229265', '284977', '288226', '292627', '436480',
        '436480', '436487', '449505', '449505', '561343', '562311', '564164', '571297', '579153', '579261', '580707',
        '580710', '581906', '585699', '585844', '589340', '589502', '594321', '594503', '594780',
    }


class AnalgesicOrAntipyreticNonNarcoticAnticholinergicCombinations(ValueSet):
    VALUE_SET_NAME = 'Analgesic or Antipyretic Non-Narcotic-Anticholinergic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AnalgesicsNarcotic(ValueSet):
    VALUE_SET_NAME = 'Analgesics - Narcotic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150370', '150370', '152381', '152381', '152664', '153957', '154407', '156036', '156210', '156812', '158036',
        '158221', '158553', '158553', '162363', '162540', '163736', '164460', '164610', '165455', '166804', '166819',
        '167704', '169106', '170425', '171547', '171547', '171547', '171547', '171654', '172838', '173765', '174110',
        '175292', '175398', '175398', '175712', '175743', '175743', '175743', '178036', '179917', '180056', '181370',
        '183758', '183803', '189389', '190226', '190526', '191019', '195608', '195608', '195608', '196156', '197034',
        '198148', '198698', '198930', '200476', '200476', '200476', '200615', '204032', '204046', '204827', '204855',
        '204978', '205640', '206268', '206325', '206872', '206872', '206872', '208615', '209431', '209467', '209480',
        '210158', '211183', '211994', '212593', '214203', '214897', '215483', '215483', '215641', '215791', '217316',
        '218930', '222345', '223529', '224210', '224233', '225495', '226400', '226400', '226805', '227354', '227416',
        '227416', '227449', '227449', '227449', '227616', '229129', '229182', '229296', '229344', '229344', '229397',
        '229786', '231407', '231413', '231413', '231898', '234092', '234103', '234103', '234103', '234816', '235596',
        '235899', '235899', '236513', '237166', '237428', '239178', '241783', '243992', '244160', '244444', '246098',
        '246098', '246098', '246480', '249525', '249787', '251512', '252556', '254768', '256654', '257805', '257805',
        '257805', '261994', '263554', '265818', '266520', '266673', '267180', '267200', '270128', '270777', '271337',
        '271337', '271337', '271337', '271534', '272352', '272950', '273536', '275706', '275976', '276911', '277261',
        '277733', '277776', '278499', '278748', '279376', '279574', '279574', '280743', '282127', '282152', '282152',
        '282435', '282842', '284088', '284189', '284301', '284694', '284775', '285163', '285837', '285837', '289905',
        '293675', '293675', '293675', '295333', '297020', '297113', '297113', '297113', '298962', '299079', '299588',
        '400050', '400249', '400871', '400871', '400871', '401054', '401055', '401056', '401057', '401108', '401109',
        '401110', '401111', '443641', '443660', '444369', '444566', '444566', '445149', '445609', '445611', '445632',
        '445633', '445634', '445636', '445686', '446738', '446738', '446738', '446740', '446741', '446741', '446742',
        '449887', '449887', '449889', '449889', '449890', '449890', '449890', '449891', '449891', '449891', '449892',
        '449893', '449894', '449895', '449896', '449897', '449897', '449897', '449898', '449899', '449954', '449962',
        '452958', '452959', '454299', '454299', '454300', '467963', '467964', '469644', '469645', '470772', '470781',
        '472067', '472067', '472068', '472069', '472069', '472069', '472071', '472073', '472074', '472075', '472075',
        '472076', '472087', '472088', '472089', '472089', '472090', '472091', '472092', '472093', '472094', '472094',
        '472095', '472097', '472112', '472384', '472385', '472386', '472387', '472388', '472389', '472620', '473431',
        '474106', '474113', '474313', '474313', '474747', '474753', '474754', '474754', '474761', '474762', '474762',
        '474763', '474763', '474763', '474763', '474764', '474766', '474767', '474768', '474769', '474770', '474771',
        '474772', '474805', '474805', '474805', '474806', '474806', '474806', '474807', '474808', '474809', '474810',
        '474811', '474847', '474848', '474849', '474850', '474851', '474852', '474853', '475263', '475263', '475264',
        '475265', '475266', '475267', '475271', '475272', '475274', '475275', '475275', '475276', '475483', '475484',
        '475485', '475486', '475487', '475495', '475497', '475498', '475501', '475503', '475618', '475792', '476215',
        '476217', '476218', '476221', '476222', '476223', '476332', '476345', '476728', '476785', '476787', '545151',
        '545154', '545244', '545245', '545246', '545437', '545716', '545717', '545721', '545722', '545723', '545724',
        '545726', '545727', '546700', '546701', '546702', '546703', '546705', '546959', '546960', '546961', '546962',
        '546963', '547672', '547722', '547723', '547792', '548174', '548175', '548176', '549196', '549197', '549199',
        '549200', '549201', '549202', '549203', '549204', '549210', '549211', '549212', '549213', '549219', '549220',
        '549222', '549223', '549227', '550062', '550078', '550165', '550570', '550581', '550706', '550733', '551067',
        '551570', '551570', '551570', '551570', '551570', '551595', '552185', '552186', '552187', '552208', '552223',
        '552428', '552437', '553390', '554201', '554208', '554209', '554375', '554376', '554583', '554584', '554585',
        '555199', '555200', '555754', '555911', '556052', '556983', '556984', '556988', '556989', '557000', '557114',
        '557158', '557159', '557167', '557168', '557196', '557197', '557259', '557336', '557337', '557338', '557393',
        '557394', '557662', '557663', '557664', '557780', '557825', '557826', '557827', '557961', '558245', '558587',
        '558588', '558589', '558590', '558591', '558595', '558602', '558933', '558934', '559278', '559413', '559414',
        '559415', '559465', '559851', '559987', '560114', '560115', '560116', '560401', '560432', '560514', '560515',
        '560516', '560517', '560578', '560683', '560784', '560784', '560785', '560799', '560874', '560875', '560877',
        '560884', '560885', '560886', '560931', '560979', '560979', '561106', '561108', '561111', '561492', '561494',
        '561551', '561564', '561828', '561843', '561959', '561987', '562037', '562041', '562051', '562054', '562055',
        '562068', '562637', '562744', '562745', '562746', '562983', '562984', '562985', '563069', '563070', '563071',
        '563072', '563073', '563074', '563141', '563157', '563263', '563264', '563265', '563266', '563267', '563513',
        '564349', '564398', '564555', '564559', '565137', '565188', '565226', '565261', '565540', '565564', '565575',
        '565827', '565922', '565923', '565924', '565942', '565943', '565944', '566012', '566015', '566067', '566068',
        '566069', '566070', '566071', '566074', '566075', '566077', '566078', '566079', '566192', '566786', '566892',
        '566893', '566896', '566897', '566902', '566907', '567161', '567244', '568371', '569259', '569840', '569841',
        '569842', '569843', '569844', '570048', '570082', '570084', '570087', '570092', '570095', '570132', '570138',
        '570356', '570357', '570358', '570420', '570424', '570914', '570962', '571141', '571142', '571155', '571156',
        '571483', '571488', '571694', '571695', '571696', '571696', '572145', '572146', '572174', '572367', '572433',
        '572579', '572660', '573548', '573918', '573918', '574830', '574831', '574923', '574929', '575074', '575301',
        '575327', '575328', '575329', '575330', '575345', '575353', '575354', '575355', '575371', '575371', '575420',
        '575448', '575715', '575861', '575899', '575901', '575901', '576094', '576227', '576228', '576264', '576265',
        '576463', '576464', '576465', '576466', '576467', '576648', '576651', '576652', '576653', '576654', '576968',
        '576979', '578600', '579001', '579002', '579265', '579267', '579753', '579764', '580086', '580165', '580166',
        '580167', '580168', '580169', '580170', '580776', '580777', '580778', '580779', '580780', '580781', '581056',
        '581057', '581093', '581123', '581351', '581353', '581396', '581397', '581398', '581607', '581742', '582000',
        '582276', '582467', '582561', '582670', '582671', '582672', '582673', '582674', '582675', '582676', '582838',
        '582839', '582952', '582953', '582954', '582955', '582956', '582957', '582958', '583307', '583336', '583337',
        '583338', '583339', '583340', '583341', '583342', '583351', '583361', '583362', '583363', '583364', '583365',
        '583366', '583367', '583585', '583586', '583587', '583588', '583589', '583590', '583591', '583592', '583593',
        '583594', '583595', '583596', '584131', '584132', '584143', '584378', '584387', '584388', '584389', '584390',
        '584391', '584475', '584476', '584477', '584478', '584479', '584480', '585970', '587328', '587331', '587653',
        '587655', '587921', '587924', '587925', '587926', '587938', '587939', '587940', '587941', '588084', '588085',
        '588086', '588087', '588088', '588089', '588090', '588148', '588149', '588150', '588151', '588152', '588153',
        '588154', '588182', '588201', '589140', '589724', '589932', '590098', '590157', '590262', '590317', '590381',
        '590428', '590483', '590484', '590485', '590486', '590487', '590490', '590491', '590492', '590493', '590494',
        '590506', '590844', '590848', '590850', '590884', '590888', '590927', '590988', '590989', '591003', '591132',
        '591189', '591831', '591832', '591833', '591875', '592821', '592822', '592823', '592842', '592843', '592844',
        '593002', '593024', '593025', '593182', '593183', '593184', '593306', '593396', '593413', '593433', '593436',
        '593473', '593502', '593586', '593615', '593656', '593661', '593765', '593812', '593814', '593832', '594103',
        '594499', '594500', '594527', '594894', '594924', '594967', '594968', '594981', '594986', '595098', '595107',
        '595132', '595354', '595355', '595537', '595544', '595625',
    }


class AnalgesicNarcoticAgonists(ValueSet):
    VALUE_SET_NAME = 'Analgesic Narcotic Agonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152381', '152381', '153957', '154407', '156036', '158221', '158553', '158553', '162363', '162540', '163736',
        '164460', '164610', '165455', '166819', '169106', '170425', '171547', '171547', '171547', '171547', '171654',
        '172838', '174110', '175292', '175712', '175743', '175743', '175743', '179917', '180056', '181370', '183758',
        '183803', '189389', '190226', '190526', '191019', '195608', '195608', '195608', '196156', '197034', '198148',
        '198930', '200476', '200476', '200476', '204827', '206268', '206325', '206872', '206872', '206872', '208615',
        '209431', '209467', '210158', '211183', '211994', '212593', '214203', '214897', '215483', '215483', '215641',
        '215791', '217316', '222345', '224210', '224233', '225495', '226400', '226400', '226805', '227354', '227416',
        '227416', '227449', '227449', '227449', '229296', '229344', '229344', '229397', '231407', '231413', '231413',
        '231898', '234092', '235596', '236513', '237166', '239178', '241783', '243992', '244160', '246098', '246098',
        '246098', '246480', '249525', '249787', '251512', '252556', '254768', '256654', '257805', '257805', '257805',
        '261994', '263554', '265818', '267180', '267200', '271337', '271337', '271337', '271337', '271534', '272352',
        '272950', '273536', '275976', '276911', '277261', '277776', '278748', '279376', '282435', '282842', '284088',
        '284189', '284301', '284694', '285163', '285837', '285837', '289905', '293675', '293675', '293675', '295333',
        '297020', '297113', '297113', '297113', '298962', '299079', '299588', '400871', '400871', '400871', '401054',
        '401055', '401056', '401057', '401108', '401109', '401110', '401111', '443641', '444369', '444566', '444566',
        '445149', '445609', '445611', '445632', '445633', '445634', '445636', '445686', '449954', '449962', '467963',
        '467964', '472073', '472074', '472091', '472092', '472093', '472094', '472094', '472095', '472097', '472384',
        '472385', '472386', '472387', '472388', '472389', '474106', '474113', '474753', '474766', '474767', '474768',
        '474769', '474770', '474771', '474772', '474847', '474848', '474849', '474850', '474851', '474852', '474853',
        '475263', '475263', '475264', '475265', '475266', '475267', '475271', '475272', '475274', '475275', '475275',
        '475276', '475483', '475484', '475485', '475486', '475487', '475495', '475497', '475498', '475501', '475503',
        '475618', '475792', '476215', '476217', '476218', '476221', '476222', '476223', '476728', '545437', '545716',
        '545717', '545721', '545722', '545723', '545724', '545726', '545727', '546700', '546701', '546702', '546703',
        '546705', '546959', '546960', '546961', '546962', '546963', '547672', '547722', '547723', '547792', '548174',
        '548175', '548176', '549197', '549199', '549200', '549201', '549202', '549203', '549204', '549210', '549211',
        '549212', '549213', '549219', '549220', '549222', '549223', '550062', '550078', '550581', '550733', '551067',
        '551570', '551570', '551570', '551570', '551570', '552185', '552186', '552187', '552208', '552428', '552437',
        '553390', '554375', '554376', '554583', '554584', '554585', '555199', '555200', '556983', '556984', '556988',
        '556989', '557000', '557158', '557159', '557167', '557168', '557336', '557337', '557338', '557393', '557394',
        '557662', '557663', '557825', '557826', '557827', '558245', '558587', '558588', '558589', '558590', '558591',
        '558595', '558602', '559413', '559414', '559415', '559465', '559851', '559987', '560114', '560115', '560116',
        '560432', '560517', '560578', '560683', '560784', '560784', '560785', '560799', '560874', '560875', '560877',
        '560884', '560885', '560886', '560931', '561108', '561492', '561494', '561551', '561564', '561828', '561843',
        '561959', '561987', '562037', '562041', '562051', '562054', '562055', '563069', '563070', '563071', '563072',
        '563073', '563074', '563141', '563157', '563263', '563264', '563265', '563266', '563267', '564349', '564398',
        '564555', '564559', '565188', '565226', '565261', '565540', '565564', '565827', '565922', '565923', '565924',
        '565942', '565943', '565944', '566012', '566015', '566067', '566068', '566069', '566070', '566071', '566074',
        '566075', '566077', '566078', '566079', '566192', '566786', '566892', '566893', '566896', '566897', '566902',
        '566907', '567161', '568371', '569259', '569840', '569841', '569842', '569843', '569844', '570048', '570082',
        '570084', '570087', '570092', '570095', '570132', '570138', '570356', '570357', '570358', '570424', '570914',
        '570962', '571141', '571142', '571155', '571156', '571483', '571488', '571694', '571695', '571696', '571696',
        '572145', '572146', '572174', '572367', '572433', '572579', '573548', '573918', '573918', '574830', '574831',
        '574923', '574929', '575074', '575301', '575327', '575328', '575329', '575330', '575345', '575371', '575371',
        '575420', '575448', '575715', '576094', '576227', '576228', '576264', '576265', '576463', '576464', '576465',
        '576466', '576467', '576648', '576651', '576652', '576653', '576654', '576968', '576979', '578600', '579001',
        '579002', '580165', '580166', '580167', '580168', '580169', '580170', '580776', '580777', '580778', '580779',
        '580780', '580781', '581056', '581057', '582670', '582671', '582672', '582673', '582674', '582675', '582676',
        '582838', '582839', '582952', '582953', '582954', '582955', '582956', '582957', '582958', '583336', '583337',
        '583338', '583339', '583340', '583341', '583342', '583361', '583362', '583363', '583364', '583365', '583366',
        '583367', '583585', '583586', '583587', '583588', '583589', '583590', '583591', '583592', '583593', '583594',
        '583595', '583596', '584131', '584132', '584143', '584378', '584387', '584388', '584389', '584390', '584391',
        '584475', '584476', '584477', '584478', '584479', '584480', '585970', '587328', '587331', '587653', '587655',
        '587921', '587924', '587925', '587926', '587938', '587939', '587940', '587941', '588201', '589140', '589724',
        '589932', '590098', '590262', '590317', '590381', '590428', '590483', '590484', '590485', '590486', '590487',
        '590490', '590491', '590492', '590493', '590494', '590506', '590844', '590848', '590850', '590884', '590888',
        '590927', '590988', '590989', '591132', '591189', '591831', '591832', '591833', '591875', '592821', '592822',
        '592823', '592842', '592843', '592844', '593002', '593024', '593025', '593182', '593183', '593184', '593306',
        '593396', '593436', '593586', '593615', '593656', '593661', '593765', '593812', '593832', '594499', '594500',
        '594527', '594894', '594924', '594967', '594968', '594981', '594986', '595098', '595107', '595132', '595354',
        '595355', '595544', '595625',
    }


class AnalgesicNarcoticPartialMixedAgonists(ValueSet):
    VALUE_SET_NAME = 'Analgesic Narcotic Partial-Mixed Agonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150370', '150370', '152664', '209480', '234103', '234103', '234103', '234816', '235899', '235899', '279574',
        '279574', '280743', '282152', '282152', '443660', '474313', '474313', '562744', '562745', '562746', '562983',
        '562984', '562985', '579753', '579764', '582276', '582561', '588084', '588085', '588086', '588087', '588088',
        '588089', '588090', '588148', '588149', '588150', '588151', '588152', '588153', '588154',
    }


class OpiateNarcoticReversalAgentsOpiateAntagonists(ValueSet):
    VALUE_SET_NAME = 'Opiate/Narcotic Reversal Agents - Opiate Antagonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '179664', '179664', '182394', '445691', '445692', '555089', '555110', '556008', '556039', '570137', '570142',
        '570146', '570147', '581264', '581586', '583665', '583666', '583666', '583828', '583829', '583829', '588517',
        '588530', '591282', '591323', '592146', '592504', '592949', '592949', '593332', '593611', '593611', '594529',
    }


class AnalgesicNarcoticPartialMixedAgonistCombinations(ValueSet):
    VALUE_SET_NAME = 'Analgesic Narcotic Partial-Mixed Agonist Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AnalgesicNarcoticCodeineCombinations(ValueSet):
    VALUE_SET_NAME = 'Analgesic Narcotic Codeine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156210', '175398', '175398', '198698', '200615', '204046', '223529', '229182', '229786', '244444', '266520',
        '275706', '400050', '400249', '551595', '575861', '575899', '575901', '575901', '579265', '579267',
    }


class AnalgesicNarcoticDihydrocodeineCombinations(ValueSet):
    VALUE_SET_NAME = 'Analgesic Narcotic Dihydrocodeine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '550165', '550706', '583307', '583351', '593433', '595537',
    }


class AnalgesicNarcoticHydrocodoneCombinations(ValueSet):
    VALUE_SET_NAME = 'Analgesic Narcotic Hydrocodone Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156812', '167704', '178036', '204978', '237428', '270128', '278499', '284775', '454299', '454299', '454300',
        '469644', '469645', '470772', '470781', '476332', '476345', '476785', '476787', '554201', '554208', '554209',
        '555754', '555911', '557114', '557196', '557197', '557259', '562637', '572660', '575353', '575354', '575355',
        '580086', '581351', '581353', '581396', '581397', '581398', '581607', '582000', '582467',
    }


class AnalgesicNarcoticPropoxypheneCombinations(ValueSet):
    VALUE_SET_NAME = 'Analgesic Narcotic Propoxyphene Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AnalgesicNarcoticMeperidineCombinations(ValueSet):
    VALUE_SET_NAME = 'Analgesic Narcotic Meperidine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AnalgesicNarcoticPentazocineCombinations(ValueSet):
    VALUE_SET_NAME = 'Analgesic Narcotic Pentazocine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class NsaidAnalgesics(ValueSet):
    VALUE_SET_NAME = 'NSAID Analgesics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150636', '151023', '151116', '151116', '151348', '152763', '154374', '155241', '157574', '158535', '161789',
        '163355', '163355', '163709', '164141', '166467', '167222', '167815', '169047', '170807', '172331', '173420',
        '174189', '178017', '182198', '182198', '182478', '191515', '193042', '196127', '198251', '198251', '202198',
        '202602', '202602', '204491', '205316', '205957', '208371', '212784', '213119', '214238', '215697', '216915',
        '216915', '217972', '222191', '224295', '228043', '228278', '231235', '231636', '234997', '237273', '237650',
        '237650', '237650', '237650', '237919', '239170', '240035', '240146', '240856', '242088', '244817', '245921',
        '246191', '246191', '246321', '249180', '249524', '249746', '250621', '252217', '252891', '254960', '255796',
        '256217', '256217', '256217', '256217', '256461', '256812', '257396', '259181', '259181', '260635', '261620',
        '263280', '263280', '264771', '265498', '265665', '266721', '269923', '273242', '275304', '275877', '278995',
        '278995', '278995', '278995', '280256', '280631', '281309', '281639', '281792', '284316', '286283', '286640',
        '286843', '286862', '289798', '290029', '290824', '291838', '292728', '293894', '293894', '297151', '298404',
        '298739', '299282', '436725', '436725', '436726', '436726', '436727', '436727', '443591', '444351', '444351',
        '444358', '444366', '445980', '446086', '446812', '449511', '449511', '449511', '468425', '471498', '472085',
        '472123', '472398', '472399', '472401', '473458', '474040', '475951', '475956', '548778', '549094', '549137',
        '550378', '550378', '550412', '550412', '550729', '555663', '555679', '556226', '556254', '557049', '557055',
        '557111', '557123', '557264', '558206', '558772', '558772', '558866', '558876', '558901', '558908', '559691',
        '559700', '559714', '559715', '560001', '560007', '560614', '560698', '561208', '561220', '561221', '561225',
        '561226', '562118', '562144', '562666', '564055', '564244', '564244', '564246', '564246', '566746', '566749',
        '571914', '575931', '580147', '580148', '580150', '580151', '581894', '583509', '583542', '583566', '585484',
        '585485', '585491', '585492', '586832', '587273', '587332', '588218', '588231', '588264', '588323', '588456',
        '588457', '588469', '588470', '588563', '589009', '590102', '590149', '590319', '590319', '590340', '590340',
        '590461', '590461', '590482', '590482', '590911', '590912', '590934', '591161', '591743', '591759', '591895',
        '592174', '592246', '592446', '592494', '594812', '595910',
    }


class NsaidAnalgesicsAndNsaidCombinations(ValueSet):
    VALUE_SET_NAME = 'NSAID Analgesics and NSAID Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150636', '151023', '151348', '152763', '154374', '155241', '157574', '158535', '161789', '163355', '163355',
        '163709', '164141', '166467', '167222', '167815', '169047', '170807', '172331', '173420', '174189', '178017',
        '182198', '182198', '182478', '191515', '193042', '196127', '198251', '198251', '202198', '202602', '202602',
        '204491', '205316', '205957', '208371', '212784', '213119', '214238', '216915', '216915', '217972', '224295',
        '228043', '228278', '231235', '231636', '234997', '237273', '237650', '237650', '237650', '237650', '237919',
        '239170', '240035', '240146', '240856', '242088', '244817', '245921', '246191', '246191', '246321', '249180',
        '249524', '249746', '250621', '252217', '252891', '254960', '255796', '256217', '256217', '256217', '256217',
        '256461', '256812', '257396', '259181', '259181', '260635', '261620', '263280', '263280', '264771', '265498',
        '265665', '266721', '269923', '273242', '275304', '275877', '278995', '278995', '278995', '278995', '280256',
        '280631', '281309', '281639', '284316', '286283', '286640', '286843', '286862', '289798', '290029', '290824',
        '291838', '292728', '293894', '293894', '297151', '298404', '298739', '299282', '436725', '436725', '436726',
        '436726', '436727', '436727', '443591', '444351', '444351', '444358', '444366', '445980', '449511', '449511',
        '449511', '468425', '471498', '472085', '472123', '472398', '472399', '472401', '473458', '474040', '475951',
        '475956', '549137', '550378', '550378', '550412', '550412', '550729', '555663', '555679', '556226', '556254',
        '557049', '557055', '557111', '557123', '557264', '558206', '558772', '558772', '558866', '558876', '558901',
        '558908', '559691', '559700', '559714', '559715', '560001', '560007', '560614', '560698', '561208', '561220',
        '561221', '561225', '561226', '562118', '562144', '562666', '564055', '564244', '564244', '564246', '564246',
        '566746', '566749', '571914', '575931', '580147', '580148', '580150', '580151', '581894', '583509', '583542',
        '583566', '585484', '585485', '585491', '585492', '586832', '587273', '587332', '588218', '588231', '588264',
        '588323', '588456', '588457', '588469', '588470', '588563', '589009', '590102', '590149', '590911', '590912',
        '590934', '591161', '591743', '591759', '591895', '592174', '592246', '592446', '592494', '594812', '595910',
    }


class DmardGoldCompounds(ValueSet):
    VALUE_SET_NAME = 'DMARD - Gold Compounds'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '189993', '252407',
    }


class DmardAntimetabolites(ValueSet):
    VALUE_SET_NAME = 'DMARD - Antimetabolites'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '237786', '237786', '237786', '237786', '237786', '446625', '446625', '446625', '446625', '446625', '580062',
        '580063', '580064', '580065', '580504', '580505', '580506', '580507', '582106', '582107', '582108', '582109',
        '582110', '582111', '582112', '582113', '582114', '582343', '582344', '582346', '582348', '582349', '582350',
        '582351', '582365', '582366', '582367', '587203', '587219', '590141', '590142', '590144', '590146', '591120',
        '591129',
    }


class DmardPyrimidineSynthesisInhibitors(ValueSet):
    VALUE_SET_NAME = 'DMARD - Pyrimidine Synthesis Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156467', '196631', '206060', '211068',
    }


class DmardAntiInflammatoryTumorNecrosisFactorInhibitingAgents(ValueSet):
    VALUE_SET_NAME = 'DMARD - Anti-inflammatory Tumor Necrosis Factor Inhibiting Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '196211', '273372', '448214', '448214', '448214', '448215', '472027', '472035', '545909', '545922', '545922',
        '545922', '548533', '548882', '550079', '550720', '550723', '554440', '554452', '554843', '554844', '557680',
        '558089', '558091', '558097', '558098', '558312', '558312', '558316', '561420', '578586', '578589', '579240',
        '579314', '579322', '579329', '582855', '582857', '582875', '582875', '594552', '594596',
    }


class MigraineTherapy(ValueSet):
    VALUE_SET_NAME = 'Migraine Therapy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150340', '165975', '171743', '171743', '171743', '177730', '177730', '177761', '178705', '179035', '180527',
        '181378', '182981', '182981', '183124', '184740', '185452', '185452', '185452', '185452', '186901', '187042',
        '190589', '190740', '192084', '192686', '192686', '192686', '192686', '192686', '193747', '193747', '196597',
        '197937', '200907', '201054', '202634', '205742', '206438', '207488', '207488', '214702', '220644', '220644',
        '221329', '221818', '222336', '235626', '235626', '235626', '237858', '242202', '246147', '256009', '259144',
        '261300', '272680', '279616', '281494', '281494', '281494', '285665', '288483', '288483', '288928', '288928',
        '297717', '297717', '297717', '297717', '298865', '298998', '400631', '400631', '436747', '436766', '436779',
        '448257', '448258', '448258', '448258', '448259', '448260', '448260', '448260', '452612', '452613', '476709',
        '476709', '476709', '476710', '476714', '476715', '554819', '554822', '560100', '560105', '560774', '561216',
        '563655', '563756', '576764', '580364', '580373', '580587', '580638', '582762', '582768', '587109', '589310',
        '589362', '589841', '589847', '590588', '590595', '591903', '591965',
    }


class MigraineTherapySerotonin5HtReceptorAntagonists(ValueSet):
    VALUE_SET_NAME = 'Migraine Therapy - Serotonin (5-HT) Receptor Antagonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MigraineTherapyOther(ValueSet):
    VALUE_SET_NAME = 'Migraine Therapy Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MigraineTherapyAnalgesicVasoconstrictors(ValueSet):
    VALUE_SET_NAME = 'Migraine Therapy - Analgesic-Vasoconstrictors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '580587', '580638',
    }


class MigraineTherapyErgotCombinations(ValueSet):
    VALUE_SET_NAME = 'Migraine Therapy - Ergot Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '180527', '181378', '436766', '436779',
    }


class GoutAndHyperuricemiaTherapy(ValueSet):
    VALUE_SET_NAME = 'Gout and Hyperuricemia Therapy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '172216', '178671', '189536', '203487', '266145', '280221', '288925', '298798', '299865', '446038', '446048',
        '545784', '545971', '557389', '557391', '557395', '557396', '559025', '562167', '562769', '582743', '582746',
        '588783', '588803', '594275', '594276', '594278', '594279',
    }


class HyperuricemiaTherapyUricosurics(ValueSet):
    VALUE_SET_NAME = 'Hyperuricemia Therapy - Uricosurics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '298798', '588783', '588803',
    }


class GoutAndHyperuricemiaCombinationDrugs(ValueSet):
    VALUE_SET_NAME = 'Gout and Hyperuricemia Combination Drugs'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '189536',
    }


class LocalAnestheticsParenteral(ValueSet):
    VALUE_SET_NAME = 'Local Anesthetics - Parenteral'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151226', '151226', '152888', '153776', '154129', '155151', '155151', '157566', '157566', '157566', '157566',
        '157732', '157732', '157732', '157732', '158038', '158038', '161337', '161337', '161337', '166218', '166218',
        '168580', '175638', '177228', '177803', '179638', '179638', '179638', '183603', '183928', '187831', '195179',
        '195179', '197191', '200666', '209575', '211658', '211658', '211658', '211658', '211658', '211658', '211658',
        '211658', '211735', '211735', '211735', '211735', '211735', '211735', '211735', '211735', '212934', '212934',
        '212934', '212934', '214487', '214487', '214487', '214487', '219604', '219604', '219604', '219604', '219987',
        '220599', '221444', '224073', '231094', '231094', '232633', '232930', '235242', '238126', '240369', '241006',
        '245319', '245585', '246780', '248740', '248740', '249003', '249003', '249003', '249118', '252262', '258903',
        '258903', '258903', '260229', '260229', '260229', '263393', '263393', '263393', '263451', '263451', '265851',
        '265851', '265851', '265851', '265851', '265851', '268149', '268149', '268149', '268149', '268915', '270295',
        '270295', '270295', '270295', '280347', '280347', '280347', '280347', '280562', '281793', '283616', '283616',
        '283616', '283918', '284673', '284673', '284673', '293166', '293166', '436852', '445765', '449874', '449874',
        '449875', '449876', '449876', '449877', '449877', '449877', '449877', '449878', '449878', '449878', '449878',
        '449879', '449879', '449879', '449879', '449880', '449881', '449881', '449882', '449882', '449882', '449882',
        '449882', '449883', '449883', '449883', '449883', '449883', '449884', '451742', '451742', '451743', '451743',
        '451744', '451744', '451745', '451745', '451746', '451746', '468130', '468131', '472065', '472065', '472065',
        '472066', '472066', '472066', '472072', '472072', '474748', '474748', '474749', '474749', '474750', '474750',
        '474750', '474750', '474750', '474750', '474751', '474752', '474802', '474803', '474846', '545225', '545226',
        '545226', '545227', '545227', '545227', '545227', '545227', '545227', '545228', '545228', '545228', '545228',
        '545229', '545230', '545237', '545906', '545906', '552499', '554153', '555117', '555120', '555121', '555222',
        '555306', '555307', '555308', '555310', '555312', '557321', '557322', '557323', '557325', '558246', '558613',
        '558814', '558815', '559130', '559242', '559297', '559447', '559448', '559449', '559450', '559451', '559521',
        '559562', '559584', '559585', '559602', '559603', '559788', '560701', '560802', '560869', '560978', '561991',
        '561991', '562008', '562015', '562303', '562317', '562330', '562340', '563489', '563500', '563580', '563581',
        '563582', '563599', '563604', '563605', '563619', '563641', '563656', '563748', '564042', '564087', '564205',
        '564208', '564251', '564523', '564556', '564565', '565365', '565579', '565579', '565579', '565579', '565579',
        '565592', '565592', '565592', '565592', '565592', '566028', '566055', '566056', '566451', '566751', '566948',
        '567101', '567833', '567833', '568560', '568634', '568634', '568670', '569132', '569960', '570396', '570455',
        '570587', '570630', '570896', '571352', '571565', '571566', '572652', '572653', '572654', '573258', '573836',
        '574023', '574064', '575310', '588174', '588247', '588287', '589896', '589954', '589980', '589989', '590049',
        '590194', '590446', '591209', '591254', '591276', '591356', '591458', '591458', '591460', '591873', '592445',
        '592447', '592495', '592496', '593698', '593775', '593868', '593905', '593940', '594039', '594055', '594071',
        '594083', '594083', '594084', '594133', '594155', '594156', '594358', '594502', '594602', '595021', '595034',
        '595040', '595198', '595532', '595560', '595601', '595622', '595652',
    }


class LocalAnestheticAmides(ValueSet):
    VALUE_SET_NAME = 'Local Anesthetic - Amides'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153776', '155151', '155151', '157566', '157566', '157566', '157566', '157732', '157732', '157732', '157732',
        '177228', '177803', '179638', '179638', '179638', '183928', '200666', '209575', '211658', '211658', '211658',
        '211658', '211658', '211658', '211658', '211658', '211735', '211735', '211735', '211735', '211735', '211735',
        '211735', '211735', '212934', '212934', '212934', '212934', '214487', '214487', '214487', '214487', '219987',
        '221444', '231094', '231094', '232633', '235242', '238126', '241006', '245585', '249003', '249003', '249003',
        '258903', '258903', '258903', '263451', '263451', '265851', '265851', '265851', '265851', '265851', '265851',
        '270295', '270295', '270295', '270295', '280562', '283616', '283616', '283616', '283918', '293166', '293166',
        '436852', '445765', '449877', '449877', '449877', '449877', '449878', '449878', '449878', '449878', '449879',
        '449879', '449879', '449879', '449880', '449881', '449881', '449882', '449882', '449882', '449882', '449882',
        '449883', '449883', '449883', '449883', '449883', '449884', '451742', '451742', '451743', '451743', '451744',
        '451744', '468130', '468131', '472065', '472065', '472065', '472066', '472066', '472066', '472072', '472072',
        '474748', '474748', '474749', '474749', '474750', '474750', '474750', '474750', '474750', '474750', '474751',
        '474752', '474802', '474803', '474846', '545225', '545226', '545226', '545227', '545227', '545227', '545227',
        '545227', '545227', '545228', '545228', '545228', '545228', '545229', '545230', '545237', '545906', '545906',
        '552499', '554153', '555117', '555120', '555121', '555222', '555306', '555307', '555308', '555310', '555312',
        '557321', '557322', '557323', '557325', '558246', '558613', '558814', '558815', '559130', '559242', '559297',
        '559447', '559448', '559449', '559450', '559451', '559521', '559562', '559584', '559585', '559602', '559603',
        '559788', '560701', '560802', '560869', '560978', '561991', '561991', '562008', '562015', '562303', '562317',
        '562330', '563489', '563500', '563580', '563581', '563582', '563599', '563604', '563605', '563619', '563641',
        '563656', '563748', '564042', '564087', '564205', '564208', '564251', '564523', '564556', '564565', '565365',
        '565579', '565579', '565579', '565579', '565579', '565592', '565592', '565592', '565592', '565592', '566028',
        '566055', '566056', '566451', '566751', '566948', '567101', '567833', '567833', '568560', '568634', '568634',
        '568670', '569132', '569960', '570396', '570455', '570587', '570630', '570896', '571352', '571565', '571566',
        '572652', '572653', '572654', '573258', '573836', '574023', '574064', '575310', '588174', '588247', '588287',
        '589896', '589954', '589980', '589989', '590049', '590194', '590446', '591209', '591254', '591276', '591356',
        '591873', '592445', '592447', '592495', '592496', '593698', '593775', '593940', '594039', '594055', '594071',
        '594083', '594083', '594084', '594133', '594155', '594156', '594358', '594502', '594602', '595021', '595034',
        '595040', '595532', '595560', '595601', '595622', '595652',
    }


class LocalAnestheticEsters(ValueSet):
    VALUE_SET_NAME = 'Local Anesthetic - Esters'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154129', '175638', '197191', '224073', '240369', '246780', '249118', '281793', '562340',
    }


class LocalAnestheticCombinations(ValueSet):
    VALUE_SET_NAME = 'Local Anesthetic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151226', '151226', '152888', '158038', '158038', '161337', '161337', '161337', '166218', '166218', '168580',
        '183603', '187831', '195179', '195179', '219604', '219604', '219604', '219604', '220599', '232930', '245319',
        '248740', '248740', '252262', '260229', '260229', '260229', '263393', '263393', '263393', '268149', '268149',
        '268149', '268149', '268915', '280347', '280347', '280347', '280347', '284673', '284673', '284673', '449874',
        '449874', '449875', '449876', '449876', '451745', '451745', '451746', '451746', '591458', '591458', '591460',
        '593868', '593905', '595198',
    }


class LocalAnestheticSympathomimeticCombinations(ValueSet):
    VALUE_SET_NAME = 'Local Anesthetic - Sympathomimetic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151226', '151226', '152888', '158038', '158038', '161337', '161337', '161337', '166218', '166218', '168580',
        '183603', '187831', '195179', '195179', '219604', '219604', '219604', '219604', '220599', '232930', '245319',
        '248740', '248740', '252262', '260229', '260229', '260229', '263393', '263393', '263393', '268149', '268149',
        '268149', '268149', '268915', '280347', '280347', '280347', '280347', '284673', '284673', '284673', '449874',
        '449874', '449875', '449876', '449876', '451745', '451745', '451746', '451746', '591458', '591458', '591460',
        '593868', '593905',
    }


class GeneralAnesthetics(ValueSet):
    VALUE_SET_NAME = 'General Anesthetics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153397', '158590', '167527', '177175', '177677', '182447', '182447', '182447', '182447', '182579', '187382',
        '195005', '195550', '196486', '196486', '196486', '196486', '218185', '218185', '221209', '221577', '224382',
        '224382', '224382', '224382', '224382', '224382', '224536', '225826', '225826', '225826', '225826', '225851',
        '225851', '225851', '225851', '234824', '237229', '237229', '254473', '254593', '254593', '254593', '254593',
        '254593', '254593', '254593', '254593', '257991', '258596', '267253', '276747', '276747', '276747', '276747',
        '277135', '286813', '297974', '297974', '298297', '298297', '299238', '299238', '299238', '444945', '445597',
        '446739', '446739', '446739', '446743', '454416', '454416', '454417', '472098', '550925', '552133', '552134',
        '552134', '557258', '557260', '557324', '557326', '560028', '560029', '561577', '562350', '562350', '563307',
        '563659', '563875', '564700', '564701', '565321', '566085', '567849', '569818', '570855', '570856', '571336',
        '571336', '571501', '573775', '575087', '575579', '575579', '575581', '575581', '580723', '580724', '587918',
        '587918', '588311', '590057', '591145', '592379', '593543', '593877', '593908', '594070', '594274', '594283',
        '594289', '594290', '595565',
    }


class GeneralAnestheticParenteralBarbiturates(ValueSet):
    VALUE_SET_NAME = 'General Anesthetic - Parenteral, Barbiturates'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153397', '182579', '277135', '286813', '564701',
    }


class GeneralAnestheticInhalant(ValueSet):
    VALUE_SET_NAME = 'General Anesthetic - Inhalant'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '177175', '195550', '221209', '237229', '237229', '258596', '297974', '297974', '454416', '454416', '454417',
        '550925', '571336', '571336',
    }


class GeneralAnestheticParenteralPhenolDerivatives(ValueSet):
    VALUE_SET_NAME = 'General Anesthetic - Parenteral, Phenol Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '182447', '182447', '182447', '182447', '276747', '276747', '276747', '276747', '560028', '560029', '563659',
        '563875', '593877', '593908', '594274', '594283', '594289', '594290',
    }


class Anticonvulsants(ValueSet):
    VALUE_SET_NAME = 'Anticonvulsants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151621', '151997', '152738', '153680', '153779', '155629', '155661', '156003', '157747', '158456', '158747',
        '158955', '162323', '163790', '164059', '166111', '168695', '171043', '171268', '171535', '174806', '176050',
        '176363', '179268', '180914', '182367', '182606', '183221', '184458', '187428', '190014', '192149', '192508',
        '193226', '193453', '194527', '195525', '195759', '196133', '197020', '197501', '197564', '199810', '199958',
        '200556', '201116', '203593', '203861', '204735', '204907', '205040', '208775', '209654', '210586', '211249',
        '212787', '213753', '214862', '215344', '216127', '217597', '217947', '223951', '225945', '226726', '227308',
        '228133', '229421', '229530', '229635', '229897', '230699', '234184', '234184', '234184', '234554', '235492',
        '236531', '238817', '241044', '241639', '241639', '242690', '243888', '244002', '244221', '246317', '246372',
        '246373', '249474', '249737', '249779', '250177', '250870', '252714', '254610', '256456', '258007', '258577',
        '258577', '258577', '258949', '261436', '261859', '263010', '263036', '263989', '265247', '265451', '265477',
        '265489', '267729', '268285', '268285', '268412', '268615', '271154', '272392', '274608', '276682', '276819',
        '278614', '278694', '279355', '281942', '282862', '283822', '285534', '285722', '287804', '288972', '290035',
        '290943', '290971', '290971', '292097', '292749', '293341', '293765', '296707', '297065', '297553', '299137',
        '436879', '445693', '446881', '446882', '448083', '449426', '449427', '449428', '449429', '449430', '451640',
        '451640', '451649', '453700', '453701', '453724', '453764', '454519', '454520', '472836', '472837', '472838',
        '472841', '472842', '472843', '472868', '472869', '472870', '474784', '474785', '474786', '474787', '474788',
        '474789', '474790', '474791', '474815', '474816', '474817', '474818', '474819', '474820', '474821', '474822',
        '475230', '475230', '475231', '475231', '475233', '475234', '545074', '545075', '546163', '546175', '553143',
        '554249', '554250', '554395', '554397', '554708', '556258', '556259', '556997', '556998', '557001', '557003',
        '557367', '557539', '557541', '557542', '557543', '557548', '557549', '557550', '557551', '557756', '557762',
        '558017', '558026', '558257', '558257', '558258', '558258', '558259', '558259', '558260', '558260', '558261',
        '558262', '558263', '558274', '558275', '558276', '558277', '558278', '558279', '558280', '558449', '558450',
        '558451', '558452', '558453', '558454', '558455', '558459', '558460', '558461', '558462', '558463', '558464',
        '558465', '559102', '559103', '559124', '559182', '559199', '559292', '559293', '561378', '561378', '561380',
        '561380', '563475', '563484', '563683', '563686', '567900', '567913', '568950', '568982', '568984', '569009',
        '569010', '569017', '569018', '569735', '569736', '569737', '572101', '572102', '572103', '572104', '572106',
        '572107', '572108', '572109', '574415', '574742', '574743', '575000', '575789', '575790', '575791', '576448',
        '576449', '576450', '579365', '579366', '579545', '579545', '579547', '579547', '579548', '579548', '579549',
        '579549', '579553', '579553', '579554', '579554', '579555', '579555', '579556', '579556', '579936', '579945',
        '580485', '580486', '580487', '580488', '580508', '580509', '580510', '580511', '580743', '580744', '580749',
        '580750', '580933', '580934', '580935', '580936', '580942', '580944', '580946', '580947', '581070', '581071',
        '581072', '581073', '581074', '581755', '581756', '581757', '581759', '581760', '589562', '589564', '589575',
        '589576', '589577', '589579', '589580', '589616', '589617', '589618', '589619', '589620', '589621', '589622',
        '589636', '589637', '589638', '589639', '589640', '589641', '589642', '589643', '589837', '589861', '589912',
        '589948', '590161', '590226', '590327', '590551', '590887', '593393', '593394', '595531', '595533',
    }


class AnticonvulsantBarbituratesAndDerivatives(ValueSet):
    VALUE_SET_NAME = 'Anticonvulsant - Barbiturates and Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151997', '153779', '156003', '157747', '171535', '179268', '214862', '223951', '238817', '254610', '258007',
        '261436', '265477', '272392', '296707',
    }


class AnticonvulsantCarbamates(ValueSet):
    VALUE_SET_NAME = 'Anticonvulsant - Carbamates'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151621', '174806', '194527', '204907', '241639', '241639', '258577', '258577', '258577',
    }


class AnticonvulsantGabaModulators(ValueSet):
    VALUE_SET_NAME = 'Anticonvulsant - GABA Modulators'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152738', '158955', '195525', '195759', '197501', '204735', '212787', '225945', '559102', '559103', '559182',
        '559199',
    }


class AnticonvulsantHydantoins(ValueSet):
    VALUE_SET_NAME = 'Anticonvulsant - Hydantoins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '171268', '182606', '193453', '199958', '200556', '209654', '210586', '228133', '234184', '234184', '234184',
        '263010', '279355', '290943', '292749', '293341', '436879', '445693', '553143', '554249', '554250', '554395',
        '554397', '554708', '559124',
    }


class AnticonvulsantOxazolidinediones(ValueSet):
    VALUE_SET_NAME = 'Anticonvulsant - Oxazolidinediones'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AnticonvulsantSuccinimides(ValueSet):
    VALUE_SET_NAME = 'Anticonvulsant - Succinimides'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '166111', '176363', '256456', '282862', '283822', '297065',
    }


class AnticonvulsantCarboxylicAcidDerivatives(ValueSet):
    VALUE_SET_NAME = 'Anticonvulsant - Carboxylic Acid Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '168695', '201116', '203861', '230699', '235492', '243888', '244221', '246317', '249779', '250177', '276682',
        '276819', '287804', '288972', '290035', '293765', '446881', '446882', '568950', '569017', '569018',
    }


class AnticonvulsantOthers(ValueSet):
    VALUE_SET_NAME = 'Anticonvulsant Others'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AnticonvulsantBarbiturateAndHydantoinCombinations(ValueSet):
    VALUE_SET_NAME = 'Anticonvulsant - Barbiturate and Hydantoin Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntiparkinsonTherapy(ValueSet):
    VALUE_SET_NAME = 'Antiparkinson Therapy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150339', '150595', '152772', '154194', '156639', '163299', '163982', '164108', '169093', '170334', '176158',
        '176267', '185449', '186473', '190369', '192774', '195184', '206741', '215224', '218766', '220842', '222445',
        '225961', '230761', '230788', '231244', '231639', '233159', '237790', '240535', '242356', '242549', '250258',
        '251660', '255432', '256375', '257574', '257929', '258364', '261383', '262361', '262361', '263240', '264600',
        '272334', '276280', '276295', '276877', '278301', '281031', '282075', '282352', '286115', '286790', '289952',
        '290868', '298405', '436929', '450965', '450966', '450967', '450980', '450981', '450982', '470618', '470622',
        '471553', '471554', '471555', '545386', '545388', '545487', '545488', '545709', '545713', '550926', '550927',
        '550928', '551454', '551455', '551456', '553020', '553039', '553069', '553073', '555341', '555342', '555343',
        '555353', '555354', '555355', '556561', '556562', '556568', '556569', '556797', '556806', '558072', '558106',
        '560520', '560521', '560522', '560523', '560524', '560527', '560549', '560550', '560551', '560552', '564640',
        '564641', '564650', '564651', '573508', '573509', '573510', '573511', '573512', '573513', '583597', '583598',
        '583599', '583600', '583631', '583632', '583633', '583634', '583870', '583875', '593385', '593386', '593667',
        '593668', '594281', '594282', '594444', '594446',
    }


class AntiparkinsonTherapyAnticholinergicAgents(ValueSet):
    VALUE_SET_NAME = 'Antiparkinson Therapy - Anticholinergic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '163299', '170334', '176267', '251660', '256375', '257574', '262361', '262361', '281031',
    }


class AntiparkinsonAdjuvantComtInhibitors(ValueSet):
    VALUE_SET_NAME = 'Antiparkinson Adjuvant - COMT Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154194', '164108', '220842', '276877',
    }


class AntiparkinsonAdjuvantCentralPeripheralComtInhibitors(ValueSet):
    VALUE_SET_NAME = 'Antiparkinson Adjuvant - Central/Peripheral COMT Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154194', '276877',
    }


class AntiparkinsonAdjuvantPeripheralComtInhibitors(ValueSet):
    VALUE_SET_NAME = 'Antiparkinson Adjuvant - Peripheral COMT Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164108', '220842',
    }


class AntiparkinsonTherapyDopaminergic(ValueSet):
    VALUE_SET_NAME = 'Antiparkinson Therapy - Dopaminergic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150339', '150595', '152772', '163982', '185449', '190369', '192774', '195184', '206741', '215224', '222445',
        '230761', '230788', '231244', '231639', '233159', '237790', '242356', '242549', '255432', '257929', '258364',
        '263240', '276280', '276295', '278301', '282352', '286790', '289952', '290868', '298405', '470618', '470622',
        '550926', '550927', '550928', '551454', '551455', '551456', '553069', '553073', '555341', '555342', '555343',
        '555353', '555354', '555355', '556797', '556806', '558072', '558106', '560520', '560521', '560522', '560523',
        '560524', '560527', '560549', '560550', '560551', '560552', '564640', '564641', '564650', '564651', '573508',
        '573509', '573510', '573511', '573512', '573513', '594281', '594282', '594444', '594446',
    }


class AntiparkinsonTherapyMorphineDerivatives(ValueSet):
    VALUE_SET_NAME = 'Antiparkinson Therapy - Morphine Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntiparkinsonCombinationAgents(ValueSet):
    VALUE_SET_NAME = 'Antiparkinson Combination Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '169093', '176158', '186473', '225961', '250258', '261383', '264600', '272334', '282075', '436929', '450965',
        '450966', '450967', '450980', '450981', '450982', '471553', '471554', '471555', '553020', '553039', '556561',
        '556562', '556568', '556569', '583597', '583598', '583599', '583600', '583631', '583632', '583633', '583634',
        '583870', '583875',
    }


class AntiparkinsonSAdjuvants(ValueSet):
    VALUE_SET_NAME = 'Antiparkinson\'s Adjuvants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154194', '156639', '164108', '218766', '220842', '276877',
    }


class NeuromuscularTherapyAgents(ValueSet):
    VALUE_SET_NAME = 'Neuromuscular Therapy Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155537', '159674', '161115', '161115', '163855', '167592', '167592', '168112', '173841', '177088', '180068',
        '183882', '183882', '188299', '189665', '189911', '198076', '198076', '200334', '202228', '206816', '214746',
        '215165', '223377', '231627', '242267', '242267', '244583', '247663', '257447', '263590', '264356', '268626',
        '274567', '276864', '282217', '282280', '287823', '287823', '299195', '299529', '445906', '451282', '451283',
        '475311', '475314', '475314', '555010', '556689', '556695', '557261', '559106', '559417', '559625', '559632',
        '560160', '560162', '560400', '561578', '561584', '561585', '562028', '562039', '562040', '562089', '562091',
        '562625', '562634', '578751', '578752', '579100', '579102', '584201', '584201', '585832', '585832', '588214',
        '588215', '588216', '589264', '589300', '589941', '590347', '591573', '591811', '591811', '591818', '591818',
        '592097', '592647', '592652', '593494', '593610', '593687', '594074', '595120',
    }


class NeuromuscularBlockerDepolarizingAgents(ValueSet):
    VALUE_SET_NAME = 'Neuromuscular Blocker - Depolarizing Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '200334', '282280', '299529', '555010', '560400', '561584', '561585', '562028', '589941', '590347', '592097',
        '593494', '595120',
    }


class NeuromuscularBlockerNondepolarizingAgents(ValueSet):
    VALUE_SET_NAME = 'Neuromuscular Blocker - Nondepolarizing Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161115', '161115', '163855', '167592', '167592', '173841', '183882', '183882', '188299', '198076', '198076',
        '215165', '231627', '242267', '242267', '287823', '287823', '475311', '475314', '475314', '557261', '559417',
        '561578', '594074',
    }


class NeuromuscularTherapyAgentsAlsAgents(ValueSet):
    VALUE_SET_NAME = 'Neuromuscular Therapy Agents - ALS Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '247663', '257447', '593610', '593687',
    }


class AlsAgentBenzathiazoles(ValueSet):
    VALUE_SET_NAME = 'ALS Agent - Benzathiazoles'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '247663', '257447',
    }


class MusculoskeletalTherapyAgents(ValueSet):
    VALUE_SET_NAME = 'Musculoskeletal Therapy Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150853', '152028', '155071', '165516', '165516', '166813', '167478', '168034', '171106', '171876', '173078',
        '173945', '173945', '173945', '173945', '175236', '176558', '183524', '186465', '187305', '192636', '197070',
        '201342', '201342', '206474', '209574', '210164', '210164', '212461', '221043', '224432', '224947', '226663',
        '231892', '233200', '233436', '234755', '234935', '234957', '244063', '252046', '261022', '261022', '261022',
        '261022', '263359', '287696', '444986', '445675', '445675', '446454', '446466', '448375', '448725', '457753',
        '457754', '468103', '473429', '473639', '473641', '473641', '473642', '473646', '473647', '473648', '473671',
        '475477', '549559', '549560', '550442', '550465', '552109', '552110', '552784', '552799', '555665', '555674',
        '557499', '557506', '560529', '560545', '561178', '561200', '561645', '562987', '562988', '562989', '562992',
        '562993', '562994', '567408', '567409', '567428', '567429', '573392', '573397', '574463', '574946', '576632',
        '576792', '576793', '576794', '576796', '576797', '576798', '577401', '581374', '581384', '582204', '582206',
        '586417', '586537', '587245', '587565', '588237', '588259', '588555', '588581', '588817', '591137', '591150',
        '591316', '592671', '592671', '592674', '592674', '594484', '594485', '594531', '594534', '595090',
    }


class SkeletalMuscleRelaxantCentralMuscleRelaxants(ValueSet):
    VALUE_SET_NAME = 'Skeletal Muscle Relaxant - Central Muscle Relaxants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150853', '152028', '155071', '165516', '165516', '166813', '173945', '173945', '173945', '173945', '175236',
        '176558', '183524', '201342', '201342', '206474', '209574', '210164', '210164', '212461', '221043', '224947',
        '233200', '233436', '234935', '234957', '244063', '252046', '261022', '261022', '261022', '261022', '287696',
        '446454', '446466', '448725', '473429', '473639', '473641', '473641', '473642', '473646', '473647', '473648',
        '473671', '549559', '549560', '550442', '550465', '552109', '552110', '552784', '552799', '562987', '562988',
        '562989', '562992', '562993', '562994', '567408', '567409', '567428', '567429', '573392', '573397', '576792',
        '576793', '576794', '576796', '576797', '576798', '588581', '594484', '594485', '594531', '594534',
    }


class SkeletalMuscleRelaxantDirectMuscleRelaxants(ValueSet):
    VALUE_SET_NAME = 'Skeletal Muscle Relaxant - Direct Muscle Relaxants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '168034', '171876', '187305', '192636', '197070', '231892', '234755', '561645', '582204', '582206',
    }


class MusculoskeletalTherapyAgentViscosupplements(ValueSet):
    VALUE_SET_NAME = 'Musculoskeletal Therapy Agent - Viscosupplements'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '167478', '186465', '224432', '226663', '263359', '445675', '445675', '448375', '457753', '457754', '475477',
        '557499', '557506', '574463', '574946', '576632', '577401', '581374', '581384', '586417', '586537', '587565',
        '588817', '591137', '591150', '591316', '595090',
    }


class SkeletalMuscleRelaxantCombinations(ValueSet):
    VALUE_SET_NAME = 'Skeletal Muscle Relaxant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '171106', '173078', '555665', '555674', '561178', '561200', '588237', '588259', '588555',
    }


class SkeletalMuscleRelaxantSteroidAnalgesicCombinations(ValueSet):
    VALUE_SET_NAME = 'Skeletal Muscle Relaxant - Steroid-Analgesic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntimyasthenicAgents(ValueSet):
    VALUE_SET_NAME = 'Antimyasthenic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155537', '159674', '168112', '180068', '189665', '214746', '223377', '244583', '263590', '264356', '268626',
        '274567', '276864', '559106', '578751', '578752', '579100', '579102', '588214', '588215', '588216', '591573',
    }


class Vitamins(ValueSet):
    VALUE_SET_NAME = 'Vitamins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153048', '153316', '153723', '155287', '155905', '156605', '156605', '158193', '159000', '159287', '159410',
        '160473', '160473', '160717', '161564', '162330', '162335', '162941', '163363', '163598', '165026', '165476',
        '166114', '166283', '166494', '166494', '166603', '167352', '167618', '168974', '169366', '169661', '169988',
        '172055', '172243', '172343', '173740', '175471', '176359', '176446', '180412', '181871', '182504', '183122',
        '183614', '186072', '187240', '187518', '188395', '189975', '190587', '190587', '191943', '192178', '193591',
        '193728', '194088', '194301', '194366', '195731', '198041', '201488', '201568', '202245', '202292', '202292',
        '202332', '202912', '204076', '204576', '205187', '206903', '206903', '208749', '210795', '212907', '214387',
        '214926', '215605', '217645', '218376', '219224', '219224', '221309', '222635', '223163', '223228', '224179',
        '224870', '224990', '226007', '226531', '226869', '232246', '232246', '232790', '234471', '236171', '236407',
        '236418', '238268', '238765', '238818', '238818', '238818', '239029', '239375', '239674', '240834', '241386',
        '241512', '243035', '244218', '245539', '249817', '250668', '254226', '255151', '255513', '255682', '256208',
        '257461', '257494', '258214', '258442', '260242', '262043', '262059', '263439', '263974', '264890', '265212',
        '266210', '268145', '268234', '268234', '269525', '269749', '270980', '271091', '272021', '273211', '273902',
        '276734', '279229', '279273', '280014', '282585', '283342', '283344', '288788', '289462', '290138', '290369',
        '290689', '291111', '291481', '291599', '293245', '293358', '293358', '294577', '295197', '295821', '295983',
        '296681', '297091', '297140', '298020', '298676', '298848', '299490', '400522', '400911', '401077', '437054',
        '437056', '437101', '437155', '437187', '437190', '437197', '437210', '437212', '437215', '437217', '437225',
        '437228', '437231', '437261', '437262', '437302', '437441', '439692', '439693', '439693', '439700', '444419',
        '444618', '445124', '445574', '448032', '448042', '448042', '448044', '448175', '450779', '450779', '452840',
        '453610', '468016', '468451', '469772', '469784', '471185', '472034', '472544', '473473', '473804', '473804',
        '473812', '474287', '474371', '474537', '475309', '475532', '475563', '475702', '475882', '476025', '476190',
        '476277', '476791', '476846', '503622', '545012', '546694', '546694', '548809', '549803', '549877', '550748',
        '550786', '550786', '553008', '553076', '553107', '554050', '554692', '554719', '554792', '554796', '554955',
        '555062', '555198', '555333', '555333', '555349', '555349', '555575', '555673', '555697', '555707', '555733',
        '555760', '555940', '555940', '555958', '555958', '556860', '557725', '557741', '557804', '557813', '558189',
        '558190', '558190', '558207', '558225', '558378', '558435', '558474', '558559', '558766', '558812', '558812',
        '558812', '558813', '558813', '558813', '558821', '558822', '559218', '559323', '559664', '559673', '559732',
        '559742', '559950', '559950', '559973', '559975', '559983', '560122', '560137', '560158', '560444', '560645',
        '560770', '560770', '560814', '560814', '560845', '560896', '560920', '560920', '560926', '561001', '561012',
        '561016', '561137', '561297', '561337', '561338', '561414', '561415', '561427', '561438', '561455', '561455',
        '561456', '561457', '561635', '561635', '561759', '561796', '562070', '562226', '562277', '563091', '563302',
        '563324', '563347', '563565', '563566', '563567', '563644', '564254', '564464', '564535', '564539', '564549',
        '564558', '564591', '564601', '564778', '564906', '565319', '565364', '565423', '565500', '565501', '565532',
        '565710', '565768', '570208', '570591', '570591', '570624', '570625', '570783', '570900', '571210', '571731',
        '571741', '571861', '572038', '572154', '572546', '572651', '572958', '572959', '572960', '573193', '573223',
        '573839', '573840', '573854', '574006', '574753', '574819', '575021', '575022', '575023', '575028', '575030',
        '575060', '576178', '576179', '576180', '576251', '576260', '576260', '576280', '576281', '576470', '576485',
        '576519', '576520', '577008', '577075', '577087', '577107', '577125', '577338', '577360', '577361', '577408',
        '577409', '577443', '577444', '577458', '577459', '577806', '577854', '577976', '577986', '578018', '578020',
        '578021', '578022', '578029', '578516', '578737', '578749', '578758', '578845', '578897', '579015', '579237',
        '579527', '579535', '579804', '580285', '580716', '580757', '580948', '580960', '580979', '581219', '581219',
        '581483', '581558', '581590', '582027', '582056', '582337', '582576', '582576', '582880', '582880', '583089',
        '583135', '583152', '583252', '583441', '583447', '583604', '583642', '584028', '584052', '584350', '585034',
        '586078', '586195', '586496', '586742', '586821', '586847', '586857', '586876', '587039', '587500', '587528',
        '587686', '587997', '588279', '588389', '588464', '588489', '588491', '588543', '588545', '588546', '588556',
        '588591', '588782', '589295', '589473', '590042', '590089', '590190', '590321', '590339', '590652', '591387',
        '591542', '591694', '591981', '592465', '592498', '592513', '592594', '593136', '593156', '593191', '593195',
        '593213', '593244', '593414', '593450', '593465', '593683', '593952', '594042', '594057', '594147', '594193',
        '594365', '594389', '594392', '594393', '594467', '594486', '594489', '594496', '594526', '594542', '594566',
        '594609', '594617', '594627', '594636', '594866', '594979', '595041', '595117', '595350', '595374', '595798',
        '595825', '595842', '595860', '595869', '595878',
    }


class VitaminsWaterSoluble(ValueSet):
    VALUE_SET_NAME = 'Vitamins - Water Soluble'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153048', '153316', '153723', '155905', '156605', '156605', '158193', '159000', '159287', '160717', '161564',
        '162330', '162941', '163363', '165026', '166114', '166283', '166494', '166494', '167352', '167618', '168974',
        '172243', '172343', '175471', '176359', '176446', '182504', '187240', '187518', '189975', '190587', '190587',
        '191943', '192178', '193591', '193728', '194088', '194301', '194366', '195731', '198041', '201568', '202332',
        '202912', '204076', '204576', '205187', '206903', '206903', '208749', '212907', '214387', '214926', '215605',
        '217645', '218376', '219224', '219224', '221309', '222635', '223163', '224870', '224990', '226007', '226531',
        '232246', '232246', '234471', '236171', '236407', '236418', '238268', '238818', '238818', '238818', '239375',
        '239674', '241386', '241512', '243035', '245539', '249817', '250668', '254226', '255151', '255682', '256208',
        '257494', '258214', '258442', '260242', '262043', '263439', '263974', '264890', '265212', '266210', '268145',
        '268234', '268234', '269525', '269749', '270980', '271091', '273211', '273902', '279229', '279273', '282585',
        '283342', '283344', '289462', '290369', '291481', '291599', '293245', '293358', '293358', '294577', '295197',
        '295821', '295983', '296681', '297091', '297140', '298020', '298848', '400522', '400911', '437054', '437056',
        '437101', '437155', '437187', '437190', '437197', '437210', '437212', '437215', '437217', '437225', '437228',
        '437231', '437261', '437262', '437302', '437441', '439692', '439693', '439693', '439700', '445124', '448032',
        '448175', '450779', '450779', '452840', '453610', '468016', '468451', '469772', '469784', '471185', '472034',
        '472544', '474287', '475309', '475532', '475563', '475882', '476025', '476277', '476791', '503622', '548809',
        '549877', '550748', '554792', '554796', '554955', '555062', '555198', '555333', '555333', '555349', '555349',
        '555673', '555733', '555760', '558189', '558207', '558378', '558559', '559323', '559732', '559742', '559975',
        '559983', '560122', '560137', '560444', '560770', '560770', '560814', '560814', '560845', '560896', '560920',
        '560920', '560926', '561016', '561337', '561338', '561414', '561415', '561455', '561455', '561456', '561457',
        '561635', '561635', '561759', '561796', '562226', '562277', '563302', '563324', '563347', '563565', '563566',
        '563567', '564254', '564549', '564558', '564591', '565319', '565364', '565423', '570208', '570591', '570591',
        '570624', '570783', '570900', '571861', '572038', '572546', '572651', '573193', '573223', '573839', '574753',
        '574819', '576178', '576179', '576180', '576251', '576470', '576485', '576519', '576520', '577075', '577087',
        '577107', '577125', '577338', '577360', '577361', '577408', '577409', '577443', '577444', '577458', '577459',
        '577806', '577854', '577976', '577986', '578018', '578020', '578021', '578022', '578029', '578516', '578737',
        '578749', '578845', '578897', '579015', '579237', '579527', '579535', '579804', '580285', '580948', '580960',
        '580979', '581483', '581558', '581590', '582027', '582056', '583089', '583135', '583152', '583252', '583441',
        '583447', '583604', '583642', '584028', '584052', '584350', '586078', '586195', '586496', '586821', '586847',
        '587039', '588279', '588389', '588464', '588489', '588491', '588543', '588545', '588546', '588556', '588591',
        '588782', '589295', '589473', '590089', '590190', '590652', '591387', '591542', '591694', '591981', '592465',
        '592498', '592513', '592594', '593136', '593156', '593191', '593195', '593213', '593465', '594365', '594389',
        '594392', '594393', '594486', '594489', '594496', '594526', '594609', '594617', '594627', '594979', '595041',
        '595117', '595842', '595860', '595869', '595878',
    }


class VitaminsB1ThiamineAndDerivatives(ValueSet):
    VALUE_SET_NAME = 'Vitamins - B-1, Thiamine and Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153048', '172243', '194301', '202912', '221309', '283344', '295821', '298848', '561759', '561796', '570208',
        '580285',
    }


class VitaminsB2RiboflavinAndDerivatives(ValueSet):
    VALUE_SET_NAME = 'Vitamins - B-2, Riboflavin and Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155905', '160717', '175471', '269749', '290369', '298020', '563302', '563324', '590652',
    }


class VitaminsB3NiacinAndDerivatives(ValueSet):
    VALUE_SET_NAME = 'Vitamins - B-3, Niacin and Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '192178', '195731', '204076', '205187', '241512', '245539', '250668', '256208', '260242', '265212', '273211',
        '289462', '296681', '437054', '437056', '437441', '474287', '555198', '559732', '559742', '563565', '563566',
        '563567', '564254', '565423', '586078', '594365', '594389', '594486', '594489', '594526', '594617', '594979',
    }


class VitaminsB5PantothenicAcidAndDerivatives(ValueSet):
    VALUE_SET_NAME = 'Vitamins - B-5, Pantothenic Acid and Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161564', '560845', '561337', '561338', '594496',
    }


class VitaminsB6PyridoxineAndDerivatives(ValueSet):
    VALUE_SET_NAME = 'Vitamins - B-6, Pyridoxine and Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159000', '162941', '182504', '193591', '208749', '239375', '254226', '258442', '270980', '273902', '291599',
        '294577', '452840', '561414', '561415', '561456', '561457', '574753', '574819',
    }


class VitaminsBiotin(ValueSet):
    VALUE_SET_NAME = 'Vitamins - Biotin'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153723', '167618', '172343', '214926', '238268', '258214', '472034', '548809', '554792', '554796', '579804',
        '580960', '580979', '581558', '588389', '590089', '591981', '595117', '595842', '595860',
    }


class VitaminsPaba(ValueSet):
    VALUE_SET_NAME = 'Vitamins - PABA'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153316', '241386',
    }


class VitaminsCAscorbicAcidAndDerivatives(ValueSet):
    VALUE_SET_NAME = 'Vitamins - C, Ascorbic Acid and Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158193', '159287', '166494', '166494', '167352', '168974', '187240', '189975', '190587', '190587', '191943',
        '202332', '214387', '218376', '219224', '219224', '224870', '224990', '226531', '232246', '232246', '234471',
        '236171', '236418', '243035', '249817', '255682', '257494', '263974', '266210', '269525', '279229', '282585',
        '291481', '293358', '293358', '295197', '295983', '297091', '400522', '437101', '437155', '437187', '437190',
        '437197', '437210', '437212', '437215', '437217', '437225', '437228', '437231', '437261', '437262', '437302',
        '445124', '450779', '450779', '471185', '549877', '558378', '560896', '560920', '560920', '560926', '561455',
        '561455', '561635', '561635', '563347', '565319', '565364', '570624', '570783', '572038', '572546', '573193',
        '573223', '577806', '577854', '583152', '592465', '592513', '593191', '593213', '594392', '594393', '594609',
        '595869',
    }


class VitaminsOilSoluble(ValueSet):
    VALUE_SET_NAME = 'Vitamins - Oil Soluble'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155287', '159410', '160473', '160473', '162335', '163598', '165476', '166603', '169366', '169661', '169988',
        '172055', '173740', '180412', '181871', '183122', '183614', '186072', '188395', '201488', '202245', '202292',
        '202292', '210795', '223228', '224179', '226869', '232790', '238765', '239029', '240834', '244218', '255513',
        '257461', '262059', '272021', '276734', '280014', '288788', '290138', '290689', '291111', '298676', '299490',
        '401077', '444419', '444618', '445574', '448042', '448042', '448044', '473473', '473804', '473804', '473812',
        '474371', '474537', '475702', '476190', '476846', '545012', '546694', '546694', '549803', '550786', '550786',
        '553008', '553076', '553107', '554050', '554692', '554719', '555575', '555697', '555707', '555940', '555940',
        '555958', '555958', '556860', '557725', '557741', '557804', '557813', '558190', '558190', '558225', '558435',
        '558474', '558766', '558812', '558812', '558812', '558813', '558813', '558813', '558821', '558822', '559218',
        '559664', '559673', '559950', '559950', '559973', '560158', '560645', '561001', '561012', '561137', '561297',
        '561427', '561438', '562070', '563091', '563644', '564464', '564535', '564539', '564601', '564778', '564906',
        '565500', '565501', '565532', '565710', '565768', '570625', '571210', '571731', '571741', '572154', '572958',
        '572959', '572960', '573840', '573854', '574006', '575021', '575022', '575023', '575028', '575030', '575060',
        '576260', '576260', '576280', '576281', '577008', '578758', '580716', '580757', '581219', '581219', '582337',
        '582576', '582576', '582880', '582880', '585034', '586742', '586857', '586876', '587500', '587528', '587686',
        '587997', '590042', '590321', '590339', '593244', '593414', '593450', '593683', '593952', '594042', '594057',
        '594147', '594193', '594467', '594542', '594566', '594636', '594866', '595350', '595374', '595798', '595825',
    }


class VitaminsA(ValueSet):
    VALUE_SET_NAME = 'Vitamins - A'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159410', '166603', '180412', '201488', '210795', '224179', '226869', '244218', '255513', '444618', '473473',
        '561012', '561297', '594147',
    }


class VitaminsDDerivatives(ValueSet):
    VALUE_SET_NAME = 'Vitamins - D Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165476', '169661', '172055', '183614', '186072', '188395', '202245', '223228', '240834', '257461', '262059',
        '272021', '276734', '280014', '288788', '290138', '290689', '299490', '401077', '444419', '448042', '448042',
        '448044', '473804', '473804', '473812', '476846', '546694', '546694', '550786', '550786', '553076', '553107',
        '554050', '555575', '555940', '555940', '555958', '555958', '557725', '557741', '557804', '557813', '558190',
        '558190', '558225', '558435', '558474', '558766', '558812', '558812', '558812', '558813', '558813', '558813',
        '558821', '558822', '559218', '559664', '559673', '559950', '559950', '559973', '560645', '561137', '561427',
        '561438', '562070', '563091', '563644', '564535', '564539', '564601', '565500', '565501', '565532', '571731',
        '571741', '572154', '573840', '573854', '574006', '576260', '576260', '576280', '576281', '577008', '580757',
        '581219', '581219', '582337', '582576', '582576', '582880', '582880', '585034', '587528', '587997', '590042',
        '590321', '590339', '593244', '593414', '593683', '593952', '594042', '594057', '594193', '594866', '595798',
        '595825',
    }


class VitaminsE(ValueSet):
    VALUE_SET_NAME = 'Vitamins - E'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155287', '160473', '160473', '162335', '173740', '181871', '183122', '202292', '202292', '238765', '291111',
        '474537', '475702', '476190', '545012', '553008', '554692', '554719', '556860', '560158', '564464', '570625',
        '571210', '572958', '572959', '572960', '575021', '575022', '575023', '575028', '575030', '575060', '580716',
        '586742', '594467', '594542', '594566', '594636',
    }


class VitaminsKPhytonadioneAndDerivatives(ValueSet):
    VALUE_SET_NAME = 'Vitamins - K, Phytonadione and Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '163598', '169366', '169988', '232790', '239029', '298676', '445574', '474371', '578758', '593450',
    }


class VitaminsBioflavonoids(ValueSet):
    VALUE_SET_NAME = 'Vitamins - Bioflavonoids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '279273', '571861',
    }


class VitaminCombinations(ValueSet):
    VALUE_SET_NAME = 'Vitamin Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150486', '150529', '150716', '151710', '151791', '152086', '153900', '154417', '154776', '155976', '155976',
        '158012', '158906', '160139', '160350', '161465', '163329', '165594', '167190', '167958', '168540', '169843',
        '171223', '171996', '172878', '173736', '175882', '176287', '176844', '177197', '177270', '181764', '181855',
        '182017', '182571', '183402', '184468', '184468', '184468', '185324', '185553', '186334', '186641', '187478',
        '187827', '188486', '190623', '191837', '191848', '195993', '196969', '197036', '197036', '197078', '197825',
        '197857', '198269', '198923', '200434', '201744', '202063', '204052', '204832', '205708', '205827', '206271',
        '206364', '206453', '206453', '206780', '207241', '209231', '209909', '210337', '211186', '212044', '212292',
        '212646', '212646', '214515', '214765', '214962', '215493', '217048', '218356', '218832', '219294', '219399',
        '219995', '220857', '221645', '223054', '225501', '225522', '226431', '228709', '228904', '229463', '230658',
        '231591', '232355', '232954', '233804', '234051', '234459', '234833', '234958', '237254', '238775', '239310',
        '239310', '241582', '243135', '243312', '243407', '244476', '244825', '245796', '245973', '246417', '246539',
        '247780', '249642', '252335', '252335', '252335', '252766', '253131', '254183', '254681', '255820', '256240',
        '256253', '259604', '261325', '261500', '262108', '262324', '263928', '263964', '264035', '264752', '266904',
        '267585', '270769', '271190', '274931', '275643', '276013', '278611', '278868', '279458', '280423', '281826',
        '281838', '283428', '283920', '284103', '284162', '284162', '284162', '284421', '286049', '286189', '287048',
        '287330', '287331', '287515', '287737', '288176', '288588', '289028', '290006', '292149', '293707', '294416',
        '295595', '296012', '298765', '298982', '299135', '400246', '400339', '400518', '400702', '400981', '401000',
        '401080', '401084', '437465', '437488', '437506', '437507', '437527', '437528', '437539', '437547', '437551',
        '437655', '437666', '437694', '437728', '437826', '437840', '437866', '437881', '437947', '437986', '437996',
        '438006', '438014', '438023', '438069', '438095', '438194', '438236', '438259', '438280', '438298', '438430',
        '438434', '438440', '438455', '438464', '438483', '438490', '438505', '438527', '438530', '438531', '438553',
        '438626', '438704', '438719', '438759', '438765', '444054', '444166', '444169', '444170', '444172', '444173',
        '444174', '444178', '444181', '444182', '444184', '444186', '444187', '444189', '444192', '444196', '444201',
        '444203', '444204', '444207', '444207', '444214', '444224', '444266', '444270', '444276', '444278', '444287',
        '444601', '444984', '445225', '445226', '445258', '445382', '445390', '445500', '445826', '445861', '445886',
        '445896', '446064', '446154', '446163', '446224', '446227', '446232', '446240', '446277', '446290', '446341',
        '446508', '446612', '446645', '446686', '446687', '446689', '446698', '446892', '447085', '448138', '448638',
        '448654', '448690', '448759', '448904', '449776', '449851', '450025', '451724', '451761', '451853', '452263',
        '452263', '452333', '452337', '452907', '452909', '453008', '453017', '453058', '453076', '453105', '453112',
        '453171', '453175', '453446', '453471', '453504', '453537', '453552', '454282', '454421', '454454', '454454',
        '464707', '465174', '465369', '465516', '465727', '465892', '465899', '466002', '466099', '467355', '467402',
        '467433', '467615', '467897', '467898', '467899', '468128', '468301', '468302', '468361', '468365', '468434',
        '468441', '469707', '469708', '469720', '470212', '470710', '471018', '471086', '471094', '471103', '471180',
        '471465', '471778', '471803', '471937', '471956', '471987', '471987', '471988', '471988', '472053', '472057',
        '472079', '472108', '472376', '472378', '472394', '472561', '472569', '472598', '472851', '472944', '472950',
        '473068', '473082', '473097', '473130', '473265', '473270', '473335', '473362', '473406', '473459', '473509',
        '473552', '473601', '473602', '473608', '473609', '473722', '473991', '474101', '474170', '474172', '474264',
        '474352', '474358', '474388', '474455', '474472', '474552', '474555', '474563', '474864', '474870', '474873',
        '474877', '474884', '474906', '474924', '474925', '474940', '474947', '474981', '475077', '475078', '475187',
        '475189', '475239', '475240', '475243', '475243', '475244', '475244', '475245', '475261', '475318', '475415',
        '475574', '475594', '475638', '475927', '475933', '475937', '476143', '476147', '476149', '545140', '545204',
        '545215', '545560', '545578', '545683', '545683', '545767', '545767', '545782', '545810', '545865', '545951',
        '545951', '545980', '546011', '546011', '546554', '546559', '546665', '547780', '547821', '547974', '548053',
        '548655', '548680', '548804', '548806', '548808', '548843', '548844', '548845', '548991', '549017', '549140',
        '549443', '549450', '549511', '549512', '549669', '549717', '550123', '550144', '550145', '550151', '550230',
        '550232', '550296', '550297', '550385', '550430', '550608', '550614', '550628', '550629', '550687', '550688',
        '551026', '551034', '551037', '551115', '551530', '552093', '552113', '552313', '552342', '552467', '552501',
        '552525', '552852', '552926', '552928', '552930', '552962', '552965', '552965', '552966', '553014', '553035',
        '553066', '553070', '553155', '553207', '553217', '553227', '553262', '553264', '553281', '553282', '553293',
        '553300', '553310', '553314', '553420', '553461', '553469', '553474', '553539', '553562', '553663', '553742',
        '554042', '554259', '554422', '554449', '554483', '554727', '554736', '554801', '554834', '554835', '554839',
        '554865', '554870', '554876', '554894', '554906', '554985', '554995', '555061', '555066', '555093', '555151',
        '555165', '555197', '555221', '555523', '555606', '555704', '555717', '555822', '555891', '555938', '556093',
        '556142', '556177', '556186', '556249', '556292', '556327', '556355', '556415', '556420', '556461', '556602',
        '556660', '556661', '556669', '556673', '556682', '556684', '556693', '556703', '556880', '556958', '556968',
        '557029', '557050', '557052', '557061', '557121', '557149', '557284', '557300', '557354', '557374', '557375',
        '557390', '557457', '557476', '557497', '557505', '557657', '557787', '557821', '557872', '557876', '557879',
        '557883', '557890', '557992', '558043', '558096', '558108', '558133', '558136', '558150', '558151', '558182',
        '558187', '558204', '558204', '558204', '558204', '558212', '558224', '558264', '558288', '558298', '558315',
        '558354', '558413', '558500', '558501', '558502', '558514', '558515', '558516', '558558', '558569', '558597',
        '558641', '558648', '558663', '558728', '558752', '558753', '558916', '558927', '558983', '558995', '559046',
        '559053', '559059', '559068', '559104', '559108', '559121', '559122', '559204', '559205', '559225', '559228',
        '559244', '559262', '559267', '559269', '559464', '559490', '559568', '559600', '559638', '559686', '559726',
        '559727', '559863', '559864', '559873', '559874', '559878', '559879', '559880', '559923', '559982', '560079',
        '560218', '560220', '560222', '560238', '560267', '560305', '560315', '560322', '560333', '560334', '560335',
        '560336', '560384', '560392', '560393', '560394', '560608', '560695', '560696', '560697', '560708', '560741',
        '560743', '560765', '560780', '560800', '560803', '560811', '560825', '560852', '560868', '560887', '560918',
        '560922', '560923', '560927', '560940', '560986', '560987', '561005', '561007', '561025', '561044', '561053',
        '561096', '561181', '561261', '561284', '561306', '561327', '561328', '561330', '561341', '561341', '561348',
        '561356', '561374', '561383', '561396', '561481', '561528', '561544', '561636', '561663', '561668', '561677',
        '561679', '561680', '561689', '561692', '561702', '561705', '561707', '561723', '561724', '561725', '561729',
        '561766', '561812', '561831', '561832', '561848', '561849', '561851', '561863', '561927', '561956', '562029',
        '562099', '562104', '562128', '562269', '562270', '562284', '562295', '562304', '562314', '562349', '562353',
        '562355', '562511', '562516', '562541', '562548', '562589', '562609', '562612', '562661', '562673', '562678',
        '562679', '562682', '562688', '562695', '562702', '562702', '562708', '562737', '562752', '562765', '562778',
        '562785', '562876', '562915', '563013', '563016', '563018', '563020', '563031', '563036', '563045', '563120',
        '563124', '563125', '563130', '563133', '563139', '563178', '563180', '563185', '563190', '563193', '563198',
        '563199', '563200', '563201', '563228', '563233', '563234', '563238', '563239', '563242', '563246', '563274',
        '563330', '563337', '563338', '563339', '563350', '563363', '563367', '563371', '563383', '563386', '563397',
        '563398', '563410', '563418', '563425', '563456', '563470', '563583', '563624', '563696', '563749', '563750',
        '563847', '563854', '563865', '563915', '564172', '564200', '564204', '564236', '564276', '564290', '564296',
        '564302', '564306', '564322', '564324', '564339', '564345', '564379', '564382', '564418', '564425', '564463',
        '564465', '564471', '564472', '564477', '564492', '564510', '564516', '564521', '564550', '564582', '564588',
        '564599', '564643', '564644', '564645', '564654', '564656', '564656', '564656', '564660', '564662', '564702',
        '564720', '564722', '564732', '564732', '564735', '564779', '564787', '564787', '564813', '564813', '564817',
        '564818', '564849', '564854', '564874', '564883', '564885', '564913', '564994', '564998', '565037', '565041',
        '565050', '565051', '565077', '565099', '565102', '565139', '565175', '565333', '565334', '565362', '565377',
        '565386', '565404', '565443', '565470', '565739', '565773', '565840', '565951', '565952', '566174', '566321',
        '566452', '566480', '566507', '566518', '566521', '566652', '566659', '566684', '566722', '566898', '567022',
        '567193', '567336', '567507', '567548', '567549', '567562', '567928', '567928', '568488', '568489', '568490',
        '568493', '568530', '568543', '568545', '568577', '568588', '568678', '568704', '568859', '568906', '568970',
        '569002', '569013', '569016', '569065', '569092', '569129', '569155', '569198', '569258', '569261', '569262',
        '569393', '569412', '569434', '569443', '569449', '569449', '569452', '569546', '569547', '569583', '569594',
        '569595', '569603', '569630', '569633', '569660', '569692', '569720', '569823', '569824', '569824', '569831',
        '569839', '569861', '569863', '569963', '570009', '570011', '570012', '570181', '570181', '570269', '570355',
        '570394', '570442', '570442', '570616', '570663', '570668', '570744', '570748', '570761', '570782', '570784',
        '570786', '570834', '570844', '570846', '570961', '570989', '571004', '571050', '571080', '571095', '571221',
        '571294', '571299', '571347', '571350', '571415', '571420', '571421', '571433', '571437', '571644', '571649',
        '571650', '571656', '571697', '571850', '571858', '571859', '571881', '571889', '571903', '571909', '571946',
        '572019', '572020', '572110', '572116', '572155', '572203', '572204', '572217', '572237', '572238', '572246',
        '572301', '572334', '572338', '572354', '572369', '572374', '572376', '572479', '572545', '572580', '572681',
        '572718', '572726', '572727', '572745', '572746', '572747', '572748', '572752', '572752', '572759', '572759',
        '572760', '572832', '572836', '572874', '572889', '572903', '572910', '573010', '573050', '573103', '573122',
        '573130', '573157', '573164', '573166', '573261', '573292', '573301', '573312', '573389', '573466', '573531',
        '573569', '573630', '573640', '573663', '573696', '573703', '573734', '573755', '573756', '573764', '573803',
        '573834', '573870', '573883', '573944', '573994', '574054', '574060', '574076', '574084', '574096', '574223',
        '574235', '574271', '574368', '574400', '574548', '574549', '574552', '574675', '574695', '574704', '574715',
        '574749', '574754', '574775', '574939', '574939', '575001', '575004', '575005', '575006', '575008', '575109',
        '575111', '575170', '575182', '575295', '575326', '575357', '575386', '575461', '575468', '575490', '575510',
        '575552', '575583', '575602', '575603', '575612', '575638', '575646', '575682', '575708', '575722', '575739',
        '575744', '575773', '575788', '575813', '575867', '575948', '575968', '576015', '576021', '576084', '576087',
        '576090', '576132', '576145', '576173', '576184', '576186', '576221', '576270', '576277', '576278', '576279',
        '576327', '576331', '576392', '576393', '576397', '576432', '576480', '576508', '576556', '576562', '576577',
        '576584', '576589', '576590', '576660', '576687', '576690', '576715', '576716', '576739', '576758', '576925',
        '576964', '576988', '577044', '577078', '577079', '577089', '577095', '577110', '577183', '577195', '577296',
        '577311', '577366', '577575', '577604', '577700', '577738', '577828', '577889', '577890', '578042', '578335',
        '578339', '578369', '578378', '578382', '578411', '578506', '578558', '578648', '578648', '578746', '578746',
        '578754', '578770', '578798', '578798', '578798', '578804', '578807', '578851', '578857', '578860', '578876',
        '578879', '578879', '578879', '578880', '578902', '578909', '578910', '578922', '578923', '578924', '578928',
        '578929', '578961', '578991', '579003', '579005', '579017', '579033', '579063', '579215', '579246', '579268',
        '579374', '579398', '579408', '579411', '579417', '579469', '579473', '579509', '579518', '579520', '579684',
        '579808', '579811', '579812', '579818', '579819', '579821', '579823', '579824', '579834', '579841', '579845',
        '579851', '579855', '580109', '580135', '580210', '580241', '580246', '580280', '580322', '580336', '580359',
        '580360', '580361', '580589', '580602', '580620', '580660', '580673', '580675', '580676', '580677', '580678',
        '580693', '580696', '580706', '580708', '580711', '580712', '580713', '580720', '580721', '580798', '580800',
        '580801', '580848', '580857', '580894', '580894', '580913', '580921', '580928', '580931', '580940', '580977',
        '580998', '581004', '581041', '581052', '581078', '581120', '581141', '581147', '581177', '581208', '581269',
        '581273', '581307', '581334', '581343', '581381', '581409', '581441', '581459', '581460', '581488', '581490',
        '581492', '581511', '581522', '581535', '581551', '581556', '581559', '581580', '581585', '581593', '581605',
        '581616', '581623', '581624', '581638', '581652', '581656', '581667', '581671', '581673', '581696', '581701',
        '581702', '581706', '581735', '581745', '581753', '581794', '581806', '581807', '581816', '581817', '581827',
        '581847', '581851', '581853', '581856', '581857', '581861', '581878', '581888', '581892', '581957', '582023',
        '582028', '582029', '582031', '582055', '582073', '582093', '582119', '582126', '582127', '582129', '582133',
        '582139', '582156', '582161', '582165', '582166', '582190', '582194', '582210', '582228', '582229', '582252',
        '582253', '582268', '582270', '582334', '582335', '582336', '582338', '582659', '582665', '582667', '582668',
        '582680', '582745', '582761', '582842', '582847', '582853', '582865', '582872', '582888', '582906', '582983',
        '583011', '583020', '583055', '583073', '583074', '583094', '583095', '583130', '583167', '583260', '583276',
        '583280', '583281', '583287', '583305', '583312', '583315', '583334', '583392', '583397', '583521', '583530',
        '583537', '583614', '583621', '583687', '583687', '583690', '583699', '583710', '583710', '583722', '583734',
        '583742', '583756', '583811', '583818', '583848', '583900', '583907', '583908', '583909', '584018', '584050',
        '584094', '584095', '584100', '584119', '584315', '584321', '584335', '584436', '584537', '584559', '584580',
        '584646', '584779', '585010', '585012', '585036', '585042', '585070', '585084', '585116', '585131', '585209',
        '585242', '585332', '585436', '585466', '585568', '585581', '585619', '585624', '585626', '585648', '585675',
        '585803', '585804', '585868', '585896', '586046', '586092', '586093', '586109', '586117', '586141', '586142',
        '586154', '586176', '586178', '586207', '586346', '586501', '586564', '586643', '586680', '586696', '586721',
        '586740', '586744', '586746', '586775', '586790', '586792', '586793', '586799', '586800', '586802', '586813',
        '586830', '586839', '586890', '586905', '586912', '586951', '586964', '586979', '587036', '587038', '587088',
        '587120', '587223', '587302', '587315', '587532', '587562', '587570', '587598', '587611', '587613', '587619',
        '587637', '587639', '587663', '587678', '587682', '587709', '587788', '587849', '587864', '587864', '587864',
        '587864', '587914', '587963', '587976', '588128', '588158', '588160', '588166', '588167', '588170', '588171',
        '588172', '588199', '588317', '588349', '588358', '588358', '588359', '588374', '588380', '588416', '588424',
        '588425', '588455', '588486', '588493', '588498', '588515', '588528', '588544', '588552', '588558', '588562',
        '588568', '588577', '588585', '588605', '588606', '588607', '588630', '588655', '588684', '588759', '588778',
        '588820', '589006', '589053', '589201', '589220', '589232', '589303', '589514', '589551', '589567', '589677',
        '589725', '589730', '589743', '589750', '589822', '589887', '589951', '589963', '589979', '590018', '590027',
        '590029', '590035', '590045', '590048', '590067', '590068', '590072', '590088', '590090', '590115', '590129',
        '590156', '590229', '590468', '590634', '590676', '590778', '590812', '590820', '590909', '590916', '590944',
        '590945', '591017', '591024', '591039', '591168', '591353', '591381', '591594', '591638', '591654', '591728',
        '591927', '591943', '591961', '591978', '592004', '592008', '592098', '592123', '592130', '592152', '592180',
        '592223', '592309', '592318', '592463', '592505', '592703', '592707', '592824', '592832', '592838', '592840',
        '592849', '592852', '593013', '593051', '593057', '593059', '593060', '593091', '593103', '593143', '593147',
        '593161', '593372', '593428', '593438', '593443', '593452', '593500', '593501', '593518', '593549', '593553',
        '593561', '593576', '593680', '593690', '593700', '593803', '593805', '593807', '593831', '593835', '593841',
        '593842', '593865', '593901', '593918', '593931', '593932', '593991', '594108', '594141', '594151', '594181',
        '594348', '594350', '594414', '594415', '594495', '594519', '594555', '594567', '594576', '594589', '594613',
        '594616', '594673', '594911', '595086', '595226', '595229', '595290', '595291', '595292', '595352', '595356',
        '595369', '595387', '595408', '595412', '595415', '595416', '595420', '595422', '595434', '595436', '595437',
        '595440', '595549', '595708', '595729', '595761', '595779', '595791', '595803', '595804', '595852', '595854',
        '595856', '595898', '595901', '595975', '595977', '596007', '596103',
    }


class BComplexVitaminsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'B-Complex Vitamins and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151710', '151791', '153900', '154417', '160350', '161465', '165594', '173736', '175882', '177270', '184468',
        '184468', '184468', '187827', '191848', '197857', '204832', '205708', '205827', '209909', '217048', '219294',
        '223054', '225522', '232954', '234958', '237254', '245796', '249642', '252335', '252335', '252335', '259604',
        '264035', '266904', '274931', '275643', '280423', '284162', '284162', '284162', '286049', '287330', '287737',
        '295595', '299135', '400246', '401080', '401084', '437465', '437488', '437506', '437507', '437527', '437528',
        '437539', '437547', '437551', '437655', '437666', '437694', '437728', '437826', '444054', '444276', '444278',
        '445225', '445258', '446064', '446277', '446290', '447085', '448904', '453058', '453076', '453171', '453175',
        '453552', '454421', '465892', '468128', '468434', '468441', '469707', '469708', '470710', '471103', '471180',
        '473068', '474870', '474873', '475594', '475638', '545560', '545578', '545810', '545865', '550123', '550297',
        '551026', '551034', '551037', '551530', '552501', '552525', '552852', '553070', '553420', '553469', '554449',
        '554483', '554995', '555151', '555165', '555717', '556249', '558108', '558264', '558569', '558641', '558728',
        '558916', '559046', '559053', '559059', '559225', '559228', '559244', '559873', '559923', '560811', '560825',
        '561831', '562737', '562752', '563371', '563386', '564465', '564472', '564656', '564656', '564656', '564720',
        '564787', '564787', '564849', '564913', '568970', '569016', '569393', '570668', '571050', '573466', '573531',
        '573630', '574675', '575004', '575005', '575006', '575109', '575170', '575182', '575326', '576556', '576584',
        '578378', '578411', '579268', '580109', '580359', '580921', '580931', '580940', '580977', '581147', '581652',
        '581673', '582129', '585070', '585131', '586802', '586839', '587223', '587963', '588655', '590916', '591654',
        '594495', '595779', '595791', '595803', '595804', '595852', '595898',
    }


class BrewersYeast(ValueSet):
    VALUE_SET_NAME = 'Brewers Yeast'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '447085', '453552', '581652', '581673',
    }


class BComplexVitaminCombinations(ValueSet):
    VALUE_SET_NAME = 'B-Complex Vitamin Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151710', '153900', '160350', '173736', '184468', '184468', '184468', '205708', '217048', '219294', '245796',
        '249642', '259604', '266904', '275643', '286049', '287737', '400246', '401080', '401084', '437655', '437666',
        '437694', '437728', '437826', '444054', '444276', '444278', '445225', '445258', '446064', '446277', '446290',
        '448904', '453171', '453175', '454421', '465892', '468434', '468441', '469707', '469708', '470710', '471103',
        '471180', '473068', '474870', '474873', '475594', '475638', '545560', '545578', '545810', '545865', '550123',
        '550297', '552501', '552525', '552852', '553070', '553420', '553469', '554449', '554483', '555151', '555165',
        '555717', '556249', '558108', '558264', '558728', '558916', '559046', '559053', '559059', '559225', '559228',
        '559244', '560811', '560825', '562737', '562752', '563371', '563386', '564465', '564472', '564656', '564656',
        '564656', '564720', '564787', '564787', '564849', '564913', '568970', '569016', '569393', '570668', '571050',
        '573466', '573531', '573630', '574675', '575004', '575005', '575006', '575109', '575326', '576556', '576584',
        '579268', '580109', '580359', '580921', '580931', '580940', '580977', '581147', '582129', '585070', '585131',
        '586802', '586839', '587963', '588655', '590916', '591654', '594495', '595779', '595791', '595803', '595804',
    }


class BioflavonoidCombinations(ValueSet):
    VALUE_SET_NAME = 'Bioflavonoid Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152086', '241582', '254681', '256253', '401000', '446154', '446163', '446686', '446687', '446689', '446698',
        '470212', '471465', '473601', '473602', '473608', '473609', '554839', '556142', '557050', '557061', '557890',
        '559874', '561261', '561284', '561327', '561348', '562516', '563367', '571903', '571909', '572116', '572246',
        '574368', '574400', '574695', '574704', '574749', '574775', '575008', '575638', '576964', '576988', '577828',
        '578042', '581177', '581269', '581535', '581551', '581806', '581857', '584315', '584335',
    }


class Multivitamins(ValueSet):
    VALUE_SET_NAME = 'Multivitamins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150529', '155976', '155976', '158906', '160139', '168540', '171223', '176287', '176844', '186641', '198923',
        '212646', '212646', '214765', '229463', '234051', '239310', '239310', '255820', '263964', '270769', '281826',
        '284103', '287048', '287515', '400339', '437840', '437881', '437947', '437986', '437996', '438006', '438014',
        '438023', '438505', '444270', '444601', '445226', '446232', '446240', '448638', '449776', '453446', '453471',
        '453504', '453537', '464707', '467355', '471937', '471956', '471988', '471988', '472950', '474172', '475243',
        '475243', '475244', '475244', '545204', '545215', '554042', '554422', '554727', '557149', '558288', '558298',
        '559068', '559204', '559568', '560267', '560608', '560987', '561053', '561725', '561927', '562029', '562511',
        '563185', '563749', '564276', '564582', '564644', '564645', '564735', '564874', '564883', '565334', '566321',
        '566452', '566521', '567549', '568906', '569013', '569092', '569594', '569603', '569633', '569660', '569692',
        '569824', '569824', '570181', '570181', '570786', '570961', '571697', '572726', '572727', '572745', '572748',
        '572903', '573010', '573050', '573755', '575001', '575111', '576173', '576279', '576715', '577044', '577311',
        '577366', '577575', '577604', '582888', '583742', '584646', '588380', '588552', '588562', '590018', '590045',
        '591168', '592098', '592152', '593013', '593143', '593147', '593518', '594673', '596103',
    }


class MultivitaminAndAppetiteStimulantCombinations(ValueSet):
    VALUE_SET_NAME = 'Multivitamin and Appetite Stimulant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MultivitaminAndMineralCombinations(ValueSet):
    VALUE_SET_NAME = 'Multivitamin and Mineral Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150486', '158012', '163329', '167958', '181855', '182017', '195993', '197036', '197036', '197078', '198269',
        '200434', '201744', '202063', '206453', '206453', '206780', '207241', '209231', '212044', '212292', '219399',
        '219995', '221645', '225501', '228904', '231591', '232355', '233804', '234833', '238775', '244825', '246417',
        '247780', '252766', '253131', '254183', '262324', '263928', '271190', '278611', '279458', '283920', '286189',
        '288588', '289028', '290006', '292149', '294416', '298765', '298982', '400518', '400702', '400981', '437866',
        '438069', '438095', '438236', '438259', '438280', '438298', '444166', '444169', '444170', '444172', '444173',
        '444174', '444178', '444181', '444182', '444186', '444187', '444189', '444192', '444196', '444201', '444203',
        '444204', '444207', '444207', '444214', '444224', '444266', '444287', '445390', '445861', '445886', '445896',
        '446224', '446227', '446341', '446508', '446612', '446645', '448654', '448690', '449851', '451724', '451761',
        '452333', '452337', '452907', '453008', '453017', '453105', '454282', '465174', '465369', '465516', '465899',
        '466002', '466099', '467433', '468301', '469720', '471018', '471778', '471803', '472053', '472057', '472079',
        '472108', '472376', '472378', '472394', '472561', '472569', '472598', '472851', '473082', '473097', '473130',
        '473335', '473362', '473406', '473459', '474101', '474264', '474352', '474358', '474455', '474472', '474552',
        '474555', '474864', '474906', '474924', '474925', '474940', '474947', '474981', '475187', '475189', '475240',
        '475261', '475318', '475574', '475927', '475933', '475937', '545140', '545767', '545767', '545782', '545951',
        '545951', '545980', '546011', '546011', '546554', '546665', '547780', '547821', '547974', '548804', '548806',
        '548808', '548843', '548844', '548845', '548991', '549017', '550144', '550145', '550151', '550230', '550296',
        '550385', '550430', '550608', '550688', '552093', '552113', '552313', '552342', '552962', '553014', '553035',
        '553066', '553207', '553217', '553227', '553264', '553282', '553293', '553539', '553562', '553663', '553742',
        '554736', '554801', '554834', '554835', '554865', '554876', '554894', '554906', '554985', '555061', '555066',
        '555093', '555221', '555606', '555822', '555891', '556093', '556415', '556420', '556660', '556661', '556684',
        '556958', '556968', '557029', '557505', '557657', '557876', '557879', '558043', '558096', '558187', '558413',
        '558597', '558648', '558663', '558927', '558983', '558995', '559262', '559267', '559600', '559686', '559863',
        '559864', '560305', '560315', '560322', '560765', '560800', '560852', '560868', '560918', '560922', '560927',
        '560986', '561025', '561044', '561181', '561330', '561383', '561668', '561679', '561680', '561702', '561723',
        '561724', '561729', '561812', '561832', '561848', '562099', '562314', '562349', '562661', '562673', '562695',
        '562702', '562702', '562708', '562765', '562876', '562915', '563013', '563016', '563018', '563031', '563036',
        '563045', '563120', '563124', '563125', '563130', '563133', '563199', '563201', '563228', '563238', '563330',
        '563337', '563338', '563339', '563350', '563397', '563398', '563410', '563418', '563425', '563456', '563470',
        '563696', '563750', '563847', '564204', '564236', '564324', '564379', '564382', '564425', '564471', '564516',
        '564588', '564643', '564654', '564662', '564732', '564732', '564779', '564813', '564813', '564854', '564994',
        '565041', '565739', '565773', '565840', '565951', '565952', '566174', '566518', '566659', '566722', '567193',
        '567507', '567548', '567562', '569129', '569155', '569412', '569449', '569449', '569452', '569595', '569630',
        '569823', '569863', '570355', '570394', '570616', '570761', '570782', '570844', '570989', '571004', '571221',
        '571644', '571656', '571850', '571881', '571889', '572019', '572110', '572203', '572204', '572237', '572238',
        '572580', '572681', '572718', '572746', '572747', '572832', '572836', '572910', '573122', '573130', '573157',
        '573166', '573292', '573301', '573312', '573569', '573703', '573756', '573834', '573944', '573994', '574084',
        '574096', '574549', '574754', '574939', '574939', '575357', '575386', '575461', '575468', '575490', '575510',
        '575788', '575813', '575867', '576084', '576087', '576184', '576186', '576392', '576393', '576432', '576562',
        '576577', '576589', '576590', '576660', '576690', '576758', '576925', '577078', '577079', '577095', '577183',
        '577700', '577738', '578335', '578339', '578369', '578382', '578804', '578902', '579063', '579408', '579411',
        '579417', '579469', '579473', '579509', '579518', '579520', '579851', '579855', '580135', '580720', '580721',
        '580800', '580848', '581078', '581120', '581343', '581556', '581585', '581735', '581851', '582023', '582073',
        '582126', '582127', '582156', '582165', '582166', '582847', '582853', '583055', '583276', '583287', '583305',
        '583315', '583334', '583392', '583521', '583687', '583687', '583690', '583710', '583710', '583811', '583818',
        '583907', '583908', '584018', '584100', '585036', '585042', '585242', '585332', '585436', '585466', '585619',
        '585626', '585803', '585804', '585868', '586154', '586176', '586346', '586501', '586564', '586744', '586775',
        '586790', '586792', '586799', '586800', '586813', '586890', '586964', '586979', '587611', '587613', '587682',
        '587709', '587914', '588317', '588359', '588416', '588424', '588425', '588455', '588486', '588498', '588515',
        '588528', '588544', '588558', '588606', '588630', '588684', '588778', '589220', '589303', '589567', '589725',
        '589750', '589951', '589979', '590129', '590156', '590229', '590944', '590945', '591024', '591594', '591638',
        '592123', '592223', '592505', '592838', '592840', '593443', '593452', '593561', '593576', '593803', '593805',
        '593807', '593831', '593835', '593841', '593842', '593865', '593918', '593931', '593932', '593991', '594108',
        '594141', '594151', '594181', '594555', '594567', '594613', '594616', '594911', '595226', '595229', '595292',
        '595356', '595415', '595416', '595422', '595437', '595549', '595708', '595729', '595761', '595856',
    }


class MultivitaminWithMineralsAndAppetiteStimulantCombinations(ValueSet):
    VALUE_SET_NAME = 'Multivitamin with Minerals and Appetite Stimulant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class PediatricVitaminsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Pediatric Vitamins and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '171996', '172878', '181764', '185324', '186334', '190623', '191837', '197825', '204052', '210337', '211186',
        '218356', '218832', '220857', '226431', '230658', '234459', '243135', '244476', '246539', '283428', '284421',
        '288176', '296012', '438430', '438434', '438440', '438455', '438464', '438483', '438490', '438527', '438530',
        '438531', '438553', '438626', '438704', '438719', '445500', '450025', '452263', '452263', '454454', '454454',
        '465727', '471987', '471987', '473722', '475077', '475078', '475415', '476143', '476147', '476149', '548655',
        '548680', '549140', '549443', '549450', '549511', '549512', '550614', '550628', '550629', '553155', '553262',
        '553281', '553300', '553310', '553314', '555523', '556669', '556682', '557284', '557300', '558500', '558501',
        '558502', '558514', '558515', '558516', '559104', '559108', '559121', '559122', '559878', '559879', '559880',
        '560392', '560393', '560394', '560695', '560696', '560697', '561341', '561341', '561396', '561689', '561707',
        '562104', '562269', '562270', '563198', '563233', '563234', '563239', '563242', '563246', '563274', '563383',
        '563583', '563624', '564463', '564521', '564722', '564817', '564818', '564885', '564998', '565037', '565050',
        '565051', '565102', '565139', '565175', '568488', '568489', '568490', '568493', '568530', '568543', '568545',
        '568588', '569198', '569261', '569262', '569546', '569547', '570744', '570834', '571347', '571350', '571420',
        '571421', '571433', '571437', '571649', '571650', '571946', '572020', '572155', '572217', '573734', '573803',
        '574054', '574060', '574715', '575552', '575602', '575603', '575612', '575646', '575722', '575948', '575968',
        '576015', '576021', '576221', '576277', '576278', '576327', '576331', '577089', '577110', '578880', '578924',
        '579834', '579841', '580246', '580280', '580589', '580602', '580620', '580673', '580675', '580676', '580677',
        '580678', '580693', '580696', '580706', '580708', '580711', '580712', '580713', '580798', '580801', '581041',
        '581141', '581409', '581459', '581460', '581488', '581490', '581492', '581656', '581706', '581745', '581753',
        '581794', '581807', '581816', '581817', '581827', '582093', '582119', '582133', '582161', '582190', '582194',
        '582210', '582228', '582229', '582252', '582253', '583073', '583074', '583094', '583095', '583167', '583312',
        '583614', '583621', '583734', '583756', '583848', '584050', '584094', '584095', '584119', '584321', '584436',
        '584559', '584580', '585581', '585624', '585896', '586092', '586093', '586141', '586142', '586643', '586696',
        '586721', '586740', '586746', '586793', '586830', '586905', '586912', '587598', '587619', '587637', '587639',
        '587663', '587678', '587976', '588128', '588349', '588374', '588568', '588585', '588607', '589514', '589551',
        '590634', '590676', '591017', '591039', '591353', '591381', '591978', '592004', '592309', '592318', '592463',
        '592832', '592849', '593051', '593059', '593103', '593500', '593501', '593549', '593553', '593680', '593690',
        '594414', '594415', '594519', '594576', '594589', '595290', '595291', '595352', '595387', '595408', '595420',
        '595434', '595436', '595440', '595854', '595901', '595975', '595977', '596007',
    }


class PediatricVitamins(ValueSet):
    VALUE_SET_NAME = 'Pediatric Vitamins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '172878', '190623', '197825', '210337', '218832', '220857', '226431', '234459', '243135', '296012', '438430',
        '438434', '438440', '438455', '438464', '438483', '438490', '454454', '454454', '465727', '471987', '471987',
        '473722', '475077', '475078', '475415', '550614', '550628', '553300', '553310', '555523', '556669', '556682',
        '557284', '557300', '559104', '559108', '559121', '559122', '561396', '561689', '561707', '562104', '563198',
        '563233', '563234', '563239', '563242', '563246', '563274', '563583', '563624', '564463', '564521', '564817',
        '564818', '564885', '564998', '565050', '565051', '565102', '572155', '573734', '573803', '574715', '575552',
        '575602', '575603', '575948', '575968', '576015', '576021', '576221', '576277', '576278', '576327', '576331',
        '577089', '577110', '580246', '580280', '580589', '580602', '580620', '580673', '580678', '580693', '580696',
        '580706', '580708', '580801', '581041', '581141', '581409', '581706', '581745', '581753', '581794', '581816',
        '581817', '583734', '583756', '583848', '585581', '585624', '585896', '586643', '586740', '586746', '586793',
        '586830', '587598', '587619', '587663', '587976', '588128', '588568', '588585', '588607', '590634', '590676',
        '591978', '592004', '592309', '592318', '592463', '593680', '593690', '595408', '595420', '595434', '595436',
        '595854',
    }


class PediatricVitaminsAndMineralCombinations(ValueSet):
    VALUE_SET_NAME = 'Pediatric Vitamins and Mineral Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '171996', '181764', '185324', '191837', '204052', '211186', '218356', '230658', '244476', '284421', '288176',
        '438527', '438530', '438531', '438553', '445500', '450025', '452263', '452263', '476143', '476147', '476149',
        '548655', '548680', '549140', '549450', '549511', '550629', '553155', '553262', '553281', '553314', '561341',
        '561341', '565037', '565139', '565175', '570744', '570834', '571946', '572020', '572217', '574054', '574060',
        '575612', '575646', '578880', '578924', '579834', '579841', '580798', '582093', '582133', '582161', '582210',
        '582252', '582253', '583614', '583621', '584095', '584119', '584321', '584436', '584559', '584580', '586905',
        '586912', '587637', '588349', '588374', '591017', '591039', '592832', '592849', '593051', '593059', '593103',
        '594519', '595290', '595291', '595352', '595387', '595440', '595901', '595975',
    }


class PediatricVitaminsWithFluorideCombinations(ValueSet):
    VALUE_SET_NAME = 'Pediatric Vitamins with Fluoride Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '186334', '246539', '438626', '558500', '558501', '558502', '558514', '558515', '558516', '559878', '559879',
        '559880', '560392', '560393', '560394', '560695', '560696', '560697', '562269', '562270', '563383', '564722',
        '568488', '568489', '568490', '568493', '568530', '568543', '568545', '568588', '569198', '569261', '569262',
        '569546', '569547', '571347', '571350', '571420', '571421', '571433', '571437', '571649', '571650', '575722',
        '580675', '580676', '580677', '580711', '580712', '580713', '581459', '581460', '581488', '581490', '581492',
        '581656', '581807', '581827', '582119', '582190', '582194', '582228', '582229', '583073', '583074', '583094',
        '583095', '583167', '583312', '584050', '584094', '586092', '586093', '586141', '586142', '586696', '586721',
        '587639', '587678', '589514', '589551', '591353', '591381', '593500', '593501', '593549', '593553', '594414',
        '594415', '594576', '594589', '595977', '596007',
    }


class PediatricVitaminsWithFluorideAndMineralsCombinations(ValueSet):
    VALUE_SET_NAME = 'Pediatric Vitamins with Fluoride and Minerals Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '283428', '438704', '438719', '549443', '549512',
    }


class PrenatalVitaminsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Prenatal Vitamins and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '169843', '177197', '182571', '183402', '185553', '188486', '206271', '206364', '214515', '214962', '215493',
        '228709', '243312', '243407', '245973', '256240', '261325', '262108', '287331', '293707', '438759', '438765',
        '444984', '446892', '448138', '448759', '467402', '467615', '467897', '467898', '467899', '468302', '468361',
        '468365', '471086', '471094', '472944', '473265', '473270', '473552', '474170', '474388', '474563', '474877',
        '474884', '475239', '475245', '545683', '545683', '546559', '548053', '549669', '549717', '550687', '551115',
        '552467', '552926', '552928', '552930', '552965', '552965', '552966', '553461', '553474', '554259', '554870',
        '555704', '555938', '556177', '556292', '556327', '556355', '556461', '556602', '556673', '556693', '556703',
        '556880', '557052', '557121', '557354', '557374', '557375', '557390', '557457', '557476', '557497', '557787',
        '557821', '557992', '558133', '558136', '558150', '558151', '558182', '558212', '558315', '558354', '558558',
        '558752', '558753', '559205', '559269', '559464', '559490', '559638', '559726', '559727', '559982', '560079',
        '560218', '560220', '560222', '560238', '560333', '560334', '560335', '560336', '560384', '560708', '560741',
        '560743', '560780', '560803', '560887', '561005', '561007', '561096', '561306', '561328', '561356', '561374',
        '561481', '561528', '561544', '561663', '561677', '561692', '561705', '561766', '561849', '561851', '561863',
        '561956', '562128', '562284', '562295', '562304', '562353', '562355', '562541', '562548', '562589', '562609',
        '562612', '562678', '562679', '562682', '562688', '562778', '562785', '563020', '563139', '563178', '563180',
        '563190', '563193', '563363', '563854', '563865', '563915', '564172', '564200', '564290', '564296', '564302',
        '564322', '564339', '564345', '564418', '564477', '564492', '564510', '564550', '564599', '564660', '564702',
        '565077', '565099', '565333', '565362', '565377', '565386', '565404', '565443', '565470', '566480', '566507',
        '566652', '566684', '566898', '567022', '567336', '567928', '567928', '568577', '568678', '568704', '568859',
        '569002', '569065', '569258', '569434', '569443', '569583', '569720', '569831', '569839', '569861', '569963',
        '570009', '570011', '570012', '570269', '570663', '570748', '570784', '570846', '571080', '571294', '571299',
        '571415', '571858', '571859', '572301', '572334', '572338', '572354', '572369', '572374', '572376', '572479',
        '572545', '572752', '572752', '572760', '572874', '572889', '573103', '573164', '573261', '573389', '573640',
        '573663', '573696', '573764', '573870', '573883', '574076', '574223', '574235', '574271', '574548', '574552',
        '575295', '575583', '575682', '575708', '575739', '575744', '575773', '576090', '576132', '576145', '576270',
        '576397', '576480', '576508', '576687', '576716', '576739', '577296', '577889', '577890', '578506', '578558',
        '578648', '578648', '578746', '578746', '578754', '578770', '578798', '578798', '578798', '578807', '578851',
        '578857', '578860', '578876', '578879', '578879', '578879', '578909', '578910', '578922', '578923', '578928',
        '578929', '578961', '578991', '579003', '579005', '579017', '579033', '579215', '579246', '579374', '579398',
        '579684', '579808', '579811', '579812', '579818', '579819', '579821', '579823', '579824', '579845', '580210',
        '580241', '580322', '580336', '580360', '580361', '580660', '580857', '580894', '580894', '580913', '580928',
        '580998', '581004', '581052', '581208', '581273', '581307', '581334', '581381', '581441', '581511', '581522',
        '581559', '581580', '581593', '581605', '581616', '581623', '581624', '581638', '581667', '581671', '581696',
        '581701', '581702', '581847', '581853', '581856', '581861', '581878', '581888', '581892', '581957', '582028',
        '582029', '582031', '582055', '582139', '582268', '582270', '582334', '582335', '582336', '582338', '582659',
        '582665', '582667', '582668', '582680', '582745', '582761', '582842', '582865', '582872', '582906', '582983',
        '583011', '583020', '583130', '583260', '583280', '583699', '583722', '583900', '583909', '584537', '584779',
        '585084', '585116', '585568', '585648', '585675', '586046', '586109', '586117', '586178', '586207', '586680',
        '587036', '587038', '587088', '587120', '587302', '587315', '587532', '587562', '587570', '587788', '588160',
        '588166', '588167', '588170', '588171', '588199', '588493', '588577', '588605', '588759', '588820', '589006',
        '589053', '589201', '589232', '589677', '589730', '589743', '589822', '589887', '589963', '590088', '590115',
        '590468', '590812', '590820', '591728', '591943', '591961', '592130', '592180', '592703', '592707', '592824',
        '592852', '593091', '593161', '593428', '593438', '593700', '593901', '594348', '594350',
    }


class PrenatalVitaminsAndMinerals(ValueSet):
    VALUE_SET_NAME = 'Prenatal Vitamins and Minerals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '169843', '177197', '182571', '183402', '185553', '188486', '206271', '206364', '214515', '214962', '215493',
        '228709', '243312', '243407', '245973', '256240', '261325', '262108', '287331', '293707', '438759', '438765',
        '444984', '446892', '448138', '448759', '467402', '467615', '467897', '467898', '467899', '468302', '468361',
        '468365', '471086', '471094', '472944', '473265', '473270', '473552', '474170', '474388', '474563', '474877',
        '474884', '475239', '475245', '545683', '545683', '546559', '548053', '549669', '549717', '550687', '551115',
        '552467', '552926', '552928', '552930', '552965', '552965', '552966', '553461', '553474', '554259', '554870',
        '555704', '555938', '556177', '556292', '556327', '556355', '556461', '556602', '556673', '556693', '556703',
        '556880', '557052', '557121', '557354', '557374', '557375', '557390', '557457', '557476', '557497', '557787',
        '557821', '557992', '558133', '558136', '558150', '558151', '558182', '558212', '558315', '558354', '558558',
        '558752', '558753', '559205', '559269', '559464', '559490', '559638', '559726', '559727', '559982', '560079',
        '560218', '560220', '560222', '560238', '560333', '560334', '560335', '560336', '560384', '560708', '560741',
        '560743', '560780', '560803', '560887', '561005', '561007', '561096', '561306', '561328', '561356', '561374',
        '561481', '561528', '561544', '561663', '561677', '561692', '561705', '561766', '561849', '561851', '561863',
        '561956', '562128', '562284', '562295', '562304', '562353', '562355', '562541', '562548', '562589', '562609',
        '562612', '562678', '562679', '562682', '562688', '562778', '562785', '563020', '563139', '563178', '563180',
        '563190', '563193', '563363', '563854', '563865', '563915', '564172', '564200', '564290', '564296', '564302',
        '564322', '564339', '564345', '564418', '564477', '564492', '564510', '564550', '564599', '564660', '564702',
        '565077', '565099', '565333', '565362', '565377', '565386', '565404', '565443', '565470', '566480', '566507',
        '566652', '566684', '566898', '567022', '567336', '567928', '567928', '568577', '568678', '568704', '568859',
        '569002', '569065', '569258', '569443', '569583', '569720', '569831', '569839', '569861', '569963', '570009',
        '570011', '570012', '570269', '570663', '570748', '570784', '570846', '571080', '571294', '571299', '571415',
        '571859', '572301', '572334', '572338', '572354', '572369', '572374', '572376', '572479', '572545', '572752',
        '572752', '572760', '572874', '572889', '573103', '573261', '573389', '573640', '573663', '573696', '573764',
        '573870', '573883', '574076', '574223', '574235', '574271', '574548', '574552', '575295', '575682', '575708',
        '575739', '575744', '575773', '576090', '576132', '576145', '576270', '576397', '576480', '576508', '576687',
        '576716', '576739', '577296', '577889', '577890', '578506', '578558', '578648', '578648', '578746', '578746',
        '578754', '578770', '578798', '578798', '578798', '578807', '578851', '578857', '578860', '578876', '578879',
        '578879', '578879', '578909', '578910', '578922', '578923', '578928', '578929', '578961', '578991', '579003',
        '579005', '579017', '579033', '579215', '579246', '579374', '579398', '579684', '579808', '579811', '579812',
        '579818', '579819', '579821', '579823', '579824', '579845', '580210', '580241', '580360', '580361', '580660',
        '580857', '580894', '580894', '580913', '580928', '580998', '581004', '581052', '581208', '581273', '581307',
        '581334', '581381', '581441', '581511', '581522', '581559', '581580', '581593', '581605', '581616', '581623',
        '581624', '581638', '581667', '581671', '581696', '581701', '581702', '581847', '581853', '581856', '581861',
        '581878', '581888', '581892', '581957', '582028', '582029', '582031', '582055', '582139', '582268', '582270',
        '582334', '582335', '582336', '582338', '582659', '582665', '582667', '582668', '582680', '582745', '582761',
        '582842', '582865', '582872', '582906', '582983', '583011', '583020', '583130', '583260', '583280', '583699',
        '583722', '583900', '583909', '584537', '584779', '585084', '585116', '585568', '585648', '585675', '586046',
        '586109', '586117', '586178', '586207', '586680', '587036', '587038', '587088', '587120', '587302', '587315',
        '587532', '587562', '587570', '587788', '588160', '588166', '588167', '588170', '588171', '588199', '588493',
        '588577', '588605', '588759', '588820', '589006', '589053', '589201', '589232', '589677', '589730', '589743',
        '589822', '589887', '589963', '590088', '590115', '590468', '590812', '590820', '591728', '591943', '591961',
        '592130', '592180', '592703', '592707', '592824', '592852', '593091', '593161', '593428', '593438', '593700',
        '593901', '594348', '594350',
    }


class VitaminsWithHormones(ValueSet):
    VALUE_SET_NAME = 'Vitamins with Hormones'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class GeriatricVitamins(ValueSet):
    VALUE_SET_NAME = 'Geriatric Vitamins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150716', '154776', '167190', '187478', '196969', '261500', '264752', '267585', '276013', '278868', '281838',
        '438194', '444184', '445382', '445826', '451853', '452909', '453112', '473509', '473991', '550232', '555197',
        '556186', '561636', '564306', '570442', '570442', '571095', '572759', '572759', '585010', '585012',
    }


class MineralsAndElectrolytes(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150618', '150618', '150748', '153309', '153600', '153600', '154039', '154473', '154615', '155333', '155631',
        '158547', '159747', '160304', '160674', '161277', '162237', '162237', '162484', '162484', '162484', '163262',
        '163888', '164048', '164063', '164063', '164063', '164507', '164572', '164810', '164892', '164892', '166468',
        '166942', '167385', '167385', '168588', '168592', '168892', '168970', '169520', '169520', '170601', '171643',
        '172639', '172806', '172898', '174318', '175160', '176238', '176332', '176332', '176524', '176524', '176691',
        '176691', '176691', '176789', '176817', '178603', '178603', '178961', '179461', '179642', '179808', '179808',
        '179808', '180105', '180444', '180681', '180681', '180681', '180681', '181763', '182949', '182949', '183148',
        '183160', '183160', '183160', '183293', '183810', '183820', '184028', '184028', '184028', '185605', '185605',
        '185793', '185915', '186885', '187000', '187168', '188671', '188705', '188846', '188902', '189423', '190788',
        '190788', '192714', '192714', '194348', '195609', '196078', '196639', '197180', '199188', '199535', '199705',
        '199705', '201489', '201557', '201823', '201847', '202544', '202694', '202913', '203230', '203317', '203858',
        '205160', '207087', '208255', '208692', '209245', '209245', '209889', '211081', '211112', '211191', '211191',
        '211359', '211950', '212562', '212663', '212663', '213462', '213462', '213462', '213462', '214003', '214437',
        '214877', '214877', '214916', '216138', '216631', '216920', '218985', '219384', '219625', '220772', '221105',
        '221635', '221635', '221732', '221732', '222115', '222438', '222847', '223106', '223277', '223280', '224168',
        '224408', '224452', '224452', '224660', '225364', '225946', '226181', '226209', '226591', '227123', '227123',
        '227123', '227123', '227123', '227123', '227123', '227123', '227123', '227187', '227195', '227195', '227195',
        '227218', '228656', '228695', '229915', '230648', '231382', '231550', '233534', '233586', '235037', '235037',
        '236485', '236637', '236844', '238507', '238507', '239813', '239813', '239934', '239934', '243158', '243449',
        '243701', '243814', '245379', '245555', '245610', '246213', '246995', '247289', '247735', '247924', '248073',
        '248073', '248420', '248588', '250038', '250389', '252389', '253019', '255125', '255125', '255638', '256514',
        '256514', '257161', '257161', '257161', '257379', '257824', '257834', '258470', '259146', '259796', '260365',
        '260374', '260460', '260460', '261470', '261470', '262156', '264076', '264265', '264514', '265147', '265147',
        '267091', '267375', '267440', '267666', '267666', '267692', '268298', '268777', '269146', '270145', '270184',
        '270573', '270573', '270857', '272361', '272899', '273577', '273577', '273866', '274885', '275169', '275444',
        '276744', '277896', '277992', '278542', '278542', '278542', '278542', '278542', '278542', '278542', '278916',
        '278916', '278916', '279231', '279291', '279291', '279323', '279975', '279975', '280982', '280982', '281420',
        '282457', '282457', '283668', '285245', '286030', '286425', '286729', '288244', '290442', '291778', '292879',
        '292879', '293631', '293631', '294201', '295646', '295655', '295992', '295992', '296351', '296351', '296351',
        '296493', '296943', '297148', '298397', '298965', '299389', '400052', '400115', '400120', '400121', '400255',
        '400262', '400262', '400296', '401058', '401064', '438900', '438903', '438905', '438914', '438989', '438997',
        '439017', '439020', '439088', '439121', '439183', '439245', '439812', '439819', '439846', '444102', '444164',
        '444179', '444195', '444206', '444550', '445041', '445117', '445193', '445194', '445363', '445387', '445442',
        '445456', '445557', '445558', '445568', '445907', '445910', '445945', '445995', '446078', '446078', '446149',
        '446150', '446151', '446210', '446432', '446455', '446461', '446574', '446655', '447616', '448345', '448505',
        '448515', '448903', '448946', '449380', '449547', '449969', '450051', '450060', '450313', '450437', '450746',
        '450948', '450949', '450979', '450979', '450979', '450979', '450979', '450991', '451000', '451061', '451128',
        '451130', '451175', '451232', '451441', '451442', '451518', '451528', '451557', '451670', '452474', '453155',
        '453429', '453480', '453580', '454438', '454517', '464547', '465830', '467303', '467304', '467796', '467873',
        '467873', '467873', '467874', '467876', '467876', '467883', '467947', '468294', '468297', '468466', '469657',
        '470937', '470947', '471600', '471602', '471892', '471893', '472664', '472908', '472909', '472910', '472911',
        '472912', '472913', '472914', '472915', '472916', '472917', '472918', '472919', '472922', '473129', '473199',
        '473328', '473328', '473558', '473769', '473831', '473905', '473962', '474023', '474048', '474052', '474081',
        '474184', '474212', '474215', '474235', '474598', '474742', '474743', '474744', '474745', '474996', '474996',
        '475001', '475045', '475210', '475210', '475222', '475308', '475364', '475365', '475399', '475407', '475449',
        '475660', '475957', '475977', '475981', '475987', '476165', '476165', '476168', '476170', '476171', '476182',
        '476193', '476343', '476346', '476346', '476467', '476467', '476469', '476469', '476685', '545082', '545856',
        '545947', '546168', '546169', '546197', '546201', '546202', '546203', '546273', '547609', '547991', '548211',
        '548226', '549139', '549188', '549189', '549451', '549883', '550469', '550515', '550524', '550525', '550526',
        '550713', '550725', '550817', '550817', '550915', '550916', '551018', '551019', '551020', '551059', '551060',
        '551061', '551099', '551224', '551536', '551606', '551990', '551990', '552052', '552181', '552182', '552183',
        '552184', '552227', '552307', '552438', '552588', '552588', '552599', '552668', '552760', '552764', '552765',
        '552765', '552771', '553025', '553388', '553434', '553436', '553587', '553592', '553597', '553675', '553730',
        '553743', '553855', '553877', '553877', '553878', '553879', '553913', '554385', '554520', '554554', '554650',
        '554658', '554866', '554880', '554938', '554943', '554977', '555079', '555099', '555148', '555591', '555592',
        '555695', '555705', '555711', '555992', '556013', '556063', '556071', '556086', '556087', '556092', '556094',
        '556514', '556585', '556589', '556649', '556864', '556892', '556895', '556903', '556934', '556941', '557008',
        '557008', '557021', '557021', '557150', '557154', '557212', '557230', '557365', '557454', '557477', '557492',
        '557554', '557598', '557646', '557651', '557660', '557743', '557805', '557815', '557830', '557839', '557857',
        '557871', '558000', '558000', '558012', '558013', '558014', '558028', '558029', '558030', '558041', '558287',
        '558292', '558329', '558349', '558350', '558485', '558548', '558560', '558592', '558669', '558674', '558689',
        '558746', '558754', '558759', '558778', '558786', '559009', '559220', '559268', '559389', '559407', '559463',
        '559471', '559571', '559571', '559601', '559601', '559624', '559655', '559857', '559906', '559920', '559976',
        '560078', '560087', '560125', '560133', '560148', '560352', '560374', '560381', '560397', '560409', '560423',
        '560534', '560542', '560554', '560617', '560675', '560684', '560760', '560761', '560834', '560836', '560841',
        '560846', '560890', '560925', '560963', '560988', '561002', '561026', '561038', '561051', '561060', '561086',
        '561223', '561281', '561305', '561340', '561342', '561347', '561369', '561388', '561473', '561609', '561858',
        '561858', '561880', '561882', '561905', '561906', '561971', '562117', '562148', '562168', '562265', '562525',
        '562526', '562530', '562531', '562774', '562784', '562931', '562933', '563117', '563145', '563146', '563151',
        '563187', '563192', '563197', '563202', '563213', '563249', '563268', '563268', '563303', '563333', '563344',
        '563346', '563354', '563516', '563517', '563531', '563531', '563544', '563544', '563570', '563571', '563678',
        '563684', '563752', '563773', '563945', '564036', '564084', '564115', '564142', '564199', '564291', '564314',
        '564333', '564335', '564357', '564557', '564560', '564572', '564597', '564598', '564699', '564815', '564872',
        '564999', '565079', '565601', '565871', '565893', '565894', '565925', '566835', '567145', '567335', '567505',
        '567511', '567589', '567669', '568553', '568558', '568586', '568645', '568972', '569004', '569437', '569487',
        '570002', '570002', '570315', '570349', '570423', '570671', '570691', '570919', '570998', '571085', '571776',
        '571776', '571793', '572163', '572373', '572573', '572577', '572641', '572645', '572655', '572691', '572719',
        '572755', '572892', '572897', '573075', '573251', '573299', '573633', '573842', '573863', '573865', '573880',
        '573955', '574264', '574693', '575019', '575062', '575110', '575147', '575172', '575202', '575204', '575209',
        '575226', '575227', '575232', '575233', '575243', '575283', '575350', '575574', '575636', '575721', '575732',
        '575763', '575781', '575782', '576034', '576035', '576037', '576046', '576202', '576237', '576337', '576578',
        '576622', '576626', '576635', '577002', '577527', '577564', '577603', '577692', '578392', '578551', '578877',
        '578890', '578952', '578952', '578993', '579055', '579061', '579082', '579134', '579354', '579359', '579364',
        '579526', '579564', '579737', '579750', '579837', '579856', '579864', '579874', '579953', '579977', '579988',
        '579992', '580008', '580139', '580141', '580473', '580536', '580540', '580671', '580704', '580759', '580767',
        '580772', '580868', '580909', '580975', '581047', '581154', '581162', '581321', '581333', '581403', '581485',
        '581539', '581697', '582087', '582101', '582195', '582319', '582329', '582330', '582345', '582585', '582626',
        '582899', '582929', '583198', '583330', '583346', '583510', '583511', '583547', '583575', '583986', '584144',
        '584730', '584734', '584736', '584737', '584738', '584739', '584740', '584741', '584886', '584967', '585985',
        '586130', '586139', '586166', '586167', '586168', '586560', '586628', '586720', '586819', '586871', '586880',
        '586898', '586913', '586922', '587142', '587177', '587194', '587195', '587283', '587291', '587313', '587342',
        '587451', '587461', '587483', '587590', '587608', '587651', '587815', '587986', '588015', '589050', '589104',
        '589846', '590136', '590355', '590369', '590386', '590573', '590574', '590646', '590647', '590728', '590732',
        '590882', '590961', '591032', '591049', '591298', '591395', '591548', '591554', '591614', '591639', '591697',
        '592096', '592111', '592166', '592218', '592565', '592599', '592732', '592799', '592802', '593003', '593122',
        '593159', '593329', '593331', '593770', '593806', '594004', '594047', '594134', '594205', '594411', '594510',
        '594614', '594645', '594663', '594691', '594692', '594702', '594703', '594738', '594739', '594740', '594741',
        '594767', '594818', '594827', '594956', '594957', '594961', '595062', '595079', '595153', '595546', '595574',
        '595824', '596008',
    }


class MineralsAndElectrolytesBicarbonateProducingOrContainingAgents(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Bicarbonate Producing or Containing Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '172898', '176691', '176691', '176691', '203858', '213462', '213462', '213462', '213462', '219625', '235037',
        '235037', '262156', '267440', '445117', '445363', '445557', '445558', '563344', '563346', '572577', '594134',
    }


class MineralsAndElectrolytesCalciumReplacement(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Calcium Replacement'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158547', '183148', '201847', '202544', '220772', '225364', '226209', '227195', '227195', '227195', '229915',
        '236637', '252389', '267375', '286425', '295655', '438900', '438903', '438905', '438914', '444102', '444550',
        '451670', '453480', '454517', '473328', '473328', '476193', '550515', '554943', '555079', '555099', '555148',
        '557212', '557743', '558746', '559009', '560542', '560684', '560834', '560925', '560963', '560988', '561305',
        '561340', '561882', '561905', '562931', '562933', '564084', '570998', '572641', '576046', '590732', '594691',
        '594692', '594702', '594703', '594738', '594739', '594740',
    }


class MineralsAndElectrolytesCalciumReplacementCombinations(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Calcium Replacement Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '222438', '248588', '285245', '400052', '445907', '445910', '445995', '448345', '448505', '448903', '451061',
        '451528', '451557', '453155', '453580', '464547', '473199', '475210', '475210', '475222', '548211', '548226',
        '549451', '549883', '550725', '551061', '551224', '551606', '552227', '553730', '553743', '554650', '554658',
        '554938', '554977', '555695', '555711', '556903', '557008', '557008', '557021', '557021', '557815', '557871',
        '558329', '558350', '558689', '558759', '559220', '559268', '559906', '559920', '560148', '560397', '560534',
        '560554', '560617', '560836', '560890', '561223', '561281', '561342', '561347', '561369', '561388', '563197',
        '564333', '564335', '564357', '564815', '564872', '568558', '568586', '570671', '570691', '572655', '572691',
        '575721', '575732', '575763', '575781', '575782', '576578', '576626', '578993', '579061', '579992', '580008',
        '580139', '580473', '580909', '581333', '581485', '581539', '582195', '582319', '582329', '586139', '586166',
        '586167', '586168', '587142', '587177', '587608', '587651', '590573', '590574', '590646', '590647', '590961',
        '591554', '594510', '594614',
    }


class MineralsAndElectrolytesIodine(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Iodine'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150618', '150618', '162484', '162484', '162484', '221732', '221732', '230648', '259796', '261470', '261470',
        '281420', '445193', '445194', '451128', '451130', '563678', '573251', '573299',
    }


class MineralsAndElectrolytesIodineCombinations(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Iodine Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MineralsAndElectrolytesMagnesium(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Magnesium'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153309', '163888', '164048', '179461', '180681', '180681', '180681', '180681', '222115', '223106', '224168',
        '236485', '245379', '247924', '256514', '256514', '267692', '275444', '288244', '298397', '439088', '445568',
        '446574', '450437', '468297', '472664', '472908', '472909', '472910', '472911', '472912', '472913', '472914',
        '472915', '472916', '472917', '472918', '472919', '472922', '473905', '474742', '474743', '474744', '474745',
        '545947', '549188', '549189', '550526', '550915', '550916', '552052', '552181', '552182', '552183', '552184',
        '553434', '553436', '553855', '553877', '553877', '553878', '553879', '554880', '555705', '556892', '557492',
        '557660', '557805', '557830', '559407', '559976', '560846', '561906', '562117', '562148', '562168', '563151',
        '564142', '567145', '570919', '573633', '575226', '575227', '575350', '576202', '576237', '580868', '586720',
        '586819', '589846', '591395', '591639', '591697', '592565', '592599', '594205', '594411', '594645', '594827',
    }


class MineralsAndElectrolytesMagnesiumCombinations(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Magnesium Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '183293', '202913',
    }


class MineralsAndElectrolytesManganese(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Manganese'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '175160', '286030',
    }


class MineralsAndElectrolytesPhosphate(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Phosphate'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164063', '164063', '164063', '278916', '278916', '278916', '446432', '553388', '563145', '563146', '563303',
        '565925', '570423', '572892', '572897', '573863', '590136', '590728', '591298', '594004', '594047', '594767',
    }


class MineralsAndElectrolytesPotassium(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Potassium'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155333', '159747', '162237', '162237', '164810', '166468', '166942', '168588', '168592', '170601', '176524',
        '176524', '176789', '180444', '185605', '185605', '185793', '185915', '192714', '192714', '199188', '199705',
        '199705', '201823', '212663', '212663', '214877', '214877', '216138', '216631', '221105', '221635', '221635',
        '222847', '223280', '226181', '227187', '228656', '233534', '233586', '236844', '248073', '248073', '250389',
        '253019', '257161', '257161', '257161', '257824', '267666', '267666', '270145', '270573', '270573', '272899',
        '275169', '291778', '296351', '296351', '296351', '439121', '449969', '450051', '450060', '450979', '450979',
        '450979', '450979', '450979', '451441', '451442', '451518', '552438', '552588', '552588', '552599', '552764',
        '552765', '552765', '567335', '572373', '572573', '572645', '573075', '579564', '579953', '580767', '581162',
        '583510', '583511', '586130', '587194', '587195', '594961',
    }


class MineralsAndElectrolytesPotassiumCombinations(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Potassium Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154615',
    }


class MineralsAndElectrolytesSodiumChloride(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Sodium Chloride'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '188705', '476685',
    }


class MineralsAndElectrolytesZinc(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Zinc'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160304', '164572', '189423', '211950', '218985', '224408', '227218', '260374', '264076', '264265', '267091',
        '268298', '270857', '272361', '296943', '400120', '439183', '452474', '546197', '556589', '557598', '558485',
        '587313', '587342', '594818', '594957',
    }


class MineralsAndElectrolytesZincCombinations(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Zinc Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '450948', '450949', '467303', '467304', '476467', '476467', '476469', '476469', '557230',
    }


class MineralsAndElectrolytesTraceMineralsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Trace Minerals and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153600', '153600', '154473', '155631', '161277', '187000', '194348', '199535', '208692', '211081', '211112',
        '211191', '211191', '225946', '226591', '228695', '246213', '247735', '255125', '255125', '255638', '259146',
        '269146', '294201', '295992', '295992', '297148', '400121', '445041', '447616', '448515', '450313', '557454',
        '558778', '558786', '561971', '564699', '565893', '565894', '572163', '573842', '573865', '573955', '575574',
        '575636', '590355', '590369',
    }


class MineralsAndElectrolytesTraceMinerals(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Trace Minerals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155631', '161277', '187000', '194348', '208692', '211081', '211112', '225946', '255638', '259146', '269146',
        '297148', '400121', '450313', '557454', '558778', '558786', '561971', '564699', '572163', '573865',
    }


class MineralsAndElectrolytesTraceMineralCombinations(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Trace Mineral Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153600', '153600', '154473', '199535', '211191', '211191', '226591', '228695', '246213', '247735', '255125',
        '255125', '294201', '295992', '295992', '445041', '447616', '448515', '565893', '565894', '573842', '573955',
        '575574', '575636', '590355', '590369',
    }


class MineralsAndElectrolytesElectrolytesAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Electrolytes and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164892', '164892', '167385', '167385', '169520', '169520', '172806', '176332', '176332', '176817', '178603',
        '178603', '179642', '179808', '179808', '179808', '180105', '183160', '183160', '183160', '183810', '183820',
        '184028', '184028', '184028', '188902', '190788', '190788', '202694', '203317', '209245', '209245', '214437',
        '224452', '224452', '224660', '227123', '227123', '227123', '227123', '227123', '227123', '227123', '227123',
        '227123', '231382', '238507', '238507', '239934', '239934', '245610', '250038', '258470', '260460', '260460',
        '264514', '265147', '265147', '273577', '273577', '278542', '278542', '278542', '278542', '278542', '278542',
        '278542', '279231', '280982', '280982', '282457', '282457', '292879', '292879', '293631', '293631', '439245',
        '468466', '476165', '476165', '476168', '476170', '476171', '476182', '476343', '476346', '476346', '545082',
        '549139', '550524', '550525', '550817', '550817', '551018', '551019', '551020', '556514', '556585', '557150',
        '557154', '558287', '558292', '559571', '559571', '559601', '559601', '560409', '560423', '563752', '570002',
        '570002', '570315', '570349', '579526', '582330', '582345', '584730', '584734', '584736', '584737', '584738',
        '584739', '584740', '584741', '584886', '584967', '592096', '592111', '592166', '592218', '594663', '594956',
    }


class MineralsAndElectrolytesOralElectrolytes(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Oral Electrolytes'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '184028', '184028', '184028', '190788', '190788', '214437', '227123', '227123', '227123', '227123', '227123',
        '227123', '227123', '227123', '227123', '245610', '265147', '265147', '278542', '278542', '278542', '278542',
        '278542', '278542', '278542', '439245', '476165', '476165', '476168', '476170', '476171', '476182', '476343',
        '476346', '476346', '545082', '549139', '550524', '550525', '556514', '556585', '557150', '557154', '558287',
        '558292', '559571', '559571', '559601', '559601', '560409', '560423', '563752', '570002', '570002', '570315',
        '570349', '579526', '582330', '582345', '584730', '584734', '584736', '584737', '584738', '584739', '584740',
        '584741', '584886', '584967', '592096', '592111', '592166', '592218', '594663', '594956',
    }


class MineralsAndElectrolytesParenteralElectrolyteCombinations(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Parenteral Electrolyte Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164892', '164892', '169520', '169520', '172806', '176817', '179642', '188902', '209245', '209245', '224452',
        '224452', '231382', '238507', '238507', '239934', '239934', '250038', '260460', '260460', '280982', '280982',
        '282457', '282457', '292879', '292879', '293631', '293631', '550817', '550817', '551018', '551019', '551020',
    }


class MineralsAndElectrolytesElectrolytesAndDextrose(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Electrolytes and Dextrose'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '167385', '167385', '176332', '176332', '178603', '178603', '179808', '179808', '179808', '180105', '183160',
        '183160', '183160', '183810', '183820', '202694', '203317', '224660', '258470', '264514', '273577', '273577',
        '279231', '468466',
    }


class MineralsAndElectrolytesElectrolytesAndInvertSugar(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Electrolytes and Invert Sugar'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MineralsAndElectrolytesElectrolytesAndFructose(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Electrolytes and Fructose'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class NutritionalProductCarbohydrates(ValueSet):
    VALUE_SET_NAME = 'Nutritional Product - Carbohydrates'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '217364', '217364', '555785', '569086', '578954', '578954', '578966', '578966', '593055', '593095',
    }


class NutritionalProductLipids(ValueSet):
    VALUE_SET_NAME = 'Nutritional Product - Lipids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '258616', '286152', '286152', '453694', '577599', '581798', '581798', '581799', '581970', '581974', '581974',
        '583223', '583224', '585977', '589984', '590061',
    }


class NutritionalProductFattyAcids(ValueSet):
    VALUE_SET_NAME = 'Nutritional Product - Fatty Acids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class NutritionalProductProteins(ValueSet):
    VALUE_SET_NAME = 'Nutritional Product - Proteins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160040', '160825', '164359', '165870', '165870', '165870', '169602', '170602', '184047', '188500', '196280',
        '203352', '210291', '210708', '210708', '210708', '212068', '217501', '233635', '239448', '240339', '241220',
        '241220', '241220', '241838', '242599', '244599', '247555', '247555', '247555', '247555', '247555', '247555',
        '247555', '265196', '277929', '277986', '281703', '282830', '283273', '285781', '285781', '285781', '286037',
        '287565', '288787', '401001', '401117', '401117', '439350', '439357', '445049', '445368', '450133', '454257',
        '454258', '454418', '454431', '465584', '467497', '467602', '471720', '471721', '471729', '471730', '473617',
        '475235', '545201', '546105', '546106', '548553', '548593', '549661', '550585', '550770', '551582', '553255',
        '553255', '553255', '553255', '553501', '553513', '553662', '554182', '554182', '554182', '554182', '554182',
        '554183', '554183', '554186', '554186', '554186', '554186', '554728', '554728', '554729', '554729', '555758',
        '555758', '555786', '557105', '557733', '557753', '557755', '557771', '557776', '557786', '557786', '557793',
        '557803', '558789', '558792', '559117', '559555', '560198', '560198', '560198', '560329', '561405', '561405',
        '561410', '561410', '562163', '562170', '562174', '562183', '562191', '562192', '562287', '562287', '562508',
        '562740', '570670', '571485', '571490', '571491', '571531', '571792', '571792', '571792', '571826', '571826',
        '571827', '571828', '571829', '572611', '573224', '573264', '574275', '574331', '574503', '574503', '574747',
        '574808', '574809', '574826', '574827', '574910', '574936', '574937', '574938', '575012', '575122', '575523',
        '575624', '575630', '575631', '575634', '575635', '575637', '575664', '575696', '575697', '575709', '576894',
        '576896', '576899', '576903', '576933', '577030', '577047', '577048', '577088', '577127', '577365', '577398',
        '577411', '577415', '577543', '577605', '577947', '577968', '578197', '578300', '578548', '578740', '578740',
        '578740', '578740', '578743', '578743', '578743', '578743', '578956', '578957', '579056', '579077', '579362',
        '579363', '579372', '579373', '580193', '580656', '580838', '581014', '581039', '581069', '581164', '581227',
        '581635', '581831', '581835', '582188', '582227', '582275', '582380', '582381', '582382', '582663', '582679',
        '582790', '582810', '582936', '582965', '582966', '583801', '583893', '583921', '585154', '585926', '585991',
        '586732', '586804', '586805', '586810', '586811', '586980', '586990', '587284', '587294', '587306', '587312',
        '587725', '587786', '588207', '589928', '589961', '590070', '590143', '590380', '590407', '592388', '592595',
        '592672', '592742', '592751', '592864', '593226', '593230', '593278', '593281', '593290', '593291', '593296',
        '593341', '594401', '594443', '594693', '594694', '594817', '594833', '594973',
    }


class NutritionalProductProteinReplacements(ValueSet):
    VALUE_SET_NAME = 'Nutritional Product - Protein Replacements'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165870', '165870', '165870', '241220', '241220', '241220', '244599', '247555', '247555', '247555', '247555',
        '247555', '247555', '247555', '277986', '285781', '285781', '285781', '445049', '445368', '454257', '454258',
        '454418', '454431', '465584', '467497', '467602', '475235', '549661', '551582', '553255', '553255', '553255',
        '553255', '553501', '553513', '554182', '554182', '554182', '554182', '554182', '554183', '554183', '554186',
        '554186', '554186', '554186', '554728', '554728', '554729', '554729', '555786', '557753', '557755', '557776',
        '557786', '557786', '557803', '560198', '560198', '560198', '561405', '561405', '561410', '561410', '562508',
        '571485', '571490', '571491', '571531', '573224', '573264', '574275', '574331', '574747', '574808', '574809',
        '574826', '574827', '574910', '574936', '574937', '574938', '575012', '575624', '575630', '575631', '575634',
        '575635', '575637', '575696', '575697', '575709', '576933', '577030', '577047', '577048', '577088', '577127',
        '577365', '577398', '577411', '577415', '577543', '577605', '578197', '578300', '578548', '578740', '578740',
        '578740', '578740', '578743', '578743', '578743', '578743', '578956', '578957', '579056', '579077', '579362',
        '579363', '579372', '579373', '580656', '580838', '581014', '581039', '581227', '581635', '581831', '581835',
        '582188', '582227', '582275', '582380', '582381', '582382', '582663', '582679', '582790', '582810', '583801',
        '583893', '585926', '585991', '586804', '586805', '586810', '586811', '586980', '586990', '587284', '587294',
        '587306', '587312', '587725', '587786', '588207', '589928', '589961', '590380', '590407', '592388', '592742',
        '594694', '594817',
    }


class NutritionalProductParenteralAndOtherAminoAcids(ValueSet):
    VALUE_SET_NAME = 'Nutritional Product - Parenteral and other Amino Acids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160040', '160825', '164359', '169602', '170602', '184047', '188500', '196280', '203352', '210291', '210708',
        '210708', '210708', '212068', '217501', '233635', '239448', '240339', '241838', '242599', '265196', '277929',
        '281703', '282830', '283273', '286037', '287565', '288787', '401001', '401117', '401117', '439350', '439357',
        '450133', '471720', '471721', '471729', '471730', '473617', '545201', '546105', '546106', '548553', '548593',
        '550585', '550770', '553662', '555758', '555758', '557105', '557733', '557771', '557793', '558789', '558792',
        '559117', '559555', '560329', '562163', '562170', '562174', '562183', '562191', '562192', '562287', '562287',
        '562740', '570670', '571792', '571792', '571792', '571826', '571826', '571827', '571828', '571829', '572611',
        '574503', '574503', '575122', '575523', '575664', '576894', '576896', '576899', '576903', '577947', '577968',
        '580193', '581069', '581164', '582936', '582965', '582966', '583921', '585154', '586732', '590070', '590143',
        '592595', '592672', '592751', '592864', '593226', '593230', '593278', '593281', '593290', '593291', '593296',
        '593341', '594401', '594443', '594693', '594833', '594973',
    }


class AntihyperlipidemicAgentsDietarySourceAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihyperlipidemic Agents - Dietary Source and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '168953', '169018', '170255', '180691', '187647', '202334', '231982', '250293', '284793', '295035', '299576',
        '299603', '439440', '439452', '439455', '449815', '449950', '450258', '453061', '466583', '470914', '470934',
        '471105', '472769', '474054', '475684', '476780', '545137', '545180', '546661', '546679', '546683', '546793',
        '546813', '546868', '546874', '546890', '550543', '550560', '551389', '551891', '552800', '552805', '552828',
        '552901', '552931', '552938', '553071', '554706', '554726', '555694', '555706', '557147', '557161', '557578',
        '557607', '557807', '557814', '557836', '558286', '558299', '558768', '558790', '558803', '559163', '559446',
        '559452', '559952', '560123', '560268', '560626', '560700', '561398', '561761', '561770', '562027', '562047',
        '562236', '562487', '562503', '562964', '563043', '563189', '563229', '563230', '563272', '563336', '563365',
        '563416', '563419', '563427', '563495', '563529', '564038', '564052', '564071', '564104', '564540', '564581',
        '564730', '564819', '564828', '564918', '565043', '565113', '565189', '565255', '565574', '565701', '565718',
        '567099', '568542', '568627', '568983', '569131', '570097', '570212', '570727', '570883', '572218', '572258',
        '572650', '572682', '572999', '573013', '573252', '573296', '573323', '573391', '573564', '573744', '573809',
        '573815', '573866', '573876', '573879', '573911', '574000', '574050', '574101', '575188', '575206', '575207',
        '575988', '576233', '577359', '577394', '577406', '577410', '577576', '577609', '577653', '577730', '578096',
        '578167', '578908', '579006', '579121', '579176', '579395', '579660', '579661', '579662', '579671', '579672',
        '579673', '579752', '580009', '580214', '580239', '580250', '580341', '580889', '581538', '581573', '581620',
        '581631', '581655', '581901', '583146', '583147', '583153', '583154', '583212', '583221', '583278', '583282',
        '583836', '584001', '584253', '584539', '585082', '585083', '585132', '585133', '585305', '585434', '585469',
        '585546', '585547', '585737', '585799', '586685', '586748', '586774', '586854', '586935', '586988', '587005',
        '587259', '587347', '587520', '587567', '587575', '587593', '587948', '588147', '588619', '591731', '591928',
        '591950', '592100', '592199', '592337', '592380', '592803', '593012', '593260', '593442', '593550', '593714',
        '593790', '593880', '593922', '594046', '594220', '594494', '594513', '594638', '594737', '594769', '594959',
    }


class AntihyperlipidemicAgentsDietarySourceCombinations(ValueSet):
    VALUE_SET_NAME = 'Antihyperlipidemic Agents - Dietary Source Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '168953', '170255', '187647', '231982', '250293', '295035', '439452', '453061', '466583', '471105', '545137',
        '545180', '546661', '546679', '546683', '546793', '546813', '546868', '546874', '546890', '550543', '550560',
        '551891', '552800', '552805', '552901', '552931', '552938', '553071', '554706', '554726', '557147', '557161',
        '557578', '557607', '557807', '557814', '557836', '558286', '558299', '558768', '558790', '558803', '559163',
        '559446', '559452', '559952', '560268', '560626', '561761', '561770', '562027', '562047', '562236', '562487',
        '562503', '563043', '563189', '563229', '563230', '563272', '563336', '563416', '563419', '563427', '563495',
        '563529', '564038', '564052', '564540', '564581', '564730', '564819', '564828', '564918', '565043', '565113',
        '565189', '565255', '565574', '565701', '565718', '567099', '568542', '568627', '568983', '569131', '570097',
        '570212', '570727', '572218', '572258', '572650', '572682', '572999', '573013', '573323', '573391', '573564',
        '573744', '573809', '573866', '573876', '573879', '573911', '574000', '574050', '574101', '575188', '575207',
        '576233', '577406', '577576', '577609', '577653', '577730', '578096', '578167', '578908', '579006', '579121',
        '579176', '579395', '579660', '579661', '579662', '579671', '579672', '579673', '580009', '580214', '580239',
        '580250', '580341', '581538', '581573', '581620', '581631', '581655', '581901', '583146', '583147', '583153',
        '583154', '583212', '583221', '583278', '583282', '583836', '584001', '584253', '584539', '585082', '585083',
        '585132', '585133', '585305', '585434', '585469', '585546', '585547', '585799', '586685', '586748', '586774',
        '586854', '586935', '586988', '587005', '587259', '587347', '587520', '587567', '587575', '587593', '587948',
        '588147', '588619', '591731', '592100', '592199', '592337', '592380', '592803', '593012', '593442', '593550',
        '593714', '593790', '593880', '593922', '594046', '594513', '594638', '594737', '594769', '594959',
    }


class DietaryProducts(ValueSet):
    VALUE_SET_NAME = 'Dietary Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150265', '151386', '152205', '154369', '157617', '162913', '164792', '165942', '168914', '169559', '170957',
        '178625', '178625', '178625', '178625', '178625', '178744', '178744', '179537', '182267', '182267', '182267',
        '182432', '182500', '188457', '190802', '199814', '200661', '209037', '213262', '213852', '213852', '213852',
        '235624', '242937', '244802', '247604', '252870', '253795', '259532', '259532', '262638', '262673', '264532',
        '265456', '267967', '268048', '268818', '270458', '272411', '272823', '272823', '273332', '273332', '273332',
        '273332', '273332', '273332', '276211', '276342', '276342', '282508', '292871', '294984', '294984', '297551',
        '439530', '439547', '443559', '443559', '443559', '443559', '443559', '443559', '443559', '443560', '443560',
        '443560', '443561', '443561', '443862', '443863', '445059', '445059', '445061', '445062', '445062', '445069',
        '445070', '445405', '445406', '445406', '445406', '445408', '445410', '445410', '445410', '446308', '446310',
        '446318', '446320', '446320', '446320', '446320', '446787', '448153', '448287', '448511', '448720', '448720',
        '448721', '448722', '448722', '449495', '450145', '450149', '451353', '452903', '453487', '464377', '465871',
        '470988', '472545', '472546', '472546', '473021', '473021', '473041', '473041', '474290', '474630', '474794',
        '474794', '474900', '474927', '474932', '474941', '474943', '475084', '475179', '475227', '476390', '545083',
        '545138', '545138', '545138', '545139', '545157', '545783', '545797', '549813', '549816', '549816', '549985',
        '549985', '550053', '550125', '550470', '550480', '550597', '550871', '550911', '551683', '552087', '552348',
        '553277', '553295', '553326', '553481', '553666', '554755', '554761', '554802', '554895', '555192', '555192',
        '555192', '555212', '555241', '555284', '555284', '555284', '555586', '555605', '555821', '555821', '555995',
        '555995', '556348', '556359', '556368', '556371', '556410', '556417', '556532', '556532', '556701', '556954',
        '556970', '557290', '557297', '557682', '557682', '557801', '557802', '557843', '557844', '557867', '557889',
        '558034', '558034', '558034', '558058', '558058', '558058', '558092', '558120', '558442', '558442', '558443',
        '558443', '558443', '558443', '558444', '558444', '558556', '558562', '558692', '558795', '558801', '559762',
        '559856', '559907', '559907', '559907', '559908', '559908', '559908', '559908', '559927', '559943', '559943',
        '559946', '559946', '560129', '560130', '560142', '560143', '560371', '560372', '560805', '560808', '560808',
        '560810', '560818', '560819', '560829', '560928', '560944', '561010', '561010', '561010', '561010', '561011',
        '561011', '561011', '561011', '561315', '561563', '561568', '561811', '561877', '561878', '561890', '561890',
        '561892', '561908', '561908', '561908', '561920', '561920', '561920', '561920', '561940', '561943', '561946',
        '561949', '561949', '561969', '561978', '561978', '561979', '561989', '561990', '562057', '562186', '562205',
        '562238', '562252', '562299', '562299', '562324', '562329', '562331', '562342', '562342', '562342', '562342',
        '562345', '562425', '562425', '562425', '562425', '562446', '562458', '562481', '562560', '562633', '562639',
        '562662', '562662', '562741', '562741', '562741', '562741', '562741', '562742', '562742', '562742', '562742',
        '562754', '562754', '562754', '562761', '562764', '562764', '562764', '562767', '562898', '562898', '562898',
        '563032', '563101', '563174', '563194', '563215', '563326', '563353', '563353', '563353', '563385', '563385',
        '563385', '563702', '563708', '564047', '564047', '564047', '564047', '564390', '564390', '564600', '564658',
        '564658', '564659', '564749', '564808', '564852', '564884', '564914', '565009', '565042', '565100', '565110',
        '565111', '565126', '565403', '565830', '567784', '567785', '567842', '567861', '568171', '568223', '568561',
        '568561', '568562', '568562', '568563', '568563', '568564', '568564', '568564', '568565', '568637', '568637',
        '568639', '568639', '568644', '568644', '568646', '568647', '568647', '568858', '568908', '568910', '568914',
        '568981', '569074', '570023', '570023', '570027', '570166', '570167', '570351', '570351', '570351', '570443',
        '570477', '570683', '570683', '570785', '570787', '570788', '570797', '570797', '570934', '572048', '572187',
        '572228', '572228', '572228', '572228', '572278', '572278', '572279', '572279', '572279', '572280', '572280',
        '572280', '572303', '572303', '572303', '572304', '572304', '572304', '572305', '572305', '572378', '572379',
        '572443', '572450', '572486', '572572', '573154', '574458', '574458', '574674', '574679', '574770', '574872',
        '574906', '574906', '574906', '575088', '575203', '575245', '575408', '575473', '575714', '575762', '575958',
        '575958', '576068', '576130', '576130', '576673', '576700', '576907', '576924', '576934', '576943', '576944',
        '576946', '576947', '576960', '576960', '577218', '577221', '577342', '577357', '577384', '577390', '577407',
        '577412', '577466', '577479', '577479', '577529', '577530', '577559', '577560', '577685', '577760', '577791',
        '577794', '577956', '578061', '578063', '578065', '578072', '578189', '578191', '578271', '578333', '578381',
        '578559', '578559', '578602', '578602', '578739', '578755', '578759', '578775', '578778', '578989', '579016',
        '579031', '579415', '579586', '579733', '579779', '579924', '580010', '580017', '580039', '580043', '580044',
        '580354', '580365', '580438', '580709', '580742', '580775', '580795', '580851', '580885', '580895', '580976',
        '580992', '581019', '581019', '581049', '581079', '581234', '581304', '581318', '581439', '581544', '581707',
        '581865', '581865', '581956', '582032', '582162', '582162', '582164', '582172', '582180', '582180', '582223',
        '582224', '582230', '582230', '582231', '582245', '582245', '582267', '582269', '582298', '582428', '582435',
        '582457', '582473', '582473', '582473', '582473', '582482', '582482', '582483', '582510', '582510', '582524',
        '582524', '582551', '582551', '582572', '582631', '582631', '582632', '582632', '582634', '582634', '582645',
        '582648', '582649', '582650', '582650', '582650', '582650', '582650', '582651', '582656', '582656', '582656',
        '582656', '582656', '582658', '582660', '582677', '582694', '582694', '582709', '582714', '582739', '582752',
        '582753', '582797', '582797', '582835', '582840', '582851', '582851', '582858', '582862', '582897', '582897',
        '582900', '582900', '582900', '582900', '582905', '582905', '582930', '582982', '583001', '583001', '583018',
        '583052', '583052', '583052', '583056', '583057', '583063', '583063', '583068', '583077', '583171', '583407',
        '583423', '583605', '583820', '583827', '584091', '584092', '584093', '584096', '584114', '584413', '584534',
        '584534', '584534', '584538', '584639', '584696', '584719', '584727', '584742', '584765', '584793', '584910',
        '585152', '585210', '585542', '585780', '585802', '585878', '585982', '586036', '586037', '586271', '586296',
        '586297', '586338', '586413', '586543', '586544', '586639', '586640', '586641', '586642', '586750', '586751',
        '586957', '586959', '586960', '586965', '586966', '586967', '587003', '587018', '587303', '587314', '587345',
        '587399', '587449', '587454', '587479', '587479', '587479', '587479', '587501', '587501', '587501', '587507',
        '587507', '587507', '587507', '587508', '587508', '587508', '587779', '587854', '588200', '588220', '588298',
        '588463', '588504', '588557', '588560', '588603', '588616', '588741', '588741', '588741', '588805', '588805',
        '588805', '589347', '589548', '589704', '589858', '589910', '589977', '590005', '590010', '590038', '590059',
        '590077', '590081', '591504', '591648', '591649', '591651', '591652', '591724', '591762', '591762', '591762',
        '591762', '591764', '591764', '591764', '591764', '591795', '591827', '591828', '592061', '592062', '592077',
        '592086', '592109', '592110', '592171', '592173', '592176', '592244', '592271', '592272', '592281', '592389',
        '592389', '592389', '592401', '592401', '592401', '592614', '592638', '592796', '592884', '592892', '593067',
        '593107', '593187', '593229', '593702', '593761', '593958', '593980', '594464', '594468', '594521', '594809',
        '594835', '594900', '594954', '595110', '595285', '595294', '595305', '595309', '595627', '595628', '595659',
        '595660', '595667', '595693', '595772', '595784', '595850', '595932',
    }


class DietaryProductInfantFormulas(ValueSet):
    VALUE_SET_NAME = 'Dietary Product - Infant Formulas'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164792', '165942', '182432', '182500', '188457', '190802', '199814', '235624', '244802', '252870', '259532',
        '259532', '270458', '273332', '273332', '273332', '273332', '273332', '273332', '292871', '439530', '439547',
        '445405', '445406', '445406', '445406', '445408', '445410', '445410', '445410', '446787', '448153', '448287',
        '448511', '448720', '448720', '448721', '448722', '448722', '465871', '474290', '475084', '545083', '545138',
        '545138', '545138', '545139', '549816', '549816', '550597', '557682', '557682', '558034', '558034', '558034',
        '558058', '558058', '558058', '558442', '558442', '558443', '558443', '558443', '558443', '558444', '558444',
        '558692', '559856', '559927', '561877', '561878', '561908', '561908', '561908', '561920', '561920', '561920',
        '561920', '561940', '561943', '561946', '561949', '561949', '561989', '561990', '562186', '562205', '562329',
        '562331', '562425', '562425', '562425', '562425', '562481', '562741', '562741', '562741', '562741', '562741',
        '562742', '562742', '562742', '562742', '562754', '562754', '562754', '562761', '562764', '562764', '562764',
        '562767', '562898', '562898', '562898', '563032', '563353', '563353', '563353', '563385', '563385', '563385',
        '564390', '564390', '564600', '564659', '568561', '568561', '568562', '568562', '568563', '568563', '568564',
        '568564', '568564', '568565', '568637', '568637', '568639', '568639', '568644', '568644', '568646', '568647',
        '568647', '568858', '568908', '568910', '568914', '570023', '570023', '570027', '570166', '570167', '570351',
        '570351', '570351', '572228', '572228', '572228', '572228', '572278', '572278', '572279', '572279', '572279',
        '572280', '572280', '572280', '572303', '572303', '572303', '572304', '572304', '572304', '572305', '572305',
        '572486', '572572', '574458', '574458', '574674', '574679', '574906', '574906', '574906', '575088', '575203',
        '575245', '575408', '575473', '575958', '575958', '576130', '576130', '576960', '576960', '577342', '577357',
        '577384', '577412', '577466', '577479', '577479', '577529', '577530', '577559', '577560', '577685', '577791',
        '577794', '578061', '578063', '578559', '578559', '578602', '578602', '578739', '578759', '579016', '579031',
        '579415', '579586', '580709', '580742', '580775', '580795', '580851', '581019', '581019', '581234', '581707',
        '581865', '581865', '581956', '582162', '582162', '582164', '582180', '582180', '582223', '582230', '582230',
        '582231', '582245', '582245', '582428', '582435', '582473', '582473', '582473', '582473', '582482', '582482',
        '582483', '582510', '582510', '582551', '582551', '582572', '582631', '582631', '582632', '582632', '582634',
        '582634', '582649', '582650', '582650', '582650', '582650', '582650', '582651', '582656', '582656', '582656',
        '582656', '582656', '582658', '582660', '582694', '582694', '582752', '582753', '582797', '582797', '582835',
        '582840', '582851', '582851', '582858', '582862', '582897', '582897', '582900', '582900', '582900', '582900',
        '582905', '582905', '582930', '582982', '583001', '583001', '583052', '583052', '583052', '583056', '583057',
        '583063', '583063', '583077', '583171', '583407', '583423', '584096', '584114', '584413', '584538', '584639',
        '584793', '584910', '585542', '586271', '586297', '586338', '586543', '586544', '586639', '586640', '586641',
        '586642', '586750', '586751', '587003', '587018', '587779', '587854', '588741', '588741', '588741', '588805',
        '588805', '588805', '589548', '590005', '590010', '591504', '591648', '591649', '591651', '591724', '591827',
        '592061', '592062', '592109', '592110', '592171', '592173', '592176', '592272', '592281', '592796', '592884',
        '592892', '594900', '595772', '595784', '595932',
    }


class DietaryProductDietarySupplements(ValueSet):
    VALUE_SET_NAME = 'Dietary Product - Dietary Supplements'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150265', '151386', '152205', '154369', '157617', '162913', '168914', '169559', '170957', '178625', '178625',
        '178625', '178625', '178625', '178744', '178744', '179537', '200661', '209037', '213262', '213852', '213852',
        '213852', '242937', '247604', '253795', '262638', '262673', '264532', '265456', '267967', '268048', '268818',
        '272411', '272823', '272823', '276211', '276342', '276342', '282508', '294984', '294984', '297551', '443559',
        '443559', '443559', '443559', '443559', '443559', '443559', '443560', '443560', '443560', '443561', '443561',
        '443862', '443863', '445059', '445059', '445061', '445062', '445062', '445069', '445070', '446308', '446310',
        '446318', '446320', '446320', '446320', '446320', '449495', '450145', '450149', '451353', '452903', '464377',
        '470988', '472545', '472546', '472546', '473021', '473021', '473041', '473041', '474630', '474794', '474794',
        '474900', '474927', '474932', '474941', '474943', '475179', '475227', '476390', '545157', '545783', '545797',
        '549813', '549985', '549985', '550053', '550125', '550470', '550480', '550871', '550911', '551683', '552087',
        '552348', '553277', '553295', '553326', '553481', '553666', '554755', '554761', '554802', '554895', '555192',
        '555192', '555192', '555212', '555241', '555284', '555284', '555284', '555586', '555605', '555821', '555821',
        '555995', '555995', '556348', '556359', '556368', '556371', '556410', '556417', '556532', '556532', '556701',
        '556954', '556970', '557290', '557297', '557801', '557802', '557843', '557844', '557867', '557889', '558092',
        '558120', '558556', '558562', '558795', '558801', '559762', '559907', '559907', '559907', '559908', '559908',
        '559908', '559908', '559943', '559943', '559946', '559946', '560129', '560130', '560142', '560143', '560371',
        '560372', '560805', '560808', '560808', '560810', '560818', '560819', '560829', '560928', '560944', '561010',
        '561010', '561010', '561010', '561011', '561011', '561011', '561011', '561315', '561563', '561568', '561811',
        '561890', '561890', '561892', '561969', '561978', '561978', '561979', '562057', '562238', '562252', '562299',
        '562299', '562324', '562342', '562342', '562342', '562342', '562345', '562446', '562458', '562560', '562633',
        '562639', '562662', '562662', '563101', '563174', '563194', '563215', '563326', '563702', '563708', '564047',
        '564047', '564047', '564047', '564658', '564658', '564749', '564808', '564852', '564884', '564914', '565009',
        '565042', '565100', '565110', '565111', '565126', '565403', '565830', '567784', '567785', '567842', '567861',
        '568171', '568223', '568981', '569074', '570443', '570477', '570683', '570683', '570785', '570787', '570788',
        '570797', '570797', '570934', '572048', '572187', '572378', '572379', '572443', '572450', '573154', '574770',
        '574872', '575714', '575762', '576068', '576673', '576700', '576907', '576924', '576934', '576943', '576944',
        '576946', '576947', '577218', '577221', '577390', '577407', '577760', '577956', '578065', '578072', '578189',
        '578191', '578271', '578333', '578381', '578755', '578775', '578778', '578989', '579733', '579779', '579924',
        '580010', '580017', '580039', '580043', '580044', '580354', '580365', '580438', '580885', '580895', '580976',
        '580992', '581049', '581079', '581304', '581318', '581439', '581544', '582032', '582172', '582224', '582267',
        '582269', '582298', '582457', '582524', '582524', '582645', '582648', '582677', '582709', '582714', '582739',
        '583018', '583068', '583605', '583820', '583827', '584091', '584092', '584093', '584534', '584534', '584534',
        '584696', '584719', '584727', '584742', '584765', '585152', '585210', '585780', '585802', '585878', '585982',
        '586036', '586037', '586296', '586413', '586957', '586959', '586960', '586965', '586966', '586967', '587303',
        '587314', '587345', '587399', '587449', '587454', '587479', '587479', '587479', '587479', '587501', '587501',
        '587501', '587507', '587507', '587507', '587507', '587508', '587508', '587508', '588200', '588220', '588298',
        '588463', '588504', '588557', '588560', '588603', '588616', '589347', '589704', '589858', '589910', '589977',
        '590038', '590059', '590077', '590081', '591652', '591762', '591762', '591762', '591762', '591764', '591764',
        '591764', '591764', '591795', '591828', '592077', '592086', '592244', '592271', '592389', '592389', '592389',
        '592401', '592401', '592401', '592614', '592638', '593067', '593107', '593187', '593229', '593702', '593761',
        '593958', '593980', '594464', '594468', '594521', '594809', '594835', '594954', '595110', '595285', '595294',
        '595305', '595309', '595627', '595628', '595659', '595660', '595667', '595693', '595850',
    }


class AnorexiantNutritionalSupplementsDietAids(ValueSet):
    VALUE_SET_NAME = 'Anorexiant Nutritional Supplements (Diet Aids)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '451081', '466163', '569014', '569019',
    }


class DietaryProductsNutritionalSubstitutes(ValueSet):
    VALUE_SET_NAME = 'Dietary Products - Nutritional Substitutes'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '182267', '182267', '182267', '453487',
    }


class DietaryProductSaltSubstitutes(ValueSet):
    VALUE_SET_NAME = 'Dietary Product - Salt Substitutes'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DietaryProductSweeteners(ValueSet):
    VALUE_SET_NAME = 'Dietary Product - Sweeteners'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '182267', '182267', '182267', '453487',
    }


class HematopoieticAgents(ValueSet):
    VALUE_SET_NAME = 'Hematopoietic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154872', '155823', '156290', '159762', '167470', '179737', '181715', '182061', '191043', '195275', '198492',
        '199841', '204587', '224148', '228026', '232560', '238638', '240075', '240985', '263196', '265135', '275819',
        '284410', '287558', '297597', '299031', '400008', '400575', '445641', '445642', '448583', '473031', '473692',
        '473694', '545573', '545587', '546002', '546003', '546004', '546005', '546012', '546013', '546014', '546019',
        '546041', '546043', '546045', '546047', '546050', '546052', '546054', '546124', '546174', '546179', '546180',
        '546181', '546182', '546186', '546187', '546188', '546190', '546192', '546194', '546205', '556017', '556018',
        '556023', '556024', '556900', '556901', '556909', '556910', '557024', '557035', '560740', '560752', '568987',
        '569033', '569809', '569817', '571168', '571169', '571170', '571172', '571173', '571246', '571265', '571267',
        '571268', '571270', '571274', '571276', '580258', '580259', '580261', '580262', '583616', '583622', '584443',
        '584445', '587207', '587208',
    }


class VitaminsB12CyanocobalaminAndDerivatives(ValueSet):
    VALUE_SET_NAME = 'Vitamins - B-12, Cyanocobalamin and derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156605', '156605', '162330', '163363', '165026', '166114', '166283', '187518', '194088', '194366', '198041',
        '201568', '212907', '215605', '226007', '236407', '238818', '238818', '238818', '239674', '262043', '268145',
        '271091', '283342', '297140', '400911', '439692', '439693', '439693', '439700', '448032', '476025', '476277',
        '554955', '555062', '555333', '555333', '555349', '555349', '555673', '558189', '558207', '559975', '559983',
        '560770', '560770', '560814', '560814', '562226', '562277', '570591', '570591', '572651', '573839', '576251',
        '576470', '576485', '577976', '578029', '578737', '578749', '579237', '579527', '579535', '580948', '581483',
        '581590', '583441', '583447', '583642', '586195', '586496', '586847', '588545', '589473', '590190', '591387',
        '591542', '591694', '593136', '594627', '595041', '595878',
    }


class VitaminsLiverPreparations(ValueSet):
    VALUE_SET_NAME = 'Vitamins - Liver Preparations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class VitaminsFolicAcidAndDerivatives(ValueSet):
    VALUE_SET_NAME = 'Vitamins - Folic Acid and Derivatives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '193728', '204576', '217645', '264890', '293245', '476791', '503622', '559323', '576178', '576179', '577408',
        '577409', '577443', '577444', '577458', '577459', '578021', '578022', '586821', '588543', '588546', '588782',
        '589295',
    }


class MineralsAndElectrolytesIron(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Iron'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164507', '168892', '168970', '171643', '176238', '181763', '182949', '182949', '188671', '209889', '214003',
        '216920', '231550', '239813', '239813', '243449', '245555', '246995', '248420', '273866', '274885', '277896',
        '277992', '279975', '279975', '283668', '286729', '298965', '299389', '400115', '400262', '400262', '400296',
        '439812', '445442', '446655', '448946', '449380', '453429', '454438', '467873', '467873', '467873', '467874',
        '467876', '467876', '467883', '471892', '471893', '473831', '474048', '474081', '474184', '474996', '474996',
        '475001', '475045', '475308', '475977', '475981', '547609', '551099', '551536', '551990', '551990', '552760',
        '552771', '553592', '553675', '553913', '554520', '554554', '556934', '556941', '557646', '558000', '558000',
        '558548', '558592', '558669', '558754', '561002', '561026', '561609', '561858', '561858', '561880', '563268',
        '563268', '563516', '563517', '563531', '563531', '563544', '563544', '563570', '563571', '563684', '563945',
        '564291', '564314', '564999', '565079', '565601', '565871', '567511', '567669', '569437', '571085', '571776',
        '571776', '574264', '575147', '575172', '575202', '575204', '575209', '575243', '576034', '576035', '576037',
        '576337', '578952', '578952', '579134', '579354', '579359', '579837', '579856', '581697', '582585', '582626',
        '584144', '586913', '587283', '587291', '590386', '590882', '591548', '593003', '593770', '593806', '595153',
        '595546', '595574', '595824',
    }


class MineralsAndElectrolytesIronCombinations(ValueSet):
    VALUE_SET_NAME = 'Minerals and Electrolytes - Iron Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150748', '154039', '163262', '172639', '174318', '186885', '187168', '188846', '195609', '196078', '196639',
        '197180', '201557', '205160', '207087', '212562', '214916', '243701', '257379', '257834', '260365', '270184',
        '276744', '279291', '279291', '290442', '295646', '296493', '401058', '401064', '439819', '439846', '444164',
        '444195', '444206', '445387', '445456', '446078', '446078', '446149', '446150', '446151', '446210', '449547',
        '450746', '450991', '451000', '451232', '465830', '468294', '469657', '471600', '471602', '473558', '546168',
        '546169', '546201', '546202', '546203', '552307', '552668', '553025', '554385', '554866', '555591', '555592',
        '555992', '556013', '556086', '556087', '557365', '557477', '557554', '558012', '558013', '558014', '558028',
        '558029', '558030', '558041', '558349', '558560', '558674', '560078', '560087', '560125', '560133', '561038',
        '561051', '561060', '561086', '561473', '562774', '562784', '563117', '563187', '563202', '564115', '568972',
        '569004', '569487', '571793', '575062', '575110', '575283', '576622', '576635', '577527', '577564', '577603',
        '577692', '578392', '578551', '578877', '578890', '579737', '579750', '579864', '579874', '579977', '580536',
        '580540', '580671', '580704', '580759', '580772', '581047', '581154', '582087', '582101', '582899', '582929',
        '583330', '583346', '583547', '583575', '585985', '586871', '586880', '587451', '587461', '587483', '587815',
        '587986', '588015', '589050', '589104', '591032', '591049', '592799', '592802', '593329', '593331', '594741',
        '596008',
    }


class HematopoieticAgentsHematopoieticGrowthFactors(ValueSet):
    VALUE_SET_NAME = 'Hematopoietic Agents - Hematopoietic Growth Factors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154872', '155823', '156290', '159762', '167470', '179737', '181715', '182061', '191043', '195275', '198492',
        '199841', '204587', '224148', '228026', '232560', '238638', '240075', '240985', '263196', '265135', '275819',
        '284410', '287558', '297597', '299031', '400008', '400575', '445641', '445642', '448583', '473031', '473692',
        '473694', '545573', '545587', '546002', '546003', '546004', '546005', '546012', '546013', '546014', '546019',
        '546041', '546043', '546045', '546047', '546050', '546052', '546054', '546124', '546174', '546179', '546180',
        '546181', '546182', '546186', '546187', '546188', '546190', '546192', '546194', '546205', '556017', '556018',
        '556023', '556024', '556900', '556901', '556909', '556910', '557024', '557035', '560740', '560752', '568987',
        '569033', '569809', '569817', '571168', '571169', '571170', '571172', '571173', '571246', '571265', '571267',
        '571268', '571270', '571274', '571276', '580258', '580259', '580261', '580262', '583616', '583622', '584443',
        '584445', '587207', '587208',
    }


class Erythropoietins(ValueSet):
    VALUE_SET_NAME = 'Erythropoietins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154872', '155823', '156290', '167470', '179737', '181715', '195275', '198492', '224148', '228026', '232560',
        '238638', '240985', '263196', '265135', '287558', '299031', '473031', '473692', '473694', '545573', '545587',
        '546002', '546003', '546004', '546005', '546012', '546013', '546014', '546019', '546041', '546043', '546045',
        '546047', '546050', '546052', '546054', '546124', '546174', '546179', '546180', '546181', '546182', '546186',
        '546187', '546188', '546190', '546192', '546194', '546205', '568987', '569033', '571168', '571169', '571170',
        '571172', '571173', '571246', '571265', '571267', '571268', '571270', '571274', '571276',
    }


class GranulocyteColonyStimulatingFactorGCsf(ValueSet):
    VALUE_SET_NAME = 'Granulocyte Colony-Stimulating Factor (G-CSF)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '182061', '191043', '199841', '204587', '275819', '400008', '400575', '445641', '445642', '448583', '580258',
        '580259', '580261', '580262', '583616', '583622', '584443', '584445', '587207', '587208',
    }


class GranulocyteMacrophageColonyStimulatingFactorGmCsf(ValueSet):
    VALUE_SET_NAME = 'Granulocyte-Macrophage Colony-Stimulating Factor (GM-CSF)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159762', '284410',
    }


class PlateletProliferationStimulantsInterleukins(ValueSet):
    VALUE_SET_NAME = 'Platelet Proliferation Stimulants (Interleukins)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '240075', '297597',
    }


class MetabolicDiseaseEnzymeReplacementAgents(ValueSet):
    VALUE_SET_NAME = 'Metabolic Disease Enzyme Replacement Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '162948', '239325', '268452', '292731', '449612', '449613', '449623', '449628', '468277', '468278', '474305',
        '474321', '545179', '545972', '545984', '560652', '560666', '561359', '572426', '572480', '580915', '580929',
        '588045', '588045', '588045', '588046', '588049', '588049', '588049', '588050', '588587', '588611', '593712',
        '593713', '594969', '594975',
    }


class SickleCellAnemiaAgents(ValueSet):
    VALUE_SET_NAME = 'Sickle Cell Anemia Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '168455', '238220', '241289', '243076', '288834', '295053', '594218', '595179',
    }


class Anticoagulants(ValueSet):
    VALUE_SET_NAME = 'Anticoagulants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152334', '153725', '155680', '155680', '155921', '163543', '165153', '165153', '165153', '178751', '179127',
        '183478', '195508', '195545', '196962', '203518', '211105', '211250', '213056', '222593', '225953', '226981',
        '226981', '235524', '238116', '239505', '242139', '245864', '247449', '250476', '252129', '256839', '257067',
        '262115', '265104', '269718', '270211', '274752', '275829', '280061', '280061', '280061', '280633', '281338',
        '285775', '288089', '288089', '289934', '290345', '296179', '296718', '400554', '400554', '400554', '400578',
        '400579', '443661', '443662', '443663', '443664', '443665', '443895', '443896', '443897', '443898', '443899',
        '443900', '445645', '445774', '448434', '448854', '448857', '449940', '449940', '450872', '450872', '450872',
        '452450', '452451', '452452', '452453', '452454', '452455', '452456', '452457', '452458', '472489', '472491',
        '472495', '472496', '472497', '472498', '476295', '476296', '476296', '476296', '476296', '476296', '476297',
        '476297', '476297', '476297', '476297', '476297', '476298', '476299', '476301', '476311', '476311', '476312',
        '476313', '476316', '476516', '476517', '476518', '547795', '547795', '547795', '547795', '547795', '552565',
        '552566', '552567', '552569', '552570', '552571', '554676', '554676', '555669', '555670', '558296', '558296',
        '558296', '558418', '558418', '558418', '560051', '560270', '560270', '560270', '560286', '560286', '560286',
        '560286', '560351', '561660', '561666', '562050', '562095', '562478', '562483', '562579', '562581', '563191',
        '563700', '564234', '564234', '564780', '564784', '564789', '565108', '565544', '565547', '566513', '568098',
        '568099', '568101', '568102', '568318', '572229', '573637', '573855', '573856', '573857', '574154', '575114',
        '576307', '576314', '576498', '576500', '579135', '579183', '582760', '582767', '583550', '583551', '583552',
        '583569', '583571', '583572', '585348', '588193', '588202', '589713', '591153', '591153', '593392', '594030',
        '594031', '594078', '594185', '594186', '594359', '594360', '594708', '594759', '594891', '594901', '594920',
        '594922', '595160', '595161', '595233', '595266', '595310', '595315',
    }


class Heparins(ValueSet):
    VALUE_SET_NAME = 'Heparins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165153', '165153', '165153', '275829', '280061', '280061', '280061', '288089', '288089', '445774', '476295',
        '476298', '476299', '476301', '476313', '476316', '476516', '476517', '476518', '560351', '562050', '563191',
        '574154', '594901', '595266',
    }


class LowMolecularWeightHeparins(ValueSet):
    VALUE_SET_NAME = 'Low Molecular Weight Heparins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '195508', '211250', '225953', '250476', '262115', '265104', '269718', '281338', '289934', '296179', '296718',
        '443661', '443662', '443663', '443664', '443665', '443895', '443896', '443897', '443898', '443899', '443900',
        '445645', '448434', '448854', '448857', '552565', '552566', '552567', '552569', '552570', '552571',
    }


class AnticoagulantsCoumarin(ValueSet):
    VALUE_SET_NAME = 'Anticoagulants - Coumarin'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152334', '153725', '155921', '178751', '179127', '183478', '195545', '196962', '211105', '213056', '222593',
        '242139', '245864', '247449', '270211', '274752', '280633', '285775', '452450', '452451', '452452', '452453',
        '452454', '452455', '452456', '452457', '452458',
    }


class AnticoagulantsIndanedione(ValueSet):
    VALUE_SET_NAME = 'Anticoagulants - Indanedione'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class ThrombinInhibitors(ValueSet):
    VALUE_SET_NAME = 'Thrombin Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '163543', '235524', '239505', '561660', '561666', '562478', '562483', '562579', '562581', '564234', '564234',
        '564789', '565108', '566513', '585348', '595160', '595161',
    }


class ThrombinInhibitorSelectiveDirectAndReversibleHirudinType(ValueSet):
    VALUE_SET_NAME = 'Thrombin Inhibitor - Selective Direct and Reversible - Hirudin Type'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '235524', '239505', '561660', '561666', '595160', '595161',
    }


class AnticoagulantsOther(ValueSet):
    VALUE_SET_NAME = 'Anticoagulants Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AnticoagulantsCitrateBased(ValueSet):
    VALUE_SET_NAME = 'Anticoagulants - Citrate-based'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '238116', '252129', '290345', '400554', '400554', '400554', '450872', '450872', '450872', '554676', '554676',
        '560051', '579135', '579183', '594759', '595233',
    }


class Hemostatics(ValueSet):
    VALUE_SET_NAME = 'Hemostatics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153448', '154327', '157707', '164983', '170391', '170391', '175213', '177171', '177726', '177726', '188889',
        '191898', '197221', '200771', '202077', '203635', '203635', '207526', '207689', '209501', '215225', '215666',
        '216544', '220167', '222294', '228194', '238113', '238454', '245327', '260109', '261286', '261286', '272201',
        '273621', '286959', '288170', '443795', '445145', '445188', '445189', '445190', '445191', '445246', '445247',
        '445248', '445249', '446776', '446777', '471762', '471764', '550619', '550621', '550837', '550861', '550882',
        '550883', '550884', '550890', '550891', '550892', '552844', '552845', '552846', '552857', '552946', '552947',
        '552948', '552951', '552952', '552953', '553068', '554079', '554099', '555176', '555183', '555184', '555955',
        '556200', '556201', '556202', '557935', '557965', '558625', '558626', '558627', '558628', '558629', '558630',
        '561230', '561253', '562115', '562116', '562121', '562122', '568579', '568579', '571569', '571933', '573526',
        '573527', '573530', '573811', '573813', '573814', '579078', '579357', '579454', '579484', '587421', '587423',
        '587480', '587481', '588594', '588595', '589113', '589178', '591078', '591079', '592327', '592334', '593599',
        '593639', '593674', '593701', '595147', '595148',
    }


class HemostaticsSystemic(ValueSet):
    VALUE_SET_NAME = 'Hemostatics - Systemic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153448', '170391', '170391', '188889', '215666', '228194', '261286', '261286', '471762', '471764', '557935',
        '557965', '561230', '561253', '568579', '568579', '588594', '588595', '591078', '591079', '595147', '595148',
    }


class HemostaticSystemicCombinations(ValueSet):
    VALUE_SET_NAME = 'Hemostatic Systemic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class HemostaticsTopicalAgentsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Hemostatics - Topical Agents and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154327', '157707', '164983', '175213', '177171', '177726', '177726', '191898', '197221', '200771', '202077',
        '203635', '203635', '207526', '207689', '209501', '215225', '216544', '220167', '222294', '238113', '238454',
        '245327', '260109', '272201', '273621', '286959', '288170', '443795', '445145', '445188', '445189', '445190',
        '445191', '445246', '445247', '445248', '445249', '446776', '446777', '550619', '550621', '550837', '550861',
        '550882', '550883', '550884', '550890', '550891', '550892', '552844', '552845', '552846', '552857', '552946',
        '552947', '552948', '552951', '552952', '552953', '553068', '554079', '554099', '555176', '555183', '555184',
        '555955', '556200', '556201', '556202', '558625', '558626', '558627', '558628', '558629', '558630', '562115',
        '562116', '562121', '562122', '571569', '571933', '573526', '573527', '573530', '573811', '573813', '573814',
        '579078', '579357', '579454', '579484', '587421', '587423', '587480', '587481', '589113', '589178', '592327',
        '592334', '593599', '593639', '593674', '593701',
    }


class HemostaticTopicalCombinations(ValueSet):
    VALUE_SET_NAME = 'Hemostatic Topical Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154327', '550619', '550621', '550882', '550883', '550884', '550890', '550891', '550892', '552844', '552845',
        '552846', '553068', '556200', '556201', '556202', '562115', '562116', '562121', '562122', '587421', '587423',
        '587480', '587481', '589113', '589178', '592327', '592334',
    }


class FactorViiiPreparationsAhf(ValueSet):
    VALUE_SET_NAME = 'Factor VIII Preparations (AHF)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157733', '158795', '182104', '190359', '195768', '197239', '213075', '215261', '216909', '240283', '243457',
        '253507', '265614', '268614', '269864', '271489', '279274', '296018', '298230', '451138', '451139', '451140',
        '451141', '476288', '476289', '476290', '476339', '476340', '476341', '512629', '545042', '545043', '545048',
        '545116', '545121', '545133', '545434', '551671', '551692', '551694', '552424', '552670', '552671', '552672',
        '552673', '552681', '552682', '552683', '552684', '552696', '552697', '552698', '552699', '553842', '555482',
        '555483', '555484', '555485', '555554', '555555', '555556', '555557', '556191', '556193', '559006', '559245',
        '560600', '560607', '560621', '560622', '562281', '562282', '563028', '563037', '565218', '565220', '565541',
        '565542', '566063', '566064', '566076', '566080', '569914', '569915', '569953', '569955', '573390', '573540',
        '573933', '573940', '579412', '581746', '581747', '581748', '581749', '581750', '581751', '581752', '581960',
        '581962', '581963', '581964', '581965', '581966', '581967', '582440', '582452', '582945', '583157', '584466',
        '584467', '584468', '584469', '584471', '584472', '584484', '584485', '584486', '584487', '584488', '584489',
        '588107', '588108', '588109', '588110', '588114', '588115', '588116', '588117', '588438', '588440', '588441',
        '588442', '588447', '588448', '588449', '588450', '589849', '589850', '589855', '589856', '589857', '590851',
        '590852', '590853', '590854', '590855', '590864', '590865', '590866', '590867', '590868', '592917', '592918',
        '592919', '592975', '592979', '593014', '593015', '593131', '593133', '593134', '593144', '593145', '593146',
        '593573', '593577', '593754', '593755', '593763', '593764', '594291', '594292', '594293', '594308', '594309',
        '594310',
    }


class PlateletAggregationInhibitorOthers(ValueSet):
    VALUE_SET_NAME = 'Platelet Aggregation Inhibitor Others'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class PlateletAggregationInhibitorsGlycoproteinIibIiiaReceptorInhib(ValueSet):
    VALUE_SET_NAME = 'Platelet Aggregation Inhibitors - Glycoprotein IIb/IIIa Receptor Inhib'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156973', '156973', '157450', '229647', '251838', '262769', '269413', '269413', '557117', '557740', '557740',
        '557745', '557745', '557746',
    }


class PlateletAggregationInhibitorsMonoclonalAgents(ValueSet):
    VALUE_SET_NAME = 'Platelet Aggregation Inhibitors - Monoclonal Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '253649', '255660',
    }


class PlateletAggregationInhibitorsPhosphodiesteraseIiiInhibitors(ValueSet):
    VALUE_SET_NAME = 'Platelet Aggregation Inhibitors - Phosphodiesterase III Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155385', '156428', '173848', '203901',
    }


class PlateletAggregationInhibitorsQuinazolineAgents(ValueSet):
    VALUE_SET_NAME = 'Platelet Aggregation Inhibitors - Quinazoline Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159926', '242567', '250188',
    }


class PlateletAggregationInhibitorCombinations(ValueSet):
    VALUE_SET_NAME = 'Platelet Aggregation Inhibitor Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155218', '158458',
    }


class HematorheologicAgents(ValueSet):
    VALUE_SET_NAME = 'Hematorheologic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '208837',
    }


class AntiporphyriaFactors(ValueSet):
    VALUE_SET_NAME = 'Antiporphyria Factors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157264', '174079', '593876', '593904',
    }


class HematologicAgentsInVitro(ValueSet):
    VALUE_SET_NAME = 'Hematologic Agents - In Vitro'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class HematologicAgentInVitroRedCellWashingAgents(ValueSet):
    VALUE_SET_NAME = 'Hematologic Agent In Vitro - Red Cell Washing Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class HematologicAgentInVitroRedCellPreservationAgents(ValueSet):
    VALUE_SET_NAME = 'Hematologic Agent In Vitro - Red Cell Preservation Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class HematologicAgentInVitroRedCellRejuvenationAgents(ValueSet):
    VALUE_SET_NAME = 'Hematologic Agent In Vitro - Red Cell Rejuvenation Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class PlasmaExpanders(ValueSet):
    VALUE_SET_NAME = 'Plasma Expanders'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154034', '166807', '177956', '200024', '204116', '220348', '283487', '439915', '558798', '563226',
    }


class BloodAlbuminAndPlasmaProteins(ValueSet):
    VALUE_SET_NAME = 'Blood Albumin and Plasma Proteins'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164915', '169091', '169091', '171846', '171846', '180416', '180416', '187435', '187435', '190464', '190464',
        '190464', '203188', '203188', '203188', '203188', '203188', '203188', '203188', '203188', '203188', '203188',
        '219982', '219982', '219982', '219982', '219982', '219982', '219982', '219982', '219982', '221984', '221984',
        '221984', '238619', '249307', '249307', '249307', '252030', '252030', '255791', '255791', '259335', '277882',
        '401092', '401092', '401093', '401093', '475946', '475946', '551424', '551425', '551441', '551442', '556823',
        '556830', '558141', '558172', '559668', '565593', '565593', '565600', '569699', '572134', '572134', '573456',
        '573457', '573458', '573459', '573497', '573498', '573499', '573500', '581922', '581928', '582438', '582439',
        '582445', '593906', '593907', '593962', '593963',
    }


class ReversalAgentsHeparinAntagonists(ValueSet):
    VALUE_SET_NAME = 'Reversal Agents - Heparin Antagonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '167272', '167272',
    }


class HematologicalAgentThrombolyticEnzymes(ValueSet):
    VALUE_SET_NAME = 'Hematological Agent - Thrombolytic Enzymes'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161412', '177202', '205791', '213117', '222845', '267100', '288550', '296851', '400662', '447785', '585064',
        '590086',
    }


class ThrombolyticTissuePlasminogenActivators(ValueSet):
    VALUE_SET_NAME = 'Thrombolytic - Tissue Plasminogen Activators'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '161412', '177202', '205791', '213117', '222845', '267100', '288550', '296851', '400662', '447785',
    }


class HematologicalAgentSyntheticBloodPreparations(ValueSet):
    VALUE_SET_NAME = 'Hematological Agent - Synthetic Blood Preparations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class OphthalmicAgents(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150113', '150973', '150973', '152810', '152810', '152846', '152846', '152857', '152857', '152857', '153566',
        '154618', '154734', '155570', '159233', '159492', '160792', '160792', '162232', '163045', '163215', '164071',
        '164662', '164662', '164826', '164921', '165590', '165590', '165765', '167430', '167659', '168822', '169061',
        '169061', '171790', '172184', '173089', '173089', '173089', '173557', '174220', '174220', '175905', '176247',
        '176726', '176726', '177371', '178609', '178905', '178905', '178947', '178947', '178947', '178954', '178954',
        '179568', '180742', '181328', '181328', '181530', '181530', '183116', '183224', '183344', '183344', '183831',
        '183831', '184163', '185001', '185512', '185512', '187236', '187958', '189831', '189897', '190620', '191105',
        '191825', '191921', '192782', '193781', '194459', '194459', '194606', '195108', '195108', '195211', '195513',
        '196316', '196583', '196737', '196737', '197179', '197259', '197637', '197637', '198982', '198982', '198982',
        '199222', '199222', '199638', '199638', '199638', '199979', '199979', '199979', '200349', '200859', '201916',
        '201916', '201916', '202271', '202271', '204145', '204284', '204495', '204986', '205057', '205057', '205057',
        '206189', '206371', '206387', '207137', '207137', '207416', '207563', '207903', '208878', '210347', '210570',
        '210743', '210743', '213227', '213466', '213466', '213529', '213529', '213529', '213577', '213577', '214048',
        '214879', '214879', '214879', '215898', '216721', '217674', '217778', '218889', '219147', '219458', '219853',
        '220153', '220153', '220296', '220502', '220502', '220951', '220951', '221480', '221568', '224010', '224010',
        '224010', '224010', '224866', '224905', '224905', '225309', '227774', '227937', '228396', '228870', '228870',
        '229864', '229864', '229864', '231842', '231842', '232452', '232452', '232452', '233552', '233552', '234134',
        '234293', '234293', '234756', '234756', '235057', '235057', '235057', '235126', '235126', '235126', '235594',
        '235594', '235594', '235750', '236272', '236306', '236869', '237026', '237168', '237754', '238183', '238183',
        '238183', '238273', '238273', '238801', '239113', '239113', '239449', '239449', '240030', '240180', '240563',
        '240933', '241356', '241356', '241447', '241948', '242219', '243673', '244041', '244545', '244545', '244713',
        '244713', '244713', '244779', '244779', '244779', '245823', '245823', '245882', '245882', '245882', '246890',
        '246890', '247143', '247504', '247583', '248105', '248747', '248913', '248913', '249383', '249383', '249410',
        '249555', '249555', '249555', '249683', '250378', '251346', '251451', '256555', '256555', '256893', '257110',
        '257189', '257278', '257366', '257564', '257947', '258105', '259332', '259760', '259925', '259925', '259925',
        '259925', '260251', '260251', '260924', '260924', '263459', '263480', '263480', '263927', '264775', '264931',
        '268441', '269596', '271971', '271971', '272590', '272590', '272590', '272827', '272926', '272926', '272926',
        '273343', '273354', '274046', '275131', '275459', '275459', '275459', '275459', '276663', '276663', '277674',
        '277687', '277765', '277990', '278179', '279392', '280037', '280037', '280037', '280154', '282071', '282943',
        '282943', '282943', '283257', '283257', '283257', '283717', '284225', '284354', '285195', '285195', '285195',
        '285349', '285485', '286307', '286310', '287036', '287196', '287196', '287196', '287355', '288572', '288572',
        '288572', '289514', '289705', '289705', '290226', '291845', '291845', '291845', '292269', '294917', '294917',
        '294917', '295329', '295698', '296320', '296320', '297032', '297712', '297729', '297764', '297764', '297857',
        '298285', '298645', '298903', '298903', '298903', '299207', '299789', '299817', '400807', '400947', '400968',
        '400979', '400979', '400980', '401047', '440044', '440053', '440066', '440066', '440143', '440143', '440145',
        '440148', '440148', '440148', '440268', '440273', '440363', '440365', '440365', '440429', '440491', '443450',
        '443450', '443451', '443492', '443522', '444450', '444813', '445827', '445996', '445996', '445996', '445996',
        '446015', '446015', '446016', '446016', '446274', '446336', '446337', '446469', '446469', '446702', '446702',
        '446705', '446705', '446714', '446715', '446715', '446716', '446717', '446721', '446722', '446898', '446898',
        '448025', '448272', '448696', '448738', '448738', '448770', '448770', '448774', '448774', '449036', '449037',
        '449038', '449039', '449542', '449543', '449790', '449790', '449790', '449790', '449790', '449790', '449811',
        '449811', '449811', '449811', '449858', '450083', '450086', '450086', '450464', '450722', '450722', '450740',
        '450771', '450900', '450900', '450912', '450928', '450928', '450928', '450929', '451394', '451417', '451734',
        '453591', '453591', '453591', '453623', '453623', '453623', '453623', '453623', '453623', '453648', '453650',
        '453675', '453704', '453916', '453922', '465890', '466561', '467719', '467719', '467719', '467719', '467757',
        '467761', '467761', '467761', '467761', '467934', '468092', '468092', '469655', '469721', '470728', '470728',
        '470978', '470978', '471372', '471430', '472377', '472377', '472383', '472840', '472846', '473029', '473029',
        '473099', '473099', '473684', '473684', '473684', '473925', '473988', '474008', '474077', '474077', '474108',
        '474326', '474356', '474574', '474574', '474574', '474583', '474583', '474583', '474584', '474585', '474585',
        '474586', '474589', '474589', '474657', '474657', '474658', '474658', '474660', '474660', '474933', '474933',
        '474933', '474942', '474968', '475038', '475039', '475217', '475581', '476192', '476195', '476422', '476455',
        '476455', '476455', '476852', '476853', '545069', '545070', '545382', '545382', '545382', '545781', '545790',
        '546037', '546037', '546059', '546059', '546130', '546130', '546166', '546896', '546896', '547663', '547663',
        '547664', '549075', '549088', '549453', '549718', '550586', '550633', '550633', '550633', '550633', '550633',
        '550633', '550637', '550674', '550674', '550705', '550785', '550865', '551057', '551057', '551066', '551066',
        '551075', '551075', '551098', '551399', '551399', '551457', '551459', '551459', '551514', '551514', '551576',
        '551604', '551629', '552105', '552105', '552469', '552552', '552552', '552811', '552854', '552854', '552854',
        '552969', '552994', '552994', '552995', '553139', '553276', '553357', '553589', '553589', '553589', '553594',
        '553594', '553594', '553609', '553628', '553628', '553649', '553651', '553652', '553731', '553736', '553736',
        '553854', '553854', '553969', '553969', '554484', '554509', '554754', '554847', '555128', '555723', '555724',
        '556100', '556270', '556318', '556337', '556337', '556337', '556337', '556337', '556493', '556515', '556533',
        '556533', '556550', '556550', '557916', '557916', '558401', '558402', '558847', '558857', '558928', '559113',
        '559113', '559212', '559230', '559303', '559303', '559327', '559327', '559505', '559663', '559667', '559909',
        '559917', '560008', '560009', '560101', '560124', '560170', '560346', '560742', '560744', '560745', '560746',
        '560753', '560754', '561036', '561052', '561058', '561065', '561085', '561344', '561349', '561662', '561857',
        '561992', '562016', '562020', '562155', '562155', '562155', '562162', '562162', '562162', '562271', '562514',
        '562514', '562518', '562518', '563029', '563035', '563044', '563104', '563104', '563232', '563232', '563680',
        '563823', '563913', '564273', '564289', '564467', '564498', '564498', '565093', '565101', '565169', '565169',
        '565253', '565648', '565656', '565790', '565790', '565791', '568471', '568669', '568671', '569581', '569873',
        '569873', '570416', '570544', '570554', '570620', '570681', '570801', '570839', '570841', '570882', '572081',
        '572368', '572392', '572392', '572397', '572441', '572444', '572444', '572468', '572478', '572617', '572617',
        '572888', '573185', '573347', '573424', '574209', '574408', '574413', '575457', '575691', '575745', '575873',
        '575944', '576081', '576081', '576136', '576159', '576342', '576342', '576343', '576343', '576369', '576514',
        '576515', '576522', '577198', '577364', '577380', '577514', '577514', '577514', '577514', '577630', '577807',
        '577808', '577944', '578030', '578031', '578031', '578052', '578054', '578056', '578239', '578654', '578738',
        '578738', '579150', '579356', '579367', '580205', '580993', '581050', '581686', '581694', '582003', '582720',
        '582979', '582980', '583037', '583301', '584040', '584058', '584625', '584625', '584805', '584872', '584872',
        '584942', '584969', '584970', '586511', '586514', '586644', '586760', '586807', '586866', '587011', '587533',
        '587571', '588388', '588397', '588698', '588847', '589247', '589247', '589877', '589878', '589878', '590238',
        '590252', '590323', '590323', '591188', '591190', '591283', '591286', '591330', '591331', '591541', '591541',
        '592019', '592188', '592201', '592273', '592273', '592283', '592285', '592292', '592296', '592492', '593096',
        '593212', '593224', '593554', '593555', '593559', '593564', '593600', '593747', '593951', '593966', '594040',
        '594067', '594135', '594244', '594368', '594406', '594607', '594867', '594947', '595048', '595194', '595201',
        '595212', '595459', '595629', '595629', '595809', '595816', '595836', '595839', '595881', '595934', '595978',
    }


class OphthalmicAntiInfectives(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Anti-infectives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165765', '174220', '174220', '178609', '178905', '178905', '185001', '197179', '200859', '204495', '206189',
        '210570', '216721', '217674', '218889', '220296', '224866', '225309', '228870', '228870', '232452', '232452',
        '232452', '234293', '234293', '237168', '238273', '238273', '238801', '242219', '246890', '246890', '247143',
        '248747', '257564', '259332', '264775', '272827', '279392', '297729', '449542', '449543', '550865', '551576',
        '551629', '558401', '558402', '561052', '561058', '561344', '561349', '563029', '563680', '565253', '576515',
        '592201', '592283', '593559', '593600', '595809',
    }


class OphthalmicAntibacterial(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic Antibacterial'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165765', '174220', '174220', '178905', '178905', '185001', '204495', '210570', '218889', '220296', '225309',
        '228870', '228870', '232452', '232452', '232452', '234293', '234293', '237168', '238273', '238273', '238801',
        '242219', '248747', '259332', '264775', '279392', '449542', '449543', '551576', '551629', '558401', '558402',
        '561344', '561349', '563029', '563680', '592201', '592283', '593559', '593600', '595809',
    }


class OphthalmicAntibioticSulfonamides(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic Antibiotic - Sulfonamides'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '185001', '234293', '234293', '237168',
    }


class OphthalmicAntivirals(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic Antivirals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '197179', '216721', '561052', '561058',
    }


class OphthalmicAntifungals(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic Antifungals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '206189', '272827',
    }


class OphthalmicAntiseptics(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic Antiseptics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '200859', '246890', '246890',
    }


class ArtificialTearsAndLubricantSingleAgents(ValueSet):
    VALUE_SET_NAME = 'Artificial Tears and Lubricant Single Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150973', '150973', '172184', '183224', '195211', '206371', '207137', '207137', '217778', '233552', '233552',
        '245823', '245823', '248105', '283257', '283257', '283257', '295698', '297712', '297857', '400947', '401047',
        '440044', '440053', '443450', '443450', '446274', '446702', '446702', '446898', '446898', '448696', '453675',
        '453704', '469655', '470978', '470978', '471430', '474658', '474658', '475038', '475039', '550586', '551075',
        '551075', '551098', '551399', '551399', '551457', '552105', '552105', '554484', '554509', '559917', '562514',
        '562514', '562518', '562518', '565093', '565101', '572368', '576136', '577198', '577380', '578030', '578654',
        '578738', '578738', '579150', '582003', '584625', '584625', '586760', '586866', '592492',
    }


class OphthalmicGonioscopicSolutions(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Gonioscopic Solutions'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155570', '206387', '400807', '400968', '574209',
    }


class OphthalmicIntraocularPressureReducingAgentsBetaBlockers(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Intraocular Pressure Reducing Agents, Beta-blockers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152857', '152857', '152857', '160792', '160792', '167659', '213577', '213577', '219458', '220153', '220153',
        '235126', '235126', '235126', '235594', '235594', '235594', '238183', '238183', '238183', '244779', '244779',
        '244779', '249683', '259760', '272926', '272926', '272926', '280037', '280037', '280037', '282071', '282943',
        '282943', '282943', '287036', '299789', '449036', '449037', '449038', '449039', '450722', '450722', '470728',
        '470728', '474077', '474077',
    }


class OphthalmicAntiInflammatoryGlucocorticoids(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Anti-inflammatory, Glucocorticoids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '181328', '181328', '184163', '185512', '185512', '194606', '197637', '197637', '202271', '202271', '213227',
        '213466', '213466', '215898', '220951', '220951', '224010', '224010', '224010', '224010', '231842', '231842',
        '235750', '236306', '243673', '244545', '244545', '245882', '245882', '245882', '249383', '249383', '259925',
        '259925', '259925', '259925', '272590', '272590', '272590', '294917', '294917', '294917', '299207', '473925',
        '473988', '553736', '553736', '554754', '554847', '556100', '556270', '559212', '559230', '565648', '565656',
        '575457', '575873', '582720', '583301',
    }


class OphthalmicIntraocularPressureReducingAgentsProstaglandinAnalogs(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic-Intraocular Pressure Reducing Agents, Prostaglandin Analogs'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153566', '194459', '194459', '198982', '198982', '198982', '257110', '269596', '284354', '546896', '546896',
        '550674', '550674', '562155', '562155', '562155', '562162', '562162', '562162', '570554', '570681', '594867',
        '594947',
    }


class OphthalmicMydriaticsAndCycloplegics(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Mydriatics and Cycloplegics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154734', '164071', '199638', '199638', '199638', '199979', '199979', '199979', '207563', '214879', '214879',
        '214879', '228396', '244713', '244713', '244713', '256555', '256555', '260251', '260251', '260924', '260924',
        '271971', '271971', '285195', '285195', '285195', '287196', '287196', '287196', '298645', '443492', '446336',
        '446337', '592188', '592273', '592273', '593564', '594244', '595048',
    }


class MydriaticAndCycloplegicCombinations(ValueSet):
    VALUE_SET_NAME = 'Mydriatic and Cycloplegic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '256555', '256555', '260924', '260924', '446336', '446337', '592273', '592273', '593564', '594244', '595048',
    }


class OphthalmicDecongestants(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Decongestants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150113', '163215', '168822', '195108', '195108', '196737', '196737', '256893', '275459', '275459', '275459',
        '275459', '290226', '440268', '446469', '446469', '446716', '446717', '446721', '474660', '474660', '551057',
        '551057', '551066', '551066', '553276', '553651', '553652', '560742', '560753', '572392', '572392', '572444',
        '572444', '572888', '575944', '576081', '576081', '576159', '577364', '589877', '589878', '589878',
    }


class OphthalmicDecongestantCombinations(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic Decongestant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154618', '183116', '229864', '229864', '229864', '240933', '268441', '277990', '288572', '288572', '288572',
        '295329', '440273', '446714', '446722', '476192', '476195', '550705', '552811', '552995', '553609', '553649',
        '564273', '572081', '579356', '579367', '580993', '581686', '581694', '593212', '593224',
    }


class OphthalmicMiotics(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Miotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164921', '189897', '210347', '240030', '247504', '257278', '257947', '278179', '280154', '285349', '289514',
        '292269',
    }


class MioticsDirectActing(ValueSet):
    VALUE_SET_NAME = 'Miotics - Direct Acting'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164921', '189897', '210347', '240030', '247504', '257947', '278179', '280154', '285349', '289514',
    }


class MioticsCholinesteraseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Miotics - Cholinesterase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '257278', '292269',
    }


class OphthalmicAdrenergicAgents(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Adrenergic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class OphthalmicIntraocularPressReducingSelAlphaAdrenergicAgonists(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic-Intraocular Press. Reducing, Sel. Alpha Adrenergic Agonists'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '169061', '169061', '201916', '201916', '201916', '224905', '224905', '236869', '249555', '249555', '249555',
        '285485', '291845', '291845', '291845', '474933', '474933', '474933', '476455', '476455', '476455',
    }


class OphthalmicLocalAnestheticEsters(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Local Anesthetic Esters'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159492', '183831', '183831', '193781', '284225', '549453', '551604', '560008', '560009', '560101', '560170',
        '560745', '560746', '563104', '563104', '584969',
    }


class OphthalmicLocalAnestheticCombinations(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Local Anesthetic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '192782', '251346', '453648',
    }


class OphthalmicSurgicalAidsAdjuncts(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Surgical Aids-Adjuncts'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165590', '165590', '167430', '173089', '173089', '173089', '173557', '178947', '178947', '178947', '187958',
        '191105', '195513', '207416', '214048', '219147', '234134', '235057', '235057', '235057', '239113', '239113',
        '240563', '263480', '263480', '273354', '297764', '297764', '444450', '444813', '451734', '475217', '475581',
        '545069', '545070', '550637', '559663', '559667', '570544', '573424', '586807', '587011', '593951', '593966',
    }


class OphthalmicSurgicalAidCombinations(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Surgical Aid Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '173557', '207416', '239113', '239113', '240563', '263480', '263480', '451734', '545069', '545070',
    }


class OphthalmicOthers(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic Others'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '474108', '553731', '572397', '572468',
    }


class OphthalmicAntiAllergy(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Anti-allergy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159233', '162232', '176726', '176726', '177371', '191921', '208878', '227774', '237026', '237754', '241447',
        '244041', '273343', '453916', '453922', '549075', '549088', '549718', '555128', '559303', '559303', '559327',
        '559327', '561662', '562271', '563035', '563044', '565790', '565790', '573347', '584040', '584058',
    }


class OphthalmicCarbonicAnhydraseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Carbonic Anhydrase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '163045', '181530', '181530', '220502', '220502', '297032',
    }


class OphthalmicIrrigationSolutions(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Irrigation Solutions'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '164826', '175905', '205057', '205057', '205057', '257189', '296320', '296320', '440363', '440365', '440365',
        '446015', '446015', '446016', '446016', '449858', '450900', '450900', '453591', '453591', '453591', '453623',
        '453623', '453623', '453623', '453623', '453623', '465890', '467719', '467719', '467719', '467719', '467757',
        '467761', '467761', '467761', '467761', '468092', '468092', '550633', '550633', '550633', '550633', '550633',
        '550633', '572617', '572617', '577514', '577514', '577514', '577514',
    }


class OphthalmicHyperosmolarAgents(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Hyperosmolar Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152810', '152810', '171790', '221568', '239449', '239449', '247583', '275131', '298285', '400979', '400979',
        '400980', '552469',
    }


class OphthalmicAntiInflammatoryNsaids(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Anti-inflammatory, NSAIDs'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '180742', '213529', '213529', '213529', '241356', '241356', '249410', '257366', '451394', '451417', '473684',
        '473684', '473684', '474942', '474968', '558847', '558857', '576342', '576342', '576343', '576343', '577807',
        '577808', '590238', '590252',
    }


class OphthalmicDiagnosticAgents(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic - Diagnostic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '191825', '197259', '204145', '210743', '210743', '227937', '263927', '274046', '286310', '287355', '453650',
        '467934', '546130', '546130', '546166', '580205',
    }


class OphthalmicCombinations(ValueSet):
    VALUE_SET_NAME = 'Ophthalmic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '187236', '189831', '196316', '196583', '199222', '199222', '207903', '219853', '221480', '241948', '258105',
        '277687', '286307', '289705', '289705', '298903', '298903', '298903', '299817', '440143', '440143', '440145',
        '440148', '440148', '440148', '443522', '473029', '473029', '473099', '473099', '562016', '562020', '576514',
        '583037', '584805', '594040', '594067', '594135', '595629', '595629', '595881',
    }


class ContactLensPreparations(ValueSet):
    VALUE_SET_NAME = 'Contact Lens Preparations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152846', '152846', '164662', '164662', '178954', '178954', '190620', '204284', '204986', '234756', '234756',
        '250378', '277674', '277765', '440429', '440491', '445996', '445996', '445996', '445996', '448738', '448738',
        '450740', '450771', '450912', '450928', '450928', '450928', '450929', '466561', '471372', '474574', '474574',
        '474574', '474583', '474583', '474583', '474584', '474585', '474585', '474586', '474589', '474589', '545382',
        '545382', '545382', '547663', '547663', '547664', '552854', '552854', '552854', '553139', '559505', '559909',
        '561992', '569581', '570620', '570801', '570841', '573185', '577630',
    }


class ContactLensPreparationHardLensProducts(ValueSet):
    VALUE_SET_NAME = 'Contact Lens Preparation - Hard Lens Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '450928', '450928', '450928', '450929', '547663', '547663', '547664', '570620', '570801', '570841', '577630',
    }


class ContactLensPreparationSoftLensProducts(ValueSet):
    VALUE_SET_NAME = 'Contact Lens Preparation - Soft Lens Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152846', '152846', '164662', '164662', '178954', '178954', '204284', '204986', '234756', '234756', '250378',
        '277674', '277765', '440429', '445996', '445996', '445996', '445996', '448738', '448738', '450771', '450912',
        '466561', '471372', '474574', '474574', '474574', '474583', '474583', '474583', '474584', '474585', '474585',
        '474586', '474589', '474589', '545382', '545382', '545382', '552854', '552854', '552854', '553139', '559909',
        '561992', '569581', '573185',
    }


class ContactLensPreparationOxygenPermeableLensProducts(ValueSet):
    VALUE_SET_NAME = 'Contact Lens Preparation - Oxygen Permeable Lens Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '440491', '450740',
    }


class ContactLensPreparationHardSoftGasPermeableProducts(ValueSet):
    VALUE_SET_NAME = 'Contact Lens Preparation - Hard/Soft/Gas Permeable Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '190620', '559505',
    }


class Otic(ValueSet):
    VALUE_SET_NAME = 'Otic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150114', '153170', '153170', '158017', '158768', '159163', '159163', '166617', '191618', '195307', '201426',
        '201426', '212598', '212630', '221087', '221087', '222089', '222089', '227104', '230134', '230140', '231904',
        '231904', '231904', '231951', '238388', '238963', '253239', '256919', '256919', '256919', '256919', '263200',
        '263200', '276926', '283169', '283176', '289685', '293716', '293768', '298214', '299910', '440525', '440527',
        '440529', '440529', '445847', '446140', '446284', '451186', '451215', '451827', '467655', '471844', '475715',
        '476010', '550867', '550867', '552554', '552563', '553732', '557431', '557443', '558345', '558380', '558467',
        '558480', '558533', '558664', '558756', '558757', '559316', '560572', '564252', '565420', '566106', '571592',
        '574504', '574512', '581195', '586815', '588707', '588727', '590605', '590839',
    }


class OticAntiInfectives(ValueSet):
    VALUE_SET_NAME = 'Otic - Anti-infectives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159163', '159163', '201426', '201426', '221087', '221087', '558467', '558480', '588707', '588727',
    }


class OticAnalgesics(ValueSet):
    VALUE_SET_NAME = 'Otic - Analgesics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class OticGlucocorticoids(ValueSet):
    VALUE_SET_NAME = 'Otic - Glucocorticoids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '230140', '293768', '467655', '471844', '475715', '476010',
    }


class OticOther(ValueSet):
    VALUE_SET_NAME = 'Otic - Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class OticAgentsForThePinna(ValueSet):
    VALUE_SET_NAME = 'Otic - Agents For the Pinna'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '195307', '298214',
    }


class OticPinnaCombinations(ValueSet):
    VALUE_SET_NAME = 'Otic - Pinna Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '195307', '298214',
    }


class OticCombinations(ValueSet):
    VALUE_SET_NAME = 'Otic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153170', '153170', '158017', '166617', '212598', '212630', '222089', '222089', '231904', '231904', '231904',
        '238388', '238963', '276926', '283176', '299910', '445847', '446140', '446284', '451186', '451215', '451827',
        '550867', '550867', '552554', '552563', '553732', '558345', '558380', '558756', '558757', '559316', '560572',
        '564252', '566106', '571592', '581195', '586815', '590605', '590839',
    }


class OticAntiInfectiveGlucocorticoidCombinations(ValueSet):
    VALUE_SET_NAME = 'Otic - Anti-infective-Glucocorticoid Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153170', '153170', '158017', '238388', '276926', '283176', '299910', '451186', '451215', '550867', '550867',
        '590605', '590839',
    }


class MouthThroatDentalPreparations(ValueSet):
    VALUE_SET_NAME = 'Mouth-Throat-Dental - Preparations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150349', '150349', '150687', '152765', '155496', '155496', '157331', '157623', '158076', '158398', '159268',
        '159268', '159268', '159268', '160656', '161909', '161991', '163004', '164446', '167551', '167964', '168504',
        '168504', '168504', '174060', '174060', '176483', '183076', '183076', '183076', '183076', '184843', '184843',
        '185246', '185246', '185246', '187501', '188530', '195585', '198921', '199484', '199484', '200701', '201673',
        '205409', '206050', '208524', '208524', '211845', '211867', '213055', '217641', '220159', '223728', '225682',
        '225760', '227885', '228145', '228145', '228192', '228192', '228662', '231789', '231789', '233374', '236336',
        '238551', '238551', '239136', '240711', '241848', '243045', '243045', '245694', '246718', '246718', '250045',
        '254006', '254379', '259530', '259530', '260271', '269554', '270455', '272919', '275878', '276800', '280643',
        '282319', '282319', '282532', '285396', '286979', '287076', '287076', '287076', '287076', '287076', '287076',
        '287076', '288978', '289260', '289260', '289260', '289260', '291745', '292427', '293440', '293440', '294040',
        '296061', '296078', '296078', '296078', '296261', '296261', '400302', '400302', '400320', '400946', '401043',
        '401116', '440642', '440642', '440661', '440661', '440701', '440705', '440705', '440707', '440735', '440750',
        '440751', '443452', '443901', '443902', '444834', '444962', '445314', '446780', '446788', '447092', '447134',
        '448628', '448912', '448912', '449393', '449393', '449409', '449409', '449664', '449720', '449726', '450508',
        '451629', '451629', '451629', '452323', '453163', '453163', '453538', '453682', '454126', '454413', '454414',
        '464641', '465521', '465903', '465961', '465961', '471085', '471750', '471751', '471754', '471755', '473206',
        '473222', '473625', '473632', '473661', '473668', '474464', '474464', '475208', '475213', '475303', '475303',
        '475303', '475582', '475587', '475978', '475978', '475978', '475978', '475995', '475995', '476000', '476000',
        '476000', '476000', '476001', '476001', '476001', '476179', '476180', '476180', '476188', '476232', '476242',
        '476244', '476248', '476440', '476440', '476440', '476824', '511678', '513569', '515464', '545327', '545327',
        '545353', '545458', '545765', '545765', '545777', '545777', '545897', '545897', '545915', '545915', '546007',
        '546007', '546008', '546485', '546485', '547313', '547577', '547611', '549662', '549662', '549712', '549712',
        '550237', '550254', '550254', '550257', '550291', '550292', '550344', '550347', '550407', '550558', '550558',
        '550620', '552143', '552143', '552163', '552163', '552587', '552678', '553441', '553454', '553531', '553557',
        '553591', '553717', '553829', '553829', '554472', '554644', '554644', '554673', '555084', '555158', '555158',
        '555164', '555164', '555549', '555809', '556030', '556032', '556037', '556054', '556055', '556204', '556547',
        '556571', '556893', '556893', '556894', '556904', '556904', '556905', '557398', '557410', '557433', '557434',
        '558655', '559096', '559893', '559894', '559896', '559911', '560301', '560308', '560850', '560850', '560853',
        '560853', '561670', '561671', '561672', '561675', '562134', '562134', '562160', '562160', '562638', '562638',
        '562913', '562926', '563088', '563706', '563818', '564250', '564279', '564280', '564281', '564282', '564328',
        '564329', '564331', '564336', '564347', '565324', '565379', '565653', '565767', '565792', '565792', '565792',
        '565793', '565833', '565834', '565911', '566900', '566952', '567373', '567729', '572275', '572302', '572391',
        '572438', '572616', '572835', '573207', '573708', '574065', '574106', '574106', '574156', '574156', '575132',
        '575157', '575374', '575452', '575629', '576266', '576863', '577103', '577179', '577179', '577232', '577232',
        '578002', '578002', '578135', '578232', '579110', '579495', '579495', '579533', '579533', '579604', '579652',
        '579657', '579658', '579658', '579658', '579659', '579678', '579679', '579679', '579680', '579680', '579680',
        '579947', '579947', '579948', '579948', '579948', '579949', '579979', '579989', '580389', '580395', '580465',
        '580465', '580465', '580465', '580465', '580465', '580465', '580465', '580465', '580518', '580518', '580518',
        '580518', '580520', '580520', '580520', '580520', '580520', '580956', '580956', '581440', '581440', '581440',
        '581665', '581665', '581665', '581834', '582249', '582393', '582786', '582802', '582807', '582808', '582898',
        '582898', '582923', '582924', '582964', '583017', '583026', '583689', '583790', '585182', '585211', '585410',
        '585993', '586683', '586683', '586900', '586920', '586995', '587020', '587638', '587638', '588862', '588862',
        '588976', '588976', '589747', '589981', '590150', '590575', '590999', '591006', '591038', '591192', '591986',
        '592699', '592718', '593367', '593461', '593492', '593945', '594110', '594204', '594294', '594429', '594473',
        '595189', '595247', '595253', '595960',
    }


class MouthAndThroatAntiInfectives(ValueSet):
    VALUE_SET_NAME = 'Mouth and Throat - Anti-infectives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155496', '155496', '159268', '159268', '159268', '159268', '160656', '168504', '168504', '168504', '184843',
        '184843', '185246', '185246', '185246', '195585', '228192', '228192', '233374', '236336', '238551', '238551',
        '270455', '282319', '282319', '400302', '400302', '440642', '440642', '440661', '440661', '475303', '475303',
        '475303', '547313', '552678', '557398', '557410', '557433', '557434', '560308', '574065', '579110', '582249',
    }


class MouthAndThroatAntiseptics(ValueSet):
    VALUE_SET_NAME = 'Mouth and Throat - Antiseptics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '160656', '168504', '168504', '168504', '184843', '184843', '185246', '185246', '185246', '195585', '228192',
        '228192', '233374', '236336', '238551', '238551', '270455', '282319', '282319', '400302', '400302', '440642',
        '440642', '440661', '440661', '475303', '475303', '475303', '547313', '552678', '557398', '557410', '557433',
        '557434', '560308', '574065', '579110', '582249',
    }


class MouthAndThroatLozenges(ValueSet):
    VALUE_SET_NAME = 'Mouth and Throat - Lozenges'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157623', '161909', '167964', '294040', '296061', '296078', '296078', '296078', '400946', '401043', '445314',
        '453538', '453682', '464641', '465521', '465903', '475978', '475978', '475978', '475978', '475995', '475995',
        '476000', '476000', '476000', '476000', '476001', '476001', '476001', '547577', '547611', '550237', '550254',
        '550254', '550257', '550291', '550292', '550344', '550347', '550407', '550558', '550558', '553829', '553829',
        '555809', '556547', '556571', '556893', '556893', '556894', '556904', '556904', '556905', '564279', '564280',
        '564281', '564282', '564328', '564329', '564331', '564336', '565324', '565379', '565792', '565792', '565792',
        '565793', '565833', '565834', '566900', '566952', '572275', '572302', '578135', '579657', '579658', '579658',
        '579658', '579659', '579678', '579679', '579679', '579680', '579680', '579680', '579947', '579947', '579948',
        '579948', '579948', '579949', '582898', '582898', '591986',
    }


class MouthAndThroatGlucocorticoids(ValueSet):
    VALUE_SET_NAME = 'Mouth and Throat - Glucocorticoids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '225760', '440701',
    }


class MouthAndThroatAphthousUlcerTherapy(ValueSet):
    VALUE_SET_NAME = 'Mouth and Throat - Aphthous Ulcer Therapy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MouthAndThroatMouthwashes(ValueSet):
    VALUE_SET_NAME = 'Mouth and Throat - Mouthwashes'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '206050', '269554', '288978', '440705', '440705', '440707', '448912', '448912', '450508', '452323', '454126',
        '582393',
    }


class MouthAndThroatLocalAnesthetics(ValueSet):
    VALUE_SET_NAME = 'Mouth and Throat - Local Anesthetics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150349', '150349', '152765', '157331', '158076', '174060', '174060', '183076', '183076', '183076', '183076',
        '199484', '199484', '208524', '208524', '211867', '217641', '220159', '223728', '225682', '227885', '228145',
        '228145', '231789', '231789', '259530', '259530', '276800', '285396', '287076', '287076', '287076', '287076',
        '287076', '287076', '287076', '291745', '296261', '296261', '440735', '440750', '440751', '446780', '449664',
        '451629', '451629', '451629', '471085', '473206', '473222', '473625', '473632', '473661', '473668', '475582',
        '475587', '511678', '545458', '545897', '545897', '545915', '545915', '546007', '546007', '546008', '546485',
        '546485', '550620', '552143', '552143', '552163', '552163', '552587', '553557', '553591', '553717', '556037',
        '556204', '558655', '559911', '560301', '562638', '562638', '563088', '565653', '567373', '567729', '572616',
        '573708', '575629', '576863', '577103', '579604', '579652', '581834', '585182', '585211', '585410', '585993',
        '589747', '593945', '594429', '594473', '595960',
    }


class DentalPeriodontalProducts(ValueSet):
    VALUE_SET_NAME = 'Dental-Periodontal Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150687', '161991', '163004', '164446', '167551', '176483', '187501', '188530', '200701', '201673', '205409',
        '211845', '213055', '228662', '240711', '241848', '245694', '246718', '246718', '250045', '254006', '254379',
        '260271', '275878', '280643', '282532', '286979', '289260', '289260', '289260', '289260', '292427', '443901',
        '443902', '446788', '448628', '449720', '449726', '474464', '474464', '476440', '476440', '476440', '476824',
        '513569', '515464', '545327', '545327', '545353', '553441', '553454', '553531', '554472', '555084', '555158',
        '555158', '555164', '555164', '555549', '559096', '559893', '559894', '559896', '561670', '561671', '561672',
        '561675', '563706', '563818', '564250', '564347', '572835', '573207', '576266', '582786', '582802', '582807',
        '582808', '582923', '582924', '583017', '583026', '591192', '593367', '593461',
    }


class DentalProductAstringents(ValueSet):
    VALUE_SET_NAME = 'Dental Product - Astringents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DentalProductDisinfectants(ValueSet):
    VALUE_SET_NAME = 'Dental Product - Disinfectants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DentalProductHemostatics(ValueSet):
    VALUE_SET_NAME = 'Dental Product - Hemostatics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DentalProductFluoridePreparations(ValueSet):
    VALUE_SET_NAME = 'Dental Product - Fluoride Preparations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150687', '163004', '164446', '167551', '176483', '187501', '188530', '201673', '205409', '211845', '213055',
        '228662', '240711', '241848', '245694', '246718', '246718', '250045', '254006', '254379', '260271', '275878',
        '282532', '286979', '289260', '289260', '289260', '289260', '292427', '443901', '443902', '446788', '448628',
        '474464', '474464', '476440', '476440', '476440', '545327', '545327', '545353', '553441', '553454', '553531',
        '554472', '559096', '559893', '559894', '559896', '561670', '561671', '561672', '561675', '563706', '564250',
        '564347', '576266', '583017', '583026', '593367',
    }


class DentalProductDentalAids(ValueSet):
    VALUE_SET_NAME = 'Dental Product - Dental Aids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class PeriodontalProductAntiInfectives(ValueSet):
    VALUE_SET_NAME = 'Periodontal Product - Anti-infectives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '280643', '449720', '449726',
    }


class PeriodontalProductsOther(ValueSet):
    VALUE_SET_NAME = 'Periodontal Products Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MouthAndThroatOther(ValueSet):
    VALUE_SET_NAME = 'Mouth and Throat Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MouthAndThroatArtificialSaliva(ValueSet):
    VALUE_SET_NAME = 'Mouth and Throat - Artificial Saliva'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '293440', '293440', '453163', '453163', '465961', '465961', '475208', '475213', '476232', '476242', '476244',
        '476248', '549662', '549662', '549712', '549712', '560850', '560850', '560853', '560853', '575132', '575157',
        '581440', '581440', '581440', '581665', '581665', '581665', '586683', '586683', '586995', '587020', '587638',
        '587638', '588862', '588862', '588976', '588976', '590575', '594204', '594294', '595189',
    }


class MouthAndThroatSalivaStimulants(ValueSet):
    VALUE_SET_NAME = 'Mouth and Throat - Saliva Stimulants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158398', '198921', '239136', '243045', '243045', '454413', '454414', '556030', '556032', '556054', '556055',
        '574106', '574106', '574156', '574156', '586900', '586920', '589981', '590150', '592699', '592718',
    }


class MouthAndThroatProtectants(ValueSet):
    VALUE_SET_NAME = 'Mouth and Throat - Protectants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '579979', '579989', '580389', '580395', '580465', '580465', '580465', '580465', '580465', '580465', '580465',
        '580465', '580465', '580518', '580518', '580518', '580518', '580520', '580520', '580520', '580520', '580520',
        '593492', '594110',
    }


class AnorectalPreparations(ValueSet):
    VALUE_SET_NAME = 'Anorectal Preparations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151419', '159373', '166801', '168811', '170050', '172928', '172928', '172928', '175888', '184493', '184797',
        '184797', '190786', '190786', '190786', '197538', '197538', '197538', '197538', '207252', '207252', '209537',
        '209537', '212595', '212595', '212595', '212595', '212595', '212781', '219119', '228723', '228723', '233874',
        '242027', '242047', '242941', '244890', '249332', '262774', '262774', '278350', '278350', '290744', '290744',
        '295612', '296257', '440837', '440837', '443841', '443841', '448909', '448909', '450947', '450947', '451590',
        '451590', '454076', '468286', '468309', '468309', '468363', '469653', '469653', '469653', '469653', '472698',
        '474389', '474954', '475986', '476159', '476184', '476184', '476186', '476186', '476202', '476587', '476772',
        '545064', '546407', '546407', '546484', '546484', '550318', '550318', '551027', '552234', '553238', '553246',
        '558379', '558787', '558788', '559146', '559147', '560631', '560631', '560631', '560631', '560631', '560636',
        '560636', '560636', '562802', '563270', '563273', '563552', '563552', '564454', '564490', '564592', '564602',
        '569822', '569822', '570024', '570024', '570029', '570081', '570089', '570089', '570678', '570678', '571796',
        '574767', '575158', '575205', '576958', '577247', '577247', '577776', '577824', '578953', '578953', '579404',
        '579404', '579517', '579517', '580111', '580230', '580230', '580293', '580293', '580293', '580355', '580372',
        '580407', '580407', '580407', '581829', '581829', '582059', '582461', '583962', '583962', '584801', '585801',
        '585801', '587419', '587472', '587748', '587748', '587749', '590363', '590749', '591640', '591893', '591966',
        '592001', '592834',
    }


class AnorectalGlucocorticoids(ValueSet):
    VALUE_SET_NAME = 'Anorectal - Glucocorticoids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159373', '170050', '190786', '190786', '190786', '212595', '212595', '212595', '212595', '212595', '219119',
        '233874', '242027', '249332', '278350', '278350', '443841', '443841', '578953', '578953', '580230', '580230',
        '587748', '587748', '587749', '590363', '591640', '591893', '591966', '592001', '592834',
    }


class InflammatoryBowelAgentGlucocorticoids(ValueSet):
    VALUE_SET_NAME = 'Inflammatory Bowel Agent - Glucocorticoids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '249289', '266986', '267499', '274798', '293882', '296506', '453663', '576821', '576824', '583129', '583132',
    }


class AnorectalLocalAnesthetics(ValueSet):
    VALUE_SET_NAME = 'Anorectal - Local Anesthetics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '172928', '172928', '172928', '175888', '295612', '451590', '451590', '569822', '569822', '570678', '570678',
        '571796', '590749',
    }


class AnorectalHemorrhoidalSingleAgentsOther(ValueSet):
    VALUE_SET_NAME = 'Anorectal - Hemorrhoidal Single Agents Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '450947', '450947', '454076', '468286', '468309', '468309', '468363', '560631', '560631', '560631', '560631',
        '560631', '560636', '560636', '560636', '562802', '563552', '563552', '574767', '577247', '577247', '584801',
    }


class AnorectalCombinations(ValueSet):
    VALUE_SET_NAME = 'Anorectal Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151419', '166801', '168811', '184493', '184797', '184797', '197538', '197538', '197538', '197538', '207252',
        '207252', '209537', '209537', '212781', '228723', '228723', '242047', '242941', '244890', '262774', '262774',
        '290744', '290744', '296257', '440837', '440837', '448909', '448909', '469653', '469653', '469653', '469653',
        '472698', '474389', '474954', '475986', '476159', '476184', '476184', '476186', '476186', '476202', '476587',
        '476772', '545064', '546407', '546407', '546484', '546484', '550318', '550318', '551027', '552234', '553238',
        '553246', '558379', '558787', '558788', '559146', '559147', '563270', '563273', '564454', '564490', '564592',
        '564602', '570024', '570024', '570089', '570089', '575158', '575205', '576958', '577776', '577824', '579404',
        '579404', '579517', '579517', '580111', '580293', '580293', '580293', '580355', '580372', '580407', '580407',
        '580407', '581829', '581829', '582059', '582461', '583962', '583962', '585801', '585801', '587419', '587472',
    }


class AnorectalHemorrhoidalRectalGlucocorticoidLocalAnestheticComb(ValueSet):
    VALUE_SET_NAME = 'Anorectal - Hemorrhoidal Rectal Glucocorticoid-Local Anesthetic Comb'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '166801', '168811', '184493', '212781', '242047', '242941', '244890', '296257', '448909', '448909', '472698',
        '474389', '476202', '476587', '476772', '545064', '551027', '558379', '558787', '558788', '559146', '559147',
        '563270', '563273', '564454', '564490', '564592', '564602', '582461',
    }


class AnorectalHemorrhoidalAndLocalAnestheticCombinationsOther(ValueSet):
    VALUE_SET_NAME = 'Anorectal - Hemorrhoidal and Local Anesthetic Combinations Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '546407', '546407', '546484', '546484', '552234', '553238', '553246', '583962', '583962', '585801', '585801',
        '587419', '587472',
    }


class AnorectalHemorrhoidalGlucocorticoidCombinationsOther(ValueSet):
    VALUE_SET_NAME = 'Anorectal - Hemorrhoidal Glucocorticoid Combinations Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AnorectalHemorrhoidalCombinationsOther(ValueSet):
    VALUE_SET_NAME = 'Anorectal - Hemorrhoidal Combinations Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151419', '184797', '184797', '197538', '197538', '197538', '197538', '207252', '207252', '209537', '209537',
        '228723', '228723', '262774', '262774', '290744', '290744', '440837', '440837', '469653', '469653', '469653',
        '469653', '474954', '475986', '476159', '476184', '476184', '476186', '476186', '550318', '550318', '570024',
        '570024', '570089', '570089', '575158', '575205', '576958', '577776', '577824', '579404', '579404', '579517',
        '579517', '580111', '580293', '580293', '580293', '580355', '580372', '580407', '580407', '580407', '581829',
        '581829', '582059',
    }


class Dermatological(ValueSet):
    VALUE_SET_NAME = 'Dermatological'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150124', '150496', '150651', '150651', '150689', '150689', '150879', '150879', '150975', '151102', '151264',
        '151272', '151351', '151351', '151426', '151426', '152018', '152163', '152312', '152312', '152832', '153294',
        '153410', '153466', '153688', '153971', '153999', '154014', '154274', '155216', '155274', '155643', '155651',
        '155651', '155651', '155651', '155712', '155712', '155712', '155737', '155737', '155737', '155737', '155737',
        '155737', '155737', '155737', '156087', '156120', '156120', '156241', '156241', '156531', '156531', '156823',
        '157376', '157376', '157380', '158383', '158410', '158546', '158620', '158682', '159167', '159390', '159390',
        '159412', '159650', '159715', '159833', '159840', '159840', '159871', '160074', '160074', '160080', '160080',
        '160206', '160532', '160532', '160882', '160882', '160882', '160882', '161463', '161476', '161476', '161752',
        '161752', '161752', '161752', '161752', '161752', '162436', '162436', '162436', '162436', '162436', '162722',
        '162726', '162726', '162726', '162726', '162726', '162726', '162850', '163192', '163508', '163915', '163988',
        '163988', '163988', '163988', '164024', '164024', '164310', '164430', '164549', '164549', '164616', '164619',
        '164702', '164702', '164750', '164796', '164993', '165123', '165123', '165205', '165205', '165332', '165649',
        '165684', '166234', '166345', '166488', '166632', '166632', '166759', '166759', '166759', '166759', '166968',
        '166968', '166968', '166968', '166968', '167021', '167074', '167541', '167998', '168010', '168010', '168010',
        '168010', '168010', '168010', '168010', '168010', '168010', '168333', '168333', '168343', '168343', '168343',
        '168344', '168715', '168743', '168743', '168800', '168800', '168800', '169364', '169481', '170175', '170175',
        '170370', '170520', '170523', '170523', '170523', '170523', '170641', '170765', '170849', '170969', '170969',
        '170969', '171036', '171036', '171103', '171514', '171514', '171723', '171739', '171739', '171870', '171970',
        '171970', '171995', '172139', '172139', '172139', '172263', '172263', '172455', '172900', '172900', '173059',
        '173329', '173353', '173353', '173353', '173353', '173353', '173353', '173353', '173353', '173353', '173353',
        '173353', '173353', '173353', '173353', '173447', '173451', '174134', '174134', '174355', '174539', '174539',
        '174676', '174676', '174676', '174768', '174897', '174897', '175188', '175188', '175585', '175585', '175585',
        '175585', '175911', '176231', '176231', '176591', '176716', '176716', '176721', '176721', '176902', '176902',
        '176979', '176996', '176996', '177463', '177632', '177667', '177667', '177667', '177667', '177667', '177667',
        '177667', '178065', '178065', '178255', '178304', '178453', '178454', '178454', '178454', '178530', '178706',
        '178706', '178706', '178786', '178786', '178786', '178854', '178854', '178854', '178854', '178854', '178854',
        '178926', '178926', '178926', '178926', '179075', '179266', '179266', '179498', '179498', '179662', '179662',
        '179662', '180120', '180120', '180120', '180162', '180193', '180193', '180193', '180193', '180193', '180193',
        '180240', '180702', '180702', '180702', '180702', '180796', '180796', '180796', '180930', '180930', '180930',
        '180930', '180930', '181129', '181284', '181337', '181392', '181392', '181392', '181392', '181392', '181785',
        '181913', '181913', '181913', '181913', '181913', '181961', '181961', '182001', '182001', '182005', '182020',
        '182162', '182302', '182302', '182302', '182392', '182392', '182407', '182835', '182835', '182877', '183021',
        '183153', '183153', '183153', '183254', '183254', '183379', '183489', '183561', '183561', '184041', '184243',
        '184603', '184603', '184731', '185009', '185302', '185685', '185937', '185937', '185960', '185960', '185960',
        '185993', '186070', '186081', '186081', '186093', '186215', '186405', '186405', '186405', '186405', '186564',
        '186564', '186564', '186564', '186564', '186564', '186637', '186693', '186965', '186996', '186996', '187151',
        '187302', '187302', '187302', '187459', '187459', '187459', '187557', '187562', '187562', '187562', '187562',
        '187770', '187876', '188286', '188343', '188616', '188782', '188782', '188863', '188863', '188863', '188863',
        '188863', '189005', '189005', '189005', '189032', '189032', '189032', '189032', '189226', '189482', '189518',
        '189526', '189600', '189960', '190461', '190471', '190716', '190716', '190716', '190716', '190810', '190810',
        '190810', '191219', '191349', '191349', '191427', '191427', '191427', '191575', '191692', '191692', '191692',
        '191913', '191913', '191913', '192034', '192034', '192034', '192034', '192034', '192112', '192112', '192112',
        '192213', '192213', '192217', '192399', '192623', '192623', '192623', '192623', '192718', '192718', '192718',
        '193051', '193051', '193100', '193198', '193263', '193389', '193389', '193389', '193389', '193615', '193628',
        '193702', '193717', '193717', '193717', '193717', '193717', '193721', '194352', '194782', '194782', '194911',
        '194963', '195092', '195152', '195336', '195336', '195402', '195402', '195664', '196025', '196215', '196577',
        '196617', '196617', '196617', '196735', '196931', '196931', '196931', '197009', '197090', '197147', '197147',
        '197214', '197214', '197251', '197251', '197455', '197455', '197455', '197699', '198131', '198332', '198332',
        '198410', '198652', '198652', '198869', '198978', '199062', '200114', '200114', '200118', '200193', '200473',
        '200489', '200489', '200544', '200544', '200544', '200544', '200544', '200544', '200544', '200605', '200687',
        '200736', '201290', '201333', '201484', '201484', '201497', '201874', '201874', '201979', '201979', '201979',
        '202171', '202570', '202570', '202663', '202663', '202663', '202663', '202663', '202663', '202663', '202663',
        '202716', '202752', '202961', '203152', '203152', '203610', '203610', '203725', '204051', '204051', '204270',
        '204278', '204638', '204799', '204799', '205165', '205326', '205326', '205618', '205681', '206279', '206433',
        '206718', '206718', '206718', '206718', '206722', '207082', '207082', '207308', '207308', '207475', '207475',
        '207475', '207475', '207475', '207475', '207671', '207930', '207930', '208085', '208085', '208085', '208113',
        '208201', '208691', '208777', '208777', '208783', '208783', '208838', '208838', '209020', '209481', '209481',
        '209481', '209581', '209588', '209869', '209869', '209961', '209961', '210492', '211072', '211072', '211224',
        '211224', '211385', '211385', '211822', '211899', '211904', '211904', '211904', '211904', '211904', '211904',
        '211910', '211946', '212059', '212059', '212059', '212059', '212159', '212204', '212220', '212226', '212777',
        '212777', '212908', '212908', '212908', '213284', '213418', '213455', '213643', '213643', '213923', '213923',
        '213923', '213923', '214148', '214255', '214255', '214501', '214501', '214501', '214564', '214797', '214797',
        '214797', '214948', '215349', '215349', '215369', '215369', '215369', '215369', '215625', '215699', '215699',
        '216366', '216366', '216481', '216568', '217082', '217082', '217082', '217284', '217658', '217846', '218196',
        '218228', '218475', '218883', '219066', '219132', '219180', '219180', '219540', '219540', '219559', '219905',
        '219936', '219989', '219989', '220180', '220180', '220556', '220727', '220833', '220833', '220970', '221031',
        '221221', '221221', '221499', '221606', '221606', '221606', '221907', '221907', '221907', '221907', '221907',
        '221907', '222101', '222101', '222101', '222149', '222149', '222149', '222149', '222724', '222850', '222850',
        '223155', '223204', '223357', '223667', '223689', '223689', '223745', '223745', '223919', '224271', '224271',
        '224461', '224474', '224514', '224515', '224515', '224801', '224801', '224801', '224805', '224805', '224805',
        '224989', '224989', '224996', '224996', '225013', '225241', '225241', '225263', '225263', '225626', '225626',
        '225626', '225626', '225915', '226234', '226234', '226234', '226234', '226330', '226330', '226330', '226330',
        '226330', '226463', '226674', '226689', '226768', '226768', '226768', '227047', '227067', '227074', '227074',
        '227185', '227185', '227336', '227336', '227511', '227530', '227530', '227530', '227559', '227760', '228315',
        '228315', '228315', '228315', '228315', '228315', '228315', '228467', '228467', '228796', '228796', '228807',
        '228911', '228911', '228911', '228911', '228950', '228997', '229071', '229071', '229277', '229277', '229830',
        '229830', '229881', '230111', '230111', '230111', '230214', '230316', '230319', '230319', '230321', '230363',
        '230378', '230378', '230378', '230526', '230826', '230826', '230850', '230850', '230857', '230857', '231202',
        '231202', '231202', '231202', '231202', '231202', '231273', '231426', '231426', '231524', '231524', '231736',
        '231736', '231896', '232476', '232495', '232495', '232495', '232495', '232524', '232601', '232601', '232758',
        '232758', '232907', '232951', '233006', '233006', '233116', '233222', '233222', '233222', '233222', '233222',
        '233222', '233449', '233449', '233449', '233449', '233449', '233449', '234159', '234159', '234350', '234350',
        '234700', '234700', '234826', '234830', '235467', '235467', '235467', '235467', '235467', '235549', '235549',
        '235549', '235549', '235598', '235600', '235803', '235943', '235943', '235943', '235943', '235943', '235943',
        '235943', '235943', '235943', '236109', '236287', '236510', '236559', '236559', '236620', '236961', '237292',
        '237327', '237327', '237327', '237452', '237720', '237720', '237720', '237748', '237748', '237748', '237748',
        '237750', '237815', '238061', '238061', '238347', '238347', '238347', '238707', '238707', '238772', '238772',
        '238772', '239005', '239148', '239216', '239216', '239216', '239237', '239366', '239366', '239382', '239412',
        '239584', '239584', '239816', '239816', '240336', '240787', '240787', '241013', '241316', '241430', '241523',
        '241940', '241940', '241940', '242107', '242254', '242254', '242254', '242254', '242254', '242415', '242415',
        '242629', '242629', '242688', '242722', '242856', '242856', '242864', '242864', '242949', '242949', '242949',
        '242949', '243418', '243418', '243496', '243603', '243603', '244142', '244327', '244554', '244554', '244554',
        '244554', '244554', '244567', '244567', '244567', '244567', '244567', '244567', '244567', '244627', '244647',
        '244647', '244759', '244759', '245063', '245423', '245815', '245815', '246222', '246232', '246232', '246232',
        '246336', '246336', '246970', '246970', '246970', '246970', '246970', '247009', '247009', '247237', '247237',
        '247237', '247237', '247237', '247237', '247478', '247676', '248181', '248181', '248189', '248189', '248189',
        '248361', '248361', '248407', '248407', '248407', '248407', '248527', '248527', '248666', '248666', '248775',
        '249280', '249573', '249573', '249733', '249774', '249862', '249943', '249981', '250278', '250278', '250278',
        '250278', '250278', '250748', '250748', '250748', '250864', '250959', '250977', '250977', '251380', '251415',
        '251601', '251601', '251714', '251729', '251742', '251742', '251870', '251923', '251923', '252027', '252027',
        '252027', '252215', '252429', '253041', '253041', '253116', '253116', '253336', '253336', '253336', '253439',
        '253439', '253439', '253590', '253664', '253664', '253921', '254064', '254260', '254260', '254265', '254354',
        '254552', '254552', '254552', '254655', '255079', '255265', '255265', '255400', '255400', '255400', '255400',
        '255400', '255400', '255495', '255609', '255715', '256116', '256479', '256479', '256479', '256479', '256741',
        '256936', '257190', '257190', '257252', '257860', '257860', '257941', '257941', '258204', '258288', '258774',
        '258774', '258774', '258774', '258807', '258889', '258889', '259370', '259370', '259370', '260006', '260006',
        '260082', '260082', '260082', '260104', '260121', '260211', '260211', '260289', '260299', '260299', '260299',
        '260299', '260614', '260645', '260656', '260656', '260685', '260828', '260828', '261860', '261860', '261860',
        '261892', '262055', '262332', '262332', '262660', '262814', '262814', '262981', '263158', '263579', '263598',
        '263737', '263737', '264053', '264213', '264508', '264508', '264508', '264629', '264629', '264629', '264629',
        '264709', '264709', '264709', '264777', '264777', '264777', '264863', '264903', '264973', '264973', '264998',
        '264998', '264998', '265372', '265372', '265424', '265722', '265722', '265881', '265881', '266026', '266026',
        '266026', '266026', '266026', '266118', '266147', '266147', '266206', '266206', '266359', '266359', '266566',
        '266566', '266566', '266566', '266675', '266675', '266700', '267102', '267102', '267113', '267187', '267187',
        '267187', '267187', '267187', '267187', '267335', '267335', '267519', '267519', '267728', '267728', '267802',
        '267835', '267921', '268075', '268075', '268489', '268593', '268593', '268593', '268593', '268981', '269028',
        '269028', '269128', '269244', '269244', '269269', '269269', '269358', '269442', '269442', '269473', '269473',
        '269473', '269843', '269843', '269843', '269843', '269843', '269896', '269899', '269899', '269928', '270360',
        '270360', '270767', '270767', '270767', '270869', '270869', '270869', '270869', '270913', '271031', '271267',
        '271267', '271332', '271370', '271370', '271822', '271953', '271953', '272052', '272057', '272057', '272057',
        '272057', '272057', '272554', '272554', '272554', '273160', '273160', '273160', '273160', '273160', '273160',
        '273275', '273275', '273359', '273359', '273775', '273890', '273890', '273890', '273957', '273957', '274242',
        '274333', '274403', '274609', '274658', '274658', '274790', '274818', '274818', '274818', '275127', '275133',
        '275133', '275152', '275152', '275375', '275470', '275470', '275688', '275728', '275937', '275937', '275937',
        '275937', '275996', '275996', '276214', '276240', '276240', '276437', '276479', '276479', '276527', '276527',
        '276749', '276862', '276980', '277091', '277097', '277196', '277318', '277318', '277318', '277318', '277318',
        '277318', '277727', '277727', '278090', '278738', '278931', '279429', '279429', '279429', '279429', '279470',
        '279470', '279512', '279598', '279783', '279825', '279825', '279825', '279825', '279825', '280044', '280044',
        '280044', '280044', '280044', '280249', '280249', '280358', '280358', '280358', '280550', '280592', '280691',
        '280839', '280839', '280839', '280839', '280839', '281175', '281175', '281175', '281625', '281625', '281625',
        '281719', '281979', '281996', '281996', '282008', '282221', '282221', '282221', '282289', '282289', '282289',
        '282289', '282621', '282722', '282722', '282722', '282722', '282722', '282722', '282782', '282788', '283136',
        '283136', '283328', '283462', '283462', '283476', '283658', '283658', '283658', '283658', '283658', '283658',
        '283741', '284131', '284578', '284578', '284636', '284636', '284788', '284840', '284840', '284840', '284840',
        '285053', '285113', '285232', '285254', '285399', '285399', '285412', '285412', '285581', '285581', '285581',
        '285679', '285732', '285968', '285995', '285995', '285995', '286220', '286881', '287259', '287712', '287712',
        '287712', '287712', '287712', '287712', '287712', '287712', '287712', '287712', '287752', '287767', '287887',
        '288191', '288318', '288627', '288627', '288855', '288855', '288901', '289428', '289428', '289528', '289720',
        '289845', '289876', '290034', '290053', '290118', '290118', '290480', '290884', '290884', '291061', '291076',
        '291076', '291076', '291458', '291673', '291673', '291673', '291673', '291673', '291673', '291673', '291673',
        '291673', '291744', '291878', '291878', '291878', '292165', '292443', '292818', '292832', '292832', '292867',
        '292867', '292867', '293030', '293030', '293094', '293094', '293287', '293400', '293468', '293468', '293627',
        '293887', '294036', '294036', '294422', '294422', '294508', '294688', '294688', '295031', '295276', '295393',
        '295393', '295393', '295538', '295538', '295587', '295802', '295828', '295828', '295828', '295856', '295856',
        '295969', '295969', '296290', '296344', '296344', '296344', '296344', '296373', '296554', '296554', '296554',
        '296554', '296571', '296571', '296598', '296728', '296915', '297139', '297139', '297139', '297155', '297155',
        '297293', '297293', '297293', '297361', '297500', '297500', '297808', '297808', '297813', '297813', '297813',
        '297813', '297813', '297961', '297961', '297961', '298153', '298153', '298236', '298250', '298499', '298499',
        '298563', '298597', '298597', '298620', '298620', '298620', '298620', '298649', '298649', '298649', '298745',
        '298909', '298909', '298919', '298937', '299056', '299091', '299091', '299091', '299556', '299556', '299771',
        '299771', '299856', '299856', '299856', '299856', '299872', '299907', '299907', '400012', '400025', '400025',
        '400025', '400025', '400064', '400077', '400078', '400190', '400196', '400196', '400196', '400197', '400197',
        '400197', '400199', '400203', '400203', '400286', '400286', '400317', '400318', '400389', '400390', '400391',
        '400391', '400391', '400391', '400391', '400395', '400395', '400395', '400398', '400398', '400398', '400398',
        '400412', '400427', '400429', '400459', '400469', '400470', '400504', '400513', '400513', '400515', '400515',
        '400515', '400515', '400539', '400650', '400887', '400887', '400887', '400888', '400888', '400888', '400942',
        '401027', '401067', '440878', '440930', '440930', '440932', '440932', '440942', '440942', '440942', '440942',
        '440948', '441000', '441000', '441038', '441066', '441066', '441066', '441066', '441066', '441066', '441192',
        '441193', '441202', '441204', '441205', '441209', '441211', '441220', '441243', '441261', '441263', '441273',
        '441273', '441293', '441293', '441307', '441366', '441366', '441379', '441379', '441379', '441451', '441461',
        '441461', '441461', '441542', '441549', '441566', '441566', '441567', '441567', '441581', '441611', '441627',
        '441639', '441666', '441666', '441676', '441704', '441704', '441714', '441721', '441726', '441726', '441737',
        '441737', '441739', '441741', '441741', '441800', '441810', '441822', '441822', '441874', '441879', '441904',
        '441932', '441934', '441935', '441935', '441938', '441938', '441938', '441940', '441943', '441944', '441945',
        '441971', '441986', '441988', '441990', '441997', '442028', '442075', '442075', '442092', '442135', '442140',
        '442141', '442142', '442147', '442154', '442155', '442156', '442157', '442158', '442229', '442229', '442230',
        '442241', '442305', '442305', '442319', '442319', '442319', '442319', '442319', '442335', '442335', '442335',
        '442344', '442344', '442344', '442344', '442344', '442353', '442361', '442421', '442421', '442423', '443498',
        '443558', '443558', '443558', '443637', '443687', '443687', '443694', '443694', '443701', '443701', '443702',
        '443703', '443703', '443704', '443704', '443707', '443710', '443710', '443710', '443710', '443710', '443710',
        '443710', '443710', '443710', '443710', '443710', '443710', '443710', '443710', '443710', '443711', '443713',
        '443713', '443713', '443713', '443713', '443713', '443713', '443716', '443721', '443722', '443724', '443724',
        '443724', '443724', '443724', '443724', '443724', '443726', '443726', '443728', '443728', '443729', '443729',
        '443735', '443739', '443739', '443741', '443742', '443742', '443742', '443743', '443743', '443750', '443750',
        '443751', '443752', '443752', '443752', '443752', '443752', '443754', '443756', '443757', '443757', '443757',
        '443757', '443758', '443759', '443760', '443761', '443762', '443763', '443764', '443765', '443765', '443766',
        '443768', '443769', '443769', '443769', '443769', '443770', '443770', '443771', '443771', '443772', '443773',
        '443773', '443773', '443786', '443800', '443801', '443802', '443839', '443842', '443915', '443916', '443919',
        '443919', '443919', '443919', '443919', '443919', '443919', '443919', '443919', '443919', '443922', '443924',
        '443926', '443927', '443927', '443971', '444104', '444104', '444104', '444285', '444285', '444295', '444295',
        '444296', '444297', '444299', '444302', '444304', '444306', '444307', '444308', '444309', '444310', '444313',
        '444314', '444317', '444318', '444320', '444324', '444324', '444325', '444353', '444356', '444360', '444367',
        '444790', '444790', '444792', '444794', '444795', '444797', '444804', '444807', '444822', '444822', '444822',
        '444822', '444832', '444840', '444840', '444840', '444840', '444840', '444842', '444843', '444843', '444843',
        '444843', '444845', '444845', '444845', '444846', '444846', '444846', '444847', '444847', '444847', '444847',
        '444848', '444848', '444849', '444851', '444851', '444854', '444855', '444855', '444856', '444858', '444859',
        '444860', '444864', '444922', '444922', '444922', '444922', '444923', '444923', '444923', '444923', '444929',
        '444929', '444933', '445001', '445002', '445022', '445024', '445028', '445086', '445093', '445094', '445095',
        '445154', '445154', '445155', '445155', '445155', '445195', '445195', '445205', '445496', '445840', '445841',
        '445842', '445946', '445946', '445946', '445957', '445957', '445968', '445969', '445969', '445969', '445969',
        '445969', '445971', '446083', '446093', '446095', '446121', '446141', '446190', '446190', '446190', '446191',
        '446229', '446278', '446386', '446387', '446398', '446505', '446544', '446547', '446547', '446547', '446547',
        '446559', '446559', '446559', '446559', '446559', '446559', '446559', '446559', '446573', '446573', '446626',
        '446626', '446631', '446632', '446633', '446634', '446658', '446683', '446683', '446746', '446747', '446748',
        '446762', '446762', '446762', '446763', '446769', '446769', '446793', '446793', '446825', '446907', '446985',
        '446987', '446988', '446989', '446990', '446992', '446996', '447144', '447145', '447146', '447275', '447320',
        '447320', '447321', '447321', '447321', '447322', '447322', '447322', '447323', '447324', '447324', '447325',
        '447325', '447357', '447358', '447359', '447360', '447361', '447424', '447541', '447547', '447635', '447697',
        '447698', '447780', '447781', '447782', '447800', '447800', '447847', '447847', '447848', '447848', '447850',
        '447850', '447907', '447910', '447914', '448005', '448018', '448018', '448018', '448086', '448094', '448094',
        '448148', '448149', '448150', '448200', '448227', '448261', '448261', '448282', '448283', '448314', '448344',
        '448346', '448348', '448544', '448545', '448545', '448545', '448597', '448599', '448746', '448747', '448838',
        '448842', '448869', '448872', '448872', '448872', '448873', '448874', '448895', '448905', '448968', '448971',
        '448974', '448974', '449052', '449386', '449582', '449586', '449676', '449684', '449684', '449687', '449689',
        '449689', '449691', '449691', '449692', '449692', '449693', '449693', '449761', '449772', '449772', '449994',
        '449994', '449994', '449994', '449994', '449994', '449994', '449994', '449994', '449994', '449998', '449998',
        '449998', '449998', '449998', '449999', '449999', '450006', '450006', '450006', '450006', '450021', '450096',
        '450114', '450114', '450114', '450114', '450114', '450116', '450116', '450116', '450123', '450237', '450239',
        '450345', '450423', '450424', '450478', '450492', '450613', '450633', '450634', '450661', '450667', '450673',
        '450737', '450769', '450791', '450810', '450810', '450810', '450810', '450810', '451003', '451003', '451003',
        '451045', '451045', '451129', '451129', '451163', '451202', '451304', '451304', '451499', '451500', '451501',
        '451502', '451503', '451504', '451588', '451589', '451589', '451589', '451621', '451621', '451732', '451732',
        '451747', '451752', '451799', '451819', '451835', '451835', '451835', '451835', '451839', '451847', '451876',
        '451904', '451910', '451921', '451943', '451944', '451944', '451944', '452025', '452026', '452030', '452034',
        '452034', '452034', '452034', '452034', '452054', '452072', '452127', '452139', '452251', '452259', '452291',
        '452311', '452311', '452311', '452311', '452311', '452338', '452339', '452346', '452346', '452358', '452379',
        '452383', '452383', '452392', '452440', '452440', '452482', '452484', '452585', '452585', '452614', '452622',
        '452625', '452626', '452630', '452632', '452636', '452637', '452638', '452640', '452652', '452652', '452652',
        '452655', '452658', '452658', '452659', '452659', '452659', '452661', '452661', '452736', '452739', '452740',
        '452740', '452743', '452743', '452758', '452759', '452759', '452761', '452762', '452765', '452765', '452765',
        '452928', '452928', '452941', '452979', '452979', '453054', '453067', '453067', '453099', '453100', '453100',
        '453100', '453144', '453381', '453448', '453448', '453448', '453550', '453671', '453734', '453744', '453835',
        '453839', '453839', '453839', '453843', '453843', '453843', '453844', '453844', '454030', '454050', '454143',
        '454222', '454222', '454227', '454296', '454296', '454319', '454319', '454321', '454322', '454323', '454391',
        '454391', '454392', '454392', '454394', '454396', '454397', '454473', '464234', '464235', '464236', '464237',
        '464252', '464306', '464306', '464306', '464306', '464306', '464440', '464441', '464442', '464443', '464503',
        '464695', '464747', '464747', '464990', '464996', '465070', '465098', '465099', '465177', '465177', '465417',
        '465444', '465454', '465454', '465462', '465462', '465462', '465462', '465462', '465713', '465912', '466017',
        '466031', '466055', '466069', '466113', '466113', '466189', '466232', '466262', '466275', '466419', '466419',
        '466525', '466673', '466716', '466716', '466716', '466718', '466718', '466718', '466719', '466719', '466823',
        '466861', '467149', '467149', '467292', '467321', '467327', '467327', '467328', '467392', '467422', '467423',
        '467432', '467470', '467511', '467511', '467563', '467564', '467599', '467610', '467611', '467646', '467648',
        '467649', '467678', '467679', '467680', '467682', '467682', '467684', '467684', '467693', '467694', '467695',
        '467700', '467701', '467706', '467707', '467708', '467714', '467714', '467715', '467715', '467716', '467716',
        '467727', '467727', '467847', '467861', '467862', '467885', '467925', '467943', '467951', '467951', '467980',
        '467980', '467990', '467991', '467992', '467992', '467996', '467996', '468080', '468084', '468084', '468084',
        '468084', '468087', '468121', '468162', '468186', '468186', '468186', '468186', '468316', '468320', '468334',
        '468335', '468340', '468341', '468350', '468430', '468430', '468436', '468436', '469462', '469546', '469546',
        '469546', '469546', '469551', '469608', '469713', '469715', '469715', '469723', '469723', '469723', '469725',
        '469779', '469780', '469781', '470614', '470615', '470634', '470634', '470634', '470634', '470634', '470635',
        '470635', '470636', '470636', '470636', '470638', '470641', '470645', '470646', '470646', '470646', '470647',
        '470648', '470672', '470684', '470685', '470704', '470844', '470957', '470958', '470970', '470971', '470975',
        '470975', '470996', '471006', '471008', '471114', '471115', '471118', '471119', '471154', '471177', '471184',
        '471209', '471211', '471217', '471218', '471349', '471363', '471395', '471402', '471402', '471451', '471453',
        '471481', '471481', '471482', '471551', '471552', '471562', '471564', '471565', '471566', '471574', '471611',
        '471611', '471686', '471686', '471706', '471706', '471706', '471761', '471795', '471795', '471903', '471904',
        '471905', '471934', '472004', '472009', '472009', '472009', '472009', '472020', '472020', '472020', '472020',
        '472047', '472081', '472081', '472099', '472390', '472390', '472412', '472412', '472412', '472500', '472501',
        '472503', '472556', '472556', '472556', '472556', '472556', '472556', '472618', '472642', '472642', '472647',
        '472647', '472655', '472685', '472824', '472825', '472981', '473136', '473136', '473136', '473136', '473136',
        '473200', '473203', '473204', '473207', '473220', '473338', '473338', '473338', '473339', '473339', '473339',
        '473358', '473358', '473359', '473385', '473395', '473407', '473407', '473440', '473440', '473448', '473456',
        '473456', '473489', '473580', '473594', '473600', '473723', '473756', '473756', '473767', '473775', '473802',
        '473825', '473830', '473833', '473840', '473851', '473851', '473851', '473851', '473899', '473900', '473900',
        '473900', '473900', '473900', '473903', '473906', '473906', '473906', '473934', '473973', '473986', '473986',
        '474067', '474073', '474078', '474115', '474116', '474117', '474151', '474191', '474200', '474204', '474216',
        '474216', '474216', '474236', '474236', '474236', '474237', '474237', '474239', '474248', '474249', '474392',
        '474393', '474490', '474502', '474529', '474540', '474568', '474568', '474573', '474616', '474625', '474647',
        '474649', '474650', '474831', '474831', '474831', '474840', '474840', '474840', '474886', '474889', '474894',
        '474911', '474971', '475002', '475002', '475002', '475110', '475111', '475111', '475111', '475112', '475112',
        '475112', '475113', '475121', '475122', '475122', '475122', '475123', '475124', '475124', '475124', '475154',
        '475186', '475219', '475219', '475229', '475252', '475252', '475290', '475290', '475291', '475291', '475420',
        '475420', '475420', '475421', '475421', '475513', '475519', '475521', '475523', '475535', '475535', '475543',
        '475543', '475565', '475565', '475566', '475566', '475566', '475576', '475576', '475579', '475579', '475579',
        '475623', '475623', '475623', '475628', '475628', '475629', '475629', '475630', '475630', '475646', '475659',
        '475662', '475662', '475662', '475667', '475716', '475773', '475775', '475776', '475802', '475802', '475802',
        '475869', '475870', '475892', '475892', '475892', '475903', '475903', '475903', '475952', '475953', '475955',
        '475996', '475996', '476012', '476012', '476089', '476098', '476099', '476191', '476212', '476212', '476212',
        '476213', '476219', '476219', '476234', '476241', '476246', '476260', '476266', '476272', '476272', '476272',
        '476274', '476274', '476274', '476412', '476419', '476420', '476424', '476424', '476425', '476425', '476428',
        '476428', '476429', '476430', '476432', '476435', '476435', '476452', '476452', '476458', '476458', '476459',
        '476459', '476466', '476466', '476466', '476466', '476484', '476486', '476488', '476488', '476491', '476556',
        '476558', '476559', '476560', '476575', '476576', '476577', '476583', '476584', '476598', '476701', '476701',
        '476702', '476702', '476708', '476830', '501640', '508181', '512418', '516397', '516716', '516716', '545020',
        '545023', '545023', '545024', '545036', '545036', '545036', '545039', '545039', '545039', '545131', '545185',
        '545186', '545186', '545187', '545189', '545190', '545191', '545191', '545221', '545302', '545378', '545378',
        '545393', '545397', '545416', '545429', '545473', '545474', '545476', '545477', '545482', '545483', '545484',
        '545485', '545494', '545498', '545506', '545513', '545526', '545526', '545550', '545564', '545564', '545568',
        '545571', '545588', '545605', '545692', '545712', '545712', '545766', '545785', '545796', '545796', '545796',
        '545855', '545997', '546031', '546067', '546067', '546067', '546071', '546071', '546071', '546071', '546071',
        '546079', '546084', '546102', '546108', '546128', '546128', '546128', '546167', '546176', '546183', '546184',
        '546185', '546279', '546279', '546288', '546288', '546414', '546414', '546414', '546433', '546433', '546482',
        '546502', '546502', '546544', '546544', '546612', '546678', '546768', '546834', '546897', '546930', '546930',
        '546930', '546930', '546930', '546966', '547162', '547278', '547278', '547310', '547316', '547356', '547369',
        '547498', '547498', '547721', '547743', '547781', '547819', '547819', '547827', '547827', '547876', '547876',
        '547952', '547952', '547952', '547952', '547952', '547965', '547965', '547967', '547975', '547975', '548113',
        '548117', '548118', '548153', '548153', '548156', '548156', '548207', '548209', '548545', '548545', '548546',
        '548546', '548569', '548574', '548574', '548576', '548576', '548577', '548769', '548909', '548910', '548911',
        '548912', '548912', '548913', '548913', '548914', '548920', '548921', '548923', '548924', '548932', '548933',
        '548935', '548936', '548939', '548940', '548941', '548942', '548943', '548970', '548970', '549037', '549037',
        '549074', '549078', '549097', '549098', '549152', '549218', '549218', '549228', '549351', '549381', '549414',
        '549414', '549555', '549725', '549749', '549787', '550266', '550320', '550415', '550416', '550421', '550439',
        '550440', '550440', '550498', '550498', '550554', '550554', '550566', '550590', '550607', '550638', '550640',
        '550640', '550640', '550640', '550643', '550662', '550662', '550671', '550671', '550714', '550730', '550730',
        '550730', '550858', '550878', '550880', '550889', '550894', '550894', '550936', '550962', '550962', '550966',
        '550966', '550969', '550985', '551009', '551009', '551039', '551040', '551050', '551064', '551065', '551077',
        '551079', '551080', '551105', '551113', '551113', '551113', '551113', '551113', '551128', '551128', '551138',
        '551162', '551162', '551162', '551163', '551163', '551163', '551164', '551167', '551167', '551167', '551167',
        '551167', '551180', '551215', '551216', '551260', '551261', '551262', '551263', '551269', '551270', '551272',
        '551277', '551278', '551375', '551376', '551383', '551391', '551426', '551433', '551435', '551436', '551437',
        '551438', '551439', '551449', '551458', '551499', '551504', '551506', '551517', '551519', '551627', '551705',
        '551705', '551787', '551982', '551995', '551996', '552013', '552053', '552085', '552104', '552123', '552198',
        '552224', '552226', '552226', '552236', '552245', '552268', '552268', '552280', '552281', '552281', '552281',
        '552283', '552326', '552326', '552333', '552337', '552343', '552360', '552364', '552371', '552373', '552373',
        '552399', '552399', '552399', '552400', '552401', '552402', '552402', '552407', '552408', '552434', '552436',
        '552436', '552436', '552472', '552477', '552480', '552485', '552507', '552533', '552538', '552589', '552589',
        '552589', '552630', '552630', '552630', '552630', '552632', '552637', '552662', '552662', '552677', '552721',
        '552721', '552721', '552721', '552721', '552728', '552728', '552728', '552728', '552728', '552729', '552729',
        '552753', '552753', '552788', '552840', '552840', '552841', '552894', '552894', '552894', '552894', '552898',
        '552898', '552898', '552898', '552899', '552914', '552919', '552933', '552944', '552961', '552961', '552981',
        '552981', '552986', '553000', '553088', '553088', '553266', '553266', '553269', '553290', '553344', '553391',
        '553396', '553401', '553401', '553401', '553401', '553401', '553404', '553456', '553541', '553556', '553556',
        '553579', '553579', '553624', '553624', '553624', '553624', '553624', '553765', '553765', '553766', '553790',
        '553793', '553818', '553819', '553862', '553868', '553872', '553968', '553974', '554001', '554001', '554001',
        '554045', '554048', '554048', '554117', '554138', '554174', '554203', '554204', '554224', '554296', '554304',
        '554444', '554459', '554508', '554523', '554548', '554588', '554588', '554660', '554664', '554709', '554710',
        '554746', '554753', '554837', '554837', '554869', '554869', '554902', '554902', '554903', '554903', '554956',
        '554959', '554959', '554976', '554981', '554988', '554991', '554991', '555019', '555027', '555027', '555058',
        '555075', '555075', '555078', '555078', '555087', '555087', '555095', '555095', '555108', '555108', '555177',
        '555286', '555286', '555286', '555300', '555348', '555365', '555367', '555371', '555372', '555381', '555382',
        '555385', '555386', '555388', '555389', '555391', '555403', '555405', '555405', '555407', '555421', '555421',
        '555425', '555427', '555431', '555444', '555487', '555492', '555589', '555590', '555595', '555601', '555611',
        '555611', '555621', '555654', '555654', '555732', '555743', '555782', '555802', '555819', '555971', '555975',
        '555989', '555997', '556001', '556043', '556043', '556043', '556050', '556051', '556059', '556060', '556069',
        '556069', '556069', '556069', '556069', '556109', '556115', '556135', '556135', '556135', '556145', '556149',
        '556165', '556181', '556185', '556205', '556210', '556238', '556242', '556243', '556263', '556274', '556274',
        '556274', '556275', '556293', '556321', '556322', '556323', '556336', '556336', '556336', '556376', '556378',
        '556379', '556380', '556399', '556399', '556399', '556403', '556404', '556405', '556427', '556427', '556427',
        '556459', '556501', '556501', '556501', '556506', '556506', '556506', '556512', '556595', '556604', '556604',
        '556608', '556611', '556615', '556619', '556619', '556623', '556652', '556718', '556718', '556721', '556721',
        '556729', '556735', '556739', '556739', '556739', '556742', '556775', '556775', '556788', '556790', '556790',
        '556799', '556808', '556838', '556839', '556840', '556914', '556914', '556915', '556915', '556955', '556969',
        '556975', '557100', '557109', '557116', '557126', '557138', '557144', '557151', '557153', '557177', '557178',
        '557180', '557180', '557182', '557182', '557224', '557228', '557231', '557248', '557254', '557269', '557270',
        '557281', '557286', '557287', '557287', '557287', '557288', '557308', '557315', '557319', '557331', '557331',
        '557331', '557331', '557331', '557331', '557331', '557339', '557339', '557353', '557355', '557355', '557360',
        '557360', '557363', '557363', '557363', '557387', '557397', '557403', '557405', '557408', '557408', '557412',
        '557412', '557428', '557428', '557429', '557429', '557432', '557432', '557435', '557442', '557442', '557463',
        '557464', '557465', '557471', '557474', '557474', '557481', '557481', '557481', '557493', '557493', '557508',
        '557509', '557527', '557528', '557529', '557589', '557601', '557630', '557658', '557666', '557666', '557679',
        '557705', '557713', '557714', '557714', '557720', '557720', '557722', '557726', '557726', '557748', '557748',
        '557757', '557779', '557779', '557781', '557785', '557788', '557790', '557791', '557808', '557828', '557835',
        '557845', '557846', '557878', '557881', '557881', '557885', '557892', '557907', '557908', '557920', '557937',
        '557941', '557964', '557964', '557979', '557990', '557998', '558024', '558036', '558036', '558036', '558071',
        '558071', '558071', '558083', '558090', '558090', '558101', '558107', '558107', '558116', '558117', '558121',
        '558122', '558124', '558126', '558126', '558128', '558129', '558174', '558174', '558194', '558194', '558208',
        '558208', '558213', '558297', '558297', '558319', '558319', '558330', '558331', '558331', '558333', '558376',
        '558411', '558411', '558436', '558446', '558457', '558458', '558479', '558496', '558510', '558534', '558540',
        '558540', '558541', '558596', '558598', '558599', '558609', '558635', '558652', '558652', '558690', '558711',
        '558711', '558720', '558730', '558740', '558758', '558783', '558820', '558845', '558859', '558859', '558864',
        '558871', '558912', '558912', '558938', '558943', '559000', '559011', '559016', '559021', '559055', '559056',
        '559061', '559078', '559078', '559087', '559093', '559093', '559118', '559118', '559138', '559140', '559148',
        '559165', '559226', '559265', '559265', '559291', '559291', '559291', '559291', '559291', '559299', '559299',
        '559299', '559313', '559374', '559376', '559377', '559388', '559390', '559396', '559397', '559397', '559400',
        '559406', '559406', '559421', '559424', '559424', '559480', '559493', '559495', '559508', '559563', '559572',
        '559572', '559573', '559573', '559574', '559575', '559576', '559577', '559577', '559578', '559579', '559580',
        '559580', '559615', '559615', '559621', '559621', '559622', '559622', '559633', '559633', '559634', '559634',
        '559660', '559661', '559662', '559694', '559694', '559695', '559696', '559708', '559712', '559733', '559805',
        '559853', '559858', '559859', '559881', '559888', '559888', '559888', '559890', '559900', '559903', '559912',
        '559922', '559931', '559932', '559942', '559944', '559945', '559945', '559956', '559956', '559964', '559977',
        '560000', '560000', '560000', '560003', '560006', '560016', '560016', '560016', '560017', '560017', '560017',
        '560031', '560077', '560084', '560146', '560159', '560213', '560213', '560235', '560242', '560266', '560276',
        '560276', '560276', '560279', '560289', '560316', '560317', '560326', '560327', '560338', '560341', '560354',
        '560363', '560369', '560414', '560426', '560447', '560482', '560483', '560483', '560484', '560484', '560484',
        '560484', '560487', '560487', '560488', '560493', '560493', '560493', '560493', '560494', '560500', '560501',
        '560505', '560505', '560505', '560509', '560510', '560562', '560562', '560629', '560630', '560630', '560634',
        '560634', '560641', '560641', '560641', '560651', '560651', '560668', '560670', '560670', '560682', '560688',
        '560690', '560690', '560709', '560734', '560734', '560749', '560771', '560777', '560777', '560779', '560781',
        '560809', '560823', '560830', '560837', '560839', '560840', '560847', '560881', '560881', '560883', '560889',
        '560889', '560901', '560921', '560933', '560933', '560933', '560933', '560935', '560936', '560939', '560945',
        '560948', '560975', '560975', '560975', '561023', '561024', '561024', '561089', '561099', '561180', '561185',
        '561194', '561205', '561215', '561217', '561217', '561286', '561288', '561355', '561377', '561385', '561391',
        '561409', '561453', '561461', '561529', '561560', '561612', '561613', '561634', '561649', '561654', '561690',
        '561696', '561699', '561700', '561726', '561727', '561731', '561732', '561733', '561737', '561767', '561784',
        '561804', '561805', '561885', '561886', '561887', '561888', '561897', '561898', '561914', '561948', '561999',
        '562002', '562003', '562004', '562006', '562022', '562024', '562025', '562034', '562044', '562060', '562064',
        '562064', '562069', '562083', '562090', '562102', '562103', '562111', '562119', '562130', '562135', '562135',
        '562136', '562140', '562149', '562154', '562156', '562157', '562161', '562166', '562184', '562184', '562184',
        '562184', '562184', '562184', '562193', '562193', '562193', '562193', '562203', '562228', '562228', '562228',
        '562240', '562251', '562328', '562336', '562395', '562395', '562395', '562449', '562451', '562452', '562459',
        '562468', '562470', '562472', '562474', '562475', '562480', '562491', '562502', '562504', '562509', '562540',
        '562540', '562540', '562540', '562544', '562544', '562544', '562544', '562596', '562604', '562615', '562616',
        '562617', '562618', '562641', '562651', '562652', '562653', '562654', '562672', '562677', '562768', '562803',
        '562804', '562806', '562807', '562807', '562807', '562830', '562836', '562837', '562842', '562846', '562857',
        '562905', '562909', '562911', '562957', '562960', '562962', '562982', '563030', '563096', '563096', '563123',
        '563126', '563127', '563127', '563129', '563132', '563132', '563136', '563142', '563143', '563159', '563204',
        '563205', '563207', '563221', '563221', '563236', '563248', '563259', '563319', '563345', '563355', '563355',
        '563400', '563402', '563417', '563422', '563432', '563432', '563432', '563439', '563450', '563455', '563465',
        '563466', '563510', '563511', '563512', '563515', '563525', '563536', '563550', '563560', '563560', '563560',
        '563578', '563603', '563607', '563607', '563608', '563609', '563609', '563622', '563623', '563623', '563625',
        '563626', '563632', '563640', '563651', '563653', '563654', '563689', '563699', '563699', '563704', '563712',
        '563723', '563724', '563726', '563742', '563743', '563751', '563759', '563759', '563822', '564078', '564177',
        '564209', '564307', '564308', '564308', '564318', '564318', '564325', '564340', '564343', '564343', '564350',
        '564351', '564352', '564353', '564374', '564375', '564375', '564395', '564395', '564395', '564397', '564400',
        '564400', '564400', '564417', '564469', '564469', '564594', '564677', '564681', '564721', '564733', '564816',
        '564816', '564848', '564853', '564853', '564905', '564991', '565133', '565134', '565135', '565163', '565178',
        '565256', '565285', '565295', '565295', '565317', '565317', '565322', '565332', '565381', '565383', '565424',
        '565464', '565528', '565528', '565528', '565566', '565573', '565662', '565664', '565699', '565706', '565707',
        '565707', '565707', '565737', '565737', '565737', '565742', '565747', '565817', '566003', '566038', '566100',
        '566193', '566193', '566193', '566331', '566374', '566374', '566377', '566529', '566555', '566556', '566562',
        '566563', '566686', '566732', '566895', '566905', '566905', '566915', '566923', '566950', '567337', '567376',
        '567383', '567389', '567390', '567393', '567393', '567400', '567402', '567426', '567426', '567458', '567458',
        '567473', '567473', '567509', '567560', '568416', '568482', '568491', '568491', '568491', '568541', '568583',
        '568583', '568583', '568585', '569006', '569080', '569080', '569113', '569115', '569127', '569128', '569195',
        '569195', '569217', '569233', '569407', '569407', '569407', '569409', '569409', '569411', '569423', '569423',
        '569424', '569828', '569862', '569862', '569870', '569879', '569908', '569909', '569910', '569954', '570000',
        '570020', '570205', '570206', '570219', '570270', '570270', '570270', '570320', '570321', '570361', '570361',
        '570361', '570370', '570398', '570398', '570398', '570398', '570398', '570398', '570398', '570398', '570398',
        '570441', '570458', '570540', '570588', '570605', '570606', '570664', '570664', '570665', '570665', '570679',
        '570687', '570689', '570690', '570762', '570764', '570765', '570811', '570811', '570811', '570811', '570845',
        '570847', '570847', '570847', '570848', '570854', '570902', '570903', '570904', '570912', '570913', '570926',
        '570927', '570960', '571031', '571048', '571153', '571158', '571207', '571208', '571244', '571244', '571244',
        '571244', '571345', '571346', '571356', '571412', '571418', '571479', '571480', '571480', '571597', '571653',
        '571658', '571691', '571722', '571726', '571790', '571795', '571851', '571851', '571864', '571864', '571877',
        '571877', '571877', '571877', '571882', '571888', '571888', '571911', '571912', '571916', '571926', '571934',
        '571939', '571945', '571969', '571977', '572016', '572076', '572076', '572079', '572186', '572197', '572208',
        '572213', '572213', '572213', '572214', '572225', '572244', '572247', '572253', '572255', '572255', '572255',
        '572259', '572286', '572286', '572297', '572315', '572316', '572316', '572320', '572321', '572344', '572371',
        '572375', '572394', '572394', '572394', '572395', '572400', '572437', '572439', '572442', '572542', '572594',
        '572615', '572643', '572643', '572644', '572644', '572667', '572667', '572668', '572668', '572669', '572669',
        '572680', '572680', '572692', '572701', '572722', '572763', '572771', '572798', '572801', '572801', '572801',
        '572871', '572872', '572873', '572876', '572876', '572878', '572878', '572891', '572902', '572902', '572904',
        '572904', '572905', '572906', '572953', '572953', '573015', '573016', '573096', '573097', '573220', '573221',
        '573222', '573227', '573229', '573230', '573231', '573234', '573263', '573286', '573289', '573293', '573297',
        '573298', '573321', '573321', '573321', '573349', '573395', '573396', '573401', '573402', '573404', '573405',
        '573405', '573406', '573406', '573461', '573463', '573554', '573555', '573558', '573559', '573560', '573579',
        '573583', '573628', '573629', '573729', '573757', '573759', '573770', '573771', '573831', '573868', '573869',
        '573884', '573884', '573885', '573914', '573914', '573932', '573973', '573973', '573988', '573988', '573988',
        '573988', '574046', '574049', '574049', '574051', '574051', '574053', '574056', '574056', '574061', '574063',
        '574081', '574217', '574226', '574226', '574265', '574398', '574407', '574411', '574441', '574642', '574643',
        '574654', '574678', '574706', '574737', '574840', '574988', '574988', '575034', '575034', '575034', '575041',
        '575041', '575041', '575043', '575138', '575140', '575150', '575168', '575186', '575210', '575246', '575246',
        '575262', '575421', '575433', '575453', '575453', '575458', '575458', '575460', '575469', '575477', '575477',
        '575479', '575480', '575480', '575481', '575481', '575482', '575483', '575483', '575487', '575493', '575494',
        '575524', '575525', '575578', '575586', '575592', '575596', '575639', '575687', '575728', '575730', '575749',
        '575783', '575797', '575862', '575878', '575900', '575910', '575925', '575973', '575983', '576003', '576003',
        '576020', '576022', '576023', '576024', '576025', '576027', '576027', '576028', '576047', '576047', '576052',
        '576052', '576052', '576078', '576078', '576085', '576085', '576133', '576135', '576137', '576137', '576137',
        '576171', '576190', '576196', '576196', '576222', '576223', '576224', '576235', '576236', '576238', '576239',
        '576240', '576250', '576252', '576252', '576271', '576271', '576272', '576272', '576304', '576304', '576305',
        '576305', '576334', '576455', '576455', '576532', '576532', '576631', '576661', '576662', '576674', '576682',
        '576685', '576704', '576726', '576731', '576734', '576741', '576742', '576784', '576791', '576808', '576817',
        '576825', '576879', '576936', '576948', '576952', '576954', '576959', '576978', '576978', '576991', '576992',
        '576995', '577013', '577013', '577015', '577034', '577045', '577045', '577092', '577126', '577129', '577209',
        '577209', '577209', '577233', '577270', '577276', '577278', '577283', '577283', '577287', '577340', '577340',
        '577341', '577383', '577418', '577419', '577468', '577469', '577500', '577519', '577571', '577571', '577571',
        '577597', '577597', '577597', '577648', '577648', '577648', '577658', '577688', '577688', '577697', '577706',
        '577714', '577715', '577831', '577832', '577843', '577850', '577860', '577860', '577861', '577861', '577862',
        '577863', '577866', '577866', '577867', '577888', '577893', '577929', '577929', '577929', '577929', '577929',
        '577930', '577930', '577942', '577943', '577945', '577948', '577949', '577954', '577959', '577965', '577966',
        '577967', '577974', '577974', '577974', '577977', '577978', '577979', '577980', '577981', '577987', '577988',
        '577995', '577995', '577995', '578014', '578015', '578016', '578026', '578027', '578045', '578047', '578090',
        '578213', '578269', '578301', '578301', '578327', '578342', '578370', '578380', '578594', '578596', '578606',
        '578617', '578631', '578633', '578664', '578675', '578675', '578684', '578709', '578710', '578711', '578712',
        '578713', '578732', '578741', '578822', '578822', '578859', '578947', '578948', '578958', '578959', '578970',
        '579023', '579026', '579034', '579034', '579050', '579051', '579052', '579076', '579085', '579193', '579198',
        '579207', '579209', '579209', '579217', '579217', '579273', '579346', '579375', '579376', '579382', '579384',
        '579391', '579392', '579396', '579396', '579402', '579416', '579416', '579418', '579418', '579419', '579420',
        '579445', '579457', '579458', '579461', '579488', '579505', '579515', '579515', '579572', '579585', '579600',
        '579615', '579638', '579638', '579643', '579649', '579669', '579670', '579687', '579702', '579703', '579704',
        '579719', '579738', '579739', '579749', '579754', '579755', '579756', '579766', '579781', '579785', '579797',
        '579806', '579806', '579806', '579806', '579860', '579860', '579860', '579860', '579860', '579860', '579860',
        '579860', '579908', '579931', '579932', '579968', '579968', '579975', '579983', '580021', '580021', '580021',
        '580101', '580101', '580102', '580108', '580194', '580195', '580202', '580207', '580236', '580236', '580236',
        '580255', '580255', '580255', '580315', '580316', '580316', '580323', '580345', '580348', '580349', '580349',
        '580353', '580379', '580383', '580383', '580385', '580392', '580392', '580397', '580402', '580403', '580411',
        '580411', '580412', '580412', '580424', '580436', '580437', '580437', '580441', '580441', '580442', '580443',
        '580443', '580443', '580443', '580443', '580443', '580456', '580471', '580530', '580535', '580582', '580585',
        '580586', '580623', '580623', '580623', '580623', '580623', '580623', '580692', '580698', '580705', '580733',
        '580740', '580752', '580753', '580754', '580754', '580769', '580785', '580787', '580792', '580793', '580794',
        '580849', '580850', '580887', '580941', '580941', '580955', '580955', '580973', '580973', '580973', '580983',
        '580983', '580999', '581012', '581017', '581046', '581075', '581081', '581095', '581096', '581097', '581098',
        '581099', '581100', '581102', '581103', '581105', '581106', '581136', '581138', '581139', '581146', '581155',
        '581156', '581157', '581158', '581161', '581166', '581167', '581168', '581169', '581170', '581173', '581183',
        '581184', '581185', '581189', '581190', '581193', '581196', '581197', '581200', '581201', '581203', '581205',
        '581215', '581215', '581215', '581285', '581294', '581301', '581302', '581303', '581312', '581316', '581330',
        '581332', '581337', '581344', '581345', '581346', '581347', '581349', '581349', '581380', '581380', '581380',
        '581383', '581393', '581393', '581425', '581426', '581427', '581428', '581429', '581442', '581442', '581457',
        '581458', '581470', '581471', '581493', '581494', '581495', '581496', '581497', '581545', '581546', '581577',
        '581577', '581589', '581601', '581606', '581613', '581613', '581614', '581615', '581654', '581661', '581666',
        '581678', '581682', '581683', '581684', '581684', '581688', '581692', '581693', '581727', '581743', '581743',
        '581761', '581761', '581826', '581832', '581838', '581839', '581840', '581848', '581858', '581859', '581860',
        '581869', '581870', '581903', '581904', '581904', '581905', '581907', '581908', '581910', '581911', '581912',
        '581913', '581914', '581915', '581924', '581927', '581932', '581945', '581971', '581972', '581973', '581976',
        '581984', '581987', '581993', '581996', '581998', '582001', '582001', '582002', '582006', '582016', '582019',
        '582026', '582026', '582052', '582052', '582052', '582052', '582053', '582061', '582061', '582061', '582061',
        '582062', '582064', '582065', '582066', '582075', '582091', '582099', '582121', '582121', '582146', '582147',
        '582148', '582149', '582151', '582151', '582152', '582153', '582157', '582208', '582209', '582213', '582214',
        '582216', '582217', '582272', '582274', '582279', '582285', '582286', '582302', '582347', '582352', '582353',
        '582354', '582376', '582376', '582376', '582390', '582390', '582394', '582394', '582402', '582402', '582410',
        '582415', '582417', '582418', '582418', '582431', '582441', '582442', '582443', '582444', '582465', '582468',
        '582468', '582475', '582492', '582516', '582517', '582521', '582611', '582701', '582703', '582707', '582719',
        '582778', '582779', '582779', '582803', '582820', '582837', '582849', '582854', '582854', '582856', '582856',
        '582859', '582866', '582866', '582867', '582868', '582883', '582884', '582885', '582889', '582890', '582896',
        '582903', '582904', '582931', '582932', '582933', '582934', '582943', '582944', '582961', '582962', '582963',
        '582969', '582970', '582987', '582988', '582989', '582990', '582993', '582995', '582997', '583002', '583012',
        '583013', '583019', '583024', '583029', '583053', '583069', '583137', '583137', '583137', '583156', '583191',
        '583193', '583210', '583211', '583222', '583236', '583262', '583262', '583262', '583262', '583277', '583347',
        '583352', '583353', '583356', '583386', '583389', '583391', '583399', '583401', '583428', '583428', '583428',
        '583432', '583440', '583440', '583440', '583440', '583444', '583455', '583455', '583458', '583458', '583467',
        '583474', '583487', '583496', '583529', '583531', '583536', '583538', '583541', '583554', '583555', '583557',
        '583558', '583559', '583561', '583601', '583601', '583601', '583606', '583608', '583609', '583610', '583611',
        '583615', '583625', '583641', '583646', '583647', '583649', '583653', '583658', '583662', '583707', '583738',
        '583755', '583789', '583806', '583807', '583808', '583809', '583841', '583956', '583959', '583960', '583964',
        '583966', '583984', '583989', '584023', '584024', '584120', '584121', '584122', '584123', '584126', '584127',
        '584130', '584148', '584149', '584161', '584162', '584163', '584164', '584165', '584174', '584197', '584198',
        '584199', '584221', '584230', '584234', '584235', '584236', '584237', '584241', '584242', '584243', '584411',
        '584411', '584463', '584508', '584508', '584584', '584584', '584584', '584618', '584619', '584687', '584687',
        '584757', '584777', '584790', '584923', '584923', '584992', '585167', '585180', '585181', '585201', '585218',
        '585220', '585221', '585222', '585290', '585290', '585339', '585339', '585374', '585382', '585382', '585383',
        '585386', '585386', '585387', '585404', '585407', '585409', '585470', '585541', '585543', '585561', '585562',
        '585563', '585598', '585645', '585653', '585654', '585655', '585660', '585661', '585662', '585664', '585669',
        '585670', '585671', '585789', '585790', '585835', '585873', '585902', '586014', '586027', '586040', '586057',
        '586057', '586097', '586097', '586169', '586185', '586189', '586205', '586209', '586211', '586236', '586236',
        '586236', '586239', '586245', '586246', '586253', '586270', '586275', '586291', '586292', '586322', '586324',
        '586374', '586389', '586390', '586421', '586434', '586467', '586471', '586491', '586492', '586493', '586495',
        '586495', '586510', '586510', '586567', '586595', '586603', '586645', '586647', '586681', '586692', '586695',
        '586698', '586718', '586718', '586723', '586723', '586736', '586753', '586761', '586816', '586829', '586834',
        '586835', '586836', '586837', '586858', '586863', '586865', '586868', '586875', '586878', '586885', '586886',
        '586887', '586888', '586889', '586897', '586910', '586919', '586939', '586942', '586943', '586950', '586950',
        '586954', '586968', '586970', '586976', '587023', '587054', '587083', '587085', '587134', '587141', '587141',
        '587149', '587197', '587213', '587222', '587261', '587261', '587271', '587388', '587430', '587468', '587488',
        '587490', '587502', '587531', '587543', '587550', '587560', '587584', '587589', '587660', '587660', '587664',
        '587664', '587665', '587706', '587717', '587721', '587724', '587747', '587830', '587858', '587872', '587881',
        '587897', '587905', '587931', '587933', '587936', '587944', '587944', '587951', '587951', '587958', '587960',
        '588003', '588047', '588057', '588058', '588059', '588080', '588093', '588094', '588156', '588169', '588197',
        '588197', '588260', '588272', '588281', '588316', '588316', '588330', '588330', '588356', '588360', '588383',
        '588385', '588386', '588396', '588410', '588411', '588423', '588454', '588459', '588465', '588466', '588468',
        '588487', '588610', '588653', '588664', '588664', '588664', '588665', '588665', '588666', '588667', '588677',
        '588679', '588700', '588723', '588731', '588731', '588744', '588746', '588746', '588746', '588749', '588749',
        '588750', '588789', '588793', '588793', '588821', '588834', '588835', '588837', '588840', '588858', '588859',
        '588891', '589096', '589109', '589119', '589149', '589150', '589151', '589167', '589214', '589217', '589288',
        '589319', '589324', '589361', '589371', '589377', '589386', '589422', '589612', '589651', '589658', '589676',
        '589678', '589679', '589688', '589688', '589738', '589738', '589756', '589757', '589790', '589835', '589903',
        '589923', '589924', '589933', '589934', '589936', '589937', '589938', '589939', '589952', '589953', '589964',
        '589987', '590046', '590052', '590079', '590095', '590111', '590246', '590257', '590258', '590259', '590260',
        '590365', '590422', '590436', '590498', '590513', '590516', '590520', '590521', '590522', '590523', '590524',
        '590525', '590525', '590525', '590525', '590534', '590538', '590561', '590566', '590567', '590582', '590584',
        '590585', '590621', '590632', '590632', '590669', '590686', '590687', '590689', '590690', '590726', '590744',
        '590755', '590761', '590767', '590781', '590783', '590784', '590785', '590814', '590814', '590816', '590845',
        '590845', '590856', '590856', '590857', '590857', '590857', '590858', '590858', '590858', '590859', '590859',
        '590860', '590860', '590861', '590862', '590862', '590862', '590863', '590869', '590869', '590870', '590871',
        '590871', '590872', '590873', '590883', '590886', '590886', '590896', '590902', '590922', '590922', '590925',
        '590925', '590929', '590936', '590951', '590970', '590972', '590974', '590975', '590976', '590986', '590991',
        '591000', '591001', '591005', '591026', '591027', '591034', '591042', '591044', '591044', '591065', '591073',
        '591110', '591141', '591151', '591152', '591170', '591170', '591228', '591229', '591247', '591297', '591299',
        '591302', '591302', '591302', '591303', '591304', '591306', '591306', '591318', '591321', '591326', '591327',
        '591344', '591358', '591358', '591358', '591362', '591366', '591368', '591388', '591389', '591389', '591390',
        '591392', '591392', '591392', '591397', '591399', '591401', '591415', '591425', '591432', '591456', '591456',
        '591461', '591477', '591478', '591480', '591482', '591483', '591495', '591500', '591505', '591519', '591522',
        '591523', '591524', '591535', '591535', '591536', '591537', '591539', '591575', '591577', '591584', '591586',
        '591587', '591595', '591596', '591596', '591611', '591611', '591613', '591617', '591673', '591700', '591701',
        '591736', '591744', '591745', '591765', '591788', '591792', '591793', '591794', '591797', '591819', '591819',
        '591819', '591821', '591857', '591887', '591892', '591892', '591914', '591951', '591952', '591953', '591962',
        '591964', '591980', '591980', '591998', '592010', '592014', '592034', '592045', '592046', '592046', '592047',
        '592074', '592074', '592075', '592093', '592122', '592225', '592276', '592277', '592321', '592335', '592354',
        '592358', '592363', '592387', '592387', '592452', '592452', '592468', '592480', '592482', '592507', '592511',
        '592512', '592521', '592529', '592541', '592543', '592548', '592549', '592553', '592557', '592558', '592559',
        '592572', '592575', '592577', '592578', '592585', '592608', '592613', '592662', '592716', '592775', '592804',
        '592825', '592845', '592850', '592866', '592891', '592891', '592906', '592923', '592991', '593021', '593029',
        '593081', '593087', '593127', '593137', '593162', '593169', '593190', '593196', '593204', '593232', '593250',
        '593280', '593295', '593301', '593336', '593343', '593344', '593400', '593449', '593468', '593519', '593520',
        '593580', '593580', '593580', '593582', '593582', '593582', '593605', '593605', '593605', '593606', '593606',
        '593606', '593614', '593625', '593640', '593663', '593663', '593688', '593739', '593778', '593778', '593782',
        '593782', '593875', '593878', '593897', '593902', '593923', '593930', '593944', '593946', '594007', '594008',
        '594009', '594017', '594017', '594105', '594125', '594148', '594148', '594154', '594160', '594160', '594178',
        '594188', '594200', '594207', '594207', '594223', '594225', '594236', '594237', '594240', '594257', '594257',
        '594273', '594361', '594362', '594363', '594375', '594384', '594390', '594458', '594469', '594469', '594492',
        '594504', '594532', '594533', '594543', '594556', '594557', '594563', '594661', '594670', '594672', '594696',
        '594798', '594803', '594813', '594839', '594855', '594864', '594885', '594898', '594925', '594945', '594955',
        '595011', '595017', '595022', '595023', '595026', '595042', '595042', '595095', '595102', '595118', '595129',
        '595137', '595143', '595164', '595176', '595223', '595228', '595228', '595248', '595275', '595275', '595289',
        '595293', '595353', '595364', '595386', '595453', '595473', '595476', '595584', '595612', '595648', '595649',
        '595650', '595661', '595677', '595679', '595715', '595716', '595717', '595718', '595719', '595720', '595793',
        '595793', '595875', '595876', '595879', '595906', '595909', '595924', '595933', '596002', '596017', '596049',
    }


class AcneTherapy(ValueSet):
    VALUE_SET_NAME = 'Acne Therapy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152312', '152312', '159715', '159871', '161476', '161476', '164024', '164024', '164549', '164549', '166345',
        '168743', '168743', '172900', '172900', '178065', '178065', '179075', '179498', '179498', '182392', '182392',
        '183561', '183561', '184603', '184603', '186405', '186405', '186405', '186405', '186564', '186564', '186564',
        '186564', '186564', '186564', '188616', '188863', '188863', '188863', '188863', '188863', '189526', '192213',
        '192213', '192399', '195664', '197090', '200605', '203610', '203610', '204270', '204799', '204799', '208113',
        '208783', '208783', '212159', '214948', '217284', '218228', '218475', '221221', '221221', '224271', '224271',
        '225626', '225626', '225626', '225626', '227047', '227067', '232495', '232495', '232495', '232495', '232758',
        '232758', '233222', '233222', '233222', '233222', '233222', '233222', '234826', '235803', '239005', '242722',
        '246232', '246232', '246232', '248407', '248407', '248407', '248407', '248775', '258889', '258889', '262332',
        '262332', '265372', '265372', '266147', '266147', '266700', '269896', '271031', '275937', '275937', '275937',
        '275937', '276527', '276527', '279783', '281719', '284636', '284636', '288318', '291076', '291076', '291076',
        '292443', '293627', '295587', '296373', '296554', '296554', '296554', '296554', '296571', '296571', '296915',
        '297361', '298153', '298153', '298499', '298499', '400012', '440878', '440930', '440930', '440932', '440932',
        '440942', '440942', '440942', '440942', '441737', '441737', '441739', '443498', '443637', '443687', '443687',
        '443694', '443694', '446398', '446746', '446747', '446748', '446825', '448599', '449691', '449691', '449692',
        '449692', '449693', '449693', '451732', '451732', '466055', '468316', '469713', '471402', '471402', '472642',
        '472642', '472647', '472647', '472655', '474392', '474616', '474625', '475773', '475775', '475776', '475952',
        '475953', '475955', '545221', '546102', '546108', '546184', '546185', '547827', '547827', '548156', '548156',
        '548209', '550266', '550894', '550894', '550936', '550962', '550962', '551105', '551138', '551164', '551499',
        '551504', '552224', '552226', '552226', '552480', '552485', '552637', '552677', '553790', '553793', '554444',
        '555421', '555421', '556050', '556051', '556059', '556060', '556501', '556501', '556501', '556506', '556506',
        '556506', '556788', '556799', '556838', '556840', '557100', '557319', '557463', '557464', '557465', '557471',
        '557508', '557509', '557528', '557529', '557589', '557791', '558596', '558740', '559055', '559056', '559291',
        '559291', '559291', '559291', '559291', '559299', '559299', '559299', '559890', '559900', '560426', '560482',
        '560483', '560483', '560509', '560510', '560629', '560830', '560847', '561612', '561613', '561885', '561886',
        '561887', '561897', '562064', '562064', '562451', '562452', '562468', '562470', '562502', '562509', '562807',
        '562807', '562807', '562846', '562962', '563422', '563455', '563466', '564078', '565134', '565163', '565566',
        '565664', '566529', '567389', '567390', '569113', '569115', '569127', '569128', '569407', '569407', '569407',
        '569409', '569409', '569411', '570679', '570687', '571207', '571208', '571658', '572297', '572542', '572667',
        '572667', '572668', '572668', '572669', '572669', '572680', '572680', '573628', '573629', '573884', '573884',
        '573885', '574061', '574840', '575460', '575910', '576020', '576022', '576023', '576024', '576025', '576726',
        '576731', '577688', '577688', '577706', '577714', '577715', '578859', '579207', '579375', '579376', '579392',
        '579515', '579515', '579703', '579704', '579738', '579739', '579754', '579766', '580315', '580349', '580349',
        '580353', '580411', '580411', '580412', '580412', '580437', '580437', '580441', '580441', '581167', '581168',
        '581169', '581170', '581184', '581185', '581189', '581190', '581330', '581337', '581393', '581393', '581682',
        '581688', '581903', '581914', '581924', '582152', '582353', '582354', '582390', '582390', '582410', '582441',
        '582442', '582443', '582444', '582719', '583210', '583211', '583641', '584023', '584024', '584130', '584164',
        '584221', '584230', '584463', '584508', '584508', '584777', '584992', '585407', '586027', '586291', '586292',
        '586389', '586390', '586692', '586698', '586718', '586718', '586723', '586723', '587141', '587141', '587468',
        '587490', '587531', '587589', '588360', '588423', '588465', '589119', '589688', '589688', '589738', '589738',
        '590521', '590522', '590523', '590524', '590525', '590525', '590525', '590525', '592906', '592923', '593930',
        '594223', '594855', '594864', '595793', '595793', '595876', '595906',
    }


class AcneTherapyTopicalAntiInfective(ValueSet):
    VALUE_SET_NAME = 'Acne Therapy Topical - Anti-infective'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159871', '195664', '200605', '208783', '208783', '225626', '225626', '225626', '225626', '232758', '232758',
        '234826', '235803', '248407', '248407', '248407', '248407', '248775', '262332', '262332', '266147', '266147',
        '269896', '279783', '288318', '296571', '296571', '296915', '298499', '298499', '400012', '440930', '440930',
        '440932', '440932', '440942', '440942', '440942', '440942', '468316', '472642', '472642', '472647', '472647',
        '550936', '556501', '556501', '556501', '556506', '556506', '556506', '563422', '566529', '578859', '589688',
        '589688', '589738', '589738', '595793', '595793',
    }


class AcneTherapyTopicalCombinations(ValueSet):
    VALUE_SET_NAME = 'Acne Therapy Topical Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '186564', '186564', '186564', '186564', '186564', '186564', '188616', '197090', '204799', '204799', '212159',
        '227047', '271031', '295587', '296373', '296554', '296554', '296554', '296554', '443498', '446398', '446825',
        '448599', '471402', '471402', '474392', '474616', '474625', '546102', '547827', '547827', '548156', '548156',
        '548209', '550266', '550894', '550894', '550962', '550962', '551105', '551138', '551164', '552224', '552226',
        '552226', '552485', '554444', '555421', '555421', '556788', '556838', '557319', '557465', '557471', '557791',
        '559890', '559900', '560482', '560483', '560483', '560509', '560510', '561897', '562064', '562064', '562502',
        '562509', '563455', '563466', '564078', '565134', '565163', '569113', '569115', '569127', '569128', '577688',
        '577688', '579207', '579375', '579376', '580349', '580349', '580353', '580411', '580411', '580412', '580412',
        '580437', '580437', '580441', '580441', '581167', '581168', '581169', '581170', '581184', '581185', '581189',
        '581190', '581903', '581914', '581924', '584130', '584164', '584508', '584508', '586291', '586292', '586389',
        '586390', '586718', '586718', '586723', '586723', '587490', '587589', '590521', '590522', '590523', '590524',
        '590525', '590525', '590525', '590525', '593930',
    }


class DermatologicalIrritantsCounterIrritants(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Irritants-Counter-Irritants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159412', '160532', '160532', '163192', '166968', '166968', '166968', '166968', '166968', '168800', '168800',
        '168800', '170520', '182005', '182877', '187302', '187302', '187302', '189482', '193100', '193628', '193702',
        '197147', '197147', '197251', '197251', '207930', '207930', '217846', '219180', '219180', '220833', '220833',
        '223745', '223745', '225013', '230111', '230111', '230111', '230826', '230826', '239148', '240336', '241523',
        '244554', '244554', '244554', '244554', '244554', '253921', '255715', '264973', '264973', '266566', '266566',
        '266566', '266566', '266675', '266675', '269244', '269244', '271332', '274403', '278738', '278931', '281175',
        '281175', '281175', '283328', '288627', '288627', '292818', '294422', '294422', '297808', '297808', '297813',
        '297813', '297813', '297813', '297813', '400199', '400650', '441243', '441800', '441810', '441822', '441822',
        '441874', '441879', '441904', '444807', '444922', '444922', '444922', '444922', '444923', '444923', '444923',
        '444923', '444929', '444929', '444933', '448148', '448282', '448283', '448597', '450114', '450114', '450114',
        '450114', '450114', '450345', '451847', '452025', '452026', '452072', '452630', '452655', '454473', '465444',
        '465912', '466189', '470641', '471349', '471611', '471611', '471686', '471686', '471761', '473136', '473136',
        '473136', '473136', '473136', '474216', '474216', '474216', '474236', '474236', '474236', '474529', '474573',
        '475219', '475219', '475229', '475892', '475892', '475892', '475903', '475903', '475903', '476424', '476424',
        '476452', '476452', '545020', '545024', '545397', '545416', '545796', '545796', '545796', '546067', '546067',
        '546067', '546279', '546279', '546288', '546288', '546544', '546544', '547316', '547356', '547743', '547952',
        '547952', '547952', '547952', '547952', '547967', '549725', '549787', '550415', '550640', '550640', '550640',
        '550640', '550714', '550878', '550880', '550966', '550966', '550985', '551128', '551128', '551705', '551705',
        '552085', '552104', '552280', '552373', '552373', '552434', '552472', '552477', '552914', '552919', '552944',
        '553556', '553556', '553579', '553579', '554001', '554001', '554001', '554048', '554048', '554296', '554304',
        '554508', '554523', '554588', '554588', '554709', '554710', '554902', '554902', '554903', '554903', '554956',
        '554988', '555286', '555286', '555286', '555348', '555365', '555367', '555382', '555391', '555407', '555444',
        '556205', '556210', '556243', '556604', '556604', '556608', '556955', '556969', '557138', '557254', '557408',
        '557408', '557412', '557412', '557428', '557428', '557435', '557474', '557474', '557493', '557493', '557630',
        '557679', '557779', '557779', '557790', '557808', '557835', '557845', '557878', '557885', '557892', '557907',
        '557908', '557920', '557941', '558297', '558297', '558534', '558541', '558599', '558609', '558912', '558912',
        '559390', '559400', '559563', '559712', '560354', '560369', '560901', '560921', '560939', '560945', '560948',
        '561385', '561391', '561461', '561529', '561560', '561634', '561948', '562119', '562149', '563221', '563221',
        '563236', '563248', '563402', '563417', '563712', '563726', '563742', '563743', '563751', '564177', '564209',
        '564677', '564681', '565133', '565135', '565178', '565256', '565285', '565295', '565295', '565317', '565317',
        '565662', '568491', '568491', '568491', '568541', '568583', '568583', '568583', '568585', '569006', '571722',
        '571790', '571912', '572615', '572722', '572763', '572798', '573015', '573016', '573096', '573097', '573321',
        '573321', '573321', '573349', '575246', '575246', '575458', '575458', '575749', '575783', '575878', '576223',
        '576238', '576978', '576978', '577013', '577013', '577209', '577209', '577209', '577648', '577648', '577648',
        '577949', '577965', '578213', '578342', '578741', '578970', '579023', '579034', '579034', '579052', '579572',
        '579638', '579638', '579687', '579781', '579797', '580021', '580021', '580021', '580101', '580101', '580456',
        '580471', '580733', '580740', '580850', '581654', '581661', '582778', '582779', '582779', '583236', '583277',
        '583386', '583487', '583531', '583538', '583541', '583601', '583601', '583601', '583647', '583649', '583738',
        '583841', '583956', '583989', '585167', '585180', '585598', '586169', '586421', '586467', '586954', '587724',
        '587897', '587931', '587933', '587960', '588003', '588047', '588396', '588610', '588653', '588731', '588731',
        '588793', '588793', '589288', '590422', '590687', '590755', '590783', '590784', '590785', '590925', '590925',
        '591034', '591042', '591044', '591044', '591505', '591537', '591673', '591765', '591951', '591952', '592277',
        '593127', '593169', '593614', '595176', '595223',
    }


class DermatologicalIrritantsCounterIrritantCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological Irritants-Counter-Irritant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '168800', '168800', '168800', '170520', '207930', '207930', '219180', '219180', '225013', '230111', '230111',
        '230111', '230826', '230826', '241523', '253921', '266566', '266566', '266566', '266566', '269244', '269244',
        '271332', '274403', '281175', '281175', '281175', '292818', '297808', '297808', '441243', '444807', '444922',
        '444922', '444922', '444922', '444929', '444929', '444933', '448148', '451847', '452025', '452026', '452072',
        '452630', '465912', '470641', '474236', '474236', '474236', '474529', '474573', '475219', '475219', '475229',
        '476424', '476424', '476452', '476452', '545020', '545024', '545397', '545416', '546279', '546279', '546288',
        '546288', '546544', '546544', '547952', '547952', '547952', '547952', '547952', '547967', '549725', '549787',
        '550415', '550714', '550880', '551128', '551128', '551705', '551705', '552280', '552373', '552373', '552434',
        '552477', '552914', '552919', '552944', '553556', '553556', '553579', '553579', '554001', '554001', '554001',
        '554048', '554048', '554956', '554988', '555286', '555286', '555286', '555348', '555365', '555382', '555444',
        '556210', '556243', '557138', '557254', '557408', '557408', '557412', '557412', '557474', '557474', '557493',
        '557493', '557630', '557679', '557808', '557835', '557845', '557878', '557885', '557892', '557907', '557908',
        '557920', '557941', '558297', '558297', '558599', '558609', '558912', '558912', '559390', '559400', '559563',
        '559712', '561529', '561560', '562119', '562149', '563248', '563402', '563417', '563712', '563726', '563742',
        '563743', '563751', '564677', '564681', '565295', '565295', '565317', '565317', '565662', '568491', '568491',
        '568491', '568541', '568583', '568583', '568583', '568585', '569006', '571722', '571790', '572798', '573015',
        '573016', '573096', '573097', '573321', '573321', '573321', '573349', '575749', '576223', '576238', '576978',
        '576978', '577013', '577013', '577209', '577209', '577209', '577648', '577648', '577648', '577949', '577965',
        '578741', '578970', '579572', '579638', '579638', '579687', '580021', '580021', '580021', '580101', '580101',
        '580456', '580471', '580733', '580740', '582778', '582779', '582779', '583236', '583277', '583386', '583487',
        '583531', '583538', '583541', '583601', '583601', '583601', '583647', '583649', '583738', '583841', '583956',
        '583989', '586421', '586467', '586954', '587724', '587897', '587931', '587933', '587960', '588731', '588731',
        '588793', '588793', '590687', '590925', '590925', '591034', '591042', '591044', '591044', '591505', '591537',
        '591673', '591765', '591951', '591952', '592277', '593127', '593169', '595176', '595223',
    }


class DermatologicalAntiInfectives(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Anti-infectives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152018', '152832', '155651', '155651', '155651', '155651', '156087', '156531', '156531', '158546', '159840',
        '159840', '160074', '160074', '160080', '160080', '162726', '162726', '162726', '162726', '162726', '162726',
        '164619', '165684', '166632', '166632', '168333', '168333', '169481', '171103', '171739', '171739', '171970',
        '171970', '171995', '172139', '172139', '172139', '173353', '173353', '173353', '173353', '173353', '173353',
        '173353', '173353', '173353', '173353', '173353', '173353', '173353', '173353', '174134', '174134', '174897',
        '174897', '175188', '175188', '176996', '176996', '178454', '178454', '178454', '178530', '180120', '180120',
        '180120', '185993', '190461', '190716', '190716', '190716', '190716', '190810', '190810', '190810', '192217',
        '192718', '192718', '192718', '195336', '195336', '196931', '196931', '196931', '197009', '198332', '198332',
        '201333', '201497', '202570', '202570', '202663', '202663', '202663', '202663', '202663', '202663', '202663',
        '202663', '204278', '206722', '213455', '215349', '215349', '215369', '215369', '215369', '215369', '215699',
        '215699', '216366', '216366', '216481', '217082', '217082', '217082', '221907', '221907', '221907', '221907',
        '221907', '221907', '222149', '222149', '222149', '222149', '222724', '223204', '224474', '224801', '224801',
        '224801', '224989', '224989', '231202', '231202', '231202', '231202', '231202', '231202', '232601', '232601',
        '233449', '233449', '233449', '233449', '233449', '233449', '234159', '234159', '236287', '237452', '237720',
        '237720', '237720', '237815', '238772', '238772', '238772', '239366', '239366', '239584', '239584', '242629',
        '242629', '243418', '243418', '244327', '248527', '248527', '249862', '250864', '251742', '251742', '253439',
        '253439', '253439', '254064', '254265', '255400', '255400', '255400', '255400', '255400', '255400', '257190',
        '257190', '258288', '260614', '260645', '260828', '260828', '261860', '261860', '261860', '262981', '267187',
        '267187', '267187', '267187', '267187', '267187', '268593', '268593', '268593', '268593', '269473', '269473',
        '269473', '269928', '270767', '270767', '270767', '271822', '273160', '273160', '273160', '273160', '273160',
        '273160', '273890', '273890', '273890', '275728', '276862', '277196', '282289', '282289', '282289', '282289',
        '282621', '282782', '284788', '285113', '285254', '286220', '287712', '287712', '287712', '287712', '287712',
        '287712', '287712', '287712', '287712', '287712', '289428', '289428', '289528', '289876', '290118', '290118',
        '291878', '291878', '291878', '292867', '292867', '292867', '293468', '293468', '293887', '296344', '296344',
        '296344', '296344', '298236', '298649', '298649', '298649', '400025', '400025', '400025', '400025', '400286',
        '400286', '400318', '400459', '400504', '400887', '400887', '400887', '400888', '400888', '400888', '441000',
        '441000', '441038', '441066', '441066', '441066', '441066', '441066', '441066', '442421', '442421', '442423',
        '443971', '445154', '445154', '445155', '445155', '445155', '446658', '447850', '447850', '448005', '448261',
        '448261', '448838', '448842', '449582', '449586', '449676', '449687', '449689', '449689', '449994', '449994',
        '449994', '449994', '449994', '449994', '449994', '449994', '449994', '449994', '450123', '450237', '450239',
        '450633', '450634', '450661', '450667', '450673', '452251', '452736', '453144', '453835', '454227', '454321',
        '454322', '467678', '467680', '467861', '467862', '468080', '468087', '469551', '469715', '469715', '469723',
        '469723', '469723', '469779', '470970', '470971', '471706', '471706', '471706', '473580', '473594', '473600',
        '473802', '473825', '473906', '473906', '473906', '473934', '474191', '474200', '475290', '475290', '475291',
        '475291', '476212', '476212', '476212', '476459', '476459', '476486', '476488', '476488', '476491', '545393',
        '546176', '546183', '546414', '546414', '546414', '546482', '547278', '547278', '548769', '549152', '549228',
        '550320', '550662', '550662', '550671', '550671', '550969', '551383', '551391', '552198', '552281', '552281',
        '552281', '552326', '552326', '552343', '552360', '552364', '552402', '552402', '552407', '552408', '552589',
        '552589', '552589', '552630', '552630', '552630', '552630', '552721', '552721', '552721', '552721', '552721',
        '552729', '552729', '553088', '553088', '553456', '553624', '553624', '553624', '553624', '553624', '554045',
        '554138', '554224', '554548', '555019', '555403', '555492', '556238', '556336', '556336', '556336', '556595',
        '556739', '556739', '556739', '556975', '557151', '557178', '557224', '557231', '557720', '557720', '557937',
        '557964', '557964', '557979', '557990', '558598', '558845', '558864', '558871', '559406', '559406', '559694',
        '559694', '560006', '560146', '560159', '560213', '560213', '560630', '560630', '560779', '560809', '560839',
        '560840', '561217', '561217', '561805', '561888', '561999', '562006', '562228', '562228', '562228', '562328',
        '562336', '562491', '562768', '562842', '562957', '563355', '563355', '563560', '563560', '563560', '564307',
        '564351', '564353', '564375', '564375', '564469', '564469', '564853', '564853', '565699', '566100', '566193',
        '566193', '566193', '566895', '568482', '569423', '569423', '569424', '570664', '570664', '570665', '570665',
        '571945', '572213', '572213', '572213', '572214', '572255', '572255', '572255', '572316', '572316', '572344',
        '572400', '572437', '572594', '572692', '573395', '573396', '573554', '573555', '573559', '573560', '573579',
        '573583', '573729', '574265', '574678', '575150', '575421', '575433', '575453', '575453', '575469', '575480',
        '575480', '575973', '576991', '577270', '577287', '579026', '579209', '579209', '579217', '579217', '579445',
        '579585', '579756', '579785', '579860', '579860', '579860', '579860', '579860', '579860', '579860', '579860',
        '580348', '580397', '580424', '580530', '580535', '580849', '581285', '581316', '581442', '581442', '581683',
        '581692', '581743', '581743', '581761', '581761', '581998', '582006', '582019', '582151', '582151', '582402',
        '582402', '582418', '582418', '583984', '584923', '584923', '585409', '585470', '586040', '586868', '586910',
        '586950', '586950', '586970', '587213', '587222', '588260', '588272', '588459', '588821', '588891', '589371',
        '589377', '589658', '590632', '590632', '590922', '590922', '590991', '591001', '591788', '591794', '592548',
        '592575', '592577', '593944', '593946', '594236', '594469', '594469', '595875',
    }


class DermatologicalAntifungals(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antifungals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152018', '155651', '155651', '155651', '155651', '160080', '160080', '164619', '166632', '166632', '168333',
        '168333', '169481', '171103', '171739', '171739', '171970', '171970', '173353', '173353', '173353', '173353',
        '173353', '173353', '173353', '173353', '173353', '173353', '173353', '173353', '173353', '173353', '174897',
        '174897', '175188', '175188', '178454', '178454', '178454', '180120', '180120', '180120', '185993', '190461',
        '190716', '190716', '190716', '190716', '190810', '190810', '190810', '192217', '196931', '196931', '196931',
        '197009', '198332', '198332', '201333', '213455', '215699', '215699', '216481', '217082', '217082', '217082',
        '221907', '221907', '221907', '221907', '221907', '221907', '222149', '222149', '222149', '222149', '222724',
        '223204', '232601', '232601', '233449', '233449', '233449', '233449', '233449', '233449', '234159', '234159',
        '237452', '237720', '237720', '237720', '237815', '239584', '239584', '242629', '242629', '248527', '248527',
        '249862', '250864', '251742', '251742', '254265', '260614', '261860', '261860', '261860', '268593', '268593',
        '268593', '268593', '269928', '270767', '270767', '270767', '271822', '273160', '273160', '273160', '273160',
        '273160', '273160', '276862', '282289', '282289', '282289', '282289', '282621', '285113', '287712', '287712',
        '287712', '287712', '287712', '287712', '287712', '287712', '287712', '287712', '289428', '289428', '289876',
        '290118', '290118', '292867', '292867', '292867', '293887', '298236', '298649', '298649', '298649', '400459',
        '400504', '441038', '441066', '441066', '441066', '441066', '441066', '441066', '443971', '445154', '445154',
        '445155', '445155', '445155', '446658', '448005', '448261', '448261', '448838', '448842', '450123', '450661',
        '454227', '467678', '467680', '467861', '467862', '468080', '469779', '471706', '471706', '471706', '473580',
        '473594', '473600', '473906', '473906', '473906', '473934', '474191', '474200', '475290', '475290', '475291',
        '475291', '476212', '476212', '476212', '476486', '476491', '545393', '546176', '546183', '550320', '550969',
        '551383', '551391', '552198', '552281', '552281', '552281', '552326', '552326', '552402', '552402', '552630',
        '552630', '552630', '552630', '552721', '552721', '552721', '552721', '552721', '552729', '552729', '553456',
        '553624', '553624', '553624', '553624', '553624', '554548', '555492', '556238', '556336', '556336', '556336',
        '556595', '556739', '556739', '556739', '556975', '557224', '557231', '557964', '557964', '558871', '560630',
        '560630', '560779', '560839', '561999', '562006', '562228', '562228', '562228', '562328', '562336', '562842',
        '562957', '563355', '563355', '564307', '564351', '564353', '564853', '564853', '565699', '566100', '566895',
        '570664', '570664', '570665', '570665', '572344', '572692', '573395', '573396', '573554', '573555', '573559',
        '573560', '573729', '574678', '575433', '575469', '579209', '579209', '579217', '579217', '579585', '580348',
        '580530', '580535', '580849', '581442', '581442', '581683', '581692', '581743', '581743', '581761', '581761',
        '582402', '582402', '582418', '582418', '583984', '586040', '586868', '586910', '586950', '586950', '587213',
        '587222', '588260', '588272', '588821', '588891', '589658', '590991', '591001', '592548', '592575', '592577',
        '593944', '593946',
    }


class DermatologicalAntifungalImidazoleAndRelatedAgents(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antifungal Imidazole and Related Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152018', '160080', '160080', '164619', '166632', '166632', '168333', '168333', '171970', '171970', '173353',
        '173353', '173353', '173353', '173353', '173353', '173353', '173353', '173353', '173353', '173353', '173353',
        '173353', '173353', '190461', '190716', '190716', '190716', '190716', '192217', '196931', '196931', '196931',
        '201333', '213455', '215699', '215699', '222724', '223204', '232601', '232601', '233449', '233449', '233449',
        '233449', '233449', '233449', '234159', '234159', '237452', '237720', '237720', '237720', '237815', '239584',
        '239584', '249862', '251742', '251742', '260614', '261860', '261860', '261860', '270767', '270767', '270767',
        '276862', '282289', '282289', '282289', '282289', '282621', '285113', '287712', '287712', '287712', '287712',
        '287712', '287712', '287712', '287712', '287712', '287712', '290118', '290118', '293887', '298236', '400504',
        '441066', '441066', '441066', '441066', '441066', '441066', '454227', '467678', '467680', '467861', '467862',
        '468080', '469779', '475291', '475291', '476212', '476212', '476212', '476486', '476491', '545393', '546176',
        '546183', '550320', '552281', '552281', '552281', '552326', '552326', '552721', '552721', '552721', '552721',
        '552721', '552729', '552729', '553456', '556975', '557964', '557964', '560779', '560839', '561999', '562006',
        '562842', '562957', '566100', '566895', '572344', '573395', '573554', '573560', '574678', '579585', '580348',
        '580530', '580535', '580849', '581442', '581442', '581683', '581692', '583984', '586868', '586910', '587222',
    }


class DermatologicalAntifungalCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antifungal Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '158546', '171995', '172139', '172139', '172139', '224801', '224801', '224801', '400286', '400286', '447850',
        '447850', '449676', '449687', '468087', '469551', '470970', '470971', '473802', '473825', '572255', '572255',
        '572255', '572316', '572316', '575421',
    }


class DermatologicalAntipruriticsAntihistamines(ValueSet):
    VALUE_SET_NAME = 'Dermatological Antipruritics - Antihistamines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '167074', '167541', '169364', '200687', '264903', '276479', '276479', '288855', '288855', '298563', '441192',
        '441193', '441202', '441204', '441205', '472825', '473395', '545855',
    }


class DermatologicalNsaidS(ValueSet):
    VALUE_SET_NAME = 'Dermatological - NSAID\'s'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '549555', '553541', '553872', '554660', '560881', '560881', '560883', '580698', '580705', '586510', '586510',
        '586567', '589096', '589149', '589835', '589903', '589953', '590079', '590095', '590621', '590686', '590761',
        '590767', '590986', '591700', '591744', '591914', '592010', '592511', '592529', '593875', '593923', '594556',
        '594563', '595102', '595129', '595453', '595584', '595909',
    }


class DermatologicalNsaidCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - NSAID Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '586510', '586510', '586567', '589835', '589953', '590621', '590686', '590767', '591700', '591744', '595102',
        '595129', '595453', '595584', '595909',
    }


class DermatologicalAntipruritics(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antipruritics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '167074', '167541', '169364', '176716', '176716', '180162', '183379', '200687', '202752', '212777', '212777',
        '234830', '260006', '260006', '264903', '276479', '276479', '279470', '279470', '288855', '288855', '298563',
        '441192', '441193', '441202', '441204', '441205', '441209', '448200', '450478', '450492', '451499', '471154',
        '472047', '472824', '472825', '473395', '476089', '476098', '476099', '545550', '545568', '545855', '551517',
        '552986', '553000', '556149', '556185', '556263', '556293', '557281', '557403', '558652', '558652', '558783',
        '559388', '563030', '565322', '565332', '572905', '574441', '581932', '581976', '582274', '582285', '582352',
    }


class DermatologicalAntipruriticsCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antipruritics Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '176716', '176716', '180162', '183379', '202752', '212777', '212777', '234830', '260006', '260006', '279470',
        '279470', '441209', '450478', '450492', '451499', '472047', '472824', '476089', '476098', '476099', '545550',
        '545568', '551517', '552986', '553000', '556149', '556185', '556263', '556293', '557281', '557403', '558652',
        '558652', '558783', '559388', '563030', '565322', '565332', '572905', '574441', '581932', '581976', '582274',
        '582285', '582352',
    }


class DermatologicalAntipsoriatics(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antipsoriatics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151102', '153410', '156120', '156120', '162722', '167998', '176231', '176231', '207671', '209961', '209961',
        '211822', '227336', '227336', '227511', '228467', '228467', '230363', '242864', '242864', '251714', '253041',
        '253041', '271953', '271953', '276437', '289720', '294688', '294688', '298909', '298909', '476701', '476701',
        '476702', '476702', '555027', '555027', '557288', '557315', '558720', '558730', '559374', '559396', '560235',
        '560242', '560316', '560317', '560326', '560327', '562135', '562135', '570540', '570588', '572876', '572876',
        '572878', '572878', '576003', '576003', '583806', '583807', '583808', '583809', '583964', '583966', '588837',
        '588840', '589923', '589924', '589933', '589934', '589936', '589937', '589938', '589939', '593029', '593280',
        '594007', '594008',
    }


class DermatologicalAntipsoriaticCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antipsoriatic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '476701', '476701', '476702', '476702', '555027', '555027', '576003', '576003', '588837', '588840',
    }


class DermatologicalAntiseborrheicProductsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antiseborrheic Products and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '176721', '176721', '181392', '181392', '181392', '181392', '181392', '186965', '200114', '200114', '200736',
        '230316', '238707', '238707', '258204', '268489', '271267', '271267', '283136', '283136', '293287', '297500',
        '297500', '400390', '441261', '441263', '443558', '443558', '443558', '453744', '470975', '470975', '472618',
        '546966', '551982', '552013', '552728', '552728', '552728', '552728', '552728', '555654', '555654', '556808',
        '557177', '557658', '558121', '558124', '559858', '559859', '559944', '560031', '561089', '564991', '566905',
        '566905', '566950', '572371', '572395', '579749', '579755', '579908', '579932', '580794', '581383', '581904',
        '581904', '582001', '582001', '582995', '586324', '586374', '587664', '587664', '588487', '590936', '594017',
        '594017', '594798', '594839',
    }


class DermatologicalAntiseborrheicCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antiseborrheic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '200114', '200114', '238707', '238707', '556808', '557658', '564991', '566905', '566905', '566950', '587664',
        '587664', '590936',
    }


class DermatologicalAntiviralHerpes(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antiviral, Herpes'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156531', '156531', '159840', '159840', '204278', '224474', '238772', '238772', '238772', '286220', '449582',
        '449586',
    }


class DermatologicalAntiviralCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antiviral Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DermatologicalAntineoplasticOrPremalignantLesions(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antineoplastic or Premalignant Lesions'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150124', '158682', '176591', '186215', '194352', '205165', '211899', '211910', '219066', '223357', '235598',
        '264213', '267921', '276214', '285232', '448086', '570205', '570206', '570320', '570321', '579975', '579983',
        '587543', '587747', '590689', '591953',
    }


class DermatologicalAntineoplasticAntimetabolites(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antineoplastic Antimetabolites'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '186215', '194352', '205165', '211899', '211910', '219066', '267921', '285232', '587543', '587747',
    }


class DermatologicalAntineoplasticRetinoids(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Antineoplastic Retinoids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '223357', '276214',
    }


class DermatologicalTherapeuticBathProducts(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Therapeutic Bath Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DermatologicalBurnProducts(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Burn Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155737', '155737', '155737', '155737', '155737', '155737', '155737', '155737', '173059', '208085', '208085',
        '208085', '228315', '228315', '228315', '228315', '228315', '228315', '228315', '260082', '260082', '260082',
        '277318', '277318', '277318', '277318', '277318', '277318', '279825', '279825', '279825', '279825', '279825',
        '290480',
    }


class DermatologicalBurnProductCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Burn Product Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DermatologicalKeratoplastics(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Keratoplastics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156241', '156241', '186081', '186081', '202961', '212220', '214797', '214797', '214797', '220180', '220180',
        '232907', '237292', '245815', '245815', '266118', '266359', '266359', '268075', '268075', '269269', '269269',
        '283658', '283658', '283658', '283658', '283658', '283658', '298620', '298620', '298620', '298620', '400317',
        '441293', '441293', '441307', '471177', '551627', '555300', '556718', '556718', '556735', '556775', '556775',
        '557228', '558213', '561099', '562083', '562102', '563159', '563640', '578090', '579968', '579968', '581727',
        '581848', '590896', '595228', '595228',
    }


class DermatologicalKeratoplasticCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Keratoplastic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '202961', '441307',
    }


class DermatologicalGlucocorticoidsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Glucocorticoids and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150651', '150651', '150689', '150689', '150975', '153971', '155643', '155712', '155712', '155712', '157376',
        '157376', '158383', '163988', '163988', '163988', '163988', '164430', '165649', '166234', '168343', '168343',
        '168343', '170175', '170175', '170765', '171036', '171036', '174539', '174539', '175585', '175585', '175585',
        '175585', '177632', '178786', '178786', '178786', '178926', '178926', '178926', '178926', '180193', '180193',
        '180193', '180193', '180193', '180193', '180796', '180796', '180796', '180930', '180930', '180930', '180930',
        '180930', '181284', '181337', '181961', '181961', '182001', '182001', '183254', '183254', '184731', '185009',
        '185302', '185960', '185960', '185960', '186637', '187459', '187459', '187459', '187562', '187562', '187562',
        '187562', '187770', '188343', '191349', '191349', '191427', '191427', '191427', '192623', '192623', '192623',
        '192623', '193051', '193051', '193198', '193389', '193389', '193389', '193389', '193717', '193717', '193717',
        '193717', '193717', '194782', '194782', '197214', '197214', '198131', '198410', '198978', '199062', '200118',
        '200193', '200544', '200544', '200544', '200544', '200544', '200544', '200544', '202171', '204051', '204051',
        '206279', '207308', '207308', '207475', '207475', '207475', '207475', '207475', '207475', '208777', '208777',
        '208838', '208838', '209481', '209481', '209481', '211224', '211224', '211904', '211904', '211904', '211904',
        '211904', '211904', '214255', '214255', '214501', '214501', '214501', '219989', '219989', '220970', '222101',
        '222101', '222101', '222850', '222850', '223667', '223689', '223689', '224805', '224805', '224805', '225263',
        '225263', '226234', '226234', '226234', '226234', '227074', '227074', '227530', '227530', '227530', '227760',
        '228911', '228911', '228911', '228911', '229277', '229277', '229830', '229830', '230319', '230319', '230526',
        '230850', '230850', '231426', '231426', '231524', '231524', '235549', '235549', '235549', '235549', '235600',
        '235943', '235943', '235943', '235943', '235943', '235943', '235943', '235943', '235943', '237327', '237327',
        '237327', '237748', '237748', '237748', '237748', '242254', '242254', '242254', '242254', '242254', '242688',
        '243603', '243603', '244647', '244647', '244759', '244759', '247009', '247009', '247676', '248181', '248181',
        '248666', '248666', '250959', '251415', '251601', '251601', '251870', '254655', '255079', '256479', '256479',
        '256479', '256479', '256936', '257860', '257860', '258774', '258774', '258774', '258774', '259370', '259370',
        '259370', '264629', '264629', '264629', '264629', '264998', '264998', '264998', '265881', '265881', '267335',
        '267335', '267728', '267728', '269442', '269442', '270360', '270360', '270869', '270869', '270869', '270869',
        '272057', '272057', '272057', '272057', '272057', '272554', '272554', '272554', '273359', '273359', '273957',
        '273957', '274242', '274658', '274658', '275127', '275375', '275996', '275996', '277727', '277727', '279429',
        '279429', '279429', '279429', '281625', '281625', '281625', '281996', '281996', '282008', '282221', '282221',
        '282221', '282722', '282722', '282722', '282722', '282722', '282722', '282788', '283462', '283462', '284840',
        '284840', '284840', '284840', '287767', '294036', '294036', '295393', '295393', '295393', '295828', '295828',
        '295828', '295969', '295969', '297139', '297139', '297139', '297293', '297293', '297293', '297961', '297961',
        '297961', '298745', '299856', '299856', '299856', '299856', '441366', '441366', '441379', '441379', '441379',
        '441451', '441461', '441461', '441461', '441542', '443842', '446573', '446573', '448905', '449998', '449998',
        '449998', '449998', '449998', '449999', '449999', '450021', '451003', '451003', '451003', '451129', '451129',
        '451304', '451304', '452338', '452339', '452979', '452979', '453448', '453448', '453448', '467321', '467328',
        '467511', '467511', '468186', '468186', '468186', '468186', '473338', '473338', '473338', '473339', '473339',
        '473339', '473756', '473756', '473775', '474237', '474237', '474239', '475535', '475535', '475543', '475543',
        '545023', '545023', '545785', '546502', '546502', '546612', '547162', '548153', '548153', '549351', '549381',
        '549414', '549414', '550554', '550554', '551009', '551009', '553266', '553266', '553269', '553290', '553404',
        '554117', '555075', '555075', '555078', '555078', '555595', '556729', '556742', '557109', '557116', '557126',
        '557144', '558635', '559078', '559078', '559226', '559493', '559508', '559931', '559932', '560670', '560670',
        '560777', '560777', '561767', '562240', '562251', '562395', '562395', '562395', '562604', '562960', '564395',
        '564395', '564395', '564397', '564400', '564400', '564400', '570370', '571346', '571356', '572394', '572394',
        '572394', '573757', '573759', '573770', '573771', '575186', '575262', '576135', '576222', '576224', '576250',
        '576334', '577278', '577658', '577942', '577959', '577988', '578015', '578380', '578606', '579806', '579806',
        '579806', '579806', '580379', '580385', '580402', '580403', '581545', '581546', '581915', '581927', '582002',
        '586246', '586270', '586736', '586863', '586878', '586897', '587271', '587488', '587550', '587584', '587706',
        '587717', '588281', '588454', '589324', '589422', '589757', '589952', '589987', '590111', '590365', '590436',
        '590534', '590561', '590781', '590883', '590951', '591519', '591584', '591745', '592480', '593081', '593162',
        '593449', '593739', '594458', '594885', '595011', '595022', '595248', '595386',
    }


class DermatologicalGlucocorticoidLocalAnestheticCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Glucocorticoid-Local Anesthetic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150651', '150651', '158383', '204051', '204051', '208838', '208838', '222850', '222850', '224805', '224805',
        '224805', '231426', '231426', '242688', '250959', '251415', '259370', '259370', '259370', '273957', '273957',
        '274242', '282788', '294036', '294036', '560670', '560670', '560777', '560777', '587271', '590883', '590951',
        '595022',
    }


class DermatologicalEmollientsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Emollients and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151264', '153999', '157380', '158620', '159390', '159390', '164796', '166488', '168010', '168010', '168010',
        '168010', '168010', '168010', '168010', '168010', '168010', '168344', '168715', '170523', '170523', '170523',
        '170523', '171723', '171870', '172455', '173451', '177667', '177667', '177667', '177667', '177667', '177667',
        '177667', '178255', '178706', '178706', '178706', '179662', '179662', '179662', '180240', '181129', '182407',
        '188286', '188782', '188782', '189005', '189005', '189005', '192034', '192034', '192034', '192034', '192034',
        '194963', '195152', '196617', '196617', '196617', '198652', '198652', '200473', '201484', '201484', '201979',
        '201979', '201979', '203725', '204638', '205326', '205326', '205618', '209020', '209581', '211072', '211072',
        '211385', '211385', '213923', '213923', '213923', '213923', '214148', '216568', '217658', '218196', '219540',
        '219540', '221031', '221499', '224461', '224514', '224515', '224515', '226689', '226768', '226768', '226768',
        '230214', '230321', '230378', '230378', '230378', '235467', '235467', '235467', '235467', '235467', '236559',
        '236559', '237750', '238347', '238347', '238347', '239237', '239382', '240787', '240787', '242415', '242415',
        '244142', '249280', '249573', '249573', '249943', '250748', '250748', '250748', '250977', '250977', '251380',
        '251729', '251923', '251923', '252027', '252027', '252027', '253590', '255609', '257252', '257941', '257941',
        '258807', '260121', '260299', '260299', '260299', '260299', '262814', '262814', '263598', '265722', '265722',
        '266026', '266026', '266026', '266026', '266026', '266206', '266206', '267102', '267102', '267802', '269028',
        '269028', '269899', '269899', '271370', '271370', '274609', '274790', '275133', '275133', '275152', '275152',
        '275688', '277091', '277097', '280044', '280044', '280044', '280044', '280044', '280358', '280358', '280358',
        '280839', '280839', '280839', '280839', '280839', '283476', '284578', '284578', '285053', '286881', '287887',
        '288191', '291744', '295276', '299556', '299556', '400064', '400196', '400196', '400196', '400197', '400197',
        '400197', '400389', '400391', '400391', '400391', '400391', '400391', '400395', '400395', '400395', '400398',
        '400398', '400398', '400398', '441549', '441566', '441566', '441567', '441567', '441581', '441611', '441627',
        '441639', '441666', '441666', '441997', '442229', '442229', '442230', '443786', '443916', '443926', '444104',
        '444104', '444104', '444285', '444285', '445002', '445946', '445946', '445946', '445957', '445957', '446191',
        '446229', '446278', '446544', '446547', '446547', '446547', '446547', '446559', '446559', '446559', '446559',
        '446559', '446559', '446559', '446559', '446907', '447424', '447635', '448094', '448094', '448149', '448150',
        '448968', '449052', '450006', '450006', '450006', '450006', '450769', '451045', '451045', '451621', '451621',
        '451752', '451799', '451943', '451944', '451944', '451944', '452259', '452346', '452346', '452440', '452440',
        '452585', '452585', '452625', '452626', '452632', '452636', '452637', '452638', '452640', '452652', '452652',
        '452652', '452658', '452658', '452661', '452661', '452743', '452743', '452758', '452759', '452759', '452761',
        '452762', '452765', '452765', '452765', '452941', '453550', '454222', '454222', '454296', '454296', '465098',
        '465099', '465177', '465177', '466716', '466716', '466716', '466719', '466719', '467679', '467684', '467684',
        '467701', '467716', '467716', '467951', '467951', '467990', '468084', '468084', '468084', '468084', '469546',
        '469546', '469546', '469546', '470684', '471209', '471211', '471363', '471934', '472004', '472685', '473200',
        '473203', '473204', '473359', '473385', '473407', '473407', '473489', '473723', '473833', '473851', '473851',
        '473851', '473851', '474067', '474073', '474248', '474249', '474393', '475659', '475667', '475996', '475996',
        '476012', '476012', '476241', '476412', '476419', '476420', '476466', '476466', '476466', '476466', '476575',
        '476576', '476577', '545036', '545036', '545036', '545039', '545039', '545039', '545185', '545186', '545186',
        '545187', '545189', '545190', '545191', '545191', '546084', '546678', '548545', '548545', '548546', '548546',
        '550416', '550421', '550858', '551787', '552283', '555621', '555975', '556043', '556043', '556043', '556109',
        '556115', '556135', '556135', '556135', '556145', '556165', '556181', '556399', '556399', '556399', '556427',
        '556427', '556427', '556459', '556512', '556611', '556652', '556721', '556721', '556915', '556915', '557153',
        '557270', '557286', '557287', '557287', '557287', '557331', '557331', '557331', '557331', '557331', '557331',
        '557331', '557339', '557339', '557353', '557355', '557355', '557360', '557360', '557363', '557363', '557363',
        '557429', '557429', '557432', '557432', '557442', '557442', '557481', '557481', '557481', '557527', '557601',
        '557666', '557666', '557705', '557713', '558036', '558036', '558036', '558071', '558071', '558071', '558126',
        '558126', '558128', '558129', '558194', '558194', '558208', '558208', '558411', '558411', '558458', '558496',
        '558540', '558540', '558711', '558711', '558820', '558859', '558859', '558938', '558943', '559011', '559087',
        '559093', '559093', '559118', '559118', '559708', '559733', '559942', '559964', '560000', '560000', '560000',
        '560017', '560017', '560017', '560077', '560084', '560487', '560487', '560488', '560634', '560634', '560651',
        '560651', '560668', '560682', '560688', '560709', '561023', '561024', '561024', '561286', '561288', '561696',
        '561699', '561700', '561727', '561731', '561732', '561737', '561804', '561914', '562130', '562161', '562184',
        '562184', '562184', '562184', '562184', '562184', '562193', '562193', '562193', '562193', '562504', '562540',
        '562540', '562540', '562540', '562544', '562544', '562544', '562544', '562672', '563259', '563319', '563400',
        '563432', '563432', '563432', '563439', '564848', '564905', '565381', '565383', '565424', '565464', '565528',
        '565528', '565528', '565573', '565706', '565707', '565707', '565707', '565737', '565737', '565737', '565742',
        '565747', '566374', '566374', '566915', '566923', '567393', '567393', '567400', '567426', '567426', '569862',
        '569862', '569879', '570020', '570441', '570845', '570848', '570854', '571031', '571479', '571480', '571480',
        '571726', '571882', '571926', '571939', '571969', '572320', '572439', '572643', '572643', '572644', '572644',
        '572701', '572871', '572872', '572873', '572891', '572902', '572902', '572904', '572904', '572906', '572953',
        '572953', '573914', '573914', '573932', '573973', '573973', '574049', '574049', '574056', '574056', '574217',
        '574398', '574654', '574988', '574988', '575034', '575034', '575034', '575041', '575041', '575041', '575043',
        '575140', '575168', '575586', '575592', '575639', '575687', '575730', '575862', '575900', '575925', '576171',
        '576190', '576791', '576808', '576825', '576936', '576995', '577015', '577092', '577129', '577500', '577519',
        '577697', '577831', '577832', '577850', '577893', '577943', '577966', '577967', '577987', '578301', '578301',
        '578617', '578664', '579488', '579505', '580443', '580443', '580443', '580443', '580443', '580443', '580623',
        '580623', '580623', '580623', '580623', '580623', '581012', '581075', '581081', '581193', '581196', '581215',
        '581215', '581215', '581380', '581380', '581380', '581577', '581577', '582026', '582026', '582075', '582272',
        '582516', '582867', '582903', '583222', '583352', '583653', '585790', '585902', '586322', '586434', '586471',
        '586645', '586695', '586816', '586875', '587388', '587944', '587944', '587951', '587951', '588197', '588197',
        '588356', '588664', '588664', '588664', '588665', '588665', '588666', '588667', '588744', '588746', '588746',
        '588746', '588749', '588749', '588750', '589319', '589361', '589756', '589790', '590246', '590498', '590520',
        '590582', '590814', '590814', '590845', '590845', '590886', '590886', '591524', '592014', '592034', '592075',
        '592358', '592363', '592543', '592557', '592804', '592825', '594154', '594160', '594160', '594200', '594207',
        '594207', '594504', '594543', '594803', '594813', '595164', '595289', '595933',
    }


class DermatologicalEmollientCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Emollient Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151264', '157380', '158620', '159390', '159390', '164796', '172455', '188286', '188782', '188782', '194963',
        '195152', '196617', '196617', '196617', '198652', '198652', '200473', '201484', '201484', '201979', '201979',
        '201979', '203725', '204638', '205618', '209020', '209581', '211072', '211072', '211385', '211385', '214148',
        '218196', '219540', '219540', '221499', '224461', '224514', '236559', '236559', '239382', '242415', '242415',
        '249280', '249943', '250977', '250977', '251380', '255609', '257252', '257941', '257941', '260121', '262814',
        '262814', '263598', '265722', '265722', '266206', '266206', '267102', '267102', '267802', '269028', '269028',
        '269899', '269899', '271370', '271370', '274609', '275133', '275133', '285053', '286881', '288191', '299556',
        '299556', '400064', '400395', '400395', '400395', '400398', '400398', '400398', '400398', '441549', '441581',
        '441666', '441666', '441997', '443786', '443916', '443926', '444285', '444285', '445002', '445946', '445946',
        '445946', '445957', '445957', '446278', '446544', '446547', '446547', '446547', '446547', '448094', '448094',
        '448149', '448150', '450006', '450006', '450006', '450006', '450769', '451045', '451045', '451621', '451621',
        '451799', '451943', '451944', '451944', '451944', '452259', '452346', '452346', '452440', '452440', '452585',
        '452585', '452625', '452626', '452632', '452636', '452637', '452640', '452652', '452652', '452652', '452658',
        '452658', '452661', '452661', '452743', '452743', '452758', '452759', '452759', '452761', '452762', '452765',
        '452765', '452765', '452941', '454222', '454222', '454296', '454296', '465098', '465099', '465177', '465177',
        '466716', '466716', '466716', '466719', '466719', '467679', '467684', '467684', '467701', '467716', '467716',
        '468084', '468084', '468084', '468084', '469546', '469546', '469546', '469546', '471363', '472685', '473200',
        '473203', '473204', '473359', '473385', '473407', '473407', '473723', '473833', '473851', '473851', '473851',
        '473851', '474067', '474073', '475659', '475667', '475996', '475996', '476012', '476012', '476241', '476412',
        '476419', '476420', '476575', '476576', '476577', '545036', '545036', '545036', '545039', '545039', '545039',
        '545185', '545186', '545186', '545187', '545189', '545190', '545191', '545191', '546084', '548545', '548545',
        '548546', '548546', '550416', '550421', '550858', '551787', '552283', '555621', '555975', '556043', '556043',
        '556043', '556109', '556115', '556135', '556135', '556135', '556145', '556165', '556181', '556399', '556399',
        '556399', '556427', '556427', '556427', '556512', '556611', '556652', '556721', '556721', '556915', '556915',
        '557153', '557270', '557286', '557287', '557287', '557287', '557331', '557331', '557331', '557331', '557331',
        '557331', '557331', '557339', '557339', '557353', '557355', '557355', '557360', '557360', '557429', '557429',
        '557442', '557442', '557481', '557481', '557481', '557527', '557601', '558036', '558036', '558036', '558194',
        '558194', '558208', '558208', '558458', '558496', '558540', '558540', '558711', '558711', '558943', '559011',
        '559087', '559093', '559093', '559118', '559118', '559708', '559733', '559942', '559964', '560000', '560000',
        '560000', '560017', '560017', '560017', '560487', '560487', '560488', '560634', '560634', '560651', '560651',
        '560668', '560682', '560688', '560709', '561286', '561288', '561696', '561699', '561700', '561727', '561731',
        '561732', '561737', '561804', '562130', '562161', '562184', '562184', '562184', '562184', '562184', '562184',
        '562193', '562193', '562193', '562193', '562504', '562540', '562540', '562540', '562540', '562544', '562544',
        '562544', '562544', '562672', '563259', '563319', '563400', '565381', '565383', '565424', '565464', '565528',
        '565528', '565528', '565573', '565706', '565707', '565707', '565707', '565737', '565737', '565737', '566374',
        '566374', '566915', '566923', '567426', '567426', '569862', '569862', '569879', '570020', '570441', '570845',
        '570848', '570854', '571031', '571479', '571480', '571480', '571939', '571969', '572320', '572439', '572643',
        '572643', '572644', '572644', '572701', '572871', '572872', '572873', '572891', '572902', '572902', '572904',
        '572904', '572906', '572953', '572953', '573914', '573914', '573973', '573973', '574049', '574049', '574056',
        '574056', '574217', '574398', '574654', '574988', '574988', '575034', '575034', '575034', '575041', '575041',
        '575041', '575140', '575168', '575586', '575687', '575730', '575862', '575900', '575925', '576171', '576190',
        '576791', '576808', '576825', '576936', '576995', '577015', '577092', '577129', '577697', '577831', '577832',
        '577850', '577893', '577943', '577966', '577967', '578617', '578664', '579488', '579505', '581075', '581081',
        '581193', '581196', '581215', '581215', '581215', '581380', '581380', '581380', '581577', '581577', '582026',
        '582026', '582867', '582903', '583222', '583352', '583653', '586322', '586434', '586471', '586645', '586695',
        '586816', '586875', '587388', '588197', '588197', '588356', '588664', '588664', '588664', '588665', '588665',
        '588666', '588667', '588744', '588746', '588746', '588746', '588749', '588749', '588750', '589756', '589790',
        '590246', '590498', '590520', '590814', '590814', '590845', '590845', '590886', '590886', '591524', '592014',
        '592034', '592075', '592358', '592363', '594154', '594160', '594160', '594200', '594207', '594207', '594504',
        '594543', '594803', '594813', '595164', '595933',
    }


class DermatologicalEnzymesAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Enzymes and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151426', '151426', '273275', '273275', '467327', '467327', '476219', '476219',
    }


class DermatologicalEnzymeCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Enzyme Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '467327', '467327', '476219', '476219',
    }


class DermatologicalHairGrowthAgents(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Hair Growth Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150496', '151272', '207082', '207082', '215625', '295802', '296728', '297155', '297155', '441704', '441704',
        '473448', '475420', '475420', '475420', '475421', '475421', '557180', '557180', '557182', '557182', '560338',
        '560341', '570000', '571911',
    }


class HairGrowthAgentsTypeIi5AlphaReductaseInhibitors(ValueSet):
    VALUE_SET_NAME = 'Hair Growth Agents - Type II 5-Alpha Reductase Inhibitors'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150496', '215625', '295802',
    }


class DermatologicalKeratolyticsAntimitotics(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Keratolytics-Antimitotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150879', '150879', '151351', '151351', '159650', '160882', '160882', '160882', '160882', '164702', '164702',
        '173329', '178854', '178854', '178854', '178854', '178854', '178854', '180702', '180702', '180702', '180702',
        '186996', '186996', '189226', '191575', '196215', '202716', '206433', '210492', '213643', '213643', '214564',
        '224996', '224996', '229881', '232476', '236109', '241316', '242107', '244627', '247237', '247237', '247237',
        '247237', '247237', '247237', '248361', '248361', '250278', '250278', '250278', '250278', '250278', '253336',
        '253336', '253336', '264709', '264709', '264709', '272052', '276980', '279512', '280592', '285412', '285412',
        '290884', '290884', '296598', '400513', '400513', '441273', '441273', '441714', '441721', '441726', '441726',
        '441741', '441741', '445968', '445969', '445969', '445969', '445969', '445969', '445971', '446093', '446095',
        '448227', '448895', '450810', '450810', '450810', '450810', '450810', '452358', '452482', '453671', '466069',
        '467980', '467980', '467992', '467992', '467996', '467996', '468350', '471795', '471795', '473440', '473440',
        '473456', '473456', '473767', '474078', '474151', '474647', '474649', '474650', '475154', '475186', '508181',
        '512418', '545378', '545378', '545498', '545605', '545766', '546128', '546128', '546128', '546768', '546834',
        '547498', '547498', '547819', '547819', '547965', '547965', '549037', '549037', '549074', '549078', '549097',
        '549098', '550590', '550607', '551050', '552788', '553401', '553401', '553401', '553401', '553401', '553765',
        '553765', '553766', '553818', '553819', '554204', '554837', '554837', '554869', '554869', '555381', '555389',
        '555405', '555405', '555743', '555819', '556321', '556322', '556790', '556790', '556839', '556914', '556914',
        '557308', '557387', '557397', '557722', '557726', '557726', '557748', '557748', '557781', '557788', '557998',
        '558024', '558117', '558510', '559061', '559138', '559140', '559313', '559424', '559424', '559480', '559495',
        '559805', '559853', '559881', '559977', '560003', '560363', '560414', '560749', '561409', '561690', '561733',
        '561784', '562103', '562836', '562837', '562909', '562911', '563515', '563525', '564594', '564721', '564816',
        '564816', '567383', '569195', '569195', '571977', '572321', '572375', '572442', '572771', '573401', '573402',
        '573404', '573405', '573405', '573406', '573406', '575210', '575477', '575477', '575479', '575481', '575481',
        '575482', '575483', '575483', '575487', '575797', '576879', '577888', '578026', '578027', '578047', '579702',
        '579719', '580436', '580442', '580785', '580787', '580887', '581173', '581183', '581684', '581684', '581996',
        '582099', '582376', '582376', '582376', '582394', '582394', '582517', '585835', '585873', '586057', '586057',
        '586595', '587261', '587261', '587665', '589678', '590052', '590516', '591000', '591247', '594898', '594925',
        '595023', '595026', '595275', '595275', '595293', '595353', '595364', '595924',
    }


class DermatologicalKeratolyticAntimitoticCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Keratolytic-Antimitotic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '206433', '229881', '279512', '290884', '290884', '441273', '441273', '441714', '453671', '545766', '549037',
        '549037', '550590', '554869', '554869', '559424', '559424', '559977', '560003', '560363', '560414', '561690',
        '561733',
    }


class DermatologicalImmunomodulatingAgents(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Immunomodulating Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '170641', '233006', '233006', '245063', '284131', '553862', '553868', '560935', '560936', '570605', '570606',
        '574407', '574411',
    }


class DermatologicalImmunomodulatorImidazoquinolinamines(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Immunomodulator - Imidazoquinolinamines'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '233006', '233006', '245063', '560935', '560936', '570605', '570606', '574407', '574411',
    }


class DermatologicalTopicalLocalAnestheticsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Topical Local Anesthetics and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155216', '158410', '162850', '164310', '166759', '166759', '166759', '166759', '172263', '172263', '174768',
        '184243', '186093', '189032', '189032', '189032', '189032', '191692', '191692', '191692', '193615', '195402',
        '195402', '196025', '201874', '201874', '209869', '209869', '218883', '219132', '225241', '225241', '226674',
        '228950', '234350', '234350', '236620', '236961', '238061', '238061', '241013', '242856', '242856', '242949',
        '242949', '242949', '242949', '246336', '246336', '252215', '253116', '253116', '253664', '253664', '260685',
        '262660', '263737', '263737', '264053', '264777', '264777', '264777', '273775', '281979', '285679', '289845',
        '293030', '293030', '441211', '441220', '441932', '441934', '441935', '441935', '441938', '441938', '441938',
        '441940', '441943', '441944', '441945', '446996', '448872', '448872', '448872', '448873', '451588', '451589',
        '451589', '451589', '451839', '453844', '453844', '473986', '473986', '474204', '474540', '475002', '475002',
        '475002', '475252', '475252', '475802', '475802', '475802', '476598', '476708', '501640', '516397', '545588',
        '545712', '545712', '546433', '546433', '547721', '547781', '548970', '548970', '549749', '550439', '550440',
        '550440', '552371', '552436', '552436', '552436', '552632', '552662', '552662', '552961', '552961', '552981',
        '552981', '553391', '555487', '555601', '556069', '556069', '556069', '556069', '556069', '556274', '556274',
        '556274', '556275', '556323', '556376', '557248', '557757', '557785', '558101', '559265', '559265', '559376',
        '559377', '559421', '559615', '559615', '560562', '560562', '560823', '562596', '562641', '563345', '564374',
        '564417', '566331', '566377', '566686', '566732', '567337', '567376', '567402', '568416', '569080', '569080',
        '570270', '570270', '570270', '570361', '570361', '570361', '570398', '570398', '570398', '570398', '570398',
        '570398', '570398', '570398', '570398', '570811', '570811', '570811', '570811', '570847', '570847', '570847',
        '571244', '571244', '571244', '571244', '571412', '571795', '572016', '573263', '573298', '575493', '575494',
        '575524', '575525', '575728', '576078', '576078', '576085', '576085', '576784', '576817', '577571', '577571',
        '577571', '577597', '577597', '577597', '577929', '577929', '577929', '577929', '577929', '577930', '577930',
        '577945', '577948', '578016', '578269', '578327', '578675', '578675', '578684', '579382', '579402', '579669',
        '579670', '579931', '580973', '580973', '580973', '580999', '581493', '581613', '581613', '581678', '581693',
        '581826', '581984', '581993', '582053', '582121', '582121', '582468', '582468', '582611', '582859', '582890',
        '582904', '582993', '582997', '583137', '583137', '583137', '583156', '583191', '583193', '583262', '583262',
        '583262', '583262', '583347', '583353', '583356', '583391', '583399', '583401', '583428', '583428', '583428',
        '583432', '583440', '583440', '583440', '583440', '583444', '583467', '583474', '583496', '583529', '583536',
        '583606', '583625', '583646', '583658', '583662', '583707', '583755', '583789', '586014', '586245', '586865',
        '587560', '587660', '587660', '587721', '587872', '587905', '588156', '588169', '589386', '589612', '589651',
        '589676', '589679', '589964', '590046', '590669', '590690', '590726', '590744', '590816', '590902', '590929',
        '591065', '591141', '591151', '591152', '591228', '591229', '591297', '591303', '591362', '591366', '591390',
        '591478', '591495', '591539', '591736', '591797', '591892', '591892', '591962', '591980', '591980', '591998',
        '592074', '592074', '592122', '592276', '592335', '592387', '592387', '592512', '592541', '592553', '592558',
        '592559', '592608', '592662', '592775', '592845', '592866', '593087', '593137', '593196', '593232', '593250',
        '593295', '593301', '593336', '593400', '593468', '593519', '593520', '593625', '593640', '593663', '593663',
        '593688', '593878', '593902', '594105', '594125', '594148', '594148', '594188', '594225', '594237', '594240',
        '594257', '594257', '594362', '594363', '594375', '594390', '594492', '594532', '594533', '594557', '594945',
        '594955', '595017', '595137', '595612', '595879', '596002', '596017', '596049',
    }


class DermatologicalLocalAnestheticGasses(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Local Anesthetic Gasses'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '472081', '472081', '472099', '472390', '472390', '550730', '550730', '550730',
    }


class DermatologicalLocalAnestheticCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Local Anesthetic Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155216', '162850', '164310', '172263', '172263', '174768', '184243', '186093', '191692', '191692', '191692',
        '195402', '195402', '196025', '201874', '201874', '209869', '209869', '225241', '225241', '236620', '236961',
        '241013', '242856', '242856', '263737', '263737', '264053', '273775', '281979', '285679', '293030', '293030',
        '441211', '441220', '441932', '441934', '441935', '441935', '441938', '441938', '441938', '441940', '441943',
        '441944', '441945', '451588', '451839', '473986', '473986', '474204', '475252', '475252', '475802', '475802',
        '475802', '476598', '476708', '516397', '545712', '545712', '546433', '546433', '547721', '547781', '550439',
        '552371', '552436', '552436', '552436', '552632', '552662', '552662', '555601', '556275', '556323', '556376',
        '557757', '557785', '558101', '559615', '559615', '560823', '562596', '562641', '563345', '564374', '564417',
        '566331', '566377', '566686', '566732', '567337', '567376', '567402', '568416', '571244', '571244', '571244',
        '571244', '571412', '572016', '573263', '573298', '575493', '575494', '575524', '575525', '576784', '576817',
        '577929', '577929', '577929', '577929', '577929', '577930', '577930', '577945', '577948', '578269', '578675',
        '578675', '578684', '579669', '579670', '579931', '581493', '581613', '581613', '581826', '581984', '581993',
        '582053', '582121', '582121', '582611', '582859', '582890', '582904', '583137', '583137', '583137', '583193',
        '583262', '583262', '583262', '583262', '583347', '583353', '583356', '583391', '583399', '583401', '583428',
        '583428', '583428', '583432', '583440', '583440', '583440', '583440', '583444', '583467', '583474', '583496',
        '583606', '583625', '583646', '583658', '583662', '583707', '583755', '583789', '586014', '586245', '586865',
        '587560', '587660', '587660', '587721', '587872', '587905', '589676', '589679', '589964', '590046', '590690',
        '590744', '590816', '591065', '591141', '591151', '591152', '591228', '591229', '591362', '591390', '591495',
        '591539', '591736', '591797', '591962', '591980', '591980', '592122', '592276', '592553', '592662', '592845',
        '593087', '593196', '593232', '593250', '593295', '593301', '593336', '593519', '593625', '593688', '594105',
        '594125', '594188', '594240', '594362', '594363', '594492', '594532', '594533', '594557', '594945', '594955',
        '595017', '595137', '595612', '595879',
    }


class DermatologicalPigmentingDepigmentingAgents(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Pigmenting-Depigmenting Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '167021', '182302', '182302', '182302', '184041', '187876', '198869', '212226', '262055', '264863', '279598',
        '299056', '400077', '400078', '450791', '454319', '454319', '467991', '468121', '474568', '474568', '475576',
        '475576', '476432', '476484', '551039', '551040', '551064', '551065', '551079', '551080', '554664', '559000',
        '566003', '566038', '570960', '585404', '592045', '592046', '592046', '592047',
    }


class DermatologicalPigmentingAgents(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Pigmenting Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '198869', '264863', '279598', '299056',
    }


class DermatologicalDepigmentingAgentsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Depigmenting Agents and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '167021', '182302', '182302', '182302', '184041', '187876', '212226', '262055', '400077', '400078', '450791',
        '454319', '454319', '467991', '468121', '474568', '474568', '475576', '475576', '476432', '476484', '551039',
        '551040', '551064', '551065', '551079', '551080', '554664', '559000', '566003', '566038', '570960', '585404',
        '592045', '592046', '592046', '592047',
    }


class DermatologicalDepigmentingCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Depigmenting Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '187876', '400077', '400078', '454319', '454319', '467991', '468121', '551040', '551064', '551065', '551079',
        '551080', '566003', '566038', '592045', '592046', '592046', '592047',
    }


class DermatologicalScabicidesAndPediculicides(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Scabicides and Pediculicides'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153688', '155274', '164616', '170370', '182835', '182835', '183489', '187151', '193263', '219559', '219936',
        '226330', '226330', '226330', '226330', '226330', '228807', '230857', '230857', '233116', '254260', '254260',
        '255495', '263579', '270913', '283741', '285732', '296290', '400469', '400470', '441971', '441986', '441988',
        '441990', '445496', '447541', '448974', '448974', '450613', '451747', '452291', '466232', '470957', '470958',
        '471574', '473358', '473358', '546031', '546897', '546930', '546930', '546930', '546930', '546930', '558436',
        '558446', '560500', '563123', '563126', '567458', '567458', '567473', '567473', '570458', '573293', '574706',
        '582091', '591522', '591536', '595473',
    }


class NitRemovers(ValueSet):
    VALUE_SET_NAME = 'Nit Removers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class ScabicideAndPediculicideCombinations(ValueSet):
    VALUE_SET_NAME = 'Scabicide and Pediculicide Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153688', '170370', '219559', '226330', '226330', '226330', '226330', '226330', '285732', '400469', '400470',
        '441986', '441988', '441990', '447541', '450613', '451747', '452291', '466232', '470957', '470958', '471574',
        '546031', '546897', '546930', '546930', '546930', '546930', '546930', '560500', '567458', '567458', '567473',
        '567473', '574706',
    }


class DermatologicalSunscreens(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Sunscreens'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '186693', '219905', '442028', '446505', '451876', '452484', '454030', '476191', '476213', '476234', '476246',
        '562034', '562044', '562069', '562090', '563129', '563136', '563142', '563143', '575138', '577276', '577341',
        '579050', '579085', '579193', '579198', '587054', '587149',
    }


class WoundCareTherapy(ValueSet):
    VALUE_SET_NAME = 'Wound Care Therapy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154274', '156823', '159167', '159833', '160206', '163508', '173447', '178304', '181785', '183021', '187557',
        '189518', '189600', '189960', '191219', '193721', '196735', '200489', '200489', '208201', '208691', '209588',
        '211946', '212204', '213284', '220556', '220727', '223155', '223919', '225915', '226463', '227559', '228796',
        '228796', '228997', '231273', '236510', '239816', '239816', '245423', '246222', '249733', '249981', '254354',
        '256741', '260104', '260289', '261892', '263158', '265424', '267835', '274333', '275470', '275470', '280691',
        '285995', '285995', '285995', '287259', '287752', '290034', '291061', '291458', '293094', '293094', '294508',
        '298597', '298597', '299771', '299771', '400942', '442075', '442075', '442092', '442135', '442140', '442141',
        '442142', '442147', '442154', '442155', '442156', '442157', '442158', '443701', '443701', '443702', '443703',
        '443703', '443704', '443704', '443707', '443710', '443710', '443710', '443710', '443710', '443710', '443710',
        '443710', '443710', '443710', '443710', '443710', '443710', '443710', '443710', '443711', '443713', '443713',
        '443713', '443713', '443713', '443713', '443713', '443716', '443721', '443722', '443724', '443724', '443724',
        '443724', '443724', '443724', '443724', '443726', '443726', '443728', '443728', '443729', '443729', '443735',
        '443739', '443739', '443741', '443742', '443742', '443742', '443743', '443743', '443750', '443750', '443751',
        '443752', '443752', '443752', '443752', '443752', '443754', '443756', '443757', '443757', '443757', '443757',
        '443758', '443759', '443760', '443761', '443762', '443763', '443764', '443765', '443765', '443766', '443768',
        '443769', '443769', '443769', '443769', '443770', '443770', '443771', '443771', '443772', '443773', '443773',
        '443773', '443800', '443801', '443802', '443915', '444295', '444295', '444296', '444297', '444299', '444302',
        '444304', '444306', '444307', '444308', '444309', '444310', '444313', '444314', '444317', '444318', '444320',
        '444324', '444324', '444325', '444353', '444356', '444360', '444367', '444790', '444790', '444792', '444794',
        '444795', '444797', '444804', '444832', '444840', '444840', '444840', '444840', '444840', '444842', '444843',
        '444843', '444843', '444843', '444845', '444845', '444845', '444846', '444846', '444846', '444847', '444847',
        '444847', '444847', '444848', '444848', '444849', '444851', '444851', '444854', '444855', '444855', '444856',
        '444858', '444859', '444860', '444864', '445001', '445022', '445024', '445028', '445086', '445093', '445094',
        '445095', '445195', '445195', '445205', '445840', '445841', '445842', '446121', '446141', '446386', '446387',
        '446626', '446626', '446631', '446632', '446633', '446634', '446683', '446683', '446985', '446987', '446988',
        '446989', '446990', '446992', '447144', '447145', '447146', '447275', '447320', '447320', '447321', '447321',
        '447321', '447322', '447322', '447322', '447323', '447324', '447324', '447325', '447325', '447357', '447358',
        '447359', '447360', '447361', '447697', '447698', '447780', '447781', '447782', '447847', '447847', '447848',
        '447848', '447907', '447910', '447914', '448344', '448346', '448348', '448971', '450423', '450424', '451163',
        '451202', '451500', '451501', '451502', '451503', '451504', '454323', '454391', '454391', '454392', '454392',
        '454394', '454396', '454397', '464234', '464235', '464236', '464237', '464252', '464440', '464441', '464442',
        '464443', '464747', '464747', '464990', '465454', '465454', '465713', '467392', '467422', '467423', '467432',
        '467470', '467563', '467564', '467599', '467610', '467611', '467646', '467648', '467693', '467694', '467695',
        '467700', '467706', '467707', '467708', '467715', '467715', '468162', '468320', '468334', '468335', '468340',
        '468341', '469608', '469725', '469780', '469781', '470614', '470615', '470634', '470634', '470634', '470634',
        '470634', '470635', '470635', '470636', '470636', '470636', '470638', '470645', '470646', '470646', '470646',
        '470647', '470648', '470704', '470844', '471008', '471114', '471115', '471118', '471119', '471217', '471218',
        '471451', '471551', '471552', '471562', '471564', '471565', '471566', '471903', '471904', '471905', '472500',
        '472501', '472503', '473207', '473220', '473830', '473840', '473973', '474115', '474116', '474117', '475513',
        '475519', '475521', '475523', '475869', '475870', '476425', '476425', '476428', '476428', '476429', '476430',
        '476556', '476558', '476559', '476560', '476583', '476584', '545302', '545473', '545474', '545476', '545477',
        '545482', '545483', '545484', '545485', '545571', '547310', '547369', '548113', '548117', '548118', '548207',
        '548569', '548574', '548574', '548576', '548576', '548577', '548909', '548910', '548911', '548912', '548912',
        '548913', '548913', '548914', '548920', '548921', '548923', '548924', '548932', '548933', '548935', '548936',
        '548939', '548940', '548941', '548942', '548943', '549218', '549218', '550638', '550643', '551180', '551215',
        '551216', '551260', '551261', '551262', '551263', '551269', '551270', '551272', '551277', '551278', '551375',
        '551376', '551426', '551433', '551435', '551436', '551437', '551438', '551439', '551449', '551506', '551995',
        '551996', '552123', '553344', '553396', '553968', '553974', '554459', '554976', '554981', '555177', '555371',
        '555372', '555385', '555386', '555388', '555427', '555732', '555782', '555802', '558457', '558479', '559572',
        '559572', '559573', '559573', '559574', '559575', '559576', '559577', '559577', '559578', '559579', '559580',
        '559580', '559621', '559621', '559622', '559622', '559633', '559633', '559634', '559634', '559660', '559661',
        '559662', '559695', '559696', '559903', '559922', '559945', '559945', '559956', '559956', '561355', '561898',
        '562002', '562003', '562004', '562022', '562024', '562025', '562060', '562111', '562140', '562154', '562156',
        '562157', '562166', '562203', '562475', '562615', '562616', '562617', '562618', '562651', '562652', '562653',
        '562654', '562677', '562803', '562804', '562806', '562830', '562857', '562905', '562982', '563096', '563096',
        '563204', '563205', '563207', '563510', '563511', '563512', '563536', '563550', '563578', '563603', '563608',
        '563622', '563625', '563626', '563632', '563651', '563653', '563654', '563704', '563724', '569217', '569233',
        '569828', '569870', '569908', '569909', '569910', '569954', '570689', '570690', '570762', '570764', '570765',
        '570902', '570903', '570904', '570912', '570913', '570926', '570927', '571153', '571158', '573220', '573221',
        '573222', '573229', '573230', '573231', '573289', '573297', '575983', '576028', '576235', '576236', '576239',
        '576240', '576271', '576271', '576272', '576272', '576304', '576304', '576305', '576305', '576455', '576455',
        '576532', '576532', '576631', '576661', '576662', '576674', '576682', '576685', '576704', '576952', '576954',
        '577383', '577418', '577419', '577468', '577469', '577843', '577860', '577860', '577861', '577861', '577862',
        '577863', '577866', '577866', '577867', '577954', '577974', '577974', '577974', '577977', '577978', '577979',
        '577980', '577981', '577995', '577995', '577995', '578633', '578709', '578710', '578711', '578712', '578713',
        '578947', '578948', '578958', '578959', '579051', '579076', '579396', '579396', '579416', '579416', '579418',
        '579418', '579419', '579420', '579457', '579458', '579461', '580692', '580752', '580753', '580754', '580754',
        '580769', '580792', '580793', '580941', '580941', '580955', '580955', '581017', '581046', '581095', '581096',
        '581097', '581098', '581099', '581100', '581102', '581103', '581105', '581106', '581136', '581138', '581139',
        '581146', '581155', '581156', '581157', '581158', '581161', '581166', '581197', '581200', '581201', '581203',
        '581205', '581294', '581301', '581302', '581303', '581344', '581345', '581346', '581347', '581428', '581429',
        '581457', '581458', '581470', '581471', '581494', '581495', '581496', '581497', '581589', '581601', '581606',
        '581614', '581615', '581666', '581832', '581838', '581839', '581840', '581858', '581859', '581860', '581869',
        '581870', '581905', '581907', '581908', '581910', '581911', '581912', '581913', '581945', '581971', '581972',
        '581973', '582052', '582052', '582052', '582052', '582061', '582061', '582061', '582061', '582062', '582064',
        '582065', '582066', '582146', '582147', '582148', '582149', '582153', '582157', '582208', '582209', '582213',
        '582214', '582216', '582217', '582347', '582465', '582492', '582701', '582820', '582837', '582849', '582854',
        '582854', '582856', '582856', '582866', '582866', '582868', '582883', '582884', '582885', '582889', '582896',
        '582931', '582932', '582933', '582934', '582943', '582944', '582961', '582962', '582963', '582969', '582970',
        '582987', '582988', '582989', '582990', '583002', '583012', '583013', '583019', '583024', '583554', '583555',
        '583557', '583559', '583561', '583609', '583610', '583611', '583615', '583959', '583960', '584120', '584121',
        '584122', '584123', '584126', '584127', '584148', '584149', '584161', '584162', '584163', '584165', '584174',
        '584197', '584198', '584199', '584234', '584235', '584236', '584237', '584241', '584242', '584243', '584618',
        '584619', '584790', '585218', '585220', '585221', '585222', '585339', '585339', '585374', '585386', '585386',
        '585387', '585561', '585562', '585563', '585645', '585653', '585654', '585655', '585660', '585661', '585662',
        '585664', '585669', '585670', '585671', '586185', '586205', '586211', '586491', '586492', '586493', '586603',
        '586647', '586681', '586753', '586761', '586829', '586834', '586835', '586836', '586837', '586885', '586886',
        '586887', '586888', '586889', '586939', '587083', '587085', '587134', '587430', '587502', '587858', '587881',
        '587958', '588057', '588058', '588059', '588080', '588093', '588094', '588385', '588386', '588410', '588411',
        '588466', '588468', '588677', '588679', '588789', '588834', '588835', '588858', '588859', '589109', '589150',
        '589151', '589167', '589214', '589217', '590257', '590258', '590259', '590260', '590566', '590567', '590584',
        '590585', '591026', '591027', '591523', '591964', '592093', '592225', '592321', '592354', '592572', '592578',
        '592891', '592891', '593580', '593580', '593580', '593582', '593582', '593582', '593605', '593605', '593605',
        '593606', '593606', '593606', '594273', '594670', '594696', '595042', '595042', '595118',
    }


class WoundCareCleansers(ValueSet):
    VALUE_SET_NAME = 'Wound Care - Cleansers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '267835', '275470', '275470', '400942', '443800', '443915', '561898', '562475', '569217', '569233', '582052',
        '582052', '582052', '582052', '582061', '582061', '582061', '582061', '586761', '590567', '590584',
    }


class WoundCareDressings(ValueSet):
    VALUE_SET_NAME = 'Wound Care - Dressings'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154274', '156823', '159167', '159833', '160206', '163508', '173447', '178304', '181785', '183021', '187557',
        '189518', '189600', '191219', '193721', '196735', '200489', '200489', '208691', '209588', '211946', '212204',
        '213284', '220556', '220727', '223155', '223919', '225915', '226463', '227559', '228796', '228796', '228997',
        '231273', '236510', '239816', '239816', '245423', '249733', '249981', '254354', '256741', '260104', '260289',
        '261892', '263158', '265424', '280691', '285995', '285995', '285995', '287259', '287752', '290034', '291061',
        '291458', '293094', '293094', '294508', '298597', '298597', '299771', '299771', '442075', '442075', '442092',
        '442135', '442140', '442141', '442142', '442147', '442154', '442155', '442156', '442157', '442158', '443701',
        '443701', '443702', '443703', '443703', '443704', '443704', '443707', '443710', '443710', '443710', '443710',
        '443710', '443710', '443710', '443710', '443710', '443710', '443710', '443710', '443710', '443710', '443710',
        '443711', '443713', '443713', '443713', '443713', '443713', '443713', '443713', '443716', '443721', '443722',
        '443724', '443724', '443724', '443724', '443724', '443724', '443724', '443726', '443726', '443728', '443728',
        '443729', '443729', '443735', '443739', '443739', '443741', '443742', '443742', '443742', '443743', '443743',
        '443750', '443750', '443751', '443752', '443752', '443752', '443752', '443752', '443754', '443756', '443757',
        '443757', '443757', '443757', '443758', '443759', '443760', '443761', '443762', '443763', '443764', '443765',
        '443765', '443766', '443768', '443769', '443769', '443769', '443769', '443770', '443770', '443771', '443771',
        '443772', '443773', '443773', '443773', '443801', '443802', '444295', '444295', '444296', '444297', '444299',
        '444302', '444304', '444306', '444307', '444308', '444309', '444310', '444313', '444314', '444317', '444318',
        '444320', '444324', '444324', '444325', '444353', '444356', '444360', '444367', '444790', '444790', '444792',
        '444794', '444795', '444797', '444804', '444832', '444840', '444840', '444840', '444840', '444840', '444842',
        '444843', '444843', '444843', '444843', '444845', '444845', '444845', '444846', '444846', '444846', '444847',
        '444847', '444847', '444847', '444848', '444848', '444849', '444851', '444851', '444854', '444855', '444855',
        '444856', '444858', '444859', '444860', '444864', '445001', '445022', '445024', '445028', '445086', '445093',
        '445094', '445095', '445195', '445195', '445205', '445840', '445841', '445842', '446121', '446141', '446386',
        '446387', '446631', '446632', '446633', '446634', '446985', '446987', '446988', '446989', '446990', '446992',
        '447144', '447145', '447146', '447275', '447320', '447320', '447321', '447321', '447321', '447322', '447322',
        '447322', '447323', '447324', '447324', '447325', '447325', '447357', '447358', '447359', '447360', '447361',
        '447697', '447698', '447780', '447781', '447782', '447847', '447847', '447848', '447848', '447907', '447910',
        '447914', '448344', '448346', '448348', '448971', '450423', '450424', '451500', '451501', '451502', '451503',
        '451504', '454323', '454391', '454391', '454392', '454392', '454394', '454396', '454397', '464234', '464235',
        '464236', '464237', '464252', '464440', '464441', '464442', '464443', '464747', '464747', '464990', '465454',
        '465454', '465713', '467392', '467422', '467423', '467432', '467470', '467563', '467564', '467599', '467610',
        '467611', '467646', '467648', '467693', '467694', '467695', '467700', '467706', '467707', '467708', '467715',
        '467715', '468162', '468320', '468334', '468335', '468340', '468341', '469608', '469725', '469780', '469781',
        '470614', '470615', '470634', '470634', '470634', '470634', '470634', '470635', '470635', '470636', '470636',
        '470636', '470638', '470645', '470646', '470646', '470646', '470647', '470648', '470704', '470844', '471008',
        '471114', '471115', '471118', '471119', '471217', '471218', '471451', '471551', '471552', '471562', '471564',
        '471565', '471566', '471903', '471904', '471905', '472500', '472501', '472503', '473207', '473220', '473830',
        '473840', '473973', '474115', '474116', '474117', '475513', '475519', '475521', '475523', '475869', '475870',
        '476583', '476584', '545302', '545473', '545474', '545476', '545477', '545482', '545483', '545484', '545485',
        '545571', '547310', '547369', '548113', '548117', '548118', '548207', '548569', '548574', '548574', '548576',
        '548576', '548577', '548909', '548910', '548911', '548912', '548912', '548913', '548913', '548914', '548920',
        '548921', '548923', '548924', '548932', '548933', '548935', '548936', '548939', '548940', '548941', '548942',
        '548943', '549218', '549218', '550638', '550643', '551180', '551215', '551216', '551260', '551261', '551262',
        '551263', '551269', '551270', '551272', '551277', '551278', '551375', '551376', '551426', '551433', '551435',
        '551436', '551437', '551438', '551439', '551449', '551506', '551995', '551996', '552123', '553344', '553396',
        '553968', '553974', '554459', '554976', '554981', '555177', '555371', '555372', '555385', '555386', '555388',
        '555427', '555732', '558457', '558479', '559903', '559922', '561355', '562002', '562003', '562004', '562022',
        '562024', '562025', '562060', '562111', '562154', '562156', '562157', '562166', '562203', '562615', '562616',
        '562617', '562618', '562651', '562652', '562653', '562654', '562677', '562803', '562804', '562806', '562830',
        '562857', '562905', '562982', '563096', '563096', '563204', '563205', '563207', '563510', '563511', '563512',
        '563536', '563550', '563578', '563603', '563608', '563622', '563625', '563626', '563632', '563651', '563653',
        '563654', '563704', '563724', '569908', '569909', '569910', '569954', '570689', '570690', '570762', '570764',
        '570765', '571153', '571158', '573220', '573221', '573222', '573229', '573230', '573231', '573289', '573297',
        '576235', '576236', '576239', '576240', '576271', '576271', '576272', '576272', '576304', '576304', '576305',
        '576305', '576455', '576455', '576532', '576532', '576631', '576661', '576662', '576674', '576682', '576685',
        '576704', '576952', '576954', '577383', '577418', '577419', '577468', '577469', '577843', '577954', '577974',
        '577974', '577974', '577995', '577995', '577995', '578633', '578709', '578710', '578711', '578712', '578713',
        '578947', '578948', '578958', '578959', '579396', '579396', '579416', '579416', '579418', '579418', '579419',
        '579420', '579457', '579458', '579461', '580692', '580752', '580753', '580754', '580754', '580769', '580792',
        '580793', '580941', '580941', '580955', '580955', '581017', '581095', '581096', '581097', '581098', '581099',
        '581100', '581102', '581103', '581105', '581106', '581136', '581138', '581139', '581146', '581155', '581156',
        '581157', '581158', '581161', '581166', '581197', '581200', '581201', '581203', '581294', '581301', '581302',
        '581303', '581344', '581345', '581346', '581347', '581428', '581429', '581589', '581601', '581606', '581666',
        '581832', '581838', '581839', '581840', '581858', '581859', '581860', '581905', '581907', '581908', '581910',
        '581911', '581912', '581913', '581945', '581971', '581972', '581973', '582062', '582064', '582065', '582066',
        '582146', '582147', '582148', '582149', '582153', '582157', '582347', '582465', '582492', '582701', '582820',
        '582837', '582849', '582883', '582884', '582885', '582889', '582896', '582931', '582932', '582933', '582934',
        '582943', '582944', '582961', '582962', '582963', '582969', '582970', '582987', '582988', '582989', '582990',
        '583002', '583012', '583013', '583019', '583024', '583554', '583555', '583557', '583559', '583561', '583959',
        '583960', '584120', '584121', '584122', '584123', '584126', '584127', '584148', '584149', '584161', '584162',
        '584163', '584165', '584174', '584197', '584198', '584199', '584234', '584235', '584236', '584237', '584241',
        '584242', '584243', '584618', '584619', '584790', '585218', '585220', '585221', '585222', '585339', '585339',
        '585374', '585386', '585386', '585387', '585561', '585562', '585563', '585645', '585653', '585654', '585655',
        '585660', '585661', '585662', '585664', '585669', '585670', '585671', '586185', '586205', '586211', '586491',
        '586492', '586493', '586753', '586829', '586834', '586835', '586836', '586837', '586885', '586886', '586887',
        '586888', '586889', '586939', '587083', '587085', '587134', '587430', '587502', '587881', '588057', '588058',
        '588059', '588080', '588093', '588094', '589109', '589150', '589151', '589167', '589214', '589217', '590257',
        '590258', '590259', '590260', '592093', '592321', '592354', '592891', '592891', '594670', '594696',
    }


class WoundCareGrowthFactorAgents(ValueSet):
    VALUE_SET_NAME = 'Wound Care - Growth Factor Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '246222', '274333',
    }


class WoundCareThrombolyticAgents(ValueSet):
    VALUE_SET_NAME = 'Wound Care - Thrombolytic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MedicalSuppliesAndDmeSurgicalAdhesives(ValueSet):
    VALUE_SET_NAME = 'Medical Supplies and DME - Surgical Adhesives'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '254642', '465855', '546684', '546687', '546688', '575139', '575156',
    }


class DermatologicalPoisonIvyProducts(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Poison Ivy Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DermatologicalVasoprotectantsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Vasoprotectants and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DermatologicalVasoprotectantCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Vasoprotectant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DermatologicalMiscellaneous(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Miscellaneous'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165123', '165123', '176902', '176902', '176979', '203152', '203152', '227185', '227185', '239412', '241940',
        '241940', '241940', '247478', '400203', '400203', '449386', '451904', '451921', '452030', '452392', '454050',
        '465070', '466017', '467149', '467149', '467292', '473899', '473903', '476435', '476435', '476458', '476458',
        '561205', '561215', '564350', '564352', '593897', '594009',
    }


class DermatologicalAstringents(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Astringents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '185685', '185937', '185937', '196577', '285581', '285581', '285581', '449761', '450737', '552753', '552753',
        '564733',
    }


class DermatologicalSoapAndCleanserSingleAgents(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Soap and Cleanser Single Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '212059', '212059', '212059', '212059',
    }


class DermatologicalProtectantsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Protectants and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '152163', '153466', '154014', '161752', '161752', '161752', '161752', '161752', '161752', '162436', '162436',
        '162436', '162436', '162436', '163915', '164750', '174355', '178453', '179266', '179266', '190471', '195092',
        '197455', '197455', '197455', '197699', '205681', '206718', '206718', '206718', '206718', '213418', '243496',
        '244567', '244567', '244567', '244567', '244567', '244567', '244567', '246970', '246970', '246970', '246970',
        '246970', '252429', '254552', '254552', '254552', '256116', '267113', '267519', '267519', '269358', '269843',
        '269843', '269843', '269843', '269843', '278090', '280249', '280249', '285968', '291673', '291673', '291673',
        '291673', '291673', '291673', '291673', '291673', '291673', '292165', '295538', '295538', '295856', '295856',
        '298250', '298937', '299872', '400412', '400515', '400515', '400515', '400515', '400539', '401027', '401067',
        '441676', '442319', '442319', '442319', '442319', '442319', '442353', '442361', '446083', '446762', '446762',
        '446762', '446763', '446769', '446769', '447547', '448018', '448018', '448018', '448314', '448544', '448545',
        '448545', '448545', '448869', '448874', '449684', '449684', '450096', '450116', '450116', '450116', '451819',
        '452034', '452034', '452034', '452034', '452034', '452054', '452127', '452139', '452379', '452614', '452739',
        '452740', '452740', '453734', '453839', '453839', '453839', '453843', '453843', '453843', '464306', '464306',
        '464306', '464306', '464306', '464695', '466262', '466275', '466419', '466419', '466673', '466861', '467649',
        '467682', '467682', '467714', '467714', '467727', '467727', '467847', '467885', '467925', '467943', '468430',
        '468430', '468436', '468436', '470672', '470685', '470996', '471006', '471395', '471453', '471481', '471481',
        '471482', '472009', '472009', '472009', '472009', '472020', '472020', '472020', '472020', '472412', '472412',
        '472412', '473900', '473900', '473900', '473900', '473900', '474831', '474831', '474831', '474840', '474840',
        '474840', '475111', '475111', '475111', '475112', '475112', '475112', '475113', '475122', '475122', '475122',
        '475123', '475124', '475124', '475124', '475566', '475566', '475566', '475579', '475579', '475579', '475623',
        '475623', '475623', '475646', '475662', '475662', '475662', '476260', '476266', '476272', '476272', '476272',
        '476274', '476274', '476274', '516716', '516716', '545526', '545526', '545564', '545564', '545997', '547876',
        '547876', '547975', '547975', '550498', '550498', '550889', '551113', '551113', '551113', '551113', '551113',
        '551162', '551162', '551162', '551163', '551163', '551163', '551167', '551167', '551167', '551167', '551167',
        '552053', '552333', '552337', '552399', '552399', '552399', '552400', '552401', '552840', '552840', '552841',
        '552894', '552894', '552894', '552894', '552898', '552898', '552898', '552898', '552899', '554174', '554203',
        '554746', '554753', '554959', '554959', '554991', '554991', '555058', '555095', '555095', '555108', '555108',
        '555590', '555989', '556001', '556615', '556619', '556619', '556623', '557714', '557714', '557828', '557846',
        '557881', '557881', '558083', '558090', '558090', '558107', '558107', '558116', '558122', '558174', '558174',
        '558319', '558319', '558330', '558331', '558331', '558333', '558376', '558690', '558758', '559016', '559021',
        '559148', '559165', '559397', '559397', '559888', '559888', '559888', '559912', '560016', '560016', '560016',
        '560266', '560276', '560276', '560276', '560279', '560289', '560447', '560484', '560484', '560484', '560484',
        '560493', '560493', '560493', '560493', '560494', '560501', '560505', '560505', '560505', '560641', '560641',
        '560641', '560690', '560690', '560734', '560734', '560771', '560781', '560837', '560889', '560889', '560933',
        '560933', '560933', '560933', '560975', '560975', '560975', '561180', '561185', '561194', '561649', '561654',
        '562136', '562449', '562459', '562474', '563127', '563127', '563132', '563132', '563822', '564308', '564308',
        '564325', '564340', '565817', '567509', '567560', '570219', '571691', '571851', '571851', '572076', '572076',
        '572079', '572186', '572197', '572244', '572286', '572286', '572315', '573461', '573463', '573831', '573988',
        '573988', '573988', '573988', '574051', '574051', '574063', '574081', '574226', '574226', '574642', '574643',
        '574737', '575578', '575596', '576027', '576027', '576047', '576047', '576052', '576052', '576052', '576133',
        '576137', '576137', '576137', '576734', '576741', '576742', '576948', '576959', '577283', '577283', '577340',
        '577340', '578014', '578045', '578594', '578596', '578631', '578732', '578822', '578822', '579273', '579346',
        '579384', '579391', '579643', '579649', '580102', '580108', '580202', '580207', '580236', '580236', '580236',
        '580255', '580255', '580255', '580383', '580383', '580392', '580392', '580582', '580585', '580586', '580983',
        '580983', '581312', '581332', '581349', '581349', '581425', '581426', '581427', '581987', '582016', '582279',
        '582286', '582302', '582415', '582417', '582431', '582475', '582521', '582703', '582707', '582803', '583053',
        '583389', '583558', '583608', '584411', '584411', '584757', '585201', '585290', '585290', '585382', '585382',
        '586097', '586097', '586239', '586253', '586275', '586943', '586976', '587023', '587197', '587936', '588316',
        '588316', '588330', '588330', '588383', '591073', '591110', '591326', '592549', '592613', '592991', '593204',
        '593778', '593778', '593782', '593782', '594361', '594384', '595095', '595143', '595476',
    }


class DermatologicalSoapAndOrCleanserCombinations(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Soap and/or Cleanser Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153294', '165332', '174676', '174676', '174676', '182020', '194911', '201290', '221606', '221606', '221606',
        '234700', '234700', '241430', '249774', '260656', '260656', '269128', '276749', '280550', '299091', '299091',
        '299091', '299907', '299907', '440948', '442241', '443839', '443919', '443919', '443919', '443919', '443919',
        '443919', '443919', '443919', '443919', '443919', '443922', '443924', '443927', '443927', '447800', '447800',
        '451835', '451835', '451835', '451835', '452383', '452383', '452622', '452659', '452659', '452659', '452928',
        '452928', '453099', '453100', '453100', '453100', '454143', '464996', '465417', '466031', '466113', '466113',
        '466718', '466718', '466718', '469462', '472981', '474971', '475628', '475628', '475629', '475629', '475716',
        '545513', '546167', '551077', '552507', '555425', '555431', '555589', '555971', '555997', '556242', '562472',
        '562480', '563450', '563465', '563607', '563607', '563609', '563609', '563623', '563623', '563689', '563723',
        '564318', '564318', '564343', '564343', '566555', '566562', '571916', '571934', '573558', '574046', '574053',
        '576196', '576196', '576252', '576252', '580316', '580316', '580345', '586495', '586495', '591005', '594178',
    }


class DermatologicalShampoos(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Shampoos'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '170849', '175911', '285399', '285399', '442305', '442305', '444822', '444822', '444822', '444822', '475630',
        '475630', '561726',
    }


class DermatologicalPowders(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Powders'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '177463', '229071', '229071', '453054', '453067', '453067',
    }


class DermatologicalSkinOils(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Skin Oils'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DermatologicalLubricants(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Lubricants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165205', '165205', '170969', '170969', '170969', '181913', '181913', '181913', '181913', '181913', '232524',
        '255265', '255265', '274818', '274818', '274818', '288901', '292832', '292832', '442335', '442335', '442335',
        '442344', '442344', '442344', '442344', '442344', '446190', '446190', '446190', '446793', '446793', '452311',
        '452311', '452311', '452311', '452311', '465462', '465462', '465462', '465462', '465462', '561377', '573286',
        '577233', '578370', '586189', '586209', '593021',
    }


class DermatologicalEyelidCleansers(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Eyelid Cleansers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '182162', '298919', '551458', '551519', '561453', '571048', '571345', '571418', '572225', '572247', '573227',
        '573234', '576992', '577034', '577045', '577045', '577126', '580194', '580195', '580323', '584584', '584584',
        '584584', '584687', '584687', '585181', '585383', '585541', '585543', '586236', '586236', '586236', '586858',
        '586919', '588700', '588723',
    }


class DermatologicalPodiatricProducts(ValueSet):
    VALUE_SET_NAME = 'Dermatological - Podiatric Products'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntisepticsAndDisinfectants(ValueSet):
    VALUE_SET_NAME = 'Antiseptics and Disinfectants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151089', '151641', '153045', '155041', '158381', '158554', '158554', '158554', '159370', '160639', '160639',
        '160639', '160639', '160639', '161327', '161327', '164690', '164690', '164690', '165945', '165945', '165945',
        '165945', '175226', '175226', '175226', '175226', '175226', '175226', '179395', '179395', '180110', '184560',
        '184560', '188566', '188566', '188566', '204488', '208249', '211088', '211929', '216624', '216624', '216624',
        '226008', '226008', '227474', '229653', '232741', '232741', '232741', '232741', '234270', '237777', '237777',
        '237777', '237777', '237777', '238383', '238383', '240372', '240372', '242515', '245664', '250524', '250524',
        '257610', '257610', '257610', '261969', '261969', '261969', '262778', '263504', '267922', '267922', '267922',
        '269064', '269064', '269454', '269454', '269798', '269798', '269798', '277210', '277324', '281138', '282597',
        '282597', '290519', '290519', '290519', '290519', '290519', '290519', '290823', '290823', '290823', '290823',
        '290823', '290823', '290823', '290823', '290823', '290823', '291553', '296056', '296056', '296056', '296056',
        '296056', '296056', '296435', '297090', '400451', '400451', '400451', '400701', '400701', '400731', '400732',
        '400943', '400943', '442216', '442216', '442219', '442219', '442219', '442363', '442367', '442367', '442378',
        '442397', '443977', '447502', '447502', '448858', '448858', '449777', '449777', '449777', '449777', '449777',
        '449777', '449859', '449859', '449859', '450276', '450767', '451712', '451826', '453741', '453741', '453863',
        '453863', '453874', '453874', '453886', '453887', '454288', '465221', '465222', '465222', '467252', '467403',
        '467450', '467632', '467632', '467632', '467638', '467638', '467657', '467657', '467731', '467731', '469582',
        '469582', '469661', '469661', '469875', '474485', '475671', '476433', '501624', '501624', '501624', '501624',
        '501624', '545676', '545704', '545824', '545824', '545824', '546447', '547178', '548955', '548955', '548955',
        '549276', '549335', '549347', '550768', '550772', '550862', '550862', '550862', '550862', '550862', '551101',
        '551101', '551101', '551101', '551101', '551101', '551155', '551155', '551155', '551758', '551799', '552180',
        '552449', '552639', '552646', '553132', '554111', '554111', '554168', '555056', '556173', '556176', '557865',
        '557865', '557865', '557865', '558168', '558183', '559481', '559481', '559492', '559492', '559687', '559730',
        '560431', '560431', '560442', '560442', '561152', '561673', '561673', '562072', '562297', '562297', '562297',
        '562298', '562580', '562582', '562590', '562591', '562591', '562591', '563722', '563722', '564358', '564358',
        '564358', '564358', '564358', '564406', '564406', '564406', '564406', '565328', '565328', '565328', '565328',
        '565385', '565570', '565570', '565571', '571129', '571129', '571129', '571129', '571797', '571875', '572299',
        '572300', '572642', '572695', '572695', '572750', '572750', '573187', '573187', '574317', '574317', '574317',
        '574526', '575675', '576038', '577081', '577387', '577429', '577490', '577490', '578396', '578444', '578799',
        '578799', '578799', '578836', '579008', '579044', '581478', '581529', '581532', '582203', '582203', '582355',
        '583270', '583270', '583270', '583270', '583332', '584940', '588678', '589237', '589237', '589239', '589239',
        '591193', '591507', '591512', '591635', '592092', '592092', '592538', '592562', '592590', '592590', '592590',
        '592590', '592590', '592914', '593129', '593148', '593205', '593239', '594064', '594064', '594064', '594064',
        '595586', '595586', '595586', '595734', '595883', '595895', '596045', '596074',
    }


class AntisepticChlorineReleasing(ValueSet):
    VALUE_SET_NAME = 'Antiseptic - Chlorine Releasing'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '291553', '400731', '400732', '442397', '451712', '546447', '547178', '550768', '550772', '560431', '560431',
        '560442', '560442', '562072', '564358', '564358', '564358', '564358', '564358', '564406', '564406', '564406',
        '564406', '572299', '572300', '575675', '582355', '584940', '588678', '591507', '591512', '595883', '595895',
        '596045', '596074',
    }


class AntisepticIodineIodophores(ValueSet):
    VALUE_SET_NAME = 'Antiseptic - Iodine/Iodophores'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155041', '179395', '179395', '269454', '269454', '281138', '282597', '282597', '400701', '400701', '443977',
        '447502', '447502', '449777', '449777', '449777', '449777', '449777', '449777', '449859', '449859', '449859',
        '476433', '548955', '548955', '548955', '550862', '550862', '550862', '550862', '550862', '556173', '589237',
        '589237', '589239', '589239',
    }


class AntisepticMercury(ValueSet):
    VALUE_SET_NAME = 'Antiseptic - Mercury'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153045', '277324',
    }


class DisinfectantsWaterPurifiers(ValueSet):
    VALUE_SET_NAME = 'Disinfectants - Water Purifiers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntisepticAndDisinfectantCombinations(ValueSet):
    VALUE_SET_NAME = 'Antiseptic and Disinfectant Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '204488', '211088',
    }


class AntidotesAndOtherReversalAgents(ValueSet):
    VALUE_SET_NAME = 'Antidotes and other Reversal Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '153060', '155728', '165692', '166448', '167272', '167272', '167402', '169775', '175311', '177792', '178677',
        '178839', '179664', '179664', '179865', '182394', '182745', '192258', '192339', '197902', '199983', '208286',
        '215502', '225623', '227089', '228124', '229089', '232243', '233721', '248565', '248565', '248565', '249702',
        '249756', '253752', '259939', '260905', '261966', '285809', '295103', '296785', '299363', '299363', '443493',
        '443499', '445691', '445692', '449738', '449738', '450909', '467984', '467994', '470991', '470991', '470992',
        '470992', '470993', '470994', '470994', '470995', '470995', '471010', '471012', '471012', '471013', '471013',
        '471016', '471016', '471017', '471017', '472446', '472447', '475709', '475710', '475711', '475729', '475730',
        '475731', '545166', '545168', '550582', '550802', '550827', '550835', '552433', '555089', '555110', '556008',
        '556039', '563634', '563639', '566316', '566681', '568481', '568638', '570137', '570142', '570146', '570147',
        '577053', '577062', '581264', '581586', '583665', '583666', '583666', '583828', '583829', '583829', '584891',
        '584892', '584893', '584896', '584897', '584898', '587962', '587965', '588517', '588530', '590233', '590384',
        '590659', '590660', '590664', '590666', '591282', '591323', '592146', '592504', '592949', '592949', '593332',
        '593611', '593611', '593731', '593732', '593733', '593736', '593737', '593738', '594529',
    }


class ChelatingAgents(ValueSet):
    VALUE_SET_NAME = 'Chelating Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '155728', '166448', '167402', '177792', '178677', '178839', '182745', '192339', '197902', '199983', '215502',
        '227089', '232243', '249756', '260905', '295103', '472446', '472447', '475709', '475710', '475711', '475729',
        '475730', '475731', '568481', '568638', '577053', '577062', '584891', '584892', '584893', '584896', '584897',
        '584898', '593731', '593732', '593733', '593736', '593737', '593738',
    }


class AntidoteTopical(ValueSet):
    VALUE_SET_NAME = 'Antidote - Topical'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class AntidoteKits(ValueSet):
    VALUE_SET_NAME = 'Antidote Kits'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DiagnosticAgents(ValueSet):
    VALUE_SET_NAME = 'Diagnostic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154099', '155727', '155727', '155727', '156198', '156198', '156198', '156198', '157365', '157634', '157634',
        '158280', '159213', '166187', '168236', '168236', '168236', '168236', '168236', '168236', '168236', '168236',
        '168474', '168474', '168474', '168474', '169815', '169815', '169815', '169815', '169815', '169815', '169815',
        '171246', '171562', '171562', '172471', '175028', '176063', '176063', '176063', '177471', '177471', '178038',
        '178038', '178038', '178038', '178038', '178038', '178038', '180484', '180484', '180484', '180484', '180484',
        '180484', '180484', '180484', '180883', '180883', '181025', '181142', '182627', '182627', '182842', '182842',
        '182842', '182842', '182842', '182842', '183369', '183450', '183450', '183450', '183450', '184007', '184007',
        '184252', '184408', '184443', '184443', '185533', '186845', '192134', '192987', '193451', '194421', '194421',
        '194421', '194421', '194421', '194421', '194689', '194689', '196283', '197908', '198886', '198886', '198886',
        '198886', '198886', '198886', '198886', '199918', '201642', '201659', '201659', '201659', '201659', '201659',
        '201714', '205381', '205381', '205381', '205381', '205381', '205381', '205381', '205381', '205381', '205508',
        '206035', '207962', '208112', '208663', '208663', '208663', '209885', '210419', '210761', '210761', '212736',
        '212736', '212736', '214686', '217380', '219372', '219990', '219990', '219990', '219990', '219990', '219990',
        '219990', '220900', '226890', '226890', '228254', '228254', '228254', '229364', '230727', '232698', '233739',
        '233739', '233739', '233739', '233739', '233739', '233739', '233739', '234900', '234900', '235012', '235051',
        '235102', '235102', '235102', '235102', '235275', '237052', '237052', '237052', '237052', '237052', '237052',
        '237052', '237634', '237634', '237634', '237634', '237634', '237634', '237634', '238190', '238190', '238190',
        '238190', '240027', '240759', '240759', '240759', '240759', '240759', '240759', '240894', '242705', '243016',
        '243075', '246122', '246944', '247325', '250956', '250956', '250956', '250956', '250956', '250956', '250956',
        '250956', '250956', '251113', '254220', '254864', '255353', '256711', '256711', '256941', '256941', '256941',
        '256941', '256941', '256941', '256941', '257109', '257258', '260948', '261852', '263442', '263793', '264539',
        '264539', '264539', '264539', '264539', '264539', '264539', '264759', '264759', '268416', '268416', '268829',
        '270556', '270556', '270556', '270556', '270556', '270569', '270612', '270612', '270612', '270612', '270612',
        '271590', '273298', '273298', '273298', '273298', '273298', '273298', '273298', '275522', '276655', '276655',
        '277326', '279621', '279621', '279621', '279621', '281847', '281847', '281847', '281847', '281847', '281847',
        '281847', '284902', '285798', '286312', '286312', '288506', '291651', '292321', '294053', '294922', '297568',
        '298740', '298740', '298740', '400633', '442490', '442550', '442553', '442553', '442559', '442563', '442583',
        '442588', '442622', '442622', '442622', '442627', '445639', '445639', '445687', '445687', '445687', '445687',
        '445695', '445698', '445698', '445698', '445698', '445698', '445882', '445882', '445908', '448273', '448451',
        '448455', '448455', '448456', '448456', '448456', '448456', '450312', '451219', '451219', '451219', '451219',
        '451219', '451245', '451245', '451245', '451245', '451245', '451246', '451246', '451246', '451246', '451246',
        '451246', '451284', '451437', '451576', '454232', '466471', '469649', '471594', '471595', '472453', '472454',
        '472455', '472456', '473159', '473160', '473161', '473162', '473167', '473168', '473169', '473170', '473215',
        '473216', '473217', '473218', '473219', '473276', '473277', '473278', '473279', '473280', '473292', '473298',
        '473355', '473355', '473355', '473355', '473355', '473355', '473355', '473355', '473356', '473356', '473356',
        '473356', '473356', '474470', '475041', '475041', '475125', '475140', '475142', '475972', '475972', '475973',
        '545548', '545548', '545548', '545548', '545548', '545548', '549652', '549652', '549823', '549823', '549823',
        '549823', '549824', '549824', '550323', '550435', '550436', '550436', '550484', '550529', '550529', '552262',
        '552262', '552778', '552778', '553271', '553292', '553298', '553299', '553478', '553844', '553884', '554087',
        '554095', '554257', '554257', '554291', '554291', '554571', '554702', '555150', '555157', '555253', '555254',
        '555255', '555257', '555258', '555294', '555295', '555296', '555297', '555316', '555317', '555318', '555319',
        '555320', '555321', '555322', '555323', '555324', '555325', '555514', '555515', '555516', '555518', '555522',
        '555530', '555531', '555536', '555537', '555538', '555539', '555540', '555541', '555767', '555767', '555779',
        '555779', '556014', '556014', '556028', '556028', '556138', '556179', '556484', '556541', '556546', '558357',
        '558368', '558633', '558634', '558638', '558639', '558640', '558683', '558830', '558839', '558851', '558868',
        '558917', '558919', '560167', '560180', '560324', '560345', '560924', '560967', '560992', '561195', '561440',
        '561440', '561678', '561711', '561862', '562007', '562019', '562462', '562482', '563067', '563075', '563150',
        '563153', '563588', '563589', '563590', '563591', '563778', '563778', '563779', '563780', '563781', '563783',
        '563784', '563785', '563790', '563791', '563792', '563793', '563793', '563794', '563795', '563796', '564152',
        '564155', '565543', '565562', '565912', '565965', '566018', '568857', '568912', '569353', '569370', '569453',
        '569483', '569490', '569495', '569522', '570090', '570091', '570134', '570135', '572751', '572762', '572993',
        '573077', '575589', '575590', '575590', '575591', '575616', '575685', '575707', '575949', '575955', '575991',
        '578604', '578604', '578604', '578605', '578605', '578605', '578605', '579124', '579124', '579124', '579124',
        '579139', '579139', '579139', '579139', '579154', '579631', '579631', '579631', '579631', '579644', '579644',
        '579644', '579901', '579907', '579982', '581222', '581229', '581422', '584136', '584153', '585245', '585261',
        '587031', '587097', '587455', '587478', '590806', '590813', '590849', '590895', '591463', '591685', '592101',
        '592105', '592133', '592134', '592149', '592155', '592329', '592348', '592353', '592386', '592397', '592573',
        '592580', '592618', '592643', '592670', '592680', '592826', '592828', '592831', '592833', '592836', '592841',
        '592976', '592980', '593359', '593670', '593670', '593671', '593671', '593856', '593856', '593856', '593866',
        '594426', '594460',
    }


class DiagnosticTestReagents(ValueSet):
    VALUE_SET_NAME = 'Diagnostic Test Reagents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154099', '155727', '155727', '155727', '157365', '158280', '166187', '168474', '168474', '168474', '168474',
        '171246', '172471', '182627', '182627', '183369', '186845', '192987', '193451', '220900', '229364', '235275',
        '246122', '247325', '251113', '254220', '257109', '261852', '263793', '264759', '264759', '270569', '275522',
        '277326', '286312', '286312', '442490', '442550', '442553', '442553', '442559', '442563', '442583', '445908',
        '448273', '450312', '451284', '454232', '469649', '472453', '472454', '472455', '472456', '553478', '554257',
        '554257', '554291', '554291', '554702', '556484', '558633', '558634', '558638', '558639', '558640', '558683',
        '560324', '560345', '561195', '561440', '561440', '568857', '568912', '575589', '575590', '575590', '575591',
        '575616', '575685', '575707', '575949', '575955', '575991', '579154', '585245', '585261', '593856', '593856',
        '593856', '593866',
    }


class DiagnosticInfectionTests(ValueSet):
    VALUE_SET_NAME = 'Diagnostic - Infection Tests'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '556484', '575589',
    }


class DiagnosticControlReagents(ValueSet):
    VALUE_SET_NAME = 'Diagnostic - Control Reagents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DiagnosticUrineTestCombinations(ValueSet):
    VALUE_SET_NAME = 'Diagnostic - Urine Test Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157365', '166187', '171246', '172471', '186845', '192987', '247325', '251113', '257109', '264759', '264759',
        '270569', '442559', '442563', '442583', '445908', '448273', '454232', '560324', '560345', '568857', '568912',
    }


class DiagnosticDrugsInVivo(ValueSet):
    VALUE_SET_NAME = 'Diagnostic Drugs - In Vivo'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '181142', '192134', '194689', '194689', '197908', '199918', '205508', '208112', '209885', '214686', '217380',
        '230727', '235012', '240894', '242705', '243075', '246944', '256711', '256711', '260948', '284902', '288506',
        '291651', '292321', '297568', '442588', '471594', '471595', '474470', '554571', '555150', '555157', '561678',
        '561711', '562007', '562019', '592573', '592580', '593359',
    }


class DiagnosticBiologicals(ValueSet):
    VALUE_SET_NAME = 'Diagnostic Biologicals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '157634', '157634', '184007', '184007', '184443', '184443', '572993', '573077',
    }


class DiagnosticSkinTests(ValueSet):
    VALUE_SET_NAME = 'Diagnostic Skin Tests'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '257258', '268829', '591685', '592101', '592105', '592133', '592134', '592149', '592155', '592329', '592348',
        '592353', '592386', '592397', '592618', '592643', '592670', '592680', '592826', '592828', '592831', '592833',
        '592836', '592841', '592976', '592980',
    }


class DiagnosticRadiopharmaceuticals(ValueSet):
    VALUE_SET_NAME = 'Diagnostic Radiopharmaceuticals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '196283', '243016', '553844', '553884', '558830', '560924', '560967', '560992', '562462', '562482', '563150',
        '563153', '564152', '564155', '565543', '565562', '565912', '565965', '569353', '569370', '569453', '569483',
        '569490', '569495', '569522', '570090', '570091', '570134', '570135', '572751', '572762', '579901', '579907',
        '579982', '584136', '584153', '587455', '587478', '590806', '590813', '590849', '590895', '591463',
    }


class DiagnosticRadiopharmaceuticalsEndocrine(ValueSet):
    VALUE_SET_NAME = 'Diagnostic Radiopharmaceuticals - Endocrine'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '553844', '553884', '569453', '569483', '579901', '579907',
    }


class DiagnosticRadiopharmaceuticalsProstatic(ValueSet):
    VALUE_SET_NAME = 'Diagnostic Radiopharmaceuticals - Prostatic'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '196283', '243016', '590849', '590895',
    }


class DiagnosticContrastMedia(ValueSet):
    VALUE_SET_NAME = 'Diagnostic - Contrast Media'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '156198', '156198', '156198', '156198', '159213', '168236', '168236', '168236', '168236', '168236', '168236',
        '168236', '168236', '169815', '169815', '169815', '169815', '169815', '169815', '169815', '171562', '171562',
        '175028', '176063', '176063', '176063', '177471', '177471', '178038', '178038', '178038', '178038', '178038',
        '178038', '178038', '180484', '180484', '180484', '180484', '180484', '180484', '180484', '180484', '180883',
        '180883', '181025', '182842', '182842', '182842', '182842', '182842', '182842', '183450', '183450', '183450',
        '183450', '184252', '184408', '185533', '194421', '194421', '194421', '194421', '194421', '194421', '198886',
        '198886', '198886', '198886', '198886', '198886', '198886', '201642', '201659', '201659', '201659', '201659',
        '201659', '201714', '205381', '205381', '205381', '205381', '205381', '205381', '205381', '205381', '205381',
        '206035', '207962', '208663', '208663', '208663', '210419', '210761', '210761', '212736', '212736', '212736',
        '219372', '219990', '219990', '219990', '219990', '219990', '219990', '219990', '226890', '226890', '228254',
        '228254', '228254', '232698', '233739', '233739', '233739', '233739', '233739', '233739', '233739', '233739',
        '234900', '234900', '235051', '235102', '235102', '235102', '235102', '237052', '237052', '237052', '237052',
        '237052', '237052', '237052', '237634', '237634', '237634', '237634', '237634', '237634', '237634', '238190',
        '238190', '238190', '238190', '240027', '240759', '240759', '240759', '240759', '240759', '240759', '250956',
        '250956', '250956', '250956', '250956', '250956', '250956', '250956', '250956', '254864', '255353', '256941',
        '256941', '256941', '256941', '256941', '256941', '256941', '263442', '264539', '264539', '264539', '264539',
        '264539', '264539', '264539', '268416', '268416', '270556', '270556', '270556', '270556', '270556', '270612',
        '270612', '270612', '270612', '270612', '271590', '273298', '273298', '273298', '273298', '273298', '273298',
        '273298', '276655', '276655', '279621', '279621', '279621', '279621', '281847', '281847', '281847', '281847',
        '281847', '281847', '281847', '285798', '294053', '294922', '298740', '298740', '298740', '400633', '442622',
        '442622', '442622', '442627', '445639', '445639', '445687', '445687', '445687', '445687', '445695', '445698',
        '445698', '445698', '445698', '445698', '445882', '445882', '448451', '448455', '448455', '448456', '448456',
        '448456', '448456', '451219', '451219', '451219', '451219', '451219', '451245', '451245', '451245', '451245',
        '451245', '451246', '451246', '451246', '451246', '451246', '451246', '451437', '451576', '466471', '473159',
        '473160', '473161', '473162', '473167', '473168', '473169', '473170', '473215', '473216', '473217', '473218',
        '473219', '473276', '473277', '473278', '473279', '473280', '473292', '473298', '473355', '473355', '473355',
        '473355', '473355', '473355', '473355', '473355', '473356', '473356', '473356', '473356', '473356', '475041',
        '475041', '475125', '475140', '475142', '475972', '475972', '475973', '545548', '545548', '545548', '545548',
        '545548', '545548', '549652', '549652', '549823', '549823', '549823', '549823', '549824', '549824', '550323',
        '550435', '550436', '550436', '550484', '550529', '550529', '552262', '552262', '552778', '552778', '553271',
        '553292', '553298', '553299', '554087', '554095', '555253', '555254', '555255', '555257', '555258', '555294',
        '555295', '555296', '555297', '555316', '555317', '555318', '555319', '555320', '555321', '555322', '555323',
        '555324', '555325', '555514', '555515', '555516', '555518', '555522', '555530', '555531', '555536', '555537',
        '555538', '555539', '555540', '555541', '555767', '555767', '555779', '555779', '556014', '556014', '556028',
        '556028', '556541', '556546', '558357', '558368', '558839', '558851', '558868', '558917', '558919', '560167',
        '560180', '561862', '563067', '563075', '563588', '563589', '563590', '563591', '563778', '563778', '563779',
        '563780', '563781', '563783', '563784', '563785', '563790', '563791', '563792', '563793', '563793', '563794',
        '563795', '563796', '566018', '578604', '578604', '578604', '578605', '578605', '578605', '578605', '579124',
        '579124', '579124', '579124', '579139', '579139', '579139', '579139', '579631', '579631', '579631', '579631',
        '579644', '579644', '579644', '581222', '581229', '581422', '587031', '587097', '593670', '593670', '593671',
        '593671', '594426', '594460',
    }


class ContrastMediaBarium(ValueSet):
    VALUE_SET_NAME = 'Contrast Media - Barium'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '400633', '466471', '473292', '473298', '475041', '475041', '475125', '475140', '475142', '550435', '550436',
        '550436', '550484', '550529', '550529', '552262', '552262', '552778', '552778', '553271', '553292', '553298',
        '553299', '554087', '554095', '555767', '555767', '555779', '555779', '558357', '558368', '558839', '558851',
        '558868', '558917', '558919', '560167', '560180', '563067', '563075', '566018', '594426', '594460',
    }


class ContrastMediaIodinated(ValueSet):
    VALUE_SET_NAME = 'Contrast Media - Iodinated'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159213', '168236', '168236', '168236', '168236', '168236', '168236', '168236', '168236', '169815', '169815',
        '169815', '169815', '169815', '169815', '169815', '171562', '171562', '175028', '176063', '176063', '176063',
        '177471', '177471', '178038', '178038', '178038', '178038', '178038', '178038', '178038', '180484', '180484',
        '180484', '180484', '180484', '180484', '180484', '180484', '180883', '180883', '182842', '182842', '182842',
        '182842', '182842', '182842', '183450', '183450', '183450', '183450', '184252', '184408', '185533', '194421',
        '194421', '194421', '194421', '194421', '194421', '198886', '198886', '198886', '198886', '198886', '198886',
        '198886', '201642', '201659', '201659', '201659', '201659', '201659', '201714', '205381', '205381', '205381',
        '205381', '205381', '205381', '205381', '205381', '205381', '207962', '208663', '208663', '208663', '210419',
        '210761', '210761', '212736', '212736', '212736', '219372', '219990', '219990', '219990', '219990', '219990',
        '219990', '219990', '228254', '228254', '228254', '232698', '233739', '233739', '233739', '233739', '233739',
        '233739', '233739', '233739', '234900', '234900', '235051', '235102', '235102', '235102', '235102', '237052',
        '237052', '237052', '237052', '237052', '237052', '237052', '237634', '237634', '237634', '237634', '237634',
        '237634', '237634', '238190', '238190', '238190', '238190', '240027', '240759', '240759', '240759', '240759',
        '240759', '240759', '250956', '250956', '250956', '250956', '250956', '250956', '250956', '250956', '250956',
        '254864', '255353', '256941', '256941', '256941', '256941', '256941', '256941', '256941', '263442', '264539',
        '264539', '264539', '264539', '264539', '264539', '264539', '268416', '268416', '270612', '270612', '270612',
        '270612', '270612', '271590', '273298', '273298', '273298', '273298', '273298', '273298', '273298', '276655',
        '276655', '279621', '279621', '279621', '279621', '281847', '281847', '281847', '281847', '281847', '281847',
        '281847', '285798', '294053', '294922', '298740', '298740', '298740', '442622', '442622', '442622', '442627',
        '445687', '445687', '445687', '445687', '445695', '445698', '445698', '445698', '445698', '445698', '448451',
        '448456', '448456', '448456', '448456', '451219', '451219', '451219', '451219', '451219', '451245', '451245',
        '451245', '451245', '451245', '451246', '451246', '451246', '451246', '451246', '451246', '473355', '473355',
        '473355', '473355', '473355', '473355', '473355', '473355', '473356', '473356', '473356', '473356', '473356',
        '475972', '475972', '475973', '549652', '549652', '561862', '579124', '579124', '579124', '579124', '579139',
        '579139', '579139', '579139', '581422', '593670', '593670', '593671', '593671',
    }


class ContrastMediaMagneticResonanceIronCompounds(ValueSet):
    VALUE_SET_NAME = 'Contrast Media - Magnetic Resonance Iron Compounds'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '451437', '451576',
    }


class ContrastMediaUltrasoundAgentsAndCombinations(ValueSet):
    VALUE_SET_NAME = 'Contrast Media - Ultrasound Agents and Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '181025', '206035', '556541', '556546', '587031', '587097',
    }


class ContrastMediaUltrasoundAgentCombinations(ValueSet):
    VALUE_SET_NAME = 'Contrast Media - Ultrasound Agent Combinations'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class DiagnosticOther(ValueSet):
    VALUE_SET_NAME = 'Diagnostic - Other'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '556138', '556179',
    }


class AlternativeTherapy(ValueSet):
    VALUE_SET_NAME = 'Alternative Therapy'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150564', '150782', '151306', '152604', '155890', '158803', '158900', '160991', '161321', '161741', '163218',
        '163546', '166918', '167105', '167573', '168505', '169303', '171427', '171453', '176770', '176978', '177278',
        '177751', '178847', '178933', '181171', '182768', '182803', '183088', '183088', '183088', '183088', '183088',
        '183088', '183328', '183627', '184169', '184948', '185159', '185519', '189179', '189817', '190521', '191779',
        '193012', '193152', '193588', '195302', '196713', '197114', '197284', '198329', '198676', '200117', '200139',
        '200898', '201601', '203155', '203935', '204734', '205271', '206320', '208346', '210801', '210993', '212860',
        '214360', '216892', '217789', '219064', '219307', '220216', '220342', '220598', '220821', '223917', '224667',
        '225298', '226269', '227911', '228007', '228507', '230401', '231203', '231360', '234353', '234742', '234822',
        '235615', '235822', '236141', '236276', '237086', '237677', '237677', '238280', '238303', '238416', '241878',
        '242451', '243241', '246069', '246339', '247299', '248359', '250224', '251000', '251076', '251833', '252009',
        '252710', '253283', '254420', '254732', '254987', '255034', '256203', '256669', '256679', '257529', '257549',
        '257933', '258254', '258887', '258925', '261374', '261704', '262734', '262758', '264869', '266138', '266914',
        '267757', '268035', '269806', '269943', '271474', '272297', '272355', '273125', '274175', '274259', '274478',
        '275192', '275551', '275762', '276951', '280073', '280372', '281820', '281840', '282725', '283409', '283776',
        '283964', '284203', '285186', '288002', '288997', '290788', '291528', '291551', '291685', '291889', '292253',
        '292376', '292902', '293199', '293260', '293459', '293899', '294138', '295187', '295264', '295554', '295966',
        '296485', '297466', '297912', '298888', '298891', '400010', '400018', '400218', '400567', '400915', '400924',
        '439486', '439506', '442646', '442647', '442654', '442655', '442658', '442659', '443746', '443747', '443796',
        '443843', '443844', '443849', '443992', '443992', '443993', '443997', '444803', '445232', '445232', '445851',
        '445885', '445887', '445898', '445904', '446001', '446197', '446198', '446225', '446226', '446275', '446291',
        '446662', '446684', '446732', '448212', '448269', '448342', '448596', '448642', '448844', '448856', '448868',
        '449774', '449775', '449939', '450115', '450115', '450180', '450285', '450288', '450941', '451222', '451289',
        '451303', '451334', '451398', '451636', '451672', '451673', '451675', '451681', '451908', '451940', '451959',
        '452058', '452074', '452106', '452108', '452131', '452303', '452309', '452331', '452400', '452462', '452610',
        '452642', '452697', '452841', '452849', '452853', '453464', '453465', '453589', '453601', '453608', '453609',
        '454051', '454108', '454135', '454269', '454271', '454420', '464553', '465306', '465373', '465393', '465435',
        '465445', '465591', '465818', '465829', '465829', '465848', '466025', '467336', '467342', '468097', '468317',
        '468354', '470936', '470942', '470983', '470984', '470998', '471004', '471049', '471285', '471591', '471592',
        '471788', '472460', '472689', '472690', '472692', '472693', '472699', '472703', '472712', '472720', '472721',
        '472722', '472723', '472725', '472727', '472731', '472732', '472746', '472758', '472782', '472785', '472809',
        '472817', '472835', '472854', '473016', '473042', '473043', '473248', '473249', '473250', '473256', '473264',
        '473275', '473275', '473284', '473284', '473287', '473319', '473455', '473467', '473576', '473579', '473689',
        '473719', '473747', '473753', '473828', '474173', '474211', '474229', '474267', '474283', '474373', '474634',
        '474681', '474681', '474759', '474909', '475137', '475238', '475238', '475238', '475327', '475342', '475464',
        '475465', '475620', '475622', '475658', '475676', '476203', '476207', '476261', '476327', '476413', '476415',
        '476462', '476489', '476730', '476758', '476760', '476763', '545630', '545630', '545630', '545631', '545631',
        '545631', '546443', '546471', '546511', '546587', '546655', '549954', '550002', '550087', '550188', '550193',
        '550234', '550268', '550276', '550322', '550441', '550552', '550567', '550584', '550610', '550914', '550914',
        '550919', '551166', '551170', '551460', '551498', '551522', '551537', '551589', '551591', '551633', '551634',
        '551698', '551715', '552812', '552834', '552842', '553036', '553036', '553038', '553090', '553091', '553091',
        '553181', '553205', '553463', '553479', '553497', '553567', '553574', '553668', '553681', '553698', '553821',
        '553914', '554255', '554687', '554829', '554851', '554862', '554877', '554882', '554901', '554953', '555109',
        '555298', '555598', '555599', '556162', '556163', '556207', '556222', '556237', '556502', '556582', '556926',
        '556965', '556990', '557016', '557025', '557027', '557141', '557152', '557155', '557501', '557501', '557851',
        '557882', '557882', '557923', '557971', '558251', '558347', '558347', '558395', '558405', '558406', '558419',
        '558420', '558477', '558699', '558791', '558806', '558850', '558899', '559126', '559136', '559169', '559213',
        '559216', '559454', '559461', '559462', '559479', '559503', '559734', '560026', '560098', '560103', '560217',
        '560248', '560367', '560531', '560547', '560632', '560722', '560735', '560930', '560946', '560959', '560961',
        '560969', '560972', '560973', '561068', '561289', '561313', '561384', '561464', '561477', '561549', '561555',
        '561657', '561658', '561697', '561704', '561736', '562290', '562305', '562535', '562539', '562730', '562766',
        '562775', '562809', '562869', '562901', '562937', '563033', '563082', '563092', '563103', '563121', '563186',
        '563209', '563210', '563231', '563237', '563254', '563291', '563316', '563334', '563381', '563557', '563631',
        '563692', '563697', '563786', '563824', '563867', '563965', '563977', '564013', '564016', '564070', '564072',
        '564094', '564099', '564171', '564203', '564241', '564259', '564263', '564367', '564391', '564393', '564394',
        '564455', '564507', '564508', '564513', '564525', '564536', '564537', '564538', '564544', '564567', '564570',
        '564589', '564595', '564625', '564631', '564680', '564683', '564695', '564697', '564719', '564734', '564793',
        '564982', '565071', '565103', '565118', '565130', '565191', '565531', '565709', '566522', '566832', '566836',
        '567104', '567146', '567159', '568058', '568061', '568132', '568237', '568305', '568375', '568706', '568745',
        '568823', '568974', '569461', '569669', '569669', '569726', '569760', '569774', '570325', '570354', '570393',
        '570395', '570592', '571025', '571212', '571216', '571245', '571247', '571288', '571290', '571295', '571353',
        '571354', '571355', '571408', '571432', '571530', '571876', '571885', '571920', '571937', '571938', '571951',
        '571955', '571958', '572022', '572039', '572040', '572080', '572088', '572111', '572133', '572151', '572167',
        '572223', '572282', '572306', '572340', '572586', '572614', '572648', '572716', '572749', '573005', '573249',
        '573326', '573422', '573462', '573563', '573838', '573841', '573864', '573935', '573937', '573968', '574554',
        '574595', '574989', '575118', '575189', '575212', '575231', '575244', '575277', '575282', '575296', '575325',
        '575436', '575437', '575449', '575472', '575530', '575690', '575760', '575796', '575799', '575820', '575967',
        '576070', '576077', '576093', '576115', '576131', '576146', '576156', '576174', '576328', '576329', '576352',
        '576385', '576396', '576407', '576445', '576454', '576477', '576482', '576512', '576513', '576521', '576550',
        '576559', '576572', '576730', '576733', '576746', '576751', '576823', '576857', '576868', '576895', '576962',
        '576994', '577014', '577046', '577072', '577248', '577501', '577518', '577531', '577554', '577593', '577593',
        '577610', '577628', '577642', '577652', '577827', '577918', '578001', '578036', '578103', '578376', '578439',
        '578443', '578470', '578766', '578777', '578838', '578925', '578926', '578950', '579060', '579145', '579152',
        '579180', '579181', '579229', '579326', '579339', '579344', '579455', '579489', '579492', '579635', '579635',
        '579668', '579677', '579686', '579688', '579689', '579690', '579691', '579693', '579709', '579720', '579724',
        '579728', '579729', '579730', '579734', '579751', '579763', '579987', '580088', '580103', '580110', '580178',
        '580219', '580223', '580229', '580235', '580245', '580247', '580248', '580256', '580265', '580294', '580317',
        '580329', '580338', '580340', '580346', '580347', '580351', '580357', '580370', '580396', '580401', '580459',
        '580519', '580879', '580965', '580966', '580982', '581013', '581058', '581065', '581094', '581142', '581165',
        '581171', '581315', '581543', '581557', '581579', '581581', '581820', '581850', '581852', '581863', '581877',
        '581884', '581887', '581891', '581916', '581923', '582124', '582187', '582225', '582226', '582243', '582280',
        '582374', '582581', '582588', '582705', '583096', '583134', '583170', '583235', '583355', '583387', '583500',
        '583501', '583502', '583540', '583562', '583563', '583564', '583602', '583676', '583702', '583745', '583754',
        '583771', '583786', '584150', '584846', '584846', '584867', '584867', '585831', '585848', '585851', '585869',
        '585876', '585983', '586122', '586542', '586570', '586627', '586678', '586708', '586725', '586773', '586789',
        '586987', '586992', '587017', '587060', '587485', '587521', '587534', '587576', '587578', '587716', '587838',
        '587917', '587957', '588267', '588303', '588308', '588318', '588344', '588346', '588390', '588399', '588578',
        '588578', '588580', '588586', '588590', '588612', '588620', '588620', '588639', '589026', '589087', '589106',
        '589122', '589179', '589180', '589187', '589221', '589313', '589492', '589505', '589529', '589566', '589568',
        '589645', '589890', '589973', '589999', '590019', '590084', '590202', '590215', '590245', '590357', '590423',
        '590878', '591050', '591391', '591411', '591429', '591511', '591530', '591545', '591556', '591884', '591899',
        '592228', '592264', '592336', '592663', '592692', '592692', '592717', '592717', '592782', '592883', '593019',
        '593080', '593228', '593234', '593255', '593272', '593311', '593316', '593317', '593351', '593356', '593378',
        '593381', '593423', '593483', '593542', '593563', '593568', '593569', '593709', '593753', '593760', '594111',
        '594180', '594222', '594263', '594366', '594374', '594490', '594512', '594520', '594524', '594564', '594592',
        '594593', '594610', '594660', '594897', '595123', '595208', '595328', '595405', '595450', '595608',
    }


class AlternativeTherapyUnclassified(ValueSet):
    VALUE_SET_NAME = 'Alternative Therapy - Unclassified'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150564', '151306', '152604', '155890', '158803', '158900', '160991', '161321', '161741', '163218', '163546',
        '166918', '167105', '167573', '168505', '169303', '171427', '171453', '176770', '177278', '177751', '178933',
        '181171', '182768', '183088', '183088', '183088', '183088', '183088', '183088', '183328', '183627', '184169',
        '184948', '189179', '189817', '191779', '193012', '193152', '193588', '195302', '198329', '198676', '200139',
        '203155', '203935', '204734', '205271', '206320', '208346', '210801', '210993', '212860', '214360', '217789',
        '219064', '219307', '220216', '220342', '220598', '220821', '223917', '224667', '225298', '226269', '227911',
        '228007', '228507', '230401', '231203', '234353', '234742', '234822', '235615', '235822', '236141', '237086',
        '237677', '237677', '238303', '238416', '241878', '242451', '243241', '246069', '246339', '247299', '248359',
        '250224', '251076', '251833', '252009', '252710', '253283', '254987', '255034', '256669', '257529', '257933',
        '258254', '258887', '258925', '261374', '261704', '262734', '262758', '264869', '266138', '266914', '268035',
        '269806', '272297', '272355', '273125', '274259', '274478', '275192', '275551', '275762', '280073', '280372',
        '281820', '281840', '282725', '283409', '283776', '283964', '285186', '288002', '288997', '291551', '291685',
        '292253', '292376', '292902', '293199', '293260', '293459', '293899', '294138', '295187', '295264', '295554',
        '295966', '296485', '297466', '298891', '400010', '400018', '400218', '400567', '400915', '400924', '439486',
        '439506', '442646', '442647', '442654', '442655', '442658', '442659', '443843', '443844', '443849', '443992',
        '443992', '443997', '444803', '445851', '445887', '445898', '445904', '446001', '446197', '446198', '446225',
        '446226', '446275', '446291', '446662', '448342', '448596', '448642', '448844', '448856', '448868', '449774',
        '449775', '449939', '450180', '450285', '450288', '450941', '451289', '451303', '451334', '451636', '451672',
        '451673', '451675', '451908', '451959', '452131', '452303', '452462', '452642', '452697', '452841', '452849',
        '452853', '453589', '453601', '453608', '453609', '454135', '454269', '454271', '454420', '464553', '465373',
        '465393', '465445', '465591', '465818', '465848', '468097', '470942', '470984', '470998', '471004', '471049',
        '471285', '471788', '472689', '472690', '472692', '472693', '472699', '472703', '472712', '472720', '472721',
        '472722', '472723', '472725', '472727', '472731', '472732', '472746', '472758', '472782', '472785', '472809',
        '472817', '472835', '472854', '473016', '473042', '473043', '473249', '473256', '473264', '473275', '473275',
        '473284', '473284', '473287', '473319', '473455', '473467', '473576', '473579', '473689', '473719', '473747',
        '473753', '473828', '474173', '474267', '474283', '474373', '474681', '474681', '474759', '475137', '475238',
        '475238', '475238', '475327', '475342', '475464', '475465', '475620', '475622', '476261', '476327', '476413',
        '476415', '476730', '476758', '476760', '476763', '545630', '545630', '545630', '545631', '545631', '545631',
        '546443', '546471', '549954', '550002', '550087', '550188', '550193', '550234', '550268', '550276', '550322',
        '550441', '550552', '550567', '550584', '550610', '550914', '550914', '550919', '551166', '551170', '551498',
        '551522', '551589', '551591', '551633', '551698', '551715', '552812', '553036', '553036', '553038', '553090',
        '553091', '553091', '553181', '553205', '553479', '553567', '553574', '553668', '554829', '554851', '554877',
        '554882', '554901', '554953', '555298', '556965', '556990', '557027', '557141', '557152', '557155', '557501',
        '557501', '557851', '557882', '557882', '557923', '557971', '558347', '558347', '558395', '558791', '558806',
        '558850', '558899', '559126', '559136', '559454', '559461', '559462', '559479', '559503', '559734', '560217',
        '560248', '560367', '560632', '560722', '560735', '560930', '561464', '561549', '561555', '562290', '562535',
        '562539', '562809', '562937', '563033', '563082', '563092', '563103', '563121', '563186', '563209', '563210',
        '563237', '563254', '563291', '563316', '563334', '563381', '563786', '563824', '563867', '563965', '563977',
        '564016', '564072', '564094', '564099', '564171', '564241', '564367', '564455', '564513', '564525', '564537',
        '564544', '564567', '564570', '564589', '564595', '564625', '564631', '564680', '564695', '564697', '564719',
        '564982', '565118', '566832', '567104', '567159', '568058', '568061', '568132', '568237', '568305', '568375',
        '568706', '568745', '568823', '570325', '570354', '570393', '570395', '570592', '571025', '571212', '571216',
        '571245', '571247', '571288', '571290', '571295', '571353', '571354', '571355', '571408', '571432', '571530',
        '571937', '571938', '571951', '571955', '571958', '572022', '572039', '572040', '572080', '572088', '572111',
        '572133', '572151', '572167', '572282', '572306', '572340', '572648', '573005', '573249', '573326', '573422',
        '573462', '573563', '573838', '573841', '573935', '573968', '574595', '574989', '575118', '575189', '575212',
        '575231', '575244', '575277', '575282', '575296', '575325', '575437', '575449', '575530', '575690', '575760',
        '575796', '575799', '575820', '575967', '576070', '576077', '576093', '576115', '576146', '576156', '576174',
        '576329', '576352', '576385', '576407', '576477', '576521', '576550', '576730', '576733', '576746', '576751',
        '576823', '576857', '576868', '576994', '577014', '577046', '577072', '577248', '577501', '577518', '577531',
        '577554', '577593', '577593', '577610', '577628', '577642', '577652', '577827', '577918', '578001', '578036',
        '578103', '578376', '578439', '578766', '578926', '579145', '579152', '579180', '579181', '579326', '579339',
        '579344', '579455', '579489', '579635', '579635', '579668', '579677', '579686', '579688', '579689', '579690',
        '579691', '579693', '579709', '579720', '579724', '579728', '579729', '579730', '579734', '579751', '579763',
        '580088', '580103', '580219', '580223', '580229', '580235', '580245', '580247', '580248', '580256', '580265',
        '580294', '580317', '580329', '580338', '580340', '580346', '580347', '580351', '580357', '580370', '580459',
        '580965', '580966', '580982', '581013', '581058', '581065', '581094', '581142', '581165', '581171', '581315',
        '581543', '581557', '581579', '581581', '581820', '581850', '581852', '581863', '581877', '581884', '581887',
        '581891', '581916', '581923', '582124', '582225', '582243', '582280', '582374', '582581', '582588', '583096',
        '583134', '583170', '583235', '583355', '583387', '583501', '583502', '583540', '583562', '583563', '583564',
        '584150', '584846', '584846', '584867', '584867', '585831', '585848', '585851', '585876', '586542', '586570',
        '586627', '586678', '586708', '586725', '586773', '586789', '586987', '586992', '587017', '587060', '587521',
        '587576', '587917', '587957', '588303', '588308', '588344', '588346', '588390', '588399', '588580', '589026',
        '589087', '589179', '589180', '589221', '589313', '589505', '589566', '589568', '589890', '589973', '589999',
        '590019', '590084', '590202', '590357', '590423', '591556', '591884', '591899', '592228', '592264', '592336',
        '592692', '592692', '592717', '592717', '592782', '592883', '593019', '593080', '593228', '593234', '593255',
        '593272', '593311', '593316', '593317', '593351', '593356', '593378', '593381', '593423', '593483', '593542',
        '593568', '593569', '593709', '593753', '593760', '594111', '594180', '594222', '594263', '594366', '594374',
        '594490', '594520', '594524', '594564', '594592', '594610', '594660', '594897', '595123', '595208', '595328',
        '595450',
    }


class AlternativeTherapyAntiarthritics(ValueSet):
    VALUE_SET_NAME = 'Alternative Therapy - Antiarthritics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150782', '176978', '190521', '197114', '216892', '254420', '254732', '256679', '274175', '290788', '291528',
        '291889', '443746', '443747', '443796', '445885', '446684', '446732', '448212', '448269', '450115', '450115',
        '451222', '451398', '451681', '451940', '452058', '452074', '452106', '452108', '452331', '452610', '453464',
        '453465', '454108', '465435', '467336', '467342', '468317', '468354', '470936', '470983', '471591', '471592',
        '473250', '474211', '474229', '474634', '474909', '476203', '476207', '546511', '546587', '546655', '551634',
        '552834', '552842', '553463', '553497', '553681', '553698', '553914', '554255', '554862', '555109', '555598',
        '555599', '556162', '556163', '556207', '556222', '556237', '556926', '558251', '558405', '558406', '558419',
        '558420', '558699', '559169', '559213', '559216', '560026', '560531', '560547', '560959', '560961', '560969',
        '560972', '560973', '561068', '561289', '561313', '561384', '561657', '561658', '561697', '561704', '561736',
        '562775', '562869', '562901', '563231', '563557', '563631', '564203', '564391', '564393', '564394', '564507',
        '564508', '564536', '564683', '564734', '564793', '565071', '565103', '565130', '565191', '565531', '566522',
        '566836', '567146', '569461', '569669', '569669', '569726', '569760', '569774', '571876', '571920', '572716',
        '572749', '573937', '574554', '576131', '576328', '576396', '576454', '576512', '576513', '576572', '576895',
        '576962', '578443', '578470', '578925', '578950', '579060', '579229', '579492', '580178', '580396', '580401',
        '580519', '580879', '583500', '583602', '587485', '587534', '587578', '589106', '589122', '589187', '589492',
        '589645', '590878', '591050', '591391', '591411', '591429', '591511', '591530', '591545', '594512', '594593',
        '595405',
    }


class AlternativeTherapyPinealHormoneAgents(ValueSet):
    VALUE_SET_NAME = 'Alternative Therapy - Pineal Hormone Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '476462', '476489',
    }


class AlternativeTherapyAndrogenicAgents(ValueSet):
    VALUE_SET_NAME = 'Alternative Therapy - Androgenic Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '178847', '182803', '185159', '196713', '200117', '284203', '452309', '454051', '557016', '557025', '563692',
        '563697', '588267', '588318',
    }


class AlternativeTherapyAntidepressants(ValueSet):
    VALUE_SET_NAME = 'Alternative Therapy - Antidepressants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '201601', '269943', '298888',
    }


class AlternativeTherapyTopicalAntiInflammatoryAgents(ValueSet):
    VALUE_SET_NAME = 'Alternative Therapy - Topical Anti-inflammatory Agents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '200898', '231360',
    }


class AlternativeTherapySedativeHypnotics(ValueSet):
    VALUE_SET_NAME = 'Alternative Therapy - Sedative/Hypnotics'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '197284', '445232', '445232', '465829', '465829', '571885', '593563',
    }


class ChemicalsPharmaceuticalAdjuvants(ValueSet):
    VALUE_SET_NAME = 'Chemicals-Pharmaceutical Adjuvants'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151890', '151890', '151890', '151890', '151890', '151890', '151890', '151890', '151890', '153004', '153504',
        '153504', '153504', '153504', '153504', '153504', '154324', '154324', '154324', '154324', '156968', '158765',
        '159360', '159463', '159755', '162859', '165262', '165266', '165266', '166519', '168778', '168778', '169926',
        '169926', '172458', '172458', '172936', '172936', '172936', '172936', '172936', '172936', '172936', '172936',
        '176346', '177750', '177750', '177750', '177750', '177967', '178421', '179864', '179864', '181733', '181733',
        '182772', '182772', '182978', '187234', '187234', '190486', '190486', '190486', '193990', '200021', '206961',
        '208327', '208327', '210777', '210777', '210777', '210777', '213578', '213578', '218446', '218714', '218714',
        '218714', '219311', '220780', '220780', '220780', '223012', '223012', '224470', '226958', '227860', '228366',
        '231199', '231199', '231199', '231199', '234264', '234264', '235872', '235872', '235872', '235872', '235872',
        '235872', '235872', '235872', '235872', '235872', '236469', '236504', '239341', '239341', '239341', '239341',
        '239341', '239341', '239341', '239341', '239341', '239457', '239719', '241676', '241676', '241676', '241676',
        '243437', '248195', '249400', '250000', '250000', '250000', '250000', '250162', '250162', '251685', '253923',
        '254185', '254185', '254185', '254185', '254575', '254575', '254575', '254575', '254575', '254575', '254575',
        '254575', '258198', '261241', '261241', '261241', '262125', '264054', '264054', '264054', '264054', '270371',
        '270371', '271493', '271493', '271493', '272389', '272389', '272389', '272389', '280471', '280471', '280471',
        '280471', '281756', '281756', '281756', '281756', '281850', '284396', '285538', '287739', '287739', '287739',
        '287739', '287739', '287739', '287739', '287739', '287739', '290089', '290089', '290089', '290089', '290089',
        '293803', '293803', '293803', '293803', '294674', '297166', '297166', '297166', '297166', '297166', '297166',
        '297166', '298053', '298053', '298053', '298053', '298053', '298053', '298053', '298053', '445097', '445403',
        '445411', '445411', '445411', '446850', '446850', '446851', '446870', '446871', '446871', '447292', '449609',
        '449771', '449860', '449947', '449947', '450277', '450277', '450320', '450396', '450396', '450396', '450396',
        '450396', '450396', '450396', '450766', '451046', '451046', '451870', '452050', '452269', '452363', '453369',
        '453369', '453736', '454433', '454433', '454433', '454434', '454434', '454434', '465117', '467363', '467363',
        '467363', '473252', '473253', '473254', '473255', '473799', '473886', '473888', '473889', '474435', '474435',
        '474435', '474436', '474436', '474436', '474448', '474448', '474448', '474648', '474648', '474723', '474723',
        '545614', '545615', '545616', '545618', '551085', '551100', '555783', '556206', '556221', '556298', '557898',
        '557898', '557898', '557898', '557898', '557938', '557938', '557938', '557938', '557938', '557967', '557967',
        '557967', '557967', '558051', '558051', '558063', '558336', '558336', '558336', '558344', '558344', '558344',
        '558773', '558773', '558773', '558773', '558774', '558774', '558774', '558774', '560032', '560049', '560812',
        '560878', '561375', '561375', '561375', '562182', '562332', '562346', '562356', '562991', '563292', '563299',
        '565563', '565563', '566817', '567246', '568446', '568831', '569220', '569220', '569295', '569597', '569636',
        '572396', '574880', '574882', '575319', '575319', '575319', '575352', '575352', '575352', '575768', '575768',
        '575895', '575895', '575895', '575896', '575896', '575906', '576134', '576141', '576152', '576152', '576152',
        '576153', '576153', '576363', '576897', '576897', '576914', '576914', '577231', '578780', '578834', '579942',
        '579942', '579943', '579943', '579944', '579944', '579991', '579991', '580016', '580037', '580047', '580047',
        '580185', '580185', '580257', '580257', '584954', '586949', '588239', '588244', '588245', '588246', '588250',
        '588253', '588254', '588255', '588313', '588622', '589994', '590528', '590529', '592990', '593082', '593094',
        '593101', '594838', '594854', '594888', '594899', '595494', '595742', '595743', '595773', '595774', '595929',
        '595930', '595989', '595990', '596012', '596053',
    }


class ChemicalsAcids(ValueSet):
    VALUE_SET_NAME = 'Chemicals - Acids'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '200021',
    }


class ChemicalsBases(ValueSet):
    VALUE_SET_NAME = 'Chemicals - Bases'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class ChemicalsBuffers(ValueSet):
    VALUE_SET_NAME = 'Chemicals - Buffers'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '227860', '251685',
    }


class ChemicalsSolvents(ValueSet):
    VALUE_SET_NAME = 'Chemicals - Solvents'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151890', '151890', '151890', '151890', '151890', '151890', '151890', '151890', '151890', '153504', '153504',
        '153504', '153504', '153504', '153504', '168778', '168778', '172458', '172458', '178421', '182772', '182772',
        '208327', '208327', '213578', '213578', '231199', '231199', '231199', '231199', '235872', '235872', '235872',
        '235872', '235872', '235872', '235872', '235872', '235872', '235872', '236504', '239341', '239341', '239341',
        '239341', '239341', '239341', '239341', '239341', '239341', '241676', '241676', '241676', '241676', '249400',
        '254185', '254185', '254185', '254185', '445403', '449609', '450766', '453369', '453369', '465117', '557967',
        '557967', '557967', '557967',
    }


class ChemicalsFixedOils(ValueSet):
    VALUE_SET_NAME = 'Chemicals - Fixed Oils'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '159755', '187234', '187234', '220780', '220780', '220780', '254575', '254575', '254575', '254575', '254575',
        '254575', '254575', '254575', '294674', '445097', '449860', '450396', '450396', '450396', '450396', '450396',
        '450396', '450396',
    }


class ChemicalsEssentialOils(ValueSet):
    VALUE_SET_NAME = 'Chemicals - Essential Oils'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '223012', '223012', '250000', '250000', '250000', '250000', '253923', '281756', '281756', '281756', '281756',
        '293803', '293803', '293803', '293803', '298053', '298053', '298053', '298053', '298053', '298053', '298053',
        '298053', '451870', '452363',
    }


class BulkChemicals(ValueSet):
    VALUE_SET_NAME = 'Bulk Chemicals'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '165262', '177967', '182978', '236469', '248195', '280471', '280471', '280471', '280471', '567246', '575906',
        '576363',
    }


class MedicalSuppliesAndDurableMedicalEquipmentDme(ValueSet):
    VALUE_SET_NAME = 'Medical Supplies and Durable Medical Equipment (DME)'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150211', '150307', '150307', '150673', '150680', '150690', '150883', '150883', '150885', '150886', '150915',
        '150923', '150934', '150985', '151004', '151124', '151143', '151176', '151176', '151269', '151848', '151875',
        '151882', '151955', '152083', '152088', '152095', '152095', '153254', '153363', '153440', '153443', '153708',
        '153749', '153788', '154076', '154086', '154348', '154371', '154404', '154404', '154459', '154560', '154592',
        '154592', '154592', '154620', '154743', '154925', '154992', '155055', '155127', '155129', '155140', '155140',
        '155140', '155334', '155395', '155395', '155524', '155524', '155524', '155524', '155677', '155707', '155802',
        '156266', '156266', '156266', '156266', '156266', '156266', '156266', '156534', '156671', '157099', '157100',
        '157104', '157246', '157246', '157246', '157246', '157246', '157246', '157438', '157467', '157467', '157736',
        '157742', '157938', '158055', '158168', '158262', '158262', '158710', '158912', '158947', '159048', '159048',
        '159071', '159071', '159071', '159071', '159071', '159071', '159071', '159071', '159071', '159111', '159151',
        '159317', '159378', '159839', '160019', '160068', '160140', '160589', '160606', '160733', '161179', '161215',
        '161380', '161380', '161483', '161596', '161900', '161900', '161900', '161921', '161921', '162036', '162036',
        '162061', '162112', '162386', '162386', '162386', '162469', '162525', '162743', '163032', '163032', '163209',
        '163450', '163842', '164007', '164217', '164324', '164587', '164781', '164928', '164977', '165035', '165049',
        '165115', '165115', '165115', '165115', '165115', '165115', '165129', '165532', '165600', '165616', '165676',
        '165946', '165997', '166022', '166039', '166065', '166070', '166091', '166499', '166711', '166916', '166980',
        '166991', '166991', '167168', '167313', '167508', '167531', '167683', '167683', '167886', '168111', '168251',
        '168251', '168305', '168324', '168363', '168510', '168510', '168629', '168832', '168911', '168934', '168937',
        '168937', '168964', '168964', '168964', '168964', '168964', '168964', '168964', '168964', '168977', '169143',
        '169143', '169143', '169340', '169449', '169543', '169546', '169556', '169909', '170318', '170318', '170689',
        '170711', '170882', '170882', '170882', '171061', '171191', '171269', '171387', '171418', '171429', '171989',
        '171989', '172044', '172174', '172306', '172306', '172306', '172306', '172306', '172306', '172306', '172306',
        '172450', '172450', '172450', '172450', '172635', '172659', '172659', '172693', '172713', '172798', '172922',
        '172922', '173098', '173196', '173742', '173966', '173977', '173977', '174186', '174592', '174946', '175063',
        '175334', '175539', '175982', '176118', '176131', '176273', '176273', '176274', '176382', '176382', '176382',
        '176382', '176382', '176382', '176382', '176382', '176382', '176382', '176569', '176569', '176929', '177021',
        '177021', '177025', '177459', '177492', '177737', '177885', '177991', '178064', '178172', '178172', '178172',
        '178172', '178172', '178172', '178172', '178172', '178172', '178371', '178686', '178699', '178780', '179009',
        '179138', '179256', '179400', '179543', '179611', '179702', '179765', '179765', '179887', '179989', '180099',
        '180574', '180574', '180574', '180574', '180574', '180574', '180574', '180612', '180647', '181200', '181437',
        '181522', '181742', '181742', '182200', '182252', '182252', '182252', '182252', '182584', '182636', '182637',
        '182637', '182711', '182792', '183165', '183192', '183196', '183242', '183398', '183482', '183656', '183724',
        '183987', '183987', '184120', '184120', '184260', '184260', '184322', '184954', '184979', '185026', '185036',
        '185036', '185036', '185036', '185036', '185049', '185098', '185162', '185162', '185176', '185428', '185428',
        '185504', '185513', '185693', '185742', '185911', '186033', '186033', '186571', '186720', '186809', '186956',
        '186964', '186964', '187261', '187713', '187924', '187924', '188202', '188534', '188934', '188934', '189175',
        '189175', '189175', '189175', '189824', '189855', '189962', '190220', '190220', '190389', '190401', '190467',
        '190647', '191055', '191653', '191801', '191919', '192036', '192215', '192472', '192554', '192584', '192898',
        '193246', '193274', '193346', '193360', '193360', '193418', '193449', '193656', '193729', '193768', '193768',
        '193768', '193768', '193888', '193888', '193972', '193972', '194035', '194035', '194041', '194145', '194145',
        '194145', '194145', '194388', '194730', '195071', '195071', '195117', '195384', '195384', '195390', '195465',
        '195485', '195581', '195707', '195707', '195707', '195714', '195714', '195724', '195792', '195880', '195941',
        '196359', '196359', '196362', '196557', '196581', '196664', '196664', '197040', '197793', '197835', '197972',
        '198000', '198174', '198248', '198341', '198586', '198586', '198840', '198931', '199030', '199277', '199375',
        '199375', '199664', '199664', '199692', '199754', '199802', '199802', '199802', '199820', '199820', '199925',
        '199925', '199998', '200054', '200099', '200225', '200250', '200260', '200260', '200260', '200261', '201063',
        '201243', '201272', '201299', '201336', '201393', '201470', '201470', '201541', '201626', '201692', '201692',
        '201692', '201692', '201829', '201948', '201948', '201948', '202036', '202036', '202036', '202036', '202036',
        '202278', '202484', '202484', '202762', '202789', '202789', '202935', '203030', '203030', '203030', '203030',
        '203231', '203231', '203471', '203609', '203609', '203660', '203938', '204033', '204177', '204247', '204487',
        '204538', '204664', '204741', '204840', '204847', '205081', '205081', '205107', '205473', '205600', '205682',
        '205752', '205752', '205977', '206080', '206086', '206086', '206260', '206269', '206269', '206311', '206342',
        '206466', '206641', '206750', '206820', '206926', '207023', '207038', '207216', '207300', '207300', '207300',
        '207300', '207486', '207486', '207486', '207486', '207486', '207511', '207511', '207512', '207779', '207779',
        '207808', '207994', '208032', '208045', '208065', '208095', '208414', '208414', '208512', '208654', '208885',
        '208936', '208936', '208990', '209066', '209066', '209066', '209066', '209066', '209066', '209066', '209066',
        '209066', '209200', '209363', '209385', '209692', '209740', '209903', '210138', '210148', '210273', '210302',
        '210360', '210375', '210385', '210967', '211028', '211247', '211247', '211247', '211247', '211247', '211247',
        '211247', '211247', '211247', '211247', '211320', '211343', '211944', '212010', '212050', '212124', '212142',
        '212360', '212454', '212609', '212931', '213208', '213208', '213208', '213208', '213588', '214050', '214341',
        '214359', '214470', '214470', '214481', '214538', '214584', '214601', '214601', '214601', '214601', '214601',
        '214732', '214766', '215717', '215743', '216062', '216062', '216087', '216183', '216263', '216336', '216388',
        '216524', '216630', '216663', '216841', '216900', '217144', '217219', '217226', '217472', '217477', '217552',
        '217657', '217720', '217776', '217776', '217776', '217776', '218342', '218387', '218519', '218519', '218961',
        '218961', '218961', '218961', '219100', '219248', '219463', '219642', '219924', '219992', '220207', '220207',
        '220574', '220653', '220682', '220932', '221101', '221168', '221185', '221185', '221185', '221185', '221185',
        '221185', '221185', '221251', '221251', '221286', '221454', '221544', '221778', '221945', '222002', '222148',
        '222629', '222691', '222728', '222728', '222728', '222787', '222905', '223145', '223145', '223145', '223145',
        '223145', '223846', '224063', '224126', '224298', '224377', '224377', '224377', '224377', '224377', '224377',
        '224520', '224566', '224727', '224958', '224958', '224958', '224958', '224958', '225002', '225076', '225102',
        '225102', '225231', '225406', '225582', '225798', '225919', '226013', '226073', '226160', '226485', '226564',
        '226564', '226564', '226564', '226564', '226564', '226564', '226564', '226584', '226584', '226870', '226955',
        '226972', '226972', '226972', '226972', '227025', '227213', '227229', '227857', '228030', '228030', '228196',
        '228393', '228430', '228941', '229075', '229608', '229974', '230019', '230292', '230357', '230477', '230504',
        '230553', '230553', '230794', '230801', '230801', '230845', '230956', '231260', '231260', '231335', '231674',
        '231674', '231674', '231706', '231774', '231858', '231858', '231858', '231893', '231893', '231893', '231992',
        '232138', '232682', '232819', '232952', '232952', '232952', '232952', '233036', '233083', '233101', '233134',
        '233758', '233758', '233860', '233879', '233882', '233934', '234193', '234327', '234328', '234349', '234349',
        '234349', '234378', '234622', '234879', '234975', '234989', '235196', '235227', '235227', '235273', '235345',
        '235523', '235534', '235534', '235534', '235620', '235683', '235926', '236098', '236188', '236188', '236188',
        '236188', '236188', '236188', '236222', '236222', '236780', '236902', '236904', '236914', '236936', '236936',
        '236936', '237394', '237433', '237563', '237653', '237788', '237803', '238188', '238359', '238359', '238460',
        '238604', '238604', '238604', '238687', '238869', '239724', '239850', '239863', '240073', '240322', '240452',
        '240647', '240647', '240647', '240647', '240910', '240910', '240910', '240919', '241069', '241367', '241588',
        '241796', '241798', '241833', '241833', '242095', '242801', '242801', '242801', '243360', '243587', '243699',
        '244088', '244158', '244208', '244246', '244246', '244246', '244246', '244424', '244470', '244530', '244530',
        '244535', '244723', '244888', '245027', '245027', '245027', '245027', '245027', '245027', '245244', '245244',
        '245461', '245502', '246211', '246326', '246678', '247118', '247231', '247262', '247399', '247400', '247436',
        '247436', '247436', '247448', '247474', '247474', '247474', '247474', '247474', '247474', '247474', '247474',
        '247474', '247474', '247474', '247474', '247474', '247474', '247474', '247474', '247474', '247474', '247506',
        '247639', '247643', '247680', '247680', '247680', '247680', '247680', '247697', '247848', '247848', '247856',
        '247860', '247860', '247878', '247878', '247878', '247928', '247955', '248010', '248151', '248502', '248502',
        '248537', '248712', '248712', '248984', '249207', '249222', '249263', '249391', '249457', '249481', '249489',
        '249497', '249941', '250067', '250089', '250139', '250142', '250174', '250608', '250740', '250740', '250740',
        '250740', '250740', '250817', '251008', '251292', '251347', '251388', '251494', '251630', '251831', '251831',
        '251921', '252396', '252557', '252557', '252557', '252557', '252557', '252557', '252557', '252557', '252778',
        '252778', '252778', '252778', '253138', '253406', '253531', '253780', '253790', '253949', '254058', '254058',
        '254058', '254128', '254257', '254525', '254592', '254628', '254628', '254642', '254727', '255008', '255074',
        '256343', '256358', '256390', '256478', '256545', '256545', '256561', '256568', '256616', '256754', '256984',
        '257008', '257008', '257008', '257381', '257651', '257651', '257745', '257859', '257978', '258092', '258374',
        '258374', '258374', '258384', '258418', '258515', '258527', '258527', '258527', '258527', '258527', '258537',
        '258589', '258589', '258658', '258692', '258692', '258692', '259274', '259274', '259429', '259713', '259713',
        '259856', '259856', '260102', '260102', '260373', '260373', '260515', '260515', '260515', '260515', '260727',
        '260728', '260742', '260806', '260844', '260971', '261424', '261424', '261462', '261560', '261603', '261650',
        '261919', '261919', '261919', '261919', '262302', '262439', '262501', '262501', '262506', '262543', '262543',
        '262598', '262684', '262833', '262926', '262926', '262926', '263264', '263297', '263509', '263509', '263509',
        '263537', '263537', '263537', '263565', '263813', '263910', '264154', '264154', '264162', '264162', '264711',
        '264824', '264824', '264824', '264824', '264971', '265004', '265004', '265004', '265004', '265153', '265244',
        '265315', '265563', '265563', '265563', '265563', '265623', '265669', '265685', '265773', '265929', '266611',
        '266671', '266671', '267030', '267030', '267243', '267243', '267259', '267259', '267259', '267341', '267351',
        '267374', '267459', '267571', '267591', '268094', '268183', '268183', '268183', '268183', '268183', '268183',
        '268183', '268183', '268199', '268211', '268270', '268270', '268270', '268270', '268464', '268579', '268607',
        '268643', '268893', '269237', '269253', '269266', '269286', '269475', '269527', '269582', '270030', '270312',
        '270643', '270824', '270832', '271617', '271626', '271626', '271626', '271626', '271626', '271626', '271722',
        '271722', '271901', '271930', '272160', '272167', '272185', '272210', '272321', '272382', '272524', '272774',
        '272806', '272907', '272970', '272970', '272970', '272970', '272970', '273280', '273747', '273787', '273887',
        '273915', '273915', '273915', '274028', '274201', '274270', '274361', '274371', '274428', '274492', '274528',
        '274634', '274801', '275003', '275646', '275682', '275718', '275975', '276371', '276563', '276662', '276752',
        '276948', '277103', '277103', '277103', '277253', '277386', '277684', '277684', '277684', '277684', '277684',
        '277684', '277950', '277954', '278388', '278513', '278513', '278906', '279000', '279442', '279442', '279442',
        '279442', '279442', '279442', '279578', '279585', '279603', '279603', '280366', '280796', '280930', '281006',
        '281115', '281220', '281233', '281292', '281381', '281381', '281381', '281381', '281381', '281381', '281381',
        '281473', '281479', '281574', '281779', '282113', '282174', '282206', '282286', '282386', '282552', '282711',
        '282711', '282711', '282711', '282733', '282802', '282908', '282980', '283044', '283214', '283557', '283878',
        '284019', '284067', '284200', '284232', '284344', '285019', '285019', '285251', '285437', '285480', '285483',
        '286024', '286024', '286024', '286024', '286499', '286499', '286602', '287126', '287138', '287433', '287577',
        '287577', '287604', '287604', '287604', '287728', '287810', '287903', '288042', '288115', '288744', '288850',
        '289059', '289059', '289059', '289059', '289059', '289071', '289116', '289116', '289194', '289256', '289363',
        '289473', '289652', '289703', '290075', '290194', '290198', '290379', '290420', '290420', '290737', '290737',
        '290737', '290737', '290751', '290815', '291174', '291174', '291197', '291429', '291751', '291930', '292009',
        '292128', '292506', '292651', '292661', '292736', '292739', '292847', '292907', '292907', '293049', '293077',
        '293250', '293346', '293404', '293404', '293404', '293404', '293560', '293727', '293727', '293870', '294104',
        '294215', '294219', '294392', '294443', '294608', '294608', '294608', '294734', '294758', '294883', '294883',
        '294955', '295012', '295108', '295213', '295244', '295462', '295536', '295639', '295664', '295664', '295870',
        '296068', '296169', '296314', '296513', '296513', '296513', '296513', '296560', '296604', '296729', '297191',
        '297581', '297690', '297690', '297786', '297794', '297794', '298359', '298359', '298359', '298428', '298442',
        '298592', '298824', '298842', '298842', '298992', '299373', '299850', '299850', '400031', '400032', '400033',
        '400034', '400044', '400075', '400257', '400358', '400358', '400358', '400358', '400358', '400358', '400358',
        '400358', '400358', '400358', '400358', '400358', '400358', '400358', '400358', '400358', '400358', '400358',
        '400358', '400358', '400358', '400358', '400358', '400358', '400358', '400358', '400358', '400358', '400520',
        '400534', '400534', '400534', '400534', '400534', '400542', '400542', '400542', '400694', '400694', '400694',
        '400695', '400696', '400696', '400697', '400699', '400707', '400708', '400723', '400724', '400857', '400897',
        '400898', '400899', '400900', '400912', '400972', '400983', '400984', '400984', '400985', '400985', '400986',
        '400986', '400994', '400994', '401073', '401083', '401085', '401086', '442100', '442119', '442120', '442121',
        '442126', '442126', '442127', '442128', '442287', '442505', '442505', '442505', '442536', '442897', '442898',
        '442899', '442899', '442900', '442900', '442901', '442903', '442904', '442906', '442908', '442911', '442912',
        '442914', '442916', '442917', '442921', '442922', '442924', '442926', '442927', '442928', '442929', '442931',
        '442932', '442936', '442939', '442946', '442953', '442959', '442963', '442966', '442968', '442968', '442968',
        '442971', '442972', '442973', '442974', '442975', '442976', '442977', '442978', '442979', '442980', '442981',
        '442982', '442982', '442984', '442986', '443128', '443128', '443128', '443230', '443286', '443298', '443311',
        '443322', '443327', '443342', '443351', '443362', '443374', '443375', '443375', '443375', '443375', '443376',
        '443376', '443376', '443387', '443402', '443406', '443425', '443425', '443425', '443427', '443427', '443428',
        '443428', '443429', '443453', '443501', '443525', '443529', '443610', '443622', '443622', '443622', '443622',
        '443622', '443622', '443622', '443623', '443623', '443623', '443623', '443624', '443624', '443624', '443624',
        '443624', '443624', '443624', '443625', '443625', '443625', '443625', '443626', '443626', '443626', '443626',
        '443626', '443626', '443626', '443626', '443627', '443627', '443627', '443627', '443627', '443628', '443628',
        '443628', '443629', '443629', '443629', '443629', '443629', '443629', '443629', '443629', '443629', '443691',
        '443696', '443697', '443698', '443699', '443700', '443829', '443832', '443833', '443835', '443836', '443836',
        '443836', '443836', '443837', '443837', '443837', '443838', '443838', '443838', '443838', '443854', '443855',
        '443883', '443883', '443886', '443887', '443888', '443946', '443962', '443962', '443962', '443962', '443962',
        '443962', '443962', '443962', '443962', '443962', '443962', '443979', '443979', '443979', '444022', '444022',
        '444022', '444022', '444022', '444022', '444022', '444022', '444022', '444022', '444022', '444022', '444022',
        '444022', '444022', '444022', '444022', '444023', '444023', '444025', '444025', '444027', '444027', '444027',
        '444027', '444027', '444027', '444037', '444037', '444037', '444038', '444038', '444038', '444039', '444039',
        '444039', '444040', '444040', '444040', '444060', '444060', '444061', '444062', '444062', '444062', '444063',
        '444063', '444064', '444064', '444064', '444064', '444065', '444066', '444067', '444069', '444071', '444071',
        '444071', '444072', '444074', '444075', '444076', '444076', '444077', '444080', '444080', '444080', '444081',
        '444083', '444084', '444084', '444084', '444084', '444084', '444085', '444086', '444086', '444086', '444086',
        '444090', '444090', '444091', '444092', '444093', '444095', '444095', '444096', '444096', '444096', '444096',
        '444097', '444098', '444098', '444100', '444101', '444101', '444107', '444111', '444114', '444115', '444116',
        '444116', '444116', '444119', '444120', '444120', '444122', '444124', '444124', '444124', '444126', '444126',
        '444129', '444131', '444131', '444134', '444143', '444144', '444145', '444146', '444147', '444150', '444151',
        '444158', '444160', '444162', '444163', '444213', '444213', '444213', '444235', '444235', '444235', '444236',
        '444236', '444236', '444238', '444238', '444238', '444239', '444241', '444241', '444241', '444256', '444259',
        '444260', '444261', '444390', '444391', '444394', '444394', '444395', '444395', '444396', '444397', '444397',
        '444399', '444399', '444401', '444410', '444412', '444413', '444421', '444421', '444421', '444422', '444425',
        '444427', '444427', '444427', '444427', '444427', '444427', '444427', '444427', '444427', '444427', '444428',
        '444433', '444433', '444433', '444434', '444434', '444436', '444437', '444438', '444442', '444443', '444445',
        '444445', '444446', '444446', '444446', '444446', '444446', '444446', '444446', '444446', '444448', '444448',
        '444452', '444453', '444455', '444455', '444457', '444458', '444458', '444461', '444462', '444462', '444462',
        '444462', '444462', '444463', '444463', '444464', '444465', '444466', '444467', '444468', '444468', '444468',
        '444472', '444473', '444476', '444476', '444477', '444477', '444477', '444477', '444477', '444477', '444477',
        '444477', '444477', '444477', '444479', '444479', '444482', '444488', '444495', '444495', '444495', '444496',
        '444497', '444498', '444498', '444498', '444499', '444499', '444501', '444501', '444501', '444501', '444501',
        '444501', '444501', '444502', '444503', '444503', '444503', '444503', '444503', '444503', '444504', '444504',
        '444504', '444504', '444504', '444506', '444507', '444507', '444508', '444509', '444509', '444509', '444510',
        '444510', '444510', '444510', '444510', '444510', '444510', '444510', '444510', '444510', '444510', '444510',
        '444510', '444510', '444510', '444510', '444510', '444511', '444511', '444511', '444511', '444547', '444547',
        '444547', '444547', '444549', '444554', '444555', '444555', '444556', '444605', '444605', '444605', '444605',
        '444622', '444622', '444622', '444622', '444622', '444623', '444623', '444623', '444623', '444623', '444624',
        '444624', '444632', '444632', '444632', '444635', '444640', '444641', '444641', '444645', '444647', '444647',
        '444658', '444660', '444660', '444660', '444661', '444661', '444661', '444662', '444663', '444665', '444666',
        '444666', '444666', '444666', '444666', '444667', '444667', '444673', '444680', '444681', '444682', '444683',
        '444684', '444702', '444703', '444706', '444707', '444709', '444711', '444713', '444713', '444714', '444714',
        '444724', '444724', '444724', '444727', '444727', '444728', '444728', '444728', '444728', '444729', '444729',
        '444729', '444734', '444739', '444741', '444741', '444743', '444744', '444744', '444745', '444746', '444746',
        '444749', '444750', '444751', '444752', '444763', '444766', '444766', '444767', '444767', '444767', '444769',
        '444771', '444772', '444773', '444773', '444775', '444775', '444778', '444778', '444780', '444865', '444865',
        '444866', '444866', '444867', '444867', '444868', '444868', '444869', '444869', '444870', '444870', '444871',
        '444881', '444881', '444885', '444898', '444901', '444902', '444912', '444968', '444971', '444971', '444973',
        '444973', '444975', '444975', '444977', '444977', '444979', '444980', '444981', '444981', '444982', '444982',
        '444983', '444983', '445073', '445075', '445079', '445079', '445081', '445082', '445084', '445112', '445112',
        '445119', '445119', '445120', '445120', '445121', '445139', '445139', '445140', '445140', '445140', '445140',
        '445140', '445141', '445146', '445146', '445147', '445148', '445148', '445148', '445257', '445257', '445257',
        '445262', '445326', '445328', '445335', '445336', '445337', '445341', '445342', '445344', '445345', '445346',
        '445348', '445350', '445351', '445352', '445353', '445356', '445357', '445359', '445360', '445371', '445374',
        '445374', '445399', '445420', '445422', '445439', '445492', '445492', '445493', '445493', '445520', '445529',
        '445529', '445529', '445529', '445532', '445532', '445533', '445533', '445533', '445533', '445535', '445535',
        '445535', '445535', '445536', '445536', '445537', '445546', '445546', '445546', '445560', '445567', '445570',
        '445579', '445585', '445586', '445587', '445587', '445598', '445600', '445600', '445799', '445800', '445817',
        '445839', '445845', '445897', '445897', '445922', '445932', '445934', '445935', '445936', '445937', '445938',
        '445938', '445938', '445940', '445940', '445941', '445942', '445943', '445943', '445944', '445944', '445944',
        '446130', '446130', '446328', '446328', '446328', '446377', '446377', '446377', '446407', '446408', '446409',
        '446410', '446411', '446412', '446453', '446453', '446480', '446483', '446484', '446485', '446486', '446487',
        '446488', '446542', '446627', '446627', '446627', '446628', '446628', '446628', '446676', '446676', '446718',
        '446805', '446848', '446848', '446849', '446849', '446856', '446856', '446857', '446857', '446874', '446874',
        '446877', '446877', '446877', '446877', '446880', '446880', '446896', '446896', '446897', '446897', '446902',
        '446903', '446936', '446958', '447041', '447057', '447057', '447057', '447058', '447121', '447139', '447169',
        '447169', '447170', '447335', '447352', '447353', '447509', '447516', '447553', '447563', '447573', '447573',
        '447593', '447594', '447595', '447596', '447597', '447598', '447599', '447621', '447685', '447686', '447687',
        '447689', '447728', '447735', '447736', '447740', '447807', '447840', '447841', '447842', '447843', '447867',
        '447868', '447868', '447868', '447871', '447873', '447881', '447882', '447894', '447917', '447917', '447918',
        '447919', '447920', '447922', '447923', '447924', '447925', '447926', '447929', '447930', '447996', '447997',
        '447998', '448007', '448053', '448054', '448055', '448056', '448057', '448058', '448059', '448060', '448061',
        '448062', '448176', '448176', '448281', '448300', '448300', '448300', '448302', '448302', '448302', '448305',
        '448305', '448305', '448305', '448305', '448305', '448305', '448305', '448305', '448305', '448306', '448307',
        '448310', '448310', '448315', '448332', '448333', '448475', '448608', '448686', '448686', '448752', '448752',
        '448752', '448778', '448778', '448778', '448778', '448779', '448779', '448779', '448785', '448785', '448786',
        '448789', '448790', '448790', '448791', '448791', '448798', '448798', '448798', '448798', '448798', '448798',
        '448799', '448799', '448799', '448799', '448799', '448799', '448800', '448800', '448800', '448800', '448805',
        '448805', '448810', '448810', '448810', '448811', '448818', '448818', '448818', '448819', '448819', '448819',
        '448819', '448819', '448819', '448819', '448819', '448821', '448821', '448821', '448821', '448821', '448821',
        '448822', '448822', '448822', '448822', '448822', '448822', '448822', '448823', '448823', '448823', '448823',
        '448823', '448823', '448829', '448829', '448829', '448829', '448830', '448830', '448830', '448830', '448830',
        '448830', '448830', '448907', '448966', '448973', '448989', '448995', '448995', '448996', '448996', '449049',
        '449049', '449242', '449275', '449276', '449277', '449278', '449279', '449280', '449281', '449282', '449283',
        '449284', '449319', '449320', '449321', '449322', '449354', '449356', '449377', '449377', '449377', '449378',
        '449378', '449387', '449391', '449397', '449413', '449414', '449415', '449442', '449452', '449453', '449453',
        '449454', '449454', '449454', '449454', '449454', '449454', '449454', '449455', '449462', '449477', '449478',
        '449478', '449479', '449480', '449481', '449481', '449484', '449485', '449486', '449501', '449507', '449508',
        '449509', '449510', '449517', '449518', '449519', '449520', '449521', '449522', '449523', '449524', '449525',
        '449526', '449527', '449528', '449529', '449548', '449570', '449575', '449577', '449578', '449578', '449579',
        '449579', '449587', '449587', '449589', '449589', '449590', '449590', '449591', '449591', '449593', '449593',
        '449595', '449595', '449598', '449599', '449600', '449601', '449601', '449602', '449602', '449603', '449603',
        '449604', '449614', '449614', '449615', '449615', '449617', '449619', '449620', '449620', '449621', '449651',
        '449673', '449674', '449740', '449740', '449763', '449763', '449779', '449779', '449780', '449780', '449781',
        '449784', '449785', '449785', '449812', '449813', '449813', '449813', '449813', '449975', '449976', '449977',
        '449981', '449981', '449982', '449982', '449987', '450199', '450199', '450199', '450199', '450200', '450209',
        '450209', '450209', '450212', '450214', '450214', '450215', '450215', '450216', '450217', '450218', '450218',
        '450260', '450260', '450260', '450260', '450260', '450295', '450328', '450328', '450328', '450330', '450330',
        '450330', '450330', '450330', '450330', '450331', '450331', '450332', '450332', '450332', '450336', '450336',
        '450337', '450337', '450337', '450341', '450341', '450341', '450342', '450342', '450342', '450342', '450343',
        '450343', '450343', '450343', '450353', '450353', '450353', '450353', '450355', '450361', '450361', '450413',
        '450416', '450427', '450427', '450427', '450427', '450427', '450427', '450427', '450427', '450427', '450427',
        '450427', '450430', '450430', '450430', '450434', '450611', '450612', '450617', '450617', '450617', '450617',
        '450617', '450678', '450678', '450678', '450678', '450680', '450681', '450682', '450683', '450709', '450709',
        '450710', '450710', '450751', '450785', '450786', '450787', '450788', '450789', '450790', '450797', '450797',
        '450868', '450888', '450897', '450898', '450899', '450954', '451036', '451037', '451040', '451167', '451187',
        '451187', '451192', '451193', '451218', '451234', '451235', '451237', '451238', '451239', '451243', '451243',
        '451310', '451311', '451312', '451313', '451314', '451329', '451329', '451331', '451331', '451359', '451359',
        '451360', '451360', '451360', '451360', '451360', '451360', '451360', '451361', '451361', '451361', '451361',
        '451361', '451362', '451362', '451362', '451362', '451362', '451362', '451363', '451363', '451366', '451366',
        '451367', '451367', '451368', '451368', '451369', '451369', '451370', '451372', '451373', '451382', '451385',
        '451386', '451392', '451397', '451399', '451400', '451408', '451433', '451434', '451436', '451480', '451480',
        '451480', '451481', '451481', '451481', '451481', '451529', '451529', '451530', '451531', '451554', '451555',
        '451563', '451584', '451585', '451586', '451605', '451605', '451606', '451650', '451650', '451650', '451650',
        '451722', '451768', '451769', '451807', '451807', '451871', '451872', '451873', '451874', '451926', '451926',
        '451926', '451926', '451926', '451926', '451926', '451926', '451926', '451926', '451926', '451926', '451926',
        '451926', '451926', '451926', '451926', '451926', '451926', '451926', '451926', '451926', '451926', '451979',
        '451979', '451979', '451979', '451999', '452000', '452001', '452003', '452003', '452004', '452004', '452006',
        '452007', '452008', '452009', '452053', '452053', '452055', '452055', '452055', '452125', '452142', '452145',
        '452145', '452146', '452146', '452147', '452149', '452154', '452246', '452266', '452266', '452266', '452277',
        '452277', '452278', '452279', '452279', '452280', '452280', '452281', '452281', '452343', '452344', '452416',
        '452421', '452432', '452434', '452468', '452468', '452496', '452498', '452504', '452505', '452506', '452511',
        '452522', '452524', '452553', '452557', '452557', '452557', '452558', '452558', '452558', '452559', '452560',
        '452560', '452560', '452560', '452560', '452560', '452561', '452561', '452561', '452561', '452561', '452561',
        '452561', '452561', '452561', '452561', '452562', '452562', '452562', '452597', '452615', '452616', '452617',
        '452618', '452619', '452663', '452663', '452663', '452663', '452663', '452663', '452663', '452663', '452668',
        '452669', '452669', '452671', '452671', '452671', '452671', '452671', '452671', '452672', '452672', '452672',
        '452672', '452673', '452674', '452674', '452675', '452676', '452676', '452676', '452676', '452681', '452682',
        '452682', '452682', '452682', '452684', '452684', '452684', '452684', '452684', '452684', '452684', '452684',
        '452684', '452684', '452684', '452684', '452685', '452685', '452685', '452686', '452686', '452695', '452695',
        '452698', '452702', '452750', '452799', '452800', '452801', '452802', '452803', '452804', '452804', '452808',
        '452808', '452809', '452809', '452810', '452815', '452816', '452817', '452818', '452819', '452820', '452887',
        '452887', '452888', '452888', '452889', '452889', '452891', '452891', '452892', '452892', '452893', '452893',
        '452894', '452894', '452895', '452895', '452908', '452908', '452908', '452908', '452908', '452915', '452915',
        '452916', '452916', '452940', '452945', '452945', '452947', '452948', '452948', '452951', '452953', '452957',
        '452961', '452961', '452994', '453031', '453032', '453042', '453042', '453042', '453070', '453070', '453070',
        '453070', '453070', '453070', '453070', '453070', '453074', '453075', '453083', '453084', '453358', '453358',
        '453359', '453359', '453361', '453362', '453363', '453364', '453365', '453417', '453417', '453418', '453418',
        '453419', '453419', '453420', '453420', '453421', '453421', '453422', '453422', '453423', '453423', '453424',
        '453424', '453425', '453434', '453434', '453435', '453436', '453436', '453437', '453437', '453438', '453438',
        '453439', '453440', '453440', '453441', '453441', '453442', '453442', '453476', '453500', '453535', '453536',
        '453575', '453599', '453599', '453600', '453612', '453619', '453619', '453672', '453673', '453812', '453879',
        '453880', '453895', '453895', '453904', '453904', '453904', '453904', '453904', '453904', '453904', '453904',
        '453904', '453943', '453944', '454096', '454110', '454365', '454366', '454381', '454381', '454381', '454444',
        '454445', '454446', '454447', '454448', '454449', '454451', '454469', '454470', '454470', '454471', '454475',
        '454480', '454481', '454512', '454512', '454521', '454522', '454523', '454555', '454556', '457755', '457755',
        '464148', '464184', '464185', '464186', '464196', '464212', '464238', '464238', '464238', '464322', '464343',
        '464344', '464345', '464354', '464386', '464386', '464386', '464386', '464388', '464389', '464396', '464397',
        '464479', '464480', '464481', '464653', '464694', '464697', '464751', '464759', '464776', '464777', '464778',
        '464779', '464780', '464807', '464818', '464826', '464828', '464828', '464872', '464873', '464874', '464876',
        '464877', '464881', '464882', '464883', '464884', '464884', '464885', '464886', '464891', '464894', '464896',
        '464897', '464907', '464908', '464909', '464912', '464914', '464915', '464917', '464918', '464919', '464920',
        '464920', '464921', '464922', '464923', '464926', '464967', '464975', '464978', '465027', '465061', '465111',
        '465158', '465159', '465159', '465160', '465160', '465161', '465161', '465202', '465203', '465208', '465210',
        '465236', '465237', '465248', '465248', '465249', '465279', '465282', '465290', '465314', '465317', '465317',
        '465341', '465342', '465364', '465365', '465366', '465376', '465377', '465378', '465380', '465381', '465382',
        '465390', '465399', '465400', '465400', '465402', '465402', '465404', '465430', '465486', '465486', '465490',
        '465558', '465559', '465560', '465561', '465562', '465563', '465625', '465686', '465686', '465688', '465693',
        '465696', '465696', '465696', '465697', '465698', '465698', '465698', '465698', '465698', '465698', '465699',
        '465700', '465701', '465702', '465703', '465704', '465704', '465704', '465705', '465707', '465708', '465728',
        '465728', '465728', '465730', '465760', '465760', '465777', '465812', '465813', '465822', '465855', '465889',
        '465946', '465952', '465959', '465981', '466071', '466130', '466132', '466132', '466149', '466150', '466151',
        '466152', '466153', '466154', '466154', '466171', '466183', '466187', '466224', '466225', '466268', '466269',
        '466270', '466271', '466271', '466272', '466273', '466274', '466289', '466290', '466291', '466292', '466299',
        '466320', '466329', '466329', '466329', '466329', '466329', '466329', '466329', '466329', '466329', '466329',
        '466329', '466329', '466329', '466329', '466391', '466462', '466488', '466526', '466526', '466529', '466631',
        '466728', '466884', '466885', '466886', '466895', '466896', '466920', '466924', '466924', '466925', '466925',
        '466925', '466942', '466947', '466948', '466949', '466950', '466951', '466952', '466953', '466955', '466956',
        '466979', '466988', '466993', '466997', '466998', '466999', '467073', '467074', '467075', '467076', '467078',
        '467115', '467116', '467127', '467127', '467128', '467157', '467157', '467166', '467172', '467174', '467186',
        '467211', '467211', '467212', '467212', '467212', '467213', '467214', '467224', '467224', '467225', '467225',
        '467226', '467226', '467249', '467253', '467253', '467254', '467255', '467255', '467256', '467256', '467257',
        '467257', '467258', '467258', '467259', '467259', '467260', '467280', '467282', '467284', '467297', '467352',
        '467372', '467372', '467372', '467411', '467412', '467413', '467414', '467415', '467428', '467429', '467459',
        '467468', '467485', '467504', '467651', '467662', '467663', '467663', '467664', '467664', '467665', '467665',
        '467667', '467668', '467670', '467671', '467672', '467672', '467672', '467674', '467675', '467676', '467685',
        '467696', '467697', '467698', '467699', '467718', '467718', '467720', '467720', '467721', '467724', '467733',
        '467738', '467752', '467752', '467763', '467764', '467764', '467765', '467767', '467768', '467769', '467769',
        '467770', '467770', '467771', '467790', '467791', '467792', '467793', '467797', '467798', '467799', '467800',
        '467801', '467802', '467803', '467807', '467815', '467817', '467820', '467821', '467822', '467823', '467827',
        '467827', '467827', '467827', '467827', '467828', '467828', '467828', '467828', '467828', '467828', '467828',
        '467828', '467828', '467828', '467832', '467843', '467843', '467844', '467844', '467845', '467846', '467853',
        '467853', '467854', '467854', '467855', '467855', '467856', '467856', '467857', '467858', '467859', '467868',
        '467868', '467869', '467869', '467870', '467870', '467871', '467871', '467879', '467879', '467879', '467880',
        '467880', '467880', '467880', '467911', '467912', '467913', '467917', '467927', '467928', '467929', '467930',
        '467931', '467932', '467933', '467939', '467939', '467978', '467981', '467986', '467993', '467993', '467999',
        '467999', '468001', '468002', '468002', '468003', '468051', '468052', '468067', '468068', '468083', '468083',
        '468083', '468133', '468187', '468187', '468318', '468319', '468324', '468324', '468324', '468324', '468324',
        '468324', '468324', '468327', '468339', '468347', '468348', '468370', '468370', '468411', '468437', '468698',
        '468755', '468756', '468756', '468756', '468757', '468757', '468757', '468798', '468798', '468798', '469112',
        '469463', '469542', '469544', '469545', '469578', '469578', '469579', '469580', '469581', '469585', '469586',
        '469587', '469589', '469589', '469590', '469591', '469591', '469592', '469592', '469593', '469593', '469593',
        '469594', '469594', '469595', '469595', '469596', '469597', '469598', '469598', '469598', '469598', '469598',
        '469598', '469599', '469599', '469601', '469603', '469603', '469603', '469604', '469607', '469609', '469611',
        '469613', '469614', '469615', '469616', '469617', '469619', '469620', '469621', '469625', '469625', '469628',
        '469630', '469646', '469668', '469669', '469670', '469671', '469672', '469673', '469674', '469675', '469677',
        '469678', '469687', '469768', '469769', '469769', '469769', '469782', '469783', '469785', '469785', '470170',
        '470229', '470613', '470640', '470642', '470659', '470660', '470660', '470661', '470661', '470669', '470750',
        '470752', '470754', '470759', '470760', '470837', '470838', '470842', '470852', '470856', '470859', '470863',
        '470864', '470865', '470866', '470867', '470868', '470869', '470870', '470871', '470872', '470873', '470876',
        '470878', '470879', '470880', '470881', '470882', '470938', '470938', '470939', '470939', '471007', '471009',
        '471011', '471019', '471028', '471030', '471038', '471084', '471186', '471342', '471343', '471346', '471346',
        '471346', '471351', '471351', '471351', '471351', '471351', '471354', '471355', '471356', '471394', '471394',
        '471394', '471394', '471426', '471431', '471432', '471433', '471434', '471435', '471436', '471487', '471487',
        '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487',
        '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487',
        '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487',
        '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487', '471487',
        '471488', '471488', '471488', '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489',
        '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489',
        '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489',
        '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489', '471489',
        '471492', '471511', '471526', '471526', '471535', '471535', '471536', '471563', '471629', '471629', '471630',
        '471631', '471632', '471633', '471634', '471635', '471636', '471637', '471638', '471639', '471640', '471641',
        '471642', '471643', '471643', '471643', '471644', '471647', '471648', '471649', '471650', '471652', '471660',
        '471666', '471678', '471679', '471679', '471681', '471682', '471683', '471684', '471688', '471689', '471690',
        '471704', '471708', '471709', '471710', '471726', '471801', '471804', '471829', '471852', '471853', '471875',
        '471875', '471876', '471878', '471879', '471924', '471924', '471925', '471925', '471926', '471926', '471927',
        '471927', '471929', '471930', '471930', '471931', '471940', '471944', '471944', '471945', '471945', '471947',
        '471950', '471951', '471955', '471968', '471970', '471971', '471991', '471991', '472048', '472101', '472102',
        '472239', '472480', '472480', '472480', '472485', '472485', '472493', '472493', '472560', '472560', '472599',
        '472600', '472600', '472600', '472601', '472602', '472613', '472708', '472717', '472718', '472719', '472759',
        '472794', '472794', '472795', '472795', '472796', '472796', '472800', '472801', '472801', '472802', '472803',
        '472811', '472819', '472856', '472859', '472860', '472861', '472862', '472875', '472921', '472957', '472957',
        '472957', '472957', '472962', '472962', '472971', '472972', '472972', '472975', '473013', '473037', '473057',
        '473084', '473101', '473102', '473124', '473131', '473132', '473188', '473191', '473192', '473201', '473202',
        '473221', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224',
        '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224',
        '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224',
        '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224',
        '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224',
        '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224',
        '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224',
        '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224',
        '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224',
        '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224', '473224',
        '473224', '473224', '473224', '473227', '473259', '473259', '473269', '473313', '473322', '473367', '473368',
        '473368', '473376', '473376', '473379', '473381', '473382', '473394', '473446', '473457', '473560', '473566',
        '473569', '473570', '473572', '473611', '473614', '473653', '473655', '473663', '473663', '473663', '473664',
        '473666', '473703', '473712', '473721', '473762', '473762', '473785', '473820', '473836', '473846', '473846',
        '473847', '473847', '473895', '473895', '473896', '473896', '473910', '473911', '473912', '473913', '473914',
        '473915', '473916', '473917', '473918', '473919', '473920', '473921', '473922', '473950', '473951', '473952',
        '473955', '473956', '473957', '473958', '473958', '473960', '473960', '473961', '473961', '473964', '473964',
        '473965', '473965', '473966', '473966', '473967', '473967', '473968', '473968', '473968', '473968', '473969',
        '473969', '474007', '474007', '474010', '474010', '474011', '474011', '474012', '474012', '474013', '474013',
        '474013', '474014', '474015', '474015', '474016', '474016', '474017', '474017', '474017', '474027', '474028',
        '474029', '474034', '474035', '474036', '474041', '474043', '474044', '474045', '474046', '474068', '474084',
        '474084', '474085', '474086', '474087', '474088', '474088', '474088', '474089', '474089', '474089', '474090',
        '474090', '474091', '474091', '474091', '474092', '474092', '474094', '474098', '474098', '474142', '474144',
        '474146', '474148', '474149', '474150', '474152', '474153', '474154', '474156', '474157', '474158', '474159',
        '474164', '474171', '474171', '474171', '474177', '474185', '474185', '474186', '474186', '474234', '474234',
        '474253', '474254', '474254', '474255', '474255', '474256', '474257', '474258', '474259', '474260', '474261',
        '474262', '474263', '474286', '474294', '474306', '474306', '474307', '474307', '474308', '474308', '474308',
        '474309', '474309', '474309', '474338', '474338', '474338', '474339', '474339', '474342', '474342', '474342',
        '474344', '474345', '474427', '474444', '474445', '474446', '474446', '474460', '474461', '474478', '474478',
        '474482', '474483', '474504', '474505', '474506', '474507', '474557', '474599', '474599', '474609', '474628',
        '474651', '474661', '474693', '474694', '474705', '474705', '474707', '474707', '474727', '474732', '474735',
        '474737', '474825', '474825', '474826', '474910', '474916', '474950', '474958', '474959', '474989', '474989',
        '475170', '475183', '475215', '475236', '475304', '475305', '475313', '475321', '475323', '475323', '475391',
        '475392', '475393', '475490', '475490', '475490', '475614', '475614', '475615', '475615', '475616', '475616',
        '475648', '475699', '475707', '475707', '475732', '475740', '475760', '475761', '475762', '475763', '475764',
        '475765', '475766', '475767', '475768', '475788', '475790', '475791', '475797', '475832', '475936', '475967',
        '475993', '475993', '475993', '475999', '476007', '476037', '476038', '476038', '476038', '476038', '476047',
        '476047', '476047', '476047', '476162', '476397', '476397', '476416', '476416', '476416', '476418', '476453',
        '476481', '476482', '476483', '476494', '476495', '476496', '476500', '476501', '476502', '476506', '476507',
        '476510', '476511', '476512', '476513', '476530', '476546', '476546', '476546', '476547', '476547', '476547',
        '476813', '476837', '545021', '545026', '545038', '545079', '545113', '545114', '545118', '545119', '545120',
        '545135', '545135', '545135', '545182', '545209', '545210', '545211', '545223', '545242', '545274', '545283',
        '545294', '545319', '545334', '545336', '545337', '545337', '545338', '545340', '545350', '545350', '545350',
        '545350', '545352', '545354', '545355', '545356', '545357', '545357', '545358', '545358', '545358', '545359',
        '545359', '545359', '545360', '545360', '545360', '545361', '545361', '545362', '545365', '545365', '545366',
        '545368', '545374', '545376', '545376', '545390', '545392', '545395', '545398', '545401', '545401', '545417',
        '545420', '545421', '545428', '545430', '545430', '545431', '545433', '545435', '545438', '545439', '545440',
        '545441', '545443', '545447', '545453', '545456', '545457', '545459', '545463', '545463', '545465', '545466',
        '545466', '545467', '545468', '545468', '545492', '545495', '545505', '545507', '545508', '545514', '545515',
        '545521', '545523', '545543', '545551', '545551', '545555', '545561', '545561', '545565', '545567', '545569',
        '545570', '545572', '545575', '545583', '545584', '545586', '545597', '545598', '545599', '545600', '545601',
        '545602', '545607', '545607', '545609', '545617', '545617', '545626', '545626', '545632', '545639', '545641',
        '545641', '545641', '545642', '545644', '545647', '545657', '545658', '545659', '545665', '545666', '545666',
        '545666', '545671', '545672', '545679', '545680', '545684', '545688', '545707', '545715', '545715', '545719',
        '545719', '545775', '545776', '545778', '545778', '545780', '545800', '545803', '545812', '545812', '545812',
        '545819', '545828', '545830', '545847', '545847', '545854', '545854', '545857', '545858', '545859', '545860',
        '545860', '545861', '545863', '545866', '545867', '545872', '545876', '545885', '545895', '545896', '545898',
        '545899', '545901', '545902', '545917', '545918', '545919', '545920', '545923', '545924', '545932', '545934',
        '545943', '545945', '545945', '545949', '545950', '545950', '545953', '545953', '545967', '545969', '545969',
        '545970', '546042', '546042', '546044', '546044', '546046', '546046', '546046', '546048', '546048', '546049',
        '546049', '546051', '546051', '546053', '546053', '546055', '546055', '546056', '546056', '546057', '546057',
        '546058', '546076', '546076', '546076', '546122', '546140', '546140', '546140', '546140', '546140', '546143',
        '546199', '546217', '546218', '546219', '546220', '546284', '546336', '546384', '546387', '546388', '546406',
        '546429', '546430', '546431', '546489', '546557', '546684', '546686', '546687', '546688', '546866', '546866',
        '546867', '546867', '547143', '547144', '547227', '547260', '547284', '547284', '547284', '547306', '547307',
        '547309', '547311', '547332', '547346', '547350', '547353', '547353', '547363', '547444', '547526', '547610',
        '547610', '547610', '547619', '547620', '547651', '547785', '547785', '547785', '548261', '548261', '548262',
        '548262', '548534', '548632', '548697', '548697', '548807', '548807', '548807', '548807', '548877', '548899',
        '548948', '548977', '548995', '549051', '549051', '549052', '549063', '549063', '549080', '549143', '549143',
        '549144', '549232', '549232', '549233', '549233', '549233', '549234', '549234', '549235', '549235', '549235',
        '549236', '549236', '549263', '549263', '549263', '549321', '549326', '549368', '549369', '549371', '549406',
        '549464', '549515', '549515', '549515', '549564', '549565', '549674', '549675', '549822', '549873', '549873',
        '549875', '549890', '549890', '549902', '549903', '549903', '549904', '549905', '549905', '549920', '549920',
        '549921', '549921', '549925', '549925', '549926', '549926', '549928', '549928', '549930', '549930', '549931',
        '549938', '549950', '549951', '549952', '549952', '549953', '549953', '549957', '549958', '549959', '549960',
        '549961', '550012', '550012', '550013', '550013', '550017', '550017', '550022', '550022', '550023', '550023',
        '550025', '550028', '550029', '550030', '550031', '550032', '550033', '550033', '550037', '550038', '550043',
        '550044', '550045', '550046', '550047', '550048', '550049', '550050', '550051', '550052', '550082', '550090',
        '550091', '550118', '550140', '550154', '550249', '550250', '550252', '550258', '550265', '550272', '550377',
        '550389', '550408', '550408', '550411', '550508', '550517', '550533', '550533', '550534', '550534', '550535',
        '550535', '550541', '550551', '550613', '550616', '550625', '550645', '550647', '550647', '550647', '550738',
        '550744', '550771', '550773', '550779', '550781', '550782', '550787', '550788', '550789', '550821', '550885',
        '550886', '550886', '550888', '550898', '550898', '550907', '550908', '550909', '550976', '551030', '551031',
        '551031', '551062', '551071', '551071', '551072', '551073', '551074', '551076', '551125', '551153', '551154',
        '551179', '551233', '551234', '551235', '551236', '551238', '551239', '551240', '551241', '551242', '551243',
        '551251', '551253', '551254', '551255', '551256', '551256', '551257', '551257', '551258', '551264', '551276',
        '551286', '551290', '551291', '551292', '551293', '551294', '551295', '551296', '551297', '551298', '551299',
        '551300', '551301', '551302', '551303', '551304', '551305', '551308', '551309', '551310', '551310', '551311',
        '551312', '551313', '551314', '551315', '551317', '551319', '551320', '551321', '551324', '551325', '551326',
        '551327', '551328', '551329', '551329', '551340', '551341', '551342', '551348', '551349', '551350', '551351',
        '551353', '551354', '551356', '551357', '551358', '551359', '551360', '551361', '551386', '551387', '551388',
        '551398', '551404', '551404', '551405', '551405', '551406', '551408', '551409', '551410', '551411', '551413',
        '551414', '551415', '551416', '551417', '551418', '551427', '551427', '551430', '551440', '551440', '551461',
        '551462', '551463', '551464', '551465', '551466', '551472', '551473', '551475', '551476', '551477', '551478',
        '551479', '551480', '551481', '551482', '551483', '551484', '551485', '551486', '551487', '551488', '551489',
        '551490', '551491', '551492', '551493', '551493', '551500', '551501', '551502', '551503', '551505', '551507',
        '551508', '551509', '551510', '551511', '551513', '551516', '551518', '551523', '551524', '551525', '551527',
        '551531', '551531', '551532', '551532', '551534', '551535', '551539', '551540', '551541', '551541', '551542',
        '551542', '551544', '551545', '551546', '551547', '551548', '551549', '551552', '551567', '551569', '551578',
        '551579', '551580', '551581', '551583', '551584', '551585', '551586', '551587', '551588', '551607', '551607',
        '551613', '551614', '551615', '551616', '551618', '551620', '551621', '551623', '551624', '551625', '551632',
        '551644', '551645', '551646', '551647', '551648', '551695', '551696', '551697', '551708', '551708', '551708',
        '551709', '551720', '551721', '551733', '551741', '551756', '551756', '551759', '551759', '551760', '551760',
        '551760', '551761', '551762', '551763', '551764', '551765', '551766', '551767', '551768', '551769', '551771',
        '551772', '551773', '551774', '551775', '551775', '551776', '551777', '551778', '551779', '551780', '551783',
        '551784', '551793', '551794', '551795', '551796', '551797', '551798', '551801', '551802', '551803', '551804',
        '551809', '551810', '551812', '551813', '551817', '551818', '551820', '551821', '551822', '551823', '551824',
        '551825', '551826', '551827', '551828', '551829', '551830', '551831', '551832', '551833', '551834', '551835',
        '551836', '551837', '551838', '551839', '551840', '551841', '551842', '551843', '551844', '551845', '551847',
        '551848', '551849', '551852', '551853', '551854', '551855', '551856', '551857', '551858', '551859', '551860',
        '551861', '551862', '551878', '551879', '551880', '551882', '551883', '551884', '551885', '551886', '551887',
        '551888', '551894', '551895', '551896', '551897', '551898', '551899', '551900', '551901', '551902', '551905',
        '551906', '551907', '551908', '551909', '551910', '551911', '551913', '551915', '551916', '551917', '551918',
        '551920', '551921', '551922', '551923', '551925', '551926', '551933', '551934', '551935', '551936', '551937',
        '551938', '551939', '551940', '551941', '551942', '551943', '551944', '551945', '551946', '551947', '551948',
        '551960', '551961', '551962', '551963', '551964', '551965', '551966', '551967', '551968', '551969', '551970',
        '551981', '551987', '551988', '551989', '551997', '551998', '551999', '552001', '552002', '552004', '552005',
        '552006', '552007', '552008', '552009', '552010', '552011', '552014', '552016', '552017', '552019', '552020',
        '552023', '552038', '552039', '552040', '552055', '552056', '552057', '552058', '552059', '552060', '552063',
        '552064', '552065', '552066', '552067', '552068', '552069', '552070', '552071', '552072', '552073', '552073',
        '552074', '552086', '552092', '552092', '552118', '552127', '552128', '552129', '552130', '552131', '552132',
        '552148', '552156', '552156', '552157', '552158', '552164', '552172', '552173', '552176', '552200', '552209',
        '552211', '552216', '552217', '552218', '552219', '552220', '552240', '552240', '552240', '552242', '552247',
        '552247', '552248', '552248', '552250', '552272', '552293', '552296', '552297', '552302', '552338', '552338',
        '552339', '552339', '552340', '552340', '552341', '552367', '552367', '552393', '552394', '552395', '552415',
        '552441', '552441', '552442', '552442', '552443', '552443', '552496', '552514', '552514', '552514', '552543',
        '552546', '552546', '552546', '552555', '552556', '552603', '552603', '552603', '552604', '552604', '552604',
        '552604', '552604', '552605', '552605', '552605', '552605', '552626', '552659', '552659', '552692', '552692',
        '552693', '552694', '552701', '552718', '552739', '552740', '552741', '552742', '552743', '552745', '552746',
        '552785', '552806', '552807', '552821', '552822', '552827', '552830', '552836', '552861', '552861', '552862',
        '552862', '552906', '552936', '552940', '552970', '553001', '553058', '553075', '553106', '553106', '553106',
        '553106', '553118', '553141', '553147', '553148', '553149', '553157', '553157', '553158', '553158', '553158',
        '553158', '553159', '553171', '553172', '553172', '553173', '553175', '553176', '553176', '553176', '553176',
        '553177', '553177', '553206', '553211', '553211', '553212', '553214', '553215', '553216', '553216', '553231',
        '553231', '553231', '553231', '553231', '553233', '553234', '553235', '553240', '553244', '553245', '553245',
        '553247', '553250', '553272', '553272', '553273', '553284', '553305', '553322', '553325', '553332', '553342',
        '553358', '553359', '553360', '553361', '553369', '553375', '553389', '553392', '553447', '553447', '553447',
        '553448', '553448', '553451', '553452', '553453', '553462', '553470', '553471', '553471', '553530', '553535',
        '553546', '553547', '553548', '553549', '553571', '553582', '553617', '553623', '553630', '553631', '553632',
        '553633', '553634', '553635', '553635', '553635', '553636', '553636', '553637', '553643', '553644', '553645',
        '553646', '553646', '553647', '553669', '553676', '553677', '553678', '553678', '553678', '553797', '553798',
        '553799', '553800', '553801', '553832', '553833', '553834', '553851', '553861', '553918', '553919', '553923',
        '553923', '553924', '553929', '553933', '553936', '553938', '553986', '554009', '554010', '554071', '554100',
        '554120', '554120', '554175', '554187', '554187', '554187', '554194', '554236', '554237', '554238', '554308',
        '554329', '554348', '554386', '554401', '554410', '554410', '554410', '554410', '554410', '554410', '554410',
        '554519', '554551', '554581', '554581', '554647', '554655', '554659', '554691', '554694', '554711', '554712',
        '554713', '554714', '554715', '554762', '554762', '554771', '554772', '554773', '554774', '554775', '554777',
        '554783', '554784', '554785', '554803', '554804', '554805', '554815', '554816', '554817', '554840', '554848',
        '554849', '554850', '554860', '554863', '554905', '554905', '554908', '554947', '555080', '555081', '555082',
        '555103', '555201', '555280', '555285', '555326', '555327', '555328', '555345', '555356', '555360', '555361',
        '555369', '555369', '555370', '555383', '555387', '555428', '555454', '555493', '555494', '555495', '555502',
        '555503', '555504', '555565', '555566', '555567', '555568', '555569', '555570', '555571', '555572', '555573',
        '555574', '555576', '555577', '555578', '555600', '555602', '555649', '555681', '555682', '555715', '555729',
        '555730', '555734', '555735', '555736', '555737', '555737', '555738', '555739', '555774', '555775', '555826',
        '555827', '555828', '555829', '555830', '555831', '555832', '555833', '555834', '555835', '555837', '555842',
        '555843', '555844', '555845', '555846', '555864', '555866', '555868', '555869', '555870', '555871', '555872',
        '555873', '555874', '555875', '555876', '555877', '555877', '555878', '555879', '555880', '555881', '555883',
        '555886', '555889', '555892', '555892', '555897', '555898', '555912', '555912', '555926', '555928', '555930',
        '555931', '555967', '555967', '555990', '555991', '555991', '555991', '555991', '555991', '555991', '555991',
        '555998', '555998', '555998', '555998', '555998', '555998', '555998', '555998', '555998', '555999', '555999',
        '555999', '555999', '555999', '555999', '555999', '555999', '556000', '556002', '556003', '556003', '556020',
        '556021', '556022', '556036', '556036', '556036', '556036', '556036', '556036', '556036', '556036', '556036',
        '556036', '556036', '556040', '556048', '556114', '556121', '556122', '556123', '556124', '556125', '556126',
        '556127', '556128', '556129', '556130', '556136', '556137', '556151', '556155', '556239', '556255', '556256',
        '556257', '556257', '556257', '556306', '556306', '556313', '556338', '556340', '556388', '556390', '556391',
        '556395', '556513', '556592', '556593', '556593', '556594', '556674', '556679', '556688', '556691', '556702',
        '556706', '556719', '556730', '556745', '556746', '556748', '556810', '556811', '556812', '556836', '556837',
        '556843', '556844', '556845', '556846', '556865', '556866', '556876', '556877', '556896', '556911', '556912',
        '556916', '556916', '556917', '556920', '556925', '556944', '556986', '556986', '556986', '557011', '557012',
        '557013', '557014', '557020', '557047', '557077', '557101', '557139', '557139', '557139', '557214', '557215',
        '557216', '557218', '557233', '557234', '557237', '557238', '557239', '557240', '557282', '557282', '557282',
        '557282', '557282', '557282', '557282', '557282', '557282', '557306', '557306', '557306', '557306', '557307',
        '557307', '557307', '557378', '557402', '557404', '557418', '557419', '557479', '557510', '557511', '557519',
        '557520', '557521', '557522', '557547', '557555', '557556', '557557', '557566', '557567', '557568', '557571',
        '557572', '557573', '557574', '557575', '557576', '557580', '557581', '557582', '557591', '557592', '557593',
        '557593', '557594', '557594', '557595', '557595', '557615', '557616', '557617', '557621', '557622', '557623',
        '557625', '557631', '557632', '557634', '557635', '557636', '557637', '557640', '557641', '557642', '557643',
        '557644', '557645', '557647', '557648', '557649', '557653', '557654', '557655', '557665', '557668', '557669',
        '557671', '557672', '557674', '557675', '557676', '557677', '557684', '557685', '557686', '557687', '557688',
        '557694', '557695', '557696', '557697', '557698', '557700', '557701', '557702', '557703', '557704', '557704',
        '557736', '557760', '557761', '557766', '557769', '557770', '557789', '557789', '557796', '557800', '557800',
        '557800', '557800', '557800', '557800', '557800', '557800', '557800', '557800', '557819', '557852', '557855',
        '557856', '557863', '557933', '557933', '557948', '557949', '557952', '557954', '557955', '557958', '557977',
        '557986', '557986', '557986', '557994', '557996', '558027', '558027', '558046', '558046', '558047', '558048',
        '558049', '558050', '558073', '558074', '558099', '558100', '558105', '558118', '558268', '558273', '558302',
        '558302', '558303', '558304', '558305', '558306', '558307', '558308', '558310', '558320', '558321', '558322',
        '558323', '558324', '558325', '558337', '558340', '558356', '558365', '558487', '558488', '558537', '558538',
        '558539', '558561', '558561', '558579', '558580', '558581', '558583', '558584', '558636', '558637', '558637',
        '558656', '558659', '558659', '558660', '558719', '558729', '558743', '558769', '558770', '558810', '558817',
        '558818', '558819', '558863', '558891', '558893', '558895', '558902', '558903', '558904', '558904', '558904',
        '558904', '558904', '558905', '558905', '558906', '558906', '558910', '558910', '558924', '558930', '558936',
        '558936', '559001', '559002', '559002', '559002', '559029', '559031', '559041', '559044', '559052', '559081',
        '559083', '559084', '559085', '559089', '559089', '559089', '559094', '559097', '559099', '559101', '559111',
        '559112', '559115', '559115', '559116', '559181', '559181', '559207', '559208', '559208', '559232', '559236',
        '559241', '559246', '559337', '559354', '559395', '559399', '559549', '559557', '559564', '559566', '559567',
        '559613', '559627', '559627', '559627', '559627', '559628', '559629', '559630', '559697', '559697', '559717',
        '559729', '559745', '559748', '559766', '559771', '559772', '559781', '559782', '559783', '559825', '559826',
        '559827', '559867', '559868', '559869', '559870', '559871', '559872', '559887', '559889', '559910', '559935',
        '559935', '559951', '559958', '559959', '559959', '559961', '560033', '560033', '560131', '560132', '560134',
        '560135', '560136', '560153', '560154', '560155', '560164', '560174', '560178', '560179', '560188', '560232',
        '560262', '560298', '560323', '560347', '560365', '560380', '560382', '560387', '560388', '560396', '560424',
        '560424', '560440', '560440', '560440', '560440', '560443', '560497', '560508', '560508', '560508', '560508',
        '560508', '560519', '560539', '560539', '560539', '560539', '560539', '560558', '560561', '560579', '560579',
        '560580', '560580', '560580', '560580', '560581', '560581', '560585', '560589', '560589', '560589', '560589',
        '560610', '560610', '560610', '560646', '560656', '560656', '560657', '560659', '560660', '560662', '560664',
        '560665', '560685', '560685', '560685', '560685', '560685', '560685', '560685', '560685', '560685', '560685',
        '560685', '560685', '560685', '560685', '560685', '560686', '560686', '560686', '560686', '560686', '560686',
        '560693', '560693', '560693', '560693', '560694', '560747', '560759', '560776', '560776', '560820', '560821',
        '560822', '560824', '560842', '560843', '560855', '560859', '560866', '560867', '560892', '560893', '560947',
        '560976', '560976', '560976', '560976', '560976', '560976', '560976', '560976', '560983', '560984', '560993',
        '560995', '560997', '561020', '561021', '561028', '561029', '561030', '561031', '561035', '561035', '561043',
        '561043', '561043', '561049', '561050', '561077', '561077', '561078', '561078', '561079', '561081', '561082',
        '561083', '561084', '561084', '561098', '561100', '561109', '561110', '561126', '561129', '561130', '561135',
        '561138', '561139', '561146', '561146', '561146', '561146', '561146', '561146', '561147', '561148', '561149',
        '561157', '561157', '561157', '561157', '561157', '561176', '561187', '561192', '561192', '561192', '561198',
        '561198', '561198', '561198', '561198', '561198', '561204', '561224', '561224', '561224', '561224', '561224',
        '561233', '561233', '561233', '561238', '561239', '561240', '561241', '561257', '561257', '561257', '561258',
        '561264', '561265', '561266', '561267', '561269', '561271', '561272', '561273', '561299', '561300', '561319',
        '561323', '561324', '561324', '561326', '561354', '561361', '561362', '561363', '561364', '561365', '561366',
        '561382', '561393', '561394', '561424', '561424', '561424', '561426', '561433', '561434', '561442', '561446',
        '561462', '561475', '561532', '561554', '561554', '561562', '561562', '561562', '561590', '561591', '561593',
        '561593', '561596', '561600', '561604', '561605', '561606', '561607', '561628', '561630', '561630', '561639',
        '561646', '561648', '561650', '561664', '561665', '561665', '561665', '561665', '561667', '561706', '561709',
        '561710', '561749', '561777', '561789', '561794', '561802', '561818', '561844', '561923', '561923', '561958',
        '561967', '561974', '561983', '561986', '561986', '562009', '562010', '562011', '562012', '562036', '562066',
        '562123', '562126', '562126', '562127', '562189', '562204', '562206', '562235', '562242', '562293', '562294',
        '562300', '562300', '562300', '562307', '562308', '562312', '562326', '562354', '562398', '562534', '562556',
        '562556', '562556', '562557', '562629', '562630', '562631', '562632', '562636', '562643', '562645', '562646',
        '562647', '562659', '562681', '562707', '562734', '562735', '562736', '562747', '562888', '562889', '562890',
        '562891', '562892', '562893', '562894', '562895', '562917', '562927', '562928', '562929', '562963', '562974',
        '562976', '562981', '562996', '563000', '563001', '563002', '563040', '563049', '563094', '563098', '563099',
        '563099', '563134', '563135', '563161', '563164', '563177', '563206', '563211', '563250', '563252', '563293',
        '563296', '563321', '563322', '563323', '563327', '563341', '563349', '563352', '563356', '563356', '563357',
        '563429', '563430', '563431', '563437', '563438', '563459', '563464', '563483', '563487', '563490', '563491',
        '563497', '563498', '563508', '563522', '563538', '563539', '563541', '563541', '563542', '563543', '563547',
        '563548', '563558', '563561', '563562', '563563', '563564', '563587', '563587', '563601', '563601', '563601',
        '563601', '563601', '563601', '563606', '563615', '563615', '563617', '563617', '563618', '563621', '563627',
        '563629', '563645', '563647', '563660', '563660', '563661', '563661', '563662', '563668', '563669', '563669',
        '563669', '563703', '563703', '563725', '563798', '563842', '563846', '563884', '563963', '564076', '564077',
        '564086', '564167', '564168', '564169', '564195', '564256', '564269', '564312', '564312', '564389', '564461',
        '564466', '564478', '564486', '564515', '564580', '564626', '564810', '564858', '565036', '565094', '565096',
        '565097', '565121', '565168', '565171', '565387', '565647', '565647', '565647', '565659', '565666', '565666',
        '565743', '565746', '565769', '565772', '565774', '565835', '565839', '565914', '565915', '565957', '565976',
        '565977', '565988', '565991', '566041', '566370', '566370', '566370', '566524', '566554', '566619', '566619',
        '566619', '566660', '566677', '566678', '566679', '566680', '566682', '566683', '566736', '566736', '566737',
        '566737', '566738', '566738', '566750', '566754', '566755', '566757', '566758', '566760', '566788', '567326',
        '567327', '567328', '567425', '567425', '567425', '567425', '567425', '567430', '567432', '567553', '567554',
        '567555', '567556', '567616', '567674', '567715', '567716', '567718', '567731', '567731', '567731', '567781',
        '567782', '567932', '567933', '567934', '567935', '568060', '568108', '568108', '568108', '568109', '568494',
        '568494', '568494', '568528', '568672', '568673', '568676', '568703', '568825', '568848', '568849', '568850',
        '568951', '568952', '568953', '569078', '569082', '569084', '569150', '569150', '569150', '569157', '569157',
        '569157', '569158', '569158', '569158', '569159', '569159', '569159', '569189', '569215', '569296', '569319',
        '569320', '569320', '569323', '569323', '569326', '569326', '569346', '569346', '569346', '569356', '569358',
        '569360', '569360', '569360', '569458', '569459', '569459', '569459', '569460', '569460', '569477', '569479',
        '569480', '569486', '569496', '569507', '569508', '569509', '569510', '569511', '569512', '569513', '569514',
        '569515', '569516', '569517', '569518', '569519', '569520', '569524', '569568', '569569', '569588', '569588',
        '569773', '569807', '569808', '569810', '569811', '569812', '569816', '569864', '569864', '569864', '569864',
        '569885', '569911', '569911', '569913', '569926', '569962', '569993', '570026', '570026', '570093', '570141',
        '570141', '570168', '570289', '570295', '570300', '570302', '570308', '570309', '570309', '570309', '570350',
        '570352', '570353', '570384', '570385', '570390', '570391', '570472', '570472', '570618', '570619', '570662',
        '570669', '570682', '570731', '570740', '570743', '570749', '570800', '570803', '570837', '570852', '570852',
        '570881', '570928', '571024', '571027', '571027', '571044', '571073', '571139', '571140', '571147', '571558',
        '571642', '571645', '571646', '571646', '571646', '571822', '571822', '571822', '571823', '571823', '571823',
        '571824', '571824', '571824', '571852', '571852', '571852', '571854', '571854', '571854', '571855', '571855',
        '571855', '571913', '571973', '571984', '572017', '572037', '572045', '572046', '572060', '572083', '572083',
        '572083', '572083', '572084', '572084', '572085', '572086', '572087', '572143', '572150', '572157', '572158',
        '572159', '572160', '572161', '572162', '572164', '572164', '572165', '572165', '572169', '572170', '572172',
        '572173', '572188', '572189', '572190', '572191', '572192', '572193', '572194', '572195', '572196', '572219',
        '572220', '572221', '572222', '572231', '572233', '572234', '572235', '572236', '572239', '572249', '572251',
        '572251', '572276', '572281', '572281', '572296', '572319', '572319', '572430', '572469', '572474', '572475',
        '572487', '572487', '572612', '572612', '572661', '572662', '572662', '572662', '572663', '572666', '572670',
        '572671', '572672', '572715', '572717', '572717', '572717', '572734', '572734', '572753', '572754', '572757',
        '572758', '572761', '572761', '572761', '572764', '572765', '572766', '572778', '572802', '572803', '572805',
        '572809', '572809', '572837', '572881', '572883', '572884', '572988', '572997', '573001', '573064', '573065',
        '573067', '573091', '573092', '573100', '573100', '573100', '573101', '573183', '573184', '573192', '573216',
        '573216', '573216', '573217', '573217', '573217', '573218', '573235', '573288', '573314', '573345', '573635',
        '573635', '573653', '573659', '573719', '573804', '573962', '573962', '573962', '573962', '573962', '573962',
        '574024', '574025', '574026', '574027', '574036', '574048', '574048', '574055', '574067', '574086', '574095',
        '574178', '574189', '574215', '574284', '574359', '574405', '574436', '574443', '574444', '574447', '574447',
        '574449', '574449', '574532', '574532', '574534', '574536', '574537', '574655', '574656', '574692', '574692',
        '574692', '574692', '575065', '575065', '575071', '575071', '575078', '575090', '575090', '575090', '575092',
        '575092', '575092', '575092', '575092', '575092', '575093', '575093', '575093', '575093', '575093', '575093',
        '575124', '575139', '575156', '575174', '575176', '575177', '575178', '575184', '575185', '575187', '575190',
        '575191', '575192', '575193', '575213', '575238', '575239', '575239', '575239', '575240', '575240', '575240',
        '575302', '575303', '575312', '575313', '575313', '575313', '575313', '575313', '575389', '575390', '575391',
        '575392', '575475', '575476', '575489', '575496', '575501', '575503', '575519', '575521', '575526', '575538',
        '575539', '575540', '575545', '575546', '575553', '575554', '575555', '575556', '575556', '575556', '575556',
        '575559', '575562', '575564', '575565', '575566', '575587', '575588', '575597', '575599', '575599', '575615',
        '575619', '575621', '575621', '575632', '575633', '575633', '575633', '575666', '575683', '575683', '575683',
        '575683', '575702', '575716', '575717', '575718', '575719', '575720', '575723', '575736', '575740', '575740',
        '575740', '575740', '575741', '575742', '575743', '575752', '575753', '575755', '575756', '575767', '575769',
        '575770', '575779', '575779', '575779', '575779', '575779', '575779', '575786', '575786', '575786', '575787',
        '575787', '575803', '575808', '575809', '575809', '575809', '575810', '575810', '575810', '575810', '575811',
        '575821', '575821', '575821', '575821', '575822', '575823', '575823', '575823', '575823', '575828', '575829',
        '575832', '575832', '575833', '575834', '575834', '575835', '575839', '575841', '575842', '575851', '575852',
        '575853', '575854', '575856', '575879', '575880', '575881', '575888', '575889', '575890', '575903', '575904',
        '575907', '575927', '575945', '575945', '575945', '575970', '575971', '575971', '575974', '575974', '575995',
        '575998', '576013', '576016', '576017', '576018', '576026', '576033', '576033', '576048', '576049', '576060',
        '576080', '576082', '576108', '576149', '576149', '576150', '576150', '576150', '576150', '576161', '576161',
        '576198', '576198', '576214', '576214', '576229', '576230', '576243', '576245', '576246', '576306', '576312',
        '576317', '576324', '576325', '576326', '576338', '576338', '576339', '576340', '576353', '576356', '576356',
        '576356', '576358', '576358', '576359', '576364', '576364', '576367', '576383', '576384', '576386', '576387',
        '576389', '576395', '576405', '576405', '576405', '576406', '576451', '576456', '576456', '576456', '576457',
        '576457', '576471', '576510', '576523', '576523', '576524', '576525', '576525', '576528', '576528', '576553',
        '576553', '576555', '576555', '576568', '576570', '576574', '576574', '576574', '576575', '576575', '576575',
        '576575', '576579', '576579', '576580', '576587', '576612', '576623', '576624', '576625', '576627', '576628',
        '576657', '576658', '576659', '576663', '576678', '576678', '576679', '576679', '576679', '576679', '576680',
        '576681', '576681', '576688', '576689', '576691', '576692', '576694', '576695', '576697', '576705', '576707',
        '576707', '576707', '576707', '576708', '576709', '576709', '576714', '576714', '576720', '576720', '576720',
        '576720', '576720', '576743', '576748', '576754', '576756', '576757', '576761', '576762', '576763', '576763',
        '576771', '576782', '576783', '576787', '576788', '576789', '576790', '576813', '576814', '576814', '576814',
        '576853', '576854', '576854', '576855', '576861', '576913', '576917', '576918', '576918', '576918', '576918',
        '576921', '576922', '576922', '576930', '576937', '576941', '576957', '576965', '576972', '576976', '576981',
        '576982', '577025', '577041', '577042', '577059', '577059', '577060', '577104', '577105', '577106', '577111',
        '577112', '577113', '577116', '577116', '577116', '577117', '577120', '577120', '577133', '577135', '577136',
        '577137', '577138', '577139', '577140', '577141', '577142', '577154', '577175', '577178', '577180', '577180',
        '577180', '577180', '577180', '577180', '577212', '577212', '577214', '577215', '577215', '577215', '577215',
        '577243', '577250', '577277', '577336', '577385', '577388', '577392', '577396', '577400', '577400', '577402',
        '577402', '577417', '577425', '577430', '577430', '577431', '577433', '577434', '577435', '577436', '577438',
        '577439', '577440', '577441', '577445', '577447', '577448', '577449', '577450', '577461', '577464', '577465',
        '577482', '577498', '577498', '577532', '577534', '577534', '577534', '577536', '577540', '577544', '577565',
        '577579', '577589', '577590', '577591', '577592', '577619', '577620', '577644', '577645', '577687', '577713',
        '577719', '577756', '577763', '577764', '577778', '577778', '577779', '577816', '577816', '577816', '577817',
        '577819', '577821', '577821', '577835', '577837', '577864', '577892', '577892', '577900', '577923', '577934',
        '577985', '578019', '578044', '578048', '578051', '578051', '578099', '578099', '578147', '578148', '578154',
        '578203', '578204', '578231', '578235', '578237', '578248', '578249', '578256', '578257', '578258', '578264',
        '578266', '578354', '578354', '578371', '578374', '578471', '578473', '578474', '578475', '578477', '578483',
        '578489', '578490', '578520', '578521', '578522', '578523', '578524', '578531', '578550', '578560', '578562',
        '578563', '578564', '578567', '578576', '578578', '578630', '578634', '578636', '578637', '578638', '578639',
        '578640', '578658', '578659', '578660', '578661', '578676', '578676', '578677', '578678', '578679', '578680',
        '578681', '578682', '578685', '578686', '578705', '578706', '578707', '578708', '578715', '578716', '578735',
        '578757', '578760', '578774', '578774', '578839', '578840', '578840', '578840', '578841', '578841', '578841',
        '578841', '578990', '579079', '579080', '579081', '579090', '579174', '579182', '579184', '579184', '579185',
        '579185', '579186', '579262', '579269', '579276', '579277', '579278', '579292', '579294', '579295', '579296',
        '579300', '579303', '579304', '579305', '579306', '579307', '579308', '579309', '579310', '579311', '579312',
        '579349', '579350', '579351', '579368', '579369', '579370', '579386', '579399', '579399', '579400', '579410',
        '579451', '579494', '579499', '579500', '579501', '579521', '579522', '579523', '579536', '579537', '579538',
        '579539', '579540', '579551', '579558', '579561', '579562', '579581', '579589', '579590', '579591', '579593',
        '579597', '579598', '579599', '579601', '579614', '579795', '579798', '579799', '579809', '579810', '579830',
        '579853', '579867', '579933', '579934', '580018', '580018', '580018', '580020', '580023', '580024', '580040',
        '580041', '580042', '580055', '580056', '580057', '580058', '580059', '580090', '580092', '580093', '580140',
        '580142', '580162', '580163', '580164', '580171', '580172', '580173', '580190', '580201', '580221', '580222',
        '580234', '580240', '580242', '580260', '580260', '580288', '580296', '580297', '580299', '580299', '580299',
        '580350', '580363', '580371', '580374', '580374', '580439', '580439', '580440', '580440', '580455', '580460',
        '580460', '580460', '580461', '580500', '580500', '580554', '580555', '580556', '580558', '580567', '580567',
        '580569', '580569', '580570', '580578', '580579', '580580', '580581', '580624', '580719', '580725', '580737',
        '580758', '580760', '580763', '580765', '580786', '580808', '580811', '580812', '580883', '580892', '580908',
        '580908', '580908', '580908', '580912', '580914', '580969', '580970', '580971', '581030', '581209', '581210',
        '581216', '581218', '581231', '581231', '581232', '581239', '581242', '581244', '581319', '581327', '581327',
        '581341', '581342', '581359', '581360', '581361', '581370', '581424', '581430', '581431', '581434', '581443',
        '581450', '581452', '581453', '581475', '581475', '581481', '581486', '581487', '581489', '581498', '581528',
        '581604', '581728', '581728', '581728', '581728', '581728', '581740', '581765', '581765', '581823', '581824',
        '581825', '581880', '581929', '581930', '582013', '582014', '582047', '582047', '582047', '582102', '582105',
        '582105', '582105', '582105', '582132', '582178', '582179', '582186', '582189', '582189', '582191', '582191',
        '582192', '582192', '582199', '582200', '582205', '582207', '582215', '582218', '582219', '582220', '582246',
        '582246', '582246', '582256', '582257', '582277', '582320', '582321', '582323', '582324', '582325', '582326',
        '582339', '582340', '582427', '582448', '582450', '582469', '582470', '582471', '582476', '582477', '582479',
        '582485', '582486', '582487', '582488', '582488', '582489', '582490', '582496', '582497', '582498', '582501',
        '582502', '582503', '582503', '582507', '582508', '582511', '582518', '582522', '582525', '582525', '582526',
        '582527', '582528', '582552', '582553', '582555', '582556', '582597', '582630', '582666', '582678', '582688',
        '582689', '582715', '582716', '582717', '582718', '582726', '582728', '582732', '582732', '582733', '582733',
        '582733', '582734', '582735', '582744', '582763', '582763', '582764', '582765', '582766', '582766', '582766',
        '582841', '582877', '582891', '582892', '582893', '582907', '582984', '583022', '583039', '583079', '583097',
        '583166', '583184', '583207', '583238', '583300', '583461', '583461', '583462', '583462', '583475', '583475',
        '583476', '583476', '583520', '583635', '583636', '583637', '583640', '583709', '583743', '583753', '583795',
        '583798', '583901', '583972', '583991', '583992', '583993', '584003', '584019', '584019', '584115', '584170',
        '584196', '584224', '584260', '584312', '584317', '584376', '584474', '584510', '584540', '584541', '584542',
        '584549', '584552', '584553', '584555', '584555', '584563', '584566', '584567', '584569', '584570', '584571',
        '584572', '584573', '584713', '584912', '584914', '584915', '584916', '584917', '584918', '584937', '585056',
        '585091', '585158', '585159', '585226', '585262', '585263', '585264', '585389', '585406', '585421', '585488',
        '585489', '585599', '585696', '585696', '585880', '585881', '585882', '585883', '585884', '585962', '586009',
        '586062', '586068', '586069', '586070', '586071', '586072', '586073', '586083', '586196', '586289', '586526',
        '586527', '586528', '586621', '586621', '586682', '586702', '586752', '586756', '586817', '586841', '586841',
        '586861', '586864', '587053', '587186', '587205', '587209', '587212', '587215', '587239', '587240', '587274',
        '587309', '587336', '587358', '587360', '587723', '587739', '587795', '587796', '587798', '587820', '587821',
        '587898', '587899', '587900', '587902', '587903', '587943', '587945', '588014', '588017', '588038', '588039',
        '588157', '588252', '588271', '588314', '588314', '588314', '588322', '588377', '588398', '588519', '588529',
        '588529', '588537', '588604', '588637', '588638', '588683', '588689', '588760', '588798', '588811', '588812',
        '588815', '588839', '588842', '588853', '588868', '588869', '588870', '588871', '588894', '588899', '588900',
        '588904', '588907', '588931', '588932', '588933', '588958', '588970', '588975', '588977', '588983', '588999',
        '588999', '589000', '589001', '589003', '589003', '589008', '589013', '589014', '589024', '589028', '589029',
        '589033', '589035', '589036', '589037', '589048', '589079', '589080', '589088', '589089', '589100', '589101',
        '589102', '589110', '589114', '589115', '589123', '589124', '589125', '589126', '589127', '589128', '589129',
        '589148', '589163', '589165', '589166', '589168', '589169', '589171', '589172', '589173', '589184', '589185',
        '589203', '589204', '589205', '589206', '589207', '589208', '589209', '589210', '589211', '589212', '589213',
        '589215', '589216', '589234', '589235', '589236', '589243', '589245', '589246', '589249', '589250', '589251',
        '589252', '589253', '589254', '589256', '589257', '589258', '589266', '589267', '589268', '589269', '589270',
        '589271', '589272', '589273', '589322', '589323', '589327', '589328', '589329', '589330', '589335', '589336',
        '589373', '589375', '589385', '589390', '589407', '589410', '589412', '589413', '589414', '589415', '589416',
        '589417', '589418', '589419', '589420', '589421', '589423', '589424', '589425', '589426', '589427', '589428',
        '589429', '589430', '589431', '589432', '589433', '589440', '589441', '589454', '589457', '589458', '589459',
        '589460', '589463', '589478', '589485', '589487', '589488', '589513', '589583', '589583', '589584', '589585',
        '589585', '589591', '589602', '589602', '589603', '589604', '589606', '589607', '589608', '589608', '589609',
        '589610', '589611', '589624', '589719', '589721', '589744', '589767', '589768', '589770', '589771', '589772',
        '589773', '589776', '589781', '589783', '589784', '589785', '589786', '589799', '589800', '589801', '589809',
        '589826', '589830', '589831', '589832', '589833', '589838', '589840', '589853', '589873', '589874', '589875',
        '589879', '589883', '589886', '589888', '589909', '589911', '589914', '589915', '589922', '589927', '589983',
        '589985', '589986', '589988', '589990', '589991', '590065', '590138', '590138', '590151', '590159', '590159',
        '590162', '590162', '590168', '590168', '590227', '590237', '590239', '590279', '590280', '590284', '590303',
        '590310', '590311', '590313', '590328', '590364', '590437', '590455', '590550', '590598', '590600', '590608',
        '590671', '590754', '590757', '590900', '590931', '591013', '591126', '591319', '591412', '591412', '591412',
        '591412', '591412', '591412', '591412', '591412', '591412', '591412', '591412', '591412', '591412', '591412',
        '591412', '591412', '591412', '591412', '591412', '591412', '591412', '591412', '591412', '591434', '591484',
        '591485', '591486', '591487', '591490', '591588', '591588', '591588', '591603', '591632', '591668', '591670',
        '591671', '591672', '591674', '591674', '591674', '591730', '591741', '591751', '591753', '591790', '591814',
        '591815', '591881', '591882', '591886', '591896', '591935', '591936', '591937', '591938', '591983', '592000',
        '592016', '592044', '592072', '592108', '592108', '592108', '592108', '592112', '592124', '592126', '592127',
        '592200', '592216', '592232', '592249', '592338', '592346', '592347', '592375', '592384', '592455', '592466',
        '592484', '592497', '592501', '592502', '592514', '592574', '592576', '592587', '592593', '592600', '592605',
        '592667', '592678', '592688', '592711', '592752', '592753', '592755', '592778', '592790', '592815', '592855',
        '592856', '592857', '592858', '592882', '592898', '592899', '592900', '592902', '592905', '592907', '592908',
        '592943', '592945', '592946', '592952', '592953', '592961', '592964', '592977', '592986', '593049', '593058',
        '593076', '593077', '593097', '593100', '593104', '593105', '593106', '593108', '593194', '593227', '593259',
        '593264', '593277', '593282', '593323', '593365', '593365', '593365', '593417', '593425', '593425', '593425',
        '593426', '593427', '593446', '593495', '593509', '593560', '593618', '593619', '593621', '593622', '593623',
        '593624', '593627', '593689', '593692', '593710', '593715', '593776', '593785', '593786', '593794', '593809',
        '593828', '593909', '593910', '593924', '593948', '593949', '593950', '594072', '594072', '594072', '594072',
        '594096', '594097', '594098', '594101', '594107', '594109', '594113', '594115', '594121', '594123', '594142',
        '594179', '594197', '594198', '594199', '594201', '594202', '594208', '594227', '594238', '594245', '594312',
        '594330', '594331', '594332', '594333', '594353', '594354', '594354', '594382', '594402', '594408', '594445',
        '594474', '594514', '594515', '594516', '594517', '594518', '594525', '594544', '594574', '594575', '594590',
        '594603', '594604', '594605', '594606', '594628', '594637', '594643', '594648', '594650', '594651', '594652',
        '594654', '594665', '594671', '594676', '594683', '594684', '594685', '594686', '594687', '594687', '594688',
        '594689', '594690', '594704', '594705', '594706', '594707', '594715', '594716', '594717', '594719', '594720',
        '594721', '594722', '594730', '594733', '594733', '594742', '594743', '594746', '594747', '594748', '594749',
        '594750', '594751', '594752', '594753', '594754', '594756', '594757', '594760', '594761', '594762', '594763',
        '594764', '594765', '594766', '594772', '594790', '594793', '594794', '594795', '594796', '594805', '594811',
        '594814', '594816', '594822', '594852', '594853', '594875', '594886', '594907', '594921', '594926', '594927',
        '594929', '594931', '594932', '594933', '594934', '594936', '594937', '594938', '594939', '594940', '594941',
        '594942', '594965', '594974', '594977', '595049', '595050', '595054', '595059', '595060', '595070', '595213',
        '595217', '595273', '595274', '595283', '595357', '595371', '595406', '595406', '595406', '595468', '595559',
        '595561', '595563', '595591', '595592', '595593', '595602', '595602', '595603', '595604', '595636', '595637',
        '595646', '595647', '595653', '595705', '595706', '595782', '595783', '595805', '595822', '595899', '595904',
        '595919', '595928', '595941', '596068', '596071', '596076', '596079', '596082',
    }


class MedicalSuppliesAndDmeParenteralTherapySupplies(ValueSet):
    VALUE_SET_NAME = 'Medical Supplies and DME - Parenteral Therapy Supplies'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '154459', '156671', '162036', '162036', '164781', '165946', '166070', '172713', '182637', '182637', '190220',
        '190220', '191653', '192472', '216841', '217720', '227025', '229075', '234378', '238359', '238359', '244535',
        '249457', '261560', '263565', '265929', '287126', '297581', '400075', '443883', '443883', '443886', '443887',
        '443888', '443962', '443962', '443962', '443962', '443962', '443962', '443962', '443962', '443962', '443962',
        '443962', '444025', '444025', '444027', '444027', '444027', '444027', '444027', '444027', '447621', '452055',
        '452055', '452055', '452154', '452434', '452511', '464894', '464896', '464897', '464914', '464915', '464926',
        '465822', '467468', '467485', '471526', '471526', '472719', '545026', '545395', '545885', '545934', '547651',
        '548977', '553157', '553157', '553158', '553158', '553158', '553158', '553159', '553172', '553172', '553173',
        '553175', '553176', '553176', '553176', '553176', '553177', '553177', '553214', '553215', '553216', '553216',
        '553233', '553235', '553244', '553245', '553245', '553247', '553284', '553305', '553546', '553547', '553548',
        '553549', '554100', '556811', '556812', '557760', '557761', '557766', '558268', '558660', '560646', '560947',
        '564478', '570472', '570472', '570618', '570669', '570682', '573314', '575526', '575854', '577117', '577154',
        '577461', '577687', '577779', '579853', '579867', '580883', '580912', '582448', '582450', '587209', '587212',
        '587215', '591603',
    }


class MedicalSuppliesAndDmeNeedlesAndSyringes(ValueSet):
    VALUE_SET_NAME = 'Medical Supplies and DME - Needles and Syringes'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '150211', '150690', '150883', '150883', '150985', '151004', '151176', '151176', '151848', '151955', '152083',
        '152088', '153363', '153788', '154348', '154560', '154620', '154925', '154992', '155127', '155334', '155677',
        '156534', '157099', '157438', '158055', '159071', '159071', '159071', '159071', '159071', '159071', '159071',
        '159071', '159071', '159378', '160589', '160606', '160733', '161380', '161380', '162743', '163032', '163032',
        '163209', '163450', '163842', '164217', '164324', '164587', '164928', '164977', '165049', '165115', '165115',
        '165115', '165115', '165115', '165115', '165129', '165616', '165997', '166022', '166065', '166091', '166916',
        '167313', '167508', '167683', '167683', '168305', '168324', '168832', '168964', '168964', '168964', '168964',
        '168964', '168964', '168964', '168964', '168977', '169340', '169543', '169546', '170711', '170882', '170882',
        '170882', '171191', '171418', '172044', '172174', '172306', '172306', '172306', '172306', '172306', '172306',
        '172306', '172306', '172450', '172450', '172450', '172450', '172693', '173098', '173742', '174186', '174592',
        '175539', '176118', '176131', '176274', '177737', '177885', '177991', '178064', '178686', '178780', '179009',
        '180647', '181200', '181437', '181742', '181742', '182584', '182636', '182792', '183165', '183196', '183242',
        '183482', '183656', '183724', '184322', '185036', '185036', '185036', '185036', '185036', '185098', '185176',
        '185428', '185428', '185513', '185911', '186809', '186964', '186964', '187261', '187924', '187924', '188202',
        '188534', '188934', '188934', '189175', '189175', '189175', '189175', '190467', '190647', '191801', '191919',
        '192036', '192584', '192898', '193274', '193449', '193768', '193768', '193768', '193768', '194041', '194145',
        '194145', '194145', '194145', '194388', '195390', '195465', '195581', '195714', '195714', '196359', '196359',
        '196557', '197040', '197793', '197835', '198000', '199754', '200250', '201243', '201336', '201541', '202278',
        '202762', '202935', '203030', '203030', '203030', '203030', '203660', '203938', '204247', '204487', '204538',
        '204664', '205081', '205081', '205107', '205682', '206080', '206342', '206466', '206641', '206750', '206820',
        '207038', '207486', '207486', '207486', '207486', '207486', '207512', '207808', '208032', '208065', '208095',
        '208654', '208885', '208990', '209200', '209692', '209903', '210148', '210273', '210302', '210375', '210385',
        '211028', '212050', '212124', '212454', '212609', '212931', '213588', '214341', '214359', '214584', '214732',
        '214766', '215717', '216183', '216263', '217144', '217472', '217477', '217552', '217657', '217776', '217776',
        '217776', '217776', '218387', '218961', '218961', '218961', '218961', '219463', '219992', '220207', '220207',
        '220653', '220682', '220932', '221101', '221454', '221544', '221778', '222148', '222629', '224063', '224126',
        '224958', '224958', '224958', '224958', '224958', '225002', '225076', '225102', '225102', '225231', '225406',
        '225582', '226013', '226584', '226584', '226870', '226955', '227213', '227229', '227857', '228393', '228430',
        '228941', '229974', '230019', '230357', '230477', '230504', '230794', '230801', '230801', '231260', '231260',
        '231674', '231674', '231674', '231706', '233101', '233134', '233860', '233879', '233882', '234193', '234327',
        '234989', '235227', '235227', '235273', '235523', '235534', '235534', '235534', '236098', '236904', '237433',
        '237563', '238188', '238460', '240073', '240322', '240452', '240910', '240910', '240910', '241069', '241367',
        '241588', '243360', '244088', '244208', '244246', '244246', '244246', '244246', '244424', '245027', '245027',
        '245027', '245027', '245027', '245027', '245461', '246211', '246326', '247118', '247231', '247262', '247400',
        '247436', '247436', '247436', '247639', '247643', '247697', '247848', '247848', '247856', '247860', '247860',
        '247955', '248010', '248151', '249222', '249263', '249391', '250067', '250089', '250139', '250174', '250608',
        '250740', '250740', '250740', '250740', '250740', '251347', '251388', '251494', '251630', '251921', '252396',
        '252557', '252557', '252557', '252557', '252557', '252557', '252557', '252557', '253138', '253406', '253790',
        '253949', '254058', '254058', '254058', '254257', '254592', '255008', '256343', '256390', '256478', '256568',
        '256616', '256754', '258092', '258374', '258374', '258374', '258515', '258692', '258692', '258692', '259274',
        '259274', '259429', '259856', '259856', '260727', '260742', '261424', '261424', '262302', '262506', '262684',
        '262833', '263297', '263509', '263509', '263509', '263910', '264154', '264154', '264971', '265153', '265669',
        '265685', '266611', '266671', '266671', '267459', '267571', '268183', '268183', '268183', '268183', '268183',
        '268183', '268183', '268183', '268270', '268270', '268270', '268270', '268464', '269475', '269527', '270312',
        '270643', '270824', '271626', '271626', '271626', '271626', '271626', '271626', '272160', '272167', '272185',
        '272210', '272321', '272382', '273747', '273887', '274270', '274361', '274371', '274492', '274801', '275975',
        '276563', '276662', '276752', '276948', '277103', '277103', '277103', '277386', '279000', '279585', '279603',
        '279603', '281006', '281220', '281233', '281473', '281479', '281779', '282113', '282174', '282552', '282802',
        '282980', '283044', '284067', '284200', '284232', '284344', '285437', '285483', '287138', '287433', '288115',
        '288744', '288850', '289256', '289363', '289473', '290075', '290194', '291197', '291429', '291930', '292128',
        '292506', '292651', '292661', '293049', '293250', '293346', '294104', '294215', '294219', '294443', '294758',
        '294883', '294883', '294955', '295462', '295870', '296513', '296513', '296513', '296513', '296560', '297794',
        '297794', '298592', '298824', '298992', '299373', '400257', '400696', '400696', '400697', '400699', '400983',
        '400984', '400984', '400985', '400985', '400986', '400986', '400994', '400994', '442897', '442898', '442899',
        '442899', '442900', '442900', '442901', '442903', '442904', '442906', '442908', '442911', '442912', '442914',
        '442916', '442917', '442921', '442922', '442924', '442926', '442927', '442928', '442929', '442931', '442932',
        '442968', '442968', '442968', '442971', '442972', '442973', '442974', '442975', '442976', '442977', '442978',
        '442979', '442980', '442981', '442982', '442982', '442984', '442986', '443829', '443854', '443855', '444037',
        '444037', '444037', '444038', '444038', '444038', '444039', '444039', '444039', '444040', '444040', '444040',
        '444069', '444213', '444213', '444213', '444235', '444235', '444235', '444236', '444236', '444236', '444238',
        '444238', '444238', '444239', '444241', '444241', '444241', '445073', '445075', '445112', '445112', '445119',
        '445119', '445120', '445120', '445121', '445139', '445139', '445140', '445140', '445140', '445140', '445140',
        '445141', '445326', '445328', '445335', '445336', '445337', '445341', '445342', '445344', '445345', '445346',
        '445348', '445350', '445351', '445352', '445353', '445356', '445357', '445359', '445360', '445399', '445546',
        '445546', '445546', '445567', '445570', '445585', '445586', '445587', '445587', '445600', '445600', '445941',
        '445942', '445943', '445943', '445944', '445944', '445944', '446542', '446676', '446676', '446856', '446856',
        '446857', '446857', '446874', '446874', '446896', '446896', '446897', '446897', '446902', '446903', '447352',
        '447353', '448053', '448054', '448055', '448056', '448057', '448058', '448059', '448060', '448061', '448062',
        '449575', '449577', '449578', '449578', '449579', '449579', '449589', '449589', '449590', '449590', '449591',
        '449591', '449593', '449593', '449595', '449595', '449598', '449599', '449600', '449601', '449601', '449602',
        '449602', '449603', '449603', '449604', '449614', '449614', '449615', '449615', '449617', '449619', '449620',
        '449620', '449621', '449651', '449779', '449779', '449780', '449780', '449781', '449975', '449976', '449977',
        '449981', '449981', '449982', '449982', '450680', '450681', '450682', '450683', '450709', '450709', '450710',
        '450710', '450897', '450898', '450899', '452343', '452344', '453672', '453673', '453879', '453880', '453943',
        '453944', '454555', '454556', '465730', '466071', '466183', '466529', '466920', '467116', '467981', '470842',
        '470863', '470864', '470865', '470866', '470867', '470868', '470869', '470870', '470871', '470872', '470873',
        '470876', '470878', '470879', '470880', '470881', '470882', '471028', '471342', '471343', '471346', '471346',
        '471346', '471511', '471924', '471924', '471925', '471925', '471926', '471926', '471927', '471927', '471929',
        '471930', '471930', '472101', '472102', '472957', '472957', '472957', '472957', '472975', '473131', '473227',
        '473663', '473663', '473663', '473664', '473666', '473910', '473911', '473912', '473913', '473914', '473915',
        '473916', '473917', '473919', '473920', '473964', '473964', '473965', '473965', '473966', '473966', '473967',
        '473967', '473968', '473968', '473968', '473968', '473969', '473969', '474007', '474007', '474010', '474010',
        '474011', '474011', '474012', '474012', '474013', '474013', '474013', '474014', '474015', '474015', '474016',
        '474016', '474017', '474017', '474017', '474027', '474028', '474029', '474034', '474035', '474036', '474041',
        '474043', '474044', '474045', '474046', '474084', '474084', '474085', '474086', '474088', '474088', '474088',
        '474089', '474089', '474089', '474090', '474090', '474091', '474091', '474091', '474092', '474092', '474094',
        '474146', '474148', '474149', '474150', '474152', '474153', '474154', '474156', '474157', '474158', '474159',
        '474164', '474177', '474916', '475323', '475323', '475391', '475392', '475393', '476837', '545242', '545274',
        '545337', '545337', '545338', '545340', '545392', '545398', '545417', '545567', '545607', '545607', '545609',
        '545647', '545658', '545659', '545671', '545672', '545688', '546866', '546866', '546867', '546867', '547284',
        '547284', '547284', '550028', '550029', '550030', '550031', '550907', '550908', '550909', '551408', '551430',
        '551472', '551473', '551475', '551476', '551477', '551478', '551479', '551480', '551481', '551482', '551483',
        '551484', '551485', '551486', '551487', '551488', '551489', '551490', '551491', '551492', '551493', '551493',
        '551505', '551513', '551516', '551518', '551523', '551534', '551535', '551539', '551540', '551541', '551541',
        '551542', '551542', '551544', '551545', '551546', '551547', '551548', '551549', '551552', '551567', '551569',
        '551578', '551579', '551580', '551581', '551583', '551584', '551585', '551586', '551587', '551588', '551607',
        '551607', '551613', '551614', '551615', '551616', '551618', '551620', '551621', '551623', '551624', '551625',
        '551632', '551695', '551696', '551697', '551741', '551878', '551879', '551880', '552209', '552216', '552272',
        '552293', '552692', '552692', '552694', '552718', '552785', '552821', '552830', '552836', '552906', '552936',
        '553075', '553332', '553342', '553361', '553571', '553623', '553851', '553861', '553929', '554647', '554691',
        '554711', '554712', '554713', '554714', '554715', '554863', '555990', '556040', '556136', '556137', '556151',
        '556338', '556340', '556592', '556594', '556679', '556896', '556917', '557519', '557522', '557566', '557567',
        '557568', '557571', '557572', '557573', '557574', '557575', '557576', '557615', '557616', '557617', '557621',
        '557622', '557623', '557625', '557631', '557632', '557634', '557635', '557636', '557637', '557640', '557641',
        '557642', '557643', '557644', '557645', '557647', '557648', '557649', '557653', '557654', '557655', '557671',
        '557672', '557674', '557675', '557676', '557677', '557684', '557685', '557686', '557687', '557688', '557695',
        '557696', '557697', '557698', '557701', '557702', '557703', '557933', '557933', '557958', '558310', '558337',
        '558729', '559549', '559557', '560380', '560396', '560443', '560843', '562189', '562636', '562659', '563293',
        '563321', '563459', '563491', '563884', '564086', '565957', '569356', '569358', '570743', '572196', '572296',
        '577417', '577433', '577434', '577435', '577436', '577438', '577439', '577440', '577441', '577445', '577447',
        '577448', '577449', '577450', '577900', '578661', '578839', '579292', '579294', '579295', '579296', '579306',
        '579307', '579308', '579309', '579310', '579311', '579312', '579349', '579350', '579351', '579368', '579369',
        '579370', '581232', '581319', '587358', '587360', '588894', '588899', '588900', '588907', '588931', '588932',
        '588933', '588983', '589000', '589001', '589008', '589013', '589014', '589028', '589029', '589033', '589035',
        '589037', '589079', '589080', '589089', '589100', '589101', '589102', '589110', '589114', '589115', '589123',
        '589124', '589125', '589126', '589127', '589128', '589129', '589148', '589165', '589166', '589168', '589169',
        '589171', '589172', '589173', '589184', '589185', '589203', '589204', '589205', '589206', '589207', '589208',
        '589209', '589210', '589211', '589212', '589213', '589215', '589234', '589235', '589236', '589243', '589245',
        '589246', '589249', '589250', '589251', '589252', '589253', '589254', '589256', '589257', '589258', '589266',
        '589267', '589268', '589269', '589270', '589271', '589272', '589273', '589322', '589323', '589327', '589328',
        '589329', '589335', '589336', '589375', '589385', '589390', '589412', '589413', '589414', '589415', '589416',
        '589417', '589418', '589419', '589420', '589421', '589423', '589424', '589425', '589426', '589427', '589428',
        '589429', '589430', '589431', '589432', '589433', '589440', '589441', '589454', '589457', '589458', '589478',
        '589488', '589610', '589611', '589767', '589768', '589770', '589771', '589776', '589781', '589799', '589800',
        '589801', '589830', '589831', '589832', '589874', '589875', '589879', '589883', '589888', '589909', '589911',
        '589914', '589915', '589927', '589983', '589985', '589986', '589988', '589990', '589991', '590065', '592667',
        '592752', '593076', '593618', '593619', '593621', '593622', '593623', '593624', '593627', '593710', '594208',
        '594227', '594245', '594574', '594590', '594648', '594651', '594652', '594654', '594747', '594814', '594965',
        '595059', '595273', '595274',
    }


class MedicalSuppliesAndDmeIvSetsTubing(ValueSet):
    VALUE_SET_NAME = 'Medical Supplies and DME - IV Sets-Tubing'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '197972', '200225', '204840', '206260', '237803', '269253', '270030', '443128', '443128', '443128', '443230',
        '443501', '445932', '445934', '445935', '445936', '445937', '445938', '445938', '445938', '445940', '445940',
        '451167', '451979', '451979', '451979', '451979', '451999', '452000', '452001', '452003', '452003', '452004',
        '452004', '452468', '452468', '452504', '452505', '452506', '452951', '452953', '465317', '465317', '466289',
        '466290', '466291', '466292', '470938', '470938', '470939', '470939', '473918', '473921', '545352', '553171',
        '553234', '554840', '554947', '556810', '556836', '556837', '556843', '556844', '556845', '556865', '557218',
        '557238', '557510', '557511', '558356', '558365', '558537', '558538', '558539', '558863', '560298', '561109',
        '561110', '561129', '561130', '561462', '562036', '562888', '562889', '562890', '562891', '562892', '562893',
        '562894', '562895', '569296', '570093', '577713', '580765', '589036', '589216', '589873', '589886', '594575',
    }


class MedicalSuppliesAndDmeBloodAdministrationSets(ValueSet):
    VALUE_SET_NAME = 'Medical Supplies and DME - Blood Administration Sets'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '450797', '450797', '556155', '556593', '556593', '556846',
    }


class MedicalSuppliesAndDmeCardiologySupplies(ValueSet):
    VALUE_SET_NAME = 'Medical Supplies and DME - Cardiology Supplies'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MedicalSuppliesAndDmeCardiacCatheters(ValueSet):
    VALUE_SET_NAME = 'Medical Supplies and DME - Cardiac Catheters'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
    }


class MedicalSuppliesAndDmeRespiratoryTherapySupplies(ValueSet):
    VALUE_SET_NAME = 'Medical Supplies and DME - Respiratory Therapy Supplies'
    EXPANSION_VERSION = 'ClassPath Update 18-10-15'
    FDB = {
        '151124', '157736', '159111', '160068', '170689', '179256', '201063', '212360', '217226', '218342', '231992',
        '241798', '248537', '251008', '257651', '257651', '281292', '286602', '288042', '290815', '443286', '443298',
        '443342', '444022', '444022', '444022', '444022', '444022', '444022', '444022', '444022', '444022', '444022',
        '444022', '444022', '444022', '444022', '444022', '444022', '444022', '444023', '444023', '445146', '445146',
        '445147', '445148', '445148', '445148', '445817', '448332', '448333', '449413', '449414', '449509', '449510',
        '449548', '449784', '449785', '449785', '450678', '450678', '450678', '450678', '451385', '451386', '451584',
        '451585', '451586', '453612', '465314', '465946', '466224', '466225', '469542', '472759', '472802', '472811',
        '473188', '473653', '473703', '473820', '473846', '473846', '473847', '473847', '473895', '473895', '473896',
        '473896', '473955', '473956', '473957', '473958', '473958', '473960', '473960', '473961', '473961', '474171',
        '474171', '474171', '474185', '474185', '474186', '474186', '474253', '474254', '474254', '474255', '474255',
        '474256', '474257', '474258', '474259', '474260', '474261', '474262', '474263', '474306', '474306', '474307',
        '474307', '474460', '474461', '474557', '475236', '475832', '476510', '476511', '476512', '476513', '476813',
        '546217', '546218', '546219', '548995', '549406', '549674', '549675', '549875', '550613', '550616', '550738',
        '553530', '555201', '555649', '555729', '555730', '555734', '555735', '555737', '555737', '555739', '556022',
        '556911', '557101', '557233', '557306', '557306', '557306', '557306', '557307', '557307', '557307', '557704',
        '557704', '557819', '558273', '559399', '560866', '560993', '560995', '561187', '561426', '562556', '562556',
        '562556', '563000', '563001', '563134', '563164', '563296', '563327', '563349', '565094', '565121', '565168',
        '566660', '566754', '566755', '566757', '566758', '567932', '567933', '567934', '567935', '568850', '568951',
        '568952', '568953', '569082', '569084', '569885', '575302', '575303', '575835', '576048', '576049', '576386',
        '577336', '578374', '578658', '578659', '578660', '580763', '581341', '581342', '582522', '582553', '582556',
        '583300', '583635', '583636', '583637', '584474', '586752', '587053', '587186', '587205', '588853', '589826',
        '590280', '591434', '591484', '591485', '591486', '591487', '591490', '591668', '591670', '591671', '591672',
        '591741', '591751', '591753', '591881', '591882', '591886', '591896', '592216', '592455', '592605', '593948',
        '593949', '593950', '594142', '594772',
    }


class MedicalSuppliesAndDmeNebulizers(ValueSet):
    VALUE_SET_NAME = 'Medical Suppli