from .....Internal.Core import Core
from .....Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Self:
	"""Self commands group definition. 2 total commands, 2 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("self", core, parent)

	@property
	def enable(self):
		"""enable commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_enable'):
			from .Self_.Enable import Enable
			self._enable = Enable(self._core, self._base)
		return self._enable

	@property
	def addr(self):
		"""addr commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_addr'):
			from .Self_.Addr import Addr
			self._addr = Addr(self._core, self._base)
		return self._addr

	def clone(self) -> 'Self':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Self(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group
