from ....Internal.Core import Core
from ....Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Reference:
	"""Reference commands group definition. 5 total commands, 3 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("reference", core, parent)

	@property
	def frequency(self):
		"""frequency commands group. 1 Sub-classes, 2 commands."""
		if not hasattr(self, '_frequency'):
			from .Reference_.Frequency import Frequency
			self._frequency = Frequency(self._core, self._base)
		return self._frequency

	@property
	def phase(self):
		"""phase commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_phase'):
			from .Reference_.Phase import Phase
			self._phase = Phase(self._core, self._base)
		return self._phase

	@property
	def dc(self):
		"""dc commands group. 1 Sub-classes, 0 commands."""
		if not hasattr(self, '_dc'):
			from .Reference_.Dc import Dc
			self._dc = Dc(self._core, self._base)
		return self._dc

	def clone(self) -> 'Reference':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Reference(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group
