import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * The policy for the receipt filter.
 *
 * @stability stable
 */
export declare enum ReceiptFilterPolicy {
    /**
     * Allow the ip address or range.
     *
     * @stability stable
     */
    ALLOW = "Allow",
    /**
     * Block the ip address or range.
     *
     * @stability stable
     */
    BLOCK = "Block"
}
/**
 * Construction properties for a ReceiptFilter.
 *
 * @stability stable
 */
export interface ReceiptFilterProps {
    /**
     * The name for the receipt filter.
     *
     * @default a CloudFormation generated name
     * @stability stable
     */
    readonly receiptFilterName?: string;
    /**
     * The ip address or range to filter.
     *
     * @default 0.0.0.0/0
     * @stability stable
     */
    readonly ip?: string;
    /**
     * The policy for the filter.
     *
     * @default Block
     * @stability stable
     */
    readonly policy?: ReceiptFilterPolicy;
}
/**
 * A receipt filter.
 *
 * When instantiated without props, it creates a
 * block all receipt filter.
 *
 * @stability stable
 */
export declare class ReceiptFilter extends Resource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ReceiptFilterProps);
}
/**
 * Construction properties for am AllowListReceiptFilter.
 *
 * @stability stable
 */
export interface AllowListReceiptFilterProps {
    /**
     * A list of ip addresses or ranges to allow list.
     *
     * @stability stable
     */
    readonly ips: string[];
}
/**
 * An allow list receipt filter.
 *
 * @stability stable
 */
export declare class AllowListReceiptFilter extends CoreConstruct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: AllowListReceiptFilterProps);
}
/**
 * (deprecated) Construction properties for a WhiteListReceiptFilter.
 *
 * @deprecated use `AllowListReceiptFilterProps`
 */
export interface WhiteListReceiptFilterProps extends AllowListReceiptFilterProps {
}
/**
 * (deprecated) An allow list receipt filter.
 *
 * @deprecated use `AllowListReceiptFilter`
 */
export declare class WhiteListReceiptFilter extends AllowListReceiptFilter {
    /**
     * @deprecated
     */
    constructor(scope: Construct, id: string, props: WhiteListReceiptFilterProps);
}
