"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .paypalshippingoptionsitemamount import (
    PaypalShippingOptionsItemAmount,
    PaypalShippingOptionsItemAmountTypedDict,
)
from gr4vy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Literal, Union
from typing_extensions import Annotated, NotRequired, TypedDict


PaypalShippingOptionsItemType = Union[
    Literal[
        "SHIPPING",
        "PICKUP",
        "PICKUP_IN_STORE",
        "PICKUP_FROM_PERSON",
    ],
    UnrecognizedStr,
]


class PaypalShippingOptionsItemTypedDict(TypedDict):
    id: str
    r"""A unique ID that identifies a payer-selected shipping option."""
    label: str
    r"""A description that the payer sees, which helps them choose an appropriate shipping option."""
    selected: bool
    r"""If the API request sets selected = true, it represents the shipping option that the payee or merchant expects to be pre-selected for the payer when they first view the shipping.options in the PayPal Checkout experience. Only one shipping.option can be set to selected=true."""
    type: NotRequired[Nullable[PaypalShippingOptionsItemType]]
    r"""A classification for the method of purchase fulfillment."""
    amount: NotRequired[Nullable[PaypalShippingOptionsItemAmountTypedDict]]
    r"""The shipping cost for the selected option."""


class PaypalShippingOptionsItem(BaseModel):
    id: str
    r"""A unique ID that identifies a payer-selected shipping option."""

    label: str
    r"""A description that the payer sees, which helps them choose an appropriate shipping option."""

    selected: bool
    r"""If the API request sets selected = true, it represents the shipping option that the payee or merchant expects to be pre-selected for the payer when they first view the shipping.options in the PayPal Checkout experience. Only one shipping.option can be set to selected=true."""

    type: Annotated[
        OptionalNullable[PaypalShippingOptionsItemType],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""A classification for the method of purchase fulfillment."""

    amount: OptionalNullable[PaypalShippingOptionsItemAmount] = UNSET
    r"""The shipping cost for the selected option."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type", "amount"]
        nullable_fields = ["type", "amount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
