"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cartitem import CartItem, CartItemTypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class PaymentOptionRequestTypedDict(TypedDict):
    metadata: NotRequired[Nullable[Dict[str, str]]]
    r"""The metadata to used to evaluate checkout rules, which will help determine the right payment options to display."""
    country: NotRequired[Nullable[str]]
    r"""The country code used to evaluate checkout rules, and which are used to help determine the right payment options to display."""
    currency: NotRequired[Nullable[str]]
    r"""The currency code used to evaluate checkout rules, and which are used to help determine the right payment options to display."""
    amount: NotRequired[Nullable[int]]
    r"""The amount used to evaluate checkout rules, and which are used to help determine the right payment options to display."""
    locale: NotRequired[str]
    r"""The locale used to determine the labels for each payment option."""
    cart_items: NotRequired[Nullable[List[CartItemTypedDict]]]
    r"""The cart items used to evaluate checkout rules, and which are used to help determine the right payment options to display."""


class PaymentOptionRequest(BaseModel):
    metadata: OptionalNullable[Dict[str, str]] = UNSET
    r"""The metadata to used to evaluate checkout rules, which will help determine the right payment options to display."""

    country: OptionalNullable[str] = UNSET
    r"""The country code used to evaluate checkout rules, and which are used to help determine the right payment options to display."""

    currency: OptionalNullable[str] = UNSET
    r"""The currency code used to evaluate checkout rules, and which are used to help determine the right payment options to display."""

    amount: OptionalNullable[int] = UNSET
    r"""The amount used to evaluate checkout rules, and which are used to help determine the right payment options to display."""

    locale: Optional[str] = "en"
    r"""The locale used to determine the labels for each payment option."""

    cart_items: OptionalNullable[List[CartItem]] = UNSET
    r"""The cart items used to evaluate checkout rules, and which are used to help determine the right payment options to display."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "metadata",
            "country",
            "currency",
            "amount",
            "locale",
            "cart_items",
        ]
        nullable_fields = ["metadata", "country", "currency", "amount", "cart_items"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
