"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .googlepayassurancedetails import (
    GooglePayAssuranceDetails,
    GooglePayAssuranceDetailsTypedDict,
)
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Any, Dict, Literal, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


TokenTypedDict = TypeAliasType("TokenTypedDict", Union[str, Dict[str, Any]])
r"""The opaque token as received from the Google Pay JS library. This format may change between JS library versions."""


Token = TypeAliasType("Token", Union[str, Dict[str, Any]])
r"""The opaque token as received from the Google Pay JS library. This format may change between JS library versions."""


class GooglePayPaymentMethodCreateTypedDict(TypedDict):
    r"""Create a Google Pay transaction with a device token."""

    token: TokenTypedDict
    r"""The opaque token as received from the Google Pay JS library. This format may change between JS library versions."""
    buyer_external_identifier: NotRequired[Nullable[str]]
    r"""The external identifier of the buyer to create a payment for."""
    buyer_id: NotRequired[Nullable[str]]
    r"""The ID of the buyer to retrieve billing details for."""
    cardholder_name: NotRequired[Nullable[str]]
    r"""The card holder name associated to the original card for the token."""
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL to redirect a user back to after the complete 3DS in browser."""
    card_suffix: NotRequired[Nullable[str]]
    r"""The last 4 digits of the original card used to generate the token."""
    card_scheme: NotRequired[Nullable[str]]
    r"""The original card scheme for which the token was generated."""
    card_type: NotRequired[Nullable[str]]
    r"""The payment scheme of the card."""
    method: Literal["googlepay"]
    r"""Always `googlepay`"""
    assurance_details: NotRequired[Nullable[GooglePayAssuranceDetailsTypedDict]]
    r"""The assurance details provided by Google Pay"""


class GooglePayPaymentMethodCreate(BaseModel):
    r"""Create a Google Pay transaction with a device token."""

    token: Token
    r"""The opaque token as received from the Google Pay JS library. This format may change between JS library versions."""

    buyer_external_identifier: OptionalNullable[str] = UNSET
    r"""The external identifier of the buyer to create a payment for."""

    buyer_id: OptionalNullable[str] = UNSET
    r"""The ID of the buyer to retrieve billing details for."""

    cardholder_name: OptionalNullable[str] = UNSET
    r"""The card holder name associated to the original card for the token."""

    redirect_url: OptionalNullable[str] = UNSET
    r"""The URL to redirect a user back to after the complete 3DS in browser."""

    card_suffix: OptionalNullable[str] = UNSET
    r"""The last 4 digits of the original card used to generate the token."""

    card_scheme: OptionalNullable[str] = UNSET
    r"""The original card scheme for which the token was generated."""

    card_type: OptionalNullable[str] = UNSET
    r"""The payment scheme of the card."""

    METHOD: Annotated[
        Annotated[Literal["googlepay"], AfterValidator(validate_const("googlepay"))],
        pydantic.Field(alias="method"),
    ] = "googlepay"
    r"""Always `googlepay`"""

    assurance_details: OptionalNullable[GooglePayAssuranceDetails] = UNSET
    r"""The assurance details provided by Google Pay"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "buyer_external_identifier",
            "buyer_id",
            "cardholder_name",
            "redirect_url",
            "card_suffix",
            "card_scheme",
            "card_type",
            "assurance_details",
        ]
        nullable_fields = [
            "buyer_external_identifier",
            "buyer_id",
            "cardholder_name",
            "redirect_url",
            "card_suffix",
            "card_scheme",
            "card_type",
            "assurance_details",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
