"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .airline import Airline, AirlineTypedDict
from .cartitem import CartItem, CartItemTypedDict
from .checkoutsessionpaymentmethod import (
    CheckoutSessionPaymentMethod,
    CheckoutSessionPaymentMethodTypedDict,
)
from .guestbuyer import GuestBuyer, GuestBuyerTypedDict
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Dict, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CheckoutSessionTypedDict(TypedDict):
    id: str
    r"""The ID for the checkout session."""
    expires_at: datetime
    r"""The date and time when this checkout session expires."""
    cart_items: NotRequired[Nullable[List[CartItemTypedDict]]]
    r"""An array of cart items that represents the line items of a transaction."""
    metadata: NotRequired[Nullable[Dict[str, str]]]
    r"""Any additional information about the transaction that you would like to store as key-value pairs. This data is passed to payment service providers that support it."""
    buyer: NotRequired[Nullable[GuestBuyerTypedDict]]
    r"""Provide buyer details for the transaction. No buyer resource will be created on Gr4vy when used."""
    airline: NotRequired[Nullable[AirlineTypedDict]]
    r"""The airline addendum data which describes the airline booking associated with this transaction."""
    amount: NotRequired[Nullable[int]]
    r"""The total amount for this transaction."""
    currency: NotRequired[Nullable[str]]
    r"""The currency code for this transaction."""
    payment_service_id: NotRequired[Nullable[str]]
    r"""The unique identifier of an existing payment service. When provided, the created transaction will be processed by the given payment service and any routing rules will be skipped."""
    type: Literal["checkout-session"]
    r"""Always `checkout-session`"""
    payment_method: NotRequired[Nullable[CheckoutSessionPaymentMethodTypedDict]]
    r"""Information about the payment method stored on the checkout session."""


class CheckoutSession(BaseModel):
    id: str
    r"""The ID for the checkout session."""

    expires_at: datetime
    r"""The date and time when this checkout session expires."""

    cart_items: OptionalNullable[List[CartItem]] = UNSET
    r"""An array of cart items that represents the line items of a transaction."""

    metadata: OptionalNullable[Dict[str, str]] = UNSET
    r"""Any additional information about the transaction that you would like to store as key-value pairs. This data is passed to payment service providers that support it."""

    buyer: OptionalNullable[GuestBuyer] = UNSET
    r"""Provide buyer details for the transaction. No buyer resource will be created on Gr4vy when used."""

    airline: OptionalNullable[Airline] = UNSET
    r"""The airline addendum data which describes the airline booking associated with this transaction."""

    amount: OptionalNullable[int] = UNSET
    r"""The total amount for this transaction."""

    currency: OptionalNullable[str] = UNSET
    r"""The currency code for this transaction."""

    payment_service_id: OptionalNullable[str] = UNSET
    r"""The unique identifier of an existing payment service. When provided, the created transaction will be processed by the given payment service and any routing rules will be skipped."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["checkout-session"]],
            AfterValidator(validate_const("checkout-session")),
        ],
        pydantic.Field(alias="type"),
    ] = "checkout-session"
    r"""Always `checkout-session`"""

    payment_method: OptionalNullable[CheckoutSessionPaymentMethod] = UNSET
    r"""Information about the payment method stored on the checkout session."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "cart_items",
            "metadata",
            "buyer",
            "airline",
            "amount",
            "currency",
            "payment_service_id",
            "type",
            "payment_method",
        ]
        nullable_fields = [
            "cart_items",
            "metadata",
            "buyer",
            "airline",
            "amount",
            "currency",
            "payment_service_id",
            "payment_method",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
