# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fastapi_control']

package_data = \
{'': ['*']}

install_requires = \
['fastapi>=0.77.0,<0.78.0', 'kink>=0.6.3,<0.7.0']

setup_kwargs = {
    'name': 'fastapi-control',
    'version': '0.2.0',
    'description': 'FastAPI utility to implement class-based routing with controllers and dependency injection.',
    'long_description': '# Welcome to FastAPI Control 👋\n\n[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)\n[![made-with-python](https://img.shields.io/badge/Made%20with-Python-1f425f.svg)](https://www.python.org/)\n[![PyPI version fury.io](https://img.shields.io/pypi/v/fastapi-control.svg)](https://pypi.python.org/pypi/fastapi-control)\n[![PyPI pyversions](https://img.shields.io/pypi/pyversions/fastapi-control.svg)](https://pypi.python.org/pypi/fastapi-control)\n[![Last commit](https://img.shields.io/github/last-commit/leynier/fastapi-control.svg?style=flat)](https://github.com/leynier/fastapi-control/commits)\n[![GitHub commit activity](https://img.shields.io/github/commit-activity/m/leynier/fastapi-control)](https://github.com/leynier/fastapi-control/commits)\n[![Github Stars](https://img.shields.io/github/stars/leynier/fastapi-control?style=flat&logo=github)](https://github.com/leynier/fastapi-control/stargazers)\n[![Github Forks](https://img.shields.io/github/forks/leynier/fastapi-control?style=flat&logo=github)](https://github.com/leynier/fastapi-control/network/members)\n[![Github Watchers](https://img.shields.io/github/watchers/leynier/fastapi-control?style=flat&logo=github)](https://github.com/leynier/fastapi-control)\n[![GitHub contributors](https://img.shields.io/github/contributors/leynier/fastapi-control)](https://github.com/leynier/fastapi-control/graphs/contributors)\n\nFastAPI utility to implement class-based routing with controllers and dependency injection.\n\n## Install\n\n```sh\npip install fastapi-control\n```\n\n## Usage\n\n```python\nfrom fastapi import FastAPI\nfrom fastapi_control import (\n    APIController,\n    add_controller,\n    add_controllers,\n    controller,\n    get,\n    inject,\n)\n\n\n# Optionally declares an abstraction\nclass GreeterAbstraction:\n    def greet(self):\n        raise NotImplementedError()\n\n\n# Implement the abstraction and make it available to the injection system\n# using the @inject decorator\n@inject(alias=GreeterAbstraction)\nclass GretterImplementation:\n    def greet(self):\n        return "Hello, world!"\n\n\n# It is also possible to implement without abstraction and make it available\n# to the injection system directly\n@inject()\nclass SpanishGretterImplementation:\n    def greet(self):\n        return "Hola, mundo!"\n\n\n@inject()\nclass NestedGretterImplementation:\n    # When the @inject decorator is used, the arguments of the __init__\n    # method are automatically injected (if the @inject decorator was used\n    # in the argument type declarations)\n    def __init__(self, spanish_gretter: SpanishGretterImplementation) -> None:\n        self.gretter = spanish_gretter\n\n    def greet(self):\n        return self.gretter.greet()\n\n\n# With the @controller decorator and inheriting from APIController, we can\n# declare class-based routing (also called controller) and it has the same\n# parameters as FastAPI\'s APIRouter\n@controller(prefix="/home")\nclass HomeController(APIController):\n    # When the @controller decorator is used, the arguments of the __init__\n    # method are automatically injected (if the @inject decorator was used\n    # in the argument type declarations)\n    def __init__(\n        self,\n        gretter: GreeterAbstraction,\n        spanish_gretter: SpanishGretterImplementation,\n        nested_gretter: NestedGretterImplementation,\n    ) -> None:\n        self.gretter = gretter\n        self.spanish_gretter = spanish_gretter\n        self.nested_gretter = nested_gretter\n\n    # The @get decorator declares the method as a GET endpoint (there are\n    # also @post, @put, @delete, @patch decorators) and the behavior is the\n    # same as the corresponding FastAPI decorators.\n    @get(path="/greet")\n    def get_greet(self):\n        return self.gretter.greet()\n\n    @get(path="/spanish_greet")\n    def get_spanish_greet(self):\n        return self.spanish_gretter.greet()\n\n    @get(path="/nested_greet")\n    def get_nested_greet(self):\n        return self.nested_gretter.greet()\n\n\napi = FastAPI()\n# Finally, it is necessary to add the controllers to the FastAPI instance\nadd_controllers(api)\n\n# If you want to have multiple FastAPI instances with different controllers,\n# you can use the add_controller method to add the desired controllers to\n# the desired FastAPI instance one by one.\nother_api = FastAPI()\nadd_controller(other_api, HomeController)\n```\n\n## Inspirations\n\nThis project is based on and inspired by the [NEXTX](https://github.com/adriangs1996/nextx.repository) and [FastApi-RESTful](https://github.com/yuval9313/FastApi-RESTful) projects.\n\nThe difference with [FastApi-RESTful](https://github.com/yuval9313/FastApi-RESTful) is that **FastAPI Control** implements an automatic dependency injection system independent of [FastAPI](https://fastapi.tiangolo.com).\n\nThe difference with [NEXTX](https://github.com/adriangs1996/nextx.repository) is that **FastAPI Control** only aims to solve the problem of class-based routes and automatic dependency injection, and uses the [kink](https://github.com/kodemore/kink) library for dependency injection which is still under maintenance while [NEXTX](https://github.com/adriangs1996/nextx.repository) uses [python-inject](https://github.com/ivankorobkov/python-inject) which has not been maintained since 2020.\n\nMany thanks to the creators and maintainers of those projects for providing inspiration and guidance for this one.\n\n## Authors\n\n👨🏻\u200d💻 **Leynier Gutiérrez González**\n\n* Website: [leynier.dev](https://leynier.dev)\n* LinkedIn: [@leynier](https://linkedin.com/in/leynier)\n* Github: [@leynier](https://github.com/leynier)\n* Twitter: [@leynier41](https://twitter.com/leynier41)\n\n## 🤝 Contributing\n\nContributions, issues and feature requests are welcome!<br />Feel free to check [issues page](https://github.com/leynier/fastapi-control/issues). You can also take a look at the [contributing guide](CONTRIBUTING.md).\n\n## Show your support\n\nGive a ⭐️ if this project helped you!\n',
    'author': 'Leynier Gutiérrez González',
    'author_email': 'leynier41@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/leynier/fastapi-control',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
