# Generated by Django 3.1.2 on 2020-10-09 22:01

import collections
import uuid

import django.db.migrations.operations.special
import django.db.models.deletion
import django.utils.timezone
import jsonfield.fields
import model_utils.fields
import swapper
from django.db import migrations, models

from ..commands import COMMAND_CHOICES
from . import assign_command_permissions_to_groups


class Migration(migrations.Migration):

    dependencies = [
        ('connection', '0006_name_unique_per_organization'),
        swapper.dependency('config', 'Device'),
    ]

    operations = [
        migrations.CreateModel(
            name='Command',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('in-progress', 'in progress'),
                            ('success', 'success'),
                            ('failed', 'failed'),
                        ],
                        default='in-progress',
                        max_length=12,
                    ),
                ),
                (
                    'type',
                    models.CharField(
                        choices=COMMAND_CHOICES,
                        max_length=16,
                    ),
                ),
                (
                    'input',
                    jsonfield.fields.JSONField(
                        blank=True,
                        dump_kwargs={'indent': 4},
                        load_kwargs={'object_pairs_hook': collections.OrderedDict},
                        null=True,
                    ),
                ),
                ('output', models.TextField(blank=True)),
                (
                    'connection',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=swapper.get_model_name('connection', 'DeviceConnection'),
                    ),
                ),
                (
                    'device',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=swapper.get_model_name('config', 'Device'),
                    ),
                ),
            ],
            options={
                'verbose_name': 'Command',
                'verbose_name_plural': 'Commands',
                'ordering': ('created',),
                'abstract': False,
                'swappable': swapper.swappable_setting('connection', 'Command'),
            },
        ),
        migrations.RunPython(
            code=assign_command_permissions_to_groups,
            reverse_code=django.db.migrations.operations.special.RunPython.noop,
        ),
    ]
