"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const environment_1 = require("../../interface/environment");
const command_step_simulation_1 = require("../command-step-simulation");
class CommandSimulation {
    constructor(commandDocument, props) {
        this.commandDocument = commandDocument;
        this.props = {
            environment: props.environment ?? new environment_1.LoggingEnvironment(),
            simulationPlatform: props.simulationPlatform ?? platform_1.Platform.LINUX,
        };
    }
    start(inputs) {
        const dateString = new Date().toISOString(); // Example 2021-10-08T08:44:02.106Z
        inputs['global:DATE'] = dateString.split('T')[0];
        inputs['global:DATE_TIME'] = dateString.split('.')[0]
            .replace('T', '_') // Example 2021-10-08_08:44:02
            .replace(/:/g, '.');
        const prefix = Math.floor(Math.random() * 999999).toString().padStart(6, '0');
        inputs['automation:EXECUTION_ID'] = prefix + '-1a2b3c-1a2b3c-1a2b3c1a2b3c1a2b3c';
        return new command_step_simulation_1.CommandStepSimulation(this.createChain(this.commandDocument.collectedSteps()), this.props).invoke(inputs);
    }
    /**
     * Chains the steps together in their default orientation (like a linked list).
     * The order of steps can change depending on the properties provided to the steps.
     * @returns the first step of the chain
     */
    createChain(steps) {
        const firstStep = steps[0];
        let previousStep = firstStep;
        steps.slice(1).forEach(s => {
            previousStep.nextStep = s;
            previousStep.allStepsInExecution = steps;
            previousStep = s;
        });
        return firstStep;
    }
}
exports.CommandSimulation = CommandSimulation;
_a = JSII_RTTI_SYMBOL_1;
CommandSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.CommandSimulation", version: "0.0.24" };
//# sourceMappingURL=data:application/json;base64,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