"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteScriptSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation for aws:executeScript
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeScript.html
 */
class ExecuteScriptSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step) {
        super(step);
        this.action = 'aws:executeScript';
        this.executeScriptStep = step;
    }
    /**
     * Runs the simulation. Nests returned object into a "Payload" key to mimic SSM behavior.
     * Switch by language and execute code based on specified language.
     */
    executeStep(inputs) {
        const inputValues = Object.fromEntries(Object.entries(this.executeScriptStep.inputs)
            .map(([k, v]) => [k, v.resolve(inputs)]));
        return this.executeScriptStep.language.simulate(this.executeScriptStep.code, inputValues);
    }
}
exports.ExecuteScriptSimulation = ExecuteScriptSimulation;
_a = JSII_RTTI_SYMBOL_1;
ExecuteScriptSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ExecuteScriptSimulation", version: "0.0.24" };
//# sourceMappingURL=data:application/json;base64,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