import { ExecuteScriptStep } from '../../parent-steps/automation/execute-script-step';
import { AutomationSimulationBase } from './automation-simulation-base';
/**
 * AutomationStep implementation for aws:executeScript
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeScript.html
 */
export declare class ExecuteScriptSimulation extends AutomationSimulationBase {
    readonly action: string;
    readonly executeScriptStep: ExecuteScriptStep;
    constructor(step: ExecuteScriptStep);
    /**
     * Runs the simulation. Nests returned object into a "Payload" key to mimic SSM behavior.
     * Switch by language and execute code based on specified language.
     */
    executeStep(inputs: {
        [name: string]: any;
    }): {
        [name: string]: any;
    };
}
