"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteStackSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const stack_status_1 = require("../../domain/stack-status");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_and_assert_1 = require("../../parent-steps/automation/sub-steps/wait-for-and-assert");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implemenation for aws:deleteStack
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-deletestack.html
 */
class DeleteStackSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:deleteStack';
        this.deleteStackStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        const stackName = this.deleteStackStep.stackNameVariable.resolve(inputs);
        const clientToken = stackName + inputs['automation:EXECUTION_ID'];
        console.log(`DeleteStack: Querying stack id for ${stackName}`);
        const stackId = this.getStackId(stackName);
        console.log(`DeleteStack: StackId for StackName ${stackName} determine ${stackId}`);
        this.deleteStack(stackId, clientToken);
        console.log(`DeleteStack: Initiated deletion of ${stackId}`);
        this.waitForStackDeletion(stackId);
        console.log(`DeleteStack: Stack ${stackName} successfully deleted`);
        return {};
    }
    getStackId(stackName) {
        const apiParams = { StackName: stackName };
        if (this.deleteStackStep.roleArn != undefined) {
            apiParams.RoleARN = this.deleteStackStep.roleArn;
        }
        const describeResponse = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'describeResponse', {
            service: 'CloudFormation',
            pascalCaseApi: 'DescribeStacks',
            apiParams,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    name: 'StackId',
                    selector: '$.Stacks[0].StackId',
                }],
        }), this.props).invoke({});
        if (describeResponse.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Describe stack failed for ${stackName}: ${describeResponse.stackTrace}`);
        }
        return (describeResponse.outputs ?? {})['describeResponse.StackId'];
    }
    deleteStack(stackId, clientToken) {
        const apiParams = { StackName: stackId };
        if (this.deleteStackStep.roleArn != undefined) {
            apiParams.RoleARN = this.deleteStackStep.roleArn;
        }
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'executeDelete', {
            service: 'CloudFormation',
            pascalCaseApi: 'DeleteStack',
            apiParams: {
                RoleARN: this.deleteStackStep.roleArn,
                ClientRequestToken: clientToken,
                StackName: stackId,
            },
            outputs: [],
        }), this.props).invoke({});
        if (result.responseCode != response_code_1.ResponseCode.SUCCESS) {
            throw new Error('Delete stack failed for ' + stackId);
        }
    }
    waitForStackDeletion(stackId) {
        wait_for_and_assert_1.waitForAndAssertStackStatus({
            stackName: stackId,
            waitForStatus: [stack_status_1.StackStatus.DELETE_FAILED, stack_status_1.StackStatus.DELETE_COMPLETE],
            assertStatus: stack_status_1.StackStatus.DELETE_COMPLETE,
        }, this.props);
    }
}
exports.DeleteStackSimulation = DeleteStackSimulation;
_a = JSII_RTTI_SYMBOL_1;
DeleteStackSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.DeleteStackSimulation", version: "0.0.24" };
//# sourceMappingURL=data:application/json;base64,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