import { IAwsInvoker } from '../../interface/aws-invoker';
import { AutomationStepProps } from '../../parent-steps/automation-step';
import { ChangeInstanceStateStep } from '../../parent-steps/automation/change-instance-state-step';
import { AutomationSimulationBase } from './automation-simulation-base';
import { AwsInvocationSimulationProps } from './aws-api-simulation';
/**
 * Properties for ChangeInstanceStateStep
 */
export interface ChangeInstanceStateSimulationProps extends AutomationStepProps {
    /**
       * (Optional) Use this as a hook to inject an alternate IAwsInvoker (for mocking the AWS API call).
       * @default - will perform a real invocation of the JavaScript AWS SDK using ReflectiveAwsInvoker class.
       */
    readonly awsInvoker: IAwsInvoker;
}
/**
 * AutomationStep implemenation for aws:changeInstanceState
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-changestate.html
 */
export declare class ChangeInstanceStateSimulation extends AutomationSimulationBase {
    readonly action: string;
    private changeInstanceStateStep;
    private props;
    constructor(step: ChangeInstanceStateStep, props: AwsInvocationSimulationProps);
    executeStep(inputs: Record<string, any>): Record<string, any>;
    private changeInstanceState;
    private changeInstanceStateToRunning;
    private changeInstanceStateToStopped;
    private changeInstanceStateToTerminated;
    private changeInstanceStateCall;
    private waitForInstanceState;
    private waitForStateRunningAndStatusOk;
    private waitForStateStopped;
    private waitForStateTerminated;
}
