import { AssertAwsResourceStep } from '../../parent-steps/automation/assert-aws-resource-step';
import { AutomationSimulationBase } from './automation-simulation-base';
import { AwsInvocationSimulationProps } from './aws-api-simulation';
/**
 * AutomationStep implementation of aws:assertAwsResourceProperty.
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-assertAwsResourceProperty.html
 */
export declare class AssertAwsResourceSimulation extends AutomationSimulationBase {
    readonly action: string;
    private assertStep;
    private props;
    constructor(step: AssertAwsResourceStep, props: AwsInvocationSimulationProps);
    /**
       * If the value found matches one of the desiredValues, then this function returns. Otherwise it throws.
       * @returns empty object if value matches desiredValues.
       */
    executeStep(inputs: {
        [name: string]: any;
    }): {
        [name: string]: any;
    };
    private matchesSelectedResponse;
    /**
       * Perform lookup in the aws result for the json path in the selector.
       */
    private parseSelectedOrNull;
}
