"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApproveSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation for aws:approve
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-approve.html
 */
class ApproveSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:approve';
        this.approveStep = step;
        this.approveHook = props.approveHook;
    }
    /**
       * May perform a real approval ask based on the params used during instance creation.
       */
    executeStep(inputs) {
        const approvers = this.approveStep.approvers.resolveToStringList(inputs);
        const requiredApprovals = this.approveStep.minRequiredApprovals?.resolveToNumber(inputs) ?? 1;
        console.log('Approve: Requesting approval from approvers');
        const result = this.requestApproval(approvers, requiredApprovals);
        console.log('Approve: Done requesting approvals');
        return result;
    }
    requestApproval(approvers, requiredApprovals) {
        let isApproved = true;
        const decisions = [];
        for (const i of [...Array(requiredApprovals).keys()]) {
            const approval = this.approveHook.ask(approvers[i]);
            isApproved = isApproved && approval;
            decisions.push({
                Approver: approvers[i],
                ApprovalStatus: approval ? 'Approve' : 'Reject',
                ApprovalDecisionTime: this.provideDate(),
            });
        }
        return {
            ApprovalStatus: isApproved ? 'Approved' : 'Rejected',
            ApproverDecisions: decisions,
        };
    }
    /**
       * Override to mock the date the reviewer approved
       */
    provideDate() {
        return new Date();
    }
}
exports.ApproveSimulation = ApproveSimulation;
_a = JSII_RTTI_SYMBOL_1;
ApproveSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ApproveSimulation", version: "0.0.24" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwcm92ZS1zaW11bGF0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3NpbXVsYXRpb24vYXV0b21hdGlvbi9hcHByb3ZlLXNpbXVsYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFFQSw2RUFBd0U7QUE0QnhFOzs7R0FHRztBQUNILE1BQWEsaUJBQWtCLFNBQVEscURBQXdCO0lBSzdELFlBQVksSUFBaUIsRUFBRSxLQUE2QjtRQUMxRCxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7UUFMTCxXQUFNLEdBQUcsYUFBYSxDQUFDO1FBTTlCLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDO1FBQ3hCLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7O1NBRUs7SUFDRSxXQUFXLENBQUMsTUFBMkI7UUFDNUMsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsbUJBQW1CLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDekUsTUFBTSxpQkFBaUIsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLG9CQUFvQixFQUFFLGVBQWUsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFOUYsT0FBTyxDQUFDLEdBQUcsQ0FBQyw2Q0FBNkMsQ0FBQyxDQUFDO1FBQzNELE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUMsU0FBUyxFQUFFLGlCQUFpQixDQUFDLENBQUM7UUFDbEUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDO1FBRWxELE9BQU8sTUFBTSxDQUFDO0lBQ2hCLENBQUM7SUFFTyxlQUFlLENBQUMsU0FBbUIsRUFBRSxpQkFBeUI7UUFDcEUsSUFBSSxVQUFVLEdBQUcsSUFBSSxDQUFDO1FBQ3RCLE1BQU0sU0FBUyxHQUFlLEVBQUUsQ0FBQztRQUNqQyxLQUFLLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQyxFQUFFO1lBQ3BELE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3BELFVBQVUsR0FBRyxVQUFVLElBQUksUUFBUSxDQUFDO1lBQ3BDLFNBQVMsQ0FBQyxJQUFJLENBQUM7Z0JBQ2IsUUFBUSxFQUFFLFNBQVMsQ0FBQyxDQUFDLENBQUM7Z0JBQ3RCLGNBQWMsRUFBRSxRQUFRLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsUUFBUTtnQkFDL0Msb0JBQW9CLEVBQUUsSUFBSSxDQUFDLFdBQVcsRUFBRTthQUN6QyxDQUFDLENBQUM7U0FDSjtRQUVELE9BQU87WUFDTCxjQUFjLEVBQUUsVUFBVSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLFVBQVU7WUFDcEQsaUJBQWlCLEVBQUUsU0FBUztTQUM3QixDQUFDO0lBQ0osQ0FBQztJQUVEOztTQUVLO0lBQ0ssV0FBVztRQUNuQixPQUFPLElBQUksSUFBSSxFQUFFLENBQUM7SUFDcEIsQ0FBQzs7QUFqREgsOENBa0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSUFwcHJvdmVIb29rIH0gZnJvbSAnLi4vLi4vaW50ZXJmYWNlL2FwcHJvdmUtaG9vayc7XG5pbXBvcnQgeyBBcHByb3ZlU3RlcCB9IGZyb20gJy4uLy4uL3BhcmVudC1zdGVwcy9hdXRvbWF0aW9uL2FwcHJvdmUtc3RlcCc7XG5pbXBvcnQgeyBBdXRvbWF0aW9uU2ltdWxhdGlvbkJhc2UgfSBmcm9tICcuL2F1dG9tYXRpb24tc2ltdWxhdGlvbi1iYXNlJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBBcHByb3ZlU3RlcFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEFwcHJvdmVTaW11bGF0aW9uUHJvcHMge1xuICAvKipcbiAgICAgKiAoT3B0aW9uYWwpIEFwcHJvdmUgaG9vayB0byBiZSBjYWxsZWQgdG8gcGF1c2UgdGhlIGV4ZWN1dGlvbi5cbiAgICAgKiBUbyBtb2NrIHRoaXMgaW1wbGVtZW50YXRpb24gZWl0aGVyIGluamVjdCBhbiBpbnN0YW5jZSBvZiBJQXBwcm92ZUhvb2sgb3IgdXNlIHRoZSBwcm92aWRlZCBNb2NrQXBwcm92ZSBjbGFzcy5cbiAgICAgKiBAZGVmYXVsdCBBcHByb3ZlSG9vayBpbnN0YW5jZS4gQXBwcm92ZUhvb2sgbWF5IG5vdCB3b3JrIGluIGV4cG9ydGVkIEpTSUkgbGFuZ3VhZ2VzLiBPdmVycmlkZSBpbnRlcmZhY2UgYXMgbmVlZGVkLlxuICAgICAqL1xuICByZWFkb25seSBhcHByb3ZlSG9vazogSUFwcHJvdmVIb29rO1xufVxuXG50eXBlIE92ZXJhbGxBcHByb3ZhbFN0YXR1cyA9ICdBcHByb3ZlZCcgfCAnUmVqZWN0ZWQnO1xudHlwZSBJbmRpdmlkdWFsQXBwcm92YWxTdGF0dXMgPSAnQXBwcm92ZScgfCAnUmVqZWN0JztcblxuaW50ZXJmYWNlIEFwcHJvdmFsIHtcbiAgQXBwcm92ZXI6IHN0cmluZztcbiAgQXBwcm92YWxTdGF0dXM6IEluZGl2aWR1YWxBcHByb3ZhbFN0YXR1cztcbiAgQXBwcm92YWxEZWNpc2lvblRpbWU6IERhdGU7XG59XG5cbmludGVyZmFjZSBBcHByb3ZlU3RlcE91dHB1dCB7XG4gIEFwcHJvdmFsU3RhdHVzOiBPdmVyYWxsQXBwcm92YWxTdGF0dXM7XG4gIEFwcHJvdmVyRGVjaXNpb25zOiBBcHByb3ZhbFtdO1xufVxuXG4vKipcbiAqIEF1dG9tYXRpb25TdGVwIGltcGxlbWVudGF0aW9uIGZvciBhd3M6YXBwcm92ZVxuICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3N5c3RlbXMtbWFuYWdlci9sYXRlc3QvdXNlcmd1aWRlL2F1dG9tYXRpb24tYWN0aW9uLWFwcHJvdmUuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQXBwcm92ZVNpbXVsYXRpb24gZXh0ZW5kcyBBdXRvbWF0aW9uU2ltdWxhdGlvbkJhc2Uge1xuICByZWFkb25seSBhY3Rpb24gPSAnYXdzOmFwcHJvdmUnO1xuICByZWFkb25seSBhcHByb3ZlSG9vazogSUFwcHJvdmVIb29rO1xuICBwcml2YXRlIGFwcHJvdmVTdGVwOiBBcHByb3ZlU3RlcDtcblxuICBjb25zdHJ1Y3RvcihzdGVwOiBBcHByb3ZlU3RlcCwgcHJvcHM6IEFwcHJvdmVTaW11bGF0aW9uUHJvcHMpIHtcbiAgICBzdXBlcihzdGVwKTtcbiAgICB0aGlzLmFwcHJvdmVTdGVwID0gc3RlcDtcbiAgICB0aGlzLmFwcHJvdmVIb29rID0gcHJvcHMuYXBwcm92ZUhvb2s7XG4gIH1cblxuICAvKipcbiAgICAgKiBNYXkgcGVyZm9ybSBhIHJlYWwgYXBwcm92YWwgYXNrIGJhc2VkIG9uIHRoZSBwYXJhbXMgdXNlZCBkdXJpbmcgaW5zdGFuY2UgY3JlYXRpb24uXG4gICAgICovXG4gIHB1YmxpYyBleGVjdXRlU3RlcChpbnB1dHM6IFJlY29yZDxzdHJpbmcsIGFueT4pOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHtcbiAgICBjb25zdCBhcHByb3ZlcnMgPSB0aGlzLmFwcHJvdmVTdGVwLmFwcHJvdmVycy5yZXNvbHZlVG9TdHJpbmdMaXN0KGlucHV0cyk7XG4gICAgY29uc3QgcmVxdWlyZWRBcHByb3ZhbHMgPSB0aGlzLmFwcHJvdmVTdGVwLm1pblJlcXVpcmVkQXBwcm92YWxzPy5yZXNvbHZlVG9OdW1iZXIoaW5wdXRzKSA/PyAxO1xuXG4gICAgY29uc29sZS5sb2coJ0FwcHJvdmU6IFJlcXVlc3RpbmcgYXBwcm92YWwgZnJvbSBhcHByb3ZlcnMnKTtcbiAgICBjb25zdCByZXN1bHQgPSB0aGlzLnJlcXVlc3RBcHByb3ZhbChhcHByb3ZlcnMsIHJlcXVpcmVkQXBwcm92YWxzKTtcbiAgICBjb25zb2xlLmxvZygnQXBwcm92ZTogRG9uZSByZXF1ZXN0aW5nIGFwcHJvdmFscycpO1xuXG4gICAgcmV0dXJuIHJlc3VsdDtcbiAgfVxuXG4gIHByaXZhdGUgcmVxdWVzdEFwcHJvdmFsKGFwcHJvdmVyczogc3RyaW5nW10sIHJlcXVpcmVkQXBwcm92YWxzOiBudW1iZXIpOiBBcHByb3ZlU3RlcE91dHB1dCB7XG4gICAgbGV0IGlzQXBwcm92ZWQgPSB0cnVlO1xuICAgIGNvbnN0IGRlY2lzaW9uczogQXBwcm92YWxbXSA9IFtdO1xuICAgIGZvciAoY29uc3QgaSBvZiBbLi4uQXJyYXkocmVxdWlyZWRBcHByb3ZhbHMpLmtleXMoKV0pIHtcbiAgICAgIGNvbnN0IGFwcHJvdmFsID0gdGhpcy5hcHByb3ZlSG9vay5hc2soYXBwcm92ZXJzW2ldKTtcbiAgICAgIGlzQXBwcm92ZWQgPSBpc0FwcHJvdmVkICYmIGFwcHJvdmFsO1xuICAgICAgZGVjaXNpb25zLnB1c2goe1xuICAgICAgICBBcHByb3ZlcjogYXBwcm92ZXJzW2ldLFxuICAgICAgICBBcHByb3ZhbFN0YXR1czogYXBwcm92YWwgPyAnQXBwcm92ZScgOiAnUmVqZWN0JyxcbiAgICAgICAgQXBwcm92YWxEZWNpc2lvblRpbWU6IHRoaXMucHJvdmlkZURhdGUoKSxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICBBcHByb3ZhbFN0YXR1czogaXNBcHByb3ZlZCA/ICdBcHByb3ZlZCcgOiAnUmVqZWN0ZWQnLFxuICAgICAgQXBwcm92ZXJEZWNpc2lvbnM6IGRlY2lzaW9ucyxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAgICogT3ZlcnJpZGUgdG8gbW9jayB0aGUgZGF0ZSB0aGUgcmV2aWV3ZXIgYXBwcm92ZWRcbiAgICAgKi9cbiAgcHJvdGVjdGVkIHByb3ZpZGVEYXRlKCk6IERhdGUge1xuICAgIHJldHVybiBuZXcgRGF0ZSgpO1xuICB9XG59XG4iXX0=