"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WaitForResourceStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const assert_aws_resource_step_1 = require("./assert-aws-resource-step");
/**
 * AutomationStep impl for aws:waitForAwsResourceProperty
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-waitForAwsResourceProperty.html
 */
class WaitForResourceStep extends assert_aws_resource_step_1.AssertAwsResourceStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:waitForAwsResourceProperty';
        this.sleepIntervalMillis = props.sleepIntervalMillis ?? 2000;
    }
}
exports.WaitForResourceStep = WaitForResourceStep;
_a = JSII_RTTI_SYMBOL_1;
WaitForResourceStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.WaitForResourceStep", version: "0.0.24" };
//# sourceMappingURL=data:application/json;base64,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