import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { AutomationStep, AutomationStepProps } from '../automation-step';
/**
 * AutomationStep implementation for aws:pause
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-pause.html
 */
export declare class PauseStep extends AutomationStep {
    readonly action: string;
    constructor(scope: Construct, id: string, props: AutomationStepProps);
    /**
     * No outputs emitted from Pause step
     * @returns []
     */
    listOutputs(): Output[];
    /**
     * No inputs required for Pause step
     * @returns []
     */
    listInputs(): string[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
