import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { IStringVariable } from '../../interface/variables/string-variable';
import { AutomationStep, AutomationStepProps } from '../automation-step';
/**
 * Props for ExecuteStateMachine step
 */
export interface ExecuteStateMachineStepProps extends AutomationStepProps {
    /**
     * The Amazon Resource Name (ARN) of the Step Functions state machine.
     */
    readonly stateMachineArn: IStringVariable;
    /**
     * (Optional) The name of the execution.
     */
    readonly executionName?: IStringVariable;
    /**
     * (Optional) A string that contains the JSON input data for the execution.
     */
    readonly input?: IStringVariable;
}
/**
 * AutomationStep implementation of [aws:executeStateMachine](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeStateMachine.html)
 */
export declare class ExecuteStateMachineStep extends AutomationStep {
    readonly action: string;
    readonly stateMachineArn: IStringVariable;
    readonly executionName?: IStringVariable;
    readonly input?: IStringVariable;
    constructor(scope: Construct, id: string, props: ExecuteStateMachineStepProps);
    /**
       * No outputs emitted from Delete Stack step
       * @returns []
       */
    listOutputs(): Output[];
    listInputs(): string[];
    toSsmEntry(): Record<string, any>;
}
