"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteImageStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation for aws:deleteImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-delete.html
 */
class DeleteImageStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:deleteImage';
        this.imageId = props.imageId;
    }
    /**
       * This step has no outputs.
       */
    listOutputs() {
        return [];
    }
    listInputs() {
        const inputs = [
            this.imageId,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        return super.prepareSsmEntry({
            ImageId: this.imageId.print(),
        });
    }
}
exports.DeleteImageStep = DeleteImageStep;
_a = JSII_RTTI_SYMBOL_1;
DeleteImageStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.DeleteImageStep", version: "0.0.24" };
//# sourceMappingURL=data:application/json;base64,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