/**
 * Command steps are not all applicable to all platforms.
 * Each command step declares which Platforms it supports.
 * That allows customers to validate their CommandDocument against a given platform prior to execution.
 */
export declare enum Platform {
    LINUX = "Linux",
    WINDOWS = "Windows",
    MAC_OS = "MacOs"
}
export declare class Platforms {
    static readonly STRING_TO_PLATFORM: {
        [name: string]: Platform;
    };
    /**
       * Converts a string to Platform
       * @param platformString a platform name to return its Platform type
       * @returns a Platform
       * @throws if platofrmString is not supported
       */
    static toPlatform(platformString: string): Platform;
    private constructor();
}
