import { DataTypeEnum } from './data-type';
/**
 * Properties of inputs supported by SSM documents.
 * These are NOT used for declaring step inputs, rather only for document inputs.
 * See https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-doc-syntax.html
 */
export interface InputProps {
    /**
       * (Required) The name of the input by which to be referenced by steps in the document.
       */
    readonly name: string;
    /**
       * (Required) The DataTypeEnum of the input.
       */
    readonly inputType: DataTypeEnum;
    /**
       * (Optional) The description of the input.
       * @default name
       */
    readonly description?: string;
    /**
       * (Optional) Default value to use for this input if not specified when invoking the document.
       * @default undefined
       */
    readonly defaultValue?: any;
    /**
       * (Optional) List of allowed values that this input may be.
       * @default undefined
       */
    readonly allowedValues?: any[];
    /**
       * (Optional) Pattern that this input value must match.
       * @default undefined
       */
    readonly allowedPattern?: string;
    /**
       * (Optional) Minimum number of items that this input value (list) must contain.
       * @default undefined
       */
    readonly minItems?: number;
    /**
       * (Optional) Maximum number of items that this input value (list) must contain.
       * @default undefined
       */
    readonly maxItems?: number;
    /**
     * (Optional) Minimum number of chars that this input value (string) must contain.
     * @default undefined
     */
    readonly minChars?: number;
    /**
     * (Optional) Maximum number of chars that this input value (string) must contain.
     * @default undefined
     */
    readonly maxChars?: number;
}
export declare abstract class Input {
    static ofTypeString(name: string, props?: StringInputProps): Input;
    static ofTypeInteger(name: string, props?: IntegerInputProps): Input;
    static ofTypeBoolean(name: string, props?: BooleanInputProps): Input;
    static ofTypeStringList(name: string, props?: StringListInputProps): Input;
    static ofTypeMapList(name: string, props?: MapListInputProps): Input;
    static ofTypeStringMap(name: string, props?: StringMapInputProps): Input;
    static ofSpecifiedType(type: DataTypeEnum, inputName: string, props: InputProps): Input;
    readonly name: string;
    readonly inputType: DataTypeEnum;
    readonly description?: string;
    readonly defaultValue?: string;
    readonly allowedValues?: string[];
    readonly allowedPattern?: string;
    readonly minItems?: number;
    readonly maxItems?: number;
    readonly minChars?: number;
    readonly maxChars?: number;
    constructor(props: InputProps);
    toSsm(): {
        [name: string]: any;
    };
    validate(value: any): void;
}
export interface StringInputProps {
    /**
     * (Optional) The description of the input.
     * @default name
     */
    readonly description?: string;
    /**
     * (Optional) Default value to use for this input if not specified when invoking the document.
     * @default undefined
     */
    readonly defaultValue?: string;
    /**
     * (Optional) List of allowed values that this input may be.
     * @default undefined
     */
    readonly allowedValues?: string[];
    /**
     * (Optional) Pattern that this input value must match.
     * @default undefined
     */
    readonly allowedPattern?: string;
    /**
     * (Optional) Minimum number of chars that this input value (string) must contain.
     * @default undefined
     */
    readonly minChars?: number;
    /**
     * (Optional) Maximum number of chars that this input value (string) must contain.
     * @default undefined
     */
    readonly maxChars?: number;
}
export interface IntegerInputProps {
    /**
     * (Optional) The description of the input.
     * @default name
     */
    readonly description?: string;
    /**
     * (Optional) Default value to use for this input if not specified when invoking the document.
     * @default undefined
     */
    readonly defaultValue?: number;
    /**
     * (Optional) List of allowed values that this input may be.
     * @default undefined
     */
    readonly allowedValues?: number[];
}
export interface BooleanInputProps {
    /**
     * (Optional) The description of the input.
     * @default name
     */
    readonly description?: string;
    /**
     * (Optional) Default value to use for this input if not specified when invoking the document.
     * @default undefined
     */
    readonly defaultValue?: boolean;
}
export interface StringListInputProps {
    /**
     * (Optional) The description of the input.
     * @default name
     */
    readonly description?: string;
    /**
     * (Optional) Default value to use for this input if not specified when invoking the document.
     * @default undefined
     */
    readonly defaultValue?: any;
    /**
     * (Optional) List of allowed values that this input may be.
     * @default undefined
     */
    readonly allowedValues?: any[];
    /**
     * (Optional) Minimum number of items that this input value (list) must contain.
     * @default undefined
     */
    readonly minItems?: number;
    /**
     * (Optional) Maximum number of items that this input value (list) must contain.
     * @default undefined
     */
    readonly maxItems?: number;
}
export interface MapListInputProps {
    /**
     * (Optional) The description of the input.
     * @default name
     */
    readonly description?: string;
    /**
     * (Optional) Default value to use for this input if not specified when invoking the document.
     * @default undefined
     */
    readonly defaultValue?: any;
    /**
     * (Optional) List of allowed values that this input may be.
     * @default undefined
     */
    readonly allowedValues?: any[];
    /**
     * (Optional) Minimum number of items that this input value (list) must contain.
     * @default undefined
     */
    readonly minItems?: number;
    /**
     * (Optional) Maximum number of items that this input value (list) must contain.
     * @default undefined
     */
    readonly maxItems?: number;
}
export interface StringMapInputProps {
    /**
     * (Optional) The description of the input.
     * @default name
     */
    readonly description?: string;
    /**
     * (Optional) Default value to use for this input if not specified when invoking the document.
     * @default undefined
     */
    readonly defaultValue?: any;
    /**
     * (Optional) List of allowed values that this input may be.
     * @default undefined
     */
    readonly allowedValues?: any[];
    /**
     * (Optional) Minimum number of items that this input value (list) must contain.
     * @default undefined
     */
    readonly minItems?: number;
    /**
     * (Optional) Maximum number of items that this input value (list) must contain.
     * @default undefined
     */
    readonly maxItems?: number;
}
