# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MeasureMetadata(Model):
    """Represents metadata for a measure (or KPI).

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar display_name:
    :vartype display_name: str
    :param name: Gets the unique name of the measure
    :type name: str
    :param description: Gets the description of the measure.
    :type description: str
    :param definition:
    :type definition: ~dynamics.customerinsights.api.models.MeasureDefinition
    :param latest_evaluation:
    :type latest_evaluation: ~dynamics.customerinsights.api.models.Evaluation
    :param output:
    :type output: ~dynamics.customerinsights.api.models.ScalarOutput
    :param evaluation_stats:
    :type evaluation_stats:
     ~dynamics.customerinsights.api.models.EvaluationStats
    :param error_description:
    :type error_description: ~dynamics.customerinsights.api.models.StringInfo
    :param sql_validation_stats:
    :type sql_validation_stats:
     ~dynamics.customerinsights.api.models.SqlValidationStats
    :param evaluation_history: Gets the evaluation history for the measure.
     (not persisted in store)
    :type evaluation_history:
     list[~dynamics.customerinsights.api.models.Evaluation]
    :param output_history: Gets the output history for the measure. (not
     persisted in store)
    :type output_history:
     list[~dynamics.customerinsights.api.models.ScalarOutput]
    :ivar version: Gets the version number of this object.
    :vartype version: long
    :ivar updated_by: Gets the UPN of the user who last updated this record.
    :vartype updated_by: str
    :ivar updated_utc: Gets the time the object was last updated.
    :vartype updated_utc: datetime
    :ivar created_by: Gets the email address of the user who created this
     record.
    :vartype created_by: str
    :ivar created_utc: Gets the time the object was initially created.
    :vartype created_utc: datetime
    :ivar instance_id: Gets the Customer Insights instance id associated with
     this object.
    :vartype instance_id: str
    """

    _validation = {
        'display_name': {'readonly': True},
        'version': {'readonly': True},
        'updated_by': {'readonly': True},
        'updated_utc': {'readonly': True},
        'created_by': {'readonly': True},
        'created_utc': {'readonly': True},
        'instance_id': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'definition': {'key': 'definition', 'type': 'MeasureDefinition'},
        'latest_evaluation': {'key': 'latestEvaluation', 'type': 'Evaluation'},
        'output': {'key': 'output', 'type': 'ScalarOutput'},
        'evaluation_stats': {'key': 'evaluationStats', 'type': 'EvaluationStats'},
        'error_description': {'key': 'errorDescription', 'type': 'StringInfo'},
        'sql_validation_stats': {'key': 'sqlValidationStats', 'type': 'SqlValidationStats'},
        'evaluation_history': {'key': 'evaluationHistory', 'type': '[Evaluation]'},
        'output_history': {'key': 'outputHistory', 'type': '[ScalarOutput]'},
        'version': {'key': 'version', 'type': 'long'},
        'updated_by': {'key': 'updatedBy', 'type': 'str'},
        'updated_utc': {'key': 'updatedUtc', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_utc': {'key': 'createdUtc', 'type': 'iso-8601'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, description: str=None, definition=None, latest_evaluation=None, output=None, evaluation_stats=None, error_description=None, sql_validation_stats=None, evaluation_history=None, output_history=None, **kwargs) -> None:
        super(MeasureMetadata, self).__init__(**kwargs)
        self.display_name = None
        self.name = name
        self.description = description
        self.definition = definition
        self.latest_evaluation = latest_evaluation
        self.output = output
        self.evaluation_stats = evaluation_stats
        self.error_description = error_description
        self.sql_validation_stats = sql_validation_stats
        self.evaluation_history = evaluation_history
        self.output_history = output_history
        self.version = None
        self.updated_by = None
        self.updated_utc = None
        self.created_by = None
        self.created_utc = None
        self.instance_id = None
